; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -mcpu=mips32r6 -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32R6

%struct.MemSize3_Align1 = type { [3 x i8], i8 }
%struct.MemSize3_Align2 = type { [3 x i8], i8 }
%struct.MemSize3_Align4 = type { [3 x i8], i8 }
%struct.MemSize3_Align8 = type { [3 x i8], i8, [4 x i8] }
%struct.MemSize5_Align1 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize5_Align2 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize5_Align4 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize5_Align8 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize6_Align1 = type { [6 x i8], i16 }
%struct.MemSize6_Align2 = type { [6 x i8], i16 }
%struct.MemSize6_Align4 = type { [6 x i8], i16 }
%struct.MemSize6_Align8 = type { [6 x i8], i16 }
%struct.MemSize7_Align1 = type { [7 x i8], i8 }
%struct.MemSize7_Align2 = type { [7 x i8], i8 }
%struct.MemSize7_Align4 = type { [7 x i8], i8 }
%struct.MemSize7_Align8 = type { [7 x i8], i8 }

@double_align1 = common global double 0.000000e+00, align 1
@double_align2 = common global double 0.000000e+00, align 2
@double_align4 = common global double 0.000000e+00, align 4
@double_align8 = common global double 0.000000e+00, align 8
@i64_align1 = common global i64 0, align 1
@i64_align2 = common global i64 0, align 2
@i64_align4 = common global i64 0, align 4
@i64_align8 = common global i64 0, align 8

define void @store3align1(ptr %S, i32 signext %a) {
; MIPS32-LABEL: store3align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sb $5, 0($4)
; MIPS32-NEXT:    srl $1, $5, 8
; MIPS32-NEXT:    sb $1, 1($4)
; MIPS32-NEXT:    srl $1, $5, 16
; MIPS32-NEXT:    sb $1, 2($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store3align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sh $5, 0($4)
; MIPS32R6-NEXT:    srl $1, $5, 16
; MIPS32R6-NEXT:    sb $1, 2($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i32 %a to i24
  store i24 %0, ptr %S, align 1
  ret void
}

define void @store3align2(ptr %S, i32 signext %a) {
; MIPS32-LABEL: store3align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sh $5, 0($4)
; MIPS32-NEXT:    srl $1, $5, 16
; MIPS32-NEXT:    sb $1, 2($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store3align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sh $5, 0($4)
; MIPS32R6-NEXT:    srl $1, $5, 16
; MIPS32R6-NEXT:    sb $1, 2($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i32 %a to i24
  store i24 %0, ptr %S, align 2
  ret void
}

define void @store3align4(ptr %S, i32 signext %a) {
; MIPS32-LABEL: store3align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sh $5, 0($4)
; MIPS32-NEXT:    srl $1, $5, 16
; MIPS32-NEXT:    sb $1, 2($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store3align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sh $5, 0($4)
; MIPS32R6-NEXT:    srl $1, $5, 16
; MIPS32R6-NEXT:    sb $1, 2($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i32 %a to i24
  store i24 %0, ptr %S, align 4
  ret void
}

define void @store3align8(ptr %S, i32 signext %a) {
; MIPS32-LABEL: store3align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sh $5, 0($4)
; MIPS32-NEXT:    srl $1, $5, 16
; MIPS32-NEXT:    sb $1, 2($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store3align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sh $5, 0($4)
; MIPS32R6-NEXT:    srl $1, $5, 16
; MIPS32R6-NEXT:    sb $1, 2($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i32 %a to i24
  store i24 %0, ptr %S, align 8
  ret void
}

define void @store5align1(ptr %S, i64 %a) {
; MIPS32-LABEL: store5align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    swl $6, 3($4)
; MIPS32-NEXT:    swr $6, 0($4)
; MIPS32-NEXT:    sb $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store5align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sb $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i40
  store i40 %0, ptr %S, align 1
  ret void
}

define void @store5align2(ptr %S, i64 %a) {
; MIPS32-LABEL: store5align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    swl $6, 3($4)
; MIPS32-NEXT:    swr $6, 0($4)
; MIPS32-NEXT:    sb $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store5align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sb $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i40
  store i40 %0, ptr %S, align 2
  ret void
}

define void @store5align4(ptr %S, i64 %a) {
; MIPS32-LABEL: store5align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sw $6, 0($4)
; MIPS32-NEXT:    sb $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store5align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sb $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i40
  store i40 %0, ptr %S, align 4
  ret void
}

define void @store5align8(ptr %S, i64 %a) {
; MIPS32-LABEL: store5align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sw $6, 0($4)
; MIPS32-NEXT:    sb $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store5align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sb $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i40
  store i40 %0, ptr %S, align 8
  ret void
}

define void @store6align1(ptr %S, i64 %a) {
; MIPS32-LABEL: store6align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 4
; MIPS32-NEXT:    addu $2, $4, $1
; MIPS32-NEXT:    swl $6, 3($4)
; MIPS32-NEXT:    swr $6, 0($4)
; MIPS32-NEXT:    sb $7, 4($4)
; MIPS32-NEXT:    srl $1, $7, 8
; MIPS32-NEXT:    sb $1, 1($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store6align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i48
  store i48 %0, ptr %S, align 1
  ret void
}

define void @store6align2(ptr %S, i64 %a) {
; MIPS32-LABEL: store6align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    swl $6, 3($4)
; MIPS32-NEXT:    swr $6, 0($4)
; MIPS32-NEXT:    sh $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store6align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i48
  store i48 %0, ptr %S, align 2
  ret void
}

define void @store6align4(ptr %S, i64 %a) {
; MIPS32-LABEL: store6align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sw $6, 0($4)
; MIPS32-NEXT:    sh $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store6align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i48
  store i48 %0, ptr %S, align 4
  ret void
}

define void @store6align8(ptr %S, i64 %a) {
; MIPS32-LABEL: store6align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sw $6, 0($4)
; MIPS32-NEXT:    sh $7, 4($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store6align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i48
  store i48 %0, ptr %S, align 8
  ret void
}

define void @store7align1(ptr %S, i64 %a) {
; MIPS32-LABEL: store7align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 4
; MIPS32-NEXT:    addu $2, $4, $1
; MIPS32-NEXT:    swl $6, 3($4)
; MIPS32-NEXT:    swr $6, 0($4)
; MIPS32-NEXT:    sb $7, 4($4)
; MIPS32-NEXT:    srl $1, $7, 8
; MIPS32-NEXT:    sb $1, 1($2)
; MIPS32-NEXT:    srl $1, $7, 16
; MIPS32-NEXT:    sb $1, 2($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store7align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    ori $1, $zero, 4
; MIPS32R6-NEXT:    addu $2, $4, $1
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    srl $1, $7, 16
; MIPS32R6-NEXT:    sb $1, 2($2)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i56
  store i56 %0, ptr %S, align 1
  ret void
}

define void @store7align2(ptr %S, i64 %a) {
; MIPS32-LABEL: store7align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 4
; MIPS32-NEXT:    addu $2, $4, $1
; MIPS32-NEXT:    swl $6, 3($4)
; MIPS32-NEXT:    swr $6, 0($4)
; MIPS32-NEXT:    sh $7, 4($4)
; MIPS32-NEXT:    srl $1, $7, 16
; MIPS32-NEXT:    sb $1, 2($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store7align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    ori $1, $zero, 4
; MIPS32R6-NEXT:    addu $2, $4, $1
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    srl $1, $7, 16
; MIPS32R6-NEXT:    sb $1, 2($2)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i56
  store i56 %0, ptr %S, align 2
  ret void
}

define void @store7align4(ptr %S, i64 %a) {
; MIPS32-LABEL: store7align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 4
; MIPS32-NEXT:    addu $2, $4, $1
; MIPS32-NEXT:    sw $6, 0($4)
; MIPS32-NEXT:    sh $7, 4($4)
; MIPS32-NEXT:    srl $1, $7, 16
; MIPS32-NEXT:    sb $1, 2($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store7align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    ori $1, $zero, 4
; MIPS32R6-NEXT:    addu $2, $4, $1
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    srl $1, $7, 16
; MIPS32R6-NEXT:    sb $1, 2($2)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i56
  store i56 %0, ptr %S, align 4
  ret void
}

define void @store7align8(ptr %S, i64 %a) {
; MIPS32-LABEL: store7align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 4
; MIPS32-NEXT:    addu $2, $4, $1
; MIPS32-NEXT:    sw $6, 0($4)
; MIPS32-NEXT:    sh $7, 4($4)
; MIPS32-NEXT:    srl $1, $7, 16
; MIPS32-NEXT:    sb $1, 2($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store7align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    ori $1, $zero, 4
; MIPS32R6-NEXT:    addu $2, $4, $1
; MIPS32R6-NEXT:    sw $6, 0($4)
; MIPS32R6-NEXT:    sh $7, 4($4)
; MIPS32R6-NEXT:    srl $1, $7, 16
; MIPS32R6-NEXT:    sb $1, 2($2)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = trunc i64 %a to i56
  store i56 %0, ptr %S, align 8
  ret void
}

define void @store_double_align1(double %a) {
; MIPS32-LABEL: store_double_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align1)
; MIPS32-NEXT:    addiu $2, $1, %lo(double_align1)
; MIPS32-NEXT:    mfc1 $3, $f12
; MIPS32-NEXT:    mfc1 $1, $f13
; MIPS32-NEXT:    swl $3, 3($2)
; MIPS32-NEXT:    swr $3, 0($2)
; MIPS32-NEXT:    swl $1, 7($2)
; MIPS32-NEXT:    swr $1, 4($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_double_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align1)
; MIPS32R6-NEXT:    sdc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store double %a, ptr @double_align1, align 1
  ret void
}

define void @store_double_align2(double %a) {
; MIPS32-LABEL: store_double_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align2)
; MIPS32-NEXT:    addiu $2, $1, %lo(double_align2)
; MIPS32-NEXT:    mfc1 $3, $f12
; MIPS32-NEXT:    mfc1 $1, $f13
; MIPS32-NEXT:    swl $3, 3($2)
; MIPS32-NEXT:    swr $3, 0($2)
; MIPS32-NEXT:    swl $1, 7($2)
; MIPS32-NEXT:    swr $1, 4($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_double_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align2)
; MIPS32R6-NEXT:    sdc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store double %a, ptr @double_align2, align 2
  ret void
}

define void @store_double_align4(double %a) {
; MIPS32-LABEL: store_double_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align4)
; MIPS32-NEXT:    addiu $2, $1, %lo(double_align4)
; MIPS32-NEXT:    mfc1 $3, $f12
; MIPS32-NEXT:    mfc1 $1, $f13
; MIPS32-NEXT:    sw $3, 0($2)
; MIPS32-NEXT:    sw $1, 4($2)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_double_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align4)
; MIPS32R6-NEXT:    sdc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store double %a, ptr @double_align4, align 4
  ret void
}

define void @store_double_align8(double %a) {
; MIPS32-LABEL: store_double_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(double_align8)
; MIPS32-NEXT:    sdc1 $f12, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_double_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align8)
; MIPS32R6-NEXT:    sdc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store double %a, ptr @double_align8, align 8
  ret void
}

define void @store_i64_align1(i64 %a) {
; MIPS32-LABEL: store_i64_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align1)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align1)
; MIPS32-NEXT:    swl $4, 3($1)
; MIPS32-NEXT:    swr $4, 0($1)
; MIPS32-NEXT:    swl $5, 7($1)
; MIPS32-NEXT:    swr $5, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i64_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align1)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    sw $5, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i64 %a, ptr @i64_align1, align 1
  ret void
}

define void @store_i64_align2(i64 signext %a) {
; MIPS32-LABEL: store_i64_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align2)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align2)
; MIPS32-NEXT:    swl $4, 3($1)
; MIPS32-NEXT:    swr $4, 0($1)
; MIPS32-NEXT:    swl $5, 7($1)
; MIPS32-NEXT:    swr $5, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i64_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align2)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    sw $5, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i64 %a, ptr @i64_align2, align 2
  ret void
}

define void @store_i64_align4(i64 %a) {
; MIPS32-LABEL: store_i64_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align4)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align4)
; MIPS32-NEXT:    sw $4, 0($1)
; MIPS32-NEXT:    sw $5, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i64_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align4)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    sw $5, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i64 %a, ptr @i64_align4, align 4
  ret void
}

define void @store_i64_align8(i64 signext %a) {
; MIPS32-LABEL: store_i64_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align8)
; MIPS32-NEXT:    sw $4, 0($1)
; MIPS32-NEXT:    sw $5, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i64_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align8)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    sw $5, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i64 %a, ptr @i64_align8, align 8
  ret void
}
