///////////////////////////////////////////////////////////////////////////////
// Name:        pdfkerning.inc
// Purpose:     Definition of kerning pairs for core fonts
// Author:      Ulrich Telle
// Created:     2009-06-24
// Copyright:   (c) Ulrich Telle
// Licence:     wxWindows licence
///////////////////////////////////////////////////////////////////////////////

/// \file pdfkerning.inc Definition of kerning pairs for core fonts.

static const wxPdfKernPairDesc kpTableHelvetica[] =
{
  { 0x0041, 0x0043, -30 },
  { 0x0041, 0x0106, -30 },
  { 0x0041, 0x010C, -30 },
  { 0x0041, 0x00C7, -30 },
  { 0x0041, 0x0047, -30 },
  { 0x0041, 0x011E, -30 },
  { 0x0041, 0x0122, -30 },
  { 0x0041, 0x004F, -30 },
  { 0x0041, 0x00D3, -30 },
  { 0x0041, 0x00D4, -30 },
  { 0x0041, 0x00D6, -30 },
  { 0x0041, 0x00D2, -30 },
  { 0x0041, 0x0150, -30 },
  { 0x0041, 0x014C, -30 },
  { 0x0041, 0x00D8, -30 },
  { 0x0041, 0x00D5, -30 },
  { 0x0041, 0x0051, -30 },
  { 0x0041, 0x0054, -120 },
  { 0x0041, 0x0164, -120 },
  { 0x0041, 0x0162, -120 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -70 },
  { 0x0041, 0x0057, -50 },
  { 0x0041, 0x0059, -100 },
  { 0x0041, 0x00DD, -100 },
  { 0x0041, 0x0178, -100 },
  { 0x0041, 0x0075, -30 },
  { 0x0041, 0x00FA, -30 },
  { 0x0041, 0x00FB, -30 },
  { 0x0041, 0x00FC, -30 },
  { 0x0041, 0x00F9, -30 },
  { 0x0041, 0x0171, -30 },
  { 0x0041, 0x016B, -30 },
  { 0x0041, 0x0173, -30 },
  { 0x0041, 0x016F, -30 },
  { 0x0041, 0x0076, -40 },
  { 0x0041, 0x0077, -40 },
  { 0x0041, 0x0079, -40 },
  { 0x0041, 0x00FD, -40 },
  { 0x0041, 0x00FF, -40 },
  { 0x00C1, 0x0043, -30 },
  { 0x00C1, 0x0106, -30 },
  { 0x00C1, 0x010C, -30 },
  { 0x00C1, 0x00C7, -30 },
  { 0x00C1, 0x0047, -30 },
  { 0x00C1, 0x011E, -30 },
  { 0x00C1, 0x0122, -30 },
  { 0x00C1, 0x004F, -30 },
  { 0x00C1, 0x00D3, -30 },
  { 0x00C1, 0x00D4, -30 },
  { 0x00C1, 0x00D6, -30 },
  { 0x00C1, 0x00D2, -30 },
  { 0x00C1, 0x0150, -30 },
  { 0x00C1, 0x014C, -30 },
  { 0x00C1, 0x00D8, -30 },
  { 0x00C1, 0x00D5, -30 },
  { 0x00C1, 0x0051, -30 },
  { 0x00C1, 0x0054, -120 },
  { 0x00C1, 0x0164, -120 },
  { 0x00C1, 0x0162, -120 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -70 },
  { 0x00C1, 0x0057, -50 },
  { 0x00C1, 0x0059, -100 },
  { 0x00C1, 0x00DD, -100 },
  { 0x00C1, 0x0178, -100 },
  { 0x00C1, 0x0075, -30 },
  { 0x00C1, 0x00FA, -30 },
  { 0x00C1, 0x00FB, -30 },
  { 0x00C1, 0x00FC, -30 },
  { 0x00C1, 0x00F9, -30 },
  { 0x00C1, 0x0171, -30 },
  { 0x00C1, 0x016B, -30 },
  { 0x00C1, 0x0173, -30 },
  { 0x00C1, 0x016F, -30 },
  { 0x00C1, 0x0076, -40 },
  { 0x00C1, 0x0077, -40 },
  { 0x00C1, 0x0079, -40 },
  { 0x00C1, 0x00FD, -40 },
  { 0x00C1, 0x00FF, -40 },
  { 0x0102, 0x0043, -30 },
  { 0x0102, 0x0106, -30 },
  { 0x0102, 0x010C, -30 },
  { 0x0102, 0x00C7, -30 },
  { 0x0102, 0x0047, -30 },
  { 0x0102, 0x011E, -30 },
  { 0x0102, 0x0122, -30 },
  { 0x0102, 0x004F, -30 },
  { 0x0102, 0x00D3, -30 },
  { 0x0102, 0x00D4, -30 },
  { 0x0102, 0x00D6, -30 },
  { 0x0102, 0x00D2, -30 },
  { 0x0102, 0x0150, -30 },
  { 0x0102, 0x014C, -30 },
  { 0x0102, 0x00D8, -30 },
  { 0x0102, 0x00D5, -30 },
  { 0x0102, 0x0051, -30 },
  { 0x0102, 0x0054, -120 },
  { 0x0102, 0x0164, -120 },
  { 0x0102, 0x0162, -120 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -70 },
  { 0x0102, 0x0057, -50 },
  { 0x0102, 0x0059, -100 },
  { 0x0102, 0x00DD, -100 },
  { 0x0102, 0x0178, -100 },
  { 0x0102, 0x0075, -30 },
  { 0x0102, 0x00FA, -30 },
  { 0x0102, 0x00FB, -30 },
  { 0x0102, 0x00FC, -30 },
  { 0x0102, 0x00F9, -30 },
  { 0x0102, 0x0171, -30 },
  { 0x0102, 0x016B, -30 },
  { 0x0102, 0x0173, -30 },
  { 0x0102, 0x016F, -30 },
  { 0x0102, 0x0076, -40 },
  { 0x0102, 0x0077, -40 },
  { 0x0102, 0x0079, -40 },
  { 0x0102, 0x00FD, -40 },
  { 0x0102, 0x00FF, -40 },
  { 0x00C2, 0x0043, -30 },
  { 0x00C2, 0x0106, -30 },
  { 0x00C2, 0x010C, -30 },
  { 0x00C2, 0x00C7, -30 },
  { 0x00C2, 0x0047, -30 },
  { 0x00C2, 0x011E, -30 },
  { 0x00C2, 0x0122, -30 },
  { 0x00C2, 0x004F, -30 },
  { 0x00C2, 0x00D3, -30 },
  { 0x00C2, 0x00D4, -30 },
  { 0x00C2, 0x00D6, -30 },
  { 0x00C2, 0x00D2, -30 },
  { 0x00C2, 0x0150, -30 },
  { 0x00C2, 0x014C, -30 },
  { 0x00C2, 0x00D8, -30 },
  { 0x00C2, 0x00D5, -30 },
  { 0x00C2, 0x0051, -30 },
  { 0x00C2, 0x0054, -120 },
  { 0x00C2, 0x0164, -120 },
  { 0x00C2, 0x0162, -120 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -70 },
  { 0x00C2, 0x0057, -50 },
  { 0x00C2, 0x0059, -100 },
  { 0x00C2, 0x00DD, -100 },
  { 0x00C2, 0x0178, -100 },
  { 0x00C2, 0x0075, -30 },
  { 0x00C2, 0x00FA, -30 },
  { 0x00C2, 0x00FB, -30 },
  { 0x00C2, 0x00FC, -30 },
  { 0x00C2, 0x00F9, -30 },
  { 0x00C2, 0x0171, -30 },
  { 0x00C2, 0x016B, -30 },
  { 0x00C2, 0x0173, -30 },
  { 0x00C2, 0x016F, -30 },
  { 0x00C2, 0x0076, -40 },
  { 0x00C2, 0x0077, -40 },
  { 0x00C2, 0x0079, -40 },
  { 0x00C2, 0x00FD, -40 },
  { 0x00C2, 0x00FF, -40 },
  { 0x00C4, 0x0043, -30 },
  { 0x00C4, 0x0106, -30 },
  { 0x00C4, 0x010C, -30 },
  { 0x00C4, 0x00C7, -30 },
  { 0x00C4, 0x0047, -30 },
  { 0x00C4, 0x011E, -30 },
  { 0x00C4, 0x0122, -30 },
  { 0x00C4, 0x004F, -30 },
  { 0x00C4, 0x00D3, -30 },
  { 0x00C4, 0x00D4, -30 },
  { 0x00C4, 0x00D6, -30 },
  { 0x00C4, 0x00D2, -30 },
  { 0x00C4, 0x0150, -30 },
  { 0x00C4, 0x014C, -30 },
  { 0x00C4, 0x00D8, -30 },
  { 0x00C4, 0x00D5, -30 },
  { 0x00C4, 0x0051, -30 },
  { 0x00C4, 0x0054, -120 },
  { 0x00C4, 0x0164, -120 },
  { 0x00C4, 0x0162, -120 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -70 },
  { 0x00C4, 0x0057, -50 },
  { 0x00C4, 0x0059, -100 },
  { 0x00C4, 0x00DD, -100 },
  { 0x00C4, 0x0178, -100 },
  { 0x00C4, 0x0075, -30 },
  { 0x00C4, 0x00FA, -30 },
  { 0x00C4, 0x00FB, -30 },
  { 0x00C4, 0x00FC, -30 },
  { 0x00C4, 0x00F9, -30 },
  { 0x00C4, 0x0171, -30 },
  { 0x00C4, 0x016B, -30 },
  { 0x00C4, 0x0173, -30 },
  { 0x00C4, 0x016F, -30 },
  { 0x00C4, 0x0076, -40 },
  { 0x00C4, 0x0077, -40 },
  { 0x00C4, 0x0079, -40 },
  { 0x00C4, 0x00FD, -40 },
  { 0x00C4, 0x00FF, -40 },
  { 0x00C0, 0x0043, -30 },
  { 0x00C0, 0x0106, -30 },
  { 0x00C0, 0x010C, -30 },
  { 0x00C0, 0x00C7, -30 },
  { 0x00C0, 0x0047, -30 },
  { 0x00C0, 0x011E, -30 },
  { 0x00C0, 0x0122, -30 },
  { 0x00C0, 0x004F, -30 },
  { 0x00C0, 0x00D3, -30 },
  { 0x00C0, 0x00D4, -30 },
  { 0x00C0, 0x00D6, -30 },
  { 0x00C0, 0x00D2, -30 },
  { 0x00C0, 0x0150, -30 },
  { 0x00C0, 0x014C, -30 },
  { 0x00C0, 0x00D8, -30 },
  { 0x00C0, 0x00D5, -30 },
  { 0x00C0, 0x0051, -30 },
  { 0x00C0, 0x0054, -120 },
  { 0x00C0, 0x0164, -120 },
  { 0x00C0, 0x0162, -120 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -70 },
  { 0x00C0, 0x0057, -50 },
  { 0x00C0, 0x0059, -100 },
  { 0x00C0, 0x00DD, -100 },
  { 0x00C0, 0x0178, -100 },
  { 0x00C0, 0x0075, -30 },
  { 0x00C0, 0x00FA, -30 },
  { 0x00C0, 0x00FB, -30 },
  { 0x00C0, 0x00FC, -30 },
  { 0x00C0, 0x00F9, -30 },
  { 0x00C0, 0x0171, -30 },
  { 0x00C0, 0x016B, -30 },
  { 0x00C0, 0x0173, -30 },
  { 0x00C0, 0x016F, -30 },
  { 0x00C0, 0x0076, -40 },
  { 0x00C0, 0x0077, -40 },
  { 0x00C0, 0x0079, -40 },
  { 0x00C0, 0x00FD, -40 },
  { 0x00C0, 0x00FF, -40 },
  { 0x0100, 0x0043, -30 },
  { 0x0100, 0x0106, -30 },
  { 0x0100, 0x010C, -30 },
  { 0x0100, 0x00C7, -30 },
  { 0x0100, 0x0047, -30 },
  { 0x0100, 0x011E, -30 },
  { 0x0100, 0x0122, -30 },
  { 0x0100, 0x004F, -30 },
  { 0x0100, 0x00D3, -30 },
  { 0x0100, 0x00D4, -30 },
  { 0x0100, 0x00D6, -30 },
  { 0x0100, 0x00D2, -30 },
  { 0x0100, 0x0150, -30 },
  { 0x0100, 0x014C, -30 },
  { 0x0100, 0x00D8, -30 },
  { 0x0100, 0x00D5, -30 },
  { 0x0100, 0x0051, -30 },
  { 0x0100, 0x0054, -120 },
  { 0x0100, 0x0164, -120 },
  { 0x0100, 0x0162, -120 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -70 },
  { 0x0100, 0x0057, -50 },
  { 0x0100, 0x0059, -100 },
  { 0x0100, 0x00DD, -100 },
  { 0x0100, 0x0178, -100 },
  { 0x0100, 0x0075, -30 },
  { 0x0100, 0x00FA, -30 },
  { 0x0100, 0x00FB, -30 },
  { 0x0100, 0x00FC, -30 },
  { 0x0100, 0x00F9, -30 },
  { 0x0100, 0x0171, -30 },
  { 0x0100, 0x016B, -30 },
  { 0x0100, 0x0173, -30 },
  { 0x0100, 0x016F, -30 },
  { 0x0100, 0x0076, -40 },
  { 0x0100, 0x0077, -40 },
  { 0x0100, 0x0079, -40 },
  { 0x0100, 0x00FD, -40 },
  { 0x0100, 0x00FF, -40 },
  { 0x0104, 0x0043, -30 },
  { 0x0104, 0x0106, -30 },
  { 0x0104, 0x010C, -30 },
  { 0x0104, 0x00C7, -30 },
  { 0x0104, 0x0047, -30 },
  { 0x0104, 0x011E, -30 },
  { 0x0104, 0x0122, -30 },
  { 0x0104, 0x004F, -30 },
  { 0x0104, 0x00D3, -30 },
  { 0x0104, 0x00D4, -30 },
  { 0x0104, 0x00D6, -30 },
  { 0x0104, 0x00D2, -30 },
  { 0x0104, 0x0150, -30 },
  { 0x0104, 0x014C, -30 },
  { 0x0104, 0x00D8, -30 },
  { 0x0104, 0x00D5, -30 },
  { 0x0104, 0x0051, -30 },
  { 0x0104, 0x0054, -120 },
  { 0x0104, 0x0164, -120 },
  { 0x0104, 0x0162, -120 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -70 },
  { 0x0104, 0x0057, -50 },
  { 0x0104, 0x0059, -100 },
  { 0x0104, 0x00DD, -100 },
  { 0x0104, 0x0178, -100 },
  { 0x0104, 0x0075, -30 },
  { 0x0104, 0x00FA, -30 },
  { 0x0104, 0x00FB, -30 },
  { 0x0104, 0x00FC, -30 },
  { 0x0104, 0x00F9, -30 },
  { 0x0104, 0x0171, -30 },
  { 0x0104, 0x016B, -30 },
  { 0x0104, 0x0173, -30 },
  { 0x0104, 0x016F, -30 },
  { 0x0104, 0x0076, -40 },
  { 0x0104, 0x0077, -40 },
  { 0x0104, 0x0079, -40 },
  { 0x0104, 0x00FD, -40 },
  { 0x0104, 0x00FF, -40 },
  { 0x00C5, 0x0043, -30 },
  { 0x00C5, 0x0106, -30 },
  { 0x00C5, 0x010C, -30 },
  { 0x00C5, 0x00C7, -30 },
  { 0x00C5, 0x0047, -30 },
  { 0x00C5, 0x011E, -30 },
  { 0x00C5, 0x0122, -30 },
  { 0x00C5, 0x004F, -30 },
  { 0x00C5, 0x00D3, -30 },
  { 0x00C5, 0x00D4, -30 },
  { 0x00C5, 0x00D6, -30 },
  { 0x00C5, 0x00D2, -30 },
  { 0x00C5, 0x0150, -30 },
  { 0x00C5, 0x014C, -30 },
  { 0x00C5, 0x00D8, -30 },
  { 0x00C5, 0x00D5, -30 },
  { 0x00C5, 0x0051, -30 },
  { 0x00C5, 0x0054, -120 },
  { 0x00C5, 0x0164, -120 },
  { 0x00C5, 0x0162, -120 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -70 },
  { 0x00C5, 0x0057, -50 },
  { 0x00C5, 0x0059, -100 },
  { 0x00C5, 0x00DD, -100 },
  { 0x00C5, 0x0178, -100 },
  { 0x00C5, 0x0075, -30 },
  { 0x00C5, 0x00FA, -30 },
  { 0x00C5, 0x00FB, -30 },
  { 0x00C5, 0x00FC, -30 },
  { 0x00C5, 0x00F9, -30 },
  { 0x00C5, 0x0171, -30 },
  { 0x00C5, 0x016B, -30 },
  { 0x00C5, 0x0173, -30 },
  { 0x00C5, 0x016F, -30 },
  { 0x00C5, 0x0076, -40 },
  { 0x00C5, 0x0077, -40 },
  { 0x00C5, 0x0079, -40 },
  { 0x00C5, 0x00FD, -40 },
  { 0x00C5, 0x00FF, -40 },
  { 0x00C3, 0x0043, -30 },
  { 0x00C3, 0x0106, -30 },
  { 0x00C3, 0x010C, -30 },
  { 0x00C3, 0x00C7, -30 },
  { 0x00C3, 0x0047, -30 },
  { 0x00C3, 0x011E, -30 },
  { 0x00C3, 0x0122, -30 },
  { 0x00C3, 0x004F, -30 },
  { 0x00C3, 0x00D3, -30 },
  { 0x00C3, 0x00D4, -30 },
  { 0x00C3, 0x00D6, -30 },
  { 0x00C3, 0x00D2, -30 },
  { 0x00C3, 0x0150, -30 },
  { 0x00C3, 0x014C, -30 },
  { 0x00C3, 0x00D8, -30 },
  { 0x00C3, 0x00D5, -30 },
  { 0x00C3, 0x0051, -30 },
  { 0x00C3, 0x0054, -120 },
  { 0x00C3, 0x0164, -120 },
  { 0x00C3, 0x0162, -120 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -70 },
  { 0x00C3, 0x0057, -50 },
  { 0x00C3, 0x0059, -100 },
  { 0x00C3, 0x00DD, -100 },
  { 0x00C3, 0x0178, -100 },
  { 0x00C3, 0x0075, -30 },
  { 0x00C3, 0x00FA, -30 },
  { 0x00C3, 0x00FB, -30 },
  { 0x00C3, 0x00FC, -30 },
  { 0x00C3, 0x00F9, -30 },
  { 0x00C3, 0x0171, -30 },
  { 0x00C3, 0x016B, -30 },
  { 0x00C3, 0x0173, -30 },
  { 0x00C3, 0x016F, -30 },
  { 0x00C3, 0x0076, -40 },
  { 0x00C3, 0x0077, -40 },
  { 0x00C3, 0x0079, -40 },
  { 0x00C3, 0x00FD, -40 },
  { 0x00C3, 0x00FF, -40 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0042, 0x002C, -20 },
  { 0x0042, 0x002E, -20 },
  { 0x0043, 0x002C, -30 },
  { 0x0043, 0x002E, -30 },
  { 0x0106, 0x002C, -30 },
  { 0x0106, 0x002E, -30 },
  { 0x010C, 0x002C, -30 },
  { 0x010C, 0x002E, -30 },
  { 0x00C7, 0x002C, -30 },
  { 0x00C7, 0x002E, -30 },
  { 0x0044, 0x0041, -40 },
  { 0x0044, 0x00C1, -40 },
  { 0x0044, 0x0102, -40 },
  { 0x0044, 0x00C2, -40 },
  { 0x0044, 0x00C4, -40 },
  { 0x0044, 0x00C0, -40 },
  { 0x0044, 0x0100, -40 },
  { 0x0044, 0x0104, -40 },
  { 0x0044, 0x00C5, -40 },
  { 0x0044, 0x00C3, -40 },
  { 0x0044, 0x0056, -70 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -90 },
  { 0x0044, 0x00DD, -90 },
  { 0x0044, 0x0178, -90 },
  { 0x0044, 0x002C, -70 },
  { 0x0044, 0x002E, -70 },
  { 0x010E, 0x0041, -40 },
  { 0x010E, 0x00C1, -40 },
  { 0x010E, 0x0102, -40 },
  { 0x010E, 0x00C2, -40 },
  { 0x010E, 0x00C4, -40 },
  { 0x010E, 0x00C0, -40 },
  { 0x010E, 0x0100, -40 },
  { 0x010E, 0x0104, -40 },
  { 0x010E, 0x00C5, -40 },
  { 0x010E, 0x00C3, -40 },
  { 0x010E, 0x0056, -70 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -90 },
  { 0x010E, 0x00DD, -90 },
  { 0x010E, 0x0178, -90 },
  { 0x010E, 0x002C, -70 },
  { 0x010E, 0x002E, -70 },
  { 0x0110, 0x0041, -40 },
  { 0x0110, 0x00C1, -40 },
  { 0x0110, 0x0102, -40 },
  { 0x0110, 0x00C2, -40 },
  { 0x0110, 0x00C4, -40 },
  { 0x0110, 0x00C0, -40 },
  { 0x0110, 0x0100, -40 },
  { 0x0110, 0x0104, -40 },
  { 0x0110, 0x00C5, -40 },
  { 0x0110, 0x00C3, -40 },
  { 0x0110, 0x0056, -70 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -90 },
  { 0x0110, 0x00DD, -90 },
  { 0x0110, 0x0178, -90 },
  { 0x0110, 0x002C, -70 },
  { 0x0110, 0x002E, -70 },
  { 0x0046, 0x0041, -80 },
  { 0x0046, 0x00C1, -80 },
  { 0x0046, 0x0102, -80 },
  { 0x0046, 0x00C2, -80 },
  { 0x0046, 0x00C4, -80 },
  { 0x0046, 0x00C0, -80 },
  { 0x0046, 0x0100, -80 },
  { 0x0046, 0x0104, -80 },
  { 0x0046, 0x00C5, -80 },
  { 0x0046, 0x00C3, -80 },
  { 0x0046, 0x0061, -50 },
  { 0x0046, 0x00E1, -50 },
  { 0x0046, 0x0103, -50 },
  { 0x0046, 0x00E2, -50 },
  { 0x0046, 0x00E4, -50 },
  { 0x0046, 0x00E0, -50 },
  { 0x0046, 0x0101, -50 },
  { 0x0046, 0x0105, -50 },
  { 0x0046, 0x00E5, -50 },
  { 0x0046, 0x00E3, -50 },
  { 0x0046, 0x002C, -150 },
  { 0x0046, 0x0065, -30 },
  { 0x0046, 0x00E9, -30 },
  { 0x0046, 0x011B, -30 },
  { 0x0046, 0x00EA, -30 },
  { 0x0046, 0x00EB, -30 },
  { 0x0046, 0x0117, -30 },
  { 0x0046, 0x00E8, -30 },
  { 0x0046, 0x0113, -30 },
  { 0x0046, 0x0119, -30 },
  { 0x0046, 0x006F, -30 },
  { 0x0046, 0x00F3, -30 },
  { 0x0046, 0x00F4, -30 },
  { 0x0046, 0x00F6, -30 },
  { 0x0046, 0x00F2, -30 },
  { 0x0046, 0x0151, -30 },
  { 0x0046, 0x014D, -30 },
  { 0x0046, 0x00F8, -30 },
  { 0x0046, 0x00F5, -30 },
  { 0x0046, 0x002E, -150 },
  { 0x0046, 0x0072, -45 },
  { 0x0046, 0x0155, -45 },
  { 0x0046, 0x0159, -45 },
  { 0x0046, 0x0157, -45 },
  { 0x004A, 0x0041, -20 },
  { 0x004A, 0x00C1, -20 },
  { 0x004A, 0x0102, -20 },
  { 0x004A, 0x00C2, -20 },
  { 0x004A, 0x00C4, -20 },
  { 0x004A, 0x00C0, -20 },
  { 0x004A, 0x0100, -20 },
  { 0x004A, 0x0104, -20 },
  { 0x004A, 0x00C5, -20 },
  { 0x004A, 0x00C3, -20 },
  { 0x004A, 0x0061, -20 },
  { 0x004A, 0x00E1, -20 },
  { 0x004A, 0x0103, -20 },
  { 0x004A, 0x00E2, -20 },
  { 0x004A, 0x00E4, -20 },
  { 0x004A, 0x00E0, -20 },
  { 0x004A, 0x0101, -20 },
  { 0x004A, 0x0105, -20 },
  { 0x004A, 0x00E5, -20 },
  { 0x004A, 0x00E3, -20 },
  { 0x004A, 0x002C, -30 },
  { 0x004A, 0x002E, -30 },
  { 0x004A, 0x0075, -20 },
  { 0x004A, 0x00FA, -20 },
  { 0x004A, 0x00FB, -20 },
  { 0x004A, 0x00FC, -20 },
  { 0x004A, 0x00F9, -20 },
  { 0x004A, 0x0171, -20 },
  { 0x004A, 0x016B, -20 },
  { 0x004A, 0x0173, -20 },
  { 0x004A, 0x016F, -20 },
  { 0x004B, 0x004F, -50 },
  { 0x004B, 0x00D3, -50 },
  { 0x004B, 0x00D4, -50 },
  { 0x004B, 0x00D6, -50 },
  { 0x004B, 0x00D2, -50 },
  { 0x004B, 0x0150, -50 },
  { 0x004B, 0x014C, -50 },
  { 0x004B, 0x00D8, -50 },
  { 0x004B, 0x00D5, -50 },
  { 0x004B, 0x0065, -40 },
  { 0x004B, 0x00E9, -40 },
  { 0x004B, 0x011B, -40 },
  { 0x004B, 0x00EA, -40 },
  { 0x004B, 0x00EB, -40 },
  { 0x004B, 0x0117, -40 },
  { 0x004B, 0x00E8, -40 },
  { 0x004B, 0x0113, -40 },
  { 0x004B, 0x0119, -40 },
  { 0x004B, 0x006F, -40 },
  { 0x004B, 0x00F3, -40 },
  { 0x004B, 0x00F4, -40 },
  { 0x004B, 0x00F6, -40 },
  { 0x004B, 0x00F2, -40 },
  { 0x004B, 0x0151, -40 },
  { 0x004B, 0x014D, -40 },
  { 0x004B, 0x00F8, -40 },
  { 0x004B, 0x00F5, -40 },
  { 0x004B, 0x0075, -30 },
  { 0x004B, 0x00FA, -30 },
  { 0x004B, 0x00FB, -30 },
  { 0x004B, 0x00FC, -30 },
  { 0x004B, 0x00F9, -30 },
  { 0x004B, 0x0171, -30 },
  { 0x004B, 0x016B, -30 },
  { 0x004B, 0x0173, -30 },
  { 0x004B, 0x016F, -30 },
  { 0x004B, 0x0079, -50 },
  { 0x004B, 0x00FD, -50 },
  { 0x004B, 0x00FF, -50 },
  { 0x0136, 0x004F, -50 },
  { 0x0136, 0x00D3, -50 },
  { 0x0136, 0x00D4, -50 },
  { 0x0136, 0x00D6, -50 },
  { 0x0136, 0x00D2, -50 },
  { 0x0136, 0x0150, -50 },
  { 0x0136, 0x014C, -50 },
  { 0x0136, 0x00D8, -50 },
  { 0x0136, 0x00D5, -50 },
  { 0x0136, 0x0065, -40 },
  { 0x0136, 0x00E9, -40 },
  { 0x0136, 0x011B, -40 },
  { 0x0136, 0x00EA, -40 },
  { 0x0136, 0x00EB, -40 },
  { 0x0136, 0x0117, -40 },
  { 0x0136, 0x00E8, -40 },
  { 0x0136, 0x0113, -40 },
  { 0x0136, 0x0119, -40 },
  { 0x0136, 0x006F, -40 },
  { 0x0136, 0x00F3, -40 },
  { 0x0136, 0x00F4, -40 },
  { 0x0136, 0x00F6, -40 },
  { 0x0136, 0x00F2, -40 },
  { 0x0136, 0x0151, -40 },
  { 0x0136, 0x014D, -40 },
  { 0x0136, 0x00F8, -40 },
  { 0x0136, 0x00F5, -40 },
  { 0x0136, 0x0075, -30 },
  { 0x0136, 0x00FA, -30 },
  { 0x0136, 0x00FB, -30 },
  { 0x0136, 0x00FC, -30 },
  { 0x0136, 0x00F9, -30 },
  { 0x0136, 0x0171, -30 },
  { 0x0136, 0x016B, -30 },
  { 0x0136, 0x0173, -30 },
  { 0x0136, 0x016F, -30 },
  { 0x0136, 0x0079, -50 },
  { 0x0136, 0x00FD, -50 },
  { 0x0136, 0x00FF, -50 },
  { 0x004C, 0x0054, -110 },
  { 0x004C, 0x0164, -110 },
  { 0x004C, 0x0162, -110 },
  { 0x004C, 0x0056, -110 },
  { 0x004C, 0x0057, -70 },
  { 0x004C, 0x0059, -140 },
  { 0x004C, 0x00DD, -140 },
  { 0x004C, 0x0178, -140 },
  { 0x004C, 0x201D, -140 },
  { 0x004C, 0x2019, -160 },
  { 0x004C, 0x0079, -30 },
  { 0x004C, 0x00FD, -30 },
  { 0x004C, 0x00FF, -30 },
  { 0x0139, 0x0054, -110 },
  { 0x0139, 0x0164, -110 },
  { 0x0139, 0x0162, -110 },
  { 0x0139, 0x0056, -110 },
  { 0x0139, 0x0057, -70 },
  { 0x0139, 0x0059, -140 },
  { 0x0139, 0x00DD, -140 },
  { 0x0139, 0x0178, -140 },
  { 0x0139, 0x201D, -140 },
  { 0x0139, 0x2019, -160 },
  { 0x0139, 0x0079, -30 },
  { 0x0139, 0x00FD, -30 },
  { 0x0139, 0x00FF, -30 },
  { 0x013D, 0x0054, -110 },
  { 0x013D, 0x0164, -110 },
  { 0x013D, 0x0162, -110 },
  { 0x013D, 0x0056, -110 },
  { 0x013D, 0x0057, -70 },
  { 0x013D, 0x0059, -140 },
  { 0x013D, 0x00DD, -140 },
  { 0x013D, 0x0178, -140 },
  { 0x013D, 0x201D, -140 },
  { 0x013D, 0x2019, -160 },
  { 0x013D, 0x0079, -30 },
  { 0x013D, 0x00FD, -30 },
  { 0x013D, 0x00FF, -30 },
  { 0x013B, 0x0054, -110 },
  { 0x013B, 0x0164, -110 },
  { 0x013B, 0x0162, -110 },
  { 0x013B, 0x0056, -110 },
  { 0x013B, 0x0057, -70 },
  { 0x013B, 0x0059, -140 },
  { 0x013B, 0x00DD, -140 },
  { 0x013B, 0x0178, -140 },
  { 0x013B, 0x201D, -140 },
  { 0x013B, 0x2019, -160 },
  { 0x013B, 0x0079, -30 },
  { 0x013B, 0x00FD, -30 },
  { 0x013B, 0x00FF, -30 },
  { 0x0141, 0x0054, -110 },
  { 0x0141, 0x0164, -110 },
  { 0x0141, 0x0162, -110 },
  { 0x0141, 0x0056, -110 },
  { 0x0141, 0x0057, -70 },
  { 0x0141, 0x0059, -140 },
  { 0x0141, 0x00DD, -140 },
  { 0x0141, 0x0178, -140 },
  { 0x0141, 0x201D, -140 },
  { 0x0141, 0x2019, -160 },
  { 0x0141, 0x0079, -30 },
  { 0x0141, 0x00FD, -30 },
  { 0x0141, 0x00FF, -30 },
  { 0x004F, 0x0041, -20 },
  { 0x004F, 0x00C1, -20 },
  { 0x004F, 0x0102, -20 },
  { 0x004F, 0x00C2, -20 },
  { 0x004F, 0x00C4, -20 },
  { 0x004F, 0x00C0, -20 },
  { 0x004F, 0x0100, -20 },
  { 0x004F, 0x0104, -20 },
  { 0x004F, 0x00C5, -20 },
  { 0x004F, 0x00C3, -20 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -30 },
  { 0x004F, 0x0058, -60 },
  { 0x004F, 0x0059, -70 },
  { 0x004F, 0x00DD, -70 },
  { 0x004F, 0x0178, -70 },
  { 0x004F, 0x002C, -40 },
  { 0x004F, 0x002E, -40 },
  { 0x00D3, 0x0041, -20 },
  { 0x00D3, 0x00C1, -20 },
  { 0x00D3, 0x0102, -20 },
  { 0x00D3, 0x00C2, -20 },
  { 0x00D3, 0x00C4, -20 },
  { 0x00D3, 0x00C0, -20 },
  { 0x00D3, 0x0100, -20 },
  { 0x00D3, 0x0104, -20 },
  { 0x00D3, 0x00C5, -20 },
  { 0x00D3, 0x00C3, -20 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -30 },
  { 0x00D3, 0x0058, -60 },
  { 0x00D3, 0x0059, -70 },
  { 0x00D3, 0x00DD, -70 },
  { 0x00D3, 0x0178, -70 },
  { 0x00D3, 0x002C, -40 },
  { 0x00D3, 0x002E, -40 },
  { 0x00D4, 0x0041, -20 },
  { 0x00D4, 0x00C1, -20 },
  { 0x00D4, 0x0102, -20 },
  { 0x00D4, 0x00C2, -20 },
  { 0x00D4, 0x00C4, -20 },
  { 0x00D4, 0x00C0, -20 },
  { 0x00D4, 0x0100, -20 },
  { 0x00D4, 0x0104, -20 },
  { 0x00D4, 0x00C5, -20 },
  { 0x00D4, 0x00C3, -20 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -30 },
  { 0x00D4, 0x0058, -60 },
  { 0x00D4, 0x0059, -70 },
  { 0x00D4, 0x00DD, -70 },
  { 0x00D4, 0x0178, -70 },
  { 0x00D4, 0x002C, -40 },
  { 0x00D4, 0x002E, -40 },
  { 0x00D6, 0x0041, -20 },
  { 0x00D6, 0x00C1, -20 },
  { 0x00D6, 0x0102, -20 },
  { 0x00D6, 0x00C2, -20 },
  { 0x00D6, 0x00C4, -20 },
  { 0x00D6, 0x00C0, -20 },
  { 0x00D6, 0x0100, -20 },
  { 0x00D6, 0x0104, -20 },
  { 0x00D6, 0x00C5, -20 },
  { 0x00D6, 0x00C3, -20 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -30 },
  { 0x00D6, 0x0058, -60 },
  { 0x00D6, 0x0059, -70 },
  { 0x00D6, 0x00DD, -70 },
  { 0x00D6, 0x0178, -70 },
  { 0x00D6, 0x002C, -40 },
  { 0x00D6, 0x002E, -40 },
  { 0x00D2, 0x0041, -20 },
  { 0x00D2, 0x00C1, -20 },
  { 0x00D2, 0x0102, -20 },
  { 0x00D2, 0x00C2, -20 },
  { 0x00D2, 0x00C4, -20 },
  { 0x00D2, 0x00C0, -20 },
  { 0x00D2, 0x0100, -20 },
  { 0x00D2, 0x0104, -20 },
  { 0x00D2, 0x00C5, -20 },
  { 0x00D2, 0x00C3, -20 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -30 },
  { 0x00D2, 0x0058, -60 },
  { 0x00D2, 0x0059, -70 },
  { 0x00D2, 0x00DD, -70 },
  { 0x00D2, 0x0178, -70 },
  { 0x00D2, 0x002C, -40 },
  { 0x00D2, 0x002E, -40 },
  { 0x0150, 0x0041, -20 },
  { 0x0150, 0x00C1, -20 },
  { 0x0150, 0x0102, -20 },
  { 0x0150, 0x00C2, -20 },
  { 0x0150, 0x00C4, -20 },
  { 0x0150, 0x00C0, -20 },
  { 0x0150, 0x0100, -20 },
  { 0x0150, 0x0104, -20 },
  { 0x0150, 0x00C5, -20 },
  { 0x0150, 0x00C3, -20 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -30 },
  { 0x0150, 0x0058, -60 },
  { 0x0150, 0x0059, -70 },
  { 0x0150, 0x00DD, -70 },
  { 0x0150, 0x0178, -70 },
  { 0x0150, 0x002C, -40 },
  { 0x0150, 0x002E, -40 },
  { 0x014C, 0x0041, -20 },
  { 0x014C, 0x00C1, -20 },
  { 0x014C, 0x0102, -20 },
  { 0x014C, 0x00C2, -20 },
  { 0x014C, 0x00C4, -20 },
  { 0x014C, 0x00C0, -20 },
  { 0x014C, 0x0100, -20 },
  { 0x014C, 0x0104, -20 },
  { 0x014C, 0x00C5, -20 },
  { 0x014C, 0x00C3, -20 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -30 },
  { 0x014C, 0x0058, -60 },
  { 0x014C, 0x0059, -70 },
  { 0x014C, 0x00DD, -70 },
  { 0x014C, 0x0178, -70 },
  { 0x014C, 0x002C, -40 },
  { 0x014C, 0x002E, -40 },
  { 0x00D8, 0x0041, -20 },
  { 0x00D8, 0x00C1, -20 },
  { 0x00D8, 0x0102, -20 },
  { 0x00D8, 0x00C2, -20 },
  { 0x00D8, 0x00C4, -20 },
  { 0x00D8, 0x00C0, -20 },
  { 0x00D8, 0x0100, -20 },
  { 0x00D8, 0x0104, -20 },
  { 0x00D8, 0x00C5, -20 },
  { 0x00D8, 0x00C3, -20 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -30 },
  { 0x00D8, 0x0058, -60 },
  { 0x00D8, 0x0059, -70 },
  { 0x00D8, 0x00DD, -70 },
  { 0x00D8, 0x0178, -70 },
  { 0x00D8, 0x002C, -40 },
  { 0x00D8, 0x002E, -40 },
  { 0x00D5, 0x0041, -20 },
  { 0x00D5, 0x00C1, -20 },
  { 0x00D5, 0x0102, -20 },
  { 0x00D5, 0x00C2, -20 },
  { 0x00D5, 0x00C4, -20 },
  { 0x00D5, 0x00C0, -20 },
  { 0x00D5, 0x0100, -20 },
  { 0x00D5, 0x0104, -20 },
  { 0x00D5, 0x00C5, -20 },
  { 0x00D5, 0x00C3, -20 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -30 },
  { 0x00D5, 0x0058, -60 },
  { 0x00D5, 0x0059, -70 },
  { 0x00D5, 0x00DD, -70 },
  { 0x00D5, 0x0178, -70 },
  { 0x00D5, 0x002C, -40 },
  { 0x00D5, 0x002E, -40 },
  { 0x0050, 0x0041, -120 },
  { 0x0050, 0x00C1, -120 },
  { 0x0050, 0x0102, -120 },
  { 0x0050, 0x00C2, -120 },
  { 0x0050, 0x00C4, -120 },
  { 0x0050, 0x00C0, -120 },
  { 0x0050, 0x0100, -120 },
  { 0x0050, 0x0104, -120 },
  { 0x0050, 0x00C5, -120 },
  { 0x0050, 0x00C3, -120 },
  { 0x0050, 0x0061, -40 },
  { 0x0050, 0x00E1, -40 },
  { 0x0050, 0x0103, -40 },
  { 0x0050, 0x00E2, -40 },
  { 0x0050, 0x00E4, -40 },
  { 0x0050, 0x00E0, -40 },
  { 0x0050, 0x0101, -40 },
  { 0x0050, 0x0105, -40 },
  { 0x0050, 0x00E5, -40 },
  { 0x0050, 0x00E3, -40 },
  { 0x0050, 0x002C, -180 },
  { 0x0050, 0x0065, -50 },
  { 0x0050, 0x00E9, -50 },
  { 0x0050, 0x011B, -50 },
  { 0x0050, 0x00EA, -50 },
  { 0x0050, 0x00EB, -50 },
  { 0x0050, 0x0117, -50 },
  { 0x0050, 0x00E8, -50 },
  { 0x0050, 0x0113, -50 },
  { 0x0050, 0x0119, -50 },
  { 0x0050, 0x006F, -50 },
  { 0x0050, 0x00F3, -50 },
  { 0x0050, 0x00F4, -50 },
  { 0x0050, 0x00F6, -50 },
  { 0x0050, 0x00F2, -50 },
  { 0x0050, 0x0151, -50 },
  { 0x0050, 0x014D, -50 },
  { 0x0050, 0x00F8, -50 },
  { 0x0050, 0x00F5, -50 },
  { 0x0050, 0x002E, -180 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0052, 0x004F, -20 },
  { 0x0052, 0x00D3, -20 },
  { 0x0052, 0x00D4, -20 },
  { 0x0052, 0x00D6, -20 },
  { 0x0052, 0x00D2, -20 },
  { 0x0052, 0x0150, -20 },
  { 0x0052, 0x014C, -20 },
  { 0x0052, 0x00D8, -20 },
  { 0x0052, 0x00D5, -20 },
  { 0x0052, 0x0054, -30 },
  { 0x0052, 0x0164, -30 },
  { 0x0052, 0x0162, -30 },
  { 0x0052, 0x0055, -40 },
  { 0x0052, 0x00DA, -40 },
  { 0x0052, 0x00DB, -40 },
  { 0x0052, 0x00DC, -40 },
  { 0x0052, 0x00D9, -40 },
  { 0x0052, 0x0170, -40 },
  { 0x0052, 0x016A, -40 },
  { 0x0052, 0x0172, -40 },
  { 0x0052, 0x016E, -40 },
  { 0x0052, 0x0056, -50 },
  { 0x0052, 0x0057, -30 },
  { 0x0052, 0x0059, -50 },
  { 0x0052, 0x00DD, -50 },
  { 0x0052, 0x0178, -50 },
  { 0x0154, 0x004F, -20 },
  { 0x0154, 0x00D3, -20 },
  { 0x0154, 0x00D4, -20 },
  { 0x0154, 0x00D6, -20 },
  { 0x0154, 0x00D2, -20 },
  { 0x0154, 0x0150, -20 },
  { 0x0154, 0x014C, -20 },
  { 0x0154, 0x00D8, -20 },
  { 0x0154, 0x00D5, -20 },
  { 0x0154, 0x0054, -30 },
  { 0x0154, 0x0164, -30 },
  { 0x0154, 0x0162, -30 },
  { 0x0154, 0x0055, -40 },
  { 0x0154, 0x00DA, -40 },
  { 0x0154, 0x00DB, -40 },
  { 0x0154, 0x00DC, -40 },
  { 0x0154, 0x00D9, -40 },
  { 0x0154, 0x0170, -40 },
  { 0x0154, 0x016A, -40 },
  { 0x0154, 0x0172, -40 },
  { 0x0154, 0x016E, -40 },
  { 0x0154, 0x0056, -50 },
  { 0x0154, 0x0057, -30 },
  { 0x0154, 0x0059, -50 },
  { 0x0154, 0x00DD, -50 },
  { 0x0154, 0x0178, -50 },
  { 0x0158, 0x004F, -20 },
  { 0x0158, 0x00D3, -20 },
  { 0x0158, 0x00D4, -20 },
  { 0x0158, 0x00D6, -20 },
  { 0x0158, 0x00D2, -20 },
  { 0x0158, 0x0150, -20 },
  { 0x0158, 0x014C, -20 },
  { 0x0158, 0x00D8, -20 },
  { 0x0158, 0x00D5, -20 },
  { 0x0158, 0x0054, -30 },
  { 0x0158, 0x0164, -30 },
  { 0x0158, 0x0162, -30 },
  { 0x0158, 0x0055, -40 },
  { 0x0158, 0x00DA, -40 },
  { 0x0158, 0x00DB, -40 },
  { 0x0158, 0x00DC, -40 },
  { 0x0158, 0x00D9, -40 },
  { 0x0158, 0x0170, -40 },
  { 0x0158, 0x016A, -40 },
  { 0x0158, 0x0172, -40 },
  { 0x0158, 0x016E, -40 },
  { 0x0158, 0x0056, -50 },
  { 0x0158, 0x0057, -30 },
  { 0x0158, 0x0059, -50 },
  { 0x0158, 0x00DD, -50 },
  { 0x0158, 0x0178, -50 },
  { 0x0156, 0x004F, -20 },
  { 0x0156, 0x00D3, -20 },
  { 0x0156, 0x00D4, -20 },
  { 0x0156, 0x00D6, -20 },
  { 0x0156, 0x00D2, -20 },
  { 0x0156, 0x0150, -20 },
  { 0x0156, 0x014C, -20 },
  { 0x0156, 0x00D8, -20 },
  { 0x0156, 0x00D5, -20 },
  { 0x0156, 0x0054, -30 },
  { 0x0156, 0x0164, -30 },
  { 0x0156, 0x0162, -30 },
  { 0x0156, 0x0055, -40 },
  { 0x0156, 0x00DA, -40 },
  { 0x0156, 0x00DB, -40 },
  { 0x0156, 0x00DC, -40 },
  { 0x0156, 0x00D9, -40 },
  { 0x0156, 0x0170, -40 },
  { 0x0156, 0x016A, -40 },
  { 0x0156, 0x0172, -40 },
  { 0x0156, 0x016E, -40 },
  { 0x0156, 0x0056, -50 },
  { 0x0156, 0x0057, -30 },
  { 0x0156, 0x0059, -50 },
  { 0x0156, 0x00DD, -50 },
  { 0x0156, 0x0178, -50 },
  { 0x0053, 0x002C, -20 },
  { 0x0053, 0x002E, -20 },
  { 0x015A, 0x002C, -20 },
  { 0x015A, 0x002E, -20 },
  { 0x0160, 0x002C, -20 },
  { 0x0160, 0x002E, -20 },
  { 0x015E, 0x002C, -20 },
  { 0x015E, 0x002E, -20 },
  { 0x0218, 0x002C, -20 },
  { 0x0218, 0x002E, -20 },
  { 0x0054, 0x0041, -120 },
  { 0x0054, 0x00C1, -120 },
  { 0x0054, 0x0102, -120 },
  { 0x0054, 0x00C2, -120 },
  { 0x0054, 0x00C4, -120 },
  { 0x0054, 0x00C0, -120 },
  { 0x0054, 0x0100, -120 },
  { 0x0054, 0x0104, -120 },
  { 0x0054, 0x00C5, -120 },
  { 0x0054, 0x00C3, -120 },
  { 0x0054, 0x004F, -40 },
  { 0x0054, 0x00D3, -40 },
  { 0x0054, 0x00D4, -40 },
  { 0x0054, 0x00D6, -40 },
  { 0x0054, 0x00D2, -40 },
  { 0x0054, 0x0150, -40 },
  { 0x0054, 0x014C, -40 },
  { 0x0054, 0x00D8, -40 },
  { 0x0054, 0x00D5, -40 },
  { 0x0054, 0x0061, -120 },
  { 0x0054, 0x00E1, -120 },
  { 0x0054, 0x0103, -60 },
  { 0x0054, 0x00E2, -120 },
  { 0x0054, 0x00E4, -120 },
  { 0x0054, 0x00E0, -120 },
  { 0x0054, 0x0101, -60 },
  { 0x0054, 0x0105, -120 },
  { 0x0054, 0x00E5, -120 },
  { 0x0054, 0x00E3, -60 },
  { 0x0054, 0x003A, -20 },
  { 0x0054, 0x002C, -120 },
  { 0x0054, 0x0065, -120 },
  { 0x0054, 0x00E9, -120 },
  { 0x0054, 0x011B, -120 },
  { 0x0054, 0x00EA, -120 },
  { 0x0054, 0x00EB, -120 },
  { 0x0054, 0x0117, -120 },
  { 0x0054, 0x00E8, -60 },
  { 0x0054, 0x0113, -60 },
  { 0x0054, 0x0119, -120 },
  { 0x0054, 0x002D, -140 },
  { 0x0054, 0x006F, -120 },
  { 0x0054, 0x00F3, -120 },
  { 0x0054, 0x00F4, -120 },
  { 0x0054, 0x00F6, -120 },
  { 0x0054, 0x00F2, -120 },
  { 0x0054, 0x0151, -120 },
  { 0x0054, 0x014D, -60 },
  { 0x0054, 0x00F8, -120 },
  { 0x0054, 0x00F5, -60 },
  { 0x0054, 0x002E, -120 },
  { 0x0054, 0x0072, -120 },
  { 0x0054, 0x0155, -120 },
  { 0x0054, 0x0159, -120 },
  { 0x0054, 0x0157, -120 },
  { 0x0054, 0x003B, -20 },
  { 0x0054, 0x0075, -120 },
  { 0x0054, 0x00FA, -120 },
  { 0x0054, 0x00FB, -120 },
  { 0x0054, 0x00FC, -120 },
  { 0x0054, 0x00F9, -120 },
  { 0x0054, 0x0171, -120 },
  { 0x0054, 0x016B, -60 },
  { 0x0054, 0x0173, -120 },
  { 0x0054, 0x016F, -120 },
  { 0x0054, 0x0077, -120 },
  { 0x0054, 0x0079, -120 },
  { 0x0054, 0x00FD, -120 },
  { 0x0054, 0x00FF, -60 },
  { 0x0164, 0x0041, -120 },
  { 0x0164, 0x00C1, -120 },
  { 0x0164, 0x0102, -120 },
  { 0x0164, 0x00C2, -120 },
  { 0x0164, 0x00C4, -120 },
  { 0x0164, 0x00C0, -120 },
  { 0x0164, 0x0100, -120 },
  { 0x0164, 0x0104, -120 },
  { 0x0164, 0x00C5, -120 },
  { 0x0164, 0x00C3, -120 },
  { 0x0164, 0x004F, -40 },
  { 0x0164, 0x00D3, -40 },
  { 0x0164, 0x00D4, -40 },
  { 0x0164, 0x00D6, -40 },
  { 0x0164, 0x00D2, -40 },
  { 0x0164, 0x0150, -40 },
  { 0x0164, 0x014C, -40 },
  { 0x0164, 0x00D8, -40 },
  { 0x0164, 0x00D5, -40 },
  { 0x0164, 0x0061, -120 },
  { 0x0164, 0x00E1, -120 },
  { 0x0164, 0x0103, -60 },
  { 0x0164, 0x00E2, -120 },
  { 0x0164, 0x00E4, -120 },
  { 0x0164, 0x00E0, -120 },
  { 0x0164, 0x0101, -60 },
  { 0x0164, 0x0105, -120 },
  { 0x0164, 0x00E5, -120 },
  { 0x0164, 0x00E3, -60 },
  { 0x0164, 0x003A, -20 },
  { 0x0164, 0x002C, -120 },
  { 0x0164, 0x0065, -120 },
  { 0x0164, 0x00E9, -120 },
  { 0x0164, 0x011B, -120 },
  { 0x0164, 0x00EA, -120 },
  { 0x0164, 0x00EB, -120 },
  { 0x0164, 0x0117, -120 },
  { 0x0164, 0x00E8, -60 },
  { 0x0164, 0x0113, -60 },
  { 0x0164, 0x0119, -120 },
  { 0x0164, 0x002D, -140 },
  { 0x0164, 0x006F, -120 },
  { 0x0164, 0x00F3, -120 },
  { 0x0164, 0x00F4, -120 },
  { 0x0164, 0x00F6, -120 },
  { 0x0164, 0x00F2, -120 },
  { 0x0164, 0x0151, -120 },
  { 0x0164, 0x014D, -60 },
  { 0x0164, 0x00F8, -120 },
  { 0x0164, 0x00F5, -60 },
  { 0x0164, 0x002E, -120 },
  { 0x0164, 0x0072, -120 },
  { 0x0164, 0x0155, -120 },
  { 0x0164, 0x0159, -120 },
  { 0x0164, 0x0157, -120 },
  { 0x0164, 0x003B, -20 },
  { 0x0164, 0x0075, -120 },
  { 0x0164, 0x00FA, -120 },
  { 0x0164, 0x00FB, -120 },
  { 0x0164, 0x00FC, -120 },
  { 0x0164, 0x00F9, -120 },
  { 0x0164, 0x0171, -120 },
  { 0x0164, 0x016B, -60 },
  { 0x0164, 0x0173, -120 },
  { 0x0164, 0x016F, -120 },
  { 0x0164, 0x0077, -120 },
  { 0x0164, 0x0079, -120 },
  { 0x0164, 0x00FD, -120 },
  { 0x0164, 0x00FF, -60 },
  { 0x0162, 0x0041, -120 },
  { 0x0162, 0x00C1, -120 },
  { 0x0162, 0x0102, -120 },
  { 0x0162, 0x00C2, -120 },
  { 0x0162, 0x00C4, -120 },
  { 0x0162, 0x00C0, -120 },
  { 0x0162, 0x0100, -120 },
  { 0x0162, 0x0104, -120 },
  { 0x0162, 0x00C5, -120 },
  { 0x0162, 0x00C3, -120 },
  { 0x0162, 0x004F, -40 },
  { 0x0162, 0x00D3, -40 },
  { 0x0162, 0x00D4, -40 },
  { 0x0162, 0x00D6, -40 },
  { 0x0162, 0x00D2, -40 },
  { 0x0162, 0x0150, -40 },
  { 0x0162, 0x014C, -40 },
  { 0x0162, 0x00D8, -40 },
  { 0x0162, 0x00D5, -40 },
  { 0x0162, 0x0061, -120 },
  { 0x0162, 0x00E1, -120 },
  { 0x0162, 0x0103, -60 },
  { 0x0162, 0x00E2, -120 },
  { 0x0162, 0x00E4, -120 },
  { 0x0162, 0x00E0, -120 },
  { 0x0162, 0x0101, -60 },
  { 0x0162, 0x0105, -120 },
  { 0x0162, 0x00E5, -120 },
  { 0x0162, 0x00E3, -60 },
  { 0x0162, 0x003A, -20 },
  { 0x0162, 0x002C, -120 },
  { 0x0162, 0x0065, -120 },
  { 0x0162, 0x00E9, -120 },
  { 0x0162, 0x011B, -120 },
  { 0x0162, 0x00EA, -120 },
  { 0x0162, 0x00EB, -120 },
  { 0x0162, 0x0117, -120 },
  { 0x0162, 0x00E8, -60 },
  { 0x0162, 0x0113, -60 },
  { 0x0162, 0x0119, -120 },
  { 0x0162, 0x002D, -140 },
  { 0x0162, 0x006F, -120 },
  { 0x0162, 0x00F3, -120 },
  { 0x0162, 0x00F4, -120 },
  { 0x0162, 0x00F6, -120 },
  { 0x0162, 0x00F2, -120 },
  { 0x0162, 0x0151, -120 },
  { 0x0162, 0x014D, -60 },
  { 0x0162, 0x00F8, -120 },
  { 0x0162, 0x00F5, -60 },
  { 0x0162, 0x002E, -120 },
  { 0x0162, 0x0072, -120 },
  { 0x0162, 0x0155, -120 },
  { 0x0162, 0x0159, -120 },
  { 0x0162, 0x0157, -120 },
  { 0x0162, 0x003B, -20 },
  { 0x0162, 0x0075, -120 },
  { 0x0162, 0x00FA, -120 },
  { 0x0162, 0x00FB, -120 },
  { 0x0162, 0x00FC, -120 },
  { 0x0162, 0x00F9, -120 },
  { 0x0162, 0x0171, -120 },
  { 0x0162, 0x016B, -60 },
  { 0x0162, 0x0173, -120 },
  { 0x0162, 0x016F, -120 },
  { 0x0162, 0x0077, -120 },
  { 0x0162, 0x0079, -120 },
  { 0x0162, 0x00FD, -120 },
  { 0x0162, 0x00FF, -60 },
  { 0x0055, 0x0041, -40 },
  { 0x0055, 0x00C1, -40 },
  { 0x0055, 0x0102, -40 },
  { 0x0055, 0x00C2, -40 },
  { 0x0055, 0x00C4, -40 },
  { 0x0055, 0x00C0, -40 },
  { 0x0055, 0x0100, -40 },
  { 0x0055, 0x0104, -40 },
  { 0x0055, 0x00C5, -40 },
  { 0x0055, 0x00C3, -40 },
  { 0x0055, 0x002C, -40 },
  { 0x0055, 0x002E, -40 },
  { 0x00DA, 0x0041, -40 },
  { 0x00DA, 0x00C1, -40 },
  { 0x00DA, 0x0102, -40 },
  { 0x00DA, 0x00C2, -40 },
  { 0x00DA, 0x00C4, -40 },
  { 0x00DA, 0x00C0, -40 },
  { 0x00DA, 0x0100, -40 },
  { 0x00DA, 0x0104, -40 },
  { 0x00DA, 0x00C5, -40 },
  { 0x00DA, 0x00C3, -40 },
  { 0x00DA, 0x002C, -40 },
  { 0x00DA, 0x002E, -40 },
  { 0x00DB, 0x0041, -40 },
  { 0x00DB, 0x00C1, -40 },
  { 0x00DB, 0x0102, -40 },
  { 0x00DB, 0x00C2, -40 },
  { 0x00DB, 0x00C4, -40 },
  { 0x00DB, 0x00C0, -40 },
  { 0x00DB, 0x0100, -40 },
  { 0x00DB, 0x0104, -40 },
  { 0x00DB, 0x00C5, -40 },
  { 0x00DB, 0x00C3, -40 },
  { 0x00DB, 0x002C, -40 },
  { 0x00DB, 0x002E, -40 },
  { 0x00DC, 0x0041, -40 },
  { 0x00DC, 0x00C1, -40 },
  { 0x00DC, 0x0102, -40 },
  { 0x00DC, 0x00C2, -40 },
  { 0x00DC, 0x00C4, -40 },
  { 0x00DC, 0x00C0, -40 },
  { 0x00DC, 0x0100, -40 },
  { 0x00DC, 0x0104, -40 },
  { 0x00DC, 0x00C5, -40 },
  { 0x00DC, 0x00C3, -40 },
  { 0x00DC, 0x002C, -40 },
  { 0x00DC, 0x002E, -40 },
  { 0x00D9, 0x0041, -40 },
  { 0x00D9, 0x00C1, -40 },
  { 0x00D9, 0x0102, -40 },
  { 0x00D9, 0x00C2, -40 },
  { 0x00D9, 0x00C4, -40 },
  { 0x00D9, 0x00C0, -40 },
  { 0x00D9, 0x0100, -40 },
  { 0x00D9, 0x0104, -40 },
  { 0x00D9, 0x00C5, -40 },
  { 0x00D9, 0x00C3, -40 },
  { 0x00D9, 0x002C, -40 },
  { 0x00D9, 0x002E, -40 },
  { 0x0170, 0x0041, -40 },
  { 0x0170, 0x00C1, -40 },
  { 0x0170, 0x0102, -40 },
  { 0x0170, 0x00C2, -40 },
  { 0x0170, 0x00C4, -40 },
  { 0x0170, 0x00C0, -40 },
  { 0x0170, 0x0100, -40 },
  { 0x0170, 0x0104, -40 },
  { 0x0170, 0x00C5, -40 },
  { 0x0170, 0x00C3, -40 },
  { 0x0170, 0x002C, -40 },
  { 0x0170, 0x002E, -40 },
  { 0x016A, 0x0041, -40 },
  { 0x016A, 0x00C1, -40 },
  { 0x016A, 0x0102, -40 },
  { 0x016A, 0x00C2, -40 },
  { 0x016A, 0x00C4, -40 },
  { 0x016A, 0x00C0, -40 },
  { 0x016A, 0x0100, -40 },
  { 0x016A, 0x0104, -40 },
  { 0x016A, 0x00C5, -40 },
  { 0x016A, 0x00C3, -40 },
  { 0x016A, 0x002C, -40 },
  { 0x016A, 0x002E, -40 },
  { 0x0172, 0x0041, -40 },
  { 0x0172, 0x00C1, -40 },
  { 0x0172, 0x0102, -40 },
  { 0x0172, 0x00C2, -40 },
  { 0x0172, 0x00C4, -40 },
  { 0x0172, 0x00C0, -40 },
  { 0x0172, 0x0100, -40 },
  { 0x0172, 0x0104, -40 },
  { 0x0172, 0x00C5, -40 },
  { 0x0172, 0x00C3, -40 },
  { 0x0172, 0x002C, -40 },
  { 0x0172, 0x002E, -40 },
  { 0x016E, 0x0041, -40 },
  { 0x016E, 0x00C1, -40 },
  { 0x016E, 0x0102, -40 },
  { 0x016E, 0x00C2, -40 },
  { 0x016E, 0x00C4, -40 },
  { 0x016E, 0x00C0, -40 },
  { 0x016E, 0x0100, -40 },
  { 0x016E, 0x0104, -40 },
  { 0x016E, 0x00C5, -40 },
  { 0x016E, 0x00C3, -40 },
  { 0x016E, 0x002C, -40 },
  { 0x016E, 0x002E, -40 },
  { 0x0056, 0x0041, -80 },
  { 0x0056, 0x00C1, -80 },
  { 0x0056, 0x0102, -80 },
  { 0x0056, 0x00C2, -80 },
  { 0x0056, 0x00C4, -80 },
  { 0x0056, 0x00C0, -80 },
  { 0x0056, 0x0100, -80 },
  { 0x0056, 0x0104, -80 },
  { 0x0056, 0x00C5, -80 },
  { 0x0056, 0x00C3, -80 },
  { 0x0056, 0x0047, -40 },
  { 0x0056, 0x011E, -40 },
  { 0x0056, 0x0122, -40 },
  { 0x0056, 0x004F, -40 },
  { 0x0056, 0x00D3, -40 },
  { 0x0056, 0x00D4, -40 },
  { 0x0056, 0x00D6, -40 },
  { 0x0056, 0x00D2, -40 },
  { 0x0056, 0x0150, -40 },
  { 0x0056, 0x014C, -40 },
  { 0x0056, 0x00D8, -40 },
  { 0x0056, 0x00D5, -40 },
  { 0x0056, 0x0061, -70 },
  { 0x0056, 0x00E1, -70 },
  { 0x0056, 0x0103, -70 },
  { 0x0056, 0x00E2, -70 },
  { 0x0056, 0x00E4, -70 },
  { 0x0056, 0x00E0, -70 },
  { 0x0056, 0x0101, -70 },
  { 0x0056, 0x0105, -70 },
  { 0x0056, 0x00E5, -70 },
  { 0x0056, 0x00E3, -70 },
  { 0x0056, 0x003A, -40 },
  { 0x0056, 0x002C, -125 },
  { 0x0056, 0x0065, -80 },
  { 0x0056, 0x00E9, -80 },
  { 0x0056, 0x011B, -80 },
  { 0x0056, 0x00EA, -80 },
  { 0x0056, 0x00EB, -80 },
  { 0x0056, 0x0117, -80 },
  { 0x0056, 0x00E8, -80 },
  { 0x0056, 0x0113, -80 },
  { 0x0056, 0x0119, -80 },
  { 0x0056, 0x002D, -80 },
  { 0x0056, 0x006F, -80 },
  { 0x0056, 0x00F3, -80 },
  { 0x0056, 0x00F4, -80 },
  { 0x0056, 0x00F6, -80 },
  { 0x0056, 0x00F2, -80 },
  { 0x0056, 0x0151, -80 },
  { 0x0056, 0x014D, -80 },
  { 0x0056, 0x00F8, -80 },
  { 0x0056, 0x00F5, -80 },
  { 0x0056, 0x002E, -125 },
  { 0x0056, 0x003B, -40 },
  { 0x0056, 0x0075, -70 },
  { 0x0056, 0x00FA, -70 },
  { 0x0056, 0x00FB, -70 },
  { 0x0056, 0x00FC, -70 },
  { 0x0056, 0x00F9, -70 },
  { 0x0056, 0x0171, -70 },
  { 0x0056, 0x016B, -70 },
  { 0x0056, 0x0173, -70 },
  { 0x0056, 0x016F, -70 },
  { 0x0057, 0x0041, -50 },
  { 0x0057, 0x00C1, -50 },
  { 0x0057, 0x0102, -50 },
  { 0x0057, 0x00C2, -50 },
  { 0x0057, 0x00C4, -50 },
  { 0x0057, 0x00C0, -50 },
  { 0x0057, 0x0100, -50 },
  { 0x0057, 0x0104, -50 },
  { 0x0057, 0x00C5, -50 },
  { 0x0057, 0x00C3, -50 },
  { 0x0057, 0x004F, -20 },
  { 0x0057, 0x00D3, -20 },
  { 0x0057, 0x00D4, -20 },
  { 0x0057, 0x00D6, -20 },
  { 0x0057, 0x00D2, -20 },
  { 0x0057, 0x0150, -20 },
  { 0x0057, 0x014C, -20 },
  { 0x0057, 0x00D8, -20 },
  { 0x0057, 0x00D5, -20 },
  { 0x0057, 0x0061, -40 },
  { 0x0057, 0x00E1, -40 },
  { 0x0057, 0x0103, -40 },
  { 0x0057, 0x00E2, -40 },
  { 0x0057, 0x00E4, -40 },
  { 0x0057, 0x00E0, -40 },
  { 0x0057, 0x0101, -40 },
  { 0x0057, 0x0105, -40 },
  { 0x0057, 0x00E5, -40 },
  { 0x0057, 0x00E3, -40 },
  { 0x0057, 0x002C, -80 },
  { 0x0057, 0x0065, -30 },
  { 0x0057, 0x00E9, -30 },
  { 0x0057, 0x011B, -30 },
  { 0x0057, 0x00EA, -30 },
  { 0x0057, 0x00EB, -30 },
  { 0x0057, 0x0117, -30 },
  { 0x0057, 0x00E8, -30 },
  { 0x0057, 0x0113, -30 },
  { 0x0057, 0x0119, -30 },
  { 0x0057, 0x002D, -40 },
  { 0x0057, 0x006F, -30 },
  { 0x0057, 0x00F3, -30 },
  { 0x0057, 0x00F4, -30 },
  { 0x0057, 0x00F6, -30 },
  { 0x0057, 0x00F2, -30 },
  { 0x0057, 0x0151, -30 },
  { 0x0057, 0x014D, -30 },
  { 0x0057, 0x00F8, -30 },
  { 0x0057, 0x00F5, -30 },
  { 0x0057, 0x002E, -80 },
  { 0x0057, 0x0075, -30 },
  { 0x0057, 0x00FA, -30 },
  { 0x0057, 0x00FB, -30 },
  { 0x0057, 0x00FC, -30 },
  { 0x0057, 0x00F9, -30 },
  { 0x0057, 0x0171, -30 },
  { 0x0057, 0x016B, -30 },
  { 0x0057, 0x0173, -30 },
  { 0x0057, 0x016F, -30 },
  { 0x0057, 0x0079, -20 },
  { 0x0057, 0x00FD, -20 },
  { 0x0057, 0x00FF, -20 },
  { 0x0059, 0x0041, -110 },
  { 0x0059, 0x00C1, -110 },
  { 0x0059, 0x0102, -110 },
  { 0x0059, 0x00C2, -110 },
  { 0x0059, 0x00C4, -110 },
  { 0x0059, 0x00C0, -110 },
  { 0x0059, 0x0100, -110 },
  { 0x0059, 0x0104, -110 },
  { 0x0059, 0x00C5, -110 },
  { 0x0059, 0x00C3, -110 },
  { 0x0059, 0x004F, -85 },
  { 0x0059, 0x00D3, -85 },
  { 0x0059, 0x00D4, -85 },
  { 0x0059, 0x00D6, -85 },
  { 0x0059, 0x00D2, -85 },
  { 0x0059, 0x0150, -85 },
  { 0x0059, 0x014C, -85 },
  { 0x0059, 0x00D8, -85 },
  { 0x0059, 0x00D5, -85 },
  { 0x0059, 0x0061, -140 },
  { 0x0059, 0x00E1, -140 },
  { 0x0059, 0x0103, -70 },
  { 0x0059, 0x00E2, -140 },
  { 0x0059, 0x00E4, -140 },
  { 0x0059, 0x00E0, -140 },
  { 0x0059, 0x0101, -70 },
  { 0x0059, 0x0105, -140 },
  { 0x0059, 0x00E5, -140 },
  { 0x0059, 0x00E3, -140 },
  { 0x0059, 0x003A, -60 },
  { 0x0059, 0x002C, -140 },
  { 0x0059, 0x0065, -140 },
  { 0x0059, 0x00E9, -140 },
  { 0x0059, 0x011B, -140 },
  { 0x0059, 0x00EA, -140 },
  { 0x0059, 0x00EB, -140 },
  { 0x0059, 0x0117, -140 },
  { 0x0059, 0x00E8, -140 },
  { 0x0059, 0x0113, -70 },
  { 0x0059, 0x0119, -140 },
  { 0x0059, 0x002D, -140 },
  { 0x0059, 0x0069, -20 },
  { 0x0059, 0x00ED, -20 },
  { 0x0059, 0x012F, -20 },
  { 0x0059, 0x006F, -140 },
  { 0x0059, 0x00F3, -140 },
  { 0x0059, 0x00F4, -140 },
  { 0x0059, 0x00F6, -140 },
  { 0x0059, 0x00F2, -140 },
  { 0x0059, 0x0151, -140 },
  { 0x0059, 0x014D, -140 },
  { 0x0059, 0x00F8, -140 },
  { 0x0059, 0x00F5, -140 },
  { 0x0059, 0x002E, -140 },
  { 0x0059, 0x003B, -60 },
  { 0x0059, 0x0075, -110 },
  { 0x0059, 0x00FA, -110 },
  { 0x0059, 0x00FB, -110 },
  { 0x0059, 0x00FC, -110 },
  { 0x0059, 0x00F9, -110 },
  { 0x0059, 0x0171, -110 },
  { 0x0059, 0x016B, -110 },
  { 0x0059, 0x0173, -110 },
  { 0x0059, 0x016F, -110 },
  { 0x00DD, 0x0041, -110 },
  { 0x00DD, 0x00C1, -110 },
  { 0x00DD, 0x0102, -110 },
  { 0x00DD, 0x00C2, -110 },
  { 0x00DD, 0x00C4, -110 },
  { 0x00DD, 0x00C0, -110 },
  { 0x00DD, 0x0100, -110 },
  { 0x00DD, 0x0104, -110 },
  { 0x00DD, 0x00C5, -110 },
  { 0x00DD, 0x00C3, -110 },
  { 0x00DD, 0x004F, -85 },
  { 0x00DD, 0x00D3, -85 },
  { 0x00DD, 0x00D4, -85 },
  { 0x00DD, 0x00D6, -85 },
  { 0x00DD, 0x00D2, -85 },
  { 0x00DD, 0x0150, -85 },
  { 0x00DD, 0x014C, -85 },
  { 0x00DD, 0x00D8, -85 },
  { 0x00DD, 0x00D5, -85 },
  { 0x00DD, 0x0061, -140 },
  { 0x00DD, 0x00E1, -140 },
  { 0x00DD, 0x0103, -70 },
  { 0x00DD, 0x00E2, -140 },
  { 0x00DD, 0x00E4, -140 },
  { 0x00DD, 0x00E0, -140 },
  { 0x00DD, 0x0101, -70 },
  { 0x00DD, 0x0105, -140 },
  { 0x00DD, 0x00E5, -140 },
  { 0x00DD, 0x00E3, -70 },
  { 0x00DD, 0x003A, -60 },
  { 0x00DD, 0x002C, -140 },
  { 0x00DD, 0x0065, -140 },
  { 0x00DD, 0x00E9, -140 },
  { 0x00DD, 0x011B, -140 },
  { 0x00DD, 0x00EA, -140 },
  { 0x00DD, 0x00EB, -140 },
  { 0x00DD, 0x0117, -140 },
  { 0x00DD, 0x00E8, -140 },
  { 0x00DD, 0x0113, -70 },
  { 0x00DD, 0x0119, -140 },
  { 0x00DD, 0x002D, -140 },
  { 0x00DD, 0x0069, -20 },
  { 0x00DD, 0x00ED, -20 },
  { 0x00DD, 0x012F, -20 },
  { 0x00DD, 0x006F, -140 },
  { 0x00DD, 0x00F3, -140 },
  { 0x00DD, 0x00F4, -140 },
  { 0x00DD, 0x00F6, -140 },
  { 0x00DD, 0x00F2, -140 },
  { 0x00DD, 0x0151, -140 },
  { 0x00DD, 0x014D, -70 },
  { 0x00DD, 0x00F8, -140 },
  { 0x00DD, 0x00F5, -140 },
  { 0x00DD, 0x002E, -140 },
  { 0x00DD, 0x003B, -60 },
  { 0x00DD, 0x0075, -110 },
  { 0x00DD, 0x00FA, -110 },
  { 0x00DD, 0x00FB, -110 },
  { 0x00DD, 0x00FC, -110 },
  { 0x00DD, 0x00F9, -110 },
  { 0x00DD, 0x0171, -110 },
  { 0x00DD, 0x016B, -110 },
  { 0x00DD, 0x0173, -110 },
  { 0x00DD, 0x016F, -110 },
  { 0x0178, 0x0041, -110 },
  { 0x0178, 0x00C1, -110 },
  { 0x0178, 0x0102, -110 },
  { 0x0178, 0x00C2, -110 },
  { 0x0178, 0x00C4, -110 },
  { 0x0178, 0x00C0, -110 },
  { 0x0178, 0x0100, -110 },
  { 0x0178, 0x0104, -110 },
  { 0x0178, 0x00C5, -110 },
  { 0x0178, 0x00C3, -110 },
  { 0x0178, 0x004F, -85 },
  { 0x0178, 0x00D3, -85 },
  { 0x0178, 0x00D4, -85 },
  { 0x0178, 0x00D6, -85 },
  { 0x0178, 0x00D2, -85 },
  { 0x0178, 0x0150, -85 },
  { 0x0178, 0x014C, -85 },
  { 0x0178, 0x00D8, -85 },
  { 0x0178, 0x00D5, -85 },
  { 0x0178, 0x0061, -140 },
  { 0x0178, 0x00E1, -140 },
  { 0x0178, 0x0103, -70 },
  { 0x0178, 0x00E2, -140 },
  { 0x0178, 0x00E4, -140 },
  { 0x0178, 0x00E0, -140 },
  { 0x0178, 0x0101, -70 },
  { 0x0178, 0x0105, -140 },
  { 0x0178, 0x00E5, -140 },
  { 0x0178, 0x00E3, -70 },
  { 0x0178, 0x003A, -60 },
  { 0x0178, 0x002C, -140 },
  { 0x0178, 0x0065, -140 },
  { 0x0178, 0x00E9, -140 },
  { 0x0178, 0x011B, -140 },
  { 0x0178, 0x00EA, -140 },
  { 0x0178, 0x00EB, -140 },
  { 0x0178, 0x0117, -140 },
  { 0x0178, 0x00E8, -140 },
  { 0x0178, 0x0113, -70 },
  { 0x0178, 0x0119, -140 },
  { 0x0178, 0x002D, -140 },
  { 0x0178, 0x0069, -20 },
  { 0x0178, 0x00ED, -20 },
  { 0x0178, 0x012F, -20 },
  { 0x0178, 0x006F, -140 },
  { 0x0178, 0x00F3, -140 },
  { 0x0178, 0x00F4, -140 },
  { 0x0178, 0x00F6, -140 },
  { 0x0178, 0x00F2, -140 },
  { 0x0178, 0x0151, -140 },
  { 0x0178, 0x014D, -140 },
  { 0x0178, 0x00F8, -140 },
  { 0x0178, 0x00F5, -140 },
  { 0x0178, 0x002E, -140 },
  { 0x0178, 0x003B, -60 },
  { 0x0178, 0x0075, -110 },
  { 0x0178, 0x00FA, -110 },
  { 0x0178, 0x00FB, -110 },
  { 0x0178, 0x00FC, -110 },
  { 0x0178, 0x00F9, -110 },
  { 0x0178, 0x0171, -110 },
  { 0x0178, 0x016B, -110 },
  { 0x0178, 0x0173, -110 },
  { 0x0178, 0x016F, -110 },
  { 0x0061, 0x0076, -20 },
  { 0x0061, 0x0077, -20 },
  { 0x0061, 0x0079, -30 },
  { 0x0061, 0x00FD, -30 },
  { 0x0061, 0x00FF, -30 },
  { 0x00E1, 0x0076, -20 },
  { 0x00E1, 0x0077, -20 },
  { 0x00E1, 0x0079, -30 },
  { 0x00E1, 0x00FD, -30 },
  { 0x00E1, 0x00FF, -30 },
  { 0x0103, 0x0076, -20 },
  { 0x0103, 0x0077, -20 },
  { 0x0103, 0x0079, -30 },
  { 0x0103, 0x00FD, -30 },
  { 0x0103, 0x00FF, -30 },
  { 0x00E2, 0x0076, -20 },
  { 0x00E2, 0x0077, -20 },
  { 0x00E2, 0x0079, -30 },
  { 0x00E2, 0x00FD, -30 },
  { 0x00E2, 0x00FF, -30 },
  { 0x00E4, 0x0076, -20 },
  { 0x00E4, 0x0077, -20 },
  { 0x00E4, 0x0079, -30 },
  { 0x00E4, 0x00FD, -30 },
  { 0x00E4, 0x00FF, -30 },
  { 0x00E0, 0x0076, -20 },
  { 0x00E0, 0x0077, -20 },
  { 0x00E0, 0x0079, -30 },
  { 0x00E0, 0x00FD, -30 },
  { 0x00E0, 0x00FF, -30 },
  { 0x0101, 0x0076, -20 },
  { 0x0101, 0x0077, -20 },
  { 0x0101, 0x0079, -30 },
  { 0x0101, 0x00FD, -30 },
  { 0x0101, 0x00FF, -30 },
  { 0x0105, 0x0076, -20 },
  { 0x0105, 0x0077, -20 },
  { 0x0105, 0x0079, -30 },
  { 0x0105, 0x00FD, -30 },
  { 0x0105, 0x00FF, -30 },
  { 0x00E5, 0x0076, -20 },
  { 0x00E5, 0x0077, -20 },
  { 0x00E5, 0x0079, -30 },
  { 0x00E5, 0x00FD, -30 },
  { 0x00E5, 0x00FF, -30 },
  { 0x00E3, 0x0076, -20 },
  { 0x00E3, 0x0077, -20 },
  { 0x00E3, 0x0079, -30 },
  { 0x00E3, 0x00FD, -30 },
  { 0x00E3, 0x00FF, -30 },
  { 0x0062, 0x0062, -10 },
  { 0x0062, 0x002C, -40 },
  { 0x0062, 0x006C, -20 },
  { 0x0062, 0x013A, -20 },
  { 0x0062, 0x013C, -20 },
  { 0x0062, 0x0142, -20 },
  { 0x0062, 0x002E, -40 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0062, 0x0076, -20 },
  { 0x0062, 0x0079, -20 },
  { 0x0062, 0x00FD, -20 },
  { 0x0062, 0x00FF, -20 },
  { 0x0063, 0x002C, -15 },
  { 0x0063, 0x006B, -20 },
  { 0x0063, 0x0137, -20 },
  { 0x0107, 0x002C, -15 },
  { 0x0107, 0x006B, -20 },
  { 0x0107, 0x0137, -20 },
  { 0x010D, 0x002C, -15 },
  { 0x010D, 0x006B, -20 },
  { 0x010D, 0x0137, -20 },
  { 0x00E7, 0x002C, -15 },
  { 0x00E7, 0x006B, -20 },
  { 0x00E7, 0x0137, -20 },
  { 0x003A, 0x0020, -50 },
  { 0x002C, 0x201D, -100 },
  { 0x002C, 0x2019, -100 },
  { 0x0065, 0x002C, -15 },
  { 0x0065, 0x002E, -15 },
  { 0x0065, 0x0076, -30 },
  { 0x0065, 0x0077, -20 },
  { 0x0065, 0x0078, -30 },
  { 0x0065, 0x0079, -20 },
  { 0x0065, 0x00FD, -20 },
  { 0x0065, 0x00FF, -20 },
  { 0x00E9, 0x002C, -15 },
  { 0x00E9, 0x002E, -15 },
  { 0x00E9, 0x0076, -30 },
  { 0x00E9, 0x0077, -20 },
  { 0x00E9, 0x0078, -30 },
  { 0x00E9, 0x0079, -20 },
  { 0x00E9, 0x00FD, -20 },
  { 0x00E9, 0x00FF, -20 },
  { 0x011B, 0x002C, -15 },
  { 0x011B, 0x002E, -15 },
  { 0x011B, 0x0076, -30 },
  { 0x011B, 0x0077, -20 },
  { 0x011B, 0x0078, -30 },
  { 0x011B, 0x0079, -20 },
  { 0x011B, 0x00FD, -20 },
  { 0x011B, 0x00FF, -20 },
  { 0x00EA, 0x002C, -15 },
  { 0x00EA, 0x002E, -15 },
  { 0x00EA, 0x0076, -30 },
  { 0x00EA, 0x0077, -20 },
  { 0x00EA, 0x0078, -30 },
  { 0x00EA, 0x0079, -20 },
  { 0x00EA, 0x00FD, -20 },
  { 0x00EA, 0x00FF, -20 },
  { 0x00EB, 0x002C, -15 },
  { 0x00EB, 0x002E, -15 },
  { 0x00EB, 0x0076, -30 },
  { 0x00EB, 0x0077, -20 },
  { 0x00EB, 0x0078, -30 },
  { 0x00EB, 0x0079, -20 },
  { 0x00EB, 0x00FD, -20 },
  { 0x00EB, 0x00FF, -20 },
  { 0x0117, 0x002C, -15 },
  { 0x0117, 0x002E, -15 },
  { 0x0117, 0x0076, -30 },
  { 0x0117, 0x0077, -20 },
  { 0x0117, 0x0078, -30 },
  { 0x0117, 0x0079, -20 },
  { 0x0117, 0x00FD, -20 },
  { 0x0117, 0x00FF, -20 },
  { 0x00E8, 0x002C, -15 },
  { 0x00E8, 0x002E, -15 },
  { 0x00E8, 0x0076, -30 },
  { 0x00E8, 0x0077, -20 },
  { 0x00E8, 0x0078, -30 },
  { 0x00E8, 0x0079, -20 },
  { 0x00E8, 0x00FD, -20 },
  { 0x00E8, 0x00FF, -20 },
  { 0x0113, 0x002C, -15 },
  { 0x0113, 0x002E, -15 },
  { 0x0113, 0x0076, -30 },
  { 0x0113, 0x0077, -20 },
  { 0x0113, 0x0078, -30 },
  { 0x0113, 0x0079, -20 },
  { 0x0113, 0x00FD, -20 },
  { 0x0113, 0x00FF, -20 },
  { 0x0119, 0x002C, -15 },
  { 0x0119, 0x002E, -15 },
  { 0x0119, 0x0076, -30 },
  { 0x0119, 0x0077, -20 },
  { 0x0119, 0x0078, -30 },
  { 0x0119, 0x0079, -20 },
  { 0x0119, 0x00FD, -20 },
  { 0x0119, 0x00FF, -20 },
  { 0x0066, 0x0061, -30 },
  { 0x0066, 0x00E1, -30 },
  { 0x0066, 0x0103, -30 },
  { 0x0066, 0x00E2, -30 },
  { 0x0066, 0x00E4, -30 },
  { 0x0066, 0x00E0, -30 },
  { 0x0066, 0x0101, -30 },
  { 0x0066, 0x0105, -30 },
  { 0x0066, 0x00E5, -30 },
  { 0x0066, 0x00E3, -30 },
  { 0x0066, 0x002C, -30 },
  { 0x0066, 0x0131, -28 },
  { 0x0066, 0x0065, -30 },
  { 0x0066, 0x00E9, -30 },
  { 0x0066, 0x011B, -30 },
  { 0x0066, 0x00EA, -30 },
  { 0x0066, 0x00EB, -30 },
  { 0x0066, 0x0117, -30 },
  { 0x0066, 0x00E8, -30 },
  { 0x0066, 0x0113, -30 },
  { 0x0066, 0x0119, -30 },
  { 0x0066, 0x006F, -30 },
  { 0x0066, 0x00F3, -30 },
  { 0x0066, 0x00F4, -30 },
  { 0x0066, 0x00F6, -30 },
  { 0x0066, 0x00F2, -30 },
  { 0x0066, 0x0151, -30 },
  { 0x0066, 0x014D, -30 },
  { 0x0066, 0x00F8, -30 },
  { 0x0066, 0x00F5, -30 },
  { 0x0066, 0x002E, -30 },
  { 0x0066, 0x201D, 60 },
  { 0x0066, 0x2019, 50 },
  { 0x0067, 0x0072, -10 },
  { 0x0067, 0x0155, -10 },
  { 0x0067, 0x0159, -10 },
  { 0x0067, 0x0157, -10 },
  { 0x011F, 0x0072, -10 },
  { 0x011F, 0x0155, -10 },
  { 0x011F, 0x0159, -10 },
  { 0x011F, 0x0157, -10 },
  { 0x0123, 0x0072, -10 },
  { 0x0123, 0x0155, -10 },
  { 0x0123, 0x0159, -10 },
  { 0x0123, 0x0157, -10 },
  { 0x0068, 0x0079, -30 },
  { 0x0068, 0x00FD, -30 },
  { 0x0068, 0x00FF, -30 },
  { 0x006B, 0x0065, -20 },
  { 0x006B, 0x00E9, -20 },
  { 0x006B, 0x011B, -20 },
  { 0x006B, 0x00EA, -20 },
  { 0x006B, 0x00EB, -20 },
  { 0x006B, 0x0117, -20 },
  { 0x006B, 0x00E8, -20 },
  { 0x006B, 0x0113, -20 },
  { 0x006B, 0x0119, -20 },
  { 0x006B, 0x006F, -20 },
  { 0x006B, 0x00F3, -20 },
  { 0x006B, 0x00F4, -20 },
  { 0x006B, 0x00F6, -20 },
  { 0x006B, 0x00F2, -20 },
  { 0x006B, 0x0151, -20 },
  { 0x006B, 0x014D, -20 },
  { 0x006B, 0x00F8, -20 },
  { 0x006B, 0x00F5, -20 },
  { 0x0137, 0x0065, -20 },
  { 0x0137, 0x00E9, -20 },
  { 0x0137, 0x011B, -20 },
  { 0x0137, 0x00EA, -20 },
  { 0x0137, 0x00EB, -20 },
  { 0x0137, 0x0117, -20 },
  { 0x0137, 0x00E8, -20 },
  { 0x0137, 0x0113, -20 },
  { 0x0137, 0x0119, -20 },
  { 0x0137, 0x006F, -20 },
  { 0x0137, 0x00F3, -20 },
  { 0x0137, 0x00F4, -20 },
  { 0x0137, 0x00F6, -20 },
  { 0x0137, 0x00F2, -20 },
  { 0x0137, 0x0151, -20 },
  { 0x0137, 0x014D, -20 },
  { 0x0137, 0x00F8, -20 },
  { 0x0137, 0x00F5, -20 },
  { 0x006D, 0x0075, -10 },
  { 0x006D, 0x00FA, -10 },
  { 0x006D, 0x00FB, -10 },
  { 0x006D, 0x00FC, -10 },
  { 0x006D, 0x00F9, -10 },
  { 0x006D, 0x0171, -10 },
  { 0x006D, 0x016B, -10 },
  { 0x006D, 0x0173, -10 },
  { 0x006D, 0x016F, -10 },
  { 0x006D, 0x0079, -15 },
  { 0x006D, 0x00FD, -15 },
  { 0x006D, 0x00FF, -15 },
  { 0x006E, 0x0075, -10 },
  { 0x006E, 0x00FA, -10 },
  { 0x006E, 0x00FB, -10 },
  { 0x006E, 0x00FC, -10 },
  { 0x006E, 0x00F9, -10 },
  { 0x006E, 0x0171, -10 },
  { 0x006E, 0x016B, -10 },
  { 0x006E, 0x0173, -10 },
  { 0x006E, 0x016F, -10 },
  { 0x006E, 0x0076, -20 },
  { 0x006E, 0x0079, -15 },
  { 0x006E, 0x00FD, -15 },
  { 0x006E, 0x00FF, -15 },
  { 0x0144, 0x0075, -10 },
  { 0x0144, 0x00FA, -10 },
  { 0x0144, 0x00FB, -10 },
  { 0x0144, 0x00FC, -10 },
  { 0x0144, 0x00F9, -10 },
  { 0x0144, 0x0171, -10 },
  { 0x0144, 0x016B, -10 },
  { 0x0144, 0x0173, -10 },
  { 0x0144, 0x016F, -10 },
  { 0x0144, 0x0076, -20 },
  { 0x0144, 0x0079, -15 },
  { 0x0144, 0x00FD, -15 },
  { 0x0144, 0x00FF, -15 },
  { 0x0148, 0x0075, -10 },
  { 0x0148, 0x00FA, -10 },
  { 0x0148, 0x00FB, -10 },
  { 0x0148, 0x00FC, -10 },
  { 0x0148, 0x00F9, -10 },
  { 0x0148, 0x0171, -10 },
  { 0x0148, 0x016B, -10 },
  { 0x0148, 0x0173, -10 },
  { 0x0148, 0x016F, -10 },
  { 0x0148, 0x0076, -20 },
  { 0x0148, 0x0079, -15 },
  { 0x0148, 0x00FD, -15 },
  { 0x0148, 0x00FF, -15 },
  { 0x0146, 0x0075, -10 },
  { 0x0146, 0x00FA, -10 },
  { 0x0146, 0x00FB, -10 },
  { 0x0146, 0x00FC, -10 },
  { 0x0146, 0x00F9, -10 },
  { 0x0146, 0x0171, -10 },
  { 0x0146, 0x016B, -10 },
  { 0x0146, 0x0173, -10 },
  { 0x0146, 0x016F, -10 },
  { 0x0146, 0x0076, -20 },
  { 0x0146, 0x0079, -15 },
  { 0x0146, 0x00FD, -15 },
  { 0x0146, 0x00FF, -15 },
  { 0x00F1, 0x0075, -10 },
  { 0x00F1, 0x00FA, -10 },
  { 0x00F1, 0x00FB, -10 },
  { 0x00F1, 0x00FC, -10 },
  { 0x00F1, 0x00F9, -10 },
  { 0x00F1, 0x0171, -10 },
  { 0x00F1, 0x016B, -10 },
  { 0x00F1, 0x0173, -10 },
  { 0x00F1, 0x016F, -10 },
  { 0x00F1, 0x0076, -20 },
  { 0x00F1, 0x0079, -15 },
  { 0x00F1, 0x00FD, -15 },
  { 0x00F1, 0x00FF, -15 },
  { 0x006F, 0x002C, -40 },
  { 0x006F, 0x002E, -40 },
  { 0x006F, 0x0076, -15 },
  { 0x006F, 0x0077, -15 },
  { 0x006F, 0x0078, -30 },
  { 0x006F, 0x0079, -30 },
  { 0x006F, 0x00FD, -30 },
  { 0x006F, 0x00FF, -30 },
  { 0x00F3, 0x002C, -40 },
  { 0x00F3, 0x002E, -40 },
  { 0x00F3, 0x0076, -15 },
  { 0x00F3, 0x0077, -15 },
  { 0x00F3, 0x0078, -30 },
  { 0x00F3, 0x0079, -30 },
  { 0x00F3, 0x00FD, -30 },
  { 0x00F3, 0x00FF, -30 },
  { 0x00F4, 0x002C, -40 },
  { 0x00F4, 0x002E, -40 },
  { 0x00F4, 0x0076, -15 },
  { 0x00F4, 0x0077, -15 },
  { 0x00F4, 0x0078, -30 },
  { 0x00F4, 0x0079, -30 },
  { 0x00F4, 0x00FD, -30 },
  { 0x00F4, 0x00FF, -30 },
  { 0x00F6, 0x002C, -40 },
  { 0x00F6, 0x002E, -40 },
  { 0x00F6, 0x0076, -15 },
  { 0x00F6, 0x0077, -15 },
  { 0x00F6, 0x0078, -30 },
  { 0x00F6, 0x0079, -30 },
  { 0x00F6, 0x00FD, -30 },
  { 0x00F6, 0x00FF, -30 },
  { 0x00F2, 0x002C, -40 },
  { 0x00F2, 0x002E, -40 },
  { 0x00F2, 0x0076, -15 },
  { 0x00F2, 0x0077, -15 },
  { 0x00F2, 0x0078, -30 },
  { 0x00F2, 0x0079, -30 },
  { 0x00F2, 0x00FD, -30 },
  { 0x00F2, 0x00FF, -30 },
  { 0x0151, 0x002C, -40 },
  { 0x0151, 0x002E, -40 },
  { 0x0151, 0x0076, -15 },
  { 0x0151, 0x0077, -15 },
  { 0x0151, 0x0078, -30 },
  { 0x0151, 0x0079, -30 },
  { 0x0151, 0x00FD, -30 },
  { 0x0151, 0x00FF, -30 },
  { 0x014D, 0x002C, -40 },
  { 0x014D, 0x002E, -40 },
  { 0x014D, 0x0076, -15 },
  { 0x014D, 0x0077, -15 },
  { 0x014D, 0x0078, -30 },
  { 0x014D, 0x0079, -30 },
  { 0x014D, 0x00FD, -30 },
  { 0x014D, 0x00FF, -30 },
  { 0x00F8, 0x0061, -55 },
  { 0x00F8, 0x00E1, -55 },
  { 0x00F8, 0x0103, -55 },
  { 0x00F8, 0x00E2, -55 },
  { 0x00F8, 0x00E4, -55 },
  { 0x00F8, 0x00E0, -55 },
  { 0x00F8, 0x0101, -55 },
  { 0x00F8, 0x0105, -55 },
  { 0x00F8, 0x00E5, -55 },
  { 0x00F8, 0x00E3, -55 },
  { 0x00F8, 0x0062, -55 },
  { 0x00F8, 0x0063, -55 },
  { 0x00F8, 0x0107, -55 },
  { 0x00F8, 0x010D, -55 },
  { 0x00F8, 0x00E7, -55 },
  { 0x00F8, 0x002C, -95 },
  { 0x00F8, 0x0064, -55 },
  { 0x00F8, 0x0111, -55 },
  { 0x00F8, 0x0065, -55 },
  { 0x00F8, 0x00E9, -55 },
  { 0x00F8, 0x011B, -55 },
  { 0x00F8, 0x00EA, -55 },
  { 0x00F8, 0x00EB, -55 },
  { 0x00F8, 0x0117, -55 },
  { 0x00F8, 0x00E8, -55 },
  { 0x00F8, 0x0113, -55 },
  { 0x00F8, 0x0119, -55 },
  { 0x00F8, 0x0066, -55 },
  { 0x00F8, 0x0067, -55 },
  { 0x00F8, 0x011F, -55 },
  { 0x00F8, 0x0123, -55 },
  { 0x00F8, 0x0068, -55 },
  { 0x00F8, 0x0069, -55 },
  { 0x00F8, 0x00ED, -55 },
  { 0x00F8, 0x00EE, -55 },
  { 0x00F8, 0x00EF, -55 },
  { 0x00F8, 0x00EC, -55 },
  { 0x00F8, 0x012B, -55 },
  { 0x00F8, 0x012F, -55 },
  { 0x00F8, 0x006A, -55 },
  { 0x00F8, 0x006B, -55 },
  { 0x00F8, 0x0137, -55 },
  { 0x00F8, 0x006C, -55 },
  { 0x00F8, 0x013A, -55 },
  { 0x00F8, 0x013C, -55 },
  { 0x00F8, 0x0142, -55 },
  { 0x00F8, 0x006D, -55 },
  { 0x00F8, 0x006E, -55 },
  { 0x00F8, 0x0144, -55 },
  { 0x00F8, 0x0148, -55 },
  { 0x00F8, 0x0146, -55 },
  { 0x00F8, 0x00F1, -55 },
  { 0x00F8, 0x006F, -55 },
  { 0x00F8, 0x00F3, -55 },
  { 0x00F8, 0x00F4, -55 },
  { 0x00F8, 0x00F6, -55 },
  { 0x00F8, 0x00F2, -55 },
  { 0x00F8, 0x0151, -55 },
  { 0x00F8, 0x014D, -55 },
  { 0x00F8, 0x00F8, -55 },
  { 0x00F8, 0x00F5, -55 },
  { 0x00F8, 0x0070, -55 },
  { 0x00F8, 0x002E, -95 },
  { 0x00F8, 0x0071, -55 },
  { 0x00F8, 0x0072, -55 },
  { 0x00F8, 0x0155, -55 },
  { 0x00F8, 0x0159, -55 },
  { 0x00F8, 0x0157, -55 },
  { 0x00F8, 0x0073, -55 },
  { 0x00F8, 0x015B, -55 },
  { 0x00F8, 0x0161, -55 },
  { 0x00F8, 0x015F, -55 },
  { 0x00F8, 0x0219, -55 },
  { 0x00F8, 0x0074, -55 },
  { 0x00F8, 0x0163, -55 },
  { 0x00F8, 0x0075, -55 },
  { 0x00F8, 0x00FA, -55 },
  { 0x00F8, 0x00FB, -55 },
  { 0x00F8, 0x00FC, -55 },
  { 0x00F8, 0x00F9, -55 },
  { 0x00F8, 0x0171, -55 },
  { 0x00F8, 0x016B, -55 },
  { 0x00F8, 0x0173, -55 },
  { 0x00F8, 0x016F, -55 },
  { 0x00F8, 0x0076, -70 },
  { 0x00F8, 0x0077, -70 },
  { 0x00F8, 0x0078, -85 },
  { 0x00F8, 0x0079, -70 },
  { 0x00F8, 0x00FD, -70 },
  { 0x00F8, 0x00FF, -70 },
  { 0x00F8, 0x007A, -55 },
  { 0x00F8, 0x017A, -55 },
  { 0x00F8, 0x017E, -55 },
  { 0x00F8, 0x017C, -55 },
  { 0x00F5, 0x002C, -40 },
  { 0x00F5, 0x002E, -40 },
  { 0x00F5, 0x0076, -15 },
  { 0x00F5, 0x0077, -15 },
  { 0x00F5, 0x0078, -30 },
  { 0x00F5, 0x0079, -30 },
  { 0x00F5, 0x00FD, -30 },
  { 0x00F5, 0x00FF, -30 },
  { 0x0070, 0x002C, -35 },
  { 0x0070, 0x002E, -35 },
  { 0x0070, 0x0079, -30 },
  { 0x0070, 0x00FD, -30 },
  { 0x0070, 0x00FF, -30 },
  { 0x002E, 0x201D, -100 },
  { 0x002E, 0x2019, -100 },
  { 0x002E, 0x0020, -60 },
  { 0x201D, 0x0020, -40 },
  { 0x2018, 0x2018, -57 },
  { 0x2019, 0x0064, -50 },
  { 0x2019, 0x0111, -50 },
  { 0x2019, 0x2019, -57 },
  { 0x2019, 0x0072, -50 },
  { 0x2019, 0x0155, -50 },
  { 0x2019, 0x0159, -50 },
  { 0x2019, 0x0157, -50 },
  { 0x2019, 0x0073, -50 },
  { 0x2019, 0x015B, -50 },
  { 0x2019, 0x0161, -50 },
  { 0x2019, 0x015F, -50 },
  { 0x2019, 0x0219, -50 },
  { 0x2019, 0x0020, -70 },
  { 0x0072, 0x0061, -10 },
  { 0x0072, 0x00E1, -10 },
  { 0x0072, 0x0103, -10 },
  { 0x0072, 0x00E2, -10 },
  { 0x0072, 0x00E4, -10 },
  { 0x0072, 0x00E0, -10 },
  { 0x0072, 0x0101, -10 },
  { 0x0072, 0x0105, -10 },
  { 0x0072, 0x00E5, -10 },
  { 0x0072, 0x00E3, -10 },
  { 0x0072, 0x003A, 30 },
  { 0x0072, 0x002C, -50 },
  { 0x0072, 0x0069, 15 },
  { 0x0072, 0x00ED, 15 },
  { 0x0072, 0x00EE, 15 },
  { 0x0072, 0x00EF, 15 },
  { 0x0072, 0x00EC, 15 },
  { 0x0072, 0x012B, 15 },
  { 0x0072, 0x012F, 15 },
  { 0x0072, 0x006B, 15 },
  { 0x0072, 0x0137, 15 },
  { 0x0072, 0x006C, 15 },
  { 0x0072, 0x013A, 15 },
  { 0x0072, 0x013C, 15 },
  { 0x0072, 0x0142, 15 },
  { 0x0072, 0x006D, 25 },
  { 0x0072, 0x006E, 25 },
  { 0x0072, 0x0144, 25 },
  { 0x0072, 0x0148, 25 },
  { 0x0072, 0x0146, 25 },
  { 0x0072, 0x00F1, 25 },
  { 0x0072, 0x0070, 30 },
  { 0x0072, 0x002E, -50 },
  { 0x0072, 0x003B, 30 },
  { 0x0072, 0x0074, 40 },
  { 0x0072, 0x0163, 40 },
  { 0x0072, 0x0075, 15 },
  { 0x0072, 0x00FA, 15 },
  { 0x0072, 0x00FB, 15 },
  { 0x0072, 0x00FC, 15 },
  { 0x0072, 0x00F9, 15 },
  { 0x0072, 0x0171, 15 },
  { 0x0072, 0x016B, 15 },
  { 0x0072, 0x0173, 15 },
  { 0x0072, 0x016F, 15 },
  { 0x0072, 0x0076, 30 },
  { 0x0072, 0x0079, 30 },
  { 0x0072, 0x00FD, 30 },
  { 0x0072, 0x00FF, 30 },
  { 0x0155, 0x0061, -10 },
  { 0x0155, 0x00E1, -10 },
  { 0x0155, 0x0103, -10 },
  { 0x0155, 0x00E2, -10 },
  { 0x0155, 0x00E4, -10 },
  { 0x0155, 0x00E0, -10 },
  { 0x0155, 0x0101, -10 },
  { 0x0155, 0x0105, -10 },
  { 0x0155, 0x00E5, -10 },
  { 0x0155, 0x00E3, -10 },
  { 0x0155, 0x003A, 30 },
  { 0x0155, 0x002C, -50 },
  { 0x0155, 0x0069, 15 },
  { 0x0155, 0x00ED, 15 },
  { 0x0155, 0x00EE, 15 },
  { 0x0155, 0x00EF, 15 },
  { 0x0155, 0x00EC, 15 },
  { 0x0155, 0x012B, 15 },
  { 0x0155, 0x012F, 15 },
  { 0x0155, 0x006B, 15 },
  { 0x0155, 0x0137, 15 },
  { 0x0155, 0x006C, 15 },
  { 0x0155, 0x013A, 15 },
  { 0x0155, 0x013C, 15 },
  { 0x0155, 0x0142, 15 },
  { 0x0155, 0x006D, 25 },
  { 0x0155, 0x006E, 25 },
  { 0x0155, 0x0144, 25 },
  { 0x0155, 0x0148, 25 },
  { 0x0155, 0x0146, 25 },
  { 0x0155, 0x00F1, 25 },
  { 0x0155, 0x0070, 30 },
  { 0x0155, 0x002E, -50 },
  { 0x0155, 0x003B, 30 },
  { 0x0155, 0x0074, 40 },
  { 0x0155, 0x0163, 40 },
  { 0x0155, 0x0075, 15 },
  { 0x0155, 0x00FA, 15 },
  { 0x0155, 0x00FB, 15 },
  { 0x0155, 0x00FC, 15 },
  { 0x0155, 0x00F9, 15 },
  { 0x0155, 0x0171, 15 },
  { 0x0155, 0x016B, 15 },
  { 0x0155, 0x0173, 15 },
  { 0x0155, 0x016F, 15 },
  { 0x0155, 0x0076, 30 },
  { 0x0155, 0x0079, 30 },
  { 0x0155, 0x00FD, 30 },
  { 0x0155, 0x00FF, 30 },
  { 0x0159, 0x0061, -10 },
  { 0x0159, 0x00E1, -10 },
  { 0x0159, 0x0103, -10 },
  { 0x0159, 0x00E2, -10 },
  { 0x0159, 0x00E4, -10 },
  { 0x0159, 0x00E0, -10 },
  { 0x0159, 0x0101, -10 },
  { 0x0159, 0x0105, -10 },
  { 0x0159, 0x00E5, -10 },
  { 0x0159, 0x00E3, -10 },
  { 0x0159, 0x003A, 30 },
  { 0x0159, 0x002C, -50 },
  { 0x0159, 0x0069, 15 },
  { 0x0159, 0x00ED, 15 },
  { 0x0159, 0x00EE, 15 },
  { 0x0159, 0x00EF, 15 },
  { 0x0159, 0x00EC, 15 },
  { 0x0159, 0x012B, 15 },
  { 0x0159, 0x012F, 15 },
  { 0x0159, 0x006B, 15 },
  { 0x0159, 0x0137, 15 },
  { 0x0159, 0x006C, 15 },
  { 0x0159, 0x013A, 15 },
  { 0x0159, 0x013C, 15 },
  { 0x0159, 0x0142, 15 },
  { 0x0159, 0x006D, 25 },
  { 0x0159, 0x006E, 25 },
  { 0x0159, 0x0144, 25 },
  { 0x0159, 0x0148, 25 },
  { 0x0159, 0x0146, 25 },
  { 0x0159, 0x00F1, 25 },
  { 0x0159, 0x0070, 30 },
  { 0x0159, 0x002E, -50 },
  { 0x0159, 0x003B, 30 },
  { 0x0159, 0x0074, 40 },
  { 0x0159, 0x0163, 40 },
  { 0x0159, 0x0075, 15 },
  { 0x0159, 0x00FA, 15 },
  { 0x0159, 0x00FB, 15 },
  { 0x0159, 0x00FC, 15 },
  { 0x0159, 0x00F9, 15 },
  { 0x0159, 0x0171, 15 },
  { 0x0159, 0x016B, 15 },
  { 0x0159, 0x0173, 15 },
  { 0x0159, 0x016F, 15 },
  { 0x0159, 0x0076, 30 },
  { 0x0159, 0x0079, 30 },
  { 0x0159, 0x00FD, 30 },
  { 0x0159, 0x00FF, 30 },
  { 0x0157, 0x0061, -10 },
  { 0x0157, 0x00E1, -10 },
  { 0x0157, 0x0103, -10 },
  { 0x0157, 0x00E2, -10 },
  { 0x0157, 0x00E4, -10 },
  { 0x0157, 0x00E0, -10 },
  { 0x0157, 0x0101, -10 },
  { 0x0157, 0x0105, -10 },
  { 0x0157, 0x00E5, -10 },
  { 0x0157, 0x00E3, -10 },
  { 0x0157, 0x003A, 30 },
  { 0x0157, 0x002C, -50 },
  { 0x0157, 0x0069, 15 },
  { 0x0157, 0x00ED, 15 },
  { 0x0157, 0x00EE, 15 },
  { 0x0157, 0x00EF, 15 },
  { 0x0157, 0x00EC, 15 },
  { 0x0157, 0x012B, 15 },
  { 0x0157, 0x012F, 15 },
  { 0x0157, 0x006B, 15 },
  { 0x0157, 0x0137, 15 },
  { 0x0157, 0x006C, 15 },
  { 0x0157, 0x013A, 15 },
  { 0x0157, 0x013C, 15 },
  { 0x0157, 0x0142, 15 },
  { 0x0157, 0x006D, 25 },
  { 0x0157, 0x006E, 25 },
  { 0x0157, 0x0144, 25 },
  { 0x0157, 0x0148, 25 },
  { 0x0157, 0x0146, 25 },
  { 0x0157, 0x00F1, 25 },
  { 0x0157, 0x0070, 30 },
  { 0x0157, 0x002E, -50 },
  { 0x0157, 0x003B, 30 },
  { 0x0157, 0x0074, 40 },
  { 0x0157, 0x0163, 40 },
  { 0x0157, 0x0075, 15 },
  { 0x0157, 0x00FA, 15 },
  { 0x0157, 0x00FB, 15 },
  { 0x0157, 0x00FC, 15 },
  { 0x0157, 0x00F9, 15 },
  { 0x0157, 0x0171, 15 },
  { 0x0157, 0x016B, 15 },
  { 0x0157, 0x0173, 15 },
  { 0x0157, 0x016F, 15 },
  { 0x0157, 0x0076, 30 },
  { 0x0157, 0x0079, 30 },
  { 0x0157, 0x00FD, 30 },
  { 0x0157, 0x00FF, 30 },
  { 0x0073, 0x002C, -15 },
  { 0x0073, 0x002E, -15 },
  { 0x0073, 0x0077, -30 },
  { 0x015B, 0x002C, -15 },
  { 0x015B, 0x002E, -15 },
  { 0x015B, 0x0077, -30 },
  { 0x0161, 0x002C, -15 },
  { 0x0161, 0x002E, -15 },
  { 0x0161, 0x0077, -30 },
  { 0x015F, 0x002C, -15 },
  { 0x015F, 0x002E, -15 },
  { 0x015F, 0x0077, -30 },
  { 0x0219, 0x002C, -15 },
  { 0x0219, 0x002E, -15 },
  { 0x0219, 0x0077, -30 },
  { 0x003B, 0x0020, -50 },
  { 0x0020, 0x0054, -50 },
  { 0x0020, 0x0164, -50 },
  { 0x0020, 0x0162, -50 },
  { 0x0020, 0x0056, -50 },
  { 0x0020, 0x0057, -40 },
  { 0x0020, 0x0059, -90 },
  { 0x0020, 0x00DD, -90 },
  { 0x0020, 0x0178, -90 },
  { 0x0020, 0x201C, -30 },
  { 0x0020, 0x2018, -60 },
  { 0x0076, 0x0061, -25 },
  { 0x0076, 0x00E1, -25 },
  { 0x0076, 0x0103, -25 },
  { 0x0076, 0x00E2, -25 },
  { 0x0076, 0x00E4, -25 },
  { 0x0076, 0x00E0, -25 },
  { 0x0076, 0x0101, -25 },
  { 0x0076, 0x0105, -25 },
  { 0x0076, 0x00E5, -25 },
  { 0x0076, 0x00E3, -25 },
  { 0x0076, 0x002C, -80 },
  { 0x0076, 0x0065, -25 },
  { 0x0076, 0x00E9, -25 },
  { 0x0076, 0x011B, -25 },
  { 0x0076, 0x00EA, -25 },
  { 0x0076, 0x00EB, -25 },
  { 0x0076, 0x0117, -25 },
  { 0x0076, 0x00E8, -25 },
  { 0x0076, 0x0113, -25 },
  { 0x0076, 0x0119, -25 },
  { 0x0076, 0x006F, -25 },
  { 0x0076, 0x00F3, -25 },
  { 0x0076, 0x00F4, -25 },
  { 0x0076, 0x00F6, -25 },
  { 0x0076, 0x00F2, -25 },
  { 0x0076, 0x0151, -25 },
  { 0x0076, 0x014D, -25 },
  { 0x0076, 0x00F8, -25 },
  { 0x0076, 0x00F5, -25 },
  { 0x0076, 0x002E, -80 },
  { 0x0077, 0x0061, -15 },
  { 0x0077, 0x00E1, -15 },
  { 0x0077, 0x0103, -15 },
  { 0x0077, 0x00E2, -15 },
  { 0x0077, 0x00E4, -15 },
  { 0x0077, 0x00E0, -15 },
  { 0x0077, 0x0101, -15 },
  { 0x0077, 0x0105, -15 },
  { 0x0077, 0x00E5, -15 },
  { 0x0077, 0x00E3, -15 },
  { 0x0077, 0x002C, -60 },
  { 0x0077, 0x0065, -10 },
  { 0x0077, 0x00E9, -10 },
  { 0x0077, 0x011B, -10 },
  { 0x0077, 0x00EA, -10 },
  { 0x0077, 0x00EB, -10 },
  { 0x0077, 0x0117, -10 },
  { 0x0077, 0x00E8, -10 },
  { 0x0077, 0x0113, -10 },
  { 0x0077, 0x0119, -10 },
  { 0x0077, 0x006F, -10 },
  { 0x0077, 0x00F3, -10 },
  { 0x0077, 0x00F4, -10 },
  { 0x0077, 0x00F6, -10 },
  { 0x0077, 0x00F2, -10 },
  { 0x0077, 0x0151, -10 },
  { 0x0077, 0x014D, -10 },
  { 0x0077, 0x00F8, -10 },
  { 0x0077, 0x00F5, -10 },
  { 0x0077, 0x002E, -60 },
  { 0x0078, 0x0065, -30 },
  { 0x0078, 0x00E9, -30 },
  { 0x0078, 0x011B, -30 },
  { 0x0078, 0x00EA, -30 },
  { 0x0078, 0x00EB, -30 },
  { 0x0078, 0x0117, -30 },
  { 0x0078, 0x00E8, -30 },
  { 0x0078, 0x0113, -30 },
  { 0x0078, 0x0119, -30 },
  { 0x0079, 0x0061, -20 },
  { 0x0079, 0x00E1, -20 },
  { 0x0079, 0x0103, -20 },
  { 0x0079, 0x00E2, -20 },
  { 0x0079, 0x00E4, -20 },
  { 0x0079, 0x00E0, -20 },
  { 0x0079, 0x0101, -20 },
  { 0x0079, 0x0105, -20 },
  { 0x0079, 0x00E5, -20 },
  { 0x0079, 0x00E3, -20 },
  { 0x0079, 0x002C, -100 },
  { 0x0079, 0x0065, -20 },
  { 0x0079, 0x00E9, -20 },
  { 0x0079, 0x011B, -20 },
  { 0x0079, 0x00EA, -20 },
  { 0x0079, 0x00EB, -20 },
  { 0x0079, 0x0117, -20 },
  { 0x0079, 0x00E8, -20 },
  { 0x0079, 0x0113, -20 },
  { 0x0079, 0x0119, -20 },
  { 0x0079, 0x006F, -20 },
  { 0x0079, 0x00F3, -20 },
  { 0x0079, 0x00F4, -20 },
  { 0x0079, 0x00F6, -20 },
  { 0x0079, 0x00F2, -20 },
  { 0x0079, 0x0151, -20 },
  { 0x0079, 0x014D, -20 },
  { 0x0079, 0x00F8, -20 },
  { 0x0079, 0x00F5, -20 },
  { 0x0079, 0x002E, -100 },
  { 0x00FD, 0x0061, -20 },
  { 0x00FD, 0x00E1, -20 },
  { 0x00FD, 0x0103, -20 },
  { 0x00FD, 0x00E2, -20 },
  { 0x00FD, 0x00E4, -20 },
  { 0x00FD, 0x00E0, -20 },
  { 0x00FD, 0x0101, -20 },
  { 0x00FD, 0x0105, -20 },
  { 0x00FD, 0x00E5, -20 },
  { 0x00FD, 0x00E3, -20 },
  { 0x00FD, 0x002C, -100 },
  { 0x00FD, 0x0065, -20 },
  { 0x00FD, 0x00E9, -20 },
  { 0x00FD, 0x011B, -20 },
  { 0x00FD, 0x00EA, -20 },
  { 0x00FD, 0x00EB, -20 },
  { 0x00FD, 0x0117, -20 },
  { 0x00FD, 0x00E8, -20 },
  { 0x00FD, 0x0113, -20 },
  { 0x00FD, 0x0119, -20 },
  { 0x00FD, 0x006F, -20 },
  { 0x00FD, 0x00F3, -20 },
  { 0x00FD, 0x00F4, -20 },
  { 0x00FD, 0x00F6, -20 },
  { 0x00FD, 0x00F2, -20 },
  { 0x00FD, 0x0151, -20 },
  { 0x00FD, 0x014D, -20 },
  { 0x00FD, 0x00F8, -20 },
  { 0x00FD, 0x00F5, -20 },
  { 0x00FD, 0x002E, -100 },
  { 0x00FF, 0x0061, -20 },
  { 0x00FF, 0x00E1, -20 },
  { 0x00FF, 0x0103, -20 },
  { 0x00FF, 0x00E2, -20 },
  { 0x00FF, 0x00E4, -20 },
  { 0x00FF, 0x00E0, -20 },
  { 0x00FF, 0x0101, -20 },
  { 0x00FF, 0x0105, -20 },
  { 0x00FF, 0x00E5, -20 },
  { 0x00FF, 0x00E3, -20 },
  { 0x00FF, 0x002C, -100 },
  { 0x00FF, 0x0065, -20 },
  { 0x00FF, 0x00E9, -20 },
  { 0x00FF, 0x011B, -20 },
  { 0x00FF, 0x00EA, -20 },
  { 0x00FF, 0x00EB, -20 },
  { 0x00FF, 0x0117, -20 },
  { 0x00FF, 0x00E8, -20 },
  { 0x00FF, 0x0113, -20 },
  { 0x00FF, 0x0119, -20 },
  { 0x00FF, 0x006F, -20 },
  { 0x00FF, 0x00F3, -20 },
  { 0x00FF, 0x00F4, -20 },
  { 0x00FF, 0x00F6, -20 },
  { 0x00FF, 0x00F2, -20 },
  { 0x00FF, 0x0151, -20 },
  { 0x00FF, 0x014D, -20 },
  { 0x00FF, 0x00F8, -20 },
  { 0x00FF, 0x00F5, -20 },
  { 0x00FF, 0x002E, -100 },
  { 0x007A, 0x0065, -15 },
  { 0x007A, 0x00E9, -15 },
  { 0x007A, 0x011B, -15 },
  { 0x007A, 0x00EA, -15 },
  { 0x007A, 0x00EB, -15 },
  { 0x007A, 0x0117, -15 },
  { 0x007A, 0x00E8, -15 },
  { 0x007A, 0x0113, -15 },
  { 0x007A, 0x0119, -15 },
  { 0x007A, 0x006F, -15 },
  { 0x007A, 0x00F3, -15 },
  { 0x007A, 0x00F4, -15 },
  { 0x007A, 0x00F6, -15 },
  { 0x007A, 0x00F2, -15 },
  { 0x007A, 0x0151, -15 },
  { 0x007A, 0x014D, -15 },
  { 0x007A, 0x00F8, -15 },
  { 0x007A, 0x00F5, -15 },
  { 0x017A, 0x0065, -15 },
  { 0x017A, 0x00E9, -15 },
  { 0x017A, 0x011B, -15 },
  { 0x017A, 0x00EA, -15 },
  { 0x017A, 0x00EB, -15 },
  { 0x017A, 0x0117, -15 },
  { 0x017A, 0x00E8, -15 },
  { 0x017A, 0x0113, -15 },
  { 0x017A, 0x0119, -15 },
  { 0x017A, 0x006F, -15 },
  { 0x017A, 0x00F3, -15 },
  { 0x017A, 0x00F4, -15 },
  { 0x017A, 0x00F6, -15 },
  { 0x017A, 0x00F2, -15 },
  { 0x017A, 0x0151, -15 },
  { 0x017A, 0x014D, -15 },
  { 0x017A, 0x00F8, -15 },
  { 0x017A, 0x00F5, -15 },
  { 0x017E, 0x0065, -15 },
  { 0x017E, 0x00E9, -15 },
  { 0x017E, 0x011B, -15 },
  { 0x017E, 0x00EA, -15 },
  { 0x017E, 0x00EB, -15 },
  { 0x017E, 0x0117, -15 },
  { 0x017E, 0x00E8, -15 },
  { 0x017E, 0x0113, -15 },
  { 0x017E, 0x0119, -15 },
  { 0x017E, 0x006F, -15 },
  { 0x017E, 0x00F3, -15 },
  { 0x017E, 0x00F4, -15 },
  { 0x017E, 0x00F6, -15 },
  { 0x017E, 0x00F2, -15 },
  { 0x017E, 0x0151, -15 },
  { 0x017E, 0x014D, -15 },
  { 0x017E, 0x00F8, -15 },
  { 0x017E, 0x00F5, -15 },
  { 0x017C, 0x0065, -15 },
  { 0x017C, 0x00E9, -15 },
  { 0x017C, 0x011B, -15 },
  { 0x017C, 0x00EA, -15 },
  { 0x017C, 0x00EB, -15 },
  { 0x017C, 0x0117, -15 },
  { 0x017C, 0x00E8, -15 },
  { 0x017C, 0x0113, -15 },
  { 0x017C, 0x0119, -15 },
  { 0x017C, 0x006F, -15 },
  { 0x017C, 0x00F3, -15 },
  { 0x017C, 0x00F4, -15 },
  { 0x017C, 0x00F6, -15 },
  { 0x017C, 0x00F2, -15 },
  { 0x017C, 0x0151, -15 },
  { 0x017C, 0x014D, -15 },
  { 0x017C, 0x00F8, -15 },
  { 0x017C, 0x00F5, -15 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableHelveticaBold[] =
{
  { 0x0041, 0x0043, -40 },
  { 0x0041, 0x0106, -40 },
  { 0x0041, 0x010C, -40 },
  { 0x0041, 0x00C7, -40 },
  { 0x0041, 0x0047, -50 },
  { 0x0041, 0x011E, -50 },
  { 0x0041, 0x0122, -50 },
  { 0x0041, 0x004F, -40 },
  { 0x0041, 0x00D3, -40 },
  { 0x0041, 0x00D4, -40 },
  { 0x0041, 0x00D6, -40 },
  { 0x0041, 0x00D2, -40 },
  { 0x0041, 0x0150, -40 },
  { 0x0041, 0x014C, -40 },
  { 0x0041, 0x00D8, -40 },
  { 0x0041, 0x00D5, -40 },
  { 0x0041, 0x0051, -40 },
  { 0x0041, 0x0054, -90 },
  { 0x0041, 0x0164, -90 },
  { 0x0041, 0x0162, -90 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -80 },
  { 0x0041, 0x0057, -60 },
  { 0x0041, 0x0059, -110 },
  { 0x0041, 0x00DD, -110 },
  { 0x0041, 0x0178, -110 },
  { 0x0041, 0x0075, -30 },
  { 0x0041, 0x00FA, -30 },
  { 0x0041, 0x00FB, -30 },
  { 0x0041, 0x00FC, -30 },
  { 0x0041, 0x00F9, -30 },
  { 0x0041, 0x0171, -30 },
  { 0x0041, 0x016B, -30 },
  { 0x0041, 0x0173, -30 },
  { 0x0041, 0x016F, -30 },
  { 0x0041, 0x0076, -40 },
  { 0x0041, 0x0077, -30 },
  { 0x0041, 0x0079, -30 },
  { 0x0041, 0x00FD, -30 },
  { 0x0041, 0x00FF, -30 },
  { 0x00C1, 0x0043, -40 },
  { 0x00C1, 0x0106, -40 },
  { 0x00C1, 0x010C, -40 },
  { 0x00C1, 0x00C7, -40 },
  { 0x00C1, 0x0047, -50 },
  { 0x00C1, 0x011E, -50 },
  { 0x00C1, 0x0122, -50 },
  { 0x00C1, 0x004F, -40 },
  { 0x00C1, 0x00D3, -40 },
  { 0x00C1, 0x00D4, -40 },
  { 0x00C1, 0x00D6, -40 },
  { 0x00C1, 0x00D2, -40 },
  { 0x00C1, 0x0150, -40 },
  { 0x00C1, 0x014C, -40 },
  { 0x00C1, 0x00D8, -40 },
  { 0x00C1, 0x00D5, -40 },
  { 0x00C1, 0x0051, -40 },
  { 0x00C1, 0x0054, -90 },
  { 0x00C1, 0x0164, -90 },
  { 0x00C1, 0x0162, -90 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -80 },
  { 0x00C1, 0x0057, -60 },
  { 0x00C1, 0x0059, -110 },
  { 0x00C1, 0x00DD, -110 },
  { 0x00C1, 0x0178, -110 },
  { 0x00C1, 0x0075, -30 },
  { 0x00C1, 0x00FA, -30 },
  { 0x00C1, 0x00FB, -30 },
  { 0x00C1, 0x00FC, -30 },
  { 0x00C1, 0x00F9, -30 },
  { 0x00C1, 0x0171, -30 },
  { 0x00C1, 0x016B, -30 },
  { 0x00C1, 0x0173, -30 },
  { 0x00C1, 0x016F, -30 },
  { 0x00C1, 0x0076, -40 },
  { 0x00C1, 0x0077, -30 },
  { 0x00C1, 0x0079, -30 },
  { 0x00C1, 0x00FD, -30 },
  { 0x00C1, 0x00FF, -30 },
  { 0x0102, 0x0043, -40 },
  { 0x0102, 0x0106, -40 },
  { 0x0102, 0x010C, -40 },
  { 0x0102, 0x00C7, -40 },
  { 0x0102, 0x0047, -50 },
  { 0x0102, 0x011E, -50 },
  { 0x0102, 0x0122, -50 },
  { 0x0102, 0x004F, -40 },
  { 0x0102, 0x00D3, -40 },
  { 0x0102, 0x00D4, -40 },
  { 0x0102, 0x00D6, -40 },
  { 0x0102, 0x00D2, -40 },
  { 0x0102, 0x0150, -40 },
  { 0x0102, 0x014C, -40 },
  { 0x0102, 0x00D8, -40 },
  { 0x0102, 0x00D5, -40 },
  { 0x0102, 0x0051, -40 },
  { 0x0102, 0x0054, -90 },
  { 0x0102, 0x0164, -90 },
  { 0x0102, 0x0162, -90 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -80 },
  { 0x0102, 0x0057, -60 },
  { 0x0102, 0x0059, -110 },
  { 0x0102, 0x00DD, -110 },
  { 0x0102, 0x0178, -110 },
  { 0x0102, 0x0075, -30 },
  { 0x0102, 0x00FA, -30 },
  { 0x0102, 0x00FB, -30 },
  { 0x0102, 0x00FC, -30 },
  { 0x0102, 0x00F9, -30 },
  { 0x0102, 0x0171, -30 },
  { 0x0102, 0x016B, -30 },
  { 0x0102, 0x0173, -30 },
  { 0x0102, 0x016F, -30 },
  { 0x0102, 0x0076, -40 },
  { 0x0102, 0x0077, -30 },
  { 0x0102, 0x0079, -30 },
  { 0x0102, 0x00FD, -30 },
  { 0x0102, 0x00FF, -30 },
  { 0x00C2, 0x0043, -40 },
  { 0x00C2, 0x0106, -40 },
  { 0x00C2, 0x010C, -40 },
  { 0x00C2, 0x00C7, -40 },
  { 0x00C2, 0x0047, -50 },
  { 0x00C2, 0x011E, -50 },
  { 0x00C2, 0x0122, -50 },
  { 0x00C2, 0x004F, -40 },
  { 0x00C2, 0x00D3, -40 },
  { 0x00C2, 0x00D4, -40 },
  { 0x00C2, 0x00D6, -40 },
  { 0x00C2, 0x00D2, -40 },
  { 0x00C2, 0x0150, -40 },
  { 0x00C2, 0x014C, -40 },
  { 0x00C2, 0x00D8, -40 },
  { 0x00C2, 0x00D5, -40 },
  { 0x00C2, 0x0051, -40 },
  { 0x00C2, 0x0054, -90 },
  { 0x00C2, 0x0164, -90 },
  { 0x00C2, 0x0162, -90 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -80 },
  { 0x00C2, 0x0057, -60 },
  { 0x00C2, 0x0059, -110 },
  { 0x00C2, 0x00DD, -110 },
  { 0x00C2, 0x0178, -110 },
  { 0x00C2, 0x0075, -30 },
  { 0x00C2, 0x00FA, -30 },
  { 0x00C2, 0x00FB, -30 },
  { 0x00C2, 0x00FC, -30 },
  { 0x00C2, 0x00F9, -30 },
  { 0x00C2, 0x0171, -30 },
  { 0x00C2, 0x016B, -30 },
  { 0x00C2, 0x0173, -30 },
  { 0x00C2, 0x016F, -30 },
  { 0x00C2, 0x0076, -40 },
  { 0x00C2, 0x0077, -30 },
  { 0x00C2, 0x0079, -30 },
  { 0x00C2, 0x00FD, -30 },
  { 0x00C2, 0x00FF, -30 },
  { 0x00C4, 0x0043, -40 },
  { 0x00C4, 0x0106, -40 },
  { 0x00C4, 0x010C, -40 },
  { 0x00C4, 0x00C7, -40 },
  { 0x00C4, 0x0047, -50 },
  { 0x00C4, 0x011E, -50 },
  { 0x00C4, 0x0122, -50 },
  { 0x00C4, 0x004F, -40 },
  { 0x00C4, 0x00D3, -40 },
  { 0x00C4, 0x00D4, -40 },
  { 0x00C4, 0x00D6, -40 },
  { 0x00C4, 0x00D2, -40 },
  { 0x00C4, 0x0150, -40 },
  { 0x00C4, 0x014C, -40 },
  { 0x00C4, 0x00D8, -40 },
  { 0x00C4, 0x00D5, -40 },
  { 0x00C4, 0x0051, -40 },
  { 0x00C4, 0x0054, -90 },
  { 0x00C4, 0x0164, -90 },
  { 0x00C4, 0x0162, -90 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -80 },
  { 0x00C4, 0x0057, -60 },
  { 0x00C4, 0x0059, -110 },
  { 0x00C4, 0x00DD, -110 },
  { 0x00C4, 0x0178, -110 },
  { 0x00C4, 0x0075, -30 },
  { 0x00C4, 0x00FA, -30 },
  { 0x00C4, 0x00FB, -30 },
  { 0x00C4, 0x00FC, -30 },
  { 0x00C4, 0x00F9, -30 },
  { 0x00C4, 0x0171, -30 },
  { 0x00C4, 0x016B, -30 },
  { 0x00C4, 0x0173, -30 },
  { 0x00C4, 0x016F, -30 },
  { 0x00C4, 0x0076, -40 },
  { 0x00C4, 0x0077, -30 },
  { 0x00C4, 0x0079, -30 },
  { 0x00C4, 0x00FD, -30 },
  { 0x00C4, 0x00FF, -30 },
  { 0x00C0, 0x0043, -40 },
  { 0x00C0, 0x0106, -40 },
  { 0x00C0, 0x010C, -40 },
  { 0x00C0, 0x00C7, -40 },
  { 0x00C0, 0x0047, -50 },
  { 0x00C0, 0x011E, -50 },
  { 0x00C0, 0x0122, -50 },
  { 0x00C0, 0x004F, -40 },
  { 0x00C0, 0x00D3, -40 },
  { 0x00C0, 0x00D4, -40 },
  { 0x00C0, 0x00D6, -40 },
  { 0x00C0, 0x00D2, -40 },
  { 0x00C0, 0x0150, -40 },
  { 0x00C0, 0x014C, -40 },
  { 0x00C0, 0x00D8, -40 },
  { 0x00C0, 0x00D5, -40 },
  { 0x00C0, 0x0051, -40 },
  { 0x00C0, 0x0054, -90 },
  { 0x00C0, 0x0164, -90 },
  { 0x00C0, 0x0162, -90 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -80 },
  { 0x00C0, 0x0057, -60 },
  { 0x00C0, 0x0059, -110 },
  { 0x00C0, 0x00DD, -110 },
  { 0x00C0, 0x0178, -110 },
  { 0x00C0, 0x0075, -30 },
  { 0x00C0, 0x00FA, -30 },
  { 0x00C0, 0x00FB, -30 },
  { 0x00C0, 0x00FC, -30 },
  { 0x00C0, 0x00F9, -30 },
  { 0x00C0, 0x0171, -30 },
  { 0x00C0, 0x016B, -30 },
  { 0x00C0, 0x0173, -30 },
  { 0x00C0, 0x016F, -30 },
  { 0x00C0, 0x0076, -40 },
  { 0x00C0, 0x0077, -30 },
  { 0x00C0, 0x0079, -30 },
  { 0x00C0, 0x00FD, -30 },
  { 0x00C0, 0x00FF, -30 },
  { 0x0100, 0x0043, -40 },
  { 0x0100, 0x0106, -40 },
  { 0x0100, 0x010C, -40 },
  { 0x0100, 0x00C7, -40 },
  { 0x0100, 0x0047, -50 },
  { 0x0100, 0x011E, -50 },
  { 0x0100, 0x0122, -50 },
  { 0x0100, 0x004F, -40 },
  { 0x0100, 0x00D3, -40 },
  { 0x0100, 0x00D4, -40 },
  { 0x0100, 0x00D6, -40 },
  { 0x0100, 0x00D2, -40 },
  { 0x0100, 0x0150, -40 },
  { 0x0100, 0x014C, -40 },
  { 0x0100, 0x00D8, -40 },
  { 0x0100, 0x00D5, -40 },
  { 0x0100, 0x0051, -40 },
  { 0x0100, 0x0054, -90 },
  { 0x0100, 0x0164, -90 },
  { 0x0100, 0x0162, -90 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -80 },
  { 0x0100, 0x0057, -60 },
  { 0x0100, 0x0059, -110 },
  { 0x0100, 0x00DD, -110 },
  { 0x0100, 0x0178, -110 },
  { 0x0100, 0x0075, -30 },
  { 0x0100, 0x00FA, -30 },
  { 0x0100, 0x00FB, -30 },
  { 0x0100, 0x00FC, -30 },
  { 0x0100, 0x00F9, -30 },
  { 0x0100, 0x0171, -30 },
  { 0x0100, 0x016B, -30 },
  { 0x0100, 0x0173, -30 },
  { 0x0100, 0x016F, -30 },
  { 0x0100, 0x0076, -40 },
  { 0x0100, 0x0077, -30 },
  { 0x0100, 0x0079, -30 },
  { 0x0100, 0x00FD, -30 },
  { 0x0100, 0x00FF, -30 },
  { 0x0104, 0x0043, -40 },
  { 0x0104, 0x0106, -40 },
  { 0x0104, 0x010C, -40 },
  { 0x0104, 0x00C7, -40 },
  { 0x0104, 0x0047, -50 },
  { 0x0104, 0x011E, -50 },
  { 0x0104, 0x0122, -50 },
  { 0x0104, 0x004F, -40 },
  { 0x0104, 0x00D3, -40 },
  { 0x0104, 0x00D4, -40 },
  { 0x0104, 0x00D6, -40 },
  { 0x0104, 0x00D2, -40 },
  { 0x0104, 0x0150, -40 },
  { 0x0104, 0x014C, -40 },
  { 0x0104, 0x00D8, -40 },
  { 0x0104, 0x00D5, -40 },
  { 0x0104, 0x0051, -40 },
  { 0x0104, 0x0054, -90 },
  { 0x0104, 0x0164, -90 },
  { 0x0104, 0x0162, -90 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -80 },
  { 0x0104, 0x0057, -60 },
  { 0x0104, 0x0059, -110 },
  { 0x0104, 0x00DD, -110 },
  { 0x0104, 0x0178, -110 },
  { 0x0104, 0x0075, -30 },
  { 0x0104, 0x00FA, -30 },
  { 0x0104, 0x00FB, -30 },
  { 0x0104, 0x00FC, -30 },
  { 0x0104, 0x00F9, -30 },
  { 0x0104, 0x0171, -30 },
  { 0x0104, 0x016B, -30 },
  { 0x0104, 0x0173, -30 },
  { 0x0104, 0x016F, -30 },
  { 0x0104, 0x0076, -40 },
  { 0x0104, 0x0077, -30 },
  { 0x0104, 0x0079, -30 },
  { 0x0104, 0x00FD, -30 },
  { 0x0104, 0x00FF, -30 },
  { 0x00C5, 0x0043, -40 },
  { 0x00C5, 0x0106, -40 },
  { 0x00C5, 0x010C, -40 },
  { 0x00C5, 0x00C7, -40 },
  { 0x00C5, 0x0047, -50 },
  { 0x00C5, 0x011E, -50 },
  { 0x00C5, 0x0122, -50 },
  { 0x00C5, 0x004F, -40 },
  { 0x00C5, 0x00D3, -40 },
  { 0x00C5, 0x00D4, -40 },
  { 0x00C5, 0x00D6, -40 },
  { 0x00C5, 0x00D2, -40 },
  { 0x00C5, 0x0150, -40 },
  { 0x00C5, 0x014C, -40 },
  { 0x00C5, 0x00D8, -40 },
  { 0x00C5, 0x00D5, -40 },
  { 0x00C5, 0x0051, -40 },
  { 0x00C5, 0x0054, -90 },
  { 0x00C5, 0x0164, -90 },
  { 0x00C5, 0x0162, -90 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -80 },
  { 0x00C5, 0x0057, -60 },
  { 0x00C5, 0x0059, -110 },
  { 0x00C5, 0x00DD, -110 },
  { 0x00C5, 0x0178, -110 },
  { 0x00C5, 0x0075, -30 },
  { 0x00C5, 0x00FA, -30 },
  { 0x00C5, 0x00FB, -30 },
  { 0x00C5, 0x00FC, -30 },
  { 0x00C5, 0x00F9, -30 },
  { 0x00C5, 0x0171, -30 },
  { 0x00C5, 0x016B, -30 },
  { 0x00C5, 0x0173, -30 },
  { 0x00C5, 0x016F, -30 },
  { 0x00C5, 0x0076, -40 },
  { 0x00C5, 0x0077, -30 },
  { 0x00C5, 0x0079, -30 },
  { 0x00C5, 0x00FD, -30 },
  { 0x00C5, 0x00FF, -30 },
  { 0x00C3, 0x0043, -40 },
  { 0x00C3, 0x0106, -40 },
  { 0x00C3, 0x010C, -40 },
  { 0x00C3, 0x00C7, -40 },
  { 0x00C3, 0x0047, -50 },
  { 0x00C3, 0x011E, -50 },
  { 0x00C3, 0x0122, -50 },
  { 0x00C3, 0x004F, -40 },
  { 0x00C3, 0x00D3, -40 },
  { 0x00C3, 0x00D4, -40 },
  { 0x00C3, 0x00D6, -40 },
  { 0x00C3, 0x00D2, -40 },
  { 0x00C3, 0x0150, -40 },
  { 0x00C3, 0x014C, -40 },
  { 0x00C3, 0x00D8, -40 },
  { 0x00C3, 0x00D5, -40 },
  { 0x00C3, 0x0051, -40 },
  { 0x00C3, 0x0054, -90 },
  { 0x00C3, 0x0164, -90 },
  { 0x00C3, 0x0162, -90 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -80 },
  { 0x00C3, 0x0057, -60 },
  { 0x00C3, 0x0059, -110 },
  { 0x00C3, 0x00DD, -110 },
  { 0x00C3, 0x0178, -110 },
  { 0x00C3, 0x0075, -30 },
  { 0x00C3, 0x00FA, -30 },
  { 0x00C3, 0x00FB, -30 },
  { 0x00C3, 0x00FC, -30 },
  { 0x00C3, 0x00F9, -30 },
  { 0x00C3, 0x0171, -30 },
  { 0x00C3, 0x016B, -30 },
  { 0x00C3, 0x0173, -30 },
  { 0x00C3, 0x016F, -30 },
  { 0x00C3, 0x0076, -40 },
  { 0x00C3, 0x0077, -30 },
  { 0x00C3, 0x0079, -30 },
  { 0x00C3, 0x00FD, -30 },
  { 0x00C3, 0x00FF, -30 },
  { 0x0042, 0x0041, -30 },
  { 0x0042, 0x00C1, -30 },
  { 0x0042, 0x0102, -30 },
  { 0x0042, 0x00C2, -30 },
  { 0x0042, 0x00C4, -30 },
  { 0x0042, 0x00C0, -30 },
  { 0x0042, 0x0100, -30 },
  { 0x0042, 0x0104, -30 },
  { 0x0042, 0x00C5, -30 },
  { 0x0042, 0x00C3, -30 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0044, 0x0041, -40 },
  { 0x0044, 0x00C1, -40 },
  { 0x0044, 0x0102, -40 },
  { 0x0044, 0x00C2, -40 },
  { 0x0044, 0x00C4, -40 },
  { 0x0044, 0x00C0, -40 },
  { 0x0044, 0x0100, -40 },
  { 0x0044, 0x0104, -40 },
  { 0x0044, 0x00C5, -40 },
  { 0x0044, 0x00C3, -40 },
  { 0x0044, 0x0056, -40 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -70 },
  { 0x0044, 0x00DD, -70 },
  { 0x0044, 0x0178, -70 },
  { 0x0044, 0x002C, -30 },
  { 0x0044, 0x002E, -30 },
  { 0x010E, 0x0041, -40 },
  { 0x010E, 0x00C1, -40 },
  { 0x010E, 0x0102, -40 },
  { 0x010E, 0x00C2, -40 },
  { 0x010E, 0x00C4, -40 },
  { 0x010E, 0x00C0, -40 },
  { 0x010E, 0x0100, -40 },
  { 0x010E, 0x0104, -40 },
  { 0x010E, 0x00C5, -40 },
  { 0x010E, 0x00C3, -40 },
  { 0x010E, 0x0056, -40 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -70 },
  { 0x010E, 0x00DD, -70 },
  { 0x010E, 0x0178, -70 },
  { 0x010E, 0x002C, -30 },
  { 0x010E, 0x002E, -30 },
  { 0x0110, 0x0041, -40 },
  { 0x0110, 0x00C1, -40 },
  { 0x0110, 0x0102, -40 },
  { 0x0110, 0x00C2, -40 },
  { 0x0110, 0x00C4, -40 },
  { 0x0110, 0x00C0, -40 },
  { 0x0110, 0x0100, -40 },
  { 0x0110, 0x0104, -40 },
  { 0x0110, 0x00C5, -40 },
  { 0x0110, 0x00C3, -40 },
  { 0x0110, 0x0056, -40 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -70 },
  { 0x0110, 0x00DD, -70 },
  { 0x0110, 0x0178, -70 },
  { 0x0110, 0x002C, -30 },
  { 0x0110, 0x002E, -30 },
  { 0x0046, 0x0041, -80 },
  { 0x0046, 0x00C1, -80 },
  { 0x0046, 0x0102, -80 },
  { 0x0046, 0x00C2, -80 },
  { 0x0046, 0x00C4, -80 },
  { 0x0046, 0x00C0, -80 },
  { 0x0046, 0x0100, -80 },
  { 0x0046, 0x0104, -80 },
  { 0x0046, 0x00C5, -80 },
  { 0x0046, 0x00C3, -80 },
  { 0x0046, 0x0061, -20 },
  { 0x0046, 0x00E1, -20 },
  { 0x0046, 0x0103, -20 },
  { 0x0046, 0x00E2, -20 },
  { 0x0046, 0x00E4, -20 },
  { 0x0046, 0x00E0, -20 },
  { 0x0046, 0x0101, -20 },
  { 0x0046, 0x0105, -20 },
  { 0x0046, 0x00E5, -20 },
  { 0x0046, 0x00E3, -20 },
  { 0x0046, 0x002C, -100 },
  { 0x0046, 0x002E, -100 },
  { 0x004A, 0x0041, -20 },
  { 0x004A, 0x00C1, -20 },
  { 0x004A, 0x0102, -20 },
  { 0x004A, 0x00C2, -20 },
  { 0x004A, 0x00C4, -20 },
  { 0x004A, 0x00C0, -20 },
  { 0x004A, 0x0100, -20 },
  { 0x004A, 0x0104, -20 },
  { 0x004A, 0x00C5, -20 },
  { 0x004A, 0x00C3, -20 },
  { 0x004A, 0x002C, -20 },
  { 0x004A, 0x002E, -20 },
  { 0x004A, 0x0075, -20 },
  { 0x004A, 0x00FA, -20 },
  { 0x004A, 0x00FB, -20 },
  { 0x004A, 0x00FC, -20 },
  { 0x004A, 0x00F9, -20 },
  { 0x004A, 0x0171, -20 },
  { 0x004A, 0x016B, -20 },
  { 0x004A, 0x0173, -20 },
  { 0x004A, 0x016F, -20 },
  { 0x004B, 0x004F, -30 },
  { 0x004B, 0x00D3, -30 },
  { 0x004B, 0x00D4, -30 },
  { 0x004B, 0x00D6, -30 },
  { 0x004B, 0x00D2, -30 },
  { 0x004B, 0x0150, -30 },
  { 0x004B, 0x014C, -30 },
  { 0x004B, 0x00D8, -30 },
  { 0x004B, 0x00D5, -30 },
  { 0x004B, 0x0065, -15 },
  { 0x004B, 0x00E9, -15 },
  { 0x004B, 0x011B, -15 },
  { 0x004B, 0x00EA, -15 },
  { 0x004B, 0x00EB, -15 },
  { 0x004B, 0x0117, -15 },
  { 0x004B, 0x00E8, -15 },
  { 0x004B, 0x0113, -15 },
  { 0x004B, 0x0119, -15 },
  { 0x004B, 0x006F, -35 },
  { 0x004B, 0x00F3, -35 },
  { 0x004B, 0x00F4, -35 },
  { 0x004B, 0x00F6, -35 },
  { 0x004B, 0x00F2, -35 },
  { 0x004B, 0x0151, -35 },
  { 0x004B, 0x014D, -35 },
  { 0x004B, 0x00F8, -35 },
  { 0x004B, 0x00F5, -35 },
  { 0x004B, 0x0075, -30 },
  { 0x004B, 0x00FA, -30 },
  { 0x004B, 0x00FB, -30 },
  { 0x004B, 0x00FC, -30 },
  { 0x004B, 0x00F9, -30 },
  { 0x004B, 0x0171, -30 },
  { 0x004B, 0x016B, -30 },
  { 0x004B, 0x0173, -30 },
  { 0x004B, 0x016F, -30 },
  { 0x004B, 0x0079, -40 },
  { 0x004B, 0x00FD, -40 },
  { 0x004B, 0x00FF, -40 },
  { 0x0136, 0x004F, -30 },
  { 0x0136, 0x00D3, -30 },
  { 0x0136, 0x00D4, -30 },
  { 0x0136, 0x00D6, -30 },
  { 0x0136, 0x00D2, -30 },
  { 0x0136, 0x0150, -30 },
  { 0x0136, 0x014C, -30 },
  { 0x0136, 0x00D8, -30 },
  { 0x0136, 0x00D5, -30 },
  { 0x0136, 0x0065, -15 },
  { 0x0136, 0x00E9, -15 },
  { 0x0136, 0x011B, -15 },
  { 0x0136, 0x00EA, -15 },
  { 0x0136, 0x00EB, -15 },
  { 0x0136, 0x0117, -15 },
  { 0x0136, 0x00E8, -15 },
  { 0x0136, 0x0113, -15 },
  { 0x0136, 0x0119, -15 },
  { 0x0136, 0x006F, -35 },
  { 0x0136, 0x00F3, -35 },
  { 0x0136, 0x00F4, -35 },
  { 0x0136, 0x00F6, -35 },
  { 0x0136, 0x00F2, -35 },
  { 0x0136, 0x0151, -35 },
  { 0x0136, 0x014D, -35 },
  { 0x0136, 0x00F8, -35 },
  { 0x0136, 0x00F5, -35 },
  { 0x0136, 0x0075, -30 },
  { 0x0136, 0x00FA, -30 },
  { 0x0136, 0x00FB, -30 },
  { 0x0136, 0x00FC, -30 },
  { 0x0136, 0x00F9, -30 },
  { 0x0136, 0x0171, -30 },
  { 0x0136, 0x016B, -30 },
  { 0x0136, 0x0173, -30 },
  { 0x0136, 0x016F, -30 },
  { 0x0136, 0x0079, -40 },
  { 0x0136, 0x00FD, -40 },
  { 0x0136, 0x00FF, -40 },
  { 0x004C, 0x0054, -90 },
  { 0x004C, 0x0164, -90 },
  { 0x004C, 0x0162, -90 },
  { 0x004C, 0x0056, -110 },
  { 0x004C, 0x0057, -80 },
  { 0x004C, 0x0059, -120 },
  { 0x004C, 0x00DD, -120 },
  { 0x004C, 0x0178, -120 },
  { 0x004C, 0x201D, -140 },
  { 0x004C, 0x2019, -140 },
  { 0x004C, 0x0079, -30 },
  { 0x004C, 0x00FD, -30 },
  { 0x004C, 0x00FF, -30 },
  { 0x0139, 0x0054, -90 },
  { 0x0139, 0x0164, -90 },
  { 0x0139, 0x0162, -90 },
  { 0x0139, 0x0056, -110 },
  { 0x0139, 0x0057, -80 },
  { 0x0139, 0x0059, -120 },
  { 0x0139, 0x00DD, -120 },
  { 0x0139, 0x0178, -120 },
  { 0x0139, 0x201D, -140 },
  { 0x0139, 0x2019, -140 },
  { 0x0139, 0x0079, -30 },
  { 0x0139, 0x00FD, -30 },
  { 0x0139, 0x00FF, -30 },
  { 0x013B, 0x0054, -90 },
  { 0x013B, 0x0164, -90 },
  { 0x013B, 0x0162, -90 },
  { 0x013B, 0x0056, -110 },
  { 0x013B, 0x0057, -80 },
  { 0x013B, 0x0059, -120 },
  { 0x013B, 0x00DD, -120 },
  { 0x013B, 0x0178, -120 },
  { 0x013B, 0x201D, -140 },
  { 0x013B, 0x2019, -140 },
  { 0x013B, 0x0079, -30 },
  { 0x013B, 0x00FD, -30 },
  { 0x013B, 0x00FF, -30 },
  { 0x0141, 0x0054, -90 },
  { 0x0141, 0x0164, -90 },
  { 0x0141, 0x0162, -90 },
  { 0x0141, 0x0056, -110 },
  { 0x0141, 0x0057, -80 },
  { 0x0141, 0x0059, -120 },
  { 0x0141, 0x00DD, -120 },
  { 0x0141, 0x0178, -120 },
  { 0x0141, 0x201D, -140 },
  { 0x0141, 0x2019, -140 },
  { 0x0141, 0x0079, -30 },
  { 0x0141, 0x00FD, -30 },
  { 0x0141, 0x00FF, -30 },
  { 0x004F, 0x0041, -50 },
  { 0x004F, 0x00C1, -50 },
  { 0x004F, 0x0102, -50 },
  { 0x004F, 0x00C2, -50 },
  { 0x004F, 0x00C4, -50 },
  { 0x004F, 0x00C0, -50 },
  { 0x004F, 0x0100, -50 },
  { 0x004F, 0x0104, -50 },
  { 0x004F, 0x00C5, -50 },
  { 0x004F, 0x00C3, -50 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -50 },
  { 0x004F, 0x0058, -50 },
  { 0x004F, 0x0059, -70 },
  { 0x004F, 0x00DD, -70 },
  { 0x004F, 0x0178, -70 },
  { 0x004F, 0x002C, -40 },
  { 0x004F, 0x002E, -40 },
  { 0x00D3, 0x0041, -50 },
  { 0x00D3, 0x00C1, -50 },
  { 0x00D3, 0x0102, -50 },
  { 0x00D3, 0x00C2, -50 },
  { 0x00D3, 0x00C4, -50 },
  { 0x00D3, 0x00C0, -50 },
  { 0x00D3, 0x0100, -50 },
  { 0x00D3, 0x0104, -50 },
  { 0x00D3, 0x00C5, -50 },
  { 0x00D3, 0x00C3, -50 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -50 },
  { 0x00D3, 0x0058, -50 },
  { 0x00D3, 0x0059, -70 },
  { 0x00D3, 0x00DD, -70 },
  { 0x00D3, 0x0178, -70 },
  { 0x00D3, 0x002C, -40 },
  { 0x00D3, 0x002E, -40 },
  { 0x00D4, 0x0041, -50 },
  { 0x00D4, 0x00C1, -50 },
  { 0x00D4, 0x0102, -50 },
  { 0x00D4, 0x00C2, -50 },
  { 0x00D4, 0x00C4, -50 },
  { 0x00D4, 0x00C0, -50 },
  { 0x00D4, 0x0100, -50 },
  { 0x00D4, 0x0104, -50 },
  { 0x00D4, 0x00C5, -50 },
  { 0x00D4, 0x00C3, -50 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -50 },
  { 0x00D4, 0x0058, -50 },
  { 0x00D4, 0x0059, -70 },
  { 0x00D4, 0x00DD, -70 },
  { 0x00D4, 0x0178, -70 },
  { 0x00D4, 0x002C, -40 },
  { 0x00D4, 0x002E, -40 },
  { 0x00D6, 0x0041, -50 },
  { 0x00D6, 0x00C1, -50 },
  { 0x00D6, 0x0102, -50 },
  { 0x00D6, 0x00C2, -50 },
  { 0x00D6, 0x00C4, -50 },
  { 0x00D6, 0x00C0, -50 },
  { 0x00D6, 0x0100, -50 },
  { 0x00D6, 0x0104, -50 },
  { 0x00D6, 0x00C5, -50 },
  { 0x00D6, 0x00C3, -50 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -50 },
  { 0x00D6, 0x0058, -50 },
  { 0x00D6, 0x0059, -70 },
  { 0x00D6, 0x00DD, -70 },
  { 0x00D6, 0x0178, -70 },
  { 0x00D6, 0x002C, -40 },
  { 0x00D6, 0x002E, -40 },
  { 0x00D2, 0x0041, -50 },
  { 0x00D2, 0x00C1, -50 },
  { 0x00D2, 0x0102, -50 },
  { 0x00D2, 0x00C2, -50 },
  { 0x00D2, 0x00C4, -50 },
  { 0x00D2, 0x00C0, -50 },
  { 0x00D2, 0x0100, -50 },
  { 0x00D2, 0x0104, -50 },
  { 0x00D2, 0x00C5, -50 },
  { 0x00D2, 0x00C3, -50 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -50 },
  { 0x00D2, 0x0058, -50 },
  { 0x00D2, 0x0059, -70 },
  { 0x00D2, 0x00DD, -70 },
  { 0x00D2, 0x0178, -70 },
  { 0x00D2, 0x002C, -40 },
  { 0x00D2, 0x002E, -40 },
  { 0x0150, 0x0041, -50 },
  { 0x0150, 0x00C1, -50 },
  { 0x0150, 0x0102, -50 },
  { 0x0150, 0x00C2, -50 },
  { 0x0150, 0x00C4, -50 },
  { 0x0150, 0x00C0, -50 },
  { 0x0150, 0x0100, -50 },
  { 0x0150, 0x0104, -50 },
  { 0x0150, 0x00C5, -50 },
  { 0x0150, 0x00C3, -50 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -50 },
  { 0x0150, 0x0058, -50 },
  { 0x0150, 0x0059, -70 },
  { 0x0150, 0x00DD, -70 },
  { 0x0150, 0x0178, -70 },
  { 0x0150, 0x002C, -40 },
  { 0x0150, 0x002E, -40 },
  { 0x014C, 0x0041, -50 },
  { 0x014C, 0x00C1, -50 },
  { 0x014C, 0x0102, -50 },
  { 0x014C, 0x00C2, -50 },
  { 0x014C, 0x00C4, -50 },
  { 0x014C, 0x00C0, -50 },
  { 0x014C, 0x0100, -50 },
  { 0x014C, 0x0104, -50 },
  { 0x014C, 0x00C5, -50 },
  { 0x014C, 0x00C3, -50 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -50 },
  { 0x014C, 0x0058, -50 },
  { 0x014C, 0x0059, -70 },
  { 0x014C, 0x00DD, -70 },
  { 0x014C, 0x0178, -70 },
  { 0x014C, 0x002C, -40 },
  { 0x014C, 0x002E, -40 },
  { 0x00D8, 0x0041, -50 },
  { 0x00D8, 0x00C1, -50 },
  { 0x00D8, 0x0102, -50 },
  { 0x00D8, 0x00C2, -50 },
  { 0x00D8, 0x00C4, -50 },
  { 0x00D8, 0x00C0, -50 },
  { 0x00D8, 0x0100, -50 },
  { 0x00D8, 0x0104, -50 },
  { 0x00D8, 0x00C5, -50 },
  { 0x00D8, 0x00C3, -50 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -50 },
  { 0x00D8, 0x0058, -50 },
  { 0x00D8, 0x0059, -70 },
  { 0x00D8, 0x00DD, -70 },
  { 0x00D8, 0x0178, -70 },
  { 0x00D8, 0x002C, -40 },
  { 0x00D8, 0x002E, -40 },
  { 0x00D5, 0x0041, -50 },
  { 0x00D5, 0x00C1, -50 },
  { 0x00D5, 0x0102, -50 },
  { 0x00D5, 0x00C2, -50 },
  { 0x00D5, 0x00C4, -50 },
  { 0x00D5, 0x00C0, -50 },
  { 0x00D5, 0x0100, -50 },
  { 0x00D5, 0x0104, -50 },
  { 0x00D5, 0x00C5, -50 },
  { 0x00D5, 0x00C3, -50 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -50 },
  { 0x00D5, 0x0058, -50 },
  { 0x00D5, 0x0059, -70 },
  { 0x00D5, 0x00DD, -70 },
  { 0x00D5, 0x0178, -70 },
  { 0x00D5, 0x002C, -40 },
  { 0x00D5, 0x002E, -40 },
  { 0x0050, 0x0041, -100 },
  { 0x0050, 0x00C1, -100 },
  { 0x0050, 0x0102, -100 },
  { 0x0050, 0x00C2, -100 },
  { 0x0050, 0x00C4, -100 },
  { 0x0050, 0x00C0, -100 },
  { 0x0050, 0x0100, -100 },
  { 0x0050, 0x0104, -100 },
  { 0x0050, 0x00C5, -100 },
  { 0x0050, 0x00C3, -100 },
  { 0x0050, 0x0061, -30 },
  { 0x0050, 0x00E1, -30 },
  { 0x0050, 0x0103, -30 },
  { 0x0050, 0x00E2, -30 },
  { 0x0050, 0x00E4, -30 },
  { 0x0050, 0x00E0, -30 },
  { 0x0050, 0x0101, -30 },
  { 0x0050, 0x0105, -30 },
  { 0x0050, 0x00E5, -30 },
  { 0x0050, 0x00E3, -30 },
  { 0x0050, 0x002C, -120 },
  { 0x0050, 0x0065, -30 },
  { 0x0050, 0x00E9, -30 },
  { 0x0050, 0x011B, -30 },
  { 0x0050, 0x00EA, -30 },
  { 0x0050, 0x00EB, -30 },
  { 0x0050, 0x0117, -30 },
  { 0x0050, 0x00E8, -30 },
  { 0x0050, 0x0113, -30 },
  { 0x0050, 0x0119, -30 },
  { 0x0050, 0x006F, -40 },
  { 0x0050, 0x00F3, -40 },
  { 0x0050, 0x00F4, -40 },
  { 0x0050, 0x00F6, -40 },
  { 0x0050, 0x00F2, -40 },
  { 0x0050, 0x0151, -40 },
  { 0x0050, 0x014D, -40 },
  { 0x0050, 0x00F8, -40 },
  { 0x0050, 0x00F5, -40 },
  { 0x0050, 0x002E, -120 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0051, 0x002C, 20 },
  { 0x0051, 0x002E, 20 },
  { 0x0052, 0x004F, -20 },
  { 0x0052, 0x00D3, -20 },
  { 0x0052, 0x00D4, -20 },
  { 0x0052, 0x00D6, -20 },
  { 0x0052, 0x00D2, -20 },
  { 0x0052, 0x0150, -20 },
  { 0x0052, 0x014C, -20 },
  { 0x0052, 0x00D8, -20 },
  { 0x0052, 0x00D5, -20 },
  { 0x0052, 0x0054, -20 },
  { 0x0052, 0x0164, -20 },
  { 0x0052, 0x0162, -20 },
  { 0x0052, 0x0055, -20 },
  { 0x0052, 0x00DA, -20 },
  { 0x0052, 0x00DB, -20 },
  { 0x0052, 0x00DC, -20 },
  { 0x0052, 0x00D9, -20 },
  { 0x0052, 0x0170, -20 },
  { 0x0052, 0x016A, -20 },
  { 0x0052, 0x0172, -20 },
  { 0x0052, 0x016E, -20 },
  { 0x0052, 0x0056, -50 },
  { 0x0052, 0x0057, -40 },
  { 0x0052, 0x0059, -50 },
  { 0x0052, 0x00DD, -50 },
  { 0x0052, 0x0178, -50 },
  { 0x0154, 0x004F, -20 },
  { 0x0154, 0x00D3, -20 },
  { 0x0154, 0x00D4, -20 },
  { 0x0154, 0x00D6, -20 },
  { 0x0154, 0x00D2, -20 },
  { 0x0154, 0x0150, -20 },
  { 0x0154, 0x014C, -20 },
  { 0x0154, 0x00D8, -20 },
  { 0x0154, 0x00D5, -20 },
  { 0x0154, 0x0054, -20 },
  { 0x0154, 0x0164, -20 },
  { 0x0154, 0x0162, -20 },
  { 0x0154, 0x0055, -20 },
  { 0x0154, 0x00DA, -20 },
  { 0x0154, 0x00DB, -20 },
  { 0x0154, 0x00DC, -20 },
  { 0x0154, 0x00D9, -20 },
  { 0x0154, 0x0170, -20 },
  { 0x0154, 0x016A, -20 },
  { 0x0154, 0x0172, -20 },
  { 0x0154, 0x016E, -20 },
  { 0x0154, 0x0056, -50 },
  { 0x0154, 0x0057, -40 },
  { 0x0154, 0x0059, -50 },
  { 0x0154, 0x00DD, -50 },
  { 0x0154, 0x0178, -50 },
  { 0x0158, 0x004F, -20 },
  { 0x0158, 0x00D3, -20 },
  { 0x0158, 0x00D4, -20 },
  { 0x0158, 0x00D6, -20 },
  { 0x0158, 0x00D2, -20 },
  { 0x0158, 0x0150, -20 },
  { 0x0158, 0x014C, -20 },
  { 0x0158, 0x00D8, -20 },
  { 0x0158, 0x00D5, -20 },
  { 0x0158, 0x0054, -20 },
  { 0x0158, 0x0164, -20 },
  { 0x0158, 0x0162, -20 },
  { 0x0158, 0x0055, -20 },
  { 0x0158, 0x00DA, -20 },
  { 0x0158, 0x00DB, -20 },
  { 0x0158, 0x00DC, -20 },
  { 0x0158, 0x00D9, -20 },
  { 0x0158, 0x0170, -20 },
  { 0x0158, 0x016A, -20 },
  { 0x0158, 0x0172, -20 },
  { 0x0158, 0x016E, -20 },
  { 0x0158, 0x0056, -50 },
  { 0x0158, 0x0057, -40 },
  { 0x0158, 0x0059, -50 },
  { 0x0158, 0x00DD, -50 },
  { 0x0158, 0x0178, -50 },
  { 0x0156, 0x004F, -20 },
  { 0x0156, 0x00D3, -20 },
  { 0x0156, 0x00D4, -20 },
  { 0x0156, 0x00D6, -20 },
  { 0x0156, 0x00D2, -20 },
  { 0x0156, 0x0150, -20 },
  { 0x0156, 0x014C, -20 },
  { 0x0156, 0x00D8, -20 },
  { 0x0156, 0x00D5, -20 },
  { 0x0156, 0x0054, -20 },
  { 0x0156, 0x0164, -20 },
  { 0x0156, 0x0162, -20 },
  { 0x0156, 0x0055, -20 },
  { 0x0156, 0x00DA, -20 },
  { 0x0156, 0x00DB, -20 },
  { 0x0156, 0x00DC, -20 },
  { 0x0156, 0x00D9, -20 },
  { 0x0156, 0x0170, -20 },
  { 0x0156, 0x016A, -20 },
  { 0x0156, 0x0172, -20 },
  { 0x0156, 0x016E, -20 },
  { 0x0156, 0x0056, -50 },
  { 0x0156, 0x0057, -40 },
  { 0x0156, 0x0059, -50 },
  { 0x0156, 0x00DD, -50 },
  { 0x0156, 0x0178, -50 },
  { 0x0054, 0x0041, -90 },
  { 0x0054, 0x00C1, -90 },
  { 0x0054, 0x0102, -90 },
  { 0x0054, 0x00C2, -90 },
  { 0x0054, 0x00C4, -90 },
  { 0x0054, 0x00C0, -90 },
  { 0x0054, 0x0100, -90 },
  { 0x0054, 0x0104, -90 },
  { 0x0054, 0x00C5, -90 },
  { 0x0054, 0x00C3, -90 },
  { 0x0054, 0x004F, -40 },
  { 0x0054, 0x00D3, -40 },
  { 0x0054, 0x00D4, -40 },
  { 0x0054, 0x00D6, -40 },
  { 0x0054, 0x00D2, -40 },
  { 0x0054, 0x0150, -40 },
  { 0x0054, 0x014C, -40 },
  { 0x0054, 0x00D8, -40 },
  { 0x0054, 0x00D5, -40 },
  { 0x0054, 0x0061, -80 },
  { 0x0054, 0x00E1, -80 },
  { 0x0054, 0x0103, -80 },
  { 0x0054, 0x00E2, -80 },
  { 0x0054, 0x00E4, -80 },
  { 0x0054, 0x00E0, -80 },
  { 0x0054, 0x0101, -80 },
  { 0x0054, 0x0105, -80 },
  { 0x0054, 0x00E5, -80 },
  { 0x0054, 0x00E3, -80 },
  { 0x0054, 0x003A, -40 },
  { 0x0054, 0x002C, -80 },
  { 0x0054, 0x0065, -60 },
  { 0x0054, 0x00E9, -60 },
  { 0x0054, 0x011B, -60 },
  { 0x0054, 0x00EA, -60 },
  { 0x0054, 0x00EB, -60 },
  { 0x0054, 0x0117, -60 },
  { 0x0054, 0x00E8, -60 },
  { 0x0054, 0x0113, -60 },
  { 0x0054, 0x0119, -60 },
  { 0x0054, 0x002D, -120 },
  { 0x0054, 0x006F, -80 },
  { 0x0054, 0x00F3, -80 },
  { 0x0054, 0x00F4, -80 },
  { 0x0054, 0x00F6, -80 },
  { 0x0054, 0x00F2, -80 },
  { 0x0054, 0x0151, -80 },
  { 0x0054, 0x014D, -80 },
  { 0x0054, 0x00F8, -80 },
  { 0x0054, 0x00F5, -80 },
  { 0x0054, 0x002E, -80 },
  { 0x0054, 0x0072, -80 },
  { 0x0054, 0x0155, -80 },
  { 0x0054, 0x0157, -80 },
  { 0x0054, 0x003B, -40 },
  { 0x0054, 0x0075, -90 },
  { 0x0054, 0x00FA, -90 },
  { 0x0054, 0x00FB, -90 },
  { 0x0054, 0x00FC, -90 },
  { 0x0054, 0x00F9, -90 },
  { 0x0054, 0x0171, -90 },
  { 0x0054, 0x016B, -90 },
  { 0x0054, 0x0173, -90 },
  { 0x0054, 0x016F, -90 },
  { 0x0054, 0x0077, -60 },
  { 0x0054, 0x0079, -60 },
  { 0x0054, 0x00FD, -60 },
  { 0x0054, 0x00FF, -60 },
  { 0x0164, 0x0041, -90 },
  { 0x0164, 0x00C1, -90 },
  { 0x0164, 0x0102, -90 },
  { 0x0164, 0x00C2, -90 },
  { 0x0164, 0x00C4, -90 },
  { 0x0164, 0x00C0, -90 },
  { 0x0164, 0x0100, -90 },
  { 0x0164, 0x0104, -90 },
  { 0x0164, 0x00C5, -90 },
  { 0x0164, 0x00C3, -90 },
  { 0x0164, 0x004F, -40 },
  { 0x0164, 0x00D3, -40 },
  { 0x0164, 0x00D4, -40 },
  { 0x0164, 0x00D6, -40 },
  { 0x0164, 0x00D2, -40 },
  { 0x0164, 0x0150, -40 },
  { 0x0164, 0x014C, -40 },
  { 0x0164, 0x00D8, -40 },
  { 0x0164, 0x00D5, -40 },
  { 0x0164, 0x0061, -80 },
  { 0x0164, 0x00E1, -80 },
  { 0x0164, 0x0103, -80 },
  { 0x0164, 0x00E2, -80 },
  { 0x0164, 0x00E4, -80 },
  { 0x0164, 0x00E0, -80 },
  { 0x0164, 0x0101, -80 },
  { 0x0164, 0x0105, -80 },
  { 0x0164, 0x00E5, -80 },
  { 0x0164, 0x00E3, -80 },
  { 0x0164, 0x003A, -40 },
  { 0x0164, 0x002C, -80 },
  { 0x0164, 0x0065, -60 },
  { 0x0164, 0x00E9, -60 },
  { 0x0164, 0x011B, -60 },
  { 0x0164, 0x00EA, -60 },
  { 0x0164, 0x00EB, -60 },
  { 0x0164, 0x0117, -60 },
  { 0x0164, 0x00E8, -60 },
  { 0x0164, 0x0113, -60 },
  { 0x0164, 0x0119, -60 },
  { 0x0164, 0x002D, -120 },
  { 0x0164, 0x006F, -80 },
  { 0x0164, 0x00F3, -80 },
  { 0x0164, 0x00F4, -80 },
  { 0x0164, 0x00F6, -80 },
  { 0x0164, 0x00F2, -80 },
  { 0x0164, 0x0151, -80 },
  { 0x0164, 0x014D, -80 },
  { 0x0164, 0x00F8, -80 },
  { 0x0164, 0x00F5, -80 },
  { 0x0164, 0x002E, -80 },
  { 0x0164, 0x0072, -80 },
  { 0x0164, 0x0155, -80 },
  { 0x0164, 0x0157, -80 },
  { 0x0164, 0x003B, -40 },
  { 0x0164, 0x0075, -90 },
  { 0x0164, 0x00FA, -90 },
  { 0x0164, 0x00FB, -90 },
  { 0x0164, 0x00FC, -90 },
  { 0x0164, 0x00F9, -90 },
  { 0x0164, 0x0171, -90 },
  { 0x0164, 0x016B, -90 },
  { 0x0164, 0x0173, -90 },
  { 0x0164, 0x016F, -90 },
  { 0x0164, 0x0077, -60 },
  { 0x0164, 0x0079, -60 },
  { 0x0164, 0x00FD, -60 },
  { 0x0164, 0x00FF, -60 },
  { 0x0162, 0x0041, -90 },
  { 0x0162, 0x00C1, -90 },
  { 0x0162, 0x0102, -90 },
  { 0x0162, 0x00C2, -90 },
  { 0x0162, 0x00C4, -90 },
  { 0x0162, 0x00C0, -90 },
  { 0x0162, 0x0100, -90 },
  { 0x0162, 0x0104, -90 },
  { 0x0162, 0x00C5, -90 },
  { 0x0162, 0x00C3, -90 },
  { 0x0162, 0x004F, -40 },
  { 0x0162, 0x00D3, -40 },
  { 0x0162, 0x00D4, -40 },
  { 0x0162, 0x00D6, -40 },
  { 0x0162, 0x00D2, -40 },
  { 0x0162, 0x0150, -40 },
  { 0x0162, 0x014C, -40 },
  { 0x0162, 0x00D8, -40 },
  { 0x0162, 0x00D5, -40 },
  { 0x0162, 0x0061, -80 },
  { 0x0162, 0x00E1, -80 },
  { 0x0162, 0x0103, -80 },
  { 0x0162, 0x00E2, -80 },
  { 0x0162, 0x00E4, -80 },
  { 0x0162, 0x00E0, -80 },
  { 0x0162, 0x0101, -80 },
  { 0x0162, 0x0105, -80 },
  { 0x0162, 0x00E5, -80 },
  { 0x0162, 0x00E3, -80 },
  { 0x0162, 0x003A, -40 },
  { 0x0162, 0x002C, -80 },
  { 0x0162, 0x0065, -60 },
  { 0x0162, 0x00E9, -60 },
  { 0x0162, 0x011B, -60 },
  { 0x0162, 0x00EA, -60 },
  { 0x0162, 0x00EB, -60 },
  { 0x0162, 0x0117, -60 },
  { 0x0162, 0x00E8, -60 },
  { 0x0162, 0x0113, -60 },
  { 0x0162, 0x0119, -60 },
  { 0x0162, 0x002D, -120 },
  { 0x0162, 0x006F, -80 },
  { 0x0162, 0x00F3, -80 },
  { 0x0162, 0x00F4, -80 },
  { 0x0162, 0x00F6, -80 },
  { 0x0162, 0x00F2, -80 },
  { 0x0162, 0x0151, -80 },
  { 0x0162, 0x014D, -80 },
  { 0x0162, 0x00F8, -80 },
  { 0x0162, 0x00F5, -80 },
  { 0x0162, 0x002E, -80 },
  { 0x0162, 0x0072, -80 },
  { 0x0162, 0x0155, -80 },
  { 0x0162, 0x0157, -80 },
  { 0x0162, 0x003B, -40 },
  { 0x0162, 0x0075, -90 },
  { 0x0162, 0x00FA, -90 },
  { 0x0162, 0x00FB, -90 },
  { 0x0162, 0x00FC, -90 },
  { 0x0162, 0x00F9, -90 },
  { 0x0162, 0x0171, -90 },
  { 0x0162, 0x016B, -90 },
  { 0x0162, 0x0173, -90 },
  { 0x0162, 0x016F, -90 },
  { 0x0162, 0x0077, -60 },
  { 0x0162, 0x0079, -60 },
  { 0x0162, 0x00FD, -60 },
  { 0x0162, 0x00FF, -60 },
  { 0x0055, 0x0041, -50 },
  { 0x0055, 0x00C1, -50 },
  { 0x0055, 0x0102, -50 },
  { 0x0055, 0x00C2, -50 },
  { 0x0055, 0x00C4, -50 },
  { 0x0055, 0x00C0, -50 },
  { 0x0055, 0x0100, -50 },
  { 0x0055, 0x0104, -50 },
  { 0x0055, 0x00C5, -50 },
  { 0x0055, 0x00C3, -50 },
  { 0x0055, 0x002C, -30 },
  { 0x0055, 0x002E, -30 },
  { 0x00DA, 0x0041, -50 },
  { 0x00DA, 0x00C1, -50 },
  { 0x00DA, 0x0102, -50 },
  { 0x00DA, 0x00C2, -50 },
  { 0x00DA, 0x00C4, -50 },
  { 0x00DA, 0x00C0, -50 },
  { 0x00DA, 0x0100, -50 },
  { 0x00DA, 0x0104, -50 },
  { 0x00DA, 0x00C5, -50 },
  { 0x00DA, 0x00C3, -50 },
  { 0x00DA, 0x002C, -30 },
  { 0x00DA, 0x002E, -30 },
  { 0x00DB, 0x0041, -50 },
  { 0x00DB, 0x00C1, -50 },
  { 0x00DB, 0x0102, -50 },
  { 0x00DB, 0x00C2, -50 },
  { 0x00DB, 0x00C4, -50 },
  { 0x00DB, 0x00C0, -50 },
  { 0x00DB, 0x0100, -50 },
  { 0x00DB, 0x0104, -50 },
  { 0x00DB, 0x00C5, -50 },
  { 0x00DB, 0x00C3, -50 },
  { 0x00DB, 0x002C, -30 },
  { 0x00DB, 0x002E, -30 },
  { 0x00DC, 0x0041, -50 },
  { 0x00DC, 0x00C1, -50 },
  { 0x00DC, 0x0102, -50 },
  { 0x00DC, 0x00C2, -50 },
  { 0x00DC, 0x00C4, -50 },
  { 0x00DC, 0x00C0, -50 },
  { 0x00DC, 0x0100, -50 },
  { 0x00DC, 0x0104, -50 },
  { 0x00DC, 0x00C5, -50 },
  { 0x00DC, 0x00C3, -50 },
  { 0x00DC, 0x002C, -30 },
  { 0x00DC, 0x002E, -30 },
  { 0x00D9, 0x0041, -50 },
  { 0x00D9, 0x00C1, -50 },
  { 0x00D9, 0x0102, -50 },
  { 0x00D9, 0x00C2, -50 },
  { 0x00D9, 0x00C4, -50 },
  { 0x00D9, 0x00C0, -50 },
  { 0x00D9, 0x0100, -50 },
  { 0x00D9, 0x0104, -50 },
  { 0x00D9, 0x00C5, -50 },
  { 0x00D9, 0x00C3, -50 },
  { 0x00D9, 0x002C, -30 },
  { 0x00D9, 0x002E, -30 },
  { 0x0170, 0x0041, -50 },
  { 0x0170, 0x00C1, -50 },
  { 0x0170, 0x0102, -50 },
  { 0x0170, 0x00C2, -50 },
  { 0x0170, 0x00C4, -50 },
  { 0x0170, 0x00C0, -50 },
  { 0x0170, 0x0100, -50 },
  { 0x0170, 0x0104, -50 },
  { 0x0170, 0x00C5, -50 },
  { 0x0170, 0x00C3, -50 },
  { 0x0170, 0x002C, -30 },
  { 0x0170, 0x002E, -30 },
  { 0x016A, 0x0041, -50 },
  { 0x016A, 0x00C1, -50 },
  { 0x016A, 0x0102, -50 },
  { 0x016A, 0x00C2, -50 },
  { 0x016A, 0x00C4, -50 },
  { 0x016A, 0x00C0, -50 },
  { 0x016A, 0x0100, -50 },
  { 0x016A, 0x0104, -50 },
  { 0x016A, 0x00C5, -50 },
  { 0x016A, 0x00C3, -50 },
  { 0x016A, 0x002C, -30 },
  { 0x016A, 0x002E, -30 },
  { 0x0172, 0x0041, -50 },
  { 0x0172, 0x00C1, -50 },
  { 0x0172, 0x0102, -50 },
  { 0x0172, 0x00C2, -50 },
  { 0x0172, 0x00C4, -50 },
  { 0x0172, 0x00C0, -50 },
  { 0x0172, 0x0100, -50 },
  { 0x0172, 0x0104, -50 },
  { 0x0172, 0x00C5, -50 },
  { 0x0172, 0x00C3, -50 },
  { 0x0172, 0x002C, -30 },
  { 0x0172, 0x002E, -30 },
  { 0x016E, 0x0041, -50 },
  { 0x016E, 0x00C1, -50 },
  { 0x016E, 0x0102, -50 },
  { 0x016E, 0x00C2, -50 },
  { 0x016E, 0x00C4, -50 },
  { 0x016E, 0x00C0, -50 },
  { 0x016E, 0x0100, -50 },
  { 0x016E, 0x0104, -50 },
  { 0x016E, 0x00C5, -50 },
  { 0x016E, 0x00C3, -50 },
  { 0x016E, 0x002C, -30 },
  { 0x016E, 0x002E, -30 },
  { 0x0056, 0x0041, -80 },
  { 0x0056, 0x00C1, -80 },
  { 0x0056, 0x0102, -80 },
  { 0x0056, 0x00C2, -80 },
  { 0x0056, 0x00C4, -80 },
  { 0x0056, 0x00C0, -80 },
  { 0x0056, 0x0100, -80 },
  { 0x0056, 0x0104, -80 },
  { 0x0056, 0x00C5, -80 },
  { 0x0056, 0x00C3, -80 },
  { 0x0056, 0x0047, -50 },
  { 0x0056, 0x011E, -50 },
  { 0x0056, 0x0122, -50 },
  { 0x0056, 0x004F, -50 },
  { 0x0056, 0x00D3, -50 },
  { 0x0056, 0x00D4, -50 },
  { 0x0056, 0x00D6, -50 },
  { 0x0056, 0x00D2, -50 },
  { 0x0056, 0x0150, -50 },
  { 0x0056, 0x014C, -50 },
  { 0x0056, 0x00D8, -50 },
  { 0x0056, 0x00D5, -50 },
  { 0x0056, 0x0061, -60 },
  { 0x0056, 0x00E1, -60 },
  { 0x0056, 0x0103, -60 },
  { 0x0056, 0x00E2, -60 },
  { 0x0056, 0x00E4, -60 },
  { 0x0056, 0x00E0, -60 },
  { 0x0056, 0x0101, -60 },
  { 0x0056, 0x0105, -60 },
  { 0x0056, 0x00E5, -60 },
  { 0x0056, 0x00E3, -60 },
  { 0x0056, 0x003A, -40 },
  { 0x0056, 0x002C, -120 },
  { 0x0056, 0x0065, -50 },
  { 0x0056, 0x00E9, -50 },
  { 0x0056, 0x011B, -50 },
  { 0x0056, 0x00EA, -50 },
  { 0x0056, 0x00EB, -50 },
  { 0x0056, 0x0117, -50 },
  { 0x0056, 0x00E8, -50 },
  { 0x0056, 0x0113, -50 },
  { 0x0056, 0x0119, -50 },
  { 0x0056, 0x002D, -80 },
  { 0x0056, 0x006F, -90 },
  { 0x0056, 0x00F3, -90 },
  { 0x0056, 0x00F4, -90 },
  { 0x0056, 0x00F6, -90 },
  { 0x0056, 0x00F2, -90 },
  { 0x0056, 0x0151, -90 },
  { 0x0056, 0x014D, -90 },
  { 0x0056, 0x00F8, -90 },
  { 0x0056, 0x00F5, -90 },
  { 0x0056, 0x002E, -120 },
  { 0x0056, 0x003B, -40 },
  { 0x0056, 0x0075, -60 },
  { 0x0056, 0x00FA, -60 },
  { 0x0056, 0x00FB, -60 },
  { 0x0056, 0x00FC, -60 },
  { 0x0056, 0x00F9, -60 },
  { 0x0056, 0x0171, -60 },
  { 0x0056, 0x016B, -60 },
  { 0x0056, 0x0173, -60 },
  { 0x0056, 0x016F, -60 },
  { 0x0057, 0x0041, -60 },
  { 0x0057, 0x00C1, -60 },
  { 0x0057, 0x0102, -60 },
  { 0x0057, 0x00C2, -60 },
  { 0x0057, 0x00C4, -60 },
  { 0x0057, 0x00C0, -60 },
  { 0x0057, 0x0100, -60 },
  { 0x0057, 0x0104, -60 },
  { 0x0057, 0x00C5, -60 },
  { 0x0057, 0x00C3, -60 },
  { 0x0057, 0x004F, -20 },
  { 0x0057, 0x00D3, -20 },
  { 0x0057, 0x00D4, -20 },
  { 0x0057, 0x00D6, -20 },
  { 0x0057, 0x00D2, -20 },
  { 0x0057, 0x0150, -20 },
  { 0x0057, 0x014C, -20 },
  { 0x0057, 0x00D8, -20 },
  { 0x0057, 0x00D5, -20 },
  { 0x0057, 0x0061, -40 },
  { 0x0057, 0x00E1, -40 },
  { 0x0057, 0x0103, -40 },
  { 0x0057, 0x00E2, -40 },
  { 0x0057, 0x00E4, -40 },
  { 0x0057, 0x00E0, -40 },
  { 0x0057, 0x0101, -40 },
  { 0x0057, 0x0105, -40 },
  { 0x0057, 0x00E5, -40 },
  { 0x0057, 0x00E3, -40 },
  { 0x0057, 0x003A, -10 },
  { 0x0057, 0x002C, -80 },
  { 0x0057, 0x0065, -35 },
  { 0x0057, 0x00E9, -35 },
  { 0x0057, 0x011B, -35 },
  { 0x0057, 0x00EA, -35 },
  { 0x0057, 0x00EB, -35 },
  { 0x0057, 0x0117, -35 },
  { 0x0057, 0x00E8, -35 },
  { 0x0057, 0x0113, -35 },
  { 0x0057, 0x0119, -35 },
  { 0x0057, 0x002D, -40 },
  { 0x0057, 0x006F, -60 },
  { 0x0057, 0x00F3, -60 },
  { 0x0057, 0x00F4, -60 },
  { 0x0057, 0x00F6, -60 },
  { 0x0057, 0x00F2, -60 },
  { 0x0057, 0x0151, -60 },
  { 0x0057, 0x014D, -60 },
  { 0x0057, 0x00F8, -60 },
  { 0x0057, 0x00F5, -60 },
  { 0x0057, 0x002E, -80 },
  { 0x0057, 0x003B, -10 },
  { 0x0057, 0x0075, -45 },
  { 0x0057, 0x00FA, -45 },
  { 0x0057, 0x00FB, -45 },
  { 0x0057, 0x00FC, -45 },
  { 0x0057, 0x00F9, -45 },
  { 0x0057, 0x0171, -45 },
  { 0x0057, 0x016B, -45 },
  { 0x0057, 0x0173, -45 },
  { 0x0057, 0x016F, -45 },
  { 0x0057, 0x0079, -20 },
  { 0x0057, 0x00FD, -20 },
  { 0x0057, 0x00FF, -20 },
  { 0x0059, 0x0041, -110 },
  { 0x0059, 0x00C1, -110 },
  { 0x0059, 0x0102, -110 },
  { 0x0059, 0x00C2, -110 },
  { 0x0059, 0x00C4, -110 },
  { 0x0059, 0x00C0, -110 },
  { 0x0059, 0x0100, -110 },
  { 0x0059, 0x0104, -110 },
  { 0x0059, 0x00C5, -110 },
  { 0x0059, 0x00C3, -110 },
  { 0x0059, 0x004F, -70 },
  { 0x0059, 0x00D3, -70 },
  { 0x0059, 0x00D4, -70 },
  { 0x0059, 0x00D6, -70 },
  { 0x0059, 0x00D2, -70 },
  { 0x0059, 0x0150, -70 },
  { 0x0059, 0x014C, -70 },
  { 0x0059, 0x00D8, -70 },
  { 0x0059, 0x00D5, -70 },
  { 0x0059, 0x0061, -90 },
  { 0x0059, 0x00E1, -90 },
  { 0x0059, 0x0103, -90 },
  { 0x0059, 0x00E2, -90 },
  { 0x0059, 0x00E4, -90 },
  { 0x0059, 0x00E0, -90 },
  { 0x0059, 0x0101, -90 },
  { 0x0059, 0x0105, -90 },
  { 0x0059, 0x00E5, -90 },
  { 0x0059, 0x00E3, -90 },
  { 0x0059, 0x003A, -50 },
  { 0x0059, 0x002C, -100 },
  { 0x0059, 0x0065, -80 },
  { 0x0059, 0x00E9, -80 },
  { 0x0059, 0x011B, -80 },
  { 0x0059, 0x00EA, -80 },
  { 0x0059, 0x00EB, -80 },
  { 0x0059, 0x0117, -80 },
  { 0x0059, 0x00E8, -80 },
  { 0x0059, 0x0113, -80 },
  { 0x0059, 0x0119, -80 },
  { 0x0059, 0x006F, -100 },
  { 0x0059, 0x00F3, -100 },
  { 0x0059, 0x00F4, -100 },
  { 0x0059, 0x00F6, -100 },
  { 0x0059, 0x00F2, -100 },
  { 0x0059, 0x0151, -100 },
  { 0x0059, 0x014D, -100 },
  { 0x0059, 0x00F8, -100 },
  { 0x0059, 0x00F5, -100 },
  { 0x0059, 0x002E, -100 },
  { 0x0059, 0x003B, -50 },
  { 0x0059, 0x0075, -100 },
  { 0x0059, 0x00FA, -100 },
  { 0x0059, 0x00FB, -100 },
  { 0x0059, 0x00FC, -100 },
  { 0x0059, 0x00F9, -100 },
  { 0x0059, 0x0171, -100 },
  { 0x0059, 0x016B, -100 },
  { 0x0059, 0x0173, -100 },
  { 0x0059, 0x016F, -100 },
  { 0x00DD, 0x0041, -110 },
  { 0x00DD, 0x00C1, -110 },
  { 0x00DD, 0x0102, -110 },
  { 0x00DD, 0x00C2, -110 },
  { 0x00DD, 0x00C4, -110 },
  { 0x00DD, 0x00C0, -110 },
  { 0x00DD, 0x0100, -110 },
  { 0x00DD, 0x0104, -110 },
  { 0x00DD, 0x00C5, -110 },
  { 0x00DD, 0x00C3, -110 },
  { 0x00DD, 0x004F, -70 },
  { 0x00DD, 0x00D3, -70 },
  { 0x00DD, 0x00D4, -70 },
  { 0x00DD, 0x00D6, -70 },
  { 0x00DD, 0x00D2, -70 },
  { 0x00DD, 0x0150, -70 },
  { 0x00DD, 0x014C, -70 },
  { 0x00DD, 0x00D8, -70 },
  { 0x00DD, 0x00D5, -70 },
  { 0x00DD, 0x0061, -90 },
  { 0x00DD, 0x00E1, -90 },
  { 0x00DD, 0x0103, -90 },
  { 0x00DD, 0x00E2, -90 },
  { 0x00DD, 0x00E4, -90 },
  { 0x00DD, 0x00E0, -90 },
  { 0x00DD, 0x0101, -90 },
  { 0x00DD, 0x0105, -90 },
  { 0x00DD, 0x00E5, -90 },
  { 0x00DD, 0x00E3, -90 },
  { 0x00DD, 0x003A, -50 },
  { 0x00DD, 0x002C, -100 },
  { 0x00DD, 0x0065, -80 },
  { 0x00DD, 0x00E9, -80 },
  { 0x00DD, 0x011B, -80 },
  { 0x00DD, 0x00EA, -80 },
  { 0x00DD, 0x00EB, -80 },
  { 0x00DD, 0x0117, -80 },
  { 0x00DD, 0x00E8, -80 },
  { 0x00DD, 0x0113, -80 },
  { 0x00DD, 0x0119, -80 },
  { 0x00DD, 0x006F, -100 },
  { 0x00DD, 0x00F3, -100 },
  { 0x00DD, 0x00F4, -100 },
  { 0x00DD, 0x00F6, -100 },
  { 0x00DD, 0x00F2, -100 },
  { 0x00DD, 0x0151, -100 },
  { 0x00DD, 0x014D, -100 },
  { 0x00DD, 0x00F8, -100 },
  { 0x00DD, 0x00F5, -100 },
  { 0x00DD, 0x002E, -100 },
  { 0x00DD, 0x003B, -50 },
  { 0x00DD, 0x0075, -100 },
  { 0x00DD, 0x00FA, -100 },
  { 0x00DD, 0x00FB, -100 },
  { 0x00DD, 0x00FC, -100 },
  { 0x00DD, 0x00F9, -100 },
  { 0x00DD, 0x0171, -100 },
  { 0x00DD, 0x016B, -100 },
  { 0x00DD, 0x0173, -100 },
  { 0x00DD, 0x016F, -100 },
  { 0x0178, 0x0041, -110 },
  { 0x0178, 0x00C1, -110 },
  { 0x0178, 0x0102, -110 },
  { 0x0178, 0x00C2, -110 },
  { 0x0178, 0x00C4, -110 },
  { 0x0178, 0x00C0, -110 },
  { 0x0178, 0x0100, -110 },
  { 0x0178, 0x0104, -110 },
  { 0x0178, 0x00C5, -110 },
  { 0x0178, 0x00C3, -110 },
  { 0x0178, 0x004F, -70 },
  { 0x0178, 0x00D3, -70 },
  { 0x0178, 0x00D4, -70 },
  { 0x0178, 0x00D6, -70 },
  { 0x0178, 0x00D2, -70 },
  { 0x0178, 0x0150, -70 },
  { 0x0178, 0x014C, -70 },
  { 0x0178, 0x00D8, -70 },
  { 0x0178, 0x00D5, -70 },
  { 0x0178, 0x0061, -90 },
  { 0x0178, 0x00E1, -90 },
  { 0x0178, 0x0103, -90 },
  { 0x0178, 0x00E2, -90 },
  { 0x0178, 0x00E4, -90 },
  { 0x0178, 0x00E0, -90 },
  { 0x0178, 0x0101, -90 },
  { 0x0178, 0x0105, -90 },
  { 0x0178, 0x00E5, -90 },
  { 0x0178, 0x00E3, -90 },
  { 0x0178, 0x003A, -50 },
  { 0x0178, 0x002C, -100 },
  { 0x0178, 0x0065, -80 },
  { 0x0178, 0x00E9, -80 },
  { 0x0178, 0x011B, -80 },
  { 0x0178, 0x00EA, -80 },
  { 0x0178, 0x00EB, -80 },
  { 0x0178, 0x0117, -80 },
  { 0x0178, 0x00E8, -80 },
  { 0x0178, 0x0113, -80 },
  { 0x0178, 0x0119, -80 },
  { 0x0178, 0x006F, -100 },
  { 0x0178, 0x00F3, -100 },
  { 0x0178, 0x00F4, -100 },
  { 0x0178, 0x00F6, -100 },
  { 0x0178, 0x00F2, -100 },
  { 0x0178, 0x0151, -100 },
  { 0x0178, 0x014D, -100 },
  { 0x0178, 0x00F8, -100 },
  { 0x0178, 0x00F5, -100 },
  { 0x0178, 0x002E, -100 },
  { 0x0178, 0x003B, -50 },
  { 0x0178, 0x0075, -100 },
  { 0x0178, 0x00FA, -100 },
  { 0x0178, 0x00FB, -100 },
  { 0x0178, 0x00FC, -100 },
  { 0x0178, 0x00F9, -100 },
  { 0x0178, 0x0171, -100 },
  { 0x0178, 0x016B, -100 },
  { 0x0178, 0x0173, -100 },
  { 0x0178, 0x016F, -100 },
  { 0x0061, 0x0067, -10 },
  { 0x0061, 0x011F, -10 },
  { 0x0061, 0x0123, -10 },
  { 0x0061, 0x0076, -15 },
  { 0x0061, 0x0077, -15 },
  { 0x0061, 0x0079, -20 },
  { 0x0061, 0x00FD, -20 },
  { 0x0061, 0x00FF, -20 },
  { 0x00E1, 0x0067, -10 },
  { 0x00E1, 0x011F, -10 },
  { 0x00E1, 0x0123, -10 },
  { 0x00E1, 0x0076, -15 },
  { 0x00E1, 0x0077, -15 },
  { 0x00E1, 0x0079, -20 },
  { 0x00E1, 0x00FD, -20 },
  { 0x00E1, 0x00FF, -20 },
  { 0x0103, 0x0067, -10 },
  { 0x0103, 0x011F, -10 },
  { 0x0103, 0x0123, -10 },
  { 0x0103, 0x0076, -15 },
  { 0x0103, 0x0077, -15 },
  { 0x0103, 0x0079, -20 },
  { 0x0103, 0x00FD, -20 },
  { 0x0103, 0x00FF, -20 },
  { 0x00E2, 0x0067, -10 },
  { 0x00E2, 0x011F, -10 },
  { 0x00E2, 0x0123, -10 },
  { 0x00E2, 0x0076, -15 },
  { 0x00E2, 0x0077, -15 },
  { 0x00E2, 0x0079, -20 },
  { 0x00E2, 0x00FD, -20 },
  { 0x00E2, 0x00FF, -20 },
  { 0x00E4, 0x0067, -10 },
  { 0x00E4, 0x011F, -10 },
  { 0x00E4, 0x0123, -10 },
  { 0x00E4, 0x0076, -15 },
  { 0x00E4, 0x0077, -15 },
  { 0x00E4, 0x0079, -20 },
  { 0x00E4, 0x00FD, -20 },
  { 0x00E4, 0x00FF, -20 },
  { 0x00E0, 0x0067, -10 },
  { 0x00E0, 0x011F, -10 },
  { 0x00E0, 0x0123, -10 },
  { 0x00E0, 0x0076, -15 },
  { 0x00E0, 0x0077, -15 },
  { 0x00E0, 0x0079, -20 },
  { 0x00E0, 0x00FD, -20 },
  { 0x00E0, 0x00FF, -20 },
  { 0x0101, 0x0067, -10 },
  { 0x0101, 0x011F, -10 },
  { 0x0101, 0x0123, -10 },
  { 0x0101, 0x0076, -15 },
  { 0x0101, 0x0077, -15 },
  { 0x0101, 0x0079, -20 },
  { 0x0101, 0x00FD, -20 },
  { 0x0101, 0x00FF, -20 },
  { 0x0105, 0x0067, -10 },
  { 0x0105, 0x011F, -10 },
  { 0x0105, 0x0123, -10 },
  { 0x0105, 0x0076, -15 },
  { 0x0105, 0x0077, -15 },
  { 0x0105, 0x0079, -20 },
  { 0x0105, 0x00FD, -20 },
  { 0x0105, 0x00FF, -20 },
  { 0x00E5, 0x0067, -10 },
  { 0x00E5, 0x011F, -10 },
  { 0x00E5, 0x0123, -10 },
  { 0x00E5, 0x0076, -15 },
  { 0x00E5, 0x0077, -15 },
  { 0x00E5, 0x0079, -20 },
  { 0x00E5, 0x00FD, -20 },
  { 0x00E5, 0x00FF, -20 },
  { 0x00E3, 0x0067, -10 },
  { 0x00E3, 0x011F, -10 },
  { 0x00E3, 0x0123, -10 },
  { 0x00E3, 0x0076, -15 },
  { 0x00E3, 0x0077, -15 },
  { 0x00E3, 0x0079, -20 },
  { 0x00E3, 0x00FD, -20 },
  { 0x00E3, 0x00FF, -20 },
  { 0x0062, 0x006C, -10 },
  { 0x0062, 0x013A, -10 },
  { 0x0062, 0x013C, -10 },
  { 0x0062, 0x0142, -10 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0062, 0x0076, -20 },
  { 0x0062, 0x0079, -20 },
  { 0x0062, 0x00FD, -20 },
  { 0x0062, 0x00FF, -20 },
  { 0x0063, 0x0068, -10 },
  { 0x0063, 0x006B, -20 },
  { 0x0063, 0x0137, -20 },
  { 0x0063, 0x006C, -20 },
  { 0x0063, 0x013A, -20 },
  { 0x0063, 0x013C, -20 },
  { 0x0063, 0x0142, -20 },
  { 0x0063, 0x0079, -10 },
  { 0x0063, 0x00FD, -10 },
  { 0x0063, 0x00FF, -10 },
  { 0x0107, 0x0068, -10 },
  { 0x0107, 0x006B, -20 },
  { 0x0107, 0x0137, -20 },
  { 0x0107, 0x006C, -20 },
  { 0x0107, 0x013A, -20 },
  { 0x0107, 0x013C, -20 },
  { 0x0107, 0x0142, -20 },
  { 0x0107, 0x0079, -10 },
  { 0x0107, 0x00FD, -10 },
  { 0x0107, 0x00FF, -10 },
  { 0x010D, 0x0068, -10 },
  { 0x010D, 0x006B, -20 },
  { 0x010D, 0x0137, -20 },
  { 0x010D, 0x006C, -20 },
  { 0x010D, 0x013A, -20 },
  { 0x010D, 0x013C, -20 },
  { 0x010D, 0x0142, -20 },
  { 0x010D, 0x0079, -10 },
  { 0x010D, 0x00FD, -10 },
  { 0x010D, 0x00FF, -10 },
  { 0x00E7, 0x0068, -10 },
  { 0x00E7, 0x006B, -20 },
  { 0x00E7, 0x0137, -20 },
  { 0x00E7, 0x006C, -20 },
  { 0x00E7, 0x013A, -20 },
  { 0x00E7, 0x013C, -20 },
  { 0x00E7, 0x0142, -20 },
  { 0x00E7, 0x0079, -10 },
  { 0x00E7, 0x00FD, -10 },
  { 0x00E7, 0x00FF, -10 },
  { 0x003A, 0x0020, -40 },
  { 0x002C, 0x201D, -120 },
  { 0x002C, 0x2019, -120 },
  { 0x002C, 0x0020, -40 },
  { 0x0064, 0x0064, -10 },
  { 0x0064, 0x0111, -10 },
  { 0x0064, 0x0076, -15 },
  { 0x0064, 0x0077, -15 },
  { 0x0064, 0x0079, -15 },
  { 0x0064, 0x00FD, -15 },
  { 0x0064, 0x00FF, -15 },
  { 0x0111, 0x0064, -10 },
  { 0x0111, 0x0111, -10 },
  { 0x0111, 0x0076, -15 },
  { 0x0111, 0x0077, -15 },
  { 0x0111, 0x0079, -15 },
  { 0x0111, 0x00FD, -15 },
  { 0x0111, 0x00FF, -15 },
  { 0x0065, 0x002C, 10 },
  { 0x0065, 0x002E, 20 },
  { 0x0065, 0x0076, -15 },
  { 0x0065, 0x0077, -15 },
  { 0x0065, 0x0078, -15 },
  { 0x0065, 0x0079, -15 },
  { 0x0065, 0x00FD, -15 },
  { 0x0065, 0x00FF, -15 },
  { 0x00E9, 0x002C, 10 },
  { 0x00E9, 0x002E, 20 },
  { 0x00E9, 0x0076, -15 },
  { 0x00E9, 0x0077, -15 },
  { 0x00E9, 0x0078, -15 },
  { 0x00E9, 0x0079, -15 },
  { 0x00E9, 0x00FD, -15 },
  { 0x00E9, 0x00FF, -15 },
  { 0x011B, 0x002C, 10 },
  { 0x011B, 0x002E, 20 },
  { 0x011B, 0x0076, -15 },
  { 0x011B, 0x0077, -15 },
  { 0x011B, 0x0078, -15 },
  { 0x011B, 0x0079, -15 },
  { 0x011B, 0x00FD, -15 },
  { 0x011B, 0x00FF, -15 },
  { 0x00EA, 0x002C, 10 },
  { 0x00EA, 0x002E, 20 },
  { 0x00EA, 0x0076, -15 },
  { 0x00EA, 0x0077, -15 },
  { 0x00EA, 0x0078, -15 },
  { 0x00EA, 0x0079, -15 },
  { 0x00EA, 0x00FD, -15 },
  { 0x00EA, 0x00FF, -15 },
  { 0x00EB, 0x002C, 10 },
  { 0x00EB, 0x002E, 20 },
  { 0x00EB, 0x0076, -15 },
  { 0x00EB, 0x0077, -15 },
  { 0x00EB, 0x0078, -15 },
  { 0x00EB, 0x0079, -15 },
  { 0x00EB, 0x00FD, -15 },
  { 0x00EB, 0x00FF, -15 },
  { 0x0117, 0x002C, 10 },
  { 0x0117, 0x002E, 20 },
  { 0x0117, 0x0076, -15 },
  { 0x0117, 0x0077, -15 },
  { 0x0117, 0x0078, -15 },
  { 0x0117, 0x0079, -15 },
  { 0x0117, 0x00FD, -15 },
  { 0x0117, 0x00FF, -15 },
  { 0x00E8, 0x002C, 10 },
  { 0x00E8, 0x002E, 20 },
  { 0x00E8, 0x0076, -15 },
  { 0x00E8, 0x0077, -15 },
  { 0x00E8, 0x0078, -15 },
  { 0x00E8, 0x0079, -15 },
  { 0x00E8, 0x00FD, -15 },
  { 0x00E8, 0x00FF, -15 },
  { 0x0113, 0x002C, 10 },
  { 0x0113, 0x002E, 20 },
  { 0x0113, 0x0076, -15 },
  { 0x0113, 0x0077, -15 },
  { 0x0113, 0x0078, -15 },
  { 0x0113, 0x0079, -15 },
  { 0x0113, 0x00FD, -15 },
  { 0x0113, 0x00FF, -15 },
  { 0x0119, 0x002C, 10 },
  { 0x0119, 0x002E, 20 },
  { 0x0119, 0x0076, -15 },
  { 0x0119, 0x0077, -15 },
  { 0x0119, 0x0078, -15 },
  { 0x0119, 0x0079, -15 },
  { 0x0119, 0x00FD, -15 },
  { 0x0119, 0x00FF, -15 },
  { 0x0066, 0x002C, -10 },
  { 0x0066, 0x0065, -10 },
  { 0x0066, 0x00E9, -10 },
  { 0x0066, 0x011B, -10 },
  { 0x0066, 0x00EA, -10 },
  { 0x0066, 0x00EB, -10 },
  { 0x0066, 0x0117, -10 },
  { 0x0066, 0x00E8, -10 },
  { 0x0066, 0x0113, -10 },
  { 0x0066, 0x0119, -10 },
  { 0x0066, 0x006F, -20 },
  { 0x0066, 0x00F3, -20 },
  { 0x0066, 0x00F4, -20 },
  { 0x0066, 0x00F6, -20 },
  { 0x0066, 0x00F2, -20 },
  { 0x0066, 0x0151, -20 },
  { 0x0066, 0x014D, -20 },
  { 0x0066, 0x00F8, -20 },
  { 0x0066, 0x00F5, -20 },
  { 0x0066, 0x002E, -10 },
  { 0x0066, 0x201D, 30 },
  { 0x0066, 0x2019, 30 },
  { 0x0067, 0x0065, 10 },
  { 0x0067, 0x00E9, 10 },
  { 0x0067, 0x011B, 10 },
  { 0x0067, 0x00EA, 10 },
  { 0x0067, 0x00EB, 10 },
  { 0x0067, 0x0117, 10 },
  { 0x0067, 0x00E8, 10 },
  { 0x0067, 0x0113, 10 },
  { 0x0067, 0x0119, 10 },
  { 0x0067, 0x0067, -10 },
  { 0x0067, 0x011F, -10 },
  { 0x0067, 0x0123, -10 },
  { 0x011F, 0x0065, 10 },
  { 0x011F, 0x00E9, 10 },
  { 0x011F, 0x011B, 10 },
  { 0x011F, 0x00EA, 10 },
  { 0x011F, 0x00EB, 10 },
  { 0x011F, 0x0117, 10 },
  { 0x011F, 0x00E8, 10 },
  { 0x011F, 0x0113, 10 },
  { 0x011F, 0x0119, 10 },
  { 0x011F, 0x0067, -10 },
  { 0x011F, 0x011F, -10 },
  { 0x011F, 0x0123, -10 },
  { 0x0123, 0x0065, 10 },
  { 0x0123, 0x00E9, 10 },
  { 0x0123, 0x011B, 10 },
  { 0x0123, 0x00EA, 10 },
  { 0x0123, 0x00EB, 10 },
  { 0x0123, 0x0117, 10 },
  { 0x0123, 0x00E8, 10 },
  { 0x0123, 0x0113, 10 },
  { 0x0123, 0x0119, 10 },
  { 0x0123, 0x0067, -10 },
  { 0x0123, 0x011F, -10 },
  { 0x0123, 0x0123, -10 },
  { 0x0068, 0x0079, -20 },
  { 0x0068, 0x00FD, -20 },
  { 0x0068, 0x00FF, -20 },
  { 0x006B, 0x006F, -15 },
  { 0x006B, 0x00F3, -15 },
  { 0x006B, 0x00F4, -15 },
  { 0x006B, 0x00F6, -15 },
  { 0x006B, 0x00F2, -15 },
  { 0x006B, 0x0151, -15 },
  { 0x006B, 0x014D, -15 },
  { 0x006B, 0x00F8, -15 },
  { 0x006B, 0x00F5, -15 },
  { 0x0137, 0x006F, -15 },
  { 0x0137, 0x00F3, -15 },
  { 0x0137, 0x00F4, -15 },
  { 0x0137, 0x00F6, -15 },
  { 0x0137, 0x00F2, -15 },
  { 0x0137, 0x0151, -15 },
  { 0x0137, 0x014D, -15 },
  { 0x0137, 0x00F8, -15 },
  { 0x0137, 0x00F5, -15 },
  { 0x006C, 0x0077, -15 },
  { 0x006C, 0x0079, -15 },
  { 0x006C, 0x00FD, -15 },
  { 0x006C, 0x00FF, -15 },
  { 0x013A, 0x0077, -15 },
  { 0x013A, 0x0079, -15 },
  { 0x013A, 0x00FD, -15 },
  { 0x013A, 0x00FF, -15 },
  { 0x013C, 0x0077, -15 },
  { 0x013C, 0x0079, -15 },
  { 0x013C, 0x00FD, -15 },
  { 0x013C, 0x00FF, -15 },
  { 0x0142, 0x0077, -15 },
  { 0x0142, 0x0079, -15 },
  { 0x0142, 0x00FD, -15 },
  { 0x0142, 0x00FF, -15 },
  { 0x006D, 0x0075, -20 },
  { 0x006D, 0x00FA, -20 },
  { 0x006D, 0x00FB, -20 },
  { 0x006D, 0x00FC, -20 },
  { 0x006D, 0x00F9, -20 },
  { 0x006D, 0x0171, -20 },
  { 0x006D, 0x016B, -20 },
  { 0x006D, 0x0173, -20 },
  { 0x006D, 0x016F, -20 },
  { 0x006D, 0x0079, -30 },
  { 0x006D, 0x00FD, -30 },
  { 0x006D, 0x00FF, -30 },
  { 0x006E, 0x0075, -10 },
  { 0x006E, 0x00FA, -10 },
  { 0x006E, 0x00FB, -10 },
  { 0x006E, 0x00FC, -10 },
  { 0x006E, 0x00F9, -10 },
  { 0x006E, 0x0171, -10 },
  { 0x006E, 0x016B, -10 },
  { 0x006E, 0x0173, -10 },
  { 0x006E, 0x016F, -10 },
  { 0x006E, 0x0076, -40 },
  { 0x006E, 0x0079, -20 },
  { 0x006E, 0x00FD, -20 },
  { 0x006E, 0x00FF, -20 },
  { 0x0144, 0x0075, -10 },
  { 0x0144, 0x00FA, -10 },
  { 0x0144, 0x00FB, -10 },
  { 0x0144, 0x00FC, -10 },
  { 0x0144, 0x00F9, -10 },
  { 0x0144, 0x0171, -10 },
  { 0x0144, 0x016B, -10 },
  { 0x0144, 0x0173, -10 },
  { 0x0144, 0x016F, -10 },
  { 0x0144, 0x0076, -40 },
  { 0x0144, 0x0079, -20 },
  { 0x0144, 0x00FD, -20 },
  { 0x0144, 0x00FF, -20 },
  { 0x0148, 0x0075, -10 },
  { 0x0148, 0x00FA, -10 },
  { 0x0148, 0x00FB, -10 },
  { 0x0148, 0x00FC, -10 },
  { 0x0148, 0x00F9, -10 },
  { 0x0148, 0x0171, -10 },
  { 0x0148, 0x016B, -10 },
  { 0x0148, 0x0173, -10 },
  { 0x0148, 0x016F, -10 },
  { 0x0148, 0x0076, -40 },
  { 0x0148, 0x0079, -20 },
  { 0x0148, 0x00FD, -20 },
  { 0x0148, 0x00FF, -20 },
  { 0x0146, 0x0075, -10 },
  { 0x0146, 0x00FA, -10 },
  { 0x0146, 0x00FB, -10 },
  { 0x0146, 0x00FC, -10 },
  { 0x0146, 0x00F9, -10 },
  { 0x0146, 0x0171, -10 },
  { 0x0146, 0x016B, -10 },
  { 0x0146, 0x0173, -10 },
  { 0x0146, 0x016F, -10 },
  { 0x0146, 0x0076, -40 },
  { 0x0146, 0x0079, -20 },
  { 0x0146, 0x00FD, -20 },
  { 0x0146, 0x00FF, -20 },
  { 0x00F1, 0x0075, -10 },
  { 0x00F1, 0x00FA, -10 },
  { 0x00F1, 0x00FB, -10 },
  { 0x00F1, 0x00FC, -10 },
  { 0x00F1, 0x00F9, -10 },
  { 0x00F1, 0x0171, -10 },
  { 0x00F1, 0x016B, -10 },
  { 0x00F1, 0x0173, -10 },
  { 0x00F1, 0x016F, -10 },
  { 0x00F1, 0x0076, -40 },
  { 0x00F1, 0x0079, -20 },
  { 0x00F1, 0x00FD, -20 },
  { 0x00F1, 0x00FF, -20 },
  { 0x006F, 0x0076, -20 },
  { 0x006F, 0x0077, -15 },
  { 0x006F, 0x0078, -30 },
  { 0x006F, 0x0079, -20 },
  { 0x006F, 0x00FD, -20 },
  { 0x006F, 0x00FF, -20 },
  { 0x00F3, 0x0076, -20 },
  { 0x00F3, 0x0077, -15 },
  { 0x00F3, 0x0078, -30 },
  { 0x00F3, 0x0079, -20 },
  { 0x00F3, 0x00FD, -20 },
  { 0x00F3, 0x00FF, -20 },
  { 0x00F4, 0x0076, -20 },
  { 0x00F4, 0x0077, -15 },
  { 0x00F4, 0x0078, -30 },
  { 0x00F4, 0x0079, -20 },
  { 0x00F4, 0x00FD, -20 },
  { 0x00F4, 0x00FF, -20 },
  { 0x00F6, 0x0076, -20 },
  { 0x00F6, 0x0077, -15 },
  { 0x00F6, 0x0078, -30 },
  { 0x00F6, 0x0079, -20 },
  { 0x00F6, 0x00FD, -20 },
  { 0x00F6, 0x00FF, -20 },
  { 0x00F2, 0x0076, -20 },
  { 0x00F2, 0x0077, -15 },
  { 0x00F2, 0x0078, -30 },
  { 0x00F2, 0x0079, -20 },
  { 0x00F2, 0x00FD, -20 },
  { 0x00F2, 0x00FF, -20 },
  { 0x0151, 0x0076, -20 },
  { 0x0151, 0x0077, -15 },
  { 0x0151, 0x0078, -30 },
  { 0x0151, 0x0079, -20 },
  { 0x0151, 0x00FD, -20 },
  { 0x0151, 0x00FF, -20 },
  { 0x014D, 0x0076, -20 },
  { 0x014D, 0x0077, -15 },
  { 0x014D, 0x0078, -30 },
  { 0x014D, 0x0079, -20 },
  { 0x014D, 0x00FD, -20 },
  { 0x014D, 0x00FF, -20 },
  { 0x00F8, 0x0076, -20 },
  { 0x00F8, 0x0077, -15 },
  { 0x00F8, 0x0078, -30 },
  { 0x00F8, 0x0079, -20 },
  { 0x00F8, 0x00FD, -20 },
  { 0x00F8, 0x00FF, -20 },
  { 0x00F5, 0x0076, -20 },
  { 0x00F5, 0x0077, -15 },
  { 0x00F5, 0x0078, -30 },
  { 0x00F5, 0x0079, -20 },
  { 0x00F5, 0x00FD, -20 },
  { 0x00F5, 0x00FF, -20 },
  { 0x0070, 0x0079, -15 },
  { 0x0070, 0x00FD, -15 },
  { 0x0070, 0x00FF, -15 },
  { 0x002E, 0x201D, -120 },
  { 0x002E, 0x2019, -120 },
  { 0x002E, 0x0020, -40 },
  { 0x201D, 0x0020, -80 },
  { 0x2018, 0x2018, -46 },
  { 0x2019, 0x0064, -80 },
  { 0x2019, 0x0111, -80 },
  { 0x2019, 0x006C, -20 },
  { 0x2019, 0x013A, -20 },
  { 0x2019, 0x013C, -20 },
  { 0x2019, 0x0142, -20 },
  { 0x2019, 0x2019, -46 },
  { 0x2019, 0x0072, -40 },
  { 0x2019, 0x0155, -40 },
  { 0x2019, 0x0159, -40 },
  { 0x2019, 0x0157, -40 },
  { 0x2019, 0x0073, -60 },
  { 0x2019, 0x015B, -60 },
  { 0x2019, 0x0161, -60 },
  { 0x2019, 0x015F, -60 },
  { 0x2019, 0x0219, -60 },
  { 0x2019, 0x0020, -80 },
  { 0x2019, 0x0076, -20 },
  { 0x0072, 0x0063, -20 },
  { 0x0072, 0x0107, -20 },
  { 0x0072, 0x010D, -20 },
  { 0x0072, 0x00E7, -20 },
  { 0x0072, 0x002C, -60 },
  { 0x0072, 0x0064, -20 },
  { 0x0072, 0x0111, -20 },
  { 0x0072, 0x0067, -15 },
  { 0x0072, 0x011F, -15 },
  { 0x0072, 0x0123, -15 },
  { 0x0072, 0x002D, -20 },
  { 0x0072, 0x006F, -20 },
  { 0x0072, 0x00F3, -20 },
  { 0x0072, 0x00F4, -20 },
  { 0x0072, 0x00F6, -20 },
  { 0x0072, 0x00F2, -20 },
  { 0x0072, 0x0151, -20 },
  { 0x0072, 0x014D, -20 },
  { 0x0072, 0x00F8, -20 },
  { 0x0072, 0x00F5, -20 },
  { 0x0072, 0x002E, -60 },
  { 0x0072, 0x0071, -20 },
  { 0x0072, 0x0073, -15 },
  { 0x0072, 0x015B, -15 },
  { 0x0072, 0x0161, -15 },
  { 0x0072, 0x015F, -15 },
  { 0x0072, 0x0219, -15 },
  { 0x0072, 0x0074, 20 },
  { 0x0072, 0x0163, 20 },
  { 0x0072, 0x0076, 10 },
  { 0x0072, 0x0079, 10 },
  { 0x0072, 0x00FD, 10 },
  { 0x0072, 0x00FF, 10 },
  { 0x0155, 0x0063, -20 },
  { 0x0155, 0x0107, -20 },
  { 0x0155, 0x010D, -20 },
  { 0x0155, 0x00E7, -20 },
  { 0x0155, 0x002C, -60 },
  { 0x0155, 0x0064, -20 },
  { 0x0155, 0x0111, -20 },
  { 0x0155, 0x0067, -15 },
  { 0x0155, 0x011F, -15 },
  { 0x0155, 0x0123, -15 },
  { 0x0155, 0x002D, -20 },
  { 0x0155, 0x006F, -20 },
  { 0x0155, 0x00F3, -20 },
  { 0x0155, 0x00F4, -20 },
  { 0x0155, 0x00F6, -20 },
  { 0x0155, 0x00F2, -20 },
  { 0x0155, 0x0151, -20 },
  { 0x0155, 0x014D, -20 },
  { 0x0155, 0x00F8, -20 },
  { 0x0155, 0x00F5, -20 },
  { 0x0155, 0x002E, -60 },
  { 0x0155, 0x0071, -20 },
  { 0x0155, 0x0073, -15 },
  { 0x0155, 0x015B, -15 },
  { 0x0155, 0x0161, -15 },
  { 0x0155, 0x015F, -15 },
  { 0x0155, 0x0219, -15 },
  { 0x0155, 0x0074, 20 },
  { 0x0155, 0x0163, 20 },
  { 0x0155, 0x0076, 10 },
  { 0x0155, 0x0079, 10 },
  { 0x0155, 0x00FD, 10 },
  { 0x0155, 0x00FF, 10 },
  { 0x0159, 0x0063, -20 },
  { 0x0159, 0x0107, -20 },
  { 0x0159, 0x010D, -20 },
  { 0x0159, 0x00E7, -20 },
  { 0x0159, 0x002C, -60 },
  { 0x0159, 0x0064, -20 },
  { 0x0159, 0x0111, -20 },
  { 0x0159, 0x0067, -15 },
  { 0x0159, 0x011F, -15 },
  { 0x0159, 0x0123, -15 },
  { 0x0159, 0x002D, -20 },
  { 0x0159, 0x006F, -20 },
  { 0x0159, 0x00F3, -20 },
  { 0x0159, 0x00F4, -20 },
  { 0x0159, 0x00F6, -20 },
  { 0x0159, 0x00F2, -20 },
  { 0x0159, 0x0151, -20 },
  { 0x0159, 0x014D, -20 },
  { 0x0159, 0x00F8, -20 },
  { 0x0159, 0x00F5, -20 },
  { 0x0159, 0x002E, -60 },
  { 0x0159, 0x0071, -20 },
  { 0x0159, 0x0073, -15 },
  { 0x0159, 0x015B, -15 },
  { 0x0159, 0x0161, -15 },
  { 0x0159, 0x015F, -15 },
  { 0x0159, 0x0219, -15 },
  { 0x0159, 0x0074, 20 },
  { 0x0159, 0x0163, 20 },
  { 0x0159, 0x0076, 10 },
  { 0x0159, 0x0079, 10 },
  { 0x0159, 0x00FD, 10 },
  { 0x0159, 0x00FF, 10 },
  { 0x0157, 0x0063, -20 },
  { 0x0157, 0x0107, -20 },
  { 0x0157, 0x010D, -20 },
  { 0x0157, 0x00E7, -20 },
  { 0x0157, 0x002C, -60 },
  { 0x0157, 0x0064, -20 },
  { 0x0157, 0x0111, -20 },
  { 0x0157, 0x0067, -15 },
  { 0x0157, 0x011F, -15 },
  { 0x0157, 0x0123, -15 },
  { 0x0157, 0x002D, -20 },
  { 0x0157, 0x006F, -20 },
  { 0x0157, 0x00F3, -20 },
  { 0x0157, 0x00F4, -20 },
  { 0x0157, 0x00F6, -20 },
  { 0x0157, 0x00F2, -20 },
  { 0x0157, 0x0151, -20 },
  { 0x0157, 0x014D, -20 },
  { 0x0157, 0x00F8, -20 },
  { 0x0157, 0x00F5, -20 },
  { 0x0157, 0x002E, -60 },
  { 0x0157, 0x0071, -20 },
  { 0x0157, 0x0073, -15 },
  { 0x0157, 0x015B, -15 },
  { 0x0157, 0x0161, -15 },
  { 0x0157, 0x015F, -15 },
  { 0x0157, 0x0219, -15 },
  { 0x0157, 0x0074, 20 },
  { 0x0157, 0x0163, 20 },
  { 0x0157, 0x0076, 10 },
  { 0x0157, 0x0079, 10 },
  { 0x0157, 0x00FD, 10 },
  { 0x0157, 0x00FF, 10 },
  { 0x0073, 0x0077, -15 },
  { 0x015B, 0x0077, -15 },
  { 0x0161, 0x0077, -15 },
  { 0x015F, 0x0077, -15 },
  { 0x0219, 0x0077, -15 },
  { 0x003B, 0x0020, -40 },
  { 0x0020, 0x0054, -100 },
  { 0x0020, 0x0164, -100 },
  { 0x0020, 0x0162, -100 },
  { 0x0020, 0x0056, -80 },
  { 0x0020, 0x0057, -80 },
  { 0x0020, 0x0059, -120 },
  { 0x0020, 0x00DD, -120 },
  { 0x0020, 0x0178, -120 },
  { 0x0020, 0x201C, -80 },
  { 0x0020, 0x2018, -60 },
  { 0x0076, 0x0061, -20 },
  { 0x0076, 0x00E1, -20 },
  { 0x0076, 0x0103, -20 },
  { 0x0076, 0x00E2, -20 },
  { 0x0076, 0x00E4, -20 },
  { 0x0076, 0x00E0, -20 },
  { 0x0076, 0x0101, -20 },
  { 0x0076, 0x0105, -20 },
  { 0x0076, 0x00E5, -20 },
  { 0x0076, 0x00E3, -20 },
  { 0x0076, 0x002C, -80 },
  { 0x0076, 0x006F, -30 },
  { 0x0076, 0x00F3, -30 },
  { 0x0076, 0x00F4, -30 },
  { 0x0076, 0x00F6, -30 },
  { 0x0076, 0x00F2, -30 },
  { 0x0076, 0x0151, -30 },
  { 0x0076, 0x014D, -30 },
  { 0x0076, 0x00F8, -30 },
  { 0x0076, 0x00F5, -30 },
  { 0x0076, 0x002E, -80 },
  { 0x0077, 0x002C, -40 },
  { 0x0077, 0x006F, -20 },
  { 0x0077, 0x00F3, -20 },
  { 0x0077, 0x00F4, -20 },
  { 0x0077, 0x00F6, -20 },
  { 0x0077, 0x00F2, -20 },
  { 0x0077, 0x0151, -20 },
  { 0x0077, 0x014D, -20 },
  { 0x0077, 0x00F8, -20 },
  { 0x0077, 0x00F5, -20 },
  { 0x0077, 0x002E, -40 },
  { 0x0078, 0x0065, -10 },
  { 0x0078, 0x00E9, -10 },
  { 0x0078, 0x011B, -10 },
  { 0x0078, 0x00EA, -10 },
  { 0x0078, 0x00EB, -10 },
  { 0x0078, 0x0117, -10 },
  { 0x0078, 0x00E8, -10 },
  { 0x0078, 0x0113, -10 },
  { 0x0078, 0x0119, -10 },
  { 0x0079, 0x0061, -30 },
  { 0x0079, 0x00E1, -30 },
  { 0x0079, 0x0103, -30 },
  { 0x0079, 0x00E2, -30 },
  { 0x0079, 0x00E4, -30 },
  { 0x0079, 0x00E0, -30 },
  { 0x0079, 0x0101, -30 },
  { 0x0079, 0x0105, -30 },
  { 0x0079, 0x00E5, -30 },
  { 0x0079, 0x00E3, -30 },
  { 0x0079, 0x002C, -80 },
  { 0x0079, 0x0065, -10 },
  { 0x0079, 0x00E9, -10 },
  { 0x0079, 0x011B, -10 },
  { 0x0079, 0x00EA, -10 },
  { 0x0079, 0x00EB, -10 },
  { 0x0079, 0x0117, -10 },
  { 0x0079, 0x00E8, -10 },
  { 0x0079, 0x0113, -10 },
  { 0x0079, 0x0119, -10 },
  { 0x0079, 0x006F, -25 },
  { 0x0079, 0x00F3, -25 },
  { 0x0079, 0x00F4, -25 },
  { 0x0079, 0x00F6, -25 },
  { 0x0079, 0x00F2, -25 },
  { 0x0079, 0x0151, -25 },
  { 0x0079, 0x014D, -25 },
  { 0x0079, 0x00F8, -25 },
  { 0x0079, 0x00F5, -25 },
  { 0x0079, 0x002E, -80 },
  { 0x00FD, 0x0061, -30 },
  { 0x00FD, 0x00E1, -30 },
  { 0x00FD, 0x0103, -30 },
  { 0x00FD, 0x00E2, -30 },
  { 0x00FD, 0x00E4, -30 },
  { 0x00FD, 0x00E0, -30 },
  { 0x00FD, 0x0101, -30 },
  { 0x00FD, 0x0105, -30 },
  { 0x00FD, 0x00E5, -30 },
  { 0x00FD, 0x00E3, -30 },
  { 0x00FD, 0x002C, -80 },
  { 0x00FD, 0x0065, -10 },
  { 0x00FD, 0x00E9, -10 },
  { 0x00FD, 0x011B, -10 },
  { 0x00FD, 0x00EA, -10 },
  { 0x00FD, 0x00EB, -10 },
  { 0x00FD, 0x0117, -10 },
  { 0x00FD, 0x00E8, -10 },
  { 0x00FD, 0x0113, -10 },
  { 0x00FD, 0x0119, -10 },
  { 0x00FD, 0x006F, -25 },
  { 0x00FD, 0x00F3, -25 },
  { 0x00FD, 0x00F4, -25 },
  { 0x00FD, 0x00F6, -25 },
  { 0x00FD, 0x00F2, -25 },
  { 0x00FD, 0x0151, -25 },
  { 0x00FD, 0x014D, -25 },
  { 0x00FD, 0x00F8, -25 },
  { 0x00FD, 0x00F5, -25 },
  { 0x00FD, 0x002E, -80 },
  { 0x00FF, 0x0061, -30 },
  { 0x00FF, 0x00E1, -30 },
  { 0x00FF, 0x0103, -30 },
  { 0x00FF, 0x00E2, -30 },
  { 0x00FF, 0x00E4, -30 },
  { 0x00FF, 0x00E0, -30 },
  { 0x00FF, 0x0101, -30 },
  { 0x00FF, 0x0105, -30 },
  { 0x00FF, 0x00E5, -30 },
  { 0x00FF, 0x00E3, -30 },
  { 0x00FF, 0x002C, -80 },
  { 0x00FF, 0x0065, -10 },
  { 0x00FF, 0x00E9, -10 },
  { 0x00FF, 0x011B, -10 },
  { 0x00FF, 0x00EA, -10 },
  { 0x00FF, 0x00EB, -10 },
  { 0x00FF, 0x0117, -10 },
  { 0x00FF, 0x00E8, -10 },
  { 0x00FF, 0x0113, -10 },
  { 0x00FF, 0x0119, -10 },
  { 0x00FF, 0x006F, -25 },
  { 0x00FF, 0x00F3, -25 },
  { 0x00FF, 0x00F4, -25 },
  { 0x00FF, 0x00F6, -25 },
  { 0x00FF, 0x00F2, -25 },
  { 0x00FF, 0x0151, -25 },
  { 0x00FF, 0x014D, -25 },
  { 0x00FF, 0x00F8, -25 },
  { 0x00FF, 0x00F5, -25 },
  { 0x00FF, 0x002E, -80 },
  { 0x007A, 0x0065, 10 },
  { 0x007A, 0x00E9, 10 },
  { 0x007A, 0x011B, 10 },
  { 0x007A, 0x00EA, 10 },
  { 0x007A, 0x00EB, 10 },
  { 0x007A, 0x0117, 10 },
  { 0x007A, 0x00E8, 10 },
  { 0x007A, 0x0113, 10 },
  { 0x007A, 0x0119, 10 },
  { 0x017A, 0x0065, 10 },
  { 0x017A, 0x00E9, 10 },
  { 0x017A, 0x011B, 10 },
  { 0x017A, 0x00EA, 10 },
  { 0x017A, 0x00EB, 10 },
  { 0x017A, 0x0117, 10 },
  { 0x017A, 0x00E8, 10 },
  { 0x017A, 0x0113, 10 },
  { 0x017A, 0x0119, 10 },
  { 0x017E, 0x0065, 10 },
  { 0x017E, 0x00E9, 10 },
  { 0x017E, 0x011B, 10 },
  { 0x017E, 0x00EA, 10 },
  { 0x017E, 0x00EB, 10 },
  { 0x017E, 0x0117, 10 },
  { 0x017E, 0x00E8, 10 },
  { 0x017E, 0x0113, 10 },
  { 0x017E, 0x0119, 10 },
  { 0x017C, 0x0065, 10 },
  { 0x017C, 0x00E9, 10 },
  { 0x017C, 0x011B, 10 },
  { 0x017C, 0x00EA, 10 },
  { 0x017C, 0x00EB, 10 },
  { 0x017C, 0x0117, 10 },
  { 0x017C, 0x00E8, 10 },
  { 0x017C, 0x0113, 10 },
  { 0x017C, 0x0119, 10 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableHelveticaBoldOblique[] =
{
  { 0x0041, 0x0043, -40 },
  { 0x0041, 0x0106, -40 },
  { 0x0041, 0x010C, -40 },
  { 0x0041, 0x00C7, -40 },
  { 0x0041, 0x0047, -50 },
  { 0x0041, 0x011E, -50 },
  { 0x0041, 0x0122, -50 },
  { 0x0041, 0x004F, -40 },
  { 0x0041, 0x00D3, -40 },
  { 0x0041, 0x00D4, -40 },
  { 0x0041, 0x00D6, -40 },
  { 0x0041, 0x00D2, -40 },
  { 0x0041, 0x0150, -40 },
  { 0x0041, 0x014C, -40 },
  { 0x0041, 0x00D8, -40 },
  { 0x0041, 0x00D5, -40 },
  { 0x0041, 0x0051, -40 },
  { 0x0041, 0x0054, -90 },
  { 0x0041, 0x0164, -90 },
  { 0x0041, 0x0162, -90 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -80 },
  { 0x0041, 0x0057, -60 },
  { 0x0041, 0x0059, -110 },
  { 0x0041, 0x00DD, -110 },
  { 0x0041, 0x0178, -110 },
  { 0x0041, 0x0075, -30 },
  { 0x0041, 0x00FA, -30 },
  { 0x0041, 0x00FB, -30 },
  { 0x0041, 0x00FC, -30 },
  { 0x0041, 0x00F9, -30 },
  { 0x0041, 0x0171, -30 },
  { 0x0041, 0x016B, -30 },
  { 0x0041, 0x0173, -30 },
  { 0x0041, 0x016F, -30 },
  { 0x0041, 0x0076, -40 },
  { 0x0041, 0x0077, -30 },
  { 0x0041, 0x0079, -30 },
  { 0x0041, 0x00FD, -30 },
  { 0x0041, 0x00FF, -30 },
  { 0x00C1, 0x0043, -40 },
  { 0x00C1, 0x0106, -40 },
  { 0x00C1, 0x010C, -40 },
  { 0x00C1, 0x00C7, -40 },
  { 0x00C1, 0x0047, -50 },
  { 0x00C1, 0x011E, -50 },
  { 0x00C1, 0x0122, -50 },
  { 0x00C1, 0x004F, -40 },
  { 0x00C1, 0x00D3, -40 },
  { 0x00C1, 0x00D4, -40 },
  { 0x00C1, 0x00D6, -40 },
  { 0x00C1, 0x00D2, -40 },
  { 0x00C1, 0x0150, -40 },
  { 0x00C1, 0x014C, -40 },
  { 0x00C1, 0x00D8, -40 },
  { 0x00C1, 0x00D5, -40 },
  { 0x00C1, 0x0051, -40 },
  { 0x00C1, 0x0054, -90 },
  { 0x00C1, 0x0164, -90 },
  { 0x00C1, 0x0162, -90 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -80 },
  { 0x00C1, 0x0057, -60 },
  { 0x00C1, 0x0059, -110 },
  { 0x00C1, 0x00DD, -110 },
  { 0x00C1, 0x0178, -110 },
  { 0x00C1, 0x0075, -30 },
  { 0x00C1, 0x00FA, -30 },
  { 0x00C1, 0x00FB, -30 },
  { 0x00C1, 0x00FC, -30 },
  { 0x00C1, 0x00F9, -30 },
  { 0x00C1, 0x0171, -30 },
  { 0x00C1, 0x016B, -30 },
  { 0x00C1, 0x0173, -30 },
  { 0x00C1, 0x016F, -30 },
  { 0x00C1, 0x0076, -40 },
  { 0x00C1, 0x0077, -30 },
  { 0x00C1, 0x0079, -30 },
  { 0x00C1, 0x00FD, -30 },
  { 0x00C1, 0x00FF, -30 },
  { 0x0102, 0x0043, -40 },
  { 0x0102, 0x0106, -40 },
  { 0x0102, 0x010C, -40 },
  { 0x0102, 0x00C7, -40 },
  { 0x0102, 0x0047, -50 },
  { 0x0102, 0x011E, -50 },
  { 0x0102, 0x0122, -50 },
  { 0x0102, 0x004F, -40 },
  { 0x0102, 0x00D3, -40 },
  { 0x0102, 0x00D4, -40 },
  { 0x0102, 0x00D6, -40 },
  { 0x0102, 0x00D2, -40 },
  { 0x0102, 0x0150, -40 },
  { 0x0102, 0x014C, -40 },
  { 0x0102, 0x00D8, -40 },
  { 0x0102, 0x00D5, -40 },
  { 0x0102, 0x0051, -40 },
  { 0x0102, 0x0054, -90 },
  { 0x0102, 0x0164, -90 },
  { 0x0102, 0x0162, -90 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -80 },
  { 0x0102, 0x0057, -60 },
  { 0x0102, 0x0059, -110 },
  { 0x0102, 0x00DD, -110 },
  { 0x0102, 0x0178, -110 },
  { 0x0102, 0x0075, -30 },
  { 0x0102, 0x00FA, -30 },
  { 0x0102, 0x00FB, -30 },
  { 0x0102, 0x00FC, -30 },
  { 0x0102, 0x00F9, -30 },
  { 0x0102, 0x0171, -30 },
  { 0x0102, 0x016B, -30 },
  { 0x0102, 0x0173, -30 },
  { 0x0102, 0x016F, -30 },
  { 0x0102, 0x0076, -40 },
  { 0x0102, 0x0077, -30 },
  { 0x0102, 0x0079, -30 },
  { 0x0102, 0x00FD, -30 },
  { 0x0102, 0x00FF, -30 },
  { 0x00C2, 0x0043, -40 },
  { 0x00C2, 0x0106, -40 },
  { 0x00C2, 0x010C, -40 },
  { 0x00C2, 0x00C7, -40 },
  { 0x00C2, 0x0047, -50 },
  { 0x00C2, 0x011E, -50 },
  { 0x00C2, 0x0122, -50 },
  { 0x00C2, 0x004F, -40 },
  { 0x00C2, 0x00D3, -40 },
  { 0x00C2, 0x00D4, -40 },
  { 0x00C2, 0x00D6, -40 },
  { 0x00C2, 0x00D2, -40 },
  { 0x00C2, 0x0150, -40 },
  { 0x00C2, 0x014C, -40 },
  { 0x00C2, 0x00D8, -40 },
  { 0x00C2, 0x00D5, -40 },
  { 0x00C2, 0x0051, -40 },
  { 0x00C2, 0x0054, -90 },
  { 0x00C2, 0x0164, -90 },
  { 0x00C2, 0x0162, -90 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -80 },
  { 0x00C2, 0x0057, -60 },
  { 0x00C2, 0x0059, -110 },
  { 0x00C2, 0x00DD, -110 },
  { 0x00C2, 0x0178, -110 },
  { 0x00C2, 0x0075, -30 },
  { 0x00C2, 0x00FA, -30 },
  { 0x00C2, 0x00FB, -30 },
  { 0x00C2, 0x00FC, -30 },
  { 0x00C2, 0x00F9, -30 },
  { 0x00C2, 0x0171, -30 },
  { 0x00C2, 0x016B, -30 },
  { 0x00C2, 0x0173, -30 },
  { 0x00C2, 0x016F, -30 },
  { 0x00C2, 0x0076, -40 },
  { 0x00C2, 0x0077, -30 },
  { 0x00C2, 0x0079, -30 },
  { 0x00C2, 0x00FD, -30 },
  { 0x00C2, 0x00FF, -30 },
  { 0x00C4, 0x0043, -40 },
  { 0x00C4, 0x0106, -40 },
  { 0x00C4, 0x010C, -40 },
  { 0x00C4, 0x00C7, -40 },
  { 0x00C4, 0x0047, -50 },
  { 0x00C4, 0x011E, -50 },
  { 0x00C4, 0x0122, -50 },
  { 0x00C4, 0x004F, -40 },
  { 0x00C4, 0x00D3, -40 },
  { 0x00C4, 0x00D4, -40 },
  { 0x00C4, 0x00D6, -40 },
  { 0x00C4, 0x00D2, -40 },
  { 0x00C4, 0x0150, -40 },
  { 0x00C4, 0x014C, -40 },
  { 0x00C4, 0x00D8, -40 },
  { 0x00C4, 0x00D5, -40 },
  { 0x00C4, 0x0051, -40 },
  { 0x00C4, 0x0054, -90 },
  { 0x00C4, 0x0164, -90 },
  { 0x00C4, 0x0162, -90 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -80 },
  { 0x00C4, 0x0057, -60 },
  { 0x00C4, 0x0059, -110 },
  { 0x00C4, 0x00DD, -110 },
  { 0x00C4, 0x0178, -110 },
  { 0x00C4, 0x0075, -30 },
  { 0x00C4, 0x00FA, -30 },
  { 0x00C4, 0x00FB, -30 },
  { 0x00C4, 0x00FC, -30 },
  { 0x00C4, 0x00F9, -30 },
  { 0x00C4, 0x0171, -30 },
  { 0x00C4, 0x016B, -30 },
  { 0x00C4, 0x0173, -30 },
  { 0x00C4, 0x016F, -30 },
  { 0x00C4, 0x0076, -40 },
  { 0x00C4, 0x0077, -30 },
  { 0x00C4, 0x0079, -30 },
  { 0x00C4, 0x00FD, -30 },
  { 0x00C4, 0x00FF, -30 },
  { 0x00C0, 0x0043, -40 },
  { 0x00C0, 0x0106, -40 },
  { 0x00C0, 0x010C, -40 },
  { 0x00C0, 0x00C7, -40 },
  { 0x00C0, 0x0047, -50 },
  { 0x00C0, 0x011E, -50 },
  { 0x00C0, 0x0122, -50 },
  { 0x00C0, 0x004F, -40 },
  { 0x00C0, 0x00D3, -40 },
  { 0x00C0, 0x00D4, -40 },
  { 0x00C0, 0x00D6, -40 },
  { 0x00C0, 0x00D2, -40 },
  { 0x00C0, 0x0150, -40 },
  { 0x00C0, 0x014C, -40 },
  { 0x00C0, 0x00D8, -40 },
  { 0x00C0, 0x00D5, -40 },
  { 0x00C0, 0x0051, -40 },
  { 0x00C0, 0x0054, -90 },
  { 0x00C0, 0x0164, -90 },
  { 0x00C0, 0x0162, -90 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -80 },
  { 0x00C0, 0x0057, -60 },
  { 0x00C0, 0x0059, -110 },
  { 0x00C0, 0x00DD, -110 },
  { 0x00C0, 0x0178, -110 },
  { 0x00C0, 0x0075, -30 },
  { 0x00C0, 0x00FA, -30 },
  { 0x00C0, 0x00FB, -30 },
  { 0x00C0, 0x00FC, -30 },
  { 0x00C0, 0x00F9, -30 },
  { 0x00C0, 0x0171, -30 },
  { 0x00C0, 0x016B, -30 },
  { 0x00C0, 0x0173, -30 },
  { 0x00C0, 0x016F, -30 },
  { 0x00C0, 0x0076, -40 },
  { 0x00C0, 0x0077, -30 },
  { 0x00C0, 0x0079, -30 },
  { 0x00C0, 0x00FD, -30 },
  { 0x00C0, 0x00FF, -30 },
  { 0x0100, 0x0043, -40 },
  { 0x0100, 0x0106, -40 },
  { 0x0100, 0x010C, -40 },
  { 0x0100, 0x00C7, -40 },
  { 0x0100, 0x0047, -50 },
  { 0x0100, 0x011E, -50 },
  { 0x0100, 0x0122, -50 },
  { 0x0100, 0x004F, -40 },
  { 0x0100, 0x00D3, -40 },
  { 0x0100, 0x00D4, -40 },
  { 0x0100, 0x00D6, -40 },
  { 0x0100, 0x00D2, -40 },
  { 0x0100, 0x0150, -40 },
  { 0x0100, 0x014C, -40 },
  { 0x0100, 0x00D8, -40 },
  { 0x0100, 0x00D5, -40 },
  { 0x0100, 0x0051, -40 },
  { 0x0100, 0x0054, -90 },
  { 0x0100, 0x0164, -90 },
  { 0x0100, 0x0162, -90 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -80 },
  { 0x0100, 0x0057, -60 },
  { 0x0100, 0x0059, -110 },
  { 0x0100, 0x00DD, -110 },
  { 0x0100, 0x0178, -110 },
  { 0x0100, 0x0075, -30 },
  { 0x0100, 0x00FA, -30 },
  { 0x0100, 0x00FB, -30 },
  { 0x0100, 0x00FC, -30 },
  { 0x0100, 0x00F9, -30 },
  { 0x0100, 0x0171, -30 },
  { 0x0100, 0x016B, -30 },
  { 0x0100, 0x0173, -30 },
  { 0x0100, 0x016F, -30 },
  { 0x0100, 0x0076, -40 },
  { 0x0100, 0x0077, -30 },
  { 0x0100, 0x0079, -30 },
  { 0x0100, 0x00FD, -30 },
  { 0x0100, 0x00FF, -30 },
  { 0x0104, 0x0043, -40 },
  { 0x0104, 0x0106, -40 },
  { 0x0104, 0x010C, -40 },
  { 0x0104, 0x00C7, -40 },
  { 0x0104, 0x0047, -50 },
  { 0x0104, 0x011E, -50 },
  { 0x0104, 0x0122, -50 },
  { 0x0104, 0x004F, -40 },
  { 0x0104, 0x00D3, -40 },
  { 0x0104, 0x00D4, -40 },
  { 0x0104, 0x00D6, -40 },
  { 0x0104, 0x00D2, -40 },
  { 0x0104, 0x0150, -40 },
  { 0x0104, 0x014C, -40 },
  { 0x0104, 0x00D8, -40 },
  { 0x0104, 0x00D5, -40 },
  { 0x0104, 0x0051, -40 },
  { 0x0104, 0x0054, -90 },
  { 0x0104, 0x0164, -90 },
  { 0x0104, 0x0162, -90 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -80 },
  { 0x0104, 0x0057, -60 },
  { 0x0104, 0x0059, -110 },
  { 0x0104, 0x00DD, -110 },
  { 0x0104, 0x0178, -110 },
  { 0x0104, 0x0075, -30 },
  { 0x0104, 0x00FA, -30 },
  { 0x0104, 0x00FB, -30 },
  { 0x0104, 0x00FC, -30 },
  { 0x0104, 0x00F9, -30 },
  { 0x0104, 0x0171, -30 },
  { 0x0104, 0x016B, -30 },
  { 0x0104, 0x0173, -30 },
  { 0x0104, 0x016F, -30 },
  { 0x0104, 0x0076, -40 },
  { 0x0104, 0x0077, -30 },
  { 0x0104, 0x0079, -30 },
  { 0x0104, 0x00FD, -30 },
  { 0x0104, 0x00FF, -30 },
  { 0x00C5, 0x0043, -40 },
  { 0x00C5, 0x0106, -40 },
  { 0x00C5, 0x010C, -40 },
  { 0x00C5, 0x00C7, -40 },
  { 0x00C5, 0x0047, -50 },
  { 0x00C5, 0x011E, -50 },
  { 0x00C5, 0x0122, -50 },
  { 0x00C5, 0x004F, -40 },
  { 0x00C5, 0x00D3, -40 },
  { 0x00C5, 0x00D4, -40 },
  { 0x00C5, 0x00D6, -40 },
  { 0x00C5, 0x00D2, -40 },
  { 0x00C5, 0x0150, -40 },
  { 0x00C5, 0x014C, -40 },
  { 0x00C5, 0x00D8, -40 },
  { 0x00C5, 0x00D5, -40 },
  { 0x00C5, 0x0051, -40 },
  { 0x00C5, 0x0054, -90 },
  { 0x00C5, 0x0164, -90 },
  { 0x00C5, 0x0162, -90 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -80 },
  { 0x00C5, 0x0057, -60 },
  { 0x00C5, 0x0059, -110 },
  { 0x00C5, 0x00DD, -110 },
  { 0x00C5, 0x0178, -110 },
  { 0x00C5, 0x0075, -30 },
  { 0x00C5, 0x00FA, -30 },
  { 0x00C5, 0x00FB, -30 },
  { 0x00C5, 0x00FC, -30 },
  { 0x00C5, 0x00F9, -30 },
  { 0x00C5, 0x0171, -30 },
  { 0x00C5, 0x016B, -30 },
  { 0x00C5, 0x0173, -30 },
  { 0x00C5, 0x016F, -30 },
  { 0x00C5, 0x0076, -40 },
  { 0x00C5, 0x0077, -30 },
  { 0x00C5, 0x0079, -30 },
  { 0x00C5, 0x00FD, -30 },
  { 0x00C5, 0x00FF, -30 },
  { 0x00C3, 0x0043, -40 },
  { 0x00C3, 0x0106, -40 },
  { 0x00C3, 0x010C, -40 },
  { 0x00C3, 0x00C7, -40 },
  { 0x00C3, 0x0047, -50 },
  { 0x00C3, 0x011E, -50 },
  { 0x00C3, 0x0122, -50 },
  { 0x00C3, 0x004F, -40 },
  { 0x00C3, 0x00D3, -40 },
  { 0x00C3, 0x00D4, -40 },
  { 0x00C3, 0x00D6, -40 },
  { 0x00C3, 0x00D2, -40 },
  { 0x00C3, 0x0150, -40 },
  { 0x00C3, 0x014C, -40 },
  { 0x00C3, 0x00D8, -40 },
  { 0x00C3, 0x00D5, -40 },
  { 0x00C3, 0x0051, -40 },
  { 0x00C3, 0x0054, -90 },
  { 0x00C3, 0x0164, -90 },
  { 0x00C3, 0x0162, -90 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -80 },
  { 0x00C3, 0x0057, -60 },
  { 0x00C3, 0x0059, -110 },
  { 0x00C3, 0x00DD, -110 },
  { 0x00C3, 0x0178, -110 },
  { 0x00C3, 0x0075, -30 },
  { 0x00C3, 0x00FA, -30 },
  { 0x00C3, 0x00FB, -30 },
  { 0x00C3, 0x00FC, -30 },
  { 0x00C3, 0x00F9, -30 },
  { 0x00C3, 0x0171, -30 },
  { 0x00C3, 0x016B, -30 },
  { 0x00C3, 0x0173, -30 },
  { 0x00C3, 0x016F, -30 },
  { 0x00C3, 0x0076, -40 },
  { 0x00C3, 0x0077, -30 },
  { 0x00C3, 0x0079, -30 },
  { 0x00C3, 0x00FD, -30 },
  { 0x00C3, 0x00FF, -30 },
  { 0x0042, 0x0041, -30 },
  { 0x0042, 0x00C1, -30 },
  { 0x0042, 0x0102, -30 },
  { 0x0042, 0x00C2, -30 },
  { 0x0042, 0x00C4, -30 },
  { 0x0042, 0x00C0, -30 },
  { 0x0042, 0x0100, -30 },
  { 0x0042, 0x0104, -30 },
  { 0x0042, 0x00C5, -30 },
  { 0x0042, 0x00C3, -30 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0044, 0x0041, -40 },
  { 0x0044, 0x00C1, -40 },
  { 0x0044, 0x0102, -40 },
  { 0x0044, 0x00C2, -40 },
  { 0x0044, 0x00C4, -40 },
  { 0x0044, 0x00C0, -40 },
  { 0x0044, 0x0100, -40 },
  { 0x0044, 0x0104, -40 },
  { 0x0044, 0x00C5, -40 },
  { 0x0044, 0x00C3, -40 },
  { 0x0044, 0x0056, -40 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -70 },
  { 0x0044, 0x00DD, -70 },
  { 0x0044, 0x0178, -70 },
  { 0x0044, 0x002C, -30 },
  { 0x0044, 0x002E, -30 },
  { 0x010E, 0x0041, -40 },
  { 0x010E, 0x00C1, -40 },
  { 0x010E, 0x0102, -40 },
  { 0x010E, 0x00C2, -40 },
  { 0x010E, 0x00C4, -40 },
  { 0x010E, 0x00C0, -40 },
  { 0x010E, 0x0100, -40 },
  { 0x010E, 0x0104, -40 },
  { 0x010E, 0x00C5, -40 },
  { 0x010E, 0x00C3, -40 },
  { 0x010E, 0x0056, -40 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -70 },
  { 0x010E, 0x00DD, -70 },
  { 0x010E, 0x0178, -70 },
  { 0x010E, 0x002C, -30 },
  { 0x010E, 0x002E, -30 },
  { 0x0110, 0x0041, -40 },
  { 0x0110, 0x00C1, -40 },
  { 0x0110, 0x0102, -40 },
  { 0x0110, 0x00C2, -40 },
  { 0x0110, 0x00C4, -40 },
  { 0x0110, 0x00C0, -40 },
  { 0x0110, 0x0100, -40 },
  { 0x0110, 0x0104, -40 },
  { 0x0110, 0x00C5, -40 },
  { 0x0110, 0x00C3, -40 },
  { 0x0110, 0x0056, -40 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -70 },
  { 0x0110, 0x00DD, -70 },
  { 0x0110, 0x0178, -70 },
  { 0x0110, 0x002C, -30 },
  { 0x0110, 0x002E, -30 },
  { 0x0046, 0x0041, -80 },
  { 0x0046, 0x00C1, -80 },
  { 0x0046, 0x0102, -80 },
  { 0x0046, 0x00C2, -80 },
  { 0x0046, 0x00C4, -80 },
  { 0x0046, 0x00C0, -80 },
  { 0x0046, 0x0100, -80 },
  { 0x0046, 0x0104, -80 },
  { 0x0046, 0x00C5, -80 },
  { 0x0046, 0x00C3, -80 },
  { 0x0046, 0x0061, -20 },
  { 0x0046, 0x00E1, -20 },
  { 0x0046, 0x0103, -20 },
  { 0x0046, 0x00E2, -20 },
  { 0x0046, 0x00E4, -20 },
  { 0x0046, 0x00E0, -20 },
  { 0x0046, 0x0101, -20 },
  { 0x0046, 0x0105, -20 },
  { 0x0046, 0x00E5, -20 },
  { 0x0046, 0x00E3, -20 },
  { 0x0046, 0x002C, -100 },
  { 0x0046, 0x002E, -100 },
  { 0x004A, 0x0041, -20 },
  { 0x004A, 0x00C1, -20 },
  { 0x004A, 0x0102, -20 },
  { 0x004A, 0x00C2, -20 },
  { 0x004A, 0x00C4, -20 },
  { 0x004A, 0x00C0, -20 },
  { 0x004A, 0x0100, -20 },
  { 0x004A, 0x0104, -20 },
  { 0x004A, 0x00C5, -20 },
  { 0x004A, 0x00C3, -20 },
  { 0x004A, 0x002C, -20 },
  { 0x004A, 0x002E, -20 },
  { 0x004A, 0x0075, -20 },
  { 0x004A, 0x00FA, -20 },
  { 0x004A, 0x00FB, -20 },
  { 0x004A, 0x00FC, -20 },
  { 0x004A, 0x00F9, -20 },
  { 0x004A, 0x0171, -20 },
  { 0x004A, 0x016B, -20 },
  { 0x004A, 0x0173, -20 },
  { 0x004A, 0x016F, -20 },
  { 0x004B, 0x004F, -30 },
  { 0x004B, 0x00D3, -30 },
  { 0x004B, 0x00D4, -30 },
  { 0x004B, 0x00D6, -30 },
  { 0x004B, 0x00D2, -30 },
  { 0x004B, 0x0150, -30 },
  { 0x004B, 0x014C, -30 },
  { 0x004B, 0x00D8, -30 },
  { 0x004B, 0x00D5, -30 },
  { 0x004B, 0x0065, -15 },
  { 0x004B, 0x00E9, -15 },
  { 0x004B, 0x011B, -15 },
  { 0x004B, 0x00EA, -15 },
  { 0x004B, 0x00EB, -15 },
  { 0x004B, 0x0117, -15 },
  { 0x004B, 0x00E8, -15 },
  { 0x004B, 0x0113, -15 },
  { 0x004B, 0x0119, -15 },
  { 0x004B, 0x006F, -35 },
  { 0x004B, 0x00F3, -35 },
  { 0x004B, 0x00F4, -35 },
  { 0x004B, 0x00F6, -35 },
  { 0x004B, 0x00F2, -35 },
  { 0x004B, 0x0151, -35 },
  { 0x004B, 0x014D, -35 },
  { 0x004B, 0x00F8, -35 },
  { 0x004B, 0x00F5, -35 },
  { 0x004B, 0x0075, -30 },
  { 0x004B, 0x00FA, -30 },
  { 0x004B, 0x00FB, -30 },
  { 0x004B, 0x00FC, -30 },
  { 0x004B, 0x00F9, -30 },
  { 0x004B, 0x0171, -30 },
  { 0x004B, 0x016B, -30 },
  { 0x004B, 0x0173, -30 },
  { 0x004B, 0x016F, -30 },
  { 0x004B, 0x0079, -40 },
  { 0x004B, 0x00FD, -40 },
  { 0x004B, 0x00FF, -40 },
  { 0x0136, 0x004F, -30 },
  { 0x0136, 0x00D3, -30 },
  { 0x0136, 0x00D4, -30 },
  { 0x0136, 0x00D6, -30 },
  { 0x0136, 0x00D2, -30 },
  { 0x0136, 0x0150, -30 },
  { 0x0136, 0x014C, -30 },
  { 0x0136, 0x00D8, -30 },
  { 0x0136, 0x00D5, -30 },
  { 0x0136, 0x0065, -15 },
  { 0x0136, 0x00E9, -15 },
  { 0x0136, 0x011B, -15 },
  { 0x0136, 0x00EA, -15 },
  { 0x0136, 0x00EB, -15 },
  { 0x0136, 0x0117, -15 },
  { 0x0136, 0x00E8, -15 },
  { 0x0136, 0x0113, -15 },
  { 0x0136, 0x0119, -15 },
  { 0x0136, 0x006F, -35 },
  { 0x0136, 0x00F3, -35 },
  { 0x0136, 0x00F4, -35 },
  { 0x0136, 0x00F6, -35 },
  { 0x0136, 0x00F2, -35 },
  { 0x0136, 0x0151, -35 },
  { 0x0136, 0x014D, -35 },
  { 0x0136, 0x00F8, -35 },
  { 0x0136, 0x00F5, -35 },
  { 0x0136, 0x0075, -30 },
  { 0x0136, 0x00FA, -30 },
  { 0x0136, 0x00FB, -30 },
  { 0x0136, 0x00FC, -30 },
  { 0x0136, 0x00F9, -30 },
  { 0x0136, 0x0171, -30 },
  { 0x0136, 0x016B, -30 },
  { 0x0136, 0x0173, -30 },
  { 0x0136, 0x016F, -30 },
  { 0x0136, 0x0079, -40 },
  { 0x0136, 0x00FD, -40 },
  { 0x0136, 0x00FF, -40 },
  { 0x004C, 0x0054, -90 },
  { 0x004C, 0x0164, -90 },
  { 0x004C, 0x0162, -90 },
  { 0x004C, 0x0056, -110 },
  { 0x004C, 0x0057, -80 },
  { 0x004C, 0x0059, -120 },
  { 0x004C, 0x00DD, -120 },
  { 0x004C, 0x0178, -120 },
  { 0x004C, 0x201D, -140 },
  { 0x004C, 0x2019, -140 },
  { 0x004C, 0x0079, -30 },
  { 0x004C, 0x00FD, -30 },
  { 0x004C, 0x00FF, -30 },
  { 0x0139, 0x0054, -90 },
  { 0x0139, 0x0164, -90 },
  { 0x0139, 0x0162, -90 },
  { 0x0139, 0x0056, -110 },
  { 0x0139, 0x0057, -80 },
  { 0x0139, 0x0059, -120 },
  { 0x0139, 0x00DD, -120 },
  { 0x0139, 0x0178, -120 },
  { 0x0139, 0x201D, -140 },
  { 0x0139, 0x2019, -140 },
  { 0x0139, 0x0079, -30 },
  { 0x0139, 0x00FD, -30 },
  { 0x0139, 0x00FF, -30 },
  { 0x013B, 0x0054, -90 },
  { 0x013B, 0x0164, -90 },
  { 0x013B, 0x0162, -90 },
  { 0x013B, 0x0056, -110 },
  { 0x013B, 0x0057, -80 },
  { 0x013B, 0x0059, -120 },
  { 0x013B, 0x00DD, -120 },
  { 0x013B, 0x0178, -120 },
  { 0x013B, 0x201D, -140 },
  { 0x013B, 0x2019, -140 },
  { 0x013B, 0x0079, -30 },
  { 0x013B, 0x00FD, -30 },
  { 0x013B, 0x00FF, -30 },
  { 0x0141, 0x0054, -90 },
  { 0x0141, 0x0164, -90 },
  { 0x0141, 0x0162, -90 },
  { 0x0141, 0x0056, -110 },
  { 0x0141, 0x0057, -80 },
  { 0x0141, 0x0059, -120 },
  { 0x0141, 0x00DD, -120 },
  { 0x0141, 0x0178, -120 },
  { 0x0141, 0x201D, -140 },
  { 0x0141, 0x2019, -140 },
  { 0x0141, 0x0079, -30 },
  { 0x0141, 0x00FD, -30 },
  { 0x0141, 0x00FF, -30 },
  { 0x004F, 0x0041, -50 },
  { 0x004F, 0x00C1, -50 },
  { 0x004F, 0x0102, -50 },
  { 0x004F, 0x00C2, -50 },
  { 0x004F, 0x00C4, -50 },
  { 0x004F, 0x00C0, -50 },
  { 0x004F, 0x0100, -50 },
  { 0x004F, 0x0104, -50 },
  { 0x004F, 0x00C5, -50 },
  { 0x004F, 0x00C3, -50 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -50 },
  { 0x004F, 0x0058, -50 },
  { 0x004F, 0x0059, -70 },
  { 0x004F, 0x00DD, -70 },
  { 0x004F, 0x0178, -70 },
  { 0x004F, 0x002C, -40 },
  { 0x004F, 0x002E, -40 },
  { 0x00D3, 0x0041, -50 },
  { 0x00D3, 0x00C1, -50 },
  { 0x00D3, 0x0102, -50 },
  { 0x00D3, 0x00C2, -50 },
  { 0x00D3, 0x00C4, -50 },
  { 0x00D3, 0x00C0, -50 },
  { 0x00D3, 0x0100, -50 },
  { 0x00D3, 0x0104, -50 },
  { 0x00D3, 0x00C5, -50 },
  { 0x00D3, 0x00C3, -50 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -50 },
  { 0x00D3, 0x0058, -50 },
  { 0x00D3, 0x0059, -70 },
  { 0x00D3, 0x00DD, -70 },
  { 0x00D3, 0x0178, -70 },
  { 0x00D3, 0x002C, -40 },
  { 0x00D3, 0x002E, -40 },
  { 0x00D4, 0x0041, -50 },
  { 0x00D4, 0x00C1, -50 },
  { 0x00D4, 0x0102, -50 },
  { 0x00D4, 0x00C2, -50 },
  { 0x00D4, 0x00C4, -50 },
  { 0x00D4, 0x00C0, -50 },
  { 0x00D4, 0x0100, -50 },
  { 0x00D4, 0x0104, -50 },
  { 0x00D4, 0x00C5, -50 },
  { 0x00D4, 0x00C3, -50 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -50 },
  { 0x00D4, 0x0058, -50 },
  { 0x00D4, 0x0059, -70 },
  { 0x00D4, 0x00DD, -70 },
  { 0x00D4, 0x0178, -70 },
  { 0x00D4, 0x002C, -40 },
  { 0x00D4, 0x002E, -40 },
  { 0x00D6, 0x0041, -50 },
  { 0x00D6, 0x00C1, -50 },
  { 0x00D6, 0x0102, -50 },
  { 0x00D6, 0x00C2, -50 },
  { 0x00D6, 0x00C4, -50 },
  { 0x00D6, 0x00C0, -50 },
  { 0x00D6, 0x0100, -50 },
  { 0x00D6, 0x0104, -50 },
  { 0x00D6, 0x00C5, -50 },
  { 0x00D6, 0x00C3, -50 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -50 },
  { 0x00D6, 0x0058, -50 },
  { 0x00D6, 0x0059, -70 },
  { 0x00D6, 0x00DD, -70 },
  { 0x00D6, 0x0178, -70 },
  { 0x00D6, 0x002C, -40 },
  { 0x00D6, 0x002E, -40 },
  { 0x00D2, 0x0041, -50 },
  { 0x00D2, 0x00C1, -50 },
  { 0x00D2, 0x0102, -50 },
  { 0x00D2, 0x00C2, -50 },
  { 0x00D2, 0x00C4, -50 },
  { 0x00D2, 0x00C0, -50 },
  { 0x00D2, 0x0100, -50 },
  { 0x00D2, 0x0104, -50 },
  { 0x00D2, 0x00C5, -50 },
  { 0x00D2, 0x00C3, -50 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -50 },
  { 0x00D2, 0x0058, -50 },
  { 0x00D2, 0x0059, -70 },
  { 0x00D2, 0x00DD, -70 },
  { 0x00D2, 0x0178, -70 },
  { 0x00D2, 0x002C, -40 },
  { 0x00D2, 0x002E, -40 },
  { 0x0150, 0x0041, -50 },
  { 0x0150, 0x00C1, -50 },
  { 0x0150, 0x0102, -50 },
  { 0x0150, 0x00C2, -50 },
  { 0x0150, 0x00C4, -50 },
  { 0x0150, 0x00C0, -50 },
  { 0x0150, 0x0100, -50 },
  { 0x0150, 0x0104, -50 },
  { 0x0150, 0x00C5, -50 },
  { 0x0150, 0x00C3, -50 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -50 },
  { 0x0150, 0x0058, -50 },
  { 0x0150, 0x0059, -70 },
  { 0x0150, 0x00DD, -70 },
  { 0x0150, 0x0178, -70 },
  { 0x0150, 0x002C, -40 },
  { 0x0150, 0x002E, -40 },
  { 0x014C, 0x0041, -50 },
  { 0x014C, 0x00C1, -50 },
  { 0x014C, 0x0102, -50 },
  { 0x014C, 0x00C2, -50 },
  { 0x014C, 0x00C4, -50 },
  { 0x014C, 0x00C0, -50 },
  { 0x014C, 0x0100, -50 },
  { 0x014C, 0x0104, -50 },
  { 0x014C, 0x00C5, -50 },
  { 0x014C, 0x00C3, -50 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -50 },
  { 0x014C, 0x0058, -50 },
  { 0x014C, 0x0059, -70 },
  { 0x014C, 0x00DD, -70 },
  { 0x014C, 0x0178, -70 },
  { 0x014C, 0x002C, -40 },
  { 0x014C, 0x002E, -40 },
  { 0x00D8, 0x0041, -50 },
  { 0x00D8, 0x00C1, -50 },
  { 0x00D8, 0x0102, -50 },
  { 0x00D8, 0x00C2, -50 },
  { 0x00D8, 0x00C4, -50 },
  { 0x00D8, 0x00C0, -50 },
  { 0x00D8, 0x0100, -50 },
  { 0x00D8, 0x0104, -50 },
  { 0x00D8, 0x00C5, -50 },
  { 0x00D8, 0x00C3, -50 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -50 },
  { 0x00D8, 0x0058, -50 },
  { 0x00D8, 0x0059, -70 },
  { 0x00D8, 0x00DD, -70 },
  { 0x00D8, 0x0178, -70 },
  { 0x00D8, 0x002C, -40 },
  { 0x00D8, 0x002E, -40 },
  { 0x00D5, 0x0041, -50 },
  { 0x00D5, 0x00C1, -50 },
  { 0x00D5, 0x0102, -50 },
  { 0x00D5, 0x00C2, -50 },
  { 0x00D5, 0x00C4, -50 },
  { 0x00D5, 0x00C0, -50 },
  { 0x00D5, 0x0100, -50 },
  { 0x00D5, 0x0104, -50 },
  { 0x00D5, 0x00C5, -50 },
  { 0x00D5, 0x00C3, -50 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -50 },
  { 0x00D5, 0x0058, -50 },
  { 0x00D5, 0x0059, -70 },
  { 0x00D5, 0x00DD, -70 },
  { 0x00D5, 0x0178, -70 },
  { 0x00D5, 0x002C, -40 },
  { 0x00D5, 0x002E, -40 },
  { 0x0050, 0x0041, -100 },
  { 0x0050, 0x00C1, -100 },
  { 0x0050, 0x0102, -100 },
  { 0x0050, 0x00C2, -100 },
  { 0x0050, 0x00C4, -100 },
  { 0x0050, 0x00C0, -100 },
  { 0x0050, 0x0100, -100 },
  { 0x0050, 0x0104, -100 },
  { 0x0050, 0x00C5, -100 },
  { 0x0050, 0x00C3, -100 },
  { 0x0050, 0x0061, -30 },
  { 0x0050, 0x00E1, -30 },
  { 0x0050, 0x0103, -30 },
  { 0x0050, 0x00E2, -30 },
  { 0x0050, 0x00E4, -30 },
  { 0x0050, 0x00E0, -30 },
  { 0x0050, 0x0101, -30 },
  { 0x0050, 0x0105, -30 },
  { 0x0050, 0x00E5, -30 },
  { 0x0050, 0x00E3, -30 },
  { 0x0050, 0x002C, -120 },
  { 0x0050, 0x0065, -30 },
  { 0x0050, 0x00E9, -30 },
  { 0x0050, 0x011B, -30 },
  { 0x0050, 0x00EA, -30 },
  { 0x0050, 0x00EB, -30 },
  { 0x0050, 0x0117, -30 },
  { 0x0050, 0x00E8, -30 },
  { 0x0050, 0x0113, -30 },
  { 0x0050, 0x0119, -30 },
  { 0x0050, 0x006F, -40 },
  { 0x0050, 0x00F3, -40 },
  { 0x0050, 0x00F4, -40 },
  { 0x0050, 0x00F6, -40 },
  { 0x0050, 0x00F2, -40 },
  { 0x0050, 0x0151, -40 },
  { 0x0050, 0x014D, -40 },
  { 0x0050, 0x00F8, -40 },
  { 0x0050, 0x00F5, -40 },
  { 0x0050, 0x002E, -120 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0051, 0x002C, 20 },
  { 0x0051, 0x002E, 20 },
  { 0x0052, 0x004F, -20 },
  { 0x0052, 0x00D3, -20 },
  { 0x0052, 0x00D4, -20 },
  { 0x0052, 0x00D6, -20 },
  { 0x0052, 0x00D2, -20 },
  { 0x0052, 0x0150, -20 },
  { 0x0052, 0x014C, -20 },
  { 0x0052, 0x00D8, -20 },
  { 0x0052, 0x00D5, -20 },
  { 0x0052, 0x0054, -20 },
  { 0x0052, 0x0164, -20 },
  { 0x0052, 0x0162, -20 },
  { 0x0052, 0x0055, -20 },
  { 0x0052, 0x00DA, -20 },
  { 0x0052, 0x00DB, -20 },
  { 0x0052, 0x00DC, -20 },
  { 0x0052, 0x00D9, -20 },
  { 0x0052, 0x0170, -20 },
  { 0x0052, 0x016A, -20 },
  { 0x0052, 0x0172, -20 },
  { 0x0052, 0x016E, -20 },
  { 0x0052, 0x0056, -50 },
  { 0x0052, 0x0057, -40 },
  { 0x0052, 0x0059, -50 },
  { 0x0052, 0x00DD, -50 },
  { 0x0052, 0x0178, -50 },
  { 0x0154, 0x004F, -20 },
  { 0x0154, 0x00D3, -20 },
  { 0x0154, 0x00D4, -20 },
  { 0x0154, 0x00D6, -20 },
  { 0x0154, 0x00D2, -20 },
  { 0x0154, 0x0150, -20 },
  { 0x0154, 0x014C, -20 },
  { 0x0154, 0x00D8, -20 },
  { 0x0154, 0x00D5, -20 },
  { 0x0154, 0x0054, -20 },
  { 0x0154, 0x0164, -20 },
  { 0x0154, 0x0162, -20 },
  { 0x0154, 0x0055, -20 },
  { 0x0154, 0x00DA, -20 },
  { 0x0154, 0x00DB, -20 },
  { 0x0154, 0x00DC, -20 },
  { 0x0154, 0x00D9, -20 },
  { 0x0154, 0x0170, -20 },
  { 0x0154, 0x016A, -20 },
  { 0x0154, 0x0172, -20 },
  { 0x0154, 0x016E, -20 },
  { 0x0154, 0x0056, -50 },
  { 0x0154, 0x0057, -40 },
  { 0x0154, 0x0059, -50 },
  { 0x0154, 0x00DD, -50 },
  { 0x0154, 0x0178, -50 },
  { 0x0158, 0x004F, -20 },
  { 0x0158, 0x00D3, -20 },
  { 0x0158, 0x00D4, -20 },
  { 0x0158, 0x00D6, -20 },
  { 0x0158, 0x00D2, -20 },
  { 0x0158, 0x0150, -20 },
  { 0x0158, 0x014C, -20 },
  { 0x0158, 0x00D8, -20 },
  { 0x0158, 0x00D5, -20 },
  { 0x0158, 0x0054, -20 },
  { 0x0158, 0x0164, -20 },
  { 0x0158, 0x0162, -20 },
  { 0x0158, 0x0055, -20 },
  { 0x0158, 0x00DA, -20 },
  { 0x0158, 0x00DB, -20 },
  { 0x0158, 0x00DC, -20 },
  { 0x0158, 0x00D9, -20 },
  { 0x0158, 0x0170, -20 },
  { 0x0158, 0x016A, -20 },
  { 0x0158, 0x0172, -20 },
  { 0x0158, 0x016E, -20 },
  { 0x0158, 0x0056, -50 },
  { 0x0158, 0x0057, -40 },
  { 0x0158, 0x0059, -50 },
  { 0x0158, 0x00DD, -50 },
  { 0x0158, 0x0178, -50 },
  { 0x0156, 0x004F, -20 },
  { 0x0156, 0x00D3, -20 },
  { 0x0156, 0x00D4, -20 },
  { 0x0156, 0x00D6, -20 },
  { 0x0156, 0x00D2, -20 },
  { 0x0156, 0x0150, -20 },
  { 0x0156, 0x014C, -20 },
  { 0x0156, 0x00D8, -20 },
  { 0x0156, 0x00D5, -20 },
  { 0x0156, 0x0054, -20 },
  { 0x0156, 0x0164, -20 },
  { 0x0156, 0x0162, -20 },
  { 0x0156, 0x0055, -20 },
  { 0x0156, 0x00DA, -20 },
  { 0x0156, 0x00DB, -20 },
  { 0x0156, 0x00DC, -20 },
  { 0x0156, 0x00D9, -20 },
  { 0x0156, 0x0170, -20 },
  { 0x0156, 0x016A, -20 },
  { 0x0156, 0x0172, -20 },
  { 0x0156, 0x016E, -20 },
  { 0x0156, 0x0056, -50 },
  { 0x0156, 0x0057, -40 },
  { 0x0156, 0x0059, -50 },
  { 0x0156, 0x00DD, -50 },
  { 0x0156, 0x0178, -50 },
  { 0x0054, 0x0041, -90 },
  { 0x0054, 0x00C1, -90 },
  { 0x0054, 0x0102, -90 },
  { 0x0054, 0x00C2, -90 },
  { 0x0054, 0x00C4, -90 },
  { 0x0054, 0x00C0, -90 },
  { 0x0054, 0x0100, -90 },
  { 0x0054, 0x0104, -90 },
  { 0x0054, 0x00C5, -90 },
  { 0x0054, 0x00C3, -90 },
  { 0x0054, 0x004F, -40 },
  { 0x0054, 0x00D3, -40 },
  { 0x0054, 0x00D4, -40 },
  { 0x0054, 0x00D6, -40 },
  { 0x0054, 0x00D2, -40 },
  { 0x0054, 0x0150, -40 },
  { 0x0054, 0x014C, -40 },
  { 0x0054, 0x00D8, -40 },
  { 0x0054, 0x00D5, -40 },
  { 0x0054, 0x0061, -80 },
  { 0x0054, 0x00E1, -80 },
  { 0x0054, 0x0103, -80 },
  { 0x0054, 0x00E2, -80 },
  { 0x0054, 0x00E4, -80 },
  { 0x0054, 0x00E0, -80 },
  { 0x0054, 0x0101, -80 },
  { 0x0054, 0x0105, -80 },
  { 0x0054, 0x00E5, -80 },
  { 0x0054, 0x00E3, -80 },
  { 0x0054, 0x003A, -40 },
  { 0x0054, 0x002C, -80 },
  { 0x0054, 0x0065, -60 },
  { 0x0054, 0x00E9, -60 },
  { 0x0054, 0x011B, -60 },
  { 0x0054, 0x00EA, -60 },
  { 0x0054, 0x00EB, -60 },
  { 0x0054, 0x0117, -60 },
  { 0x0054, 0x00E8, -60 },
  { 0x0054, 0x0113, -60 },
  { 0x0054, 0x0119, -60 },
  { 0x0054, 0x002D, -120 },
  { 0x0054, 0x006F, -80 },
  { 0x0054, 0x00F3, -80 },
  { 0x0054, 0x00F4, -80 },
  { 0x0054, 0x00F6, -80 },
  { 0x0054, 0x00F2, -80 },
  { 0x0054, 0x0151, -80 },
  { 0x0054, 0x014D, -80 },
  { 0x0054, 0x00F8, -80 },
  { 0x0054, 0x00F5, -80 },
  { 0x0054, 0x002E, -80 },
  { 0x0054, 0x0072, -80 },
  { 0x0054, 0x0155, -80 },
  { 0x0054, 0x0157, -80 },
  { 0x0054, 0x003B, -40 },
  { 0x0054, 0x0075, -90 },
  { 0x0054, 0x00FA, -90 },
  { 0x0054, 0x00FB, -90 },
  { 0x0054, 0x00FC, -90 },
  { 0x0054, 0x00F9, -90 },
  { 0x0054, 0x0171, -90 },
  { 0x0054, 0x016B, -90 },
  { 0x0054, 0x0173, -90 },
  { 0x0054, 0x016F, -90 },
  { 0x0054, 0x0077, -60 },
  { 0x0054, 0x0079, -60 },
  { 0x0054, 0x00FD, -60 },
  { 0x0054, 0x00FF, -60 },
  { 0x0164, 0x0041, -90 },
  { 0x0164, 0x00C1, -90 },
  { 0x0164, 0x0102, -90 },
  { 0x0164, 0x00C2, -90 },
  { 0x0164, 0x00C4, -90 },
  { 0x0164, 0x00C0, -90 },
  { 0x0164, 0x0100, -90 },
  { 0x0164, 0x0104, -90 },
  { 0x0164, 0x00C5, -90 },
  { 0x0164, 0x00C3, -90 },
  { 0x0164, 0x004F, -40 },
  { 0x0164, 0x00D3, -40 },
  { 0x0164, 0x00D4, -40 },
  { 0x0164, 0x00D6, -40 },
  { 0x0164, 0x00D2, -40 },
  { 0x0164, 0x0150, -40 },
  { 0x0164, 0x014C, -40 },
  { 0x0164, 0x00D8, -40 },
  { 0x0164, 0x00D5, -40 },
  { 0x0164, 0x0061, -80 },
  { 0x0164, 0x00E1, -80 },
  { 0x0164, 0x0103, -80 },
  { 0x0164, 0x00E2, -80 },
  { 0x0164, 0x00E4, -80 },
  { 0x0164, 0x00E0, -80 },
  { 0x0164, 0x0101, -80 },
  { 0x0164, 0x0105, -80 },
  { 0x0164, 0x00E5, -80 },
  { 0x0164, 0x00E3, -80 },
  { 0x0164, 0x003A, -40 },
  { 0x0164, 0x002C, -80 },
  { 0x0164, 0x0065, -60 },
  { 0x0164, 0x00E9, -60 },
  { 0x0164, 0x011B, -60 },
  { 0x0164, 0x00EA, -60 },
  { 0x0164, 0x00EB, -60 },
  { 0x0164, 0x0117, -60 },
  { 0x0164, 0x00E8, -60 },
  { 0x0164, 0x0113, -60 },
  { 0x0164, 0x0119, -60 },
  { 0x0164, 0x002D, -120 },
  { 0x0164, 0x006F, -80 },
  { 0x0164, 0x00F3, -80 },
  { 0x0164, 0x00F4, -80 },
  { 0x0164, 0x00F6, -80 },
  { 0x0164, 0x00F2, -80 },
  { 0x0164, 0x0151, -80 },
  { 0x0164, 0x014D, -80 },
  { 0x0164, 0x00F8, -80 },
  { 0x0164, 0x00F5, -80 },
  { 0x0164, 0x002E, -80 },
  { 0x0164, 0x0072, -80 },
  { 0x0164, 0x0155, -80 },
  { 0x0164, 0x0157, -80 },
  { 0x0164, 0x003B, -40 },
  { 0x0164, 0x0075, -90 },
  { 0x0164, 0x00FA, -90 },
  { 0x0164, 0x00FB, -90 },
  { 0x0164, 0x00FC, -90 },
  { 0x0164, 0x00F9, -90 },
  { 0x0164, 0x0171, -90 },
  { 0x0164, 0x016B, -90 },
  { 0x0164, 0x0173, -90 },
  { 0x0164, 0x016F, -90 },
  { 0x0164, 0x0077, -60 },
  { 0x0164, 0x0079, -60 },
  { 0x0164, 0x00FD, -60 },
  { 0x0164, 0x00FF, -60 },
  { 0x0162, 0x0041, -90 },
  { 0x0162, 0x00C1, -90 },
  { 0x0162, 0x0102, -90 },
  { 0x0162, 0x00C2, -90 },
  { 0x0162, 0x00C4, -90 },
  { 0x0162, 0x00C0, -90 },
  { 0x0162, 0x0100, -90 },
  { 0x0162, 0x0104, -90 },
  { 0x0162, 0x00C5, -90 },
  { 0x0162, 0x00C3, -90 },
  { 0x0162, 0x004F, -40 },
  { 0x0162, 0x00D3, -40 },
  { 0x0162, 0x00D4, -40 },
  { 0x0162, 0x00D6, -40 },
  { 0x0162, 0x00D2, -40 },
  { 0x0162, 0x0150, -40 },
  { 0x0162, 0x014C, -40 },
  { 0x0162, 0x00D8, -40 },
  { 0x0162, 0x00D5, -40 },
  { 0x0162, 0x0061, -80 },
  { 0x0162, 0x00E1, -80 },
  { 0x0162, 0x0103, -80 },
  { 0x0162, 0x00E2, -80 },
  { 0x0162, 0x00E4, -80 },
  { 0x0162, 0x00E0, -80 },
  { 0x0162, 0x0101, -80 },
  { 0x0162, 0x0105, -80 },
  { 0x0162, 0x00E5, -80 },
  { 0x0162, 0x00E3, -80 },
  { 0x0162, 0x003A, -40 },
  { 0x0162, 0x002C, -80 },
  { 0x0162, 0x0065, -60 },
  { 0x0162, 0x00E9, -60 },
  { 0x0162, 0x011B, -60 },
  { 0x0162, 0x00EA, -60 },
  { 0x0162, 0x00EB, -60 },
  { 0x0162, 0x0117, -60 },
  { 0x0162, 0x00E8, -60 },
  { 0x0162, 0x0113, -60 },
  { 0x0162, 0x0119, -60 },
  { 0x0162, 0x002D, -120 },
  { 0x0162, 0x006F, -80 },
  { 0x0162, 0x00F3, -80 },
  { 0x0162, 0x00F4, -80 },
  { 0x0162, 0x00F6, -80 },
  { 0x0162, 0x00F2, -80 },
  { 0x0162, 0x0151, -80 },
  { 0x0162, 0x014D, -80 },
  { 0x0162, 0x00F8, -80 },
  { 0x0162, 0x00F5, -80 },
  { 0x0162, 0x002E, -80 },
  { 0x0162, 0x0072, -80 },
  { 0x0162, 0x0155, -80 },
  { 0x0162, 0x0157, -80 },
  { 0x0162, 0x003B, -40 },
  { 0x0162, 0x0075, -90 },
  { 0x0162, 0x00FA, -90 },
  { 0x0162, 0x00FB, -90 },
  { 0x0162, 0x00FC, -90 },
  { 0x0162, 0x00F9, -90 },
  { 0x0162, 0x0171, -90 },
  { 0x0162, 0x016B, -90 },
  { 0x0162, 0x0173, -90 },
  { 0x0162, 0x016F, -90 },
  { 0x0162, 0x0077, -60 },
  { 0x0162, 0x0079, -60 },
  { 0x0162, 0x00FD, -60 },
  { 0x0162, 0x00FF, -60 },
  { 0x0055, 0x0041, -50 },
  { 0x0055, 0x00C1, -50 },
  { 0x0055, 0x0102, -50 },
  { 0x0055, 0x00C2, -50 },
  { 0x0055, 0x00C4, -50 },
  { 0x0055, 0x00C0, -50 },
  { 0x0055, 0x0100, -50 },
  { 0x0055, 0x0104, -50 },
  { 0x0055, 0x00C5, -50 },
  { 0x0055, 0x00C3, -50 },
  { 0x0055, 0x002C, -30 },
  { 0x0055, 0x002E, -30 },
  { 0x00DA, 0x0041, -50 },
  { 0x00DA, 0x00C1, -50 },
  { 0x00DA, 0x0102, -50 },
  { 0x00DA, 0x00C2, -50 },
  { 0x00DA, 0x00C4, -50 },
  { 0x00DA, 0x00C0, -50 },
  { 0x00DA, 0x0100, -50 },
  { 0x00DA, 0x0104, -50 },
  { 0x00DA, 0x00C5, -50 },
  { 0x00DA, 0x00C3, -50 },
  { 0x00DA, 0x002C, -30 },
  { 0x00DA, 0x002E, -30 },
  { 0x00DB, 0x0041, -50 },
  { 0x00DB, 0x00C1, -50 },
  { 0x00DB, 0x0102, -50 },
  { 0x00DB, 0x00C2, -50 },
  { 0x00DB, 0x00C4, -50 },
  { 0x00DB, 0x00C0, -50 },
  { 0x00DB, 0x0100, -50 },
  { 0x00DB, 0x0104, -50 },
  { 0x00DB, 0x00C5, -50 },
  { 0x00DB, 0x00C3, -50 },
  { 0x00DB, 0x002C, -30 },
  { 0x00DB, 0x002E, -30 },
  { 0x00DC, 0x0041, -50 },
  { 0x00DC, 0x00C1, -50 },
  { 0x00DC, 0x0102, -50 },
  { 0x00DC, 0x00C2, -50 },
  { 0x00DC, 0x00C4, -50 },
  { 0x00DC, 0x00C0, -50 },
  { 0x00DC, 0x0100, -50 },
  { 0x00DC, 0x0104, -50 },
  { 0x00DC, 0x00C5, -50 },
  { 0x00DC, 0x00C3, -50 },
  { 0x00DC, 0x002C, -30 },
  { 0x00DC, 0x002E, -30 },
  { 0x00D9, 0x0041, -50 },
  { 0x00D9, 0x00C1, -50 },
  { 0x00D9, 0x0102, -50 },
  { 0x00D9, 0x00C2, -50 },
  { 0x00D9, 0x00C4, -50 },
  { 0x00D9, 0x00C0, -50 },
  { 0x00D9, 0x0100, -50 },
  { 0x00D9, 0x0104, -50 },
  { 0x00D9, 0x00C5, -50 },
  { 0x00D9, 0x00C3, -50 },
  { 0x00D9, 0x002C, -30 },
  { 0x00D9, 0x002E, -30 },
  { 0x0170, 0x0041, -50 },
  { 0x0170, 0x00C1, -50 },
  { 0x0170, 0x0102, -50 },
  { 0x0170, 0x00C2, -50 },
  { 0x0170, 0x00C4, -50 },
  { 0x0170, 0x00C0, -50 },
  { 0x0170, 0x0100, -50 },
  { 0x0170, 0x0104, -50 },
  { 0x0170, 0x00C5, -50 },
  { 0x0170, 0x00C3, -50 },
  { 0x0170, 0x002C, -30 },
  { 0x0170, 0x002E, -30 },
  { 0x016A, 0x0041, -50 },
  { 0x016A, 0x00C1, -50 },
  { 0x016A, 0x0102, -50 },
  { 0x016A, 0x00C2, -50 },
  { 0x016A, 0x00C4, -50 },
  { 0x016A, 0x00C0, -50 },
  { 0x016A, 0x0100, -50 },
  { 0x016A, 0x0104, -50 },
  { 0x016A, 0x00C5, -50 },
  { 0x016A, 0x00C3, -50 },
  { 0x016A, 0x002C, -30 },
  { 0x016A, 0x002E, -30 },
  { 0x0172, 0x0041, -50 },
  { 0x0172, 0x00C1, -50 },
  { 0x0172, 0x0102, -50 },
  { 0x0172, 0x00C2, -50 },
  { 0x0172, 0x00C4, -50 },
  { 0x0172, 0x00C0, -50 },
  { 0x0172, 0x0100, -50 },
  { 0x0172, 0x0104, -50 },
  { 0x0172, 0x00C5, -50 },
  { 0x0172, 0x00C3, -50 },
  { 0x0172, 0x002C, -30 },
  { 0x0172, 0x002E, -30 },
  { 0x016E, 0x0041, -50 },
  { 0x016E, 0x00C1, -50 },
  { 0x016E, 0x0102, -50 },
  { 0x016E, 0x00C2, -50 },
  { 0x016E, 0x00C4, -50 },
  { 0x016E, 0x00C0, -50 },
  { 0x016E, 0x0100, -50 },
  { 0x016E, 0x0104, -50 },
  { 0x016E, 0x00C5, -50 },
  { 0x016E, 0x00C3, -50 },
  { 0x016E, 0x002C, -30 },
  { 0x016E, 0x002E, -30 },
  { 0x0056, 0x0041, -80 },
  { 0x0056, 0x00C1, -80 },
  { 0x0056, 0x0102, -80 },
  { 0x0056, 0x00C2, -80 },
  { 0x0056, 0x00C4, -80 },
  { 0x0056, 0x00C0, -80 },
  { 0x0056, 0x0100, -80 },
  { 0x0056, 0x0104, -80 },
  { 0x0056, 0x00C5, -80 },
  { 0x0056, 0x00C3, -80 },
  { 0x0056, 0x0047, -50 },
  { 0x0056, 0x011E, -50 },
  { 0x0056, 0x0122, -50 },
  { 0x0056, 0x004F, -50 },
  { 0x0056, 0x00D3, -50 },
  { 0x0056, 0x00D4, -50 },
  { 0x0056, 0x00D6, -50 },
  { 0x0056, 0x00D2, -50 },
  { 0x0056, 0x0150, -50 },
  { 0x0056, 0x014C, -50 },
  { 0x0056, 0x00D8, -50 },
  { 0x0056, 0x00D5, -50 },
  { 0x0056, 0x0061, -60 },
  { 0x0056, 0x00E1, -60 },
  { 0x0056, 0x0103, -60 },
  { 0x0056, 0x00E2, -60 },
  { 0x0056, 0x00E4, -60 },
  { 0x0056, 0x00E0, -60 },
  { 0x0056, 0x0101, -60 },
  { 0x0056, 0x0105, -60 },
  { 0x0056, 0x00E5, -60 },
  { 0x0056, 0x00E3, -60 },
  { 0x0056, 0x003A, -40 },
  { 0x0056, 0x002C, -120 },
  { 0x0056, 0x0065, -50 },
  { 0x0056, 0x00E9, -50 },
  { 0x0056, 0x011B, -50 },
  { 0x0056, 0x00EA, -50 },
  { 0x0056, 0x00EB, -50 },
  { 0x0056, 0x0117, -50 },
  { 0x0056, 0x00E8, -50 },
  { 0x0056, 0x0113, -50 },
  { 0x0056, 0x0119, -50 },
  { 0x0056, 0x002D, -80 },
  { 0x0056, 0x006F, -90 },
  { 0x0056, 0x00F3, -90 },
  { 0x0056, 0x00F4, -90 },
  { 0x0056, 0x00F6, -90 },
  { 0x0056, 0x00F2, -90 },
  { 0x0056, 0x0151, -90 },
  { 0x0056, 0x014D, -90 },
  { 0x0056, 0x00F8, -90 },
  { 0x0056, 0x00F5, -90 },
  { 0x0056, 0x002E, -120 },
  { 0x0056, 0x003B, -40 },
  { 0x0056, 0x0075, -60 },
  { 0x0056, 0x00FA, -60 },
  { 0x0056, 0x00FB, -60 },
  { 0x0056, 0x00FC, -60 },
  { 0x0056, 0x00F9, -60 },
  { 0x0056, 0x0171, -60 },
  { 0x0056, 0x016B, -60 },
  { 0x0056, 0x0173, -60 },
  { 0x0056, 0x016F, -60 },
  { 0x0057, 0x0041, -60 },
  { 0x0057, 0x00C1, -60 },
  { 0x0057, 0x0102, -60 },
  { 0x0057, 0x00C2, -60 },
  { 0x0057, 0x00C4, -60 },
  { 0x0057, 0x00C0, -60 },
  { 0x0057, 0x0100, -60 },
  { 0x0057, 0x0104, -60 },
  { 0x0057, 0x00C5, -60 },
  { 0x0057, 0x00C3, -60 },
  { 0x0057, 0x004F, -20 },
  { 0x0057, 0x00D3, -20 },
  { 0x0057, 0x00D4, -20 },
  { 0x0057, 0x00D6, -20 },
  { 0x0057, 0x00D2, -20 },
  { 0x0057, 0x0150, -20 },
  { 0x0057, 0x014C, -20 },
  { 0x0057, 0x00D8, -20 },
  { 0x0057, 0x00D5, -20 },
  { 0x0057, 0x0061, -40 },
  { 0x0057, 0x00E1, -40 },
  { 0x0057, 0x0103, -40 },
  { 0x0057, 0x00E2, -40 },
  { 0x0057, 0x00E4, -40 },
  { 0x0057, 0x00E0, -40 },
  { 0x0057, 0x0101, -40 },
  { 0x0057, 0x0105, -40 },
  { 0x0057, 0x00E5, -40 },
  { 0x0057, 0x00E3, -40 },
  { 0x0057, 0x003A, -10 },
  { 0x0057, 0x002C, -80 },
  { 0x0057, 0x0065, -35 },
  { 0x0057, 0x00E9, -35 },
  { 0x0057, 0x011B, -35 },
  { 0x0057, 0x00EA, -35 },
  { 0x0057, 0x00EB, -35 },
  { 0x0057, 0x0117, -35 },
  { 0x0057, 0x00E8, -35 },
  { 0x0057, 0x0113, -35 },
  { 0x0057, 0x0119, -35 },
  { 0x0057, 0x002D, -40 },
  { 0x0057, 0x006F, -60 },
  { 0x0057, 0x00F3, -60 },
  { 0x0057, 0x00F4, -60 },
  { 0x0057, 0x00F6, -60 },
  { 0x0057, 0x00F2, -60 },
  { 0x0057, 0x0151, -60 },
  { 0x0057, 0x014D, -60 },
  { 0x0057, 0x00F8, -60 },
  { 0x0057, 0x00F5, -60 },
  { 0x0057, 0x002E, -80 },
  { 0x0057, 0x003B, -10 },
  { 0x0057, 0x0075, -45 },
  { 0x0057, 0x00FA, -45 },
  { 0x0057, 0x00FB, -45 },
  { 0x0057, 0x00FC, -45 },
  { 0x0057, 0x00F9, -45 },
  { 0x0057, 0x0171, -45 },
  { 0x0057, 0x016B, -45 },
  { 0x0057, 0x0173, -45 },
  { 0x0057, 0x016F, -45 },
  { 0x0057, 0x0079, -20 },
  { 0x0057, 0x00FD, -20 },
  { 0x0057, 0x00FF, -20 },
  { 0x0059, 0x0041, -110 },
  { 0x0059, 0x00C1, -110 },
  { 0x0059, 0x0102, -110 },
  { 0x0059, 0x00C2, -110 },
  { 0x0059, 0x00C4, -110 },
  { 0x0059, 0x00C0, -110 },
  { 0x0059, 0x0100, -110 },
  { 0x0059, 0x0104, -110 },
  { 0x0059, 0x00C5, -110 },
  { 0x0059, 0x00C3, -110 },
  { 0x0059, 0x004F, -70 },
  { 0x0059, 0x00D3, -70 },
  { 0x0059, 0x00D4, -70 },
  { 0x0059, 0x00D6, -70 },
  { 0x0059, 0x00D2, -70 },
  { 0x0059, 0x0150, -70 },
  { 0x0059, 0x014C, -70 },
  { 0x0059, 0x00D8, -70 },
  { 0x0059, 0x00D5, -70 },
  { 0x0059, 0x0061, -90 },
  { 0x0059, 0x00E1, -90 },
  { 0x0059, 0x0103, -90 },
  { 0x0059, 0x00E2, -90 },
  { 0x0059, 0x00E4, -90 },
  { 0x0059, 0x00E0, -90 },
  { 0x0059, 0x0101, -90 },
  { 0x0059, 0x0105, -90 },
  { 0x0059, 0x00E5, -90 },
  { 0x0059, 0x00E3, -90 },
  { 0x0059, 0x003A, -50 },
  { 0x0059, 0x002C, -100 },
  { 0x0059, 0x0065, -80 },
  { 0x0059, 0x00E9, -80 },
  { 0x0059, 0x011B, -80 },
  { 0x0059, 0x00EA, -80 },
  { 0x0059, 0x00EB, -80 },
  { 0x0059, 0x0117, -80 },
  { 0x0059, 0x00E8, -80 },
  { 0x0059, 0x0113, -80 },
  { 0x0059, 0x0119, -80 },
  { 0x0059, 0x006F, -100 },
  { 0x0059, 0x00F3, -100 },
  { 0x0059, 0x00F4, -100 },
  { 0x0059, 0x00F6, -100 },
  { 0x0059, 0x00F2, -100 },
  { 0x0059, 0x0151, -100 },
  { 0x0059, 0x014D, -100 },
  { 0x0059, 0x00F8, -100 },
  { 0x0059, 0x00F5, -100 },
  { 0x0059, 0x002E, -100 },
  { 0x0059, 0x003B, -50 },
  { 0x0059, 0x0075, -100 },
  { 0x0059, 0x00FA, -100 },
  { 0x0059, 0x00FB, -100 },
  { 0x0059, 0x00FC, -100 },
  { 0x0059, 0x00F9, -100 },
  { 0x0059, 0x0171, -100 },
  { 0x0059, 0x016B, -100 },
  { 0x0059, 0x0173, -100 },
  { 0x0059, 0x016F, -100 },
  { 0x00DD, 0x0041, -110 },
  { 0x00DD, 0x00C1, -110 },
  { 0x00DD, 0x0102, -110 },
  { 0x00DD, 0x00C2, -110 },
  { 0x00DD, 0x00C4, -110 },
  { 0x00DD, 0x00C0, -110 },
  { 0x00DD, 0x0100, -110 },
  { 0x00DD, 0x0104, -110 },
  { 0x00DD, 0x00C5, -110 },
  { 0x00DD, 0x00C3, -110 },
  { 0x00DD, 0x004F, -70 },
  { 0x00DD, 0x00D3, -70 },
  { 0x00DD, 0x00D4, -70 },
  { 0x00DD, 0x00D6, -70 },
  { 0x00DD, 0x00D2, -70 },
  { 0x00DD, 0x0150, -70 },
  { 0x00DD, 0x014C, -70 },
  { 0x00DD, 0x00D8, -70 },
  { 0x00DD, 0x00D5, -70 },
  { 0x00DD, 0x0061, -90 },
  { 0x00DD, 0x00E1, -90 },
  { 0x00DD, 0x0103, -90 },
  { 0x00DD, 0x00E2, -90 },
  { 0x00DD, 0x00E4, -90 },
  { 0x00DD, 0x00E0, -90 },
  { 0x00DD, 0x0101, -90 },
  { 0x00DD, 0x0105, -90 },
  { 0x00DD, 0x00E5, -90 },
  { 0x00DD, 0x00E3, -90 },
  { 0x00DD, 0x003A, -50 },
  { 0x00DD, 0x002C, -100 },
  { 0x00DD, 0x0065, -80 },
  { 0x00DD, 0x00E9, -80 },
  { 0x00DD, 0x011B, -80 },
  { 0x00DD, 0x00EA, -80 },
  { 0x00DD, 0x00EB, -80 },
  { 0x00DD, 0x0117, -80 },
  { 0x00DD, 0x00E8, -80 },
  { 0x00DD, 0x0113, -80 },
  { 0x00DD, 0x0119, -80 },
  { 0x00DD, 0x006F, -100 },
  { 0x00DD, 0x00F3, -100 },
  { 0x00DD, 0x00F4, -100 },
  { 0x00DD, 0x00F6, -100 },
  { 0x00DD, 0x00F2, -100 },
  { 0x00DD, 0x0151, -100 },
  { 0x00DD, 0x014D, -100 },
  { 0x00DD, 0x00F8, -100 },
  { 0x00DD, 0x00F5, -100 },
  { 0x00DD, 0x002E, -100 },
  { 0x00DD, 0x003B, -50 },
  { 0x00DD, 0x0075, -100 },
  { 0x00DD, 0x00FA, -100 },
  { 0x00DD, 0x00FB, -100 },
  { 0x00DD, 0x00FC, -100 },
  { 0x00DD, 0x00F9, -100 },
  { 0x00DD, 0x0171, -100 },
  { 0x00DD, 0x016B, -100 },
  { 0x00DD, 0x0173, -100 },
  { 0x00DD, 0x016F, -100 },
  { 0x0178, 0x0041, -110 },
  { 0x0178, 0x00C1, -110 },
  { 0x0178, 0x0102, -110 },
  { 0x0178, 0x00C2, -110 },
  { 0x0178, 0x00C4, -110 },
  { 0x0178, 0x00C0, -110 },
  { 0x0178, 0x0100, -110 },
  { 0x0178, 0x0104, -110 },
  { 0x0178, 0x00C5, -110 },
  { 0x0178, 0x00C3, -110 },
  { 0x0178, 0x004F, -70 },
  { 0x0178, 0x00D3, -70 },
  { 0x0178, 0x00D4, -70 },
  { 0x0178, 0x00D6, -70 },
  { 0x0178, 0x00D2, -70 },
  { 0x0178, 0x0150, -70 },
  { 0x0178, 0x014C, -70 },
  { 0x0178, 0x00D8, -70 },
  { 0x0178, 0x00D5, -70 },
  { 0x0178, 0x0061, -90 },
  { 0x0178, 0x00E1, -90 },
  { 0x0178, 0x0103, -90 },
  { 0x0178, 0x00E2, -90 },
  { 0x0178, 0x00E4, -90 },
  { 0x0178, 0x00E0, -90 },
  { 0x0178, 0x0101, -90 },
  { 0x0178, 0x0105, -90 },
  { 0x0178, 0x00E5, -90 },
  { 0x0178, 0x00E3, -90 },
  { 0x0178, 0x003A, -50 },
  { 0x0178, 0x002C, -100 },
  { 0x0178, 0x0065, -80 },
  { 0x0178, 0x00E9, -80 },
  { 0x0178, 0x011B, -80 },
  { 0x0178, 0x00EA, -80 },
  { 0x0178, 0x00EB, -80 },
  { 0x0178, 0x0117, -80 },
  { 0x0178, 0x00E8, -80 },
  { 0x0178, 0x0113, -80 },
  { 0x0178, 0x0119, -80 },
  { 0x0178, 0x006F, -100 },
  { 0x0178, 0x00F3, -100 },
  { 0x0178, 0x00F4, -100 },
  { 0x0178, 0x00F6, -100 },
  { 0x0178, 0x00F2, -100 },
  { 0x0178, 0x0151, -100 },
  { 0x0178, 0x014D, -100 },
  { 0x0178, 0x00F8, -100 },
  { 0x0178, 0x00F5, -100 },
  { 0x0178, 0x002E, -100 },
  { 0x0178, 0x003B, -50 },
  { 0x0178, 0x0075, -100 },
  { 0x0178, 0x00FA, -100 },
  { 0x0178, 0x00FB, -100 },
  { 0x0178, 0x00FC, -100 },
  { 0x0178, 0x00F9, -100 },
  { 0x0178, 0x0171, -100 },
  { 0x0178, 0x016B, -100 },
  { 0x0178, 0x0173, -100 },
  { 0x0178, 0x016F, -100 },
  { 0x0061, 0x0067, -10 },
  { 0x0061, 0x011F, -10 },
  { 0x0061, 0x0123, -10 },
  { 0x0061, 0x0076, -15 },
  { 0x0061, 0x0077, -15 },
  { 0x0061, 0x0079, -20 },
  { 0x0061, 0x00FD, -20 },
  { 0x0061, 0x00FF, -20 },
  { 0x00E1, 0x0067, -10 },
  { 0x00E1, 0x011F, -10 },
  { 0x00E1, 0x0123, -10 },
  { 0x00E1, 0x0076, -15 },
  { 0x00E1, 0x0077, -15 },
  { 0x00E1, 0x0079, -20 },
  { 0x00E1, 0x00FD, -20 },
  { 0x00E1, 0x00FF, -20 },
  { 0x0103, 0x0067, -10 },
  { 0x0103, 0x011F, -10 },
  { 0x0103, 0x0123, -10 },
  { 0x0103, 0x0076, -15 },
  { 0x0103, 0x0077, -15 },
  { 0x0103, 0x0079, -20 },
  { 0x0103, 0x00FD, -20 },
  { 0x0103, 0x00FF, -20 },
  { 0x00E2, 0x0067, -10 },
  { 0x00E2, 0x011F, -10 },
  { 0x00E2, 0x0123, -10 },
  { 0x00E2, 0x0076, -15 },
  { 0x00E2, 0x0077, -15 },
  { 0x00E2, 0x0079, -20 },
  { 0x00E2, 0x00FD, -20 },
  { 0x00E2, 0x00FF, -20 },
  { 0x00E4, 0x0067, -10 },
  { 0x00E4, 0x011F, -10 },
  { 0x00E4, 0x0123, -10 },
  { 0x00E4, 0x0076, -15 },
  { 0x00E4, 0x0077, -15 },
  { 0x00E4, 0x0079, -20 },
  { 0x00E4, 0x00FD, -20 },
  { 0x00E4, 0x00FF, -20 },
  { 0x00E0, 0x0067, -10 },
  { 0x00E0, 0x011F, -10 },
  { 0x00E0, 0x0123, -10 },
  { 0x00E0, 0x0076, -15 },
  { 0x00E0, 0x0077, -15 },
  { 0x00E0, 0x0079, -20 },
  { 0x00E0, 0x00FD, -20 },
  { 0x00E0, 0x00FF, -20 },
  { 0x0101, 0x0067, -10 },
  { 0x0101, 0x011F, -10 },
  { 0x0101, 0x0123, -10 },
  { 0x0101, 0x0076, -15 },
  { 0x0101, 0x0077, -15 },
  { 0x0101, 0x0079, -20 },
  { 0x0101, 0x00FD, -20 },
  { 0x0101, 0x00FF, -20 },
  { 0x0105, 0x0067, -10 },
  { 0x0105, 0x011F, -10 },
  { 0x0105, 0x0123, -10 },
  { 0x0105, 0x0076, -15 },
  { 0x0105, 0x0077, -15 },
  { 0x0105, 0x0079, -20 },
  { 0x0105, 0x00FD, -20 },
  { 0x0105, 0x00FF, -20 },
  { 0x00E5, 0x0067, -10 },
  { 0x00E5, 0x011F, -10 },
  { 0x00E5, 0x0123, -10 },
  { 0x00E5, 0x0076, -15 },
  { 0x00E5, 0x0077, -15 },
  { 0x00E5, 0x0079, -20 },
  { 0x00E5, 0x00FD, -20 },
  { 0x00E5, 0x00FF, -20 },
  { 0x00E3, 0x0067, -10 },
  { 0x00E3, 0x011F, -10 },
  { 0x00E3, 0x0123, -10 },
  { 0x00E3, 0x0076, -15 },
  { 0x00E3, 0x0077, -15 },
  { 0x00E3, 0x0079, -20 },
  { 0x00E3, 0x00FD, -20 },
  { 0x00E3, 0x00FF, -20 },
  { 0x0062, 0x006C, -10 },
  { 0x0062, 0x013A, -10 },
  { 0x0062, 0x013C, -10 },
  { 0x0062, 0x0142, -10 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0062, 0x0076, -20 },
  { 0x0062, 0x0079, -20 },
  { 0x0062, 0x00FD, -20 },
  { 0x0062, 0x00FF, -20 },
  { 0x0063, 0x0068, -10 },
  { 0x0063, 0x006B, -20 },
  { 0x0063, 0x0137, -20 },
  { 0x0063, 0x006C, -20 },
  { 0x0063, 0x013A, -20 },
  { 0x0063, 0x013C, -20 },
  { 0x0063, 0x0142, -20 },
  { 0x0063, 0x0079, -10 },
  { 0x0063, 0x00FD, -10 },
  { 0x0063, 0x00FF, -10 },
  { 0x0107, 0x0068, -10 },
  { 0x0107, 0x006B, -20 },
  { 0x0107, 0x0137, -20 },
  { 0x0107, 0x006C, -20 },
  { 0x0107, 0x013A, -20 },
  { 0x0107, 0x013C, -20 },
  { 0x0107, 0x0142, -20 },
  { 0x0107, 0x0079, -10 },
  { 0x0107, 0x00FD, -10 },
  { 0x0107, 0x00FF, -10 },
  { 0x010D, 0x0068, -10 },
  { 0x010D, 0x006B, -20 },
  { 0x010D, 0x0137, -20 },
  { 0x010D, 0x006C, -20 },
  { 0x010D, 0x013A, -20 },
  { 0x010D, 0x013C, -20 },
  { 0x010D, 0x0142, -20 },
  { 0x010D, 0x0079, -10 },
  { 0x010D, 0x00FD, -10 },
  { 0x010D, 0x00FF, -10 },
  { 0x00E7, 0x0068, -10 },
  { 0x00E7, 0x006B, -20 },
  { 0x00E7, 0x0137, -20 },
  { 0x00E7, 0x006C, -20 },
  { 0x00E7, 0x013A, -20 },
  { 0x00E7, 0x013C, -20 },
  { 0x00E7, 0x0142, -20 },
  { 0x00E7, 0x0079, -10 },
  { 0x00E7, 0x00FD, -10 },
  { 0x00E7, 0x00FF, -10 },
  { 0x003A, 0x0020, -40 },
  { 0x002C, 0x201D, -120 },
  { 0x002C, 0x2019, -120 },
  { 0x002C, 0x0020, -40 },
  { 0x0064, 0x0064, -10 },
  { 0x0064, 0x0111, -10 },
  { 0x0064, 0x0076, -15 },
  { 0x0064, 0x0077, -15 },
  { 0x0064, 0x0079, -15 },
  { 0x0064, 0x00FD, -15 },
  { 0x0064, 0x00FF, -15 },
  { 0x0111, 0x0064, -10 },
  { 0x0111, 0x0111, -10 },
  { 0x0111, 0x0076, -15 },
  { 0x0111, 0x0077, -15 },
  { 0x0111, 0x0079, -15 },
  { 0x0111, 0x00FD, -15 },
  { 0x0111, 0x00FF, -15 },
  { 0x0065, 0x002C, 10 },
  { 0x0065, 0x002E, 20 },
  { 0x0065, 0x0076, -15 },
  { 0x0065, 0x0077, -15 },
  { 0x0065, 0x0078, -15 },
  { 0x0065, 0x0079, -15 },
  { 0x0065, 0x00FD, -15 },
  { 0x0065, 0x00FF, -15 },
  { 0x00E9, 0x002C, 10 },
  { 0x00E9, 0x002E, 20 },
  { 0x00E9, 0x0076, -15 },
  { 0x00E9, 0x0077, -15 },
  { 0x00E9, 0x0078, -15 },
  { 0x00E9, 0x0079, -15 },
  { 0x00E9, 0x00FD, -15 },
  { 0x00E9, 0x00FF, -15 },
  { 0x011B, 0x002C, 10 },
  { 0x011B, 0x002E, 20 },
  { 0x011B, 0x0076, -15 },
  { 0x011B, 0x0077, -15 },
  { 0x011B, 0x0078, -15 },
  { 0x011B, 0x0079, -15 },
  { 0x011B, 0x00FD, -15 },
  { 0x011B, 0x00FF, -15 },
  { 0x00EA, 0x002C, 10 },
  { 0x00EA, 0x002E, 20 },
  { 0x00EA, 0x0076, -15 },
  { 0x00EA, 0x0077, -15 },
  { 0x00EA, 0x0078, -15 },
  { 0x00EA, 0x0079, -15 },
  { 0x00EA, 0x00FD, -15 },
  { 0x00EA, 0x00FF, -15 },
  { 0x00EB, 0x002C, 10 },
  { 0x00EB, 0x002E, 20 },
  { 0x00EB, 0x0076, -15 },
  { 0x00EB, 0x0077, -15 },
  { 0x00EB, 0x0078, -15 },
  { 0x00EB, 0x0079, -15 },
  { 0x00EB, 0x00FD, -15 },
  { 0x00EB, 0x00FF, -15 },
  { 0x0117, 0x002C, 10 },
  { 0x0117, 0x002E, 20 },
  { 0x0117, 0x0076, -15 },
  { 0x0117, 0x0077, -15 },
  { 0x0117, 0x0078, -15 },
  { 0x0117, 0x0079, -15 },
  { 0x0117, 0x00FD, -15 },
  { 0x0117, 0x00FF, -15 },
  { 0x00E8, 0x002C, 10 },
  { 0x00E8, 0x002E, 20 },
  { 0x00E8, 0x0076, -15 },
  { 0x00E8, 0x0077, -15 },
  { 0x00E8, 0x0078, -15 },
  { 0x00E8, 0x0079, -15 },
  { 0x00E8, 0x00FD, -15 },
  { 0x00E8, 0x00FF, -15 },
  { 0x0113, 0x002C, 10 },
  { 0x0113, 0x002E, 20 },
  { 0x0113, 0x0076, -15 },
  { 0x0113, 0x0077, -15 },
  { 0x0113, 0x0078, -15 },
  { 0x0113, 0x0079, -15 },
  { 0x0113, 0x00FD, -15 },
  { 0x0113, 0x00FF, -15 },
  { 0x0119, 0x002C, 10 },
  { 0x0119, 0x002E, 20 },
  { 0x0119, 0x0076, -15 },
  { 0x0119, 0x0077, -15 },
  { 0x0119, 0x0078, -15 },
  { 0x0119, 0x0079, -15 },
  { 0x0119, 0x00FD, -15 },
  { 0x0119, 0x00FF, -15 },
  { 0x0066, 0x002C, -10 },
  { 0x0066, 0x0065, -10 },
  { 0x0066, 0x00E9, -10 },
  { 0x0066, 0x011B, -10 },
  { 0x0066, 0x00EA, -10 },
  { 0x0066, 0x00EB, -10 },
  { 0x0066, 0x0117, -10 },
  { 0x0066, 0x00E8, -10 },
  { 0x0066, 0x0113, -10 },
  { 0x0066, 0x0119, -10 },
  { 0x0066, 0x006F, -20 },
  { 0x0066, 0x00F3, -20 },
  { 0x0066, 0x00F4, -20 },
  { 0x0066, 0x00F6, -20 },
  { 0x0066, 0x00F2, -20 },
  { 0x0066, 0x0151, -20 },
  { 0x0066, 0x014D, -20 },
  { 0x0066, 0x00F8, -20 },
  { 0x0066, 0x00F5, -20 },
  { 0x0066, 0x002E, -10 },
  { 0x0066, 0x201D, 30 },
  { 0x0066, 0x2019, 30 },
  { 0x0067, 0x0065, 10 },
  { 0x0067, 0x00E9, 10 },
  { 0x0067, 0x011B, 10 },
  { 0x0067, 0x00EA, 10 },
  { 0x0067, 0x00EB, 10 },
  { 0x0067, 0x0117, 10 },
  { 0x0067, 0x00E8, 10 },
  { 0x0067, 0x0113, 10 },
  { 0x0067, 0x0119, 10 },
  { 0x0067, 0x0067, -10 },
  { 0x0067, 0x011F, -10 },
  { 0x0067, 0x0123, -10 },
  { 0x011F, 0x0065, 10 },
  { 0x011F, 0x00E9, 10 },
  { 0x011F, 0x011B, 10 },
  { 0x011F, 0x00EA, 10 },
  { 0x011F, 0x00EB, 10 },
  { 0x011F, 0x0117, 10 },
  { 0x011F, 0x00E8, 10 },
  { 0x011F, 0x0113, 10 },
  { 0x011F, 0x0119, 10 },
  { 0x011F, 0x0067, -10 },
  { 0x011F, 0x011F, -10 },
  { 0x011F, 0x0123, -10 },
  { 0x0123, 0x0065, 10 },
  { 0x0123, 0x00E9, 10 },
  { 0x0123, 0x011B, 10 },
  { 0x0123, 0x00EA, 10 },
  { 0x0123, 0x00EB, 10 },
  { 0x0123, 0x0117, 10 },
  { 0x0123, 0x00E8, 10 },
  { 0x0123, 0x0113, 10 },
  { 0x0123, 0x0119, 10 },
  { 0x0123, 0x0067, -10 },
  { 0x0123, 0x011F, -10 },
  { 0x0123, 0x0123, -10 },
  { 0x0068, 0x0079, -20 },
  { 0x0068, 0x00FD, -20 },
  { 0x0068, 0x00FF, -20 },
  { 0x006B, 0x006F, -15 },
  { 0x006B, 0x00F3, -15 },
  { 0x006B, 0x00F4, -15 },
  { 0x006B, 0x00F6, -15 },
  { 0x006B, 0x00F2, -15 },
  { 0x006B, 0x0151, -15 },
  { 0x006B, 0x014D, -15 },
  { 0x006B, 0x00F8, -15 },
  { 0x006B, 0x00F5, -15 },
  { 0x0137, 0x006F, -15 },
  { 0x0137, 0x00F3, -15 },
  { 0x0137, 0x00F4, -15 },
  { 0x0137, 0x00F6, -15 },
  { 0x0137, 0x00F2, -15 },
  { 0x0137, 0x0151, -15 },
  { 0x0137, 0x014D, -15 },
  { 0x0137, 0x00F8, -15 },
  { 0x0137, 0x00F5, -15 },
  { 0x006C, 0x0077, -15 },
  { 0x006C, 0x0079, -15 },
  { 0x006C, 0x00FD, -15 },
  { 0x006C, 0x00FF, -15 },
  { 0x013A, 0x0077, -15 },
  { 0x013A, 0x0079, -15 },
  { 0x013A, 0x00FD, -15 },
  { 0x013A, 0x00FF, -15 },
  { 0x013C, 0x0077, -15 },
  { 0x013C, 0x0079, -15 },
  { 0x013C, 0x00FD, -15 },
  { 0x013C, 0x00FF, -15 },
  { 0x0142, 0x0077, -15 },
  { 0x0142, 0x0079, -15 },
  { 0x0142, 0x00FD, -15 },
  { 0x0142, 0x00FF, -15 },
  { 0x006D, 0x0075, -20 },
  { 0x006D, 0x00FA, -20 },
  { 0x006D, 0x00FB, -20 },
  { 0x006D, 0x00FC, -20 },
  { 0x006D, 0x00F9, -20 },
  { 0x006D, 0x0171, -20 },
  { 0x006D, 0x016B, -20 },
  { 0x006D, 0x0173, -20 },
  { 0x006D, 0x016F, -20 },
  { 0x006D, 0x0079, -30 },
  { 0x006D, 0x00FD, -30 },
  { 0x006D, 0x00FF, -30 },
  { 0x006E, 0x0075, -10 },
  { 0x006E, 0x00FA, -10 },
  { 0x006E, 0x00FB, -10 },
  { 0x006E, 0x00FC, -10 },
  { 0x006E, 0x00F9, -10 },
  { 0x006E, 0x0171, -10 },
  { 0x006E, 0x016B, -10 },
  { 0x006E, 0x0173, -10 },
  { 0x006E, 0x016F, -10 },
  { 0x006E, 0x0076, -40 },
  { 0x006E, 0x0079, -20 },
  { 0x006E, 0x00FD, -20 },
  { 0x006E, 0x00FF, -20 },
  { 0x0144, 0x0075, -10 },
  { 0x0144, 0x00FA, -10 },
  { 0x0144, 0x00FB, -10 },
  { 0x0144, 0x00FC, -10 },
  { 0x0144, 0x00F9, -10 },
  { 0x0144, 0x0171, -10 },
  { 0x0144, 0x016B, -10 },
  { 0x0144, 0x0173, -10 },
  { 0x0144, 0x016F, -10 },
  { 0x0144, 0x0076, -40 },
  { 0x0144, 0x0079, -20 },
  { 0x0144, 0x00FD, -20 },
  { 0x0144, 0x00FF, -20 },
  { 0x0148, 0x0075, -10 },
  { 0x0148, 0x00FA, -10 },
  { 0x0148, 0x00FB, -10 },
  { 0x0148, 0x00FC, -10 },
  { 0x0148, 0x00F9, -10 },
  { 0x0148, 0x0171, -10 },
  { 0x0148, 0x016B, -10 },
  { 0x0148, 0x0173, -10 },
  { 0x0148, 0x016F, -10 },
  { 0x0148, 0x0076, -40 },
  { 0x0148, 0x0079, -20 },
  { 0x0148, 0x00FD, -20 },
  { 0x0148, 0x00FF, -20 },
  { 0x0146, 0x0075, -10 },
  { 0x0146, 0x00FA, -10 },
  { 0x0146, 0x00FB, -10 },
  { 0x0146, 0x00FC, -10 },
  { 0x0146, 0x00F9, -10 },
  { 0x0146, 0x0171, -10 },
  { 0x0146, 0x016B, -10 },
  { 0x0146, 0x0173, -10 },
  { 0x0146, 0x016F, -10 },
  { 0x0146, 0x0076, -40 },
  { 0x0146, 0x0079, -20 },
  { 0x0146, 0x00FD, -20 },
  { 0x0146, 0x00FF, -20 },
  { 0x00F1, 0x0075, -10 },
  { 0x00F1, 0x00FA, -10 },
  { 0x00F1, 0x00FB, -10 },
  { 0x00F1, 0x00FC, -10 },
  { 0x00F1, 0x00F9, -10 },
  { 0x00F1, 0x0171, -10 },
  { 0x00F1, 0x016B, -10 },
  { 0x00F1, 0x0173, -10 },
  { 0x00F1, 0x016F, -10 },
  { 0x00F1, 0x0076, -40 },
  { 0x00F1, 0x0079, -20 },
  { 0x00F1, 0x00FD, -20 },
  { 0x00F1, 0x00FF, -20 },
  { 0x006F, 0x0076, -20 },
  { 0x006F, 0x0077, -15 },
  { 0x006F, 0x0078, -30 },
  { 0x006F, 0x0079, -20 },
  { 0x006F, 0x00FD, -20 },
  { 0x006F, 0x00FF, -20 },
  { 0x00F3, 0x0076, -20 },
  { 0x00F3, 0x0077, -15 },
  { 0x00F3, 0x0078, -30 },
  { 0x00F3, 0x0079, -20 },
  { 0x00F3, 0x00FD, -20 },
  { 0x00F3, 0x00FF, -20 },
  { 0x00F4, 0x0076, -20 },
  { 0x00F4, 0x0077, -15 },
  { 0x00F4, 0x0078, -30 },
  { 0x00F4, 0x0079, -20 },
  { 0x00F4, 0x00FD, -20 },
  { 0x00F4, 0x00FF, -20 },
  { 0x00F6, 0x0076, -20 },
  { 0x00F6, 0x0077, -15 },
  { 0x00F6, 0x0078, -30 },
  { 0x00F6, 0x0079, -20 },
  { 0x00F6, 0x00FD, -20 },
  { 0x00F6, 0x00FF, -20 },
  { 0x00F2, 0x0076, -20 },
  { 0x00F2, 0x0077, -15 },
  { 0x00F2, 0x0078, -30 },
  { 0x00F2, 0x0079, -20 },
  { 0x00F2, 0x00FD, -20 },
  { 0x00F2, 0x00FF, -20 },
  { 0x0151, 0x0076, -20 },
  { 0x0151, 0x0077, -15 },
  { 0x0151, 0x0078, -30 },
  { 0x0151, 0x0079, -20 },
  { 0x0151, 0x00FD, -20 },
  { 0x0151, 0x00FF, -20 },
  { 0x014D, 0x0076, -20 },
  { 0x014D, 0x0077, -15 },
  { 0x014D, 0x0078, -30 },
  { 0x014D, 0x0079, -20 },
  { 0x014D, 0x00FD, -20 },
  { 0x014D, 0x00FF, -20 },
  { 0x00F8, 0x0076, -20 },
  { 0x00F8, 0x0077, -15 },
  { 0x00F8, 0x0078, -30 },
  { 0x00F8, 0x0079, -20 },
  { 0x00F8, 0x00FD, -20 },
  { 0x00F8, 0x00FF, -20 },
  { 0x00F5, 0x0076, -20 },
  { 0x00F5, 0x0077, -15 },
  { 0x00F5, 0x0078, -30 },
  { 0x00F5, 0x0079, -20 },
  { 0x00F5, 0x00FD, -20 },
  { 0x00F5, 0x00FF, -20 },
  { 0x0070, 0x0079, -15 },
  { 0x0070, 0x00FD, -15 },
  { 0x0070, 0x00FF, -15 },
  { 0x002E, 0x201D, -120 },
  { 0x002E, 0x2019, -120 },
  { 0x002E, 0x0020, -40 },
  { 0x201D, 0x0020, -80 },
  { 0x2018, 0x2018, -46 },
  { 0x2019, 0x0064, -80 },
  { 0x2019, 0x0111, -80 },
  { 0x2019, 0x006C, -20 },
  { 0x2019, 0x013A, -20 },
  { 0x2019, 0x013C, -20 },
  { 0x2019, 0x0142, -20 },
  { 0x2019, 0x2019, -46 },
  { 0x2019, 0x0072, -40 },
  { 0x2019, 0x0155, -40 },
  { 0x2019, 0x0159, -40 },
  { 0x2019, 0x0157, -40 },
  { 0x2019, 0x0073, -60 },
  { 0x2019, 0x015B, -60 },
  { 0x2019, 0x0161, -60 },
  { 0x2019, 0x015F, -60 },
  { 0x2019, 0x0219, -60 },
  { 0x2019, 0x0020, -80 },
  { 0x2019, 0x0076, -20 },
  { 0x0072, 0x0063, -20 },
  { 0x0072, 0x0107, -20 },
  { 0x0072, 0x010D, -20 },
  { 0x0072, 0x00E7, -20 },
  { 0x0072, 0x002C, -60 },
  { 0x0072, 0x0064, -20 },
  { 0x0072, 0x0111, -20 },
  { 0x0072, 0x0067, -15 },
  { 0x0072, 0x011F, -15 },
  { 0x0072, 0x0123, -15 },
  { 0x0072, 0x002D, -20 },
  { 0x0072, 0x006F, -20 },
  { 0x0072, 0x00F3, -20 },
  { 0x0072, 0x00F4, -20 },
  { 0x0072, 0x00F6, -20 },
  { 0x0072, 0x00F2, -20 },
  { 0x0072, 0x0151, -20 },
  { 0x0072, 0x014D, -20 },
  { 0x0072, 0x00F8, -20 },
  { 0x0072, 0x00F5, -20 },
  { 0x0072, 0x002E, -60 },
  { 0x0072, 0x0071, -20 },
  { 0x0072, 0x0073, -15 },
  { 0x0072, 0x015B, -15 },
  { 0x0072, 0x0161, -15 },
  { 0x0072, 0x015F, -15 },
  { 0x0072, 0x0219, -15 },
  { 0x0072, 0x0074, 20 },
  { 0x0072, 0x0163, 20 },
  { 0x0072, 0x0076, 10 },
  { 0x0072, 0x0079, 10 },
  { 0x0072, 0x00FD, 10 },
  { 0x0072, 0x00FF, 10 },
  { 0x0155, 0x0063, -20 },
  { 0x0155, 0x0107, -20 },
  { 0x0155, 0x010D, -20 },
  { 0x0155, 0x00E7, -20 },
  { 0x0155, 0x002C, -60 },
  { 0x0155, 0x0064, -20 },
  { 0x0155, 0x0111, -20 },
  { 0x0155, 0x0067, -15 },
  { 0x0155, 0x011F, -15 },
  { 0x0155, 0x0123, -15 },
  { 0x0155, 0x002D, -20 },
  { 0x0155, 0x006F, -20 },
  { 0x0155, 0x00F3, -20 },
  { 0x0155, 0x00F4, -20 },
  { 0x0155, 0x00F6, -20 },
  { 0x0155, 0x00F2, -20 },
  { 0x0155, 0x0151, -20 },
  { 0x0155, 0x014D, -20 },
  { 0x0155, 0x00F8, -20 },
  { 0x0155, 0x00F5, -20 },
  { 0x0155, 0x002E, -60 },
  { 0x0155, 0x0071, -20 },
  { 0x0155, 0x0073, -15 },
  { 0x0155, 0x015B, -15 },
  { 0x0155, 0x0161, -15 },
  { 0x0155, 0x015F, -15 },
  { 0x0155, 0x0219, -15 },
  { 0x0155, 0x0074, 20 },
  { 0x0155, 0x0163, 20 },
  { 0x0155, 0x0076, 10 },
  { 0x0155, 0x0079, 10 },
  { 0x0155, 0x00FD, 10 },
  { 0x0155, 0x00FF, 10 },
  { 0x0159, 0x0063, -20 },
  { 0x0159, 0x0107, -20 },
  { 0x0159, 0x010D, -20 },
  { 0x0159, 0x00E7, -20 },
  { 0x0159, 0x002C, -60 },
  { 0x0159, 0x0064, -20 },
  { 0x0159, 0x0111, -20 },
  { 0x0159, 0x0067, -15 },
  { 0x0159, 0x011F, -15 },
  { 0x0159, 0x0123, -15 },
  { 0x0159, 0x002D, -20 },
  { 0x0159, 0x006F, -20 },
  { 0x0159, 0x00F3, -20 },
  { 0x0159, 0x00F4, -20 },
  { 0x0159, 0x00F6, -20 },
  { 0x0159, 0x00F2, -20 },
  { 0x0159, 0x0151, -20 },
  { 0x0159, 0x014D, -20 },
  { 0x0159, 0x00F8, -20 },
  { 0x0159, 0x00F5, -20 },
  { 0x0159, 0x002E, -60 },
  { 0x0159, 0x0071, -20 },
  { 0x0159, 0x0073, -15 },
  { 0x0159, 0x015B, -15 },
  { 0x0159, 0x0161, -15 },
  { 0x0159, 0x015F, -15 },
  { 0x0159, 0x0219, -15 },
  { 0x0159, 0x0074, 20 },
  { 0x0159, 0x0163, 20 },
  { 0x0159, 0x0076, 10 },
  { 0x0159, 0x0079, 10 },
  { 0x0159, 0x00FD, 10 },
  { 0x0159, 0x00FF, 10 },
  { 0x0157, 0x0063, -20 },
  { 0x0157, 0x0107, -20 },
  { 0x0157, 0x010D, -20 },
  { 0x0157, 0x00E7, -20 },
  { 0x0157, 0x002C, -60 },
  { 0x0157, 0x0064, -20 },
  { 0x0157, 0x0111, -20 },
  { 0x0157, 0x0067, -15 },
  { 0x0157, 0x011F, -15 },
  { 0x0157, 0x0123, -15 },
  { 0x0157, 0x002D, -20 },
  { 0x0157, 0x006F, -20 },
  { 0x0157, 0x00F3, -20 },
  { 0x0157, 0x00F4, -20 },
  { 0x0157, 0x00F6, -20 },
  { 0x0157, 0x00F2, -20 },
  { 0x0157, 0x0151, -20 },
  { 0x0157, 0x014D, -20 },
  { 0x0157, 0x00F8, -20 },
  { 0x0157, 0x00F5, -20 },
  { 0x0157, 0x002E, -60 },
  { 0x0157, 0x0071, -20 },
  { 0x0157, 0x0073, -15 },
  { 0x0157, 0x015B, -15 },
  { 0x0157, 0x0161, -15 },
  { 0x0157, 0x015F, -15 },
  { 0x0157, 0x0219, -15 },
  { 0x0157, 0x0074, 20 },
  { 0x0157, 0x0163, 20 },
  { 0x0157, 0x0076, 10 },
  { 0x0157, 0x0079, 10 },
  { 0x0157, 0x00FD, 10 },
  { 0x0157, 0x00FF, 10 },
  { 0x0073, 0x0077, -15 },
  { 0x015B, 0x0077, -15 },
  { 0x0161, 0x0077, -15 },
  { 0x015F, 0x0077, -15 },
  { 0x0219, 0x0077, -15 },
  { 0x003B, 0x0020, -40 },
  { 0x0020, 0x0054, -100 },
  { 0x0020, 0x0164, -100 },
  { 0x0020, 0x0162, -100 },
  { 0x0020, 0x0056, -80 },
  { 0x0020, 0x0057, -80 },
  { 0x0020, 0x0059, -120 },
  { 0x0020, 0x00DD, -120 },
  { 0x0020, 0x0178, -120 },
  { 0x0020, 0x201C, -80 },
  { 0x0020, 0x2018, -60 },
  { 0x0076, 0x0061, -20 },
  { 0x0076, 0x00E1, -20 },
  { 0x0076, 0x0103, -20 },
  { 0x0076, 0x00E2, -20 },
  { 0x0076, 0x00E4, -20 },
  { 0x0076, 0x00E0, -20 },
  { 0x0076, 0x0101, -20 },
  { 0x0076, 0x0105, -20 },
  { 0x0076, 0x00E5, -20 },
  { 0x0076, 0x00E3, -20 },
  { 0x0076, 0x002C, -80 },
  { 0x0076, 0x006F, -30 },
  { 0x0076, 0x00F3, -30 },
  { 0x0076, 0x00F4, -30 },
  { 0x0076, 0x00F6, -30 },
  { 0x0076, 0x00F2, -30 },
  { 0x0076, 0x0151, -30 },
  { 0x0076, 0x014D, -30 },
  { 0x0076, 0x00F8, -30 },
  { 0x0076, 0x00F5, -30 },
  { 0x0076, 0x002E, -80 },
  { 0x0077, 0x002C, -40 },
  { 0x0077, 0x006F, -20 },
  { 0x0077, 0x00F3, -20 },
  { 0x0077, 0x00F4, -20 },
  { 0x0077, 0x00F6, -20 },
  { 0x0077, 0x00F2, -20 },
  { 0x0077, 0x0151, -20 },
  { 0x0077, 0x014D, -20 },
  { 0x0077, 0x00F8, -20 },
  { 0x0077, 0x00F5, -20 },
  { 0x0077, 0x002E, -40 },
  { 0x0078, 0x0065, -10 },
  { 0x0078, 0x00E9, -10 },
  { 0x0078, 0x011B, -10 },
  { 0x0078, 0x00EA, -10 },
  { 0x0078, 0x00EB, -10 },
  { 0x0078, 0x0117, -10 },
  { 0x0078, 0x00E8, -10 },
  { 0x0078, 0x0113, -10 },
  { 0x0078, 0x0119, -10 },
  { 0x0079, 0x0061, -30 },
  { 0x0079, 0x00E1, -30 },
  { 0x0079, 0x0103, -30 },
  { 0x0079, 0x00E2, -30 },
  { 0x0079, 0x00E4, -30 },
  { 0x0079, 0x00E0, -30 },
  { 0x0079, 0x0101, -30 },
  { 0x0079, 0x0105, -30 },
  { 0x0079, 0x00E5, -30 },
  { 0x0079, 0x00E3, -30 },
  { 0x0079, 0x002C, -80 },
  { 0x0079, 0x0065, -10 },
  { 0x0079, 0x00E9, -10 },
  { 0x0079, 0x011B, -10 },
  { 0x0079, 0x00EA, -10 },
  { 0x0079, 0x00EB, -10 },
  { 0x0079, 0x0117, -10 },
  { 0x0079, 0x00E8, -10 },
  { 0x0079, 0x0113, -10 },
  { 0x0079, 0x0119, -10 },
  { 0x0079, 0x006F, -25 },
  { 0x0079, 0x00F3, -25 },
  { 0x0079, 0x00F4, -25 },
  { 0x0079, 0x00F6, -25 },
  { 0x0079, 0x00F2, -25 },
  { 0x0079, 0x0151, -25 },
  { 0x0079, 0x014D, -25 },
  { 0x0079, 0x00F8, -25 },
  { 0x0079, 0x00F5, -25 },
  { 0x0079, 0x002E, -80 },
  { 0x00FD, 0x0061, -30 },
  { 0x00FD, 0x00E1, -30 },
  { 0x00FD, 0x0103, -30 },
  { 0x00FD, 0x00E2, -30 },
  { 0x00FD, 0x00E4, -30 },
  { 0x00FD, 0x00E0, -30 },
  { 0x00FD, 0x0101, -30 },
  { 0x00FD, 0x0105, -30 },
  { 0x00FD, 0x00E5, -30 },
  { 0x00FD, 0x00E3, -30 },
  { 0x00FD, 0x002C, -80 },
  { 0x00FD, 0x0065, -10 },
  { 0x00FD, 0x00E9, -10 },
  { 0x00FD, 0x011B, -10 },
  { 0x00FD, 0x00EA, -10 },
  { 0x00FD, 0x00EB, -10 },
  { 0x00FD, 0x0117, -10 },
  { 0x00FD, 0x00E8, -10 },
  { 0x00FD, 0x0113, -10 },
  { 0x00FD, 0x0119, -10 },
  { 0x00FD, 0x006F, -25 },
  { 0x00FD, 0x00F3, -25 },
  { 0x00FD, 0x00F4, -25 },
  { 0x00FD, 0x00F6, -25 },
  { 0x00FD, 0x00F2, -25 },
  { 0x00FD, 0x0151, -25 },
  { 0x00FD, 0x014D, -25 },
  { 0x00FD, 0x00F8, -25 },
  { 0x00FD, 0x00F5, -25 },
  { 0x00FD, 0x002E, -80 },
  { 0x00FF, 0x0061, -30 },
  { 0x00FF, 0x00E1, -30 },
  { 0x00FF, 0x0103, -30 },
  { 0x00FF, 0x00E2, -30 },
  { 0x00FF, 0x00E4, -30 },
  { 0x00FF, 0x00E0, -30 },
  { 0x00FF, 0x0101, -30 },
  { 0x00FF, 0x0105, -30 },
  { 0x00FF, 0x00E5, -30 },
  { 0x00FF, 0x00E3, -30 },
  { 0x00FF, 0x002C, -80 },
  { 0x00FF, 0x0065, -10 },
  { 0x00FF, 0x00E9, -10 },
  { 0x00FF, 0x011B, -10 },
  { 0x00FF, 0x00EA, -10 },
  { 0x00FF, 0x00EB, -10 },
  { 0x00FF, 0x0117, -10 },
  { 0x00FF, 0x00E8, -10 },
  { 0x00FF, 0x0113, -10 },
  { 0x00FF, 0x0119, -10 },
  { 0x00FF, 0x006F, -25 },
  { 0x00FF, 0x00F3, -25 },
  { 0x00FF, 0x00F4, -25 },
  { 0x00FF, 0x00F6, -25 },
  { 0x00FF, 0x00F2, -25 },
  { 0x00FF, 0x0151, -25 },
  { 0x00FF, 0x014D, -25 },
  { 0x00FF, 0x00F8, -25 },
  { 0x00FF, 0x00F5, -25 },
  { 0x00FF, 0x002E, -80 },
  { 0x007A, 0x0065, 10 },
  { 0x007A, 0x00E9, 10 },
  { 0x007A, 0x011B, 10 },
  { 0x007A, 0x00EA, 10 },
  { 0x007A, 0x00EB, 10 },
  { 0x007A, 0x0117, 10 },
  { 0x007A, 0x00E8, 10 },
  { 0x007A, 0x0113, 10 },
  { 0x007A, 0x0119, 10 },
  { 0x017A, 0x0065, 10 },
  { 0x017A, 0x00E9, 10 },
  { 0x017A, 0x011B, 10 },
  { 0x017A, 0x00EA, 10 },
  { 0x017A, 0x00EB, 10 },
  { 0x017A, 0x0117, 10 },
  { 0x017A, 0x00E8, 10 },
  { 0x017A, 0x0113, 10 },
  { 0x017A, 0x0119, 10 },
  { 0x017E, 0x0065, 10 },
  { 0x017E, 0x00E9, 10 },
  { 0x017E, 0x011B, 10 },
  { 0x017E, 0x00EA, 10 },
  { 0x017E, 0x00EB, 10 },
  { 0x017E, 0x0117, 10 },
  { 0x017E, 0x00E8, 10 },
  { 0x017E, 0x0113, 10 },
  { 0x017E, 0x0119, 10 },
  { 0x017C, 0x0065, 10 },
  { 0x017C, 0x00E9, 10 },
  { 0x017C, 0x011B, 10 },
  { 0x017C, 0x00EA, 10 },
  { 0x017C, 0x00EB, 10 },
  { 0x017C, 0x0117, 10 },
  { 0x017C, 0x00E8, 10 },
  { 0x017C, 0x0113, 10 },
  { 0x017C, 0x0119, 10 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableHelveticaOblique[] =
{
  { 0x0041, 0x0043, -30 },
  { 0x0041, 0x0106, -30 },
  { 0x0041, 0x010C, -30 },
  { 0x0041, 0x00C7, -30 },
  { 0x0041, 0x0047, -30 },
  { 0x0041, 0x011E, -30 },
  { 0x0041, 0x0122, -30 },
  { 0x0041, 0x004F, -30 },
  { 0x0041, 0x00D3, -30 },
  { 0x0041, 0x00D4, -30 },
  { 0x0041, 0x00D6, -30 },
  { 0x0041, 0x00D2, -30 },
  { 0x0041, 0x0150, -30 },
  { 0x0041, 0x014C, -30 },
  { 0x0041, 0x00D8, -30 },
  { 0x0041, 0x00D5, -30 },
  { 0x0041, 0x0051, -30 },
  { 0x0041, 0x0054, -120 },
  { 0x0041, 0x0164, -120 },
  { 0x0041, 0x0162, -120 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -70 },
  { 0x0041, 0x0057, -50 },
  { 0x0041, 0x0059, -100 },
  { 0x0041, 0x00DD, -100 },
  { 0x0041, 0x0178, -100 },
  { 0x0041, 0x0075, -30 },
  { 0x0041, 0x00FA, -30 },
  { 0x0041, 0x00FB, -30 },
  { 0x0041, 0x00FC, -30 },
  { 0x0041, 0x00F9, -30 },
  { 0x0041, 0x0171, -30 },
  { 0x0041, 0x016B, -30 },
  { 0x0041, 0x0173, -30 },
  { 0x0041, 0x016F, -30 },
  { 0x0041, 0x0076, -40 },
  { 0x0041, 0x0077, -40 },
  { 0x0041, 0x0079, -40 },
  { 0x0041, 0x00FD, -40 },
  { 0x0041, 0x00FF, -40 },
  { 0x00C1, 0x0043, -30 },
  { 0x00C1, 0x0106, -30 },
  { 0x00C1, 0x010C, -30 },
  { 0x00C1, 0x00C7, -30 },
  { 0x00C1, 0x0047, -30 },
  { 0x00C1, 0x011E, -30 },
  { 0x00C1, 0x0122, -30 },
  { 0x00C1, 0x004F, -30 },
  { 0x00C1, 0x00D3, -30 },
  { 0x00C1, 0x00D4, -30 },
  { 0x00C1, 0x00D6, -30 },
  { 0x00C1, 0x00D2, -30 },
  { 0x00C1, 0x0150, -30 },
  { 0x00C1, 0x014C, -30 },
  { 0x00C1, 0x00D8, -30 },
  { 0x00C1, 0x00D5, -30 },
  { 0x00C1, 0x0051, -30 },
  { 0x00C1, 0x0054, -120 },
  { 0x00C1, 0x0164, -120 },
  { 0x00C1, 0x0162, -120 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -70 },
  { 0x00C1, 0x0057, -50 },
  { 0x00C1, 0x0059, -100 },
  { 0x00C1, 0x00DD, -100 },
  { 0x00C1, 0x0178, -100 },
  { 0x00C1, 0x0075, -30 },
  { 0x00C1, 0x00FA, -30 },
  { 0x00C1, 0x00FB, -30 },
  { 0x00C1, 0x00FC, -30 },
  { 0x00C1, 0x00F9, -30 },
  { 0x00C1, 0x0171, -30 },
  { 0x00C1, 0x016B, -30 },
  { 0x00C1, 0x0173, -30 },
  { 0x00C1, 0x016F, -30 },
  { 0x00C1, 0x0076, -40 },
  { 0x00C1, 0x0077, -40 },
  { 0x00C1, 0x0079, -40 },
  { 0x00C1, 0x00FD, -40 },
  { 0x00C1, 0x00FF, -40 },
  { 0x0102, 0x0043, -30 },
  { 0x0102, 0x0106, -30 },
  { 0x0102, 0x010C, -30 },
  { 0x0102, 0x00C7, -30 },
  { 0x0102, 0x0047, -30 },
  { 0x0102, 0x011E, -30 },
  { 0x0102, 0x0122, -30 },
  { 0x0102, 0x004F, -30 },
  { 0x0102, 0x00D3, -30 },
  { 0x0102, 0x00D4, -30 },
  { 0x0102, 0x00D6, -30 },
  { 0x0102, 0x00D2, -30 },
  { 0x0102, 0x0150, -30 },
  { 0x0102, 0x014C, -30 },
  { 0x0102, 0x00D8, -30 },
  { 0x0102, 0x00D5, -30 },
  { 0x0102, 0x0051, -30 },
  { 0x0102, 0x0054, -120 },
  { 0x0102, 0x0164, -120 },
  { 0x0102, 0x0162, -120 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -70 },
  { 0x0102, 0x0057, -50 },
  { 0x0102, 0x0059, -100 },
  { 0x0102, 0x00DD, -100 },
  { 0x0102, 0x0178, -100 },
  { 0x0102, 0x0075, -30 },
  { 0x0102, 0x00FA, -30 },
  { 0x0102, 0x00FB, -30 },
  { 0x0102, 0x00FC, -30 },
  { 0x0102, 0x00F9, -30 },
  { 0x0102, 0x0171, -30 },
  { 0x0102, 0x016B, -30 },
  { 0x0102, 0x0173, -30 },
  { 0x0102, 0x016F, -30 },
  { 0x0102, 0x0076, -40 },
  { 0x0102, 0x0077, -40 },
  { 0x0102, 0x0079, -40 },
  { 0x0102, 0x00FD, -40 },
  { 0x0102, 0x00FF, -40 },
  { 0x00C2, 0x0043, -30 },
  { 0x00C2, 0x0106, -30 },
  { 0x00C2, 0x010C, -30 },
  { 0x00C2, 0x00C7, -30 },
  { 0x00C2, 0x0047, -30 },
  { 0x00C2, 0x011E, -30 },
  { 0x00C2, 0x0122, -30 },
  { 0x00C2, 0x004F, -30 },
  { 0x00C2, 0x00D3, -30 },
  { 0x00C2, 0x00D4, -30 },
  { 0x00C2, 0x00D6, -30 },
  { 0x00C2, 0x00D2, -30 },
  { 0x00C2, 0x0150, -30 },
  { 0x00C2, 0x014C, -30 },
  { 0x00C2, 0x00D8, -30 },
  { 0x00C2, 0x00D5, -30 },
  { 0x00C2, 0x0051, -30 },
  { 0x00C2, 0x0054, -120 },
  { 0x00C2, 0x0164, -120 },
  { 0x00C2, 0x0162, -120 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -70 },
  { 0x00C2, 0x0057, -50 },
  { 0x00C2, 0x0059, -100 },
  { 0x00C2, 0x00DD, -100 },
  { 0x00C2, 0x0178, -100 },
  { 0x00C2, 0x0075, -30 },
  { 0x00C2, 0x00FA, -30 },
  { 0x00C2, 0x00FB, -30 },
  { 0x00C2, 0x00FC, -30 },
  { 0x00C2, 0x00F9, -30 },
  { 0x00C2, 0x0171, -30 },
  { 0x00C2, 0x016B, -30 },
  { 0x00C2, 0x0173, -30 },
  { 0x00C2, 0x016F, -30 },
  { 0x00C2, 0x0076, -40 },
  { 0x00C2, 0x0077, -40 },
  { 0x00C2, 0x0079, -40 },
  { 0x00C2, 0x00FD, -40 },
  { 0x00C2, 0x00FF, -40 },
  { 0x00C4, 0x0043, -30 },
  { 0x00C4, 0x0106, -30 },
  { 0x00C4, 0x010C, -30 },
  { 0x00C4, 0x00C7, -30 },
  { 0x00C4, 0x0047, -30 },
  { 0x00C4, 0x011E, -30 },
  { 0x00C4, 0x0122, -30 },
  { 0x00C4, 0x004F, -30 },
  { 0x00C4, 0x00D3, -30 },
  { 0x00C4, 0x00D4, -30 },
  { 0x00C4, 0x00D6, -30 },
  { 0x00C4, 0x00D2, -30 },
  { 0x00C4, 0x0150, -30 },
  { 0x00C4, 0x014C, -30 },
  { 0x00C4, 0x00D8, -30 },
  { 0x00C4, 0x00D5, -30 },
  { 0x00C4, 0x0051, -30 },
  { 0x00C4, 0x0054, -120 },
  { 0x00C4, 0x0164, -120 },
  { 0x00C4, 0x0162, -120 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -70 },
  { 0x00C4, 0x0057, -50 },
  { 0x00C4, 0x0059, -100 },
  { 0x00C4, 0x00DD, -100 },
  { 0x00C4, 0x0178, -100 },
  { 0x00C4, 0x0075, -30 },
  { 0x00C4, 0x00FA, -30 },
  { 0x00C4, 0x00FB, -30 },
  { 0x00C4, 0x00FC, -30 },
  { 0x00C4, 0x00F9, -30 },
  { 0x00C4, 0x0171, -30 },
  { 0x00C4, 0x016B, -30 },
  { 0x00C4, 0x0173, -30 },
  { 0x00C4, 0x016F, -30 },
  { 0x00C4, 0x0076, -40 },
  { 0x00C4, 0x0077, -40 },
  { 0x00C4, 0x0079, -40 },
  { 0x00C4, 0x00FD, -40 },
  { 0x00C4, 0x00FF, -40 },
  { 0x00C0, 0x0043, -30 },
  { 0x00C0, 0x0106, -30 },
  { 0x00C0, 0x010C, -30 },
  { 0x00C0, 0x00C7, -30 },
  { 0x00C0, 0x0047, -30 },
  { 0x00C0, 0x011E, -30 },
  { 0x00C0, 0x0122, -30 },
  { 0x00C0, 0x004F, -30 },
  { 0x00C0, 0x00D3, -30 },
  { 0x00C0, 0x00D4, -30 },
  { 0x00C0, 0x00D6, -30 },
  { 0x00C0, 0x00D2, -30 },
  { 0x00C0, 0x0150, -30 },
  { 0x00C0, 0x014C, -30 },
  { 0x00C0, 0x00D8, -30 },
  { 0x00C0, 0x00D5, -30 },
  { 0x00C0, 0x0051, -30 },
  { 0x00C0, 0x0054, -120 },
  { 0x00C0, 0x0164, -120 },
  { 0x00C0, 0x0162, -120 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -70 },
  { 0x00C0, 0x0057, -50 },
  { 0x00C0, 0x0059, -100 },
  { 0x00C0, 0x00DD, -100 },
  { 0x00C0, 0x0178, -100 },
  { 0x00C0, 0x0075, -30 },
  { 0x00C0, 0x00FA, -30 },
  { 0x00C0, 0x00FB, -30 },
  { 0x00C0, 0x00FC, -30 },
  { 0x00C0, 0x00F9, -30 },
  { 0x00C0, 0x0171, -30 },
  { 0x00C0, 0x016B, -30 },
  { 0x00C0, 0x0173, -30 },
  { 0x00C0, 0x016F, -30 },
  { 0x00C0, 0x0076, -40 },
  { 0x00C0, 0x0077, -40 },
  { 0x00C0, 0x0079, -40 },
  { 0x00C0, 0x00FD, -40 },
  { 0x00C0, 0x00FF, -40 },
  { 0x0100, 0x0043, -30 },
  { 0x0100, 0x0106, -30 },
  { 0x0100, 0x010C, -30 },
  { 0x0100, 0x00C7, -30 },
  { 0x0100, 0x0047, -30 },
  { 0x0100, 0x011E, -30 },
  { 0x0100, 0x0122, -30 },
  { 0x0100, 0x004F, -30 },
  { 0x0100, 0x00D3, -30 },
  { 0x0100, 0x00D4, -30 },
  { 0x0100, 0x00D6, -30 },
  { 0x0100, 0x00D2, -30 },
  { 0x0100, 0x0150, -30 },
  { 0x0100, 0x014C, -30 },
  { 0x0100, 0x00D8, -30 },
  { 0x0100, 0x00D5, -30 },
  { 0x0100, 0x0051, -30 },
  { 0x0100, 0x0054, -120 },
  { 0x0100, 0x0164, -120 },
  { 0x0100, 0x0162, -120 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -70 },
  { 0x0100, 0x0057, -50 },
  { 0x0100, 0x0059, -100 },
  { 0x0100, 0x00DD, -100 },
  { 0x0100, 0x0178, -100 },
  { 0x0100, 0x0075, -30 },
  { 0x0100, 0x00FA, -30 },
  { 0x0100, 0x00FB, -30 },
  { 0x0100, 0x00FC, -30 },
  { 0x0100, 0x00F9, -30 },
  { 0x0100, 0x0171, -30 },
  { 0x0100, 0x016B, -30 },
  { 0x0100, 0x0173, -30 },
  { 0x0100, 0x016F, -30 },
  { 0x0100, 0x0076, -40 },
  { 0x0100, 0x0077, -40 },
  { 0x0100, 0x0079, -40 },
  { 0x0100, 0x00FD, -40 },
  { 0x0100, 0x00FF, -40 },
  { 0x0104, 0x0043, -30 },
  { 0x0104, 0x0106, -30 },
  { 0x0104, 0x010C, -30 },
  { 0x0104, 0x00C7, -30 },
  { 0x0104, 0x0047, -30 },
  { 0x0104, 0x011E, -30 },
  { 0x0104, 0x0122, -30 },
  { 0x0104, 0x004F, -30 },
  { 0x0104, 0x00D3, -30 },
  { 0x0104, 0x00D4, -30 },
  { 0x0104, 0x00D6, -30 },
  { 0x0104, 0x00D2, -30 },
  { 0x0104, 0x0150, -30 },
  { 0x0104, 0x014C, -30 },
  { 0x0104, 0x00D8, -30 },
  { 0x0104, 0x00D5, -30 },
  { 0x0104, 0x0051, -30 },
  { 0x0104, 0x0054, -120 },
  { 0x0104, 0x0164, -120 },
  { 0x0104, 0x0162, -120 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -70 },
  { 0x0104, 0x0057, -50 },
  { 0x0104, 0x0059, -100 },
  { 0x0104, 0x00DD, -100 },
  { 0x0104, 0x0178, -100 },
  { 0x0104, 0x0075, -30 },
  { 0x0104, 0x00FA, -30 },
  { 0x0104, 0x00FB, -30 },
  { 0x0104, 0x00FC, -30 },
  { 0x0104, 0x00F9, -30 },
  { 0x0104, 0x0171, -30 },
  { 0x0104, 0x016B, -30 },
  { 0x0104, 0x0173, -30 },
  { 0x0104, 0x016F, -30 },
  { 0x0104, 0x0076, -40 },
  { 0x0104, 0x0077, -40 },
  { 0x0104, 0x0079, -40 },
  { 0x0104, 0x00FD, -40 },
  { 0x0104, 0x00FF, -40 },
  { 0x00C5, 0x0043, -30 },
  { 0x00C5, 0x0106, -30 },
  { 0x00C5, 0x010C, -30 },
  { 0x00C5, 0x00C7, -30 },
  { 0x00C5, 0x0047, -30 },
  { 0x00C5, 0x011E, -30 },
  { 0x00C5, 0x0122, -30 },
  { 0x00C5, 0x004F, -30 },
  { 0x00C5, 0x00D3, -30 },
  { 0x00C5, 0x00D4, -30 },
  { 0x00C5, 0x00D6, -30 },
  { 0x00C5, 0x00D2, -30 },
  { 0x00C5, 0x0150, -30 },
  { 0x00C5, 0x014C, -30 },
  { 0x00C5, 0x00D8, -30 },
  { 0x00C5, 0x00D5, -30 },
  { 0x00C5, 0x0051, -30 },
  { 0x00C5, 0x0054, -120 },
  { 0x00C5, 0x0164, -120 },
  { 0x00C5, 0x0162, -120 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -70 },
  { 0x00C5, 0x0057, -50 },
  { 0x00C5, 0x0059, -100 },
  { 0x00C5, 0x00DD, -100 },
  { 0x00C5, 0x0178, -100 },
  { 0x00C5, 0x0075, -30 },
  { 0x00C5, 0x00FA, -30 },
  { 0x00C5, 0x00FB, -30 },
  { 0x00C5, 0x00FC, -30 },
  { 0x00C5, 0x00F9, -30 },
  { 0x00C5, 0x0171, -30 },
  { 0x00C5, 0x016B, -30 },
  { 0x00C5, 0x0173, -30 },
  { 0x00C5, 0x016F, -30 },
  { 0x00C5, 0x0076, -40 },
  { 0x00C5, 0x0077, -40 },
  { 0x00C5, 0x0079, -40 },
  { 0x00C5, 0x00FD, -40 },
  { 0x00C5, 0x00FF, -40 },
  { 0x00C3, 0x0043, -30 },
  { 0x00C3, 0x0106, -30 },
  { 0x00C3, 0x010C, -30 },
  { 0x00C3, 0x00C7, -30 },
  { 0x00C3, 0x0047, -30 },
  { 0x00C3, 0x011E, -30 },
  { 0x00C3, 0x0122, -30 },
  { 0x00C3, 0x004F, -30 },
  { 0x00C3, 0x00D3, -30 },
  { 0x00C3, 0x00D4, -30 },
  { 0x00C3, 0x00D6, -30 },
  { 0x00C3, 0x00D2, -30 },
  { 0x00C3, 0x0150, -30 },
  { 0x00C3, 0x014C, -30 },
  { 0x00C3, 0x00D8, -30 },
  { 0x00C3, 0x00D5, -30 },
  { 0x00C3, 0x0051, -30 },
  { 0x00C3, 0x0054, -120 },
  { 0x00C3, 0x0164, -120 },
  { 0x00C3, 0x0162, -120 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -70 },
  { 0x00C3, 0x0057, -50 },
  { 0x00C3, 0x0059, -100 },
  { 0x00C3, 0x00DD, -100 },
  { 0x00C3, 0x0178, -100 },
  { 0x00C3, 0x0075, -30 },
  { 0x00C3, 0x00FA, -30 },
  { 0x00C3, 0x00FB, -30 },
  { 0x00C3, 0x00FC, -30 },
  { 0x00C3, 0x00F9, -30 },
  { 0x00C3, 0x0171, -30 },
  { 0x00C3, 0x016B, -30 },
  { 0x00C3, 0x0173, -30 },
  { 0x00C3, 0x016F, -30 },
  { 0x00C3, 0x0076, -40 },
  { 0x00C3, 0x0077, -40 },
  { 0x00C3, 0x0079, -40 },
  { 0x00C3, 0x00FD, -40 },
  { 0x00C3, 0x00FF, -40 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0042, 0x002C, -20 },
  { 0x0042, 0x002E, -20 },
  { 0x0043, 0x002C, -30 },
  { 0x0043, 0x002E, -30 },
  { 0x0106, 0x002C, -30 },
  { 0x0106, 0x002E, -30 },
  { 0x010C, 0x002C, -30 },
  { 0x010C, 0x002E, -30 },
  { 0x00C7, 0x002C, -30 },
  { 0x00C7, 0x002E, -30 },
  { 0x0044, 0x0041, -40 },
  { 0x0044, 0x00C1, -40 },
  { 0x0044, 0x0102, -40 },
  { 0x0044, 0x00C2, -40 },
  { 0x0044, 0x00C4, -40 },
  { 0x0044, 0x00C0, -40 },
  { 0x0044, 0x0100, -40 },
  { 0x0044, 0x0104, -40 },
  { 0x0044, 0x00C5, -40 },
  { 0x0044, 0x00C3, -40 },
  { 0x0044, 0x0056, -70 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -90 },
  { 0x0044, 0x00DD, -90 },
  { 0x0044, 0x0178, -90 },
  { 0x0044, 0x002C, -70 },
  { 0x0044, 0x002E, -70 },
  { 0x010E, 0x0041, -40 },
  { 0x010E, 0x00C1, -40 },
  { 0x010E, 0x0102, -40 },
  { 0x010E, 0x00C2, -40 },
  { 0x010E, 0x00C4, -40 },
  { 0x010E, 0x00C0, -40 },
  { 0x010E, 0x0100, -40 },
  { 0x010E, 0x0104, -40 },
  { 0x010E, 0x00C5, -40 },
  { 0x010E, 0x00C3, -40 },
  { 0x010E, 0x0056, -70 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -90 },
  { 0x010E, 0x00DD, -90 },
  { 0x010E, 0x0178, -90 },
  { 0x010E, 0x002C, -70 },
  { 0x010E, 0x002E, -70 },
  { 0x0110, 0x0041, -40 },
  { 0x0110, 0x00C1, -40 },
  { 0x0110, 0x0102, -40 },
  { 0x0110, 0x00C2, -40 },
  { 0x0110, 0x00C4, -40 },
  { 0x0110, 0x00C0, -40 },
  { 0x0110, 0x0100, -40 },
  { 0x0110, 0x0104, -40 },
  { 0x0110, 0x00C5, -40 },
  { 0x0110, 0x00C3, -40 },
  { 0x0110, 0x0056, -70 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -90 },
  { 0x0110, 0x00DD, -90 },
  { 0x0110, 0x0178, -90 },
  { 0x0110, 0x002C, -70 },
  { 0x0110, 0x002E, -70 },
  { 0x0046, 0x0041, -80 },
  { 0x0046, 0x00C1, -80 },
  { 0x0046, 0x0102, -80 },
  { 0x0046, 0x00C2, -80 },
  { 0x0046, 0x00C4, -80 },
  { 0x0046, 0x00C0, -80 },
  { 0x0046, 0x0100, -80 },
  { 0x0046, 0x0104, -80 },
  { 0x0046, 0x00C5, -80 },
  { 0x0046, 0x00C3, -80 },
  { 0x0046, 0x0061, -50 },
  { 0x0046, 0x00E1, -50 },
  { 0x0046, 0x0103, -50 },
  { 0x0046, 0x00E2, -50 },
  { 0x0046, 0x00E4, -50 },
  { 0x0046, 0x00E0, -50 },
  { 0x0046, 0x0101, -50 },
  { 0x0046, 0x0105, -50 },
  { 0x0046, 0x00E5, -50 },
  { 0x0046, 0x00E3, -50 },
  { 0x0046, 0x002C, -150 },
  { 0x0046, 0x0065, -30 },
  { 0x0046, 0x00E9, -30 },
  { 0x0046, 0x011B, -30 },
  { 0x0046, 0x00EA, -30 },
  { 0x0046, 0x00EB, -30 },
  { 0x0046, 0x0117, -30 },
  { 0x0046, 0x00E8, -30 },
  { 0x0046, 0x0113, -30 },
  { 0x0046, 0x0119, -30 },
  { 0x0046, 0x006F, -30 },
  { 0x0046, 0x00F3, -30 },
  { 0x0046, 0x00F4, -30 },
  { 0x0046, 0x00F6, -30 },
  { 0x0046, 0x00F2, -30 },
  { 0x0046, 0x0151, -30 },
  { 0x0046, 0x014D, -30 },
  { 0x0046, 0x00F8, -30 },
  { 0x0046, 0x00F5, -30 },
  { 0x0046, 0x002E, -150 },
  { 0x0046, 0x0072, -45 },
  { 0x0046, 0x0155, -45 },
  { 0x0046, 0x0159, -45 },
  { 0x0046, 0x0157, -45 },
  { 0x004A, 0x0041, -20 },
  { 0x004A, 0x00C1, -20 },
  { 0x004A, 0x0102, -20 },
  { 0x004A, 0x00C2, -20 },
  { 0x004A, 0x00C4, -20 },
  { 0x004A, 0x00C0, -20 },
  { 0x004A, 0x0100, -20 },
  { 0x004A, 0x0104, -20 },
  { 0x004A, 0x00C5, -20 },
  { 0x004A, 0x00C3, -20 },
  { 0x004A, 0x0061, -20 },
  { 0x004A, 0x00E1, -20 },
  { 0x004A, 0x0103, -20 },
  { 0x004A, 0x00E2, -20 },
  { 0x004A, 0x00E4, -20 },
  { 0x004A, 0x00E0, -20 },
  { 0x004A, 0x0101, -20 },
  { 0x004A, 0x0105, -20 },
  { 0x004A, 0x00E5, -20 },
  { 0x004A, 0x00E3, -20 },
  { 0x004A, 0x002C, -30 },
  { 0x004A, 0x002E, -30 },
  { 0x004A, 0x0075, -20 },
  { 0x004A, 0x00FA, -20 },
  { 0x004A, 0x00FB, -20 },
  { 0x004A, 0x00FC, -20 },
  { 0x004A, 0x00F9, -20 },
  { 0x004A, 0x0171, -20 },
  { 0x004A, 0x016B, -20 },
  { 0x004A, 0x0173, -20 },
  { 0x004A, 0x016F, -20 },
  { 0x004B, 0x004F, -50 },
  { 0x004B, 0x00D3, -50 },
  { 0x004B, 0x00D4, -50 },
  { 0x004B, 0x00D6, -50 },
  { 0x004B, 0x00D2, -50 },
  { 0x004B, 0x0150, -50 },
  { 0x004B, 0x014C, -50 },
  { 0x004B, 0x00D8, -50 },
  { 0x004B, 0x00D5, -50 },
  { 0x004B, 0x0065, -40 },
  { 0x004B, 0x00E9, -40 },
  { 0x004B, 0x011B, -40 },
  { 0x004B, 0x00EA, -40 },
  { 0x004B, 0x00EB, -40 },
  { 0x004B, 0x0117, -40 },
  { 0x004B, 0x00E8, -40 },
  { 0x004B, 0x0113, -40 },
  { 0x004B, 0x0119, -40 },
  { 0x004B, 0x006F, -40 },
  { 0x004B, 0x00F3, -40 },
  { 0x004B, 0x00F4, -40 },
  { 0x004B, 0x00F6, -40 },
  { 0x004B, 0x00F2, -40 },
  { 0x004B, 0x0151, -40 },
  { 0x004B, 0x014D, -40 },
  { 0x004B, 0x00F8, -40 },
  { 0x004B, 0x00F5, -40 },
  { 0x004B, 0x0075, -30 },
  { 0x004B, 0x00FA, -30 },
  { 0x004B, 0x00FB, -30 },
  { 0x004B, 0x00FC, -30 },
  { 0x004B, 0x00F9, -30 },
  { 0x004B, 0x0171, -30 },
  { 0x004B, 0x016B, -30 },
  { 0x004B, 0x0173, -30 },
  { 0x004B, 0x016F, -30 },
  { 0x004B, 0x0079, -50 },
  { 0x004B, 0x00FD, -50 },
  { 0x004B, 0x00FF, -50 },
  { 0x0136, 0x004F, -50 },
  { 0x0136, 0x00D3, -50 },
  { 0x0136, 0x00D4, -50 },
  { 0x0136, 0x00D6, -50 },
  { 0x0136, 0x00D2, -50 },
  { 0x0136, 0x0150, -50 },
  { 0x0136, 0x014C, -50 },
  { 0x0136, 0x00D8, -50 },
  { 0x0136, 0x00D5, -50 },
  { 0x0136, 0x0065, -40 },
  { 0x0136, 0x00E9, -40 },
  { 0x0136, 0x011B, -40 },
  { 0x0136, 0x00EA, -40 },
  { 0x0136, 0x00EB, -40 },
  { 0x0136, 0x0117, -40 },
  { 0x0136, 0x00E8, -40 },
  { 0x0136, 0x0113, -40 },
  { 0x0136, 0x0119, -40 },
  { 0x0136, 0x006F, -40 },
  { 0x0136, 0x00F3, -40 },
  { 0x0136, 0x00F4, -40 },
  { 0x0136, 0x00F6, -40 },
  { 0x0136, 0x00F2, -40 },
  { 0x0136, 0x0151, -40 },
  { 0x0136, 0x014D, -40 },
  { 0x0136, 0x00F8, -40 },
  { 0x0136, 0x00F5, -40 },
  { 0x0136, 0x0075, -30 },
  { 0x0136, 0x00FA, -30 },
  { 0x0136, 0x00FB, -30 },
  { 0x0136, 0x00FC, -30 },
  { 0x0136, 0x00F9, -30 },
  { 0x0136, 0x0171, -30 },
  { 0x0136, 0x016B, -30 },
  { 0x0136, 0x0173, -30 },
  { 0x0136, 0x016F, -30 },
  { 0x0136, 0x0079, -50 },
  { 0x0136, 0x00FD, -50 },
  { 0x0136, 0x00FF, -50 },
  { 0x004C, 0x0054, -110 },
  { 0x004C, 0x0164, -110 },
  { 0x004C, 0x0162, -110 },
  { 0x004C, 0x0056, -110 },
  { 0x004C, 0x0057, -70 },
  { 0x004C, 0x0059, -140 },
  { 0x004C, 0x00DD, -140 },
  { 0x004C, 0x0178, -140 },
  { 0x004C, 0x201D, -140 },
  { 0x004C, 0x2019, -160 },
  { 0x004C, 0x0079, -30 },
  { 0x004C, 0x00FD, -30 },
  { 0x004C, 0x00FF, -30 },
  { 0x0139, 0x0054, -110 },
  { 0x0139, 0x0164, -110 },
  { 0x0139, 0x0162, -110 },
  { 0x0139, 0x0056, -110 },
  { 0x0139, 0x0057, -70 },
  { 0x0139, 0x0059, -140 },
  { 0x0139, 0x00DD, -140 },
  { 0x0139, 0x0178, -140 },
  { 0x0139, 0x201D, -140 },
  { 0x0139, 0x2019, -160 },
  { 0x0139, 0x0079, -30 },
  { 0x0139, 0x00FD, -30 },
  { 0x0139, 0x00FF, -30 },
  { 0x013D, 0x0054, -110 },
  { 0x013D, 0x0164, -110 },
  { 0x013D, 0x0162, -110 },
  { 0x013D, 0x0056, -110 },
  { 0x013D, 0x0057, -70 },
  { 0x013D, 0x0059, -140 },
  { 0x013D, 0x00DD, -140 },
  { 0x013D, 0x0178, -140 },
  { 0x013D, 0x201D, -140 },
  { 0x013D, 0x2019, -160 },
  { 0x013D, 0x0079, -30 },
  { 0x013D, 0x00FD, -30 },
  { 0x013D, 0x00FF, -30 },
  { 0x013B, 0x0054, -110 },
  { 0x013B, 0x0164, -110 },
  { 0x013B, 0x0162, -110 },
  { 0x013B, 0x0056, -110 },
  { 0x013B, 0x0057, -70 },
  { 0x013B, 0x0059, -140 },
  { 0x013B, 0x00DD, -140 },
  { 0x013B, 0x0178, -140 },
  { 0x013B, 0x201D, -140 },
  { 0x013B, 0x2019, -160 },
  { 0x013B, 0x0079, -30 },
  { 0x013B, 0x00FD, -30 },
  { 0x013B, 0x00FF, -30 },
  { 0x0141, 0x0054, -110 },
  { 0x0141, 0x0164, -110 },
  { 0x0141, 0x0162, -110 },
  { 0x0141, 0x0056, -110 },
  { 0x0141, 0x0057, -70 },
  { 0x0141, 0x0059, -140 },
  { 0x0141, 0x00DD, -140 },
  { 0x0141, 0x0178, -140 },
  { 0x0141, 0x201D, -140 },
  { 0x0141, 0x2019, -160 },
  { 0x0141, 0x0079, -30 },
  { 0x0141, 0x00FD, -30 },
  { 0x0141, 0x00FF, -30 },
  { 0x004F, 0x0041, -20 },
  { 0x004F, 0x00C1, -20 },
  { 0x004F, 0x0102, -20 },
  { 0x004F, 0x00C2, -20 },
  { 0x004F, 0x00C4, -20 },
  { 0x004F, 0x00C0, -20 },
  { 0x004F, 0x0100, -20 },
  { 0x004F, 0x0104, -20 },
  { 0x004F, 0x00C5, -20 },
  { 0x004F, 0x00C3, -20 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -30 },
  { 0x004F, 0x0058, -60 },
  { 0x004F, 0x0059, -70 },
  { 0x004F, 0x00DD, -70 },
  { 0x004F, 0x0178, -70 },
  { 0x004F, 0x002C, -40 },
  { 0x004F, 0x002E, -40 },
  { 0x00D3, 0x0041, -20 },
  { 0x00D3, 0x00C1, -20 },
  { 0x00D3, 0x0102, -20 },
  { 0x00D3, 0x00C2, -20 },
  { 0x00D3, 0x00C4, -20 },
  { 0x00D3, 0x00C0, -20 },
  { 0x00D3, 0x0100, -20 },
  { 0x00D3, 0x0104, -20 },
  { 0x00D3, 0x00C5, -20 },
  { 0x00D3, 0x00C3, -20 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -30 },
  { 0x00D3, 0x0058, -60 },
  { 0x00D3, 0x0059, -70 },
  { 0x00D3, 0x00DD, -70 },
  { 0x00D3, 0x0178, -70 },
  { 0x00D3, 0x002C, -40 },
  { 0x00D3, 0x002E, -40 },
  { 0x00D4, 0x0041, -20 },
  { 0x00D4, 0x00C1, -20 },
  { 0x00D4, 0x0102, -20 },
  { 0x00D4, 0x00C2, -20 },
  { 0x00D4, 0x00C4, -20 },
  { 0x00D4, 0x00C0, -20 },
  { 0x00D4, 0x0100, -20 },
  { 0x00D4, 0x0104, -20 },
  { 0x00D4, 0x00C5, -20 },
  { 0x00D4, 0x00C3, -20 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -30 },
  { 0x00D4, 0x0058, -60 },
  { 0x00D4, 0x0059, -70 },
  { 0x00D4, 0x00DD, -70 },
  { 0x00D4, 0x0178, -70 },
  { 0x00D4, 0x002C, -40 },
  { 0x00D4, 0x002E, -40 },
  { 0x00D6, 0x0041, -20 },
  { 0x00D6, 0x00C1, -20 },
  { 0x00D6, 0x0102, -20 },
  { 0x00D6, 0x00C2, -20 },
  { 0x00D6, 0x00C4, -20 },
  { 0x00D6, 0x00C0, -20 },
  { 0x00D6, 0x0100, -20 },
  { 0x00D6, 0x0104, -20 },
  { 0x00D6, 0x00C5, -20 },
  { 0x00D6, 0x00C3, -20 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -30 },
  { 0x00D6, 0x0058, -60 },
  { 0x00D6, 0x0059, -70 },
  { 0x00D6, 0x00DD, -70 },
  { 0x00D6, 0x0178, -70 },
  { 0x00D6, 0x002C, -40 },
  { 0x00D6, 0x002E, -40 },
  { 0x00D2, 0x0041, -20 },
  { 0x00D2, 0x00C1, -20 },
  { 0x00D2, 0x0102, -20 },
  { 0x00D2, 0x00C2, -20 },
  { 0x00D2, 0x00C4, -20 },
  { 0x00D2, 0x00C0, -20 },
  { 0x00D2, 0x0100, -20 },
  { 0x00D2, 0x0104, -20 },
  { 0x00D2, 0x00C5, -20 },
  { 0x00D2, 0x00C3, -20 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -30 },
  { 0x00D2, 0x0058, -60 },
  { 0x00D2, 0x0059, -70 },
  { 0x00D2, 0x00DD, -70 },
  { 0x00D2, 0x0178, -70 },
  { 0x00D2, 0x002C, -40 },
  { 0x00D2, 0x002E, -40 },
  { 0x0150, 0x0041, -20 },
  { 0x0150, 0x00C1, -20 },
  { 0x0150, 0x0102, -20 },
  { 0x0150, 0x00C2, -20 },
  { 0x0150, 0x00C4, -20 },
  { 0x0150, 0x00C0, -20 },
  { 0x0150, 0x0100, -20 },
  { 0x0150, 0x0104, -20 },
  { 0x0150, 0x00C5, -20 },
  { 0x0150, 0x00C3, -20 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -30 },
  { 0x0150, 0x0058, -60 },
  { 0x0150, 0x0059, -70 },
  { 0x0150, 0x00DD, -70 },
  { 0x0150, 0x0178, -70 },
  { 0x0150, 0x002C, -40 },
  { 0x0150, 0x002E, -40 },
  { 0x014C, 0x0041, -20 },
  { 0x014C, 0x00C1, -20 },
  { 0x014C, 0x0102, -20 },
  { 0x014C, 0x00C2, -20 },
  { 0x014C, 0x00C4, -20 },
  { 0x014C, 0x00C0, -20 },
  { 0x014C, 0x0100, -20 },
  { 0x014C, 0x0104, -20 },
  { 0x014C, 0x00C5, -20 },
  { 0x014C, 0x00C3, -20 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -30 },
  { 0x014C, 0x0058, -60 },
  { 0x014C, 0x0059, -70 },
  { 0x014C, 0x00DD, -70 },
  { 0x014C, 0x0178, -70 },
  { 0x014C, 0x002C, -40 },
  { 0x014C, 0x002E, -40 },
  { 0x00D8, 0x0041, -20 },
  { 0x00D8, 0x00C1, -20 },
  { 0x00D8, 0x0102, -20 },
  { 0x00D8, 0x00C2, -20 },
  { 0x00D8, 0x00C4, -20 },
  { 0x00D8, 0x00C0, -20 },
  { 0x00D8, 0x0100, -20 },
  { 0x00D8, 0x0104, -20 },
  { 0x00D8, 0x00C5, -20 },
  { 0x00D8, 0x00C3, -20 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -30 },
  { 0x00D8, 0x0058, -60 },
  { 0x00D8, 0x0059, -70 },
  { 0x00D8, 0x00DD, -70 },
  { 0x00D8, 0x0178, -70 },
  { 0x00D8, 0x002C, -40 },
  { 0x00D8, 0x002E, -40 },
  { 0x00D5, 0x0041, -20 },
  { 0x00D5, 0x00C1, -20 },
  { 0x00D5, 0x0102, -20 },
  { 0x00D5, 0x00C2, -20 },
  { 0x00D5, 0x00C4, -20 },
  { 0x00D5, 0x00C0, -20 },
  { 0x00D5, 0x0100, -20 },
  { 0x00D5, 0x0104, -20 },
  { 0x00D5, 0x00C5, -20 },
  { 0x00D5, 0x00C3, -20 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -30 },
  { 0x00D5, 0x0058, -60 },
  { 0x00D5, 0x0059, -70 },
  { 0x00D5, 0x00DD, -70 },
  { 0x00D5, 0x0178, -70 },
  { 0x00D5, 0x002C, -40 },
  { 0x00D5, 0x002E, -40 },
  { 0x0050, 0x0041, -120 },
  { 0x0050, 0x00C1, -120 },
  { 0x0050, 0x0102, -120 },
  { 0x0050, 0x00C2, -120 },
  { 0x0050, 0x00C4, -120 },
  { 0x0050, 0x00C0, -120 },
  { 0x0050, 0x0100, -120 },
  { 0x0050, 0x0104, -120 },
  { 0x0050, 0x00C5, -120 },
  { 0x0050, 0x00C3, -120 },
  { 0x0050, 0x0061, -40 },
  { 0x0050, 0x00E1, -40 },
  { 0x0050, 0x0103, -40 },
  { 0x0050, 0x00E2, -40 },
  { 0x0050, 0x00E4, -40 },
  { 0x0050, 0x00E0, -40 },
  { 0x0050, 0x0101, -40 },
  { 0x0050, 0x0105, -40 },
  { 0x0050, 0x00E5, -40 },
  { 0x0050, 0x00E3, -40 },
  { 0x0050, 0x002C, -180 },
  { 0x0050, 0x0065, -50 },
  { 0x0050, 0x00E9, -50 },
  { 0x0050, 0x011B, -50 },
  { 0x0050, 0x00EA, -50 },
  { 0x0050, 0x00EB, -50 },
  { 0x0050, 0x0117, -50 },
  { 0x0050, 0x00E8, -50 },
  { 0x0050, 0x0113, -50 },
  { 0x0050, 0x0119, -50 },
  { 0x0050, 0x006F, -50 },
  { 0x0050, 0x00F3, -50 },
  { 0x0050, 0x00F4, -50 },
  { 0x0050, 0x00F6, -50 },
  { 0x0050, 0x00F2, -50 },
  { 0x0050, 0x0151, -50 },
  { 0x0050, 0x014D, -50 },
  { 0x0050, 0x00F8, -50 },
  { 0x0050, 0x00F5, -50 },
  { 0x0050, 0x002E, -180 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0052, 0x004F, -20 },
  { 0x0052, 0x00D3, -20 },
  { 0x0052, 0x00D4, -20 },
  { 0x0052, 0x00D6, -20 },
  { 0x0052, 0x00D2, -20 },
  { 0x0052, 0x0150, -20 },
  { 0x0052, 0x014C, -20 },
  { 0x0052, 0x00D8, -20 },
  { 0x0052, 0x00D5, -20 },
  { 0x0052, 0x0054, -30 },
  { 0x0052, 0x0164, -30 },
  { 0x0052, 0x0162, -30 },
  { 0x0052, 0x0055, -40 },
  { 0x0052, 0x00DA, -40 },
  { 0x0052, 0x00DB, -40 },
  { 0x0052, 0x00DC, -40 },
  { 0x0052, 0x00D9, -40 },
  { 0x0052, 0x0170, -40 },
  { 0x0052, 0x016A, -40 },
  { 0x0052, 0x0172, -40 },
  { 0x0052, 0x016E, -40 },
  { 0x0052, 0x0056, -50 },
  { 0x0052, 0x0057, -30 },
  { 0x0052, 0x0059, -50 },
  { 0x0052, 0x00DD, -50 },
  { 0x0052, 0x0178, -50 },
  { 0x0154, 0x004F, -20 },
  { 0x0154, 0x00D3, -20 },
  { 0x0154, 0x00D4, -20 },
  { 0x0154, 0x00D6, -20 },
  { 0x0154, 0x00D2, -20 },
  { 0x0154, 0x0150, -20 },
  { 0x0154, 0x014C, -20 },
  { 0x0154, 0x00D8, -20 },
  { 0x0154, 0x00D5, -20 },
  { 0x0154, 0x0054, -30 },
  { 0x0154, 0x0164, -30 },
  { 0x0154, 0x0162, -30 },
  { 0x0154, 0x0055, -40 },
  { 0x0154, 0x00DA, -40 },
  { 0x0154, 0x00DB, -40 },
  { 0x0154, 0x00DC, -40 },
  { 0x0154, 0x00D9, -40 },
  { 0x0154, 0x0170, -40 },
  { 0x0154, 0x016A, -40 },
  { 0x0154, 0x0172, -40 },
  { 0x0154, 0x016E, -40 },
  { 0x0154, 0x0056, -50 },
  { 0x0154, 0x0057, -30 },
  { 0x0154, 0x0059, -50 },
  { 0x0154, 0x00DD, -50 },
  { 0x0154, 0x0178, -50 },
  { 0x0158, 0x004F, -20 },
  { 0x0158, 0x00D3, -20 },
  { 0x0158, 0x00D4, -20 },
  { 0x0158, 0x00D6, -20 },
  { 0x0158, 0x00D2, -20 },
  { 0x0158, 0x0150, -20 },
  { 0x0158, 0x014C, -20 },
  { 0x0158, 0x00D8, -20 },
  { 0x0158, 0x00D5, -20 },
  { 0x0158, 0x0054, -30 },
  { 0x0158, 0x0164, -30 },
  { 0x0158, 0x0162, -30 },
  { 0x0158, 0x0055, -40 },
  { 0x0158, 0x00DA, -40 },
  { 0x0158, 0x00DB, -40 },
  { 0x0158, 0x00DC, -40 },
  { 0x0158, 0x00D9, -40 },
  { 0x0158, 0x0170, -40 },
  { 0x0158, 0x016A, -40 },
  { 0x0158, 0x0172, -40 },
  { 0x0158, 0x016E, -40 },
  { 0x0158, 0x0056, -50 },
  { 0x0158, 0x0057, -30 },
  { 0x0158, 0x0059, -50 },
  { 0x0158, 0x00DD, -50 },
  { 0x0158, 0x0178, -50 },
  { 0x0156, 0x004F, -20 },
  { 0x0156, 0x00D3, -20 },
  { 0x0156, 0x00D4, -20 },
  { 0x0156, 0x00D6, -20 },
  { 0x0156, 0x00D2, -20 },
  { 0x0156, 0x0150, -20 },
  { 0x0156, 0x014C, -20 },
  { 0x0156, 0x00D8, -20 },
  { 0x0156, 0x00D5, -20 },
  { 0x0156, 0x0054, -30 },
  { 0x0156, 0x0164, -30 },
  { 0x0156, 0x0162, -30 },
  { 0x0156, 0x0055, -40 },
  { 0x0156, 0x00DA, -40 },
  { 0x0156, 0x00DB, -40 },
  { 0x0156, 0x00DC, -40 },
  { 0x0156, 0x00D9, -40 },
  { 0x0156, 0x0170, -40 },
  { 0x0156, 0x016A, -40 },
  { 0x0156, 0x0172, -40 },
  { 0x0156, 0x016E, -40 },
  { 0x0156, 0x0056, -50 },
  { 0x0156, 0x0057, -30 },
  { 0x0156, 0x0059, -50 },
  { 0x0156, 0x00DD, -50 },
  { 0x0156, 0x0178, -50 },
  { 0x0053, 0x002C, -20 },
  { 0x0053, 0x002E, -20 },
  { 0x015A, 0x002C, -20 },
  { 0x015A, 0x002E, -20 },
  { 0x0160, 0x002C, -20 },
  { 0x0160, 0x002E, -20 },
  { 0x015E, 0x002C, -20 },
  { 0x015E, 0x002E, -20 },
  { 0x0218, 0x002C, -20 },
  { 0x0218, 0x002E, -20 },
  { 0x0054, 0x0041, -120 },
  { 0x0054, 0x00C1, -120 },
  { 0x0054, 0x0102, -120 },
  { 0x0054, 0x00C2, -120 },
  { 0x0054, 0x00C4, -120 },
  { 0x0054, 0x00C0, -120 },
  { 0x0054, 0x0100, -120 },
  { 0x0054, 0x0104, -120 },
  { 0x0054, 0x00C5, -120 },
  { 0x0054, 0x00C3, -120 },
  { 0x0054, 0x004F, -40 },
  { 0x0054, 0x00D3, -40 },
  { 0x0054, 0x00D4, -40 },
  { 0x0054, 0x00D6, -40 },
  { 0x0054, 0x00D2, -40 },
  { 0x0054, 0x0150, -40 },
  { 0x0054, 0x014C, -40 },
  { 0x0054, 0x00D8, -40 },
  { 0x0054, 0x00D5, -40 },
  { 0x0054, 0x0061, -120 },
  { 0x0054, 0x00E1, -120 },
  { 0x0054, 0x0103, -60 },
  { 0x0054, 0x00E2, -120 },
  { 0x0054, 0x00E4, -120 },
  { 0x0054, 0x00E0, -120 },
  { 0x0054, 0x0101, -60 },
  { 0x0054, 0x0105, -120 },
  { 0x0054, 0x00E5, -120 },
  { 0x0054, 0x00E3, -60 },
  { 0x0054, 0x003A, -20 },
  { 0x0054, 0x002C, -120 },
  { 0x0054, 0x0065, -120 },
  { 0x0054, 0x00E9, -120 },
  { 0x0054, 0x011B, -120 },
  { 0x0054, 0x00EA, -120 },
  { 0x0054, 0x00EB, -120 },
  { 0x0054, 0x0117, -120 },
  { 0x0054, 0x00E8, -60 },
  { 0x0054, 0x0113, -60 },
  { 0x0054, 0x0119, -120 },
  { 0x0054, 0x002D, -140 },
  { 0x0054, 0x006F, -120 },
  { 0x0054, 0x00F3, -120 },
  { 0x0054, 0x00F4, -120 },
  { 0x0054, 0x00F6, -120 },
  { 0x0054, 0x00F2, -120 },
  { 0x0054, 0x0151, -120 },
  { 0x0054, 0x014D, -60 },
  { 0x0054, 0x00F8, -120 },
  { 0x0054, 0x00F5, -60 },
  { 0x0054, 0x002E, -120 },
  { 0x0054, 0x0072, -120 },
  { 0x0054, 0x0155, -120 },
  { 0x0054, 0x0159, -120 },
  { 0x0054, 0x0157, -120 },
  { 0x0054, 0x003B, -20 },
  { 0x0054, 0x0075, -120 },
  { 0x0054, 0x00FA, -120 },
  { 0x0054, 0x00FB, -120 },
  { 0x0054, 0x00FC, -120 },
  { 0x0054, 0x00F9, -120 },
  { 0x0054, 0x0171, -120 },
  { 0x0054, 0x016B, -60 },
  { 0x0054, 0x0173, -120 },
  { 0x0054, 0x016F, -120 },
  { 0x0054, 0x0077, -120 },
  { 0x0054, 0x0079, -120 },
  { 0x0054, 0x00FD, -120 },
  { 0x0054, 0x00FF, -60 },
  { 0x0164, 0x0041, -120 },
  { 0x0164, 0x00C1, -120 },
  { 0x0164, 0x0102, -120 },
  { 0x0164, 0x00C2, -120 },
  { 0x0164, 0x00C4, -120 },
  { 0x0164, 0x00C0, -120 },
  { 0x0164, 0x0100, -120 },
  { 0x0164, 0x0104, -120 },
  { 0x0164, 0x00C5, -120 },
  { 0x0164, 0x00C3, -120 },
  { 0x0164, 0x004F, -40 },
  { 0x0164, 0x00D3, -40 },
  { 0x0164, 0x00D4, -40 },
  { 0x0164, 0x00D6, -40 },
  { 0x0164, 0x00D2, -40 },
  { 0x0164, 0x0150, -40 },
  { 0x0164, 0x014C, -40 },
  { 0x0164, 0x00D8, -40 },
  { 0x0164, 0x00D5, -40 },
  { 0x0164, 0x0061, -120 },
  { 0x0164, 0x00E1, -120 },
  { 0x0164, 0x0103, -60 },
  { 0x0164, 0x00E2, -120 },
  { 0x0164, 0x00E4, -120 },
  { 0x0164, 0x00E0, -120 },
  { 0x0164, 0x0101, -60 },
  { 0x0164, 0x0105, -120 },
  { 0x0164, 0x00E5, -120 },
  { 0x0164, 0x00E3, -60 },
  { 0x0164, 0x003A, -20 },
  { 0x0164, 0x002C, -120 },
  { 0x0164, 0x0065, -120 },
  { 0x0164, 0x00E9, -120 },
  { 0x0164, 0x011B, -120 },
  { 0x0164, 0x00EA, -120 },
  { 0x0164, 0x00EB, -120 },
  { 0x0164, 0x0117, -120 },
  { 0x0164, 0x00E8, -60 },
  { 0x0164, 0x0113, -60 },
  { 0x0164, 0x0119, -120 },
  { 0x0164, 0x002D, -140 },
  { 0x0164, 0x006F, -120 },
  { 0x0164, 0x00F3, -120 },
  { 0x0164, 0x00F4, -120 },
  { 0x0164, 0x00F6, -120 },
  { 0x0164, 0x00F2, -120 },
  { 0x0164, 0x0151, -120 },
  { 0x0164, 0x014D, -60 },
  { 0x0164, 0x00F8, -120 },
  { 0x0164, 0x00F5, -60 },
  { 0x0164, 0x002E, -120 },
  { 0x0164, 0x0072, -120 },
  { 0x0164, 0x0155, -120 },
  { 0x0164, 0x0159, -120 },
  { 0x0164, 0x0157, -120 },
  { 0x0164, 0x003B, -20 },
  { 0x0164, 0x0075, -120 },
  { 0x0164, 0x00FA, -120 },
  { 0x0164, 0x00FB, -120 },
  { 0x0164, 0x00FC, -120 },
  { 0x0164, 0x00F9, -120 },
  { 0x0164, 0x0171, -120 },
  { 0x0164, 0x016B, -60 },
  { 0x0164, 0x0173, -120 },
  { 0x0164, 0x016F, -120 },
  { 0x0164, 0x0077, -120 },
  { 0x0164, 0x0079, -120 },
  { 0x0164, 0x00FD, -120 },
  { 0x0164, 0x00FF, -60 },
  { 0x0162, 0x0041, -120 },
  { 0x0162, 0x00C1, -120 },
  { 0x0162, 0x0102, -120 },
  { 0x0162, 0x00C2, -120 },
  { 0x0162, 0x00C4, -120 },
  { 0x0162, 0x00C0, -120 },
  { 0x0162, 0x0100, -120 },
  { 0x0162, 0x0104, -120 },
  { 0x0162, 0x00C5, -120 },
  { 0x0162, 0x00C3, -120 },
  { 0x0162, 0x004F, -40 },
  { 0x0162, 0x00D3, -40 },
  { 0x0162, 0x00D4, -40 },
  { 0x0162, 0x00D6, -40 },
  { 0x0162, 0x00D2, -40 },
  { 0x0162, 0x0150, -40 },
  { 0x0162, 0x014C, -40 },
  { 0x0162, 0x00D8, -40 },
  { 0x0162, 0x00D5, -40 },
  { 0x0162, 0x0061, -120 },
  { 0x0162, 0x00E1, -120 },
  { 0x0162, 0x0103, -60 },
  { 0x0162, 0x00E2, -120 },
  { 0x0162, 0x00E4, -120 },
  { 0x0162, 0x00E0, -120 },
  { 0x0162, 0x0101, -60 },
  { 0x0162, 0x0105, -120 },
  { 0x0162, 0x00E5, -120 },
  { 0x0162, 0x00E3, -60 },
  { 0x0162, 0x003A, -20 },
  { 0x0162, 0x002C, -120 },
  { 0x0162, 0x0065, -120 },
  { 0x0162, 0x00E9, -120 },
  { 0x0162, 0x011B, -120 },
  { 0x0162, 0x00EA, -120 },
  { 0x0162, 0x00EB, -120 },
  { 0x0162, 0x0117, -120 },
  { 0x0162, 0x00E8, -60 },
  { 0x0162, 0x0113, -60 },
  { 0x0162, 0x0119, -120 },
  { 0x0162, 0x002D, -140 },
  { 0x0162, 0x006F, -120 },
  { 0x0162, 0x00F3, -120 },
  { 0x0162, 0x00F4, -120 },
  { 0x0162, 0x00F6, -120 },
  { 0x0162, 0x00F2, -120 },
  { 0x0162, 0x0151, -120 },
  { 0x0162, 0x014D, -60 },
  { 0x0162, 0x00F8, -120 },
  { 0x0162, 0x00F5, -60 },
  { 0x0162, 0x002E, -120 },
  { 0x0162, 0x0072, -120 },
  { 0x0162, 0x0155, -120 },
  { 0x0162, 0x0159, -120 },
  { 0x0162, 0x0157, -120 },
  { 0x0162, 0x003B, -20 },
  { 0x0162, 0x0075, -120 },
  { 0x0162, 0x00FA, -120 },
  { 0x0162, 0x00FB, -120 },
  { 0x0162, 0x00FC, -120 },
  { 0x0162, 0x00F9, -120 },
  { 0x0162, 0x0171, -120 },
  { 0x0162, 0x016B, -60 },
  { 0x0162, 0x0173, -120 },
  { 0x0162, 0x016F, -120 },
  { 0x0162, 0x0077, -120 },
  { 0x0162, 0x0079, -120 },
  { 0x0162, 0x00FD, -120 },
  { 0x0162, 0x00FF, -60 },
  { 0x0055, 0x0041, -40 },
  { 0x0055, 0x00C1, -40 },
  { 0x0055, 0x0102, -40 },
  { 0x0055, 0x00C2, -40 },
  { 0x0055, 0x00C4, -40 },
  { 0x0055, 0x00C0, -40 },
  { 0x0055, 0x0100, -40 },
  { 0x0055, 0x0104, -40 },
  { 0x0055, 0x00C5, -40 },
  { 0x0055, 0x00C3, -40 },
  { 0x0055, 0x002C, -40 },
  { 0x0055, 0x002E, -40 },
  { 0x00DA, 0x0041, -40 },
  { 0x00DA, 0x00C1, -40 },
  { 0x00DA, 0x0102, -40 },
  { 0x00DA, 0x00C2, -40 },
  { 0x00DA, 0x00C4, -40 },
  { 0x00DA, 0x00C0, -40 },
  { 0x00DA, 0x0100, -40 },
  { 0x00DA, 0x0104, -40 },
  { 0x00DA, 0x00C5, -40 },
  { 0x00DA, 0x00C3, -40 },
  { 0x00DA, 0x002C, -40 },
  { 0x00DA, 0x002E, -40 },
  { 0x00DB, 0x0041, -40 },
  { 0x00DB, 0x00C1, -40 },
  { 0x00DB, 0x0102, -40 },
  { 0x00DB, 0x00C2, -40 },
  { 0x00DB, 0x00C4, -40 },
  { 0x00DB, 0x00C0, -40 },
  { 0x00DB, 0x0100, -40 },
  { 0x00DB, 0x0104, -40 },
  { 0x00DB, 0x00C5, -40 },
  { 0x00DB, 0x00C3, -40 },
  { 0x00DB, 0x002C, -40 },
  { 0x00DB, 0x002E, -40 },
  { 0x00DC, 0x0041, -40 },
  { 0x00DC, 0x00C1, -40 },
  { 0x00DC, 0x0102, -40 },
  { 0x00DC, 0x00C2, -40 },
  { 0x00DC, 0x00C4, -40 },
  { 0x00DC, 0x00C0, -40 },
  { 0x00DC, 0x0100, -40 },
  { 0x00DC, 0x0104, -40 },
  { 0x00DC, 0x00C5, -40 },
  { 0x00DC, 0x00C3, -40 },
  { 0x00DC, 0x002C, -40 },
  { 0x00DC, 0x002E, -40 },
  { 0x00D9, 0x0041, -40 },
  { 0x00D9, 0x00C1, -40 },
  { 0x00D9, 0x0102, -40 },
  { 0x00D9, 0x00C2, -40 },
  { 0x00D9, 0x00C4, -40 },
  { 0x00D9, 0x00C0, -40 },
  { 0x00D9, 0x0100, -40 },
  { 0x00D9, 0x0104, -40 },
  { 0x00D9, 0x00C5, -40 },
  { 0x00D9, 0x00C3, -40 },
  { 0x00D9, 0x002C, -40 },
  { 0x00D9, 0x002E, -40 },
  { 0x0170, 0x0041, -40 },
  { 0x0170, 0x00C1, -40 },
  { 0x0170, 0x0102, -40 },
  { 0x0170, 0x00C2, -40 },
  { 0x0170, 0x00C4, -40 },
  { 0x0170, 0x00C0, -40 },
  { 0x0170, 0x0100, -40 },
  { 0x0170, 0x0104, -40 },
  { 0x0170, 0x00C5, -40 },
  { 0x0170, 0x00C3, -40 },
  { 0x0170, 0x002C, -40 },
  { 0x0170, 0x002E, -40 },
  { 0x016A, 0x0041, -40 },
  { 0x016A, 0x00C1, -40 },
  { 0x016A, 0x0102, -40 },
  { 0x016A, 0x00C2, -40 },
  { 0x016A, 0x00C4, -40 },
  { 0x016A, 0x00C0, -40 },
  { 0x016A, 0x0100, -40 },
  { 0x016A, 0x0104, -40 },
  { 0x016A, 0x00C5, -40 },
  { 0x016A, 0x00C3, -40 },
  { 0x016A, 0x002C, -40 },
  { 0x016A, 0x002E, -40 },
  { 0x0172, 0x0041, -40 },
  { 0x0172, 0x00C1, -40 },
  { 0x0172, 0x0102, -40 },
  { 0x0172, 0x00C2, -40 },
  { 0x0172, 0x00C4, -40 },
  { 0x0172, 0x00C0, -40 },
  { 0x0172, 0x0100, -40 },
  { 0x0172, 0x0104, -40 },
  { 0x0172, 0x00C5, -40 },
  { 0x0172, 0x00C3, -40 },
  { 0x0172, 0x002C, -40 },
  { 0x0172, 0x002E, -40 },
  { 0x016E, 0x0041, -40 },
  { 0x016E, 0x00C1, -40 },
  { 0x016E, 0x0102, -40 },
  { 0x016E, 0x00C2, -40 },
  { 0x016E, 0x00C4, -40 },
  { 0x016E, 0x00C0, -40 },
  { 0x016E, 0x0100, -40 },
  { 0x016E, 0x0104, -40 },
  { 0x016E, 0x00C5, -40 },
  { 0x016E, 0x00C3, -40 },
  { 0x016E, 0x002C, -40 },
  { 0x016E, 0x002E, -40 },
  { 0x0056, 0x0041, -80 },
  { 0x0056, 0x00C1, -80 },
  { 0x0056, 0x0102, -80 },
  { 0x0056, 0x00C2, -80 },
  { 0x0056, 0x00C4, -80 },
  { 0x0056, 0x00C0, -80 },
  { 0x0056, 0x0100, -80 },
  { 0x0056, 0x0104, -80 },
  { 0x0056, 0x00C5, -80 },
  { 0x0056, 0x00C3, -80 },
  { 0x0056, 0x0047, -40 },
  { 0x0056, 0x011E, -40 },
  { 0x0056, 0x0122, -40 },
  { 0x0056, 0x004F, -40 },
  { 0x0056, 0x00D3, -40 },
  { 0x0056, 0x00D4, -40 },
  { 0x0056, 0x00D6, -40 },
  { 0x0056, 0x00D2, -40 },
  { 0x0056, 0x0150, -40 },
  { 0x0056, 0x014C, -40 },
  { 0x0056, 0x00D8, -40 },
  { 0x0056, 0x00D5, -40 },
  { 0x0056, 0x0061, -70 },
  { 0x0056, 0x00E1, -70 },
  { 0x0056, 0x0103, -70 },
  { 0x0056, 0x00E2, -70 },
  { 0x0056, 0x00E4, -70 },
  { 0x0056, 0x00E0, -70 },
  { 0x0056, 0x0101, -70 },
  { 0x0056, 0x0105, -70 },
  { 0x0056, 0x00E5, -70 },
  { 0x0056, 0x00E3, -70 },
  { 0x0056, 0x003A, -40 },
  { 0x0056, 0x002C, -125 },
  { 0x0056, 0x0065, -80 },
  { 0x0056, 0x00E9, -80 },
  { 0x0056, 0x011B, -80 },
  { 0x0056, 0x00EA, -80 },
  { 0x0056, 0x00EB, -80 },
  { 0x0056, 0x0117, -80 },
  { 0x0056, 0x00E8, -80 },
  { 0x0056, 0x0113, -80 },
  { 0x0056, 0x0119, -80 },
  { 0x0056, 0x002D, -80 },
  { 0x0056, 0x006F, -80 },
  { 0x0056, 0x00F3, -80 },
  { 0x0056, 0x00F4, -80 },
  { 0x0056, 0x00F6, -80 },
  { 0x0056, 0x00F2, -80 },
  { 0x0056, 0x0151, -80 },
  { 0x0056, 0x014D, -80 },
  { 0x0056, 0x00F8, -80 },
  { 0x0056, 0x00F5, -80 },
  { 0x0056, 0x002E, -125 },
  { 0x0056, 0x003B, -40 },
  { 0x0056, 0x0075, -70 },
  { 0x0056, 0x00FA, -70 },
  { 0x0056, 0x00FB, -70 },
  { 0x0056, 0x00FC, -70 },
  { 0x0056, 0x00F9, -70 },
  { 0x0056, 0x0171, -70 },
  { 0x0056, 0x016B, -70 },
  { 0x0056, 0x0173, -70 },
  { 0x0056, 0x016F, -70 },
  { 0x0057, 0x0041, -50 },
  { 0x0057, 0x00C1, -50 },
  { 0x0057, 0x0102, -50 },
  { 0x0057, 0x00C2, -50 },
  { 0x0057, 0x00C4, -50 },
  { 0x0057, 0x00C0, -50 },
  { 0x0057, 0x0100, -50 },
  { 0x0057, 0x0104, -50 },
  { 0x0057, 0x00C5, -50 },
  { 0x0057, 0x00C3, -50 },
  { 0x0057, 0x004F, -20 },
  { 0x0057, 0x00D3, -20 },
  { 0x0057, 0x00D4, -20 },
  { 0x0057, 0x00D6, -20 },
  { 0x0057, 0x00D2, -20 },
  { 0x0057, 0x0150, -20 },
  { 0x0057, 0x014C, -20 },
  { 0x0057, 0x00D8, -20 },
  { 0x0057, 0x00D5, -20 },
  { 0x0057, 0x0061, -40 },
  { 0x0057, 0x00E1, -40 },
  { 0x0057, 0x0103, -40 },
  { 0x0057, 0x00E2, -40 },
  { 0x0057, 0x00E4, -40 },
  { 0x0057, 0x00E0, -40 },
  { 0x0057, 0x0101, -40 },
  { 0x0057, 0x0105, -40 },
  { 0x0057, 0x00E5, -40 },
  { 0x0057, 0x00E3, -40 },
  { 0x0057, 0x002C, -80 },
  { 0x0057, 0x0065, -30 },
  { 0x0057, 0x00E9, -30 },
  { 0x0057, 0x011B, -30 },
  { 0x0057, 0x00EA, -30 },
  { 0x0057, 0x00EB, -30 },
  { 0x0057, 0x0117, -30 },
  { 0x0057, 0x00E8, -30 },
  { 0x0057, 0x0113, -30 },
  { 0x0057, 0x0119, -30 },
  { 0x0057, 0x002D, -40 },
  { 0x0057, 0x006F, -30 },
  { 0x0057, 0x00F3, -30 },
  { 0x0057, 0x00F4, -30 },
  { 0x0057, 0x00F6, -30 },
  { 0x0057, 0x00F2, -30 },
  { 0x0057, 0x0151, -30 },
  { 0x0057, 0x014D, -30 },
  { 0x0057, 0x00F8, -30 },
  { 0x0057, 0x00F5, -30 },
  { 0x0057, 0x002E, -80 },
  { 0x0057, 0x0075, -30 },
  { 0x0057, 0x00FA, -30 },
  { 0x0057, 0x00FB, -30 },
  { 0x0057, 0x00FC, -30 },
  { 0x0057, 0x00F9, -30 },
  { 0x0057, 0x0171, -30 },
  { 0x0057, 0x016B, -30 },
  { 0x0057, 0x0173, -30 },
  { 0x0057, 0x016F, -30 },
  { 0x0057, 0x0079, -20 },
  { 0x0057, 0x00FD, -20 },
  { 0x0057, 0x00FF, -20 },
  { 0x0059, 0x0041, -110 },
  { 0x0059, 0x00C1, -110 },
  { 0x0059, 0x0102, -110 },
  { 0x0059, 0x00C2, -110 },
  { 0x0059, 0x00C4, -110 },
  { 0x0059, 0x00C0, -110 },
  { 0x0059, 0x0100, -110 },
  { 0x0059, 0x0104, -110 },
  { 0x0059, 0x00C5, -110 },
  { 0x0059, 0x00C3, -110 },
  { 0x0059, 0x004F, -85 },
  { 0x0059, 0x00D3, -85 },
  { 0x0059, 0x00D4, -85 },
  { 0x0059, 0x00D6, -85 },
  { 0x0059, 0x00D2, -85 },
  { 0x0059, 0x0150, -85 },
  { 0x0059, 0x014C, -85 },
  { 0x0059, 0x00D8, -85 },
  { 0x0059, 0x00D5, -85 },
  { 0x0059, 0x0061, -140 },
  { 0x0059, 0x00E1, -140 },
  { 0x0059, 0x0103, -70 },
  { 0x0059, 0x00E2, -140 },
  { 0x0059, 0x00E4, -140 },
  { 0x0059, 0x00E0, -140 },
  { 0x0059, 0x0101, -70 },
  { 0x0059, 0x0105, -140 },
  { 0x0059, 0x00E5, -140 },
  { 0x0059, 0x00E3, -140 },
  { 0x0059, 0x003A, -60 },
  { 0x0059, 0x002C, -140 },
  { 0x0059, 0x0065, -140 },
  { 0x0059, 0x00E9, -140 },
  { 0x0059, 0x011B, -140 },
  { 0x0059, 0x00EA, -140 },
  { 0x0059, 0x00EB, -140 },
  { 0x0059, 0x0117, -140 },
  { 0x0059, 0x00E8, -140 },
  { 0x0059, 0x0113, -70 },
  { 0x0059, 0x0119, -140 },
  { 0x0059, 0x002D, -140 },
  { 0x0059, 0x0069, -20 },
  { 0x0059, 0x00ED, -20 },
  { 0x0059, 0x012F, -20 },
  { 0x0059, 0x006F, -140 },
  { 0x0059, 0x00F3, -140 },
  { 0x0059, 0x00F4, -140 },
  { 0x0059, 0x00F6, -140 },
  { 0x0059, 0x00F2, -140 },
  { 0x0059, 0x0151, -140 },
  { 0x0059, 0x014D, -140 },
  { 0x0059, 0x00F8, -140 },
  { 0x0059, 0x00F5, -140 },
  { 0x0059, 0x002E, -140 },
  { 0x0059, 0x003B, -60 },
  { 0x0059, 0x0075, -110 },
  { 0x0059, 0x00FA, -110 },
  { 0x0059, 0x00FB, -110 },
  { 0x0059, 0x00FC, -110 },
  { 0x0059, 0x00F9, -110 },
  { 0x0059, 0x0171, -110 },
  { 0x0059, 0x016B, -110 },
  { 0x0059, 0x0173, -110 },
  { 0x0059, 0x016F, -110 },
  { 0x00DD, 0x0041, -110 },
  { 0x00DD, 0x00C1, -110 },
  { 0x00DD, 0x0102, -110 },
  { 0x00DD, 0x00C2, -110 },
  { 0x00DD, 0x00C4, -110 },
  { 0x00DD, 0x00C0, -110 },
  { 0x00DD, 0x0100, -110 },
  { 0x00DD, 0x0104, -110 },
  { 0x00DD, 0x00C5, -110 },
  { 0x00DD, 0x00C3, -110 },
  { 0x00DD, 0x004F, -85 },
  { 0x00DD, 0x00D3, -85 },
  { 0x00DD, 0x00D4, -85 },
  { 0x00DD, 0x00D6, -85 },
  { 0x00DD, 0x00D2, -85 },
  { 0x00DD, 0x0150, -85 },
  { 0x00DD, 0x014C, -85 },
  { 0x00DD, 0x00D8, -85 },
  { 0x00DD, 0x00D5, -85 },
  { 0x00DD, 0x0061, -140 },
  { 0x00DD, 0x00E1, -140 },
  { 0x00DD, 0x0103, -70 },
  { 0x00DD, 0x00E2, -140 },
  { 0x00DD, 0x00E4, -140 },
  { 0x00DD, 0x00E0, -140 },
  { 0x00DD, 0x0101, -70 },
  { 0x00DD, 0x0105, -140 },
  { 0x00DD, 0x00E5, -140 },
  { 0x00DD, 0x00E3, -70 },
  { 0x00DD, 0x003A, -60 },
  { 0x00DD, 0x002C, -140 },
  { 0x00DD, 0x0065, -140 },
  { 0x00DD, 0x00E9, -140 },
  { 0x00DD, 0x011B, -140 },
  { 0x00DD, 0x00EA, -140 },
  { 0x00DD, 0x00EB, -140 },
  { 0x00DD, 0x0117, -140 },
  { 0x00DD, 0x00E8, -140 },
  { 0x00DD, 0x0113, -70 },
  { 0x00DD, 0x0119, -140 },
  { 0x00DD, 0x002D, -140 },
  { 0x00DD, 0x0069, -20 },
  { 0x00DD, 0x00ED, -20 },
  { 0x00DD, 0x012F, -20 },
  { 0x00DD, 0x006F, -140 },
  { 0x00DD, 0x00F3, -140 },
  { 0x00DD, 0x00F4, -140 },
  { 0x00DD, 0x00F6, -140 },
  { 0x00DD, 0x00F2, -140 },
  { 0x00DD, 0x0151, -140 },
  { 0x00DD, 0x014D, -70 },
  { 0x00DD, 0x00F8, -140 },
  { 0x00DD, 0x00F5, -140 },
  { 0x00DD, 0x002E, -140 },
  { 0x00DD, 0x003B, -60 },
  { 0x00DD, 0x0075, -110 },
  { 0x00DD, 0x00FA, -110 },
  { 0x00DD, 0x00FB, -110 },
  { 0x00DD, 0x00FC, -110 },
  { 0x00DD, 0x00F9, -110 },
  { 0x00DD, 0x0171, -110 },
  { 0x00DD, 0x016B, -110 },
  { 0x00DD, 0x0173, -110 },
  { 0x00DD, 0x016F, -110 },
  { 0x0178, 0x0041, -110 },
  { 0x0178, 0x00C1, -110 },
  { 0x0178, 0x0102, -110 },
  { 0x0178, 0x00C2, -110 },
  { 0x0178, 0x00C4, -110 },
  { 0x0178, 0x00C0, -110 },
  { 0x0178, 0x0100, -110 },
  { 0x0178, 0x0104, -110 },
  { 0x0178, 0x00C5, -110 },
  { 0x0178, 0x00C3, -110 },
  { 0x0178, 0x004F, -85 },
  { 0x0178, 0x00D3, -85 },
  { 0x0178, 0x00D4, -85 },
  { 0x0178, 0x00D6, -85 },
  { 0x0178, 0x00D2, -85 },
  { 0x0178, 0x0150, -85 },
  { 0x0178, 0x014C, -85 },
  { 0x0178, 0x00D8, -85 },
  { 0x0178, 0x00D5, -85 },
  { 0x0178, 0x0061, -140 },
  { 0x0178, 0x00E1, -140 },
  { 0x0178, 0x0103, -70 },
  { 0x0178, 0x00E2, -140 },
  { 0x0178, 0x00E4, -140 },
  { 0x0178, 0x00E0, -140 },
  { 0x0178, 0x0101, -70 },
  { 0x0178, 0x0105, -140 },
  { 0x0178, 0x00E5, -140 },
  { 0x0178, 0x00E3, -70 },
  { 0x0178, 0x003A, -60 },
  { 0x0178, 0x002C, -140 },
  { 0x0178, 0x0065, -140 },
  { 0x0178, 0x00E9, -140 },
  { 0x0178, 0x011B, -140 },
  { 0x0178, 0x00EA, -140 },
  { 0x0178, 0x00EB, -140 },
  { 0x0178, 0x0117, -140 },
  { 0x0178, 0x00E8, -140 },
  { 0x0178, 0x0113, -70 },
  { 0x0178, 0x0119, -140 },
  { 0x0178, 0x002D, -140 },
  { 0x0178, 0x0069, -20 },
  { 0x0178, 0x00ED, -20 },
  { 0x0178, 0x012F, -20 },
  { 0x0178, 0x006F, -140 },
  { 0x0178, 0x00F3, -140 },
  { 0x0178, 0x00F4, -140 },
  { 0x0178, 0x00F6, -140 },
  { 0x0178, 0x00F2, -140 },
  { 0x0178, 0x0151, -140 },
  { 0x0178, 0x014D, -140 },
  { 0x0178, 0x00F8, -140 },
  { 0x0178, 0x00F5, -140 },
  { 0x0178, 0x002E, -140 },
  { 0x0178, 0x003B, -60 },
  { 0x0178, 0x0075, -110 },
  { 0x0178, 0x00FA, -110 },
  { 0x0178, 0x00FB, -110 },
  { 0x0178, 0x00FC, -110 },
  { 0x0178, 0x00F9, -110 },
  { 0x0178, 0x0171, -110 },
  { 0x0178, 0x016B, -110 },
  { 0x0178, 0x0173, -110 },
  { 0x0178, 0x016F, -110 },
  { 0x0061, 0x0076, -20 },
  { 0x0061, 0x0077, -20 },
  { 0x0061, 0x0079, -30 },
  { 0x0061, 0x00FD, -30 },
  { 0x0061, 0x00FF, -30 },
  { 0x00E1, 0x0076, -20 },
  { 0x00E1, 0x0077, -20 },
  { 0x00E1, 0x0079, -30 },
  { 0x00E1, 0x00FD, -30 },
  { 0x00E1, 0x00FF, -30 },
  { 0x0103, 0x0076, -20 },
  { 0x0103, 0x0077, -20 },
  { 0x0103, 0x0079, -30 },
  { 0x0103, 0x00FD, -30 },
  { 0x0103, 0x00FF, -30 },
  { 0x00E2, 0x0076, -20 },
  { 0x00E2, 0x0077, -20 },
  { 0x00E2, 0x0079, -30 },
  { 0x00E2, 0x00FD, -30 },
  { 0x00E2, 0x00FF, -30 },
  { 0x00E4, 0x0076, -20 },
  { 0x00E4, 0x0077, -20 },
  { 0x00E4, 0x0079, -30 },
  { 0x00E4, 0x00FD, -30 },
  { 0x00E4, 0x00FF, -30 },
  { 0x00E0, 0x0076, -20 },
  { 0x00E0, 0x0077, -20 },
  { 0x00E0, 0x0079, -30 },
  { 0x00E0, 0x00FD, -30 },
  { 0x00E0, 0x00FF, -30 },
  { 0x0101, 0x0076, -20 },
  { 0x0101, 0x0077, -20 },
  { 0x0101, 0x0079, -30 },
  { 0x0101, 0x00FD, -30 },
  { 0x0101, 0x00FF, -30 },
  { 0x0105, 0x0076, -20 },
  { 0x0105, 0x0077, -20 },
  { 0x0105, 0x0079, -30 },
  { 0x0105, 0x00FD, -30 },
  { 0x0105, 0x00FF, -30 },
  { 0x00E5, 0x0076, -20 },
  { 0x00E5, 0x0077, -20 },
  { 0x00E5, 0x0079, -30 },
  { 0x00E5, 0x00FD, -30 },
  { 0x00E5, 0x00FF, -30 },
  { 0x00E3, 0x0076, -20 },
  { 0x00E3, 0x0077, -20 },
  { 0x00E3, 0x0079, -30 },
  { 0x00E3, 0x00FD, -30 },
  { 0x00E3, 0x00FF, -30 },
  { 0x0062, 0x0062, -10 },
  { 0x0062, 0x002C, -40 },
  { 0x0062, 0x006C, -20 },
  { 0x0062, 0x013A, -20 },
  { 0x0062, 0x013C, -20 },
  { 0x0062, 0x0142, -20 },
  { 0x0062, 0x002E, -40 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0062, 0x0076, -20 },
  { 0x0062, 0x0079, -20 },
  { 0x0062, 0x00FD, -20 },
  { 0x0062, 0x00FF, -20 },
  { 0x0063, 0x002C, -15 },
  { 0x0063, 0x006B, -20 },
  { 0x0063, 0x0137, -20 },
  { 0x0107, 0x002C, -15 },
  { 0x0107, 0x006B, -20 },
  { 0x0107, 0x0137, -20 },
  { 0x010D, 0x002C, -15 },
  { 0x010D, 0x006B, -20 },
  { 0x010D, 0x0137, -20 },
  { 0x00E7, 0x002C, -15 },
  { 0x00E7, 0x006B, -20 },
  { 0x00E7, 0x0137, -20 },
  { 0x003A, 0x0020, -50 },
  { 0x002C, 0x201D, -100 },
  { 0x002C, 0x2019, -100 },
  { 0x0065, 0x002C, -15 },
  { 0x0065, 0x002E, -15 },
  { 0x0065, 0x0076, -30 },
  { 0x0065, 0x0077, -20 },
  { 0x0065, 0x0078, -30 },
  { 0x0065, 0x0079, -20 },
  { 0x0065, 0x00FD, -20 },
  { 0x0065, 0x00FF, -20 },
  { 0x00E9, 0x002C, -15 },
  { 0x00E9, 0x002E, -15 },
  { 0x00E9, 0x0076, -30 },
  { 0x00E9, 0x0077, -20 },
  { 0x00E9, 0x0078, -30 },
  { 0x00E9, 0x0079, -20 },
  { 0x00E9, 0x00FD, -20 },
  { 0x00E9, 0x00FF, -20 },
  { 0x011B, 0x002C, -15 },
  { 0x011B, 0x002E, -15 },
  { 0x011B, 0x0076, -30 },
  { 0x011B, 0x0077, -20 },
  { 0x011B, 0x0078, -30 },
  { 0x011B, 0x0079, -20 },
  { 0x011B, 0x00FD, -20 },
  { 0x011B, 0x00FF, -20 },
  { 0x00EA, 0x002C, -15 },
  { 0x00EA, 0x002E, -15 },
  { 0x00EA, 0x0076, -30 },
  { 0x00EA, 0x0077, -20 },
  { 0x00EA, 0x0078, -30 },
  { 0x00EA, 0x0079, -20 },
  { 0x00EA, 0x00FD, -20 },
  { 0x00EA, 0x00FF, -20 },
  { 0x00EB, 0x002C, -15 },
  { 0x00EB, 0x002E, -15 },
  { 0x00EB, 0x0076, -30 },
  { 0x00EB, 0x0077, -20 },
  { 0x00EB, 0x0078, -30 },
  { 0x00EB, 0x0079, -20 },
  { 0x00EB, 0x00FD, -20 },
  { 0x00EB, 0x00FF, -20 },
  { 0x0117, 0x002C, -15 },
  { 0x0117, 0x002E, -15 },
  { 0x0117, 0x0076, -30 },
  { 0x0117, 0x0077, -20 },
  { 0x0117, 0x0078, -30 },
  { 0x0117, 0x0079, -20 },
  { 0x0117, 0x00FD, -20 },
  { 0x0117, 0x00FF, -20 },
  { 0x00E8, 0x002C, -15 },
  { 0x00E8, 0x002E, -15 },
  { 0x00E8, 0x0076, -30 },
  { 0x00E8, 0x0077, -20 },
  { 0x00E8, 0x0078, -30 },
  { 0x00E8, 0x0079, -20 },
  { 0x00E8, 0x00FD, -20 },
  { 0x00E8, 0x00FF, -20 },
  { 0x0113, 0x002C, -15 },
  { 0x0113, 0x002E, -15 },
  { 0x0113, 0x0076, -30 },
  { 0x0113, 0x0077, -20 },
  { 0x0113, 0x0078, -30 },
  { 0x0113, 0x0079, -20 },
  { 0x0113, 0x00FD, -20 },
  { 0x0113, 0x00FF, -20 },
  { 0x0119, 0x002C, -15 },
  { 0x0119, 0x002E, -15 },
  { 0x0119, 0x0076, -30 },
  { 0x0119, 0x0077, -20 },
  { 0x0119, 0x0078, -30 },
  { 0x0119, 0x0079, -20 },
  { 0x0119, 0x00FD, -20 },
  { 0x0119, 0x00FF, -20 },
  { 0x0066, 0x0061, -30 },
  { 0x0066, 0x00E1, -30 },
  { 0x0066, 0x0103, -30 },
  { 0x0066, 0x00E2, -30 },
  { 0x0066, 0x00E4, -30 },
  { 0x0066, 0x00E0, -30 },
  { 0x0066, 0x0101, -30 },
  { 0x0066, 0x0105, -30 },
  { 0x0066, 0x00E5, -30 },
  { 0x0066, 0x00E3, -30 },
  { 0x0066, 0x002C, -30 },
  { 0x0066, 0x0131, -28 },
  { 0x0066, 0x0065, -30 },
  { 0x0066, 0x00E9, -30 },
  { 0x0066, 0x011B, -30 },
  { 0x0066, 0x00EA, -30 },
  { 0x0066, 0x00EB, -30 },
  { 0x0066, 0x0117, -30 },
  { 0x0066, 0x00E8, -30 },
  { 0x0066, 0x0113, -30 },
  { 0x0066, 0x0119, -30 },
  { 0x0066, 0x006F, -30 },
  { 0x0066, 0x00F3, -30 },
  { 0x0066, 0x00F4, -30 },
  { 0x0066, 0x00F6, -30 },
  { 0x0066, 0x00F2, -30 },
  { 0x0066, 0x0151, -30 },
  { 0x0066, 0x014D, -30 },
  { 0x0066, 0x00F8, -30 },
  { 0x0066, 0x00F5, -30 },
  { 0x0066, 0x002E, -30 },
  { 0x0066, 0x201D, 60 },
  { 0x0066, 0x2019, 50 },
  { 0x0067, 0x0072, -10 },
  { 0x0067, 0x0155, -10 },
  { 0x0067, 0x0159, -10 },
  { 0x0067, 0x0157, -10 },
  { 0x011F, 0x0072, -10 },
  { 0x011F, 0x0155, -10 },
  { 0x011F, 0x0159, -10 },
  { 0x011F, 0x0157, -10 },
  { 0x0123, 0x0072, -10 },
  { 0x0123, 0x0155, -10 },
  { 0x0123, 0x0159, -10 },
  { 0x0123, 0x0157, -10 },
  { 0x0068, 0x0079, -30 },
  { 0x0068, 0x00FD, -30 },
  { 0x0068, 0x00FF, -30 },
  { 0x006B, 0x0065, -20 },
  { 0x006B, 0x00E9, -20 },
  { 0x006B, 0x011B, -20 },
  { 0x006B, 0x00EA, -20 },
  { 0x006B, 0x00EB, -20 },
  { 0x006B, 0x0117, -20 },
  { 0x006B, 0x00E8, -20 },
  { 0x006B, 0x0113, -20 },
  { 0x006B, 0x0119, -20 },
  { 0x006B, 0x006F, -20 },
  { 0x006B, 0x00F3, -20 },
  { 0x006B, 0x00F4, -20 },
  { 0x006B, 0x00F6, -20 },
  { 0x006B, 0x00F2, -20 },
  { 0x006B, 0x0151, -20 },
  { 0x006B, 0x014D, -20 },
  { 0x006B, 0x00F8, -20 },
  { 0x006B, 0x00F5, -20 },
  { 0x0137, 0x0065, -20 },
  { 0x0137, 0x00E9, -20 },
  { 0x0137, 0x011B, -20 },
  { 0x0137, 0x00EA, -20 },
  { 0x0137, 0x00EB, -20 },
  { 0x0137, 0x0117, -20 },
  { 0x0137, 0x00E8, -20 },
  { 0x0137, 0x0113, -20 },
  { 0x0137, 0x0119, -20 },
  { 0x0137, 0x006F, -20 },
  { 0x0137, 0x00F3, -20 },
  { 0x0137, 0x00F4, -20 },
  { 0x0137, 0x00F6, -20 },
  { 0x0137, 0x00F2, -20 },
  { 0x0137, 0x0151, -20 },
  { 0x0137, 0x014D, -20 },
  { 0x0137, 0x00F8, -20 },
  { 0x0137, 0x00F5, -20 },
  { 0x006D, 0x0075, -10 },
  { 0x006D, 0x00FA, -10 },
  { 0x006D, 0x00FB, -10 },
  { 0x006D, 0x00FC, -10 },
  { 0x006D, 0x00F9, -10 },
  { 0x006D, 0x0171, -10 },
  { 0x006D, 0x016B, -10 },
  { 0x006D, 0x0173, -10 },
  { 0x006D, 0x016F, -10 },
  { 0x006D, 0x0079, -15 },
  { 0x006D, 0x00FD, -15 },
  { 0x006D, 0x00FF, -15 },
  { 0x006E, 0x0075, -10 },
  { 0x006E, 0x00FA, -10 },
  { 0x006E, 0x00FB, -10 },
  { 0x006E, 0x00FC, -10 },
  { 0x006E, 0x00F9, -10 },
  { 0x006E, 0x0171, -10 },
  { 0x006E, 0x016B, -10 },
  { 0x006E, 0x0173, -10 },
  { 0x006E, 0x016F, -10 },
  { 0x006E, 0x0076, -20 },
  { 0x006E, 0x0079, -15 },
  { 0x006E, 0x00FD, -15 },
  { 0x006E, 0x00FF, -15 },
  { 0x0144, 0x0075, -10 },
  { 0x0144, 0x00FA, -10 },
  { 0x0144, 0x00FB, -10 },
  { 0x0144, 0x00FC, -10 },
  { 0x0144, 0x00F9, -10 },
  { 0x0144, 0x0171, -10 },
  { 0x0144, 0x016B, -10 },
  { 0x0144, 0x0173, -10 },
  { 0x0144, 0x016F, -10 },
  { 0x0144, 0x0076, -20 },
  { 0x0144, 0x0079, -15 },
  { 0x0144, 0x00FD, -15 },
  { 0x0144, 0x00FF, -15 },
  { 0x0148, 0x0075, -10 },
  { 0x0148, 0x00FA, -10 },
  { 0x0148, 0x00FB, -10 },
  { 0x0148, 0x00FC, -10 },
  { 0x0148, 0x00F9, -10 },
  { 0x0148, 0x0171, -10 },
  { 0x0148, 0x016B, -10 },
  { 0x0148, 0x0173, -10 },
  { 0x0148, 0x016F, -10 },
  { 0x0148, 0x0076, -20 },
  { 0x0148, 0x0079, -15 },
  { 0x0148, 0x00FD, -15 },
  { 0x0148, 0x00FF, -15 },
  { 0x0146, 0x0075, -10 },
  { 0x0146, 0x00FA, -10 },
  { 0x0146, 0x00FB, -10 },
  { 0x0146, 0x00FC, -10 },
  { 0x0146, 0x00F9, -10 },
  { 0x0146, 0x0171, -10 },
  { 0x0146, 0x016B, -10 },
  { 0x0146, 0x0173, -10 },
  { 0x0146, 0x016F, -10 },
  { 0x0146, 0x0076, -20 },
  { 0x0146, 0x0079, -15 },
  { 0x0146, 0x00FD, -15 },
  { 0x0146, 0x00FF, -15 },
  { 0x00F1, 0x0075, -10 },
  { 0x00F1, 0x00FA, -10 },
  { 0x00F1, 0x00FB, -10 },
  { 0x00F1, 0x00FC, -10 },
  { 0x00F1, 0x00F9, -10 },
  { 0x00F1, 0x0171, -10 },
  { 0x00F1, 0x016B, -10 },
  { 0x00F1, 0x0173, -10 },
  { 0x00F1, 0x016F, -10 },
  { 0x00F1, 0x0076, -20 },
  { 0x00F1, 0x0079, -15 },
  { 0x00F1, 0x00FD, -15 },
  { 0x00F1, 0x00FF, -15 },
  { 0x006F, 0x002C, -40 },
  { 0x006F, 0x002E, -40 },
  { 0x006F, 0x0076, -15 },
  { 0x006F, 0x0077, -15 },
  { 0x006F, 0x0078, -30 },
  { 0x006F, 0x0079, -30 },
  { 0x006F, 0x00FD, -30 },
  { 0x006F, 0x00FF, -30 },
  { 0x00F3, 0x002C, -40 },
  { 0x00F3, 0x002E, -40 },
  { 0x00F3, 0x0076, -15 },
  { 0x00F3, 0x0077, -15 },
  { 0x00F3, 0x0078, -30 },
  { 0x00F3, 0x0079, -30 },
  { 0x00F3, 0x00FD, -30 },
  { 0x00F3, 0x00FF, -30 },
  { 0x00F4, 0x002C, -40 },
  { 0x00F4, 0x002E, -40 },
  { 0x00F4, 0x0076, -15 },
  { 0x00F4, 0x0077, -15 },
  { 0x00F4, 0x0078, -30 },
  { 0x00F4, 0x0079, -30 },
  { 0x00F4, 0x00FD, -30 },
  { 0x00F4, 0x00FF, -30 },
  { 0x00F6, 0x002C, -40 },
  { 0x00F6, 0x002E, -40 },
  { 0x00F6, 0x0076, -15 },
  { 0x00F6, 0x0077, -15 },
  { 0x00F6, 0x0078, -30 },
  { 0x00F6, 0x0079, -30 },
  { 0x00F6, 0x00FD, -30 },
  { 0x00F6, 0x00FF, -30 },
  { 0x00F2, 0x002C, -40 },
  { 0x00F2, 0x002E, -40 },
  { 0x00F2, 0x0076, -15 },
  { 0x00F2, 0x0077, -15 },
  { 0x00F2, 0x0078, -30 },
  { 0x00F2, 0x0079, -30 },
  { 0x00F2, 0x00FD, -30 },
  { 0x00F2, 0x00FF, -30 },
  { 0x0151, 0x002C, -40 },
  { 0x0151, 0x002E, -40 },
  { 0x0151, 0x0076, -15 },
  { 0x0151, 0x0077, -15 },
  { 0x0151, 0x0078, -30 },
  { 0x0151, 0x0079, -30 },
  { 0x0151, 0x00FD, -30 },
  { 0x0151, 0x00FF, -30 },
  { 0x014D, 0x002C, -40 },
  { 0x014D, 0x002E, -40 },
  { 0x014D, 0x0076, -15 },
  { 0x014D, 0x0077, -15 },
  { 0x014D, 0x0078, -30 },
  { 0x014D, 0x0079, -30 },
  { 0x014D, 0x00FD, -30 },
  { 0x014D, 0x00FF, -30 },
  { 0x00F8, 0x0061, -55 },
  { 0x00F8, 0x00E1, -55 },
  { 0x00F8, 0x0103, -55 },
  { 0x00F8, 0x00E2, -55 },
  { 0x00F8, 0x00E4, -55 },
  { 0x00F8, 0x00E0, -55 },
  { 0x00F8, 0x0101, -55 },
  { 0x00F8, 0x0105, -55 },
  { 0x00F8, 0x00E5, -55 },
  { 0x00F8, 0x00E3, -55 },
  { 0x00F8, 0x0062, -55 },
  { 0x00F8, 0x0063, -55 },
  { 0x00F8, 0x0107, -55 },
  { 0x00F8, 0x010D, -55 },
  { 0x00F8, 0x00E7, -55 },
  { 0x00F8, 0x002C, -95 },
  { 0x00F8, 0x0064, -55 },
  { 0x00F8, 0x0111, -55 },
  { 0x00F8, 0x0065, -55 },
  { 0x00F8, 0x00E9, -55 },
  { 0x00F8, 0x011B, -55 },
  { 0x00F8, 0x00EA, -55 },
  { 0x00F8, 0x00EB, -55 },
  { 0x00F8, 0x0117, -55 },
  { 0x00F8, 0x00E8, -55 },
  { 0x00F8, 0x0113, -55 },
  { 0x00F8, 0x0119, -55 },
  { 0x00F8, 0x0066, -55 },
  { 0x00F8, 0x0067, -55 },
  { 0x00F8, 0x011F, -55 },
  { 0x00F8, 0x0123, -55 },
  { 0x00F8, 0x0068, -55 },
  { 0x00F8, 0x0069, -55 },
  { 0x00F8, 0x00ED, -55 },
  { 0x00F8, 0x00EE, -55 },
  { 0x00F8, 0x00EF, -55 },
  { 0x00F8, 0x00EC, -55 },
  { 0x00F8, 0x012B, -55 },
  { 0x00F8, 0x012F, -55 },
  { 0x00F8, 0x006A, -55 },
  { 0x00F8, 0x006B, -55 },
  { 0x00F8, 0x0137, -55 },
  { 0x00F8, 0x006C, -55 },
  { 0x00F8, 0x013A, -55 },
  { 0x00F8, 0x013C, -55 },
  { 0x00F8, 0x0142, -55 },
  { 0x00F8, 0x006D, -55 },
  { 0x00F8, 0x006E, -55 },
  { 0x00F8, 0x0144, -55 },
  { 0x00F8, 0x0148, -55 },
  { 0x00F8, 0x0146, -55 },
  { 0x00F8, 0x00F1, -55 },
  { 0x00F8, 0x006F, -55 },
  { 0x00F8, 0x00F3, -55 },
  { 0x00F8, 0x00F4, -55 },
  { 0x00F8, 0x00F6, -55 },
  { 0x00F8, 0x00F2, -55 },
  { 0x00F8, 0x0151, -55 },
  { 0x00F8, 0x014D, -55 },
  { 0x00F8, 0x00F8, -55 },
  { 0x00F8, 0x00F5, -55 },
  { 0x00F8, 0x0070, -55 },
  { 0x00F8, 0x002E, -95 },
  { 0x00F8, 0x0071, -55 },
  { 0x00F8, 0x0072, -55 },
  { 0x00F8, 0x0155, -55 },
  { 0x00F8, 0x0159, -55 },
  { 0x00F8, 0x0157, -55 },
  { 0x00F8, 0x0073, -55 },
  { 0x00F8, 0x015B, -55 },
  { 0x00F8, 0x0161, -55 },
  { 0x00F8, 0x015F, -55 },
  { 0x00F8, 0x0219, -55 },
  { 0x00F8, 0x0074, -55 },
  { 0x00F8, 0x0163, -55 },
  { 0x00F8, 0x0075, -55 },
  { 0x00F8, 0x00FA, -55 },
  { 0x00F8, 0x00FB, -55 },
  { 0x00F8, 0x00FC, -55 },
  { 0x00F8, 0x00F9, -55 },
  { 0x00F8, 0x0171, -55 },
  { 0x00F8, 0x016B, -55 },
  { 0x00F8, 0x0173, -55 },
  { 0x00F8, 0x016F, -55 },
  { 0x00F8, 0x0076, -70 },
  { 0x00F8, 0x0077, -70 },
  { 0x00F8, 0x0078, -85 },
  { 0x00F8, 0x0079, -70 },
  { 0x00F8, 0x00FD, -70 },
  { 0x00F8, 0x00FF, -70 },
  { 0x00F8, 0x007A, -55 },
  { 0x00F8, 0x017A, -55 },
  { 0x00F8, 0x017E, -55 },
  { 0x00F8, 0x017C, -55 },
  { 0x00F5, 0x002C, -40 },
  { 0x00F5, 0x002E, -40 },
  { 0x00F5, 0x0076, -15 },
  { 0x00F5, 0x0077, -15 },
  { 0x00F5, 0x0078, -30 },
  { 0x00F5, 0x0079, -30 },
  { 0x00F5, 0x00FD, -30 },
  { 0x00F5, 0x00FF, -30 },
  { 0x0070, 0x002C, -35 },
  { 0x0070, 0x002E, -35 },
  { 0x0070, 0x0079, -30 },
  { 0x0070, 0x00FD, -30 },
  { 0x0070, 0x00FF, -30 },
  { 0x002E, 0x201D, -100 },
  { 0x002E, 0x2019, -100 },
  { 0x002E, 0x0020, -60 },
  { 0x201D, 0x0020, -40 },
  { 0x2018, 0x2018, -57 },
  { 0x2019, 0x0064, -50 },
  { 0x2019, 0x0111, -50 },
  { 0x2019, 0x2019, -57 },
  { 0x2019, 0x0072, -50 },
  { 0x2019, 0x0155, -50 },
  { 0x2019, 0x0159, -50 },
  { 0x2019, 0x0157, -50 },
  { 0x2019, 0x0073, -50 },
  { 0x2019, 0x015B, -50 },
  { 0x2019, 0x0161, -50 },
  { 0x2019, 0x015F, -50 },
  { 0x2019, 0x0219, -50 },
  { 0x2019, 0x0020, -70 },
  { 0x0072, 0x0061, -10 },
  { 0x0072, 0x00E1, -10 },
  { 0x0072, 0x0103, -10 },
  { 0x0072, 0x00E2, -10 },
  { 0x0072, 0x00E4, -10 },
  { 0x0072, 0x00E0, -10 },
  { 0x0072, 0x0101, -10 },
  { 0x0072, 0x0105, -10 },
  { 0x0072, 0x00E5, -10 },
  { 0x0072, 0x00E3, -10 },
  { 0x0072, 0x003A, 30 },
  { 0x0072, 0x002C, -50 },
  { 0x0072, 0x0069, 15 },
  { 0x0072, 0x00ED, 15 },
  { 0x0072, 0x00EE, 15 },
  { 0x0072, 0x00EF, 15 },
  { 0x0072, 0x00EC, 15 },
  { 0x0072, 0x012B, 15 },
  { 0x0072, 0x012F, 15 },
  { 0x0072, 0x006B, 15 },
  { 0x0072, 0x0137, 15 },
  { 0x0072, 0x006C, 15 },
  { 0x0072, 0x013A, 15 },
  { 0x0072, 0x013C, 15 },
  { 0x0072, 0x0142, 15 },
  { 0x0072, 0x006D, 25 },
  { 0x0072, 0x006E, 25 },
  { 0x0072, 0x0144, 25 },
  { 0x0072, 0x0148, 25 },
  { 0x0072, 0x0146, 25 },
  { 0x0072, 0x00F1, 25 },
  { 0x0072, 0x0070, 30 },
  { 0x0072, 0x002E, -50 },
  { 0x0072, 0x003B, 30 },
  { 0x0072, 0x0074, 40 },
  { 0x0072, 0x0163, 40 },
  { 0x0072, 0x0075, 15 },
  { 0x0072, 0x00FA, 15 },
  { 0x0072, 0x00FB, 15 },
  { 0x0072, 0x00FC, 15 },
  { 0x0072, 0x00F9, 15 },
  { 0x0072, 0x0171, 15 },
  { 0x0072, 0x016B, 15 },
  { 0x0072, 0x0173, 15 },
  { 0x0072, 0x016F, 15 },
  { 0x0072, 0x0076, 30 },
  { 0x0072, 0x0079, 30 },
  { 0x0072, 0x00FD, 30 },
  { 0x0072, 0x00FF, 30 },
  { 0x0155, 0x0061, -10 },
  { 0x0155, 0x00E1, -10 },
  { 0x0155, 0x0103, -10 },
  { 0x0155, 0x00E2, -10 },
  { 0x0155, 0x00E4, -10 },
  { 0x0155, 0x00E0, -10 },
  { 0x0155, 0x0101, -10 },
  { 0x0155, 0x0105, -10 },
  { 0x0155, 0x00E5, -10 },
  { 0x0155, 0x00E3, -10 },
  { 0x0155, 0x003A, 30 },
  { 0x0155, 0x002C, -50 },
  { 0x0155, 0x0069, 15 },
  { 0x0155, 0x00ED, 15 },
  { 0x0155, 0x00EE, 15 },
  { 0x0155, 0x00EF, 15 },
  { 0x0155, 0x00EC, 15 },
  { 0x0155, 0x012B, 15 },
  { 0x0155, 0x012F, 15 },
  { 0x0155, 0x006B, 15 },
  { 0x0155, 0x0137, 15 },
  { 0x0155, 0x006C, 15 },
  { 0x0155, 0x013A, 15 },
  { 0x0155, 0x013C, 15 },
  { 0x0155, 0x0142, 15 },
  { 0x0155, 0x006D, 25 },
  { 0x0155, 0x006E, 25 },
  { 0x0155, 0x0144, 25 },
  { 0x0155, 0x0148, 25 },
  { 0x0155, 0x0146, 25 },
  { 0x0155, 0x00F1, 25 },
  { 0x0155, 0x0070, 30 },
  { 0x0155, 0x002E, -50 },
  { 0x0155, 0x003B, 30 },
  { 0x0155, 0x0074, 40 },
  { 0x0155, 0x0163, 40 },
  { 0x0155, 0x0075, 15 },
  { 0x0155, 0x00FA, 15 },
  { 0x0155, 0x00FB, 15 },
  { 0x0155, 0x00FC, 15 },
  { 0x0155, 0x00F9, 15 },
  { 0x0155, 0x0171, 15 },
  { 0x0155, 0x016B, 15 },
  { 0x0155, 0x0173, 15 },
  { 0x0155, 0x016F, 15 },
  { 0x0155, 0x0076, 30 },
  { 0x0155, 0x0079, 30 },
  { 0x0155, 0x00FD, 30 },
  { 0x0155, 0x00FF, 30 },
  { 0x0159, 0x0061, -10 },
  { 0x0159, 0x00E1, -10 },
  { 0x0159, 0x0103, -10 },
  { 0x0159, 0x00E2, -10 },
  { 0x0159, 0x00E4, -10 },
  { 0x0159, 0x00E0, -10 },
  { 0x0159, 0x0101, -10 },
  { 0x0159, 0x0105, -10 },
  { 0x0159, 0x00E5, -10 },
  { 0x0159, 0x00E3, -10 },
  { 0x0159, 0x003A, 30 },
  { 0x0159, 0x002C, -50 },
  { 0x0159, 0x0069, 15 },
  { 0x0159, 0x00ED, 15 },
  { 0x0159, 0x00EE, 15 },
  { 0x0159, 0x00EF, 15 },
  { 0x0159, 0x00EC, 15 },
  { 0x0159, 0x012B, 15 },
  { 0x0159, 0x012F, 15 },
  { 0x0159, 0x006B, 15 },
  { 0x0159, 0x0137, 15 },
  { 0x0159, 0x006C, 15 },
  { 0x0159, 0x013A, 15 },
  { 0x0159, 0x013C, 15 },
  { 0x0159, 0x0142, 15 },
  { 0x0159, 0x006D, 25 },
  { 0x0159, 0x006E, 25 },
  { 0x0159, 0x0144, 25 },
  { 0x0159, 0x0148, 25 },
  { 0x0159, 0x0146, 25 },
  { 0x0159, 0x00F1, 25 },
  { 0x0159, 0x0070, 30 },
  { 0x0159, 0x002E, -50 },
  { 0x0159, 0x003B, 30 },
  { 0x0159, 0x0074, 40 },
  { 0x0159, 0x0163, 40 },
  { 0x0159, 0x0075, 15 },
  { 0x0159, 0x00FA, 15 },
  { 0x0159, 0x00FB, 15 },
  { 0x0159, 0x00FC, 15 },
  { 0x0159, 0x00F9, 15 },
  { 0x0159, 0x0171, 15 },
  { 0x0159, 0x016B, 15 },
  { 0x0159, 0x0173, 15 },
  { 0x0159, 0x016F, 15 },
  { 0x0159, 0x0076, 30 },
  { 0x0159, 0x0079, 30 },
  { 0x0159, 0x00FD, 30 },
  { 0x0159, 0x00FF, 30 },
  { 0x0157, 0x0061, -10 },
  { 0x0157, 0x00E1, -10 },
  { 0x0157, 0x0103, -10 },
  { 0x0157, 0x00E2, -10 },
  { 0x0157, 0x00E4, -10 },
  { 0x0157, 0x00E0, -10 },
  { 0x0157, 0x0101, -10 },
  { 0x0157, 0x0105, -10 },
  { 0x0157, 0x00E5, -10 },
  { 0x0157, 0x00E3, -10 },
  { 0x0157, 0x003A, 30 },
  { 0x0157, 0x002C, -50 },
  { 0x0157, 0x0069, 15 },
  { 0x0157, 0x00ED, 15 },
  { 0x0157, 0x00EE, 15 },
  { 0x0157, 0x00EF, 15 },
  { 0x0157, 0x00EC, 15 },
  { 0x0157, 0x012B, 15 },
  { 0x0157, 0x012F, 15 },
  { 0x0157, 0x006B, 15 },
  { 0x0157, 0x0137, 15 },
  { 0x0157, 0x006C, 15 },
  { 0x0157, 0x013A, 15 },
  { 0x0157, 0x013C, 15 },
  { 0x0157, 0x0142, 15 },
  { 0x0157, 0x006D, 25 },
  { 0x0157, 0x006E, 25 },
  { 0x0157, 0x0144, 25 },
  { 0x0157, 0x0148, 25 },
  { 0x0157, 0x0146, 25 },
  { 0x0157, 0x00F1, 25 },
  { 0x0157, 0x0070, 30 },
  { 0x0157, 0x002E, -50 },
  { 0x0157, 0x003B, 30 },
  { 0x0157, 0x0074, 40 },
  { 0x0157, 0x0163, 40 },
  { 0x0157, 0x0075, 15 },
  { 0x0157, 0x00FA, 15 },
  { 0x0157, 0x00FB, 15 },
  { 0x0157, 0x00FC, 15 },
  { 0x0157, 0x00F9, 15 },
  { 0x0157, 0x0171, 15 },
  { 0x0157, 0x016B, 15 },
  { 0x0157, 0x0173, 15 },
  { 0x0157, 0x016F, 15 },
  { 0x0157, 0x0076, 30 },
  { 0x0157, 0x0079, 30 },
  { 0x0157, 0x00FD, 30 },
  { 0x0157, 0x00FF, 30 },
  { 0x0073, 0x002C, -15 },
  { 0x0073, 0x002E, -15 },
  { 0x0073, 0x0077, -30 },
  { 0x015B, 0x002C, -15 },
  { 0x015B, 0x002E, -15 },
  { 0x015B, 0x0077, -30 },
  { 0x0161, 0x002C, -15 },
  { 0x0161, 0x002E, -15 },
  { 0x0161, 0x0077, -30 },
  { 0x015F, 0x002C, -15 },
  { 0x015F, 0x002E, -15 },
  { 0x015F, 0x0077, -30 },
  { 0x0219, 0x002C, -15 },
  { 0x0219, 0x002E, -15 },
  { 0x0219, 0x0077, -30 },
  { 0x003B, 0x0020, -50 },
  { 0x0020, 0x0054, -50 },
  { 0x0020, 0x0164, -50 },
  { 0x0020, 0x0162, -50 },
  { 0x0020, 0x0056, -50 },
  { 0x0020, 0x0057, -40 },
  { 0x0020, 0x0059, -90 },
  { 0x0020, 0x00DD, -90 },
  { 0x0020, 0x0178, -90 },
  { 0x0020, 0x201C, -30 },
  { 0x0020, 0x2018, -60 },
  { 0x0076, 0x0061, -25 },
  { 0x0076, 0x00E1, -25 },
  { 0x0076, 0x0103, -25 },
  { 0x0076, 0x00E2, -25 },
  { 0x0076, 0x00E4, -25 },
  { 0x0076, 0x00E0, -25 },
  { 0x0076, 0x0101, -25 },
  { 0x0076, 0x0105, -25 },
  { 0x0076, 0x00E5, -25 },
  { 0x0076, 0x00E3, -25 },
  { 0x0076, 0x002C, -80 },
  { 0x0076, 0x0065, -25 },
  { 0x0076, 0x00E9, -25 },
  { 0x0076, 0x011B, -25 },
  { 0x0076, 0x00EA, -25 },
  { 0x0076, 0x00EB, -25 },
  { 0x0076, 0x0117, -25 },
  { 0x0076, 0x00E8, -25 },
  { 0x0076, 0x0113, -25 },
  { 0x0076, 0x0119, -25 },
  { 0x0076, 0x006F, -25 },
  { 0x0076, 0x00F3, -25 },
  { 0x0076, 0x00F4, -25 },
  { 0x0076, 0x00F6, -25 },
  { 0x0076, 0x00F2, -25 },
  { 0x0076, 0x0151, -25 },
  { 0x0076, 0x014D, -25 },
  { 0x0076, 0x00F8, -25 },
  { 0x0076, 0x00F5, -25 },
  { 0x0076, 0x002E, -80 },
  { 0x0077, 0x0061, -15 },
  { 0x0077, 0x00E1, -15 },
  { 0x0077, 0x0103, -15 },
  { 0x0077, 0x00E2, -15 },
  { 0x0077, 0x00E4, -15 },
  { 0x0077, 0x00E0, -15 },
  { 0x0077, 0x0101, -15 },
  { 0x0077, 0x0105, -15 },
  { 0x0077, 0x00E5, -15 },
  { 0x0077, 0x00E3, -15 },
  { 0x0077, 0x002C, -60 },
  { 0x0077, 0x0065, -10 },
  { 0x0077, 0x00E9, -10 },
  { 0x0077, 0x011B, -10 },
  { 0x0077, 0x00EA, -10 },
  { 0x0077, 0x00EB, -10 },
  { 0x0077, 0x0117, -10 },
  { 0x0077, 0x00E8, -10 },
  { 0x0077, 0x0113, -10 },
  { 0x0077, 0x0119, -10 },
  { 0x0077, 0x006F, -10 },
  { 0x0077, 0x00F3, -10 },
  { 0x0077, 0x00F4, -10 },
  { 0x0077, 0x00F6, -10 },
  { 0x0077, 0x00F2, -10 },
  { 0x0077, 0x0151, -10 },
  { 0x0077, 0x014D, -10 },
  { 0x0077, 0x00F8, -10 },
  { 0x0077, 0x00F5, -10 },
  { 0x0077, 0x002E, -60 },
  { 0x0078, 0x0065, -30 },
  { 0x0078, 0x00E9, -30 },
  { 0x0078, 0x011B, -30 },
  { 0x0078, 0x00EA, -30 },
  { 0x0078, 0x00EB, -30 },
  { 0x0078, 0x0117, -30 },
  { 0x0078, 0x00E8, -30 },
  { 0x0078, 0x0113, -30 },
  { 0x0078, 0x0119, -30 },
  { 0x0079, 0x0061, -20 },
  { 0x0079, 0x00E1, -20 },
  { 0x0079, 0x0103, -20 },
  { 0x0079, 0x00E2, -20 },
  { 0x0079, 0x00E4, -20 },
  { 0x0079, 0x00E0, -20 },
  { 0x0079, 0x0101, -20 },
  { 0x0079, 0x0105, -20 },
  { 0x0079, 0x00E5, -20 },
  { 0x0079, 0x00E3, -20 },
  { 0x0079, 0x002C, -100 },
  { 0x0079, 0x0065, -20 },
  { 0x0079, 0x00E9, -20 },
  { 0x0079, 0x011B, -20 },
  { 0x0079, 0x00EA, -20 },
  { 0x0079, 0x00EB, -20 },
  { 0x0079, 0x0117, -20 },
  { 0x0079, 0x00E8, -20 },
  { 0x0079, 0x0113, -20 },
  { 0x0079, 0x0119, -20 },
  { 0x0079, 0x006F, -20 },
  { 0x0079, 0x00F3, -20 },
  { 0x0079, 0x00F4, -20 },
  { 0x0079, 0x00F6, -20 },
  { 0x0079, 0x00F2, -20 },
  { 0x0079, 0x0151, -20 },
  { 0x0079, 0x014D, -20 },
  { 0x0079, 0x00F8, -20 },
  { 0x0079, 0x00F5, -20 },
  { 0x0079, 0x002E, -100 },
  { 0x00FD, 0x0061, -20 },
  { 0x00FD, 0x00E1, -20 },
  { 0x00FD, 0x0103, -20 },
  { 0x00FD, 0x00E2, -20 },
  { 0x00FD, 0x00E4, -20 },
  { 0x00FD, 0x00E0, -20 },
  { 0x00FD, 0x0101, -20 },
  { 0x00FD, 0x0105, -20 },
  { 0x00FD, 0x00E5, -20 },
  { 0x00FD, 0x00E3, -20 },
  { 0x00FD, 0x002C, -100 },
  { 0x00FD, 0x0065, -20 },
  { 0x00FD, 0x00E9, -20 },
  { 0x00FD, 0x011B, -20 },
  { 0x00FD, 0x00EA, -20 },
  { 0x00FD, 0x00EB, -20 },
  { 0x00FD, 0x0117, -20 },
  { 0x00FD, 0x00E8, -20 },
  { 0x00FD, 0x0113, -20 },
  { 0x00FD, 0x0119, -20 },
  { 0x00FD, 0x006F, -20 },
  { 0x00FD, 0x00F3, -20 },
  { 0x00FD, 0x00F4, -20 },
  { 0x00FD, 0x00F6, -20 },
  { 0x00FD, 0x00F2, -20 },
  { 0x00FD, 0x0151, -20 },
  { 0x00FD, 0x014D, -20 },
  { 0x00FD, 0x00F8, -20 },
  { 0x00FD, 0x00F5, -20 },
  { 0x00FD, 0x002E, -100 },
  { 0x00FF, 0x0061, -20 },
  { 0x00FF, 0x00E1, -20 },
  { 0x00FF, 0x0103, -20 },
  { 0x00FF, 0x00E2, -20 },
  { 0x00FF, 0x00E4, -20 },
  { 0x00FF, 0x00E0, -20 },
  { 0x00FF, 0x0101, -20 },
  { 0x00FF, 0x0105, -20 },
  { 0x00FF, 0x00E5, -20 },
  { 0x00FF, 0x00E3, -20 },
  { 0x00FF, 0x002C, -100 },
  { 0x00FF, 0x0065, -20 },
  { 0x00FF, 0x00E9, -20 },
  { 0x00FF, 0x011B, -20 },
  { 0x00FF, 0x00EA, -20 },
  { 0x00FF, 0x00EB, -20 },
  { 0x00FF, 0x0117, -20 },
  { 0x00FF, 0x00E8, -20 },
  { 0x00FF, 0x0113, -20 },
  { 0x00FF, 0x0119, -20 },
  { 0x00FF, 0x006F, -20 },
  { 0x00FF, 0x00F3, -20 },
  { 0x00FF, 0x00F4, -20 },
  { 0x00FF, 0x00F6, -20 },
  { 0x00FF, 0x00F2, -20 },
  { 0x00FF, 0x0151, -20 },
  { 0x00FF, 0x014D, -20 },
  { 0x00FF, 0x00F8, -20 },
  { 0x00FF, 0x00F5, -20 },
  { 0x00FF, 0x002E, -100 },
  { 0x007A, 0x0065, -15 },
  { 0x007A, 0x00E9, -15 },
  { 0x007A, 0x011B, -15 },
  { 0x007A, 0x00EA, -15 },
  { 0x007A, 0x00EB, -15 },
  { 0x007A, 0x0117, -15 },
  { 0x007A, 0x00E8, -15 },
  { 0x007A, 0x0113, -15 },
  { 0x007A, 0x0119, -15 },
  { 0x007A, 0x006F, -15 },
  { 0x007A, 0x00F3, -15 },
  { 0x007A, 0x00F4, -15 },
  { 0x007A, 0x00F6, -15 },
  { 0x007A, 0x00F2, -15 },
  { 0x007A, 0x0151, -15 },
  { 0x007A, 0x014D, -15 },
  { 0x007A, 0x00F8, -15 },
  { 0x007A, 0x00F5, -15 },
  { 0x017A, 0x0065, -15 },
  { 0x017A, 0x00E9, -15 },
  { 0x017A, 0x011B, -15 },
  { 0x017A, 0x00EA, -15 },
  { 0x017A, 0x00EB, -15 },
  { 0x017A, 0x0117, -15 },
  { 0x017A, 0x00E8, -15 },
  { 0x017A, 0x0113, -15 },
  { 0x017A, 0x0119, -15 },
  { 0x017A, 0x006F, -15 },
  { 0x017A, 0x00F3, -15 },
  { 0x017A, 0x00F4, -15 },
  { 0x017A, 0x00F6, -15 },
  { 0x017A, 0x00F2, -15 },
  { 0x017A, 0x0151, -15 },
  { 0x017A, 0x014D, -15 },
  { 0x017A, 0x00F8, -15 },
  { 0x017A, 0x00F5, -15 },
  { 0x017E, 0x0065, -15 },
  { 0x017E, 0x00E9, -15 },
  { 0x017E, 0x011B, -15 },
  { 0x017E, 0x00EA, -15 },
  { 0x017E, 0x00EB, -15 },
  { 0x017E, 0x0117, -15 },
  { 0x017E, 0x00E8, -15 },
  { 0x017E, 0x0113, -15 },
  { 0x017E, 0x0119, -15 },
  { 0x017E, 0x006F, -15 },
  { 0x017E, 0x00F3, -15 },
  { 0x017E, 0x00F4, -15 },
  { 0x017E, 0x00F6, -15 },
  { 0x017E, 0x00F2, -15 },
  { 0x017E, 0x0151, -15 },
  { 0x017E, 0x014D, -15 },
  { 0x017E, 0x00F8, -15 },
  { 0x017E, 0x00F5, -15 },
  { 0x017C, 0x0065, -15 },
  { 0x017C, 0x00E9, -15 },
  { 0x017C, 0x011B, -15 },
  { 0x017C, 0x00EA, -15 },
  { 0x017C, 0x00EB, -15 },
  { 0x017C, 0x0117, -15 },
  { 0x017C, 0x00E8, -15 },
  { 0x017C, 0x0113, -15 },
  { 0x017C, 0x0119, -15 },
  { 0x017C, 0x006F, -15 },
  { 0x017C, 0x00F3, -15 },
  { 0x017C, 0x00F4, -15 },
  { 0x017C, 0x00F6, -15 },
  { 0x017C, 0x00F2, -15 },
  { 0x017C, 0x0151, -15 },
  { 0x017C, 0x014D, -15 },
  { 0x017C, 0x00F8, -15 },
  { 0x017C, 0x00F5, -15 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableTimes[] =
{
  { 0x0041, 0x0043, -40 },
  { 0x0041, 0x0106, -40 },
  { 0x0041, 0x010C, -40 },
  { 0x0041, 0x00C7, -40 },
  { 0x0041, 0x0047, -40 },
  { 0x0041, 0x011E, -40 },
  { 0x0041, 0x0122, -40 },
  { 0x0041, 0x004F, -55 },
  { 0x0041, 0x00D3, -55 },
  { 0x0041, 0x00D4, -55 },
  { 0x0041, 0x00D6, -55 },
  { 0x0041, 0x00D2, -55 },
  { 0x0041, 0x0150, -55 },
  { 0x0041, 0x014C, -55 },
  { 0x0041, 0x00D8, -55 },
  { 0x0041, 0x00D5, -55 },
  { 0x0041, 0x0051, -55 },
  { 0x0041, 0x0054, -111 },
  { 0x0041, 0x0164, -111 },
  { 0x0041, 0x0162, -111 },
  { 0x0041, 0x0055, -55 },
  { 0x0041, 0x00DA, -55 },
  { 0x0041, 0x00DB, -55 },
  { 0x0041, 0x00DC, -55 },
  { 0x0041, 0x00D9, -55 },
  { 0x0041, 0x0170, -55 },
  { 0x0041, 0x016A, -55 },
  { 0x0041, 0x0172, -55 },
  { 0x0041, 0x016E, -55 },
  { 0x0041, 0x0056, -135 },
  { 0x0041, 0x0057, -90 },
  { 0x0041, 0x0059, -105 },
  { 0x0041, 0x00DD, -105 },
  { 0x0041, 0x0178, -105 },
  { 0x0041, 0x2019, -111 },
  { 0x0041, 0x0076, -74 },
  { 0x0041, 0x0077, -92 },
  { 0x0041, 0x0079, -92 },
  { 0x0041, 0x00FD, -92 },
  { 0x0041, 0x00FF, -92 },
  { 0x00C1, 0x0043, -40 },
  { 0x00C1, 0x0106, -40 },
  { 0x00C1, 0x010C, -40 },
  { 0x00C1, 0x00C7, -40 },
  { 0x00C1, 0x0047, -40 },
  { 0x00C1, 0x011E, -40 },
  { 0x00C1, 0x0122, -40 },
  { 0x00C1, 0x004F, -55 },
  { 0x00C1, 0x00D3, -55 },
  { 0x00C1, 0x00D4, -55 },
  { 0x00C1, 0x00D6, -55 },
  { 0x00C1, 0x00D2, -55 },
  { 0x00C1, 0x0150, -55 },
  { 0x00C1, 0x014C, -55 },
  { 0x00C1, 0x00D8, -55 },
  { 0x00C1, 0x00D5, -55 },
  { 0x00C1, 0x0051, -55 },
  { 0x00C1, 0x0054, -111 },
  { 0x00C1, 0x0164, -111 },
  { 0x00C1, 0x0162, -111 },
  { 0x00C1, 0x0055, -55 },
  { 0x00C1, 0x00DA, -55 },
  { 0x00C1, 0x00DB, -55 },
  { 0x00C1, 0x00DC, -55 },
  { 0x00C1, 0x00D9, -55 },
  { 0x00C1, 0x0170, -55 },
  { 0x00C1, 0x016A, -55 },
  { 0x00C1, 0x0172, -55 },
  { 0x00C1, 0x016E, -55 },
  { 0x00C1, 0x0056, -135 },
  { 0x00C1, 0x0057, -90 },
  { 0x00C1, 0x0059, -105 },
  { 0x00C1, 0x00DD, -105 },
  { 0x00C1, 0x0178, -105 },
  { 0x00C1, 0x2019, -111 },
  { 0x00C1, 0x0076, -74 },
  { 0x00C1, 0x0077, -92 },
  { 0x00C1, 0x0079, -92 },
  { 0x00C1, 0x00FD, -92 },
  { 0x00C1, 0x00FF, -92 },
  { 0x0102, 0x0043, -40 },
  { 0x0102, 0x0106, -40 },
  { 0x0102, 0x010C, -40 },
  { 0x0102, 0x00C7, -40 },
  { 0x0102, 0x0047, -40 },
  { 0x0102, 0x011E, -40 },
  { 0x0102, 0x0122, -40 },
  { 0x0102, 0x004F, -55 },
  { 0x0102, 0x00D3, -55 },
  { 0x0102, 0x00D4, -55 },
  { 0x0102, 0x00D6, -55 },
  { 0x0102, 0x00D2, -55 },
  { 0x0102, 0x0150, -55 },
  { 0x0102, 0x014C, -55 },
  { 0x0102, 0x00D8, -55 },
  { 0x0102, 0x00D5, -55 },
  { 0x0102, 0x0051, -55 },
  { 0x0102, 0x0054, -111 },
  { 0x0102, 0x0164, -111 },
  { 0x0102, 0x0162, -111 },
  { 0x0102, 0x0055, -55 },
  { 0x0102, 0x00DA, -55 },
  { 0x0102, 0x00DB, -55 },
  { 0x0102, 0x00DC, -55 },
  { 0x0102, 0x00D9, -55 },
  { 0x0102, 0x0170, -55 },
  { 0x0102, 0x016A, -55 },
  { 0x0102, 0x0172, -55 },
  { 0x0102, 0x016E, -55 },
  { 0x0102, 0x0056, -135 },
  { 0x0102, 0x0057, -90 },
  { 0x0102, 0x0059, -105 },
  { 0x0102, 0x00DD, -105 },
  { 0x0102, 0x0178, -105 },
  { 0x0102, 0x2019, -111 },
  { 0x0102, 0x0076, -74 },
  { 0x0102, 0x0077, -92 },
  { 0x0102, 0x0079, -92 },
  { 0x0102, 0x00FD, -92 },
  { 0x0102, 0x00FF, -92 },
  { 0x00C2, 0x0043, -40 },
  { 0x00C2, 0x0106, -40 },
  { 0x00C2, 0x010C, -40 },
  { 0x00C2, 0x00C7, -40 },
  { 0x00C2, 0x0047, -40 },
  { 0x00C2, 0x011E, -40 },
  { 0x00C2, 0x0122, -40 },
  { 0x00C2, 0x004F, -55 },
  { 0x00C2, 0x00D3, -55 },
  { 0x00C2, 0x00D4, -55 },
  { 0x00C2, 0x00D6, -55 },
  { 0x00C2, 0x00D2, -55 },
  { 0x00C2, 0x0150, -55 },
  { 0x00C2, 0x014C, -55 },
  { 0x00C2, 0x00D8, -55 },
  { 0x00C2, 0x00D5, -55 },
  { 0x00C2, 0x0051, -55 },
  { 0x00C2, 0x0054, -111 },
  { 0x00C2, 0x0164, -111 },
  { 0x00C2, 0x0162, -111 },
  { 0x00C2, 0x0055, -55 },
  { 0x00C2, 0x00DA, -55 },
  { 0x00C2, 0x00DB, -55 },
  { 0x00C2, 0x00DC, -55 },
  { 0x00C2, 0x00D9, -55 },
  { 0x00C2, 0x0170, -55 },
  { 0x00C2, 0x016A, -55 },
  { 0x00C2, 0x0172, -55 },
  { 0x00C2, 0x016E, -55 },
  { 0x00C2, 0x0056, -135 },
  { 0x00C2, 0x0057, -90 },
  { 0x00C2, 0x0059, -105 },
  { 0x00C2, 0x00DD, -105 },
  { 0x00C2, 0x0178, -105 },
  { 0x00C2, 0x2019, -111 },
  { 0x00C2, 0x0076, -74 },
  { 0x00C2, 0x0077, -92 },
  { 0x00C2, 0x0079, -92 },
  { 0x00C2, 0x00FD, -92 },
  { 0x00C2, 0x00FF, -92 },
  { 0x00C4, 0x0043, -40 },
  { 0x00C4, 0x0106, -40 },
  { 0x00C4, 0x010C, -40 },
  { 0x00C4, 0x00C7, -40 },
  { 0x00C4, 0x0047, -40 },
  { 0x00C4, 0x011E, -40 },
  { 0x00C4, 0x0122, -40 },
  { 0x00C4, 0x004F, -55 },
  { 0x00C4, 0x00D3, -55 },
  { 0x00C4, 0x00D4, -55 },
  { 0x00C4, 0x00D6, -55 },
  { 0x00C4, 0x00D2, -55 },
  { 0x00C4, 0x0150, -55 },
  { 0x00C4, 0x014C, -55 },
  { 0x00C4, 0x00D8, -55 },
  { 0x00C4, 0x00D5, -55 },
  { 0x00C4, 0x0051, -55 },
  { 0x00C4, 0x0054, -111 },
  { 0x00C4, 0x0164, -111 },
  { 0x00C4, 0x0162, -111 },
  { 0x00C4, 0x0055, -55 },
  { 0x00C4, 0x00DA, -55 },
  { 0x00C4, 0x00DB, -55 },
  { 0x00C4, 0x00DC, -55 },
  { 0x00C4, 0x00D9, -55 },
  { 0x00C4, 0x0170, -55 },
  { 0x00C4, 0x016A, -55 },
  { 0x00C4, 0x0172, -55 },
  { 0x00C4, 0x016E, -55 },
  { 0x00C4, 0x0056, -135 },
  { 0x00C4, 0x0057, -90 },
  { 0x00C4, 0x0059, -105 },
  { 0x00C4, 0x00DD, -105 },
  { 0x00C4, 0x0178, -105 },
  { 0x00C4, 0x2019, -111 },
  { 0x00C4, 0x0076, -74 },
  { 0x00C4, 0x0077, -92 },
  { 0x00C4, 0x0079, -92 },
  { 0x00C4, 0x00FD, -92 },
  { 0x00C4, 0x00FF, -92 },
  { 0x00C0, 0x0043, -40 },
  { 0x00C0, 0x0106, -40 },
  { 0x00C0, 0x010C, -40 },
  { 0x00C0, 0x00C7, -40 },
  { 0x00C0, 0x0047, -40 },
  { 0x00C0, 0x011E, -40 },
  { 0x00C0, 0x0122, -40 },
  { 0x00C0, 0x004F, -55 },
  { 0x00C0, 0x00D3, -55 },
  { 0x00C0, 0x00D4, -55 },
  { 0x00C0, 0x00D6, -55 },
  { 0x00C0, 0x00D2, -55 },
  { 0x00C0, 0x0150, -55 },
  { 0x00C0, 0x014C, -55 },
  { 0x00C0, 0x00D8, -55 },
  { 0x00C0, 0x00D5, -55 },
  { 0x00C0, 0x0051, -55 },
  { 0x00C0, 0x0054, -111 },
  { 0x00C0, 0x0164, -111 },
  { 0x00C0, 0x0162, -111 },
  { 0x00C0, 0x0055, -55 },
  { 0x00C0, 0x00DA, -55 },
  { 0x00C0, 0x00DB, -55 },
  { 0x00C0, 0x00DC, -55 },
  { 0x00C0, 0x00D9, -55 },
  { 0x00C0, 0x0170, -55 },
  { 0x00C0, 0x016A, -55 },
  { 0x00C0, 0x0172, -55 },
  { 0x00C0, 0x016E, -55 },
  { 0x00C0, 0x0056, -135 },
  { 0x00C0, 0x0057, -90 },
  { 0x00C0, 0x0059, -105 },
  { 0x00C0, 0x00DD, -105 },
  { 0x00C0, 0x0178, -105 },
  { 0x00C0, 0x2019, -111 },
  { 0x00C0, 0x0076, -74 },
  { 0x00C0, 0x0077, -92 },
  { 0x00C0, 0x0079, -92 },
  { 0x00C0, 0x00FD, -92 },
  { 0x00C0, 0x00FF, -92 },
  { 0x0100, 0x0043, -40 },
  { 0x0100, 0x0106, -40 },
  { 0x0100, 0x010C, -40 },
  { 0x0100, 0x00C7, -40 },
  { 0x0100, 0x0047, -40 },
  { 0x0100, 0x011E, -40 },
  { 0x0100, 0x0122, -40 },
  { 0x0100, 0x004F, -55 },
  { 0x0100, 0x00D3, -55 },
  { 0x0100, 0x00D4, -55 },
  { 0x0100, 0x00D6, -55 },
  { 0x0100, 0x00D2, -55 },
  { 0x0100, 0x0150, -55 },
  { 0x0100, 0x014C, -55 },
  { 0x0100, 0x00D8, -55 },
  { 0x0100, 0x00D5, -55 },
  { 0x0100, 0x0051, -55 },
  { 0x0100, 0x0054, -111 },
  { 0x0100, 0x0164, -111 },
  { 0x0100, 0x0162, -111 },
  { 0x0100, 0x0055, -55 },
  { 0x0100, 0x00DA, -55 },
  { 0x0100, 0x00DB, -55 },
  { 0x0100, 0x00DC, -55 },
  { 0x0100, 0x00D9, -55 },
  { 0x0100, 0x0170, -55 },
  { 0x0100, 0x016A, -55 },
  { 0x0100, 0x0172, -55 },
  { 0x0100, 0x016E, -55 },
  { 0x0100, 0x0056, -135 },
  { 0x0100, 0x0057, -90 },
  { 0x0100, 0x0059, -105 },
  { 0x0100, 0x00DD, -105 },
  { 0x0100, 0x0178, -105 },
  { 0x0100, 0x2019, -111 },
  { 0x0100, 0x0076, -74 },
  { 0x0100, 0x0077, -92 },
  { 0x0100, 0x0079, -92 },
  { 0x0100, 0x00FD, -92 },
  { 0x0100, 0x00FF, -92 },
  { 0x0104, 0x0043, -40 },
  { 0x0104, 0x0106, -40 },
  { 0x0104, 0x010C, -40 },
  { 0x0104, 0x00C7, -40 },
  { 0x0104, 0x0047, -40 },
  { 0x0104, 0x011E, -40 },
  { 0x0104, 0x0122, -40 },
  { 0x0104, 0x004F, -55 },
  { 0x0104, 0x00D3, -55 },
  { 0x0104, 0x00D4, -55 },
  { 0x0104, 0x00D6, -55 },
  { 0x0104, 0x00D2, -55 },
  { 0x0104, 0x0150, -55 },
  { 0x0104, 0x014C, -55 },
  { 0x0104, 0x00D8, -55 },
  { 0x0104, 0x00D5, -55 },
  { 0x0104, 0x0051, -55 },
  { 0x0104, 0x0054, -111 },
  { 0x0104, 0x0164, -111 },
  { 0x0104, 0x0162, -111 },
  { 0x0104, 0x0055, -55 },
  { 0x0104, 0x00DA, -55 },
  { 0x0104, 0x00DB, -55 },
  { 0x0104, 0x00DC, -55 },
  { 0x0104, 0x00D9, -55 },
  { 0x0104, 0x0170, -55 },
  { 0x0104, 0x016A, -55 },
  { 0x0104, 0x0172, -55 },
  { 0x0104, 0x016E, -55 },
  { 0x0104, 0x0056, -135 },
  { 0x0104, 0x0057, -90 },
  { 0x0104, 0x0059, -105 },
  { 0x0104, 0x00DD, -105 },
  { 0x0104, 0x0178, -105 },
  { 0x0104, 0x2019, -111 },
  { 0x0104, 0x0076, -74 },
  { 0x0104, 0x0077, -52 },
  { 0x0104, 0x0079, -52 },
  { 0x0104, 0x00FD, -52 },
  { 0x0104, 0x00FF, -52 },
  { 0x00C5, 0x0043, -40 },
  { 0x00C5, 0x0106, -40 },
  { 0x00C5, 0x010C, -40 },
  { 0x00C5, 0x00C7, -40 },
  { 0x00C5, 0x0047, -40 },
  { 0x00C5, 0x011E, -40 },
  { 0x00C5, 0x0122, -40 },
  { 0x00C5, 0x004F, -55 },
  { 0x00C5, 0x00D3, -55 },
  { 0x00C5, 0x00D4, -55 },
  { 0x00C5, 0x00D6, -55 },
  { 0x00C5, 0x00D2, -55 },
  { 0x00C5, 0x0150, -55 },
  { 0x00C5, 0x014C, -55 },
  { 0x00C5, 0x00D8, -55 },
  { 0x00C5, 0x00D5, -55 },
  { 0x00C5, 0x0051, -55 },
  { 0x00C5, 0x0054, -111 },
  { 0x00C5, 0x0164, -111 },
  { 0x00C5, 0x0162, -111 },
  { 0x00C5, 0x0055, -55 },
  { 0x00C5, 0x00DA, -55 },
  { 0x00C5, 0x00DB, -55 },
  { 0x00C5, 0x00DC, -55 },
  { 0x00C5, 0x00D9, -55 },
  { 0x00C5, 0x0170, -55 },
  { 0x00C5, 0x016A, -55 },
  { 0x00C5, 0x0172, -55 },
  { 0x00C5, 0x016E, -55 },
  { 0x00C5, 0x0056, -135 },
  { 0x00C5, 0x0057, -90 },
  { 0x00C5, 0x0059, -105 },
  { 0x00C5, 0x00DD, -105 },
  { 0x00C5, 0x0178, -105 },
  { 0x00C5, 0x2019, -111 },
  { 0x00C5, 0x0076, -74 },
  { 0x00C5, 0x0077, -92 },
  { 0x00C5, 0x0079, -92 },
  { 0x00C5, 0x00FD, -92 },
  { 0x00C5, 0x00FF, -92 },
  { 0x00C3, 0x0043, -40 },
  { 0x00C3, 0x0106, -40 },
  { 0x00C3, 0x010C, -40 },
  { 0x00C3, 0x00C7, -40 },
  { 0x00C3, 0x0047, -40 },
  { 0x00C3, 0x011E, -40 },
  { 0x00C3, 0x0122, -40 },
  { 0x00C3, 0x004F, -55 },
  { 0x00C3, 0x00D3, -55 },
  { 0x00C3, 0x00D4, -55 },
  { 0x00C3, 0x00D6, -55 },
  { 0x00C3, 0x00D2, -55 },
  { 0x00C3, 0x0150, -55 },
  { 0x00C3, 0x014C, -55 },
  { 0x00C3, 0x00D8, -55 },
  { 0x00C3, 0x00D5, -55 },
  { 0x00C3, 0x0051, -55 },
  { 0x00C3, 0x0054, -111 },
  { 0x00C3, 0x0164, -111 },
  { 0x00C3, 0x0162, -111 },
  { 0x00C3, 0x0055, -55 },
  { 0x00C3, 0x00DA, -55 },
  { 0x00C3, 0x00DB, -55 },
  { 0x00C3, 0x00DC, -55 },
  { 0x00C3, 0x00D9, -55 },
  { 0x00C3, 0x0170, -55 },
  { 0x00C3, 0x016A, -55 },
  { 0x00C3, 0x0172, -55 },
  { 0x00C3, 0x016E, -55 },
  { 0x00C3, 0x0056, -135 },
  { 0x00C3, 0x0057, -90 },
  { 0x00C3, 0x0059, -105 },
  { 0x00C3, 0x00DD, -105 },
  { 0x00C3, 0x0178, -105 },
  { 0x00C3, 0x2019, -111 },
  { 0x00C3, 0x0076, -74 },
  { 0x00C3, 0x0077, -92 },
  { 0x00C3, 0x0079, -92 },
  { 0x00C3, 0x00FD, -92 },
  { 0x00C3, 0x00FF, -92 },
  { 0x0042, 0x0041, -35 },
  { 0x0042, 0x00C1, -35 },
  { 0x0042, 0x0102, -35 },
  { 0x0042, 0x00C2, -35 },
  { 0x0042, 0x00C4, -35 },
  { 0x0042, 0x00C0, -35 },
  { 0x0042, 0x0100, -35 },
  { 0x0042, 0x0104, -35 },
  { 0x0042, 0x00C5, -35 },
  { 0x0042, 0x00C3, -35 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0044, 0x0041, -40 },
  { 0x0044, 0x00C1, -40 },
  { 0x0044, 0x0102, -40 },
  { 0x0044, 0x00C2, -40 },
  { 0x0044, 0x00C4, -40 },
  { 0x0044, 0x00C0, -40 },
  { 0x0044, 0x0100, -40 },
  { 0x0044, 0x0104, -40 },
  { 0x0044, 0x00C5, -40 },
  { 0x0044, 0x00C3, -40 },
  { 0x0044, 0x0056, -40 },
  { 0x0044, 0x0057, -30 },
  { 0x0044, 0x0059, -55 },
  { 0x0044, 0x00DD, -55 },
  { 0x0044, 0x0178, -55 },
  { 0x010E, 0x0041, -40 },
  { 0x010E, 0x00C1, -40 },
  { 0x010E, 0x0102, -40 },
  { 0x010E, 0x00C2, -40 },
  { 0x010E, 0x00C4, -40 },
  { 0x010E, 0x00C0, -40 },
  { 0x010E, 0x0100, -40 },
  { 0x010E, 0x0104, -40 },
  { 0x010E, 0x00C5, -40 },
  { 0x010E, 0x00C3, -40 },
  { 0x010E, 0x0056, -40 },
  { 0x010E, 0x0057, -30 },
  { 0x010E, 0x0059, -55 },
  { 0x010E, 0x00DD, -55 },
  { 0x010E, 0x0178, -55 },
  { 0x0110, 0x0041, -40 },
  { 0x0110, 0x00C1, -40 },
  { 0x0110, 0x0102, -40 },
  { 0x0110, 0x00C2, -40 },
  { 0x0110, 0x00C4, -40 },
  { 0x0110, 0x00C0, -40 },
  { 0x0110, 0x0100, -40 },
  { 0x0110, 0x0104, -40 },
  { 0x0110, 0x00C5, -40 },
  { 0x0110, 0x00C3, -40 },
  { 0x0110, 0x0056, -40 },
  { 0x0110, 0x0057, -30 },
  { 0x0110, 0x0059, -55 },
  { 0x0110, 0x00DD, -55 },
  { 0x0110, 0x0178, -55 },
  { 0x0046, 0x0041, -74 },
  { 0x0046, 0x00C1, -74 },
  { 0x0046, 0x0102, -74 },
  { 0x0046, 0x00C2, -74 },
  { 0x0046, 0x00C4, -74 },
  { 0x0046, 0x00C0, -74 },
  { 0x0046, 0x0100, -74 },
  { 0x0046, 0x0104, -74 },
  { 0x0046, 0x00C5, -74 },
  { 0x0046, 0x00C3, -74 },
  { 0x0046, 0x0061, -15 },
  { 0x0046, 0x00E1, -15 },
  { 0x0046, 0x0103, -15 },
  { 0x0046, 0x00E2, -15 },
  { 0x0046, 0x00E4, -15 },
  { 0x0046, 0x00E0, -15 },
  { 0x0046, 0x0101, -15 },
  { 0x0046, 0x0105, -15 },
  { 0x0046, 0x00E5, -15 },
  { 0x0046, 0x00E3, -15 },
  { 0x0046, 0x002C, -80 },
  { 0x0046, 0x006F, -15 },
  { 0x0046, 0x00F3, -15 },
  { 0x0046, 0x00F4, -15 },
  { 0x0046, 0x00F6, -15 },
  { 0x0046, 0x00F2, -15 },
  { 0x0046, 0x0151, -15 },
  { 0x0046, 0x014D, -15 },
  { 0x0046, 0x00F8, -15 },
  { 0x0046, 0x00F5, -15 },
  { 0x0046, 0x002E, -80 },
  { 0x004A, 0x0041, -60 },
  { 0x004A, 0x00C1, -60 },
  { 0x004A, 0x0102, -60 },
  { 0x004A, 0x00C2, -60 },
  { 0x004A, 0x00C4, -60 },
  { 0x004A, 0x00C0, -60 },
  { 0x004A, 0x0100, -60 },
  { 0x004A, 0x0104, -60 },
  { 0x004A, 0x00C5, -60 },
  { 0x004A, 0x00C3, -60 },
  { 0x004B, 0x004F, -30 },
  { 0x004B, 0x00D3, -30 },
  { 0x004B, 0x00D4, -30 },
  { 0x004B, 0x00D6, -30 },
  { 0x004B, 0x00D2, -30 },
  { 0x004B, 0x0150, -30 },
  { 0x004B, 0x014C, -30 },
  { 0x004B, 0x00D8, -30 },
  { 0x004B, 0x00D5, -30 },
  { 0x004B, 0x0065, -25 },
  { 0x004B, 0x00E9, -25 },
  { 0x004B, 0x011B, -25 },
  { 0x004B, 0x00EA, -25 },
  { 0x004B, 0x00EB, -25 },
  { 0x004B, 0x0117, -25 },
  { 0x004B, 0x00E8, -25 },
  { 0x004B, 0x0113, -25 },
  { 0x004B, 0x0119, -25 },
  { 0x004B, 0x006F, -35 },
  { 0x004B, 0x00F3, -35 },
  { 0x004B, 0x00F4, -35 },
  { 0x004B, 0x00F6, -35 },
  { 0x004B, 0x00F2, -35 },
  { 0x004B, 0x0151, -35 },
  { 0x004B, 0x014D, -35 },
  { 0x004B, 0x00F8, -35 },
  { 0x004B, 0x00F5, -35 },
  { 0x004B, 0x0075, -15 },
  { 0x004B, 0x00FA, -15 },
  { 0x004B, 0x00FB, -15 },
  { 0x004B, 0x00FC, -15 },
  { 0x004B, 0x00F9, -15 },
  { 0x004B, 0x0171, -15 },
  { 0x004B, 0x016B, -15 },
  { 0x004B, 0x0173, -15 },
  { 0x004B, 0x016F, -15 },
  { 0x004B, 0x0079, -25 },
  { 0x004B, 0x00FD, -25 },
  { 0x004B, 0x00FF, -25 },
  { 0x0136, 0x004F, -30 },
  { 0x0136, 0x00D3, -30 },
  { 0x0136, 0x00D4, -30 },
  { 0x0136, 0x00D6, -30 },
  { 0x0136, 0x00D2, -30 },
  { 0x0136, 0x0150, -30 },
  { 0x0136, 0x014C, -30 },
  { 0x0136, 0x00D8, -30 },
  { 0x0136, 0x00D5, -30 },
  { 0x0136, 0x0065, -25 },
  { 0x0136, 0x00E9, -25 },
  { 0x0136, 0x011B, -25 },
  { 0x0136, 0x00EA, -25 },
  { 0x0136, 0x00EB, -25 },
  { 0x0136, 0x0117, -25 },
  { 0x0136, 0x00E8, -25 },
  { 0x0136, 0x0113, -25 },
  { 0x0136, 0x0119, -25 },
  { 0x0136, 0x006F, -35 },
  { 0x0136, 0x00F3, -35 },
  { 0x0136, 0x00F4, -35 },
  { 0x0136, 0x00F6, -35 },
  { 0x0136, 0x00F2, -35 },
  { 0x0136, 0x0151, -35 },
  { 0x0136, 0x014D, -35 },
  { 0x0136, 0x00F8, -35 },
  { 0x0136, 0x00F5, -35 },
  { 0x0136, 0x0075, -15 },
  { 0x0136, 0x00FA, -15 },
  { 0x0136, 0x00FB, -15 },
  { 0x0136, 0x00FC, -15 },
  { 0x0136, 0x00F9, -15 },
  { 0x0136, 0x0171, -15 },
  { 0x0136, 0x016B, -15 },
  { 0x0136, 0x0173, -15 },
  { 0x0136, 0x016F, -15 },
  { 0x0136, 0x0079, -25 },
  { 0x0136, 0x00FD, -25 },
  { 0x0136, 0x00FF, -25 },
  { 0x004C, 0x0054, -92 },
  { 0x004C, 0x0164, -92 },
  { 0x004C, 0x0162, -92 },
  { 0x004C, 0x0056, -100 },
  { 0x004C, 0x0057, -74 },
  { 0x004C, 0x0059, -100 },
  { 0x004C, 0x00DD, -100 },
  { 0x004C, 0x0178, -100 },
  { 0x004C, 0x2019, -92 },
  { 0x004C, 0x0079, -55 },
  { 0x004C, 0x00FD, -55 },
  { 0x004C, 0x00FF, -55 },
  { 0x0139, 0x0054, -92 },
  { 0x0139, 0x0164, -92 },
  { 0x0139, 0x0162, -92 },
  { 0x0139, 0x0056, -100 },
  { 0x0139, 0x0057, -74 },
  { 0x0139, 0x0059, -100 },
  { 0x0139, 0x00DD, -100 },
  { 0x0139, 0x0178, -100 },
  { 0x0139, 0x2019, -92 },
  { 0x0139, 0x0079, -55 },
  { 0x0139, 0x00FD, -55 },
  { 0x0139, 0x00FF, -55 },
  { 0x013D, 0x2019, -92 },
  { 0x013D, 0x0079, -55 },
  { 0x013D, 0x00FD, -55 },
  { 0x013D, 0x00FF, -55 },
  { 0x013B, 0x0054, -92 },
  { 0x013B, 0x0164, -92 },
  { 0x013B, 0x0162, -92 },
  { 0x013B, 0x0056, -100 },
  { 0x013B, 0x0057, -74 },
  { 0x013B, 0x0059, -100 },
  { 0x013B, 0x00DD, -100 },
  { 0x013B, 0x0178, -100 },
  { 0x013B, 0x2019, -92 },
  { 0x013B, 0x0079, -55 },
  { 0x013B, 0x00FD, -55 },
  { 0x013B, 0x00FF, -55 },
  { 0x0141, 0x0054, -92 },
  { 0x0141, 0x0164, -92 },
  { 0x0141, 0x0162, -92 },
  { 0x0141, 0x0056, -100 },
  { 0x0141, 0x0057, -74 },
  { 0x0141, 0x0059, -100 },
  { 0x0141, 0x00DD, -100 },
  { 0x0141, 0x0178, -100 },
  { 0x0141, 0x2019, -92 },
  { 0x0141, 0x0079, -55 },
  { 0x0141, 0x00FD, -55 },
  { 0x0141, 0x00FF, -55 },
  { 0x004E, 0x0041, -35 },
  { 0x004E, 0x00C1, -35 },
  { 0x004E, 0x0102, -35 },
  { 0x004E, 0x00C2, -35 },
  { 0x004E, 0x00C4, -35 },
  { 0x004E, 0x00C0, -35 },
  { 0x004E, 0x0100, -35 },
  { 0x004E, 0x0104, -35 },
  { 0x004E, 0x00C5, -35 },
  { 0x004E, 0x00C3, -35 },
  { 0x0143, 0x0041, -35 },
  { 0x0143, 0x00C1, -35 },
  { 0x0143, 0x0102, -35 },
  { 0x0143, 0x00C2, -35 },
  { 0x0143, 0x00C4, -35 },
  { 0x0143, 0x00C0, -35 },
  { 0x0143, 0x0100, -35 },
  { 0x0143, 0x0104, -35 },
  { 0x0143, 0x00C5, -35 },
  { 0x0143, 0x00C3, -35 },
  { 0x0147, 0x0041, -35 },
  { 0x0147, 0x00C1, -35 },
  { 0x0147, 0x0102, -35 },
  { 0x0147, 0x00C2, -35 },
  { 0x0147, 0x00C4, -35 },
  { 0x0147, 0x00C0, -35 },
  { 0x0147, 0x0100, -35 },
  { 0x0147, 0x0104, -35 },
  { 0x0147, 0x00C5, -35 },
  { 0x0147, 0x00C3, -35 },
  { 0x0145, 0x0041, -35 },
  { 0x0145, 0x00C1, -35 },
  { 0x0145, 0x0102, -35 },
  { 0x0145, 0x00C2, -35 },
  { 0x0145, 0x00C4, -35 },
  { 0x0145, 0x00C0, -35 },
  { 0x0145, 0x0100, -35 },
  { 0x0145, 0x0104, -35 },
  { 0x0145, 0x00C5, -35 },
  { 0x0145, 0x00C3, -35 },
  { 0x00D1, 0x0041, -35 },
  { 0x00D1, 0x00C1, -35 },
  { 0x00D1, 0x0102, -35 },
  { 0x00D1, 0x00C2, -35 },
  { 0x00D1, 0x00C4, -35 },
  { 0x00D1, 0x00C0, -35 },
  { 0x00D1, 0x0100, -35 },
  { 0x00D1, 0x0104, -35 },
  { 0x00D1, 0x00C5, -35 },
  { 0x00D1, 0x00C3, -35 },
  { 0x004F, 0x0041, -35 },
  { 0x004F, 0x00C1, -35 },
  { 0x004F, 0x0102, -35 },
  { 0x004F, 0x00C2, -35 },
  { 0x004F, 0x00C4, -35 },
  { 0x004F, 0x00C0, -35 },
  { 0x004F, 0x0100, -35 },
  { 0x004F, 0x0104, -35 },
  { 0x004F, 0x00C5, -35 },
  { 0x004F, 0x00C3, -35 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -35 },
  { 0x004F, 0x0058, -40 },
  { 0x004F, 0x0059, -50 },
  { 0x004F, 0x00DD, -50 },
  { 0x004F, 0x0178, -50 },
  { 0x00D3, 0x0041, -35 },
  { 0x00D3, 0x00C1, -35 },
  { 0x00D3, 0x0102, -35 },
  { 0x00D3, 0x00C2, -35 },
  { 0x00D3, 0x00C4, -35 },
  { 0x00D3, 0x00C0, -35 },
  { 0x00D3, 0x0100, -35 },
  { 0x00D3, 0x0104, -35 },
  { 0x00D3, 0x00C5, -35 },
  { 0x00D3, 0x00C3, -35 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -35 },
  { 0x00D3, 0x0058, -40 },
  { 0x00D3, 0x0059, -50 },
  { 0x00D3, 0x00DD, -50 },
  { 0x00D3, 0x0178, -50 },
  { 0x00D4, 0x0041, -35 },
  { 0x00D4, 0x00C1, -35 },
  { 0x00D4, 0x0102, -35 },
  { 0x00D4, 0x00C2, -35 },
  { 0x00D4, 0x00C4, -35 },
  { 0x00D4, 0x00C0, -35 },
  { 0x00D4, 0x0100, -35 },
  { 0x00D4, 0x0104, -35 },
  { 0x00D4, 0x00C5, -35 },
  { 0x00D4, 0x00C3, -35 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -35 },
  { 0x00D4, 0x0058, -40 },
  { 0x00D4, 0x0059, -50 },
  { 0x00D4, 0x00DD, -50 },
  { 0x00D4, 0x0178, -50 },
  { 0x00D6, 0x0041, -35 },
  { 0x00D6, 0x00C1, -35 },
  { 0x00D6, 0x0102, -35 },
  { 0x00D6, 0x00C2, -35 },
  { 0x00D6, 0x00C4, -35 },
  { 0x00D6, 0x00C0, -35 },
  { 0x00D6, 0x0100, -35 },
  { 0x00D6, 0x0104, -35 },
  { 0x00D6, 0x00C5, -35 },
  { 0x00D6, 0x00C3, -35 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -35 },
  { 0x00D6, 0x0058, -40 },
  { 0x00D6, 0x0059, -50 },
  { 0x00D6, 0x00DD, -50 },
  { 0x00D6, 0x0178, -50 },
  { 0x00D2, 0x0041, -35 },
  { 0x00D2, 0x00C1, -35 },
  { 0x00D2, 0x0102, -35 },
  { 0x00D2, 0x00C2, -35 },
  { 0x00D2, 0x00C4, -35 },
  { 0x00D2, 0x00C0, -35 },
  { 0x00D2, 0x0100, -35 },
  { 0x00D2, 0x0104, -35 },
  { 0x00D2, 0x00C5, -35 },
  { 0x00D2, 0x00C3, -35 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -35 },
  { 0x00D2, 0x0058, -40 },
  { 0x00D2, 0x0059, -50 },
  { 0x00D2, 0x00DD, -50 },
  { 0x00D2, 0x0178, -50 },
  { 0x0150, 0x0041, -35 },
  { 0x0150, 0x00C1, -35 },
  { 0x0150, 0x0102, -35 },
  { 0x0150, 0x00C2, -35 },
  { 0x0150, 0x00C4, -35 },
  { 0x0150, 0x00C0, -35 },
  { 0x0150, 0x0100, -35 },
  { 0x0150, 0x0104, -35 },
  { 0x0150, 0x00C5, -35 },
  { 0x0150, 0x00C3, -35 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -35 },
  { 0x0150, 0x0058, -40 },
  { 0x0150, 0x0059, -50 },
  { 0x0150, 0x00DD, -50 },
  { 0x0150, 0x0178, -50 },
  { 0x014C, 0x0041, -35 },
  { 0x014C, 0x00C1, -35 },
  { 0x014C, 0x0102, -35 },
  { 0x014C, 0x00C2, -35 },
  { 0x014C, 0x00C4, -35 },
  { 0x014C, 0x00C0, -35 },
  { 0x014C, 0x0100, -35 },
  { 0x014C, 0x0104, -35 },
  { 0x014C, 0x00C5, -35 },
  { 0x014C, 0x00C3, -35 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -35 },
  { 0x014C, 0x0058, -40 },
  { 0x014C, 0x0059, -50 },
  { 0x014C, 0x00DD, -50 },
  { 0x014C, 0x0178, -50 },
  { 0x00D8, 0x0041, -35 },
  { 0x00D8, 0x00C1, -35 },
  { 0x00D8, 0x0102, -35 },
  { 0x00D8, 0x00C2, -35 },
  { 0x00D8, 0x00C4, -35 },
  { 0x00D8, 0x00C0, -35 },
  { 0x00D8, 0x0100, -35 },
  { 0x00D8, 0x0104, -35 },
  { 0x00D8, 0x00C5, -35 },
  { 0x00D8, 0x00C3, -35 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -35 },
  { 0x00D8, 0x0058, -40 },
  { 0x00D8, 0x0059, -50 },
  { 0x00D8, 0x00DD, -50 },
  { 0x00D8, 0x0178, -50 },
  { 0x00D5, 0x0041, -35 },
  { 0x00D5, 0x00C1, -35 },
  { 0x00D5, 0x0102, -35 },
  { 0x00D5, 0x00C2, -35 },
  { 0x00D5, 0x00C4, -35 },
  { 0x00D5, 0x00C0, -35 },
  { 0x00D5, 0x0100, -35 },
  { 0x00D5, 0x0104, -35 },
  { 0x00D5, 0x00C5, -35 },
  { 0x00D5, 0x00C3, -35 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -35 },
  { 0x00D5, 0x0058, -40 },
  { 0x00D5, 0x0059, -50 },
  { 0x00D5, 0x00DD, -50 },
  { 0x00D5, 0x0178, -50 },
  { 0x0050, 0x0041, -92 },
  { 0x0050, 0x00C1, -92 },
  { 0x0050, 0x0102, -92 },
  { 0x0050, 0x00C2, -92 },
  { 0x0050, 0x00C4, -92 },
  { 0x0050, 0x00C0, -92 },
  { 0x0050, 0x0100, -92 },
  { 0x0050, 0x0104, -92 },
  { 0x0050, 0x00C5, -92 },
  { 0x0050, 0x00C3, -92 },
  { 0x0050, 0x0061, -15 },
  { 0x0050, 0x00E1, -15 },
  { 0x0050, 0x0103, -15 },
  { 0x0050, 0x00E2, -15 },
  { 0x0050, 0x00E4, -15 },
  { 0x0050, 0x00E0, -15 },
  { 0x0050, 0x0101, -15 },
  { 0x0050, 0x0105, -15 },
  { 0x0050, 0x00E5, -15 },
  { 0x0050, 0x00E3, -15 },
  { 0x0050, 0x002C, -111 },
  { 0x0050, 0x002E, -111 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0052, 0x004F, -40 },
  { 0x0052, 0x00D3, -40 },
  { 0x0052, 0x00D4, -40 },
  { 0x0052, 0x00D6, -40 },
  { 0x0052, 0x00D2, -40 },
  { 0x0052, 0x0150, -40 },
  { 0x0052, 0x014C, -40 },
  { 0x0052, 0x00D8, -40 },
  { 0x0052, 0x00D5, -40 },
  { 0x0052, 0x0054, -60 },
  { 0x0052, 0x0164, -60 },
  { 0x0052, 0x0162, -60 },
  { 0x0052, 0x0055, -40 },
  { 0x0052, 0x00DA, -40 },
  { 0x0052, 0x00DB, -40 },
  { 0x0052, 0x00DC, -40 },
  { 0x0052, 0x00D9, -40 },
  { 0x0052, 0x0170, -40 },
  { 0x0052, 0x016A, -40 },
  { 0x0052, 0x0172, -40 },
  { 0x0052, 0x016E, -40 },
  { 0x0052, 0x0056, -80 },
  { 0x0052, 0x0057, -55 },
  { 0x0052, 0x0059, -65 },
  { 0x0052, 0x00DD, -65 },
  { 0x0052, 0x0178, -65 },
  { 0x0154, 0x004F, -40 },
  { 0x0154, 0x00D3, -40 },
  { 0x0154, 0x00D4, -40 },
  { 0x0154, 0x00D6, -40 },
  { 0x0154, 0x00D2, -40 },
  { 0x0154, 0x0150, -40 },
  { 0x0154, 0x014C, -40 },
  { 0x0154, 0x00D8, -40 },
  { 0x0154, 0x00D5, -40 },
  { 0x0154, 0x0054, -60 },
  { 0x0154, 0x0164, -60 },
  { 0x0154, 0x0162, -60 },
  { 0x0154, 0x0055, -40 },
  { 0x0154, 0x00DA, -40 },
  { 0x0154, 0x00DB, -40 },
  { 0x0154, 0x00DC, -40 },
  { 0x0154, 0x00D9, -40 },
  { 0x0154, 0x0170, -40 },
  { 0x0154, 0x016A, -40 },
  { 0x0154, 0x0172, -40 },
  { 0x0154, 0x016E, -40 },
  { 0x0154, 0x0056, -80 },
  { 0x0154, 0x0057, -55 },
  { 0x0154, 0x0059, -65 },
  { 0x0154, 0x00DD, -65 },
  { 0x0154, 0x0178, -65 },
  { 0x0158, 0x004F, -40 },
  { 0x0158, 0x00D3, -40 },
  { 0x0158, 0x00D4, -40 },
  { 0x0158, 0x00D6, -40 },
  { 0x0158, 0x00D2, -40 },
  { 0x0158, 0x0150, -40 },
  { 0x0158, 0x014C, -40 },
  { 0x0158, 0x00D8, -40 },
  { 0x0158, 0x00D5, -40 },
  { 0x0158, 0x0054, -60 },
  { 0x0158, 0x0164, -60 },
  { 0x0158, 0x0162, -60 },
  { 0x0158, 0x0055, -40 },
  { 0x0158, 0x00DA, -40 },
  { 0x0158, 0x00DB, -40 },
  { 0x0158, 0x00DC, -40 },
  { 0x0158, 0x00D9, -40 },
  { 0x0158, 0x0170, -40 },
  { 0x0158, 0x016A, -40 },
  { 0x0158, 0x0172, -40 },
  { 0x0158, 0x016E, -40 },
  { 0x0158, 0x0056, -80 },
  { 0x0158, 0x0057, -55 },
  { 0x0158, 0x0059, -65 },
  { 0x0158, 0x00DD, -65 },
  { 0x0158, 0x0178, -65 },
  { 0x0156, 0x004F, -40 },
  { 0x0156, 0x00D3, -40 },
  { 0x0156, 0x00D4, -40 },
  { 0x0156, 0x00D6, -40 },
  { 0x0156, 0x00D2, -40 },
  { 0x0156, 0x0150, -40 },
  { 0x0156, 0x014C, -40 },
  { 0x0156, 0x00D8, -40 },
  { 0x0156, 0x00D5, -40 },
  { 0x0156, 0x0054, -60 },
  { 0x0156, 0x0164, -60 },
  { 0x0156, 0x0162, -60 },
  { 0x0156, 0x0055, -40 },
  { 0x0156, 0x00DA, -40 },
  { 0x0156, 0x00DB, -40 },
  { 0x0156, 0x00DC, -40 },
  { 0x0156, 0x00D9, -40 },
  { 0x0156, 0x0170, -40 },
  { 0x0156, 0x016A, -40 },
  { 0x0156, 0x0172, -40 },
  { 0x0156, 0x016E, -40 },
  { 0x0156, 0x0056, -80 },
  { 0x0156, 0x0057, -55 },
  { 0x0156, 0x0059, -65 },
  { 0x0156, 0x00DD, -65 },
  { 0x0156, 0x0178, -65 },
  { 0x0054, 0x0041, -93 },
  { 0x0054, 0x00C1, -93 },
  { 0x0054, 0x0102, -93 },
  { 0x0054, 0x00C2, -93 },
  { 0x0054, 0x00C4, -93 },
  { 0x0054, 0x00C0, -93 },
  { 0x0054, 0x0100, -93 },
  { 0x0054, 0x0104, -93 },
  { 0x0054, 0x00C5, -93 },
  { 0x0054, 0x00C3, -93 },
  { 0x0054, 0x004F, -18 },
  { 0x0054, 0x00D3, -18 },
  { 0x0054, 0x00D4, -18 },
  { 0x0054, 0x00D6, -18 },
  { 0x0054, 0x00D2, -18 },
  { 0x0054, 0x0150, -18 },
  { 0x0054, 0x014C, -18 },
  { 0x0054, 0x00D8, -18 },
  { 0x0054, 0x00D5, -18 },
  { 0x0054, 0x0061, -80 },
  { 0x0054, 0x00E1, -80 },
  { 0x0054, 0x0103, -80 },
  { 0x0054, 0x00E2, -80 },
  { 0x0054, 0x00E4, -40 },
  { 0x0054, 0x00E0, -40 },
  { 0x0054, 0x0101, -40 },
  { 0x0054, 0x0105, -80 },
  { 0x0054, 0x00E5, -80 },
  { 0x0054, 0x00E3, -40 },
  { 0x0054, 0x003A, -50 },
  { 0x0054, 0x002C, -74 },
  { 0x0054, 0x0065, -70 },
  { 0x0054, 0x00E9, -70 },
  { 0x0054, 0x011B, -70 },
  { 0x0054, 0x00EA, -70 },
  { 0x0054, 0x00EB, -30 },
  { 0x0054, 0x0117, -70 },
  { 0x0054, 0x00E8, -70 },
  { 0x0054, 0x0113, -30 },
  { 0x0054, 0x0119, -70 },
  { 0x0054, 0x002D, -92 },
  { 0x0054, 0x0069, -35 },
  { 0x0054, 0x00ED, -35 },
  { 0x0054, 0x012F, -35 },
  { 0x0054, 0x006F, -80 },
  { 0x0054, 0x00F3, -80 },
  { 0x0054, 0x00F4, -80 },
  { 0x0054, 0x00F6, -80 },
  { 0x0054, 0x00F2, -80 },
  { 0x0054, 0x0151, -80 },
  { 0x0054, 0x014D, -80 },
  { 0x0054, 0x00F8, -80 },
  { 0x0054, 0x00F5, -80 },
  { 0x0054, 0x002E, -74 },
  { 0x0054, 0x0072, -35 },
  { 0x0054, 0x0155, -35 },
  { 0x0054, 0x0159, -35 },
  { 0x0054, 0x0157, -35 },
  { 0x0054, 0x003B, -55 },
  { 0x0054, 0x0075, -45 },
  { 0x0054, 0x00FA, -45 },
  { 0x0054, 0x00FB, -45 },
  { 0x0054, 0x00FC, -45 },
  { 0x0054, 0x00F9, -45 },
  { 0x0054, 0x0171, -45 },
  { 0x0054, 0x016B, -45 },
  { 0x0054, 0x0173, -45 },
  { 0x0054, 0x016F, -45 },
  { 0x0054, 0x0077, -80 },
  { 0x0054, 0x0079, -80 },
  { 0x0054, 0x00FD, -80 },
  { 0x0054, 0x00FF, -80 },
  { 0x0164, 0x0041, -93 },
  { 0x0164, 0x00C1, -93 },
  { 0x0164, 0x0102, -93 },
  { 0x0164, 0x00C2, -93 },
  { 0x0164, 0x00C4, -93 },
  { 0x0164, 0x00C0, -93 },
  { 0x0164, 0x0100, -93 },
  { 0x0164, 0x0104, -93 },
  { 0x0164, 0x00C5, -93 },
  { 0x0164, 0x00C3, -93 },
  { 0x0164, 0x004F, -18 },
  { 0x0164, 0x00D3, -18 },
  { 0x0164, 0x00D4, -18 },
  { 0x0164, 0x00D6, -18 },
  { 0x0164, 0x00D2, -18 },
  { 0x0164, 0x0150, -18 },
  { 0x0164, 0x014C, -18 },
  { 0x0164, 0x00D8, -18 },
  { 0x0164, 0x00D5, -18 },
  { 0x0164, 0x0061, -80 },
  { 0x0164, 0x00E1, -80 },
  { 0x0164, 0x0103, -80 },
  { 0x0164, 0x00E2, -80 },
  { 0x0164, 0x00E4, -40 },
  { 0x0164, 0x00E0, -40 },
  { 0x0164, 0x0101, -40 },
  { 0x0164, 0x0105, -80 },
  { 0x0164, 0x00E5, -80 },
  { 0x0164, 0x00E3, -40 },
  { 0x0164, 0x003A, -50 },
  { 0x0164, 0x002C, -74 },
  { 0x0164, 0x0065, -70 },
  { 0x0164, 0x00E9, -70 },
  { 0x0164, 0x011B, -70 },
  { 0x0164, 0x00EA, -30 },
  { 0x0164, 0x00EB, -30 },
  { 0x0164, 0x0117, -70 },
  { 0x0164, 0x00E8, -70 },
  { 0x0164, 0x0113, -30 },
  { 0x0164, 0x0119, -70 },
  { 0x0164, 0x002D, -92 },
  { 0x0164, 0x0069, -35 },
  { 0x0164, 0x00ED, -35 },
  { 0x0164, 0x012F, -35 },
  { 0x0164, 0x006F, -80 },
  { 0x0164, 0x00F3, -80 },
  { 0x0164, 0x00F4, -80 },
  { 0x0164, 0x00F6, -80 },
  { 0x0164, 0x00F2, -80 },
  { 0x0164, 0x0151, -80 },
  { 0x0164, 0x014D, -80 },
  { 0x0164, 0x00F8, -80 },
  { 0x0164, 0x00F5, -80 },
  { 0x0164, 0x002E, -74 },
  { 0x0164, 0x0072, -35 },
  { 0x0164, 0x0155, -35 },
  { 0x0164, 0x0159, -35 },
  { 0x0164, 0x0157, -35 },
  { 0x0164, 0x003B, -55 },
  { 0x0164, 0x0075, -45 },
  { 0x0164, 0x00FA, -45 },
  { 0x0164, 0x00FB, -45 },
  { 0x0164, 0x00FC, -45 },
  { 0x0164, 0x00F9, -45 },
  { 0x0164, 0x0171, -45 },
  { 0x0164, 0x016B, -45 },
  { 0x0164, 0x0173, -45 },
  { 0x0164, 0x016F, -45 },
  { 0x0164, 0x0077, -80 },
  { 0x0164, 0x0079, -80 },
  { 0x0164, 0x00FD, -80 },
  { 0x0164, 0x00FF, -80 },
  { 0x0162, 0x0041, -93 },
  { 0x0162, 0x00C1, -93 },
  { 0x0162, 0x0102, -93 },
  { 0x0162, 0x00C2, -93 },
  { 0x0162, 0x00C4, -93 },
  { 0x0162, 0x00C0, -93 },
  { 0x0162, 0x0100, -93 },
  { 0x0162, 0x0104, -93 },
  { 0x0162, 0x00C5, -93 },
  { 0x0162, 0x00C3, -93 },
  { 0x0162, 0x004F, -18 },
  { 0x0162, 0x00D3, -18 },
  { 0x0162, 0x00D4, -18 },
  { 0x0162, 0x00D6, -18 },
  { 0x0162, 0x00D2, -18 },
  { 0x0162, 0x0150, -18 },
  { 0x0162, 0x014C, -18 },
  { 0x0162, 0x00D8, -18 },
  { 0x0162, 0x00D5, -18 },
  { 0x0162, 0x0061, -80 },
  { 0x0162, 0x00E1, -80 },
  { 0x0162, 0x0103, -80 },
  { 0x0162, 0x00E2, -80 },
  { 0x0162, 0x00E4, -40 },
  { 0x0162, 0x00E0, -40 },
  { 0x0162, 0x0101, -40 },
  { 0x0162, 0x0105, -80 },
  { 0x0162, 0x00E5, -80 },
  { 0x0162, 0x00E3, -40 },
  { 0x0162, 0x003A, -50 },
  { 0x0162, 0x002C, -74 },
  { 0x0162, 0x0065, -70 },
  { 0x0162, 0x00E9, -70 },
  { 0x0162, 0x011B, -70 },
  { 0x0162, 0x00EA, -30 },
  { 0x0162, 0x00EB, -30 },
  { 0x0162, 0x0117, -70 },
  { 0x0162, 0x00E8, -30 },
  { 0x0162, 0x0113, -70 },
  { 0x0162, 0x0119, -70 },
  { 0x0162, 0x002D, -92 },
  { 0x0162, 0x0069, -35 },
  { 0x0162, 0x00ED, -35 },
  { 0x0162, 0x012F, -35 },
  { 0x0162, 0x006F, -80 },
  { 0x0162, 0x00F3, -80 },
  { 0x0162, 0x00F4, -80 },
  { 0x0162, 0x00F6, -80 },
  { 0x0162, 0x00F2, -80 },
  { 0x0162, 0x0151, -80 },
  { 0x0162, 0x014D, -80 },
  { 0x0162, 0x00F8, -80 },
  { 0x0162, 0x00F5, -80 },
  { 0x0162, 0x002E, -74 },
  { 0x0162, 0x0072, -35 },
  { 0x0162, 0x0155, -35 },
  { 0x0162, 0x0159, -35 },
  { 0x0162, 0x0157, -35 },
  { 0x0162, 0x003B, -55 },
  { 0x0162, 0x0075, -45 },
  { 0x0162, 0x00FA, -45 },
  { 0x0162, 0x00FB, -45 },
  { 0x0162, 0x00FC, -45 },
  { 0x0162, 0x00F9, -45 },
  { 0x0162, 0x0171, -45 },
  { 0x0162, 0x016B, -45 },
  { 0x0162, 0x0173, -45 },
  { 0x0162, 0x016F, -45 },
  { 0x0162, 0x0077, -80 },
  { 0x0162, 0x0079, -80 },
  { 0x0162, 0x00FD, -80 },
  { 0x0162, 0x00FF, -80 },
  { 0x0055, 0x0041, -40 },
  { 0x0055, 0x00C1, -40 },
  { 0x0055, 0x0102, -40 },
  { 0x0055, 0x00C2, -40 },
  { 0x0055, 0x00C4, -40 },
  { 0x0055, 0x00C0, -40 },
  { 0x0055, 0x0100, -40 },
  { 0x0055, 0x0104, -40 },
  { 0x0055, 0x00C5, -40 },
  { 0x0055, 0x00C3, -40 },
  { 0x00DA, 0x0041, -40 },
  { 0x00DA, 0x00C1, -40 },
  { 0x00DA, 0x0102, -40 },
  { 0x00DA, 0x00C2, -40 },
  { 0x00DA, 0x00C4, -40 },
  { 0x00DA, 0x00C0, -40 },
  { 0x00DA, 0x0100, -40 },
  { 0x00DA, 0x0104, -40 },
  { 0x00DA, 0x00C5, -40 },
  { 0x00DA, 0x00C3, -40 },
  { 0x00DB, 0x0041, -40 },
  { 0x00DB, 0x00C1, -40 },
  { 0x00DB, 0x0102, -40 },
  { 0x00DB, 0x00C2, -40 },
  { 0x00DB, 0x00C4, -40 },
  { 0x00DB, 0x00C0, -40 },
  { 0x00DB, 0x0100, -40 },
  { 0x00DB, 0x0104, -40 },
  { 0x00DB, 0x00C5, -40 },
  { 0x00DB, 0x00C3, -40 },
  { 0x00DC, 0x0041, -40 },
  { 0x00DC, 0x00C1, -40 },
  { 0x00DC, 0x0102, -40 },
  { 0x00DC, 0x00C2, -40 },
  { 0x00DC, 0x00C4, -40 },
  { 0x00DC, 0x00C0, -40 },
  { 0x00DC, 0x0100, -40 },
  { 0x00DC, 0x0104, -40 },
  { 0x00DC, 0x00C5, -40 },
  { 0x00DC, 0x00C3, -40 },
  { 0x00D9, 0x0041, -40 },
  { 0x00D9, 0x00C1, -40 },
  { 0x00D9, 0x0102, -40 },
  { 0x00D9, 0x00C2, -40 },
  { 0x00D9, 0x00C4, -40 },
  { 0x00D9, 0x00C0, -40 },
  { 0x00D9, 0x0100, -40 },
  { 0x00D9, 0x0104, -40 },
  { 0x00D9, 0x00C5, -40 },
  { 0x00D9, 0x00C3, -40 },
  { 0x0170, 0x0041, -40 },
  { 0x0170, 0x00C1, -40 },
  { 0x0170, 0x0102, -40 },
  { 0x0170, 0x00C2, -40 },
  { 0x0170, 0x00C4, -40 },
  { 0x0170, 0x00C0, -40 },
  { 0x0170, 0x0100, -40 },
  { 0x0170, 0x0104, -40 },
  { 0x0170, 0x00C5, -40 },
  { 0x0170, 0x00C3, -40 },
  { 0x016A, 0x0041, -40 },
  { 0x016A, 0x00C1, -40 },
  { 0x016A, 0x0102, -40 },
  { 0x016A, 0x00C2, -40 },
  { 0x016A, 0x00C4, -40 },
  { 0x016A, 0x00C0, -40 },
  { 0x016A, 0x0100, -40 },
  { 0x016A, 0x0104, -40 },
  { 0x016A, 0x00C5, -40 },
  { 0x016A, 0x00C3, -40 },
  { 0x0172, 0x0041, -40 },
  { 0x0172, 0x00C1, -40 },
  { 0x0172, 0x0102, -40 },
  { 0x0172, 0x00C2, -40 },
  { 0x0172, 0x00C4, -40 },
  { 0x0172, 0x00C0, -40 },
  { 0x0172, 0x0100, -40 },
  { 0x0172, 0x0104, -40 },
  { 0x0172, 0x00C5, -40 },
  { 0x0172, 0x00C3, -40 },
  { 0x016E, 0x0041, -40 },
  { 0x016E, 0x00C1, -40 },
  { 0x016E, 0x0102, -40 },
  { 0x016E, 0x00C2, -40 },
  { 0x016E, 0x00C4, -40 },
  { 0x016E, 0x00C0, -40 },
  { 0x016E, 0x0100, -40 },
  { 0x016E, 0x0104, -40 },
  { 0x016E, 0x00C5, -40 },
  { 0x016E, 0x00C3, -40 },
  { 0x0056, 0x0041, -135 },
  { 0x0056, 0x00C1, -135 },
  { 0x0056, 0x0102, -135 },
  { 0x0056, 0x00C2, -135 },
  { 0x0056, 0x00C4, -135 },
  { 0x0056, 0x00C0, -135 },
  { 0x0056, 0x0100, -135 },
  { 0x0056, 0x0104, -135 },
  { 0x0056, 0x00C5, -135 },
  { 0x0056, 0x00C3, -135 },
  { 0x0056, 0x0047, -15 },
  { 0x0056, 0x011E, -15 },
  { 0x0056, 0x0122, -15 },
  { 0x0056, 0x004F, -40 },
  { 0x0056, 0x00D3, -40 },
  { 0x0056, 0x00D4, -40 },
  { 0x0056, 0x00D6, -40 },
  { 0x0056, 0x00D2, -40 },
  { 0x0056, 0x0150, -40 },
  { 0x0056, 0x014C, -40 },
  { 0x0056, 0x00D8, -40 },
  { 0x0056, 0x00D5, -40 },
  { 0x0056, 0x0061, -111 },
  { 0x0056, 0x00E1, -111 },
  { 0x0056, 0x0103, -111 },
  { 0x0056, 0x00E2, -71 },
  { 0x0056, 0x00E4, -71 },
  { 0x0056, 0x00E0, -71 },
  { 0x0056, 0x0101, -71 },
  { 0x0056, 0x0105, -111 },
  { 0x0056, 0x00E5, -111 },
  { 0x0056, 0x00E3, -71 },
  { 0x0056, 0x003A, -74 },
  { 0x0056, 0x002C, -129 },
  { 0x0056, 0x0065, -111 },
  { 0x0056, 0x00E9, -111 },
  { 0x0056, 0x011B, -71 },
  { 0x0056, 0x00EA, -71 },
  { 0x0056, 0x00EB, -71 },
  { 0x0056, 0x0117, -111 },
  { 0x0056, 0x00E8, -71 },
  { 0x0056, 0x0113, -71 },
  { 0x0056, 0x0119, -111 },
  { 0x0056, 0x002D, -100 },
  { 0x0056, 0x0069, -60 },
  { 0x0056, 0x00ED, -60 },
  { 0x0056, 0x00EE, -20 },
  { 0x0056, 0x00EF, -20 },
  { 0x0056, 0x00EC, -20 },
  { 0x0056, 0x012B, -20 },
  { 0x0056, 0x012F, -60 },
  { 0x0056, 0x006F, -129 },
  { 0x0056, 0x00F3, -129 },
  { 0x0056, 0x00F4, -129 },
  { 0x0056, 0x00F6, -89 },
  { 0x0056, 0x00F2, -89 },
  { 0x0056, 0x0151, -129 },
  { 0x0056, 0x014D, -89 },
  { 0x0056, 0x00F8, -129 },
  { 0x0056, 0x00F5, -89 },
  { 0x0056, 0x002E, -129 },
  { 0x0056, 0x003B, -74 },
  { 0x0056, 0x0075, -75 },
  { 0x0056, 0x00FA, -75 },
  { 0x0056, 0x00FB, -75 },
  { 0x0056, 0x00FC, -75 },
  { 0x0056, 0x00F9, -75 },
  { 0x0056, 0x0171, -75 },
  { 0x0056, 0x016B, -75 },
  { 0x0056, 0x0173, -75 },
  { 0x0056, 0x016F, -75 },
  { 0x0057, 0x0041, -120 },
  { 0x0057, 0x00C1, -120 },
  { 0x0057, 0x0102, -120 },
  { 0x0057, 0x00C2, -120 },
  { 0x0057, 0x00C4, -120 },
  { 0x0057, 0x00C0, -120 },
  { 0x0057, 0x0100, -120 },
  { 0x0057, 0x0104, -120 },
  { 0x0057, 0x00C5, -120 },
  { 0x0057, 0x00C3, -120 },
  { 0x0057, 0x004F, -10 },
  { 0x0057, 0x00D3, -10 },
  { 0x0057, 0x00D4, -10 },
  { 0x0057, 0x00D6, -10 },
  { 0x0057, 0x00D2, -10 },
  { 0x0057, 0x0150, -10 },
  { 0x0057, 0x014C, -10 },
  { 0x0057, 0x00D8, -10 },
  { 0x0057, 0x00D5, -10 },
  { 0x0057, 0x0061, -80 },
  { 0x0057, 0x00E1, -80 },
  { 0x0057, 0x0103, -80 },
  { 0x0057, 0x00E2, -80 },
  { 0x0057, 0x00E4, -80 },
  { 0x0057, 0x00E0, -80 },
  { 0x0057, 0x0101, -80 },
  { 0x0057, 0x0105, -80 },
  { 0x0057, 0x00E5, -80 },
  { 0x0057, 0x00E3, -80 },
  { 0x0057, 0x003A, -37 },
  { 0x0057, 0x002C, -92 },
  { 0x0057, 0x0065, -80 },
  { 0x0057, 0x00E9, -80 },
  { 0x0057, 0x011B, -80 },
  { 0x0057, 0x00EA, -80 },
  { 0x0057, 0x00EB, -40 },
  { 0x0057, 0x0117, -80 },
  { 0x0057, 0x00E8, -40 },
  { 0x0057, 0x0113, -40 },
  { 0x0057, 0x0119, -80 },
  { 0x0057, 0x002D, -65 },
  { 0x0057, 0x0069, -40 },
  { 0x0057, 0x00ED, -40 },
  { 0x0057, 0x012F, -40 },
  { 0x0057, 0x006F, -80 },
  { 0x0057, 0x00F3, -80 },
  { 0x0057, 0x00F4, -80 },
  { 0x0057, 0x00F6, -80 },
  { 0x0057, 0x00F2, -80 },
  { 0x0057, 0x0151, -80 },
  { 0x0057, 0x014D, -80 },
  { 0x0057, 0x00F8, -80 },
  { 0x0057, 0x00F5, -80 },
  { 0x0057, 0x002E, -92 },
  { 0x0057, 0x003B, -37 },
  { 0x0057, 0x0075, -50 },
  { 0x0057, 0x00FA, -50 },
  { 0x0057, 0x00FB, -50 },
  { 0x0057, 0x00FC, -50 },
  { 0x0057, 0x00F9, -50 },
  { 0x0057, 0x0171, -50 },
  { 0x0057, 0x016B, -50 },
  { 0x0057, 0x0173, -50 },
  { 0x0057, 0x016F, -50 },
  { 0x0057, 0x0079, -73 },
  { 0x0057, 0x00FD, -73 },
  { 0x0057, 0x00FF, -73 },
  { 0x0059, 0x0041, -120 },
  { 0x0059, 0x00C1, -120 },
  { 0x0059, 0x0102, -120 },
  { 0x0059, 0x00C2, -120 },
  { 0x0059, 0x00C4, -120 },
  { 0x0059, 0x00C0, -120 },
  { 0x0059, 0x0100, -120 },
  { 0x0059, 0x0104, -120 },
  { 0x0059, 0x00C5, -120 },
  { 0x0059, 0x00C3, -120 },
  { 0x0059, 0x004F, -30 },
  { 0x0059, 0x00D3, -30 },
  { 0x0059, 0x00D4, -30 },
  { 0x0059, 0x00D6, -30 },
  { 0x0059, 0x00D2, -30 },
  { 0x0059, 0x0150, -30 },
  { 0x0059, 0x014C, -30 },
  { 0x0059, 0x00D8, -30 },
  { 0x0059, 0x00D5, -30 },
  { 0x0059, 0x0061, -100 },
  { 0x0059, 0x00E1, -100 },
  { 0x0059, 0x0103, -100 },
  { 0x0059, 0x00E2, -100 },
  { 0x0059, 0x00E4, -60 },
  { 0x0059, 0x00E0, -60 },
  { 0x0059, 0x0101, -60 },
  { 0x0059, 0x0105, -100 },
  { 0x0059, 0x00E5, -100 },
  { 0x0059, 0x00E3, -60 },
  { 0x0059, 0x003A, -92 },
  { 0x0059, 0x002C, -129 },
  { 0x0059, 0x0065, -100 },
  { 0x0059, 0x00E9, -100 },
  { 0x0059, 0x011B, -100 },
  { 0x0059, 0x00EA, -100 },
  { 0x0059, 0x00EB, -60 },
  { 0x0059, 0x0117, -100 },
  { 0x0059, 0x00E8, -60 },
  { 0x0059, 0x0113, -60 },
  { 0x0059, 0x0119, -100 },
  { 0x0059, 0x002D, -111 },
  { 0x0059, 0x0069, -55 },
  { 0x0059, 0x00ED, -55 },
  { 0x0059, 0x012F, -55 },
  { 0x0059, 0x006F, -110 },
  { 0x0059, 0x00F3, -110 },
  { 0x0059, 0x00F4, -110 },
  { 0x0059, 0x00F6, -70 },
  { 0x0059, 0x00F2, -70 },
  { 0x0059, 0x0151, -110 },
  { 0x0059, 0x014D, -70 },
  { 0x0059, 0x00F8, -110 },
  { 0x0059, 0x00F5, -70 },
  { 0x0059, 0x002E, -129 },
  { 0x0059, 0x003B, -92 },
  { 0x0059, 0x0075, -111 },
  { 0x0059, 0x00FA, -111 },
  { 0x0059, 0x00FB, -111 },
  { 0x0059, 0x00FC, -71 },
  { 0x0059, 0x00F9, -71 },
  { 0x0059, 0x0171, -111 },
  { 0x0059, 0x016B, -71 },
  { 0x0059, 0x0173, -111 },
  { 0x0059, 0x016F, -111 },
  { 0x00DD, 0x0041, -120 },
  { 0x00DD, 0x00C1, -120 },
  { 0x00DD, 0x0102, -120 },
  { 0x00DD, 0x00C2, -120 },
  { 0x00DD, 0x00C4, -120 },
  { 0x00DD, 0x00C0, -120 },
  { 0x00DD, 0x0100, -120 },
  { 0x00DD, 0x0104, -120 },
  { 0x00DD, 0x00C5, -120 },
  { 0x00DD, 0x00C3, -120 },
  { 0x00DD, 0x004F, -30 },
  { 0x00DD, 0x00D3, -30 },
  { 0x00DD, 0x00D4, -30 },
  { 0x00DD, 0x00D6, -30 },
  { 0x00DD, 0x00D2, -30 },
  { 0x00DD, 0x0150, -30 },
  { 0x00DD, 0x014C, -30 },
  { 0x00DD, 0x00D8, -30 },
  { 0x00DD, 0x00D5, -30 },
  { 0x00DD, 0x0061, -100 },
  { 0x00DD, 0x00E1, -100 },
  { 0x00DD, 0x0103, -100 },
  { 0x00DD, 0x00E2, -100 },
  { 0x00DD, 0x00E4, -60 },
  { 0x00DD, 0x00E0, -60 },
  { 0x00DD, 0x0101, -60 },
  { 0x00DD, 0x0105, -100 },
  { 0x00DD, 0x00E5, -100 },
  { 0x00DD, 0x00E3, -60 },
  { 0x00DD, 0x003A, -92 },
  { 0x00DD, 0x002C, -129 },
  { 0x00DD, 0x0065, -100 },
  { 0x00DD, 0x00E9, -100 },
  { 0x00DD, 0x011B, -100 },
  { 0x00DD, 0x00EA, -100 },
  { 0x00DD, 0x00EB, -60 },
  { 0x00DD, 0x0117, -100 },
  { 0x00DD, 0x00E8, -60 },
  { 0x00DD, 0x0113, -60 },
  { 0x00DD, 0x0119, -100 },
  { 0x00DD, 0x002D, -111 },
  { 0x00DD, 0x0069, -55 },
  { 0x00DD, 0x00ED, -55 },
  { 0x00DD, 0x012F, -55 },
  { 0x00DD, 0x006F, -110 },
  { 0x00DD, 0x00F3, -110 },
  { 0x00DD, 0x00F4, -110 },
  { 0x00DD, 0x00F6, -70 },
  { 0x00DD, 0x00F2, -70 },
  { 0x00DD, 0x0151, -110 },
  { 0x00DD, 0x014D, -70 },
  { 0x00DD, 0x00F8, -110 },
  { 0x00DD, 0x00F5, -70 },
  { 0x00DD, 0x002E, -129 },
  { 0x00DD, 0x003B, -92 },
  { 0x00DD, 0x0075, -111 },
  { 0x00DD, 0x00FA, -111 },
  { 0x00DD, 0x00FB, -111 },
  { 0x00DD, 0x00FC, -71 },
  { 0x00DD, 0x00F9, -71 },
  { 0x00DD, 0x0171, -111 },
  { 0x00DD, 0x016B, -71 },
  { 0x00DD, 0x0173, -111 },
  { 0x00DD, 0x016F, -111 },
  { 0x0178, 0x0041, -120 },
  { 0x0178, 0x00C1, -120 },
  { 0x0178, 0x0102, -120 },
  { 0x0178, 0x00C2, -120 },
  { 0x0178, 0x00C4, -120 },
  { 0x0178, 0x00C0, -120 },
  { 0x0178, 0x0100, -120 },
  { 0x0178, 0x0104, -120 },
  { 0x0178, 0x00C5, -120 },
  { 0x0178, 0x00C3, -120 },
  { 0x0178, 0x004F, -30 },
  { 0x0178, 0x00D3, -30 },
  { 0x0178, 0x00D4, -30 },
  { 0x0178, 0x00D6, -30 },
  { 0x0178, 0x00D2, -30 },
  { 0x0178, 0x0150, -30 },
  { 0x0178, 0x014C, -30 },
  { 0x0178, 0x00D8, -30 },
  { 0x0178, 0x00D5, -30 },
  { 0x0178, 0x0061, -100 },
  { 0x0178, 0x00E1, -100 },
  { 0x0178, 0x0103, -100 },
  { 0x0178, 0x00E2, -100 },
  { 0x0178, 0x00E4, -60 },
  { 0x0178, 0x00E0, -60 },
  { 0x0178, 0x0101, -60 },
  { 0x0178, 0x0105, -100 },
  { 0x0178, 0x00E5, -100 },
  { 0x0178, 0x00E3, -100 },
  { 0x0178, 0x003A, -92 },
  { 0x0178, 0x002C, -129 },
  { 0x0178, 0x0065, -100 },
  { 0x0178, 0x00E9, -100 },
  { 0x0178, 0x011B, -100 },
  { 0x0178, 0x00EA, -100 },
  { 0x0178, 0x00EB, -60 },
  { 0x0178, 0x0117, -100 },
  { 0x0178, 0x00E8, -60 },
  { 0x0178, 0x0113, -60 },
  { 0x0178, 0x0119, -100 },
  { 0x0178, 0x002D, -111 },
  { 0x0178, 0x0069, -55 },
  { 0x0178, 0x00ED, -55 },
  { 0x0178, 0x012F, -55 },
  { 0x0178, 0x006F, -110 },
  { 0x0178, 0x00F3, -110 },
  { 0x0178, 0x00F4, -110 },
  { 0x0178, 0x00F6, -70 },
  { 0x0178, 0x00F2, -70 },
  { 0x0178, 0x0151, -110 },
  { 0x0178, 0x014D, -70 },
  { 0x0178, 0x00F8, -110 },
  { 0x0178, 0x00F5, -70 },
  { 0x0178, 0x002E, -129 },
  { 0x0178, 0x003B, -92 },
  { 0x0178, 0x0075, -111 },
  { 0x0178, 0x00FA, -111 },
  { 0x0178, 0x00FB, -111 },
  { 0x0178, 0x00FC, -71 },
  { 0x0178, 0x00F9, -71 },
  { 0x0178, 0x0171, -111 },
  { 0x0178, 0x016B, -71 },
  { 0x0178, 0x0173, -111 },
  { 0x0178, 0x016F, -111 },
  { 0x0061, 0x0076, -20 },
  { 0x0061, 0x0077, -15 },
  { 0x00E1, 0x0076, -20 },
  { 0x00E1, 0x0077, -15 },
  { 0x0103, 0x0076, -20 },
  { 0x0103, 0x0077, -15 },
  { 0x00E2, 0x0076, -20 },
  { 0x00E2, 0x0077, -15 },
  { 0x00E4, 0x0076, -20 },
  { 0x00E4, 0x0077, -15 },
  { 0x00E0, 0x0076, -20 },
  { 0x00E0, 0x0077, -15 },
  { 0x0101, 0x0076, -20 },
  { 0x0101, 0x0077, -15 },
  { 0x0105, 0x0076, -20 },
  { 0x0105, 0x0077, -15 },
  { 0x00E5, 0x0076, -20 },
  { 0x00E5, 0x0077, -15 },
  { 0x00E3, 0x0076, -20 },
  { 0x00E3, 0x0077, -15 },
  { 0x0062, 0x002E, -40 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0062, 0x0076, -15 },
  { 0x0063, 0x0079, -15 },
  { 0x0063, 0x00FD, -15 },
  { 0x0063, 0x00FF, -15 },
  { 0x0107, 0x0079, -15 },
  { 0x0107, 0x00FD, -15 },
  { 0x0107, 0x00FF, -15 },
  { 0x010D, 0x0079, -15 },
  { 0x010D, 0x00FD, -15 },
  { 0x010D, 0x00FF, -15 },
  { 0x00E7, 0x0079, -15 },
  { 0x00E7, 0x00FD, -15 },
  { 0x00E7, 0x00FF, -15 },
  { 0x002C, 0x201D, -70 },
  { 0x002C, 0x2019, -70 },
  { 0x0065, 0x0067, -15 },
  { 0x0065, 0x011F, -15 },
  { 0x0065, 0x0123, -15 },
  { 0x0065, 0x0076, -25 },
  { 0x0065, 0x0077, -25 },
  { 0x0065, 0x0078, -15 },
  { 0x0065, 0x0079, -15 },
  { 0x0065, 0x00FD, -15 },
  { 0x0065, 0x00FF, -15 },
  { 0x00E9, 0x0067, -15 },
  { 0x00E9, 0x011F, -15 },
  { 0x00E9, 0x0123, -15 },
  { 0x00E9, 0x0076, -25 },
  { 0x00E9, 0x0077, -25 },
  { 0x00E9, 0x0078, -15 },
  { 0x00E9, 0x0079, -15 },
  { 0x00E9, 0x00FD, -15 },
  { 0x00E9, 0x00FF, -15 },
  { 0x011B, 0x0067, -15 },
  { 0x011B, 0x011F, -15 },
  { 0x011B, 0x0123, -15 },
  { 0x011B, 0x0076, -25 },
  { 0x011B, 0x0077, -25 },
  { 0x011B, 0x0078, -15 },
  { 0x011B, 0x0079, -15 },
  { 0x011B, 0x00FD, -15 },
  { 0x011B, 0x00FF, -15 },
  { 0x00EA, 0x0067, -15 },
  { 0x00EA, 0x011F, -15 },
  { 0x00EA, 0x0123, -15 },
  { 0x00EA, 0x0076, -25 },
  { 0x00EA, 0x0077, -25 },
  { 0x00EA, 0x0078, -15 },
  { 0x00EA, 0x0079, -15 },
  { 0x00EA, 0x00FD, -15 },
  { 0x00EA, 0x00FF, -15 },
  { 0x00EB, 0x0067, -15 },
  { 0x00EB, 0x011F, -15 },
  { 0x00EB, 0x0123, -15 },
  { 0x00EB, 0x0076, -25 },
  { 0x00EB, 0x0077, -25 },
  { 0x00EB, 0x0078, -15 },
  { 0x00EB, 0x0079, -15 },
  { 0x00EB, 0x00FD, -15 },
  { 0x00EB, 0x00FF, -15 },
  { 0x0117, 0x0067, -15 },
  { 0x0117, 0x011F, -15 },
  { 0x0117, 0x0123, -15 },
  { 0x0117, 0x0076, -25 },
  { 0x0117, 0x0077, -25 },
  { 0x0117, 0x0078, -15 },
  { 0x0117, 0x0079, -15 },
  { 0x0117, 0x00FD, -15 },
  { 0x0117, 0x00FF, -15 },
  { 0x00E8, 0x0067, -15 },
  { 0x00E8, 0x011F, -15 },
  { 0x00E8, 0x0123, -15 },
  { 0x00E8, 0x0076, -25 },
  { 0x00E8, 0x0077, -25 },
  { 0x00E8, 0x0078, -15 },
  { 0x00E8, 0x0079, -15 },
  { 0x00E8, 0x00FD, -15 },
  { 0x00E8, 0x00FF, -15 },
  { 0x0113, 0x0067, -15 },
  { 0x0113, 0x011F, -15 },
  { 0x0113, 0x0123, -15 },
  { 0x0113, 0x0076, -25 },
  { 0x0113, 0x0077, -25 },
  { 0x0113, 0x0078, -15 },
  { 0x0113, 0x0079, -15 },
  { 0x0113, 0x00FD, -15 },
  { 0x0113, 0x00FF, -15 },
  { 0x0119, 0x0067, -15 },
  { 0x0119, 0x011F, -15 },
  { 0x0119, 0x0123, -15 },
  { 0x0119, 0x0076, -25 },
  { 0x0119, 0x0077, -25 },
  { 0x0119, 0x0078, -15 },
  { 0x0119, 0x0079, -15 },
  { 0x0119, 0x00FD, -15 },
  { 0x0119, 0x00FF, -15 },
  { 0x0066, 0x0061, -10 },
  { 0x0066, 0x00E1, -10 },
  { 0x0066, 0x0103, -10 },
  { 0x0066, 0x00E2, -10 },
  { 0x0066, 0x00E4, -10 },
  { 0x0066, 0x00E0, -10 },
  { 0x0066, 0x0101, -10 },
  { 0x0066, 0x0105, -10 },
  { 0x0066, 0x00E5, -10 },
  { 0x0066, 0x00E3, -10 },
  { 0x0066, 0x0131, -50 },
  { 0x0066, 0x0066, -25 },
  { 0x0066, 0x0069, -20 },
  { 0x0066, 0x00ED, -20 },
  { 0x0066, 0x2019, 55 },
  { 0x0067, 0x0061, -5 },
  { 0x0067, 0x00E1, -5 },
  { 0x0067, 0x0103, -5 },
  { 0x0067, 0x00E2, -5 },
  { 0x0067, 0x00E4, -5 },
  { 0x0067, 0x00E0, -5 },
  { 0x0067, 0x0101, -5 },
  { 0x0067, 0x0105, -5 },
  { 0x0067, 0x00E5, -5 },
  { 0x0067, 0x00E3, -5 },
  { 0x011F, 0x0061, -5 },
  { 0x011F, 0x00E1, -5 },
  { 0x011F, 0x0103, -5 },
  { 0x011F, 0x00E2, -5 },
  { 0x011F, 0x00E4, -5 },
  { 0x011F, 0x00E0, -5 },
  { 0x011F, 0x0101, -5 },
  { 0x011F, 0x0105, -5 },
  { 0x011F, 0x00E5, -5 },
  { 0x011F, 0x00E3, -5 },
  { 0x0123, 0x0061, -5 },
  { 0x0123, 0x00E1, -5 },
  { 0x0123, 0x0103, -5 },
  { 0x0123, 0x00E2, -5 },
  { 0x0123, 0x00E4, -5 },
  { 0x0123, 0x00E0, -5 },
  { 0x0123, 0x0101, -5 },
  { 0x0123, 0x0105, -5 },
  { 0x0123, 0x00E5, -5 },
  { 0x0123, 0x00E3, -5 },
  { 0x0068, 0x0079, -5 },
  { 0x0068, 0x00FD, -5 },
  { 0x0068, 0x00FF, -5 },
  { 0x0069, 0x0076, -25 },
  { 0x00ED, 0x0076, -25 },
  { 0x00EE, 0x0076, -25 },
  { 0x00EF, 0x0076, -25 },
  { 0x00EC, 0x0076, -25 },
  { 0x012B, 0x0076, -25 },
  { 0x012F, 0x0076, -25 },
  { 0x006B, 0x0065, -10 },
  { 0x006B, 0x00E9, -10 },
  { 0x006B, 0x011B, -10 },
  { 0x006B, 0x00EA, -10 },
  { 0x006B, 0x00EB, -10 },
  { 0x006B, 0x0117, -10 },
  { 0x006B, 0x00E8, -10 },
  { 0x006B, 0x0113, -10 },
  { 0x006B, 0x0119, -10 },
  { 0x006B, 0x006F, -10 },
  { 0x006B, 0x00F3, -10 },
  { 0x006B, 0x00F4, -10 },
  { 0x006B, 0x00F6, -10 },
  { 0x006B, 0x00F2, -10 },
  { 0x006B, 0x0151, -10 },
  { 0x006B, 0x014D, -10 },
  { 0x006B, 0x00F8, -10 },
  { 0x006B, 0x00F5, -10 },
  { 0x006B, 0x0079, -15 },
  { 0x006B, 0x00FD, -15 },
  { 0x006B, 0x00FF, -15 },
  { 0x0137, 0x0065, -10 },
  { 0x0137, 0x00E9, -10 },
  { 0x0137, 0x011B, -10 },
  { 0x0137, 0x00EA, -10 },
  { 0x0137, 0x00EB, -10 },
  { 0x0137, 0x0117, -10 },
  { 0x0137, 0x00E8, -10 },
  { 0x0137, 0x0113, -10 },
  { 0x0137, 0x0119, -10 },
  { 0x0137, 0x006F, -10 },
  { 0x0137, 0x00F3, -10 },
  { 0x0137, 0x00F4, -10 },
  { 0x0137, 0x00F6, -10 },
  { 0x0137, 0x00F2, -10 },
  { 0x0137, 0x0151, -10 },
  { 0x0137, 0x014D, -10 },
  { 0x0137, 0x00F8, -10 },
  { 0x0137, 0x00F5, -10 },
  { 0x0137, 0x0079, -15 },
  { 0x0137, 0x00FD, -15 },
  { 0x0137, 0x00FF, -15 },
  { 0x006C, 0x0077, -10 },
  { 0x013A, 0x0077, -10 },
  { 0x013C, 0x0077, -10 },
  { 0x0142, 0x0077, -10 },
  { 0x006E, 0x0076, -40 },
  { 0x006E, 0x0079, -15 },
  { 0x006E, 0x00FD, -15 },
  { 0x006E, 0x00FF, -15 },
  { 0x0144, 0x0076, -40 },
  { 0x0144, 0x0079, -15 },
  { 0x0144, 0x00FD, -15 },
  { 0x0144, 0x00FF, -15 },
  { 0x0148, 0x0076, -40 },
  { 0x0148, 0x0079, -15 },
  { 0x0148, 0x00FD, -15 },
  { 0x0148, 0x00FF, -15 },
  { 0x0146, 0x0076, -40 },
  { 0x0146, 0x0079, -15 },
  { 0x0146, 0x00FD, -15 },
  { 0x0146, 0x00FF, -15 },
  { 0x00F1, 0x0076, -40 },
  { 0x00F1, 0x0079, -15 },
  { 0x00F1, 0x00FD, -15 },
  { 0x00F1, 0x00FF, -15 },
  { 0x006F, 0x0076, -15 },
  { 0x006F, 0x0077, -25 },
  { 0x006F, 0x0079, -10 },
  { 0x006F, 0x00FD, -10 },
  { 0x006F, 0x00FF, -10 },
  { 0x00F3, 0x0076, -15 },
  { 0x00F3, 0x0077, -25 },
  { 0x00F3, 0x0079, -10 },
  { 0x00F3, 0x00FD, -10 },
  { 0x00F3, 0x00FF, -10 },
  { 0x00F4, 0x0076, -15 },
  { 0x00F4, 0x0077, -25 },
  { 0x00F4, 0x0079, -10 },
  { 0x00F4, 0x00FD, -10 },
  { 0x00F4, 0x00FF, -10 },
  { 0x00F6, 0x0076, -15 },
  { 0x00F6, 0x0077, -25 },
  { 0x00F6, 0x0079, -10 },
  { 0x00F6, 0x00FD, -10 },
  { 0x00F6, 0x00FF, -10 },
  { 0x00F2, 0x0076, -15 },
  { 0x00F2, 0x0077, -25 },
  { 0x00F2, 0x0079, -10 },
  { 0x00F2, 0x00FD, -10 },
  { 0x00F2, 0x00FF, -10 },
  { 0x0151, 0x0076, -15 },
  { 0x0151, 0x0077, -25 },
  { 0x0151, 0x0079, -10 },
  { 0x0151, 0x00FD, -10 },
  { 0x0151, 0x00FF, -10 },
  { 0x014D, 0x0076, -15 },
  { 0x014D, 0x0077, -25 },
  { 0x014D, 0x0079, -10 },
  { 0x014D, 0x00FD, -10 },
  { 0x014D, 0x00FF, -10 },
  { 0x00F8, 0x0076, -15 },
  { 0x00F8, 0x0077, -25 },
  { 0x00F8, 0x0079, -10 },
  { 0x00F8, 0x00FD, -10 },
  { 0x00F8, 0x00FF, -10 },
  { 0x00F5, 0x0076, -15 },
  { 0x00F5, 0x0077, -25 },
  { 0x00F5, 0x0079, -10 },
  { 0x00F5, 0x00FD, -10 },
  { 0x00F5, 0x00FF, -10 },
  { 0x0070, 0x0079, -10 },
  { 0x0070, 0x00FD, -10 },
  { 0x0070, 0x00FF, -10 },
  { 0x002E, 0x201D, -70 },
  { 0x002E, 0x2019, -70 },
  { 0x201C, 0x0041, -80 },
  { 0x201C, 0x00C1, -80 },
  { 0x201C, 0x0102, -80 },
  { 0x201C, 0x00C2, -80 },
  { 0x201C, 0x00C4, -80 },
  { 0x201C, 0x00C0, -80 },
  { 0x201C, 0x0100, -80 },
  { 0x201C, 0x0104, -80 },
  { 0x201C, 0x00C5, -80 },
  { 0x201C, 0x00C3, -80 },
  { 0x2018, 0x0041, -80 },
  { 0x2018, 0x00C1, -80 },
  { 0x2018, 0x0102, -80 },
  { 0x2018, 0x00C2, -80 },
  { 0x2018, 0x00C4, -80 },
  { 0x2018, 0x00C0, -80 },
  { 0x2018, 0x0100, -80 },
  { 0x2018, 0x0104, -80 },
  { 0x2018, 0x00C5, -80 },
  { 0x2018, 0x00C3, -80 },
  { 0x2018, 0x2018, -74 },
  { 0x2019, 0x0064, -50 },
  { 0x2019, 0x0111, -50 },
  { 0x2019, 0x006C, -10 },
  { 0x2019, 0x013A, -10 },
  { 0x2019, 0x013C, -10 },
  { 0x2019, 0x0142, -10 },
  { 0x2019, 0x2019, -74 },
  { 0x2019, 0x0072, -50 },
  { 0x2019, 0x0155, -50 },
  { 0x2019, 0x0159, -50 },
  { 0x2019, 0x0157, -50 },
  { 0x2019, 0x0073, -55 },
  { 0x2019, 0x015B, -55 },
  { 0x2019, 0x0161, -55 },
  { 0x2019, 0x015F, -55 },
  { 0x2019, 0x0219, -55 },
  { 0x2019, 0x0020, -74 },
  { 0x2019, 0x0074, -18 },
  { 0x2019, 0x0163, -18 },
  { 0x2019, 0x0076, -50 },
  { 0x0072, 0x002C, -40 },
  { 0x0072, 0x0067, -18 },
  { 0x0072, 0x011F, -18 },
  { 0x0072, 0x0123, -18 },
  { 0x0072, 0x002D, -20 },
  { 0x0072, 0x002E, -55 },
  { 0x0155, 0x002C, -40 },
  { 0x0155, 0x0067, -18 },
  { 0x0155, 0x011F, -18 },
  { 0x0155, 0x0123, -18 },
  { 0x0155, 0x002D, -20 },
  { 0x0155, 0x002E, -55 },
  { 0x0159, 0x002C, -40 },
  { 0x0159, 0x0067, -18 },
  { 0x0159, 0x011F, -18 },
  { 0x0159, 0x0123, -18 },
  { 0x0159, 0x002D, -20 },
  { 0x0159, 0x002E, -55 },
  { 0x0157, 0x002C, -40 },
  { 0x0157, 0x0067, -18 },
  { 0x0157, 0x011F, -18 },
  { 0x0157, 0x0123, -18 },
  { 0x0157, 0x002D, -20 },
  { 0x0157, 0x002E, -55 },
  { 0x0020, 0x0041, -55 },
  { 0x0020, 0x00C1, -55 },
  { 0x0020, 0x0102, -55 },
  { 0x0020, 0x00C2, -55 },
  { 0x0020, 0x00C4, -55 },
  { 0x0020, 0x00C0, -55 },
  { 0x0020, 0x0100, -55 },
  { 0x0020, 0x0104, -55 },
  { 0x0020, 0x00C5, -55 },
  { 0x0020, 0x00C3, -55 },
  { 0x0020, 0x0054, -18 },
  { 0x0020, 0x0164, -18 },
  { 0x0020, 0x0162, -18 },
  { 0x0020, 0x0056, -50 },
  { 0x0020, 0x0057, -30 },
  { 0x0020, 0x0059, -90 },
  { 0x0020, 0x00DD, -90 },
  { 0x0020, 0x0178, -90 },
  { 0x0076, 0x0061, -25 },
  { 0x0076, 0x00E1, -25 },
  { 0x0076, 0x0103, -25 },
  { 0x0076, 0x00E2, -25 },
  { 0x0076, 0x00E4, -25 },
  { 0x0076, 0x00E0, -25 },
  { 0x0076, 0x0101, -25 },
  { 0x0076, 0x0105, -25 },
  { 0x0076, 0x00E5, -25 },
  { 0x0076, 0x00E3, -25 },
  { 0x0076, 0x002C, -65 },
  { 0x0076, 0x0065, -15 },
  { 0x0076, 0x00E9, -15 },
  { 0x0076, 0x011B, -15 },
  { 0x0076, 0x00EA, -15 },
  { 0x0076, 0x00EB, -15 },
  { 0x0076, 0x0117, -15 },
  { 0x0076, 0x00E8, -15 },
  { 0x0076, 0x0113, -15 },
  { 0x0076, 0x0119, -15 },
  { 0x0076, 0x006F, -20 },
  { 0x0076, 0x00F3, -20 },
  { 0x0076, 0x00F4, -20 },
  { 0x0076, 0x00F6, -20 },
  { 0x0076, 0x00F2, -20 },
  { 0x0076, 0x0151, -20 },
  { 0x0076, 0x014D, -20 },
  { 0x0076, 0x00F8, -20 },
  { 0x0076, 0x00F5, -20 },
  { 0x0076, 0x002E, -65 },
  { 0x0077, 0x0061, -10 },
  { 0x0077, 0x00E1, -10 },
  { 0x0077, 0x0103, -10 },
  { 0x0077, 0x00E2, -10 },
  { 0x0077, 0x00E4, -10 },
  { 0x0077, 0x00E0, -10 },
  { 0x0077, 0x0101, -10 },
  { 0x0077, 0x0105, -10 },
  { 0x0077, 0x00E5, -10 },
  { 0x0077, 0x00E3, -10 },
  { 0x0077, 0x002C, -65 },
  { 0x0077, 0x006F, -10 },
  { 0x0077, 0x00F3, -10 },
  { 0x0077, 0x00F4, -10 },
  { 0x0077, 0x00F6, -10 },
  { 0x0077, 0x00F2, -10 },
  { 0x0077, 0x0151, -10 },
  { 0x0077, 0x014D, -10 },
  { 0x0077, 0x00F8, -10 },
  { 0x0077, 0x00F5, -10 },
  { 0x0077, 0x002E, -65 },
  { 0x0078, 0x0065, -15 },
  { 0x0078, 0x00E9, -15 },
  { 0x0078, 0x011B, -15 },
  { 0x0078, 0x00EA, -15 },
  { 0x0078, 0x00EB, -15 },
  { 0x0078, 0x0117, -15 },
  { 0x0078, 0x00E8, -15 },
  { 0x0078, 0x0113, -15 },
  { 0x0078, 0x0119, -15 },
  { 0x0079, 0x002C, -65 },
  { 0x0079, 0x002E, -65 },
  { 0x00FD, 0x002C, -65 },
  { 0x00FD, 0x002E, -65 },
  { 0x00FF, 0x002C, -65 },
  { 0x00FF, 0x002E, -65 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableTimesBold[] =
{
  { 0x0041, 0x0043, -55 },
  { 0x0041, 0x0106, -55 },
  { 0x0041, 0x010C, -55 },
  { 0x0041, 0x00C7, -55 },
  { 0x0041, 0x0047, -55 },
  { 0x0041, 0x011E, -55 },
  { 0x0041, 0x0122, -55 },
  { 0x0041, 0x004F, -45 },
  { 0x0041, 0x00D3, -45 },
  { 0x0041, 0x00D4, -45 },
  { 0x0041, 0x00D6, -45 },
  { 0x0041, 0x00D2, -45 },
  { 0x0041, 0x0150, -45 },
  { 0x0041, 0x014C, -45 },
  { 0x0041, 0x00D8, -45 },
  { 0x0041, 0x00D5, -45 },
  { 0x0041, 0x0051, -45 },
  { 0x0041, 0x0054, -95 },
  { 0x0041, 0x0164, -95 },
  { 0x0041, 0x0162, -95 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -145 },
  { 0x0041, 0x0057, -130 },
  { 0x0041, 0x0059, -100 },
  { 0x0041, 0x00DD, -100 },
  { 0x0041, 0x0178, -100 },
  { 0x0041, 0x0070, -25 },
  { 0x0041, 0x2019, -74 },
  { 0x0041, 0x0075, -50 },
  { 0x0041, 0x00FA, -50 },
  { 0x0041, 0x00FB, -50 },
  { 0x0041, 0x00FC, -50 },
  { 0x0041, 0x00F9, -50 },
  { 0x0041, 0x0171, -50 },
  { 0x0041, 0x016B, -50 },
  { 0x0041, 0x0173, -50 },
  { 0x0041, 0x016F, -50 },
  { 0x0041, 0x0076, -100 },
  { 0x0041, 0x0077, -90 },
  { 0x0041, 0x0079, -74 },
  { 0x0041, 0x00FD, -74 },
  { 0x0041, 0x00FF, -74 },
  { 0x00C1, 0x0043, -55 },
  { 0x00C1, 0x0106, -55 },
  { 0x00C1, 0x010C, -55 },
  { 0x00C1, 0x00C7, -55 },
  { 0x00C1, 0x0047, -55 },
  { 0x00C1, 0x011E, -55 },
  { 0x00C1, 0x0122, -55 },
  { 0x00C1, 0x004F, -45 },
  { 0x00C1, 0x00D3, -45 },
  { 0x00C1, 0x00D4, -45 },
  { 0x00C1, 0x00D6, -45 },
  { 0x00C1, 0x00D2, -45 },
  { 0x00C1, 0x0150, -45 },
  { 0x00C1, 0x014C, -45 },
  { 0x00C1, 0x00D8, -45 },
  { 0x00C1, 0x00D5, -45 },
  { 0x00C1, 0x0051, -45 },
  { 0x00C1, 0x0054, -95 },
  { 0x00C1, 0x0164, -95 },
  { 0x00C1, 0x0162, -95 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -145 },
  { 0x00C1, 0x0057, -130 },
  { 0x00C1, 0x0059, -100 },
  { 0x00C1, 0x00DD, -100 },
  { 0x00C1, 0x0178, -100 },
  { 0x00C1, 0x0070, -25 },
  { 0x00C1, 0x2019, -74 },
  { 0x00C1, 0x0075, -50 },
  { 0x00C1, 0x00FA, -50 },
  { 0x00C1, 0x00FB, -50 },
  { 0x00C1, 0x00FC, -50 },
  { 0x00C1, 0x00F9, -50 },
  { 0x00C1, 0x0171, -50 },
  { 0x00C1, 0x016B, -50 },
  { 0x00C1, 0x0173, -50 },
  { 0x00C1, 0x016F, -50 },
  { 0x00C1, 0x0076, -100 },
  { 0x00C1, 0x0077, -90 },
  { 0x00C1, 0x0079, -74 },
  { 0x00C1, 0x00FD, -74 },
  { 0x00C1, 0x00FF, -74 },
  { 0x0102, 0x0043, -55 },
  { 0x0102, 0x0106, -55 },
  { 0x0102, 0x010C, -55 },
  { 0x0102, 0x00C7, -55 },
  { 0x0102, 0x0047, -55 },
  { 0x0102, 0x011E, -55 },
  { 0x0102, 0x0122, -55 },
  { 0x0102, 0x004F, -45 },
  { 0x0102, 0x00D3, -45 },
  { 0x0102, 0x00D4, -45 },
  { 0x0102, 0x00D6, -45 },
  { 0x0102, 0x00D2, -45 },
  { 0x0102, 0x0150, -45 },
  { 0x0102, 0x014C, -45 },
  { 0x0102, 0x00D8, -45 },
  { 0x0102, 0x00D5, -45 },
  { 0x0102, 0x0051, -45 },
  { 0x0102, 0x0054, -95 },
  { 0x0102, 0x0164, -95 },
  { 0x0102, 0x0162, -95 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -145 },
  { 0x0102, 0x0057, -130 },
  { 0x0102, 0x0059, -100 },
  { 0x0102, 0x00DD, -100 },
  { 0x0102, 0x0178, -100 },
  { 0x0102, 0x0070, -25 },
  { 0x0102, 0x2019, -74 },
  { 0x0102, 0x0075, -50 },
  { 0x0102, 0x00FA, -50 },
  { 0x0102, 0x00FB, -50 },
  { 0x0102, 0x00FC, -50 },
  { 0x0102, 0x00F9, -50 },
  { 0x0102, 0x0171, -50 },
  { 0x0102, 0x016B, -50 },
  { 0x0102, 0x0173, -50 },
  { 0x0102, 0x016F, -50 },
  { 0x0102, 0x0076, -100 },
  { 0x0102, 0x0077, -90 },
  { 0x0102, 0x0079, -74 },
  { 0x0102, 0x00FD, -74 },
  { 0x0102, 0x00FF, -74 },
  { 0x00C2, 0x0043, -55 },
  { 0x00C2, 0x0106, -55 },
  { 0x00C2, 0x010C, -55 },
  { 0x00C2, 0x00C7, -55 },
  { 0x00C2, 0x0047, -55 },
  { 0x00C2, 0x011E, -55 },
  { 0x00C2, 0x0122, -55 },
  { 0x00C2, 0x004F, -45 },
  { 0x00C2, 0x00D3, -45 },
  { 0x00C2, 0x00D4, -45 },
  { 0x00C2, 0x00D6, -45 },
  { 0x00C2, 0x00D2, -45 },
  { 0x00C2, 0x0150, -45 },
  { 0x00C2, 0x014C, -45 },
  { 0x00C2, 0x00D8, -45 },
  { 0x00C2, 0x00D5, -45 },
  { 0x00C2, 0x0051, -45 },
  { 0x00C2, 0x0054, -95 },
  { 0x00C2, 0x0164, -95 },
  { 0x00C2, 0x0162, -95 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -145 },
  { 0x00C2, 0x0057, -130 },
  { 0x00C2, 0x0059, -100 },
  { 0x00C2, 0x00DD, -100 },
  { 0x00C2, 0x0178, -100 },
  { 0x00C2, 0x0070, -25 },
  { 0x00C2, 0x2019, -74 },
  { 0x00C2, 0x0075, -50 },
  { 0x00C2, 0x00FA, -50 },
  { 0x00C2, 0x00FB, -50 },
  { 0x00C2, 0x00FC, -50 },
  { 0x00C2, 0x00F9, -50 },
  { 0x00C2, 0x0171, -50 },
  { 0x00C2, 0x016B, -50 },
  { 0x00C2, 0x0173, -50 },
  { 0x00C2, 0x016F, -50 },
  { 0x00C2, 0x0076, -100 },
  { 0x00C2, 0x0077, -90 },
  { 0x00C2, 0x0079, -74 },
  { 0x00C2, 0x00FD, -74 },
  { 0x00C2, 0x00FF, -74 },
  { 0x00C4, 0x0043, -55 },
  { 0x00C4, 0x0106, -55 },
  { 0x00C4, 0x010C, -55 },
  { 0x00C4, 0x00C7, -55 },
  { 0x00C4, 0x0047, -55 },
  { 0x00C4, 0x011E, -55 },
  { 0x00C4, 0x0122, -55 },
  { 0x00C4, 0x004F, -45 },
  { 0x00C4, 0x00D3, -45 },
  { 0x00C4, 0x00D4, -45 },
  { 0x00C4, 0x00D6, -45 },
  { 0x00C4, 0x00D2, -45 },
  { 0x00C4, 0x0150, -45 },
  { 0x00C4, 0x014C, -45 },
  { 0x00C4, 0x00D8, -45 },
  { 0x00C4, 0x00D5, -45 },
  { 0x00C4, 0x0051, -45 },
  { 0x00C4, 0x0054, -95 },
  { 0x00C4, 0x0164, -95 },
  { 0x00C4, 0x0162, -95 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -145 },
  { 0x00C4, 0x0057, -130 },
  { 0x00C4, 0x0059, -100 },
  { 0x00C4, 0x00DD, -100 },
  { 0x00C4, 0x0178, -100 },
  { 0x00C4, 0x0070, -25 },
  { 0x00C4, 0x2019, -74 },
  { 0x00C4, 0x0075, -50 },
  { 0x00C4, 0x00FA, -50 },
  { 0x00C4, 0x00FB, -50 },
  { 0x00C4, 0x00FC, -50 },
  { 0x00C4, 0x00F9, -50 },
  { 0x00C4, 0x0171, -50 },
  { 0x00C4, 0x016B, -50 },
  { 0x00C4, 0x0173, -50 },
  { 0x00C4, 0x016F, -50 },
  { 0x00C4, 0x0076, -100 },
  { 0x00C4, 0x0077, -90 },
  { 0x00C4, 0x0079, -74 },
  { 0x00C4, 0x00FD, -74 },
  { 0x00C4, 0x00FF, -74 },
  { 0x00C0, 0x0043, -55 },
  { 0x00C0, 0x0106, -55 },
  { 0x00C0, 0x010C, -55 },
  { 0x00C0, 0x00C7, -55 },
  { 0x00C0, 0x0047, -55 },
  { 0x00C0, 0x011E, -55 },
  { 0x00C0, 0x0122, -55 },
  { 0x00C0, 0x004F, -45 },
  { 0x00C0, 0x00D3, -45 },
  { 0x00C0, 0x00D4, -45 },
  { 0x00C0, 0x00D6, -45 },
  { 0x00C0, 0x00D2, -45 },
  { 0x00C0, 0x0150, -45 },
  { 0x00C0, 0x014C, -45 },
  { 0x00C0, 0x00D8, -45 },
  { 0x00C0, 0x00D5, -45 },
  { 0x00C0, 0x0051, -45 },
  { 0x00C0, 0x0054, -95 },
  { 0x00C0, 0x0164, -95 },
  { 0x00C0, 0x0162, -95 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -145 },
  { 0x00C0, 0x0057, -130 },
  { 0x00C0, 0x0059, -100 },
  { 0x00C0, 0x00DD, -100 },
  { 0x00C0, 0x0178, -100 },
  { 0x00C0, 0x0070, -25 },
  { 0x00C0, 0x2019, -74 },
  { 0x00C0, 0x0075, -50 },
  { 0x00C0, 0x00FA, -50 },
  { 0x00C0, 0x00FB, -50 },
  { 0x00C0, 0x00FC, -50 },
  { 0x00C0, 0x00F9, -50 },
  { 0x00C0, 0x0171, -50 },
  { 0x00C0, 0x016B, -50 },
  { 0x00C0, 0x0173, -50 },
  { 0x00C0, 0x016F, -50 },
  { 0x00C0, 0x0076, -100 },
  { 0x00C0, 0x0077, -90 },
  { 0x00C0, 0x0079, -74 },
  { 0x00C0, 0x00FD, -74 },
  { 0x00C0, 0x00FF, -74 },
  { 0x0100, 0x0043, -55 },
  { 0x0100, 0x0106, -55 },
  { 0x0100, 0x010C, -55 },
  { 0x0100, 0x00C7, -55 },
  { 0x0100, 0x0047, -55 },
  { 0x0100, 0x011E, -55 },
  { 0x0100, 0x0122, -55 },
  { 0x0100, 0x004F, -45 },
  { 0x0100, 0x00D3, -45 },
  { 0x0100, 0x00D4, -45 },
  { 0x0100, 0x00D6, -45 },
  { 0x0100, 0x00D2, -45 },
  { 0x0100, 0x0150, -45 },
  { 0x0100, 0x014C, -45 },
  { 0x0100, 0x00D8, -45 },
  { 0x0100, 0x00D5, -45 },
  { 0x0100, 0x0051, -45 },
  { 0x0100, 0x0054, -95 },
  { 0x0100, 0x0164, -95 },
  { 0x0100, 0x0162, -95 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -145 },
  { 0x0100, 0x0057, -130 },
  { 0x0100, 0x0059, -100 },
  { 0x0100, 0x00DD, -100 },
  { 0x0100, 0x0178, -100 },
  { 0x0100, 0x0070, -25 },
  { 0x0100, 0x2019, -74 },
  { 0x0100, 0x0075, -50 },
  { 0x0100, 0x00FA, -50 },
  { 0x0100, 0x00FB, -50 },
  { 0x0100, 0x00FC, -50 },
  { 0x0100, 0x00F9, -50 },
  { 0x0100, 0x0171, -50 },
  { 0x0100, 0x016B, -50 },
  { 0x0100, 0x0173, -50 },
  { 0x0100, 0x016F, -50 },
  { 0x0100, 0x0076, -100 },
  { 0x0100, 0x0077, -90 },
  { 0x0100, 0x0079, -74 },
  { 0x0100, 0x00FD, -74 },
  { 0x0100, 0x00FF, -74 },
  { 0x0104, 0x0043, -55 },
  { 0x0104, 0x0106, -55 },
  { 0x0104, 0x010C, -55 },
  { 0x0104, 0x00C7, -55 },
  { 0x0104, 0x0047, -55 },
  { 0x0104, 0x011E, -55 },
  { 0x0104, 0x0122, -55 },
  { 0x0104, 0x004F, -45 },
  { 0x0104, 0x00D3, -45 },
  { 0x0104, 0x00D4, -45 },
  { 0x0104, 0x00D6, -45 },
  { 0x0104, 0x00D2, -45 },
  { 0x0104, 0x0150, -45 },
  { 0x0104, 0x014C, -45 },
  { 0x0104, 0x00D8, -45 },
  { 0x0104, 0x00D5, -45 },
  { 0x0104, 0x0051, -45 },
  { 0x0104, 0x0054, -95 },
  { 0x0104, 0x0164, -95 },
  { 0x0104, 0x0162, -95 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -145 },
  { 0x0104, 0x0057, -130 },
  { 0x0104, 0x0059, -100 },
  { 0x0104, 0x00DD, -100 },
  { 0x0104, 0x0178, -100 },
  { 0x0104, 0x0070, -25 },
  { 0x0104, 0x2019, -74 },
  { 0x0104, 0x0075, -50 },
  { 0x0104, 0x00FA, -50 },
  { 0x0104, 0x00FB, -50 },
  { 0x0104, 0x00FC, -50 },
  { 0x0104, 0x00F9, -50 },
  { 0x0104, 0x0171, -50 },
  { 0x0104, 0x016B, -50 },
  { 0x0104, 0x0173, -50 },
  { 0x0104, 0x016F, -50 },
  { 0x0104, 0x0076, -100 },
  { 0x0104, 0x0077, -90 },
  { 0x0104, 0x0079, -34 },
  { 0x0104, 0x00FD, -34 },
  { 0x0104, 0x00FF, -34 },
  { 0x00C5, 0x0043, -55 },
  { 0x00C5, 0x0106, -55 },
  { 0x00C5, 0x010C, -55 },
  { 0x00C5, 0x00C7, -55 },
  { 0x00C5, 0x0047, -55 },
  { 0x00C5, 0x011E, -55 },
  { 0x00C5, 0x0122, -55 },
  { 0x00C5, 0x004F, -45 },
  { 0x00C5, 0x00D3, -45 },
  { 0x00C5, 0x00D4, -45 },
  { 0x00C5, 0x00D6, -45 },
  { 0x00C5, 0x00D2, -45 },
  { 0x00C5, 0x0150, -45 },
  { 0x00C5, 0x014C, -45 },
  { 0x00C5, 0x00D8, -45 },
  { 0x00C5, 0x00D5, -45 },
  { 0x00C5, 0x0051, -45 },
  { 0x00C5, 0x0054, -95 },
  { 0x00C5, 0x0164, -95 },
  { 0x00C5, 0x0162, -95 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -145 },
  { 0x00C5, 0x0057, -130 },
  { 0x00C5, 0x0059, -100 },
  { 0x00C5, 0x00DD, -100 },
  { 0x00C5, 0x0178, -100 },
  { 0x00C5, 0x0070, -25 },
  { 0x00C5, 0x2019, -74 },
  { 0x00C5, 0x0075, -50 },
  { 0x00C5, 0x00FA, -50 },
  { 0x00C5, 0x00FB, -50 },
  { 0x00C5, 0x00FC, -50 },
  { 0x00C5, 0x00F9, -50 },
  { 0x00C5, 0x0171, -50 },
  { 0x00C5, 0x016B, -50 },
  { 0x00C5, 0x0173, -50 },
  { 0x00C5, 0x016F, -50 },
  { 0x00C5, 0x0076, -100 },
  { 0x00C5, 0x0077, -90 },
  { 0x00C5, 0x0079, -74 },
  { 0x00C5, 0x00FD, -74 },
  { 0x00C5, 0x00FF, -74 },
  { 0x00C3, 0x0043, -55 },
  { 0x00C3, 0x0106, -55 },
  { 0x00C3, 0x010C, -55 },
  { 0x00C3, 0x00C7, -55 },
  { 0x00C3, 0x0047, -55 },
  { 0x00C3, 0x011E, -55 },
  { 0x00C3, 0x0122, -55 },
  { 0x00C3, 0x004F, -45 },
  { 0x00C3, 0x00D3, -45 },
  { 0x00C3, 0x00D4, -45 },
  { 0x00C3, 0x00D6, -45 },
  { 0x00C3, 0x00D2, -45 },
  { 0x00C3, 0x0150, -45 },
  { 0x00C3, 0x014C, -45 },
  { 0x00C3, 0x00D8, -45 },
  { 0x00C3, 0x00D5, -45 },
  { 0x00C3, 0x0051, -45 },
  { 0x00C3, 0x0054, -95 },
  { 0x00C3, 0x0164, -95 },
  { 0x00C3, 0x0162, -95 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -145 },
  { 0x00C3, 0x0057, -130 },
  { 0x00C3, 0x0059, -100 },
  { 0x00C3, 0x00DD, -100 },
  { 0x00C3, 0x0178, -100 },
  { 0x00C3, 0x0070, -25 },
  { 0x00C3, 0x2019, -74 },
  { 0x00C3, 0x0075, -50 },
  { 0x00C3, 0x00FA, -50 },
  { 0x00C3, 0x00FB, -50 },
  { 0x00C3, 0x00FC, -50 },
  { 0x00C3, 0x00F9, -50 },
  { 0x00C3, 0x0171, -50 },
  { 0x00C3, 0x016B, -50 },
  { 0x00C3, 0x0173, -50 },
  { 0x00C3, 0x016F, -50 },
  { 0x00C3, 0x0076, -100 },
  { 0x00C3, 0x0077, -90 },
  { 0x00C3, 0x0079, -74 },
  { 0x00C3, 0x00FD, -74 },
  { 0x00C3, 0x00FF, -74 },
  { 0x0042, 0x0041, -30 },
  { 0x0042, 0x00C1, -30 },
  { 0x0042, 0x0102, -30 },
  { 0x0042, 0x00C2, -30 },
  { 0x0042, 0x00C4, -30 },
  { 0x0042, 0x00C0, -30 },
  { 0x0042, 0x0100, -30 },
  { 0x0042, 0x0104, -30 },
  { 0x0042, 0x00C5, -30 },
  { 0x0042, 0x00C3, -30 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0044, 0x0041, -35 },
  { 0x0044, 0x00C1, -35 },
  { 0x0044, 0x0102, -35 },
  { 0x0044, 0x00C2, -35 },
  { 0x0044, 0x00C4, -35 },
  { 0x0044, 0x00C0, -35 },
  { 0x0044, 0x0100, -35 },
  { 0x0044, 0x0104, -35 },
  { 0x0044, 0x00C5, -35 },
  { 0x0044, 0x00C3, -35 },
  { 0x0044, 0x0056, -40 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -40 },
  { 0x0044, 0x00DD, -40 },
  { 0x0044, 0x0178, -40 },
  { 0x0044, 0x002E, -20 },
  { 0x010E, 0x0041, -35 },
  { 0x010E, 0x00C1, -35 },
  { 0x010E, 0x0102, -35 },
  { 0x010E, 0x00C2, -35 },
  { 0x010E, 0x00C4, -35 },
  { 0x010E, 0x00C0, -35 },
  { 0x010E, 0x0100, -35 },
  { 0x010E, 0x0104, -35 },
  { 0x010E, 0x00C5, -35 },
  { 0x010E, 0x00C3, -35 },
  { 0x010E, 0x0056, -40 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -40 },
  { 0x010E, 0x00DD, -40 },
  { 0x010E, 0x0178, -40 },
  { 0x010E, 0x002E, -20 },
  { 0x0110, 0x0041, -35 },
  { 0x0110, 0x00C1, -35 },
  { 0x0110, 0x0102, -35 },
  { 0x0110, 0x00C2, -35 },
  { 0x0110, 0x00C4, -35 },
  { 0x0110, 0x00C0, -35 },
  { 0x0110, 0x0100, -35 },
  { 0x0110, 0x0104, -35 },
  { 0x0110, 0x00C5, -35 },
  { 0x0110, 0x00C3, -35 },
  { 0x0110, 0x0056, -40 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -40 },
  { 0x0110, 0x00DD, -40 },
  { 0x0110, 0x0178, -40 },
  { 0x0110, 0x002E, -20 },
  { 0x0046, 0x0041, -90 },
  { 0x0046, 0x00C1, -90 },
  { 0x0046, 0x0102, -90 },
  { 0x0046, 0x00C2, -90 },
  { 0x0046, 0x00C4, -90 },
  { 0x0046, 0x00C0, -90 },
  { 0x0046, 0x0100, -90 },
  { 0x0046, 0x0104, -90 },
  { 0x0046, 0x00C5, -90 },
  { 0x0046, 0x00C3, -90 },
  { 0x0046, 0x0061, -25 },
  { 0x0046, 0x00E1, -25 },
  { 0x0046, 0x0103, -25 },
  { 0x0046, 0x00E2, -25 },
  { 0x0046, 0x00E4, -25 },
  { 0x0046, 0x00E0, -25 },
  { 0x0046, 0x0101, -25 },
  { 0x0046, 0x0105, -25 },
  { 0x0046, 0x00E5, -25 },
  { 0x0046, 0x00E3, -25 },
  { 0x0046, 0x002C, -92 },
  { 0x0046, 0x0065, -25 },
  { 0x0046, 0x00E9, -25 },
  { 0x0046, 0x011B, -25 },
  { 0x0046, 0x00EA, -25 },
  { 0x0046, 0x00EB, -25 },
  { 0x0046, 0x0117, -25 },
  { 0x0046, 0x00E8, -25 },
  { 0x0046, 0x0113, -25 },
  { 0x0046, 0x0119, -25 },
  { 0x0046, 0x006F, -25 },
  { 0x0046, 0x00F3, -25 },
  { 0x0046, 0x00F4, -25 },
  { 0x0046, 0x00F6, -25 },
  { 0x0046, 0x00F2, -25 },
  { 0x0046, 0x0151, -25 },
  { 0x0046, 0x014D, -25 },
  { 0x0046, 0x00F8, -25 },
  { 0x0046, 0x00F5, -25 },
  { 0x0046, 0x002E, -110 },
  { 0x004A, 0x0041, -30 },
  { 0x004A, 0x00C1, -30 },
  { 0x004A, 0x0102, -30 },
  { 0x004A, 0x00C2, -30 },
  { 0x004A, 0x00C4, -30 },
  { 0x004A, 0x00C0, -30 },
  { 0x004A, 0x0100, -30 },
  { 0x004A, 0x0104, -30 },
  { 0x004A, 0x00C5, -30 },
  { 0x004A, 0x00C3, -30 },
  { 0x004A, 0x0061, -15 },
  { 0x004A, 0x00E1, -15 },
  { 0x004A, 0x0103, -15 },
  { 0x004A, 0x00E2, -15 },
  { 0x004A, 0x00E4, -15 },
  { 0x004A, 0x00E0, -15 },
  { 0x004A, 0x0101, -15 },
  { 0x004A, 0x0105, -15 },
  { 0x004A, 0x00E5, -15 },
  { 0x004A, 0x00E3, -15 },
  { 0x004A, 0x0065, -15 },
  { 0x004A, 0x00E9, -15 },
  { 0x004A, 0x011B, -15 },
  { 0x004A, 0x00EA, -15 },
  { 0x004A, 0x00EB, -15 },
  { 0x004A, 0x0117, -15 },
  { 0x004A, 0x00E8, -15 },
  { 0x004A, 0x0113, -15 },
  { 0x004A, 0x0119, -15 },
  { 0x004A, 0x006F, -15 },
  { 0x004A, 0x00F3, -15 },
  { 0x004A, 0x00F4, -15 },
  { 0x004A, 0x00F6, -15 },
  { 0x004A, 0x00F2, -15 },
  { 0x004A, 0x0151, -15 },
  { 0x004A, 0x014D, -15 },
  { 0x004A, 0x00F8, -15 },
  { 0x004A, 0x00F5, -15 },
  { 0x004A, 0x002E, -20 },
  { 0x004A, 0x0075, -15 },
  { 0x004A, 0x00FA, -15 },
  { 0x004A, 0x00FB, -15 },
  { 0x004A, 0x00FC, -15 },
  { 0x004A, 0x00F9, -15 },
  { 0x004A, 0x0171, -15 },
  { 0x004A, 0x016B, -15 },
  { 0x004A, 0x0173, -15 },
  { 0x004A, 0x016F, -15 },
  { 0x004B, 0x004F, -30 },
  { 0x004B, 0x00D3, -30 },
  { 0x004B, 0x00D4, -30 },
  { 0x004B, 0x00D6, -30 },
  { 0x004B, 0x00D2, -30 },
  { 0x004B, 0x0150, -30 },
  { 0x004B, 0x014C, -30 },
  { 0x004B, 0x00D8, -30 },
  { 0x004B, 0x00D5, -30 },
  { 0x004B, 0x0065, -25 },
  { 0x004B, 0x00E9, -25 },
  { 0x004B, 0x011B, -25 },
  { 0x004B, 0x00EA, -25 },
  { 0x004B, 0x00EB, -25 },
  { 0x004B, 0x0117, -25 },
  { 0x004B, 0x00E8, -25 },
  { 0x004B, 0x0113, -25 },
  { 0x004B, 0x0119, -25 },
  { 0x004B, 0x006F, -25 },
  { 0x004B, 0x00F3, -25 },
  { 0x004B, 0x00F4, -25 },
  { 0x004B, 0x00F6, -25 },
  { 0x004B, 0x00F2, -25 },
  { 0x004B, 0x0151, -25 },
  { 0x004B, 0x014D, -25 },
  { 0x004B, 0x00F8, -25 },
  { 0x004B, 0x00F5, -25 },
  { 0x004B, 0x0075, -15 },
  { 0x004B, 0x00FA, -15 },
  { 0x004B, 0x00FB, -15 },
  { 0x004B, 0x00FC, -15 },
  { 0x004B, 0x00F9, -15 },
  { 0x004B, 0x0171, -15 },
  { 0x004B, 0x016B, -15 },
  { 0x004B, 0x0173, -15 },
  { 0x004B, 0x016F, -15 },
  { 0x004B, 0x0079, -45 },
  { 0x004B, 0x00FD, -45 },
  { 0x004B, 0x00FF, -45 },
  { 0x0136, 0x004F, -30 },
  { 0x0136, 0x00D3, -30 },
  { 0x0136, 0x00D4, -30 },
  { 0x0136, 0x00D6, -30 },
  { 0x0136, 0x00D2, -30 },
  { 0x0136, 0x0150, -30 },
  { 0x0136, 0x014C, -30 },
  { 0x0136, 0x00D8, -30 },
  { 0x0136, 0x00D5, -30 },
  { 0x0136, 0x0065, -25 },
  { 0x0136, 0x00E9, -25 },
  { 0x0136, 0x011B, -25 },
  { 0x0136, 0x00EA, -25 },
  { 0x0136, 0x00EB, -25 },
  { 0x0136, 0x0117, -25 },
  { 0x0136, 0x00E8, -25 },
  { 0x0136, 0x0113, -25 },
  { 0x0136, 0x0119, -25 },
  { 0x0136, 0x006F, -25 },
  { 0x0136, 0x00F3, -25 },
  { 0x0136, 0x00F4, -25 },
  { 0x0136, 0x00F6, -25 },
  { 0x0136, 0x00F2, -25 },
  { 0x0136, 0x0151, -25 },
  { 0x0136, 0x014D, -25 },
  { 0x0136, 0x00F8, -25 },
  { 0x0136, 0x00F5, -25 },
  { 0x0136, 0x0075, -15 },
  { 0x0136, 0x00FA, -15 },
  { 0x0136, 0x00FB, -15 },
  { 0x0136, 0x00FC, -15 },
  { 0x0136, 0x00F9, -15 },
  { 0x0136, 0x0171, -15 },
  { 0x0136, 0x016B, -15 },
  { 0x0136, 0x0173, -15 },
  { 0x0136, 0x016F, -15 },
  { 0x0136, 0x0079, -45 },
  { 0x0136, 0x00FD, -45 },
  { 0x0136, 0x00FF, -45 },
  { 0x004C, 0x0054, -92 },
  { 0x004C, 0x0164, -92 },
  { 0x004C, 0x0162, -92 },
  { 0x004C, 0x0056, -92 },
  { 0x004C, 0x0057, -92 },
  { 0x004C, 0x0059, -92 },
  { 0x004C, 0x00DD, -92 },
  { 0x004C, 0x0178, -92 },
  { 0x004C, 0x201D, -20 },
  { 0x004C, 0x2019, -110 },
  { 0x004C, 0x0079, -55 },
  { 0x004C, 0x00FD, -55 },
  { 0x004C, 0x00FF, -55 },
  { 0x0139, 0x0054, -92 },
  { 0x0139, 0x0164, -92 },
  { 0x0139, 0x0162, -92 },
  { 0x0139, 0x0056, -92 },
  { 0x0139, 0x0057, -92 },
  { 0x0139, 0x0059, -92 },
  { 0x0139, 0x00DD, -92 },
  { 0x0139, 0x0178, -92 },
  { 0x0139, 0x201D, -20 },
  { 0x0139, 0x2019, -110 },
  { 0x0139, 0x0079, -55 },
  { 0x0139, 0x00FD, -55 },
  { 0x0139, 0x00FF, -55 },
  { 0x013B, 0x0054, -92 },
  { 0x013B, 0x0164, -92 },
  { 0x013B, 0x0162, -92 },
  { 0x013B, 0x0056, -92 },
  { 0x013B, 0x0057, -92 },
  { 0x013B, 0x0059, -92 },
  { 0x013B, 0x00DD, -92 },
  { 0x013B, 0x0178, -92 },
  { 0x013B, 0x201D, -20 },
  { 0x013B, 0x2019, -110 },
  { 0x013B, 0x0079, -55 },
  { 0x013B, 0x00FD, -55 },
  { 0x013B, 0x00FF, -55 },
  { 0x0141, 0x0054, -92 },
  { 0x0141, 0x0164, -92 },
  { 0x0141, 0x0162, -92 },
  { 0x0141, 0x0056, -92 },
  { 0x0141, 0x0057, -92 },
  { 0x0141, 0x0059, -92 },
  { 0x0141, 0x00DD, -92 },
  { 0x0141, 0x0178, -92 },
  { 0x0141, 0x201D, -20 },
  { 0x0141, 0x2019, -110 },
  { 0x0141, 0x0079, -55 },
  { 0x0141, 0x00FD, -55 },
  { 0x0141, 0x00FF, -55 },
  { 0x004E, 0x0041, -20 },
  { 0x004E, 0x00C1, -20 },
  { 0x004E, 0x0102, -20 },
  { 0x004E, 0x00C2, -20 },
  { 0x004E, 0x00C4, -20 },
  { 0x004E, 0x00C0, -20 },
  { 0x004E, 0x0100, -20 },
  { 0x004E, 0x0104, -20 },
  { 0x004E, 0x00C5, -20 },
  { 0x004E, 0x00C3, -20 },
  { 0x0143, 0x0041, -20 },
  { 0x0143, 0x00C1, -20 },
  { 0x0143, 0x0102, -20 },
  { 0x0143, 0x00C2, -20 },
  { 0x0143, 0x00C4, -20 },
  { 0x0143, 0x00C0, -20 },
  { 0x0143, 0x0100, -20 },
  { 0x0143, 0x0104, -20 },
  { 0x0143, 0x00C5, -20 },
  { 0x0143, 0x00C3, -20 },
  { 0x0147, 0x0041, -20 },
  { 0x0147, 0x00C1, -20 },
  { 0x0147, 0x0102, -20 },
  { 0x0147, 0x00C2, -20 },
  { 0x0147, 0x00C4, -20 },
  { 0x0147, 0x00C0, -20 },
  { 0x0147, 0x0100, -20 },
  { 0x0147, 0x0104, -20 },
  { 0x0147, 0x00C5, -20 },
  { 0x0147, 0x00C3, -20 },
  { 0x0145, 0x0041, -20 },
  { 0x0145, 0x00C1, -20 },
  { 0x0145, 0x0102, -20 },
  { 0x0145, 0x00C2, -20 },
  { 0x0145, 0x00C4, -20 },
  { 0x0145, 0x00C0, -20 },
  { 0x0145, 0x0100, -20 },
  { 0x0145, 0x0104, -20 },
  { 0x0145, 0x00C5, -20 },
  { 0x0145, 0x00C3, -20 },
  { 0x00D1, 0x0041, -20 },
  { 0x00D1, 0x00C1, -20 },
  { 0x00D1, 0x0102, -20 },
  { 0x00D1, 0x00C2, -20 },
  { 0x00D1, 0x00C4, -20 },
  { 0x00D1, 0x00C0, -20 },
  { 0x00D1, 0x0100, -20 },
  { 0x00D1, 0x0104, -20 },
  { 0x00D1, 0x00C5, -20 },
  { 0x00D1, 0x00C3, -20 },
  { 0x004F, 0x0041, -40 },
  { 0x004F, 0x00C1, -40 },
  { 0x004F, 0x0102, -40 },
  { 0x004F, 0x00C2, -40 },
  { 0x004F, 0x00C4, -40 },
  { 0x004F, 0x00C0, -40 },
  { 0x004F, 0x0100, -40 },
  { 0x004F, 0x0104, -40 },
  { 0x004F, 0x00C5, -40 },
  { 0x004F, 0x00C3, -40 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -50 },
  { 0x004F, 0x0058, -40 },
  { 0x004F, 0x0059, -50 },
  { 0x004F, 0x00DD, -50 },
  { 0x004F, 0x0178, -50 },
  { 0x00D3, 0x0041, -40 },
  { 0x00D3, 0x00C1, -40 },
  { 0x00D3, 0x0102, -40 },
  { 0x00D3, 0x00C2, -40 },
  { 0x00D3, 0x00C4, -40 },
  { 0x00D3, 0x00C0, -40 },
  { 0x00D3, 0x0100, -40 },
  { 0x00D3, 0x0104, -40 },
  { 0x00D3, 0x00C5, -40 },
  { 0x00D3, 0x00C3, -40 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -50 },
  { 0x00D3, 0x0058, -40 },
  { 0x00D3, 0x0059, -50 },
  { 0x00D3, 0x00DD, -50 },
  { 0x00D3, 0x0178, -50 },
  { 0x00D4, 0x0041, -40 },
  { 0x00D4, 0x00C1, -40 },
  { 0x00D4, 0x0102, -40 },
  { 0x00D4, 0x00C2, -40 },
  { 0x00D4, 0x00C4, -40 },
  { 0x00D4, 0x00C0, -40 },
  { 0x00D4, 0x0100, -40 },
  { 0x00D4, 0x0104, -40 },
  { 0x00D4, 0x00C5, -40 },
  { 0x00D4, 0x00C3, -40 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -50 },
  { 0x00D4, 0x0058, -40 },
  { 0x00D4, 0x0059, -50 },
  { 0x00D4, 0x00DD, -50 },
  { 0x00D4, 0x0178, -50 },
  { 0x00D6, 0x0041, -40 },
  { 0x00D6, 0x00C1, -40 },
  { 0x00D6, 0x0102, -40 },
  { 0x00D6, 0x00C2, -40 },
  { 0x00D6, 0x00C4, -40 },
  { 0x00D6, 0x00C0, -40 },
  { 0x00D6, 0x0100, -40 },
  { 0x00D6, 0x0104, -40 },
  { 0x00D6, 0x00C5, -40 },
  { 0x00D6, 0x00C3, -40 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -50 },
  { 0x00D6, 0x0058, -40 },
  { 0x00D6, 0x0059, -50 },
  { 0x00D6, 0x00DD, -50 },
  { 0x00D6, 0x0178, -50 },
  { 0x00D2, 0x0041, -40 },
  { 0x00D2, 0x00C1, -40 },
  { 0x00D2, 0x0102, -40 },
  { 0x00D2, 0x00C2, -40 },
  { 0x00D2, 0x00C4, -40 },
  { 0x00D2, 0x00C0, -40 },
  { 0x00D2, 0x0100, -40 },
  { 0x00D2, 0x0104, -40 },
  { 0x00D2, 0x00C5, -40 },
  { 0x00D2, 0x00C3, -40 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -50 },
  { 0x00D2, 0x0058, -40 },
  { 0x00D2, 0x0059, -50 },
  { 0x00D2, 0x00DD, -50 },
  { 0x00D2, 0x0178, -50 },
  { 0x0150, 0x0041, -40 },
  { 0x0150, 0x00C1, -40 },
  { 0x0150, 0x0102, -40 },
  { 0x0150, 0x00C2, -40 },
  { 0x0150, 0x00C4, -40 },
  { 0x0150, 0x00C0, -40 },
  { 0x0150, 0x0100, -40 },
  { 0x0150, 0x0104, -40 },
  { 0x0150, 0x00C5, -40 },
  { 0x0150, 0x00C3, -40 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -50 },
  { 0x0150, 0x0058, -40 },
  { 0x0150, 0x0059, -50 },
  { 0x0150, 0x00DD, -50 },
  { 0x0150, 0x0178, -50 },
  { 0x014C, 0x0041, -40 },
  { 0x014C, 0x00C1, -40 },
  { 0x014C, 0x0102, -40 },
  { 0x014C, 0x00C2, -40 },
  { 0x014C, 0x00C4, -40 },
  { 0x014C, 0x00C0, -40 },
  { 0x014C, 0x0100, -40 },
  { 0x014C, 0x0104, -40 },
  { 0x014C, 0x00C5, -40 },
  { 0x014C, 0x00C3, -40 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -50 },
  { 0x014C, 0x0058, -40 },
  { 0x014C, 0x0059, -50 },
  { 0x014C, 0x00DD, -50 },
  { 0x014C, 0x0178, -50 },
  { 0x00D8, 0x0041, -40 },
  { 0x00D8, 0x00C1, -40 },
  { 0x00D8, 0x0102, -40 },
  { 0x00D8, 0x00C2, -40 },
  { 0x00D8, 0x00C4, -40 },
  { 0x00D8, 0x00C0, -40 },
  { 0x00D8, 0x0100, -40 },
  { 0x00D8, 0x0104, -40 },
  { 0x00D8, 0x00C5, -40 },
  { 0x00D8, 0x00C3, -40 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -50 },
  { 0x00D8, 0x0058, -40 },
  { 0x00D8, 0x0059, -50 },
  { 0x00D8, 0x00DD, -50 },
  { 0x00D8, 0x0178, -50 },
  { 0x00D5, 0x0041, -40 },
  { 0x00D5, 0x00C1, -40 },
  { 0x00D5, 0x0102, -40 },
  { 0x00D5, 0x00C2, -40 },
  { 0x00D5, 0x00C4, -40 },
  { 0x00D5, 0x00C0, -40 },
  { 0x00D5, 0x0100, -40 },
  { 0x00D5, 0x0104, -40 },
  { 0x00D5, 0x00C5, -40 },
  { 0x00D5, 0x00C3, -40 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -50 },
  { 0x00D5, 0x0058, -40 },
  { 0x00D5, 0x0059, -50 },
  { 0x00D5, 0x00DD, -50 },
  { 0x00D5, 0x0178, -50 },
  { 0x0050, 0x0041, -74 },
  { 0x0050, 0x00C1, -74 },
  { 0x0050, 0x0102, -74 },
  { 0x0050, 0x00C2, -74 },
  { 0x0050, 0x00C4, -74 },
  { 0x0050, 0x00C0, -74 },
  { 0x0050, 0x0100, -74 },
  { 0x0050, 0x0104, -74 },
  { 0x0050, 0x00C5, -74 },
  { 0x0050, 0x00C3, -74 },
  { 0x0050, 0x0061, -10 },
  { 0x0050, 0x00E1, -10 },
  { 0x0050, 0x0103, -10 },
  { 0x0050, 0x00E2, -10 },
  { 0x0050, 0x00E4, -10 },
  { 0x0050, 0x00E0, -10 },
  { 0x0050, 0x0101, -10 },
  { 0x0050, 0x0105, -10 },
  { 0x0050, 0x00E5, -10 },
  { 0x0050, 0x00E3, -10 },
  { 0x0050, 0x002C, -92 },
  { 0x0050, 0x0065, -20 },
  { 0x0050, 0x00E9, -20 },
  { 0x0050, 0x011B, -20 },
  { 0x0050, 0x00EA, -20 },
  { 0x0050, 0x00EB, -20 },
  { 0x0050, 0x0117, -20 },
  { 0x0050, 0x00E8, -20 },
  { 0x0050, 0x0113, -20 },
  { 0x0050, 0x0119, -20 },
  { 0x0050, 0x006F, -20 },
  { 0x0050, 0x00F3, -20 },
  { 0x0050, 0x00F4, -20 },
  { 0x0050, 0x00F6, -20 },
  { 0x0050, 0x00F2, -20 },
  { 0x0050, 0x0151, -20 },
  { 0x0050, 0x014D, -20 },
  { 0x0050, 0x00F8, -20 },
  { 0x0050, 0x00F5, -20 },
  { 0x0050, 0x002E, -110 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0051, 0x002E, -20 },
  { 0x0052, 0x004F, -30 },
  { 0x0052, 0x00D3, -30 },
  { 0x0052, 0x00D4, -30 },
  { 0x0052, 0x00D6, -30 },
  { 0x0052, 0x00D2, -30 },
  { 0x0052, 0x0150, -30 },
  { 0x0052, 0x014C, -30 },
  { 0x0052, 0x00D8, -30 },
  { 0x0052, 0x00D5, -30 },
  { 0x0052, 0x0054, -40 },
  { 0x0052, 0x0164, -40 },
  { 0x0052, 0x0162, -40 },
  { 0x0052, 0x0055, -30 },
  { 0x0052, 0x00DA, -30 },
  { 0x0052, 0x00DB, -30 },
  { 0x0052, 0x00DC, -30 },
  { 0x0052, 0x00D9, -30 },
  { 0x0052, 0x0170, -30 },
  { 0x0052, 0x016A, -30 },
  { 0x0052, 0x0172, -30 },
  { 0x0052, 0x016E, -30 },
  { 0x0052, 0x0056, -55 },
  { 0x0052, 0x0057, -35 },
  { 0x0052, 0x0059, -35 },
  { 0x0052, 0x00DD, -35 },
  { 0x0052, 0x0178, -35 },
  { 0x0154, 0x004F, -30 },
  { 0x0154, 0x00D3, -30 },
  { 0x0154, 0x00D4, -30 },
  { 0x0154, 0x00D6, -30 },
  { 0x0154, 0x00D2, -30 },
  { 0x0154, 0x0150, -30 },
  { 0x0154, 0x014C, -30 },
  { 0x0154, 0x00D8, -30 },
  { 0x0154, 0x00D5, -30 },
  { 0x0154, 0x0054, -40 },
  { 0x0154, 0x0164, -40 },
  { 0x0154, 0x0162, -40 },
  { 0x0154, 0x0055, -30 },
  { 0x0154, 0x00DA, -30 },
  { 0x0154, 0x00DB, -30 },
  { 0x0154, 0x00DC, -30 },
  { 0x0154, 0x00D9, -30 },
  { 0x0154, 0x0170, -30 },
  { 0x0154, 0x016A, -30 },
  { 0x0154, 0x0172, -30 },
  { 0x0154, 0x016E, -30 },
  { 0x0154, 0x0056, -55 },
  { 0x0154, 0x0057, -35 },
  { 0x0154, 0x0059, -35 },
  { 0x0154, 0x00DD, -35 },
  { 0x0154, 0x0178, -35 },
  { 0x0158, 0x004F, -30 },
  { 0x0158, 0x00D3, -30 },
  { 0x0158, 0x00D4, -30 },
  { 0x0158, 0x00D6, -30 },
  { 0x0158, 0x00D2, -30 },
  { 0x0158, 0x0150, -30 },
  { 0x0158, 0x014C, -30 },
  { 0x0158, 0x00D8, -30 },
  { 0x0158, 0x00D5, -30 },
  { 0x0158, 0x0054, -40 },
  { 0x0158, 0x0164, -40 },
  { 0x0158, 0x0162, -40 },
  { 0x0158, 0x0055, -30 },
  { 0x0158, 0x00DA, -30 },
  { 0x0158, 0x00DB, -30 },
  { 0x0158, 0x00DC, -30 },
  { 0x0158, 0x00D9, -30 },
  { 0x0158, 0x0170, -30 },
  { 0x0158, 0x016A, -30 },
  { 0x0158, 0x0172, -30 },
  { 0x0158, 0x016E, -30 },
  { 0x0158, 0x0056, -55 },
  { 0x0158, 0x0057, -35 },
  { 0x0158, 0x0059, -35 },
  { 0x0158, 0x00DD, -35 },
  { 0x0158, 0x0178, -35 },
  { 0x0156, 0x004F, -30 },
  { 0x0156, 0x00D3, -30 },
  { 0x0156, 0x00D4, -30 },
  { 0x0156, 0x00D6, -30 },
  { 0x0156, 0x00D2, -30 },
  { 0x0156, 0x0150, -30 },
  { 0x0156, 0x014C, -30 },
  { 0x0156, 0x00D8, -30 },
  { 0x0156, 0x00D5, -30 },
  { 0x0156, 0x0054, -40 },
  { 0x0156, 0x0164, -40 },
  { 0x0156, 0x0162, -40 },
  { 0x0156, 0x0055, -30 },
  { 0x0156, 0x00DA, -30 },
  { 0x0156, 0x00DB, -30 },
  { 0x0156, 0x00DC, -30 },
  { 0x0156, 0x00D9, -30 },
  { 0x0156, 0x0170, -30 },
  { 0x0156, 0x016A, -30 },
  { 0x0156, 0x0172, -30 },
  { 0x0156, 0x016E, -30 },
  { 0x0156, 0x0056, -55 },
  { 0x0156, 0x0057, -35 },
  { 0x0156, 0x0059, -35 },
  { 0x0156, 0x00DD, -35 },
  { 0x0156, 0x0178, -35 },
  { 0x0054, 0x0041, -90 },
  { 0x0054, 0x00C1, -90 },
  { 0x0054, 0x0102, -90 },
  { 0x0054, 0x00C2, -90 },
  { 0x0054, 0x00C4, -90 },
  { 0x0054, 0x00C0, -90 },
  { 0x0054, 0x0100, -90 },
  { 0x0054, 0x0104, -90 },
  { 0x0054, 0x00C5, -90 },
  { 0x0054, 0x00C3, -90 },
  { 0x0054, 0x004F, -18 },
  { 0x0054, 0x00D3, -18 },
  { 0x0054, 0x00D4, -18 },
  { 0x0054, 0x00D6, -18 },
  { 0x0054, 0x00D2, -18 },
  { 0x0054, 0x0150, -18 },
  { 0x0054, 0x014C, -18 },
  { 0x0054, 0x00D8, -18 },
  { 0x0054, 0x00D5, -18 },
  { 0x0054, 0x0061, -92 },
  { 0x0054, 0x00E1, -92 },
  { 0x0054, 0x0103, -52 },
  { 0x0054, 0x00E2, -52 },
  { 0x0054, 0x00E4, -52 },
  { 0x0054, 0x00E0, -52 },
  { 0x0054, 0x0101, -52 },
  { 0x0054, 0x0105, -92 },
  { 0x0054, 0x00E5, -92 },
  { 0x0054, 0x00E3, -52 },
  { 0x0054, 0x003A, -74 },
  { 0x0054, 0x002C, -74 },
  { 0x0054, 0x0065, -92 },
  { 0x0054, 0x00E9, -92 },
  { 0x0054, 0x011B, -92 },
  { 0x0054, 0x00EA, -92 },
  { 0x0054, 0x00EB, -52 },
  { 0x0054, 0x0117, -92 },
  { 0x0054, 0x00E8, -52 },
  { 0x0054, 0x0113, -52 },
  { 0x0054, 0x0119, -92 },
  { 0x0054, 0x002D, -92 },
  { 0x0054, 0x0069, -18 },
  { 0x0054, 0x00ED, -18 },
  { 0x0054, 0x012F, -18 },
  { 0x0054, 0x006F, -92 },
  { 0x0054, 0x00F3, -92 },
  { 0x0054, 0x00F4, -92 },
  { 0x0054, 0x00F6, -92 },
  { 0x0054, 0x00F2, -92 },
  { 0x0054, 0x0151, -92 },
  { 0x0054, 0x014D, -92 },
  { 0x0054, 0x00F8, -92 },
  { 0x0054, 0x00F5, -92 },
  { 0x0054, 0x002E, -90 },
  { 0x0054, 0x0072, -74 },
  { 0x0054, 0x0155, -74 },
  { 0x0054, 0x0159, -74 },
  { 0x0054, 0x0157, -74 },
  { 0x0054, 0x003B, -74 },
  { 0x0054, 0x0075, -92 },
  { 0x0054, 0x00FA, -92 },
  { 0x0054, 0x00FB, -92 },
  { 0x0054, 0x00FC, -92 },
  { 0x0054, 0x00F9, -92 },
  { 0x0054, 0x0171, -92 },
  { 0x0054, 0x016B, -92 },
  { 0x0054, 0x0173, -92 },
  { 0x0054, 0x016F, -92 },
  { 0x0054, 0x0077, -74 },
  { 0x0054, 0x0079, -34 },
  { 0x0054, 0x00FD, -34 },
  { 0x0054, 0x00FF, -34 },
  { 0x0164, 0x0041, -90 },
  { 0x0164, 0x00C1, -90 },
  { 0x0164, 0x0102, -90 },
  { 0x0164, 0x00C2, -90 },
  { 0x0164, 0x00C4, -90 },
  { 0x0164, 0x00C0, -90 },
  { 0x0164, 0x0100, -90 },
  { 0x0164, 0x0104, -90 },
  { 0x0164, 0x00C5, -90 },
  { 0x0164, 0x00C3, -90 },
  { 0x0164, 0x004F, -18 },
  { 0x0164, 0x00D3, -18 },
  { 0x0164, 0x00D4, -18 },
  { 0x0164, 0x00D6, -18 },
  { 0x0164, 0x00D2, -18 },
  { 0x0164, 0x0150, -18 },
  { 0x0164, 0x014C, -18 },
  { 0x0164, 0x00D8, -18 },
  { 0x0164, 0x00D5, -18 },
  { 0x0164, 0x0061, -92 },
  { 0x0164, 0x00E1, -92 },
  { 0x0164, 0x0103, -52 },
  { 0x0164, 0x00E2, -52 },
  { 0x0164, 0x00E4, -52 },
  { 0x0164, 0x00E0, -52 },
  { 0x0164, 0x0101, -52 },
  { 0x0164, 0x0105, -92 },
  { 0x0164, 0x00E5, -92 },
  { 0x0164, 0x00E3, -52 },
  { 0x0164, 0x003A, -74 },
  { 0x0164, 0x002C, -74 },
  { 0x0164, 0x0065, -92 },
  { 0x0164, 0x00E9, -92 },
  { 0x0164, 0x011B, -92 },
  { 0x0164, 0x00EA, -92 },
  { 0x0164, 0x00EB, -52 },
  { 0x0164, 0x0117, -92 },
  { 0x0164, 0x00E8, -52 },
  { 0x0164, 0x0113, -52 },
  { 0x0164, 0x0119, -92 },
  { 0x0164, 0x002D, -92 },
  { 0x0164, 0x0069, -18 },
  { 0x0164, 0x00ED, -18 },
  { 0x0164, 0x012F, -18 },
  { 0x0164, 0x006F, -92 },
  { 0x0164, 0x00F3, -92 },
  { 0x0164, 0x00F4, -92 },
  { 0x0164, 0x00F6, -92 },
  { 0x0164, 0x00F2, -92 },
  { 0x0164, 0x0151, -92 },
  { 0x0164, 0x014D, -92 },
  { 0x0164, 0x00F8, -92 },
  { 0x0164, 0x00F5, -92 },
  { 0x0164, 0x002E, -90 },
  { 0x0164, 0x0072, -74 },
  { 0x0164, 0x0155, -74 },
  { 0x0164, 0x0159, -74 },
  { 0x0164, 0x0157, -74 },
  { 0x0164, 0x003B, -74 },
  { 0x0164, 0x0075, -92 },
  { 0x0164, 0x00FA, -92 },
  { 0x0164, 0x00FB, -92 },
  { 0x0164, 0x00FC, -92 },
  { 0x0164, 0x00F9, -92 },
  { 0x0164, 0x0171, -92 },
  { 0x0164, 0x016B, -92 },
  { 0x0164, 0x0173, -92 },
  { 0x0164, 0x016F, -92 },
  { 0x0164, 0x0077, -74 },
  { 0x0164, 0x0079, -34 },
  { 0x0164, 0x00FD, -34 },
  { 0x0164, 0x00FF, -34 },
  { 0x0162, 0x0041, -90 },
  { 0x0162, 0x00C1, -90 },
  { 0x0162, 0x0102, -90 },
  { 0x0162, 0x00C2, -90 },
  { 0x0162, 0x00C4, -90 },
  { 0x0162, 0x00C0, -90 },
  { 0x0162, 0x0100, -90 },
  { 0x0162, 0x0104, -90 },
  { 0x0162, 0x00C5, -90 },
  { 0x0162, 0x00C3, -90 },
  { 0x0162, 0x004F, -18 },
  { 0x0162, 0x00D3, -18 },
  { 0x0162, 0x00D4, -18 },
  { 0x0162, 0x00D6, -18 },
  { 0x0162, 0x00D2, -18 },
  { 0x0162, 0x0150, -18 },
  { 0x0162, 0x014C, -18 },
  { 0x0162, 0x00D8, -18 },
  { 0x0162, 0x00D5, -18 },
  { 0x0162, 0x0061, -92 },
  { 0x0162, 0x00E1, -92 },
  { 0x0162, 0x0103, -52 },
  { 0x0162, 0x00E2, -52 },
  { 0x0162, 0x00E4, -52 },
  { 0x0162, 0x00E0, -52 },
  { 0x0162, 0x0101, -52 },
  { 0x0162, 0x0105, -92 },
  { 0x0162, 0x00E5, -92 },
  { 0x0162, 0x00E3, -52 },
  { 0x0162, 0x003A, -74 },
  { 0x0162, 0x002C, -74 },
  { 0x0162, 0x0065, -92 },
  { 0x0162, 0x00E9, -92 },
  { 0x0162, 0x011B, -92 },
  { 0x0162, 0x00EA, -92 },
  { 0x0162, 0x00EB, -52 },
  { 0x0162, 0x0117, -92 },
  { 0x0162, 0x00E8, -52 },
  { 0x0162, 0x0113, -52 },
  { 0x0162, 0x0119, -92 },
  { 0x0162, 0x002D, -92 },
  { 0x0162, 0x0069, -18 },
  { 0x0162, 0x00ED, -18 },
  { 0x0162, 0x012F, -18 },
  { 0x0162, 0x006F, -92 },
  { 0x0162, 0x00F3, -92 },
  { 0x0162, 0x00F4, -92 },
  { 0x0162, 0x00F6, -92 },
  { 0x0162, 0x00F2, -92 },
  { 0x0162, 0x0151, -92 },
  { 0x0162, 0x014D, -92 },
  { 0x0162, 0x00F8, -92 },
  { 0x0162, 0x00F5, -92 },
  { 0x0162, 0x002E, -90 },
  { 0x0162, 0x0072, -74 },
  { 0x0162, 0x0155, -74 },
  { 0x0162, 0x0159, -74 },
  { 0x0162, 0x0157, -74 },
  { 0x0162, 0x003B, -74 },
  { 0x0162, 0x0075, -92 },
  { 0x0162, 0x00FA, -92 },
  { 0x0162, 0x00FB, -92 },
  { 0x0162, 0x00FC, -92 },
  { 0x0162, 0x00F9, -92 },
  { 0x0162, 0x0171, -92 },
  { 0x0162, 0x016B, -92 },
  { 0x0162, 0x0173, -92 },
  { 0x0162, 0x016F, -92 },
  { 0x0162, 0x0077, -74 },
  { 0x0162, 0x0079, -34 },
  { 0x0162, 0x00FD, -34 },
  { 0x0162, 0x00FF, -34 },
  { 0x0055, 0x0041, -60 },
  { 0x0055, 0x00C1, -60 },
  { 0x0055, 0x0102, -60 },
  { 0x0055, 0x00C2, -60 },
  { 0x0055, 0x00C4, -60 },
  { 0x0055, 0x00C0, -60 },
  { 0x0055, 0x0100, -60 },
  { 0x0055, 0x0104, -60 },
  { 0x0055, 0x00C5, -60 },
  { 0x0055, 0x00C3, -60 },
  { 0x0055, 0x002C, -50 },
  { 0x0055, 0x002E, -50 },
  { 0x00DA, 0x0041, -60 },
  { 0x00DA, 0x00C1, -60 },
  { 0x00DA, 0x0102, -60 },
  { 0x00DA, 0x00C2, -60 },
  { 0x00DA, 0x00C4, -60 },
  { 0x00DA, 0x00C0, -60 },
  { 0x00DA, 0x0100, -60 },
  { 0x00DA, 0x0104, -60 },
  { 0x00DA, 0x00C5, -60 },
  { 0x00DA, 0x00C3, -60 },
  { 0x00DA, 0x002C, -50 },
  { 0x00DA, 0x002E, -50 },
  { 0x00DB, 0x0041, -60 },
  { 0x00DB, 0x00C1, -60 },
  { 0x00DB, 0x0102, -60 },
  { 0x00DB, 0x00C2, -60 },
  { 0x00DB, 0x00C4, -60 },
  { 0x00DB, 0x00C0, -60 },
  { 0x00DB, 0x0100, -60 },
  { 0x00DB, 0x0104, -60 },
  { 0x00DB, 0x00C5, -60 },
  { 0x00DB, 0x00C3, -60 },
  { 0x00DB, 0x002C, -50 },
  { 0x00DB, 0x002E, -50 },
  { 0x00DC, 0x0041, -60 },
  { 0x00DC, 0x00C1, -60 },
  { 0x00DC, 0x0102, -60 },
  { 0x00DC, 0x00C2, -60 },
  { 0x00DC, 0x00C4, -60 },
  { 0x00DC, 0x00C0, -60 },
  { 0x00DC, 0x0100, -60 },
  { 0x00DC, 0x0104, -60 },
  { 0x00DC, 0x00C5, -60 },
  { 0x00DC, 0x00C3, -60 },
  { 0x00DC, 0x002C, -50 },
  { 0x00DC, 0x002E, -50 },
  { 0x00D9, 0x0041, -60 },
  { 0x00D9, 0x00C1, -60 },
  { 0x00D9, 0x0102, -60 },
  { 0x00D9, 0x00C2, -60 },
  { 0x00D9, 0x00C4, -60 },
  { 0x00D9, 0x00C0, -60 },
  { 0x00D9, 0x0100, -60 },
  { 0x00D9, 0x0104, -60 },
  { 0x00D9, 0x00C5, -60 },
  { 0x00D9, 0x00C3, -60 },
  { 0x00D9, 0x002C, -50 },
  { 0x00D9, 0x002E, -50 },
  { 0x0170, 0x0041, -60 },
  { 0x0170, 0x00C1, -60 },
  { 0x0170, 0x0102, -60 },
  { 0x0170, 0x00C2, -60 },
  { 0x0170, 0x00C4, -60 },
  { 0x0170, 0x00C0, -60 },
  { 0x0170, 0x0100, -60 },
  { 0x0170, 0x0104, -60 },
  { 0x0170, 0x00C5, -60 },
  { 0x0170, 0x00C3, -60 },
  { 0x0170, 0x002C, -50 },
  { 0x0170, 0x002E, -50 },
  { 0x016A, 0x0041, -60 },
  { 0x016A, 0x00C1, -60 },
  { 0x016A, 0x0102, -60 },
  { 0x016A, 0x00C2, -60 },
  { 0x016A, 0x00C4, -60 },
  { 0x016A, 0x00C0, -60 },
  { 0x016A, 0x0100, -60 },
  { 0x016A, 0x0104, -60 },
  { 0x016A, 0x00C5, -60 },
  { 0x016A, 0x00C3, -60 },
  { 0x016A, 0x002C, -50 },
  { 0x016A, 0x002E, -50 },
  { 0x0172, 0x0041, -60 },
  { 0x0172, 0x00C1, -60 },
  { 0x0172, 0x0102, -60 },
  { 0x0172, 0x00C2, -60 },
  { 0x0172, 0x00C4, -60 },
  { 0x0172, 0x00C0, -60 },
  { 0x0172, 0x0100, -60 },
  { 0x0172, 0x0104, -60 },
  { 0x0172, 0x00C5, -60 },
  { 0x0172, 0x00C3, -60 },
  { 0x0172, 0x002C, -50 },
  { 0x0172, 0x002E, -50 },
  { 0x016E, 0x0041, -60 },
  { 0x016E, 0x00C1, -60 },
  { 0x016E, 0x0102, -60 },
  { 0x016E, 0x00C2, -60 },
  { 0x016E, 0x00C4, -60 },
  { 0x016E, 0x00C0, -60 },
  { 0x016E, 0x0100, -60 },
  { 0x016E, 0x0104, -60 },
  { 0x016E, 0x00C5, -60 },
  { 0x016E, 0x00C3, -60 },
  { 0x016E, 0x002C, -50 },
  { 0x016E, 0x002E, -50 },
  { 0x0056, 0x0041, -135 },
  { 0x0056, 0x00C1, -135 },
  { 0x0056, 0x0102, -135 },
  { 0x0056, 0x00C2, -135 },
  { 0x0056, 0x00C4, -135 },
  { 0x0056, 0x00C0, -135 },
  { 0x0056, 0x0100, -135 },
  { 0x0056, 0x0104, -135 },
  { 0x0056, 0x00C5, -135 },
  { 0x0056, 0x00C3, -135 },
  { 0x0056, 0x0047, -30 },
  { 0x0056, 0x011E, -30 },
  { 0x0056, 0x0122, -30 },
  { 0x0056, 0x004F, -45 },
  { 0x0056, 0x00D3, -45 },
  { 0x0056, 0x00D4, -45 },
  { 0x0056, 0x00D6, -45 },
  { 0x0056, 0x00D2, -45 },
  { 0x0056, 0x0150, -45 },
  { 0x0056, 0x014C, -45 },
  { 0x0056, 0x00D8, -45 },
  { 0x0056, 0x00D5, -45 },
  { 0x0056, 0x0061, -92 },
  { 0x0056, 0x00E1, -92 },
  { 0x0056, 0x0103, -92 },
  { 0x0056, 0x00E2, -92 },
  { 0x0056, 0x00E4, -92 },
  { 0x0056, 0x00E0, -92 },
  { 0x0056, 0x0101, -92 },
  { 0x0056, 0x0105, -92 },
  { 0x0056, 0x00E5, -92 },
  { 0x0056, 0x00E3, -92 },
  { 0x0056, 0x003A, -92 },
  { 0x0056, 0x002C, -129 },
  { 0x0056, 0x0065, -100 },
  { 0x0056, 0x00E9, -100 },
  { 0x0056, 0x011B, -100 },
  { 0x0056, 0x00EA, -100 },
  { 0x0056, 0x00EB, -100 },
  { 0x0056, 0x0117, -100 },
  { 0x0056, 0x00E8, -100 },
  { 0x0056, 0x0113, -100 },
  { 0x0056, 0x0119, -100 },
  { 0x0056, 0x002D, -74 },
  { 0x0056, 0x0069, -37 },
  { 0x0056, 0x00ED, -37 },
  { 0x0056, 0x00EE, -37 },
  { 0x0056, 0x00EF, -37 },
  { 0x0056, 0x00EC, -37 },
  { 0x0056, 0x012B, -37 },
  { 0x0056, 0x012F, -37 },
  { 0x0056, 0x006F, -100 },
  { 0x0056, 0x00F3, -100 },
  { 0x0056, 0x00F4, -100 },
  { 0x0056, 0x00F6, -100 },
  { 0x0056, 0x00F2, -100 },
  { 0x0056, 0x0151, -100 },
  { 0x0056, 0x014D, -100 },
  { 0x0056, 0x00F8, -100 },
  { 0x0056, 0x00F5, -100 },
  { 0x0056, 0x002E, -145 },
  { 0x0056, 0x003B, -92 },
  { 0x0056, 0x0075, -92 },
  { 0x0056, 0x00FA, -92 },
  { 0x0056, 0x00FB, -92 },
  { 0x0056, 0x00FC, -92 },
  { 0x0056, 0x00F9, -92 },
  { 0x0056, 0x0171, -92 },
  { 0x0056, 0x016B, -92 },
  { 0x0056, 0x0173, -92 },
  { 0x0056, 0x016F, -92 },
  { 0x0057, 0x0041, -120 },
  { 0x0057, 0x00C1, -120 },
  { 0x0057, 0x0102, -120 },
  { 0x0057, 0x00C2, -120 },
  { 0x0057, 0x00C4, -120 },
  { 0x0057, 0x00C0, -120 },
  { 0x0057, 0x0100, -120 },
  { 0x0057, 0x0104, -120 },
  { 0x0057, 0x00C5, -120 },
  { 0x0057, 0x00C3, -120 },
  { 0x0057, 0x004F, -10 },
  { 0x0057, 0x00D3, -10 },
  { 0x0057, 0x00D4, -10 },
  { 0x0057, 0x00D6, -10 },
  { 0x0057, 0x00D2, -10 },
  { 0x0057, 0x0150, -10 },
  { 0x0057, 0x014C, -10 },
  { 0x0057, 0x00D8, -10 },
  { 0x0057, 0x00D5, -10 },
  { 0x0057, 0x0061, -65 },
  { 0x0057, 0x00E1, -65 },
  { 0x0057, 0x0103, -65 },
  { 0x0057, 0x00E2, -65 },
  { 0x0057, 0x00E4, -65 },
  { 0x0057, 0x00E0, -65 },
  { 0x0057, 0x0101, -65 },
  { 0x0057, 0x0105, -65 },
  { 0x0057, 0x00E5, -65 },
  { 0x0057, 0x00E3, -65 },
  { 0x0057, 0x003A, -55 },
  { 0x0057, 0x002C, -92 },
  { 0x0057, 0x0065, -65 },
  { 0x0057, 0x00E9, -65 },
  { 0x0057, 0x011B, -65 },
  { 0x0057, 0x00EA, -65 },
  { 0x0057, 0x00EB, -65 },
  { 0x0057, 0x0117, -65 },
  { 0x0057, 0x00E8, -65 },
  { 0x0057, 0x0113, -65 },
  { 0x0057, 0x0119, -65 },
  { 0x0057, 0x002D, -37 },
  { 0x0057, 0x0069, -18 },
  { 0x0057, 0x00ED, -18 },
  { 0x0057, 0x012F, -18 },
  { 0x0057, 0x006F, -75 },
  { 0x0057, 0x00F3, -75 },
  { 0x0057, 0x00F4, -75 },
  { 0x0057, 0x00F6, -75 },
  { 0x0057, 0x00F2, -75 },
  { 0x0057, 0x0151, -75 },
  { 0x0057, 0x014D, -75 },
  { 0x0057, 0x00F8, -75 },
  { 0x0057, 0x00F5, -75 },
  { 0x0057, 0x002E, -92 },
  { 0x0057, 0x003B, -55 },
  { 0x0057, 0x0075, -50 },
  { 0x0057, 0x00FA, -50 },
  { 0x0057, 0x00FB, -50 },
  { 0x0057, 0x00FC, -50 },
  { 0x0057, 0x00F9, -50 },
  { 0x0057, 0x0171, -50 },
  { 0x0057, 0x016B, -50 },
  { 0x0057, 0x0173, -50 },
  { 0x0057, 0x016F, -50 },
  { 0x0057, 0x0079, -60 },
  { 0x0057, 0x00FD, -60 },
  { 0x0057, 0x00FF, -60 },
  { 0x0059, 0x0041, -110 },
  { 0x0059, 0x00C1, -110 },
  { 0x0059, 0x0102, -110 },
  { 0x0059, 0x00C2, -110 },
  { 0x0059, 0x00C4, -110 },
  { 0x0059, 0x00C0, -110 },
  { 0x0059, 0x0100, -110 },
  { 0x0059, 0x0104, -110 },
  { 0x0059, 0x00C5, -110 },
  { 0x0059, 0x00C3, -110 },
  { 0x0059, 0x004F, -35 },
  { 0x0059, 0x00D3, -35 },
  { 0x0059, 0x00D4, -35 },
  { 0x0059, 0x00D6, -35 },
  { 0x0059, 0x00D2, -35 },
  { 0x0059, 0x0150, -35 },
  { 0x0059, 0x014C, -35 },
  { 0x0059, 0x00D8, -35 },
  { 0x0059, 0x00D5, -35 },
  { 0x0059, 0x0061, -85 },
  { 0x0059, 0x00E1, -85 },
  { 0x0059, 0x0103, -85 },
  { 0x0059, 0x00E2, -85 },
  { 0x0059, 0x00E4, -85 },
  { 0x0059, 0x00E0, -85 },
  { 0x0059, 0x0101, -85 },
  { 0x0059, 0x0105, -85 },
  { 0x0059, 0x00E5, -85 },
  { 0x0059, 0x00E3, -85 },
  { 0x0059, 0x003A, -92 },
  { 0x0059, 0x002C, -92 },
  { 0x0059, 0x0065, -111 },
  { 0x0059, 0x00E9, -111 },
  { 0x0059, 0x011B, -111 },
  { 0x0059, 0x00EA, -111 },
  { 0x0059, 0x00EB, -71 },
  { 0x0059, 0x0117, -111 },
  { 0x0059, 0x00E8, -71 },
  { 0x0059, 0x0113, -71 },
  { 0x0059, 0x0119, -111 },
  { 0x0059, 0x002D, -92 },
  { 0x0059, 0x0069, -37 },
  { 0x0059, 0x00ED, -37 },
  { 0x0059, 0x012F, -37 },
  { 0x0059, 0x006F, -111 },
  { 0x0059, 0x00F3, -111 },
  { 0x0059, 0x00F4, -111 },
  { 0x0059, 0x00F6, -111 },
  { 0x0059, 0x00F2, -111 },
  { 0x0059, 0x0151, -111 },
  { 0x0059, 0x014D, -111 },
  { 0x0059, 0x00F8, -111 },
  { 0x0059, 0x00F5, -111 },
  { 0x0059, 0x002E, -92 },
  { 0x0059, 0x003B, -92 },
  { 0x0059, 0x0075, -92 },
  { 0x0059, 0x00FA, -92 },
  { 0x0059, 0x00FB, -92 },
  { 0x0059, 0x00FC, -92 },
  { 0x0059, 0x00F9, -92 },
  { 0x0059, 0x0171, -92 },
  { 0x0059, 0x016B, -92 },
  { 0x0059, 0x0173, -92 },
  { 0x0059, 0x016F, -92 },
  { 0x00DD, 0x0041, -110 },
  { 0x00DD, 0x00C1, -110 },
  { 0x00DD, 0x0102, -110 },
  { 0x00DD, 0x00C2, -110 },
  { 0x00DD, 0x00C4, -110 },
  { 0x00DD, 0x00C0, -110 },
  { 0x00DD, 0x0100, -110 },
  { 0x00DD, 0x0104, -110 },
  { 0x00DD, 0x00C5, -110 },
  { 0x00DD, 0x00C3, -110 },
  { 0x00DD, 0x004F, -35 },
  { 0x00DD, 0x00D3, -35 },
  { 0x00DD, 0x00D4, -35 },
  { 0x00DD, 0x00D6, -35 },
  { 0x00DD, 0x00D2, -35 },
  { 0x00DD, 0x0150, -35 },
  { 0x00DD, 0x014C, -35 },
  { 0x00DD, 0x00D8, -35 },
  { 0x00DD, 0x00D5, -35 },
  { 0x00DD, 0x0061, -85 },
  { 0x00DD, 0x00E1, -85 },
  { 0x00DD, 0x0103, -85 },
  { 0x00DD, 0x00E2, -85 },
  { 0x00DD, 0x00E4, -85 },
  { 0x00DD, 0x00E0, -85 },
  { 0x00DD, 0x0101, -85 },
  { 0x00DD, 0x0105, -85 },
  { 0x00DD, 0x00E5, -85 },
  { 0x00DD, 0x00E3, -85 },
  { 0x00DD, 0x003A, -92 },
  { 0x00DD, 0x002C, -92 },
  { 0x00DD, 0x0065, -111 },
  { 0x00DD, 0x00E9, -111 },
  { 0x00DD, 0x011B, -111 },
  { 0x00DD, 0x00EA, -111 },
  { 0x00DD, 0x00EB, -71 },
  { 0x00DD, 0x0117, -111 },
  { 0x00DD, 0x00E8, -71 },
  { 0x00DD, 0x0113, -71 },
  { 0x00DD, 0x0119, -111 },
  { 0x00DD, 0x002D, -92 },
  { 0x00DD, 0x0069, -37 },
  { 0x00DD, 0x00ED, -37 },
  { 0x00DD, 0x012F, -37 },
  { 0x00DD, 0x006F, -111 },
  { 0x00DD, 0x00F3, -111 },
  { 0x00DD, 0x00F4, -111 },
  { 0x00DD, 0x00F6, -111 },
  { 0x00DD, 0x00F2, -111 },
  { 0x00DD, 0x0151, -111 },
  { 0x00DD, 0x014D, -111 },
  { 0x00DD, 0x00F8, -111 },
  { 0x00DD, 0x00F5, -111 },
  { 0x00DD, 0x002E, -92 },
  { 0x00DD, 0x003B, -92 },
  { 0x00DD, 0x0075, -92 },
  { 0x00DD, 0x00FA, -92 },
  { 0x00DD, 0x00FB, -92 },
  { 0x00DD, 0x00FC, -92 },
  { 0x00DD, 0x00F9, -92 },
  { 0x00DD, 0x0171, -92 },
  { 0x00DD, 0x016B, -92 },
  { 0x00DD, 0x0173, -92 },
  { 0x00DD, 0x016F, -92 },
  { 0x0178, 0x0041, -110 },
  { 0x0178, 0x00C1, -110 },
  { 0x0178, 0x0102, -110 },
  { 0x0178, 0x00C2, -110 },
  { 0x0178, 0x00C4, -110 },
  { 0x0178, 0x00C0, -110 },
  { 0x0178, 0x0100, -110 },
  { 0x0178, 0x0104, -110 },
  { 0x0178, 0x00C5, -110 },
  { 0x0178, 0x00C3, -110 },
  { 0x0178, 0x004F, -35 },
  { 0x0178, 0x00D3, -35 },
  { 0x0178, 0x00D4, -35 },
  { 0x0178, 0x00D6, -35 },
  { 0x0178, 0x00D2, -35 },
  { 0x0178, 0x0150, -35 },
  { 0x0178, 0x014C, -35 },
  { 0x0178, 0x00D8, -35 },
  { 0x0178, 0x00D5, -35 },
  { 0x0178, 0x0061, -85 },
  { 0x0178, 0x00E1, -85 },
  { 0x0178, 0x0103, -85 },
  { 0x0178, 0x00E2, -85 },
  { 0x0178, 0x00E4, -85 },
  { 0x0178, 0x00E0, -85 },
  { 0x0178, 0x0101, -85 },
  { 0x0178, 0x0105, -85 },
  { 0x0178, 0x00E5, -85 },
  { 0x0178, 0x00E3, -85 },
  { 0x0178, 0x003A, -92 },
  { 0x0178, 0x002C, -92 },
  { 0x0178, 0x0065, -111 },
  { 0x0178, 0x00E9, -111 },
  { 0x0178, 0x011B, -111 },
  { 0x0178, 0x00EA, -111 },
  { 0x0178, 0x00EB, -71 },
  { 0x0178, 0x0117, -111 },
  { 0x0178, 0x00E8, -71 },
  { 0x0178, 0x0113, -71 },
  { 0x0178, 0x0119, -111 },
  { 0x0178, 0x002D, -92 },
  { 0x0178, 0x0069, -37 },
  { 0x0178, 0x00ED, -37 },
  { 0x0178, 0x012F, -37 },
  { 0x0178, 0x006F, -111 },
  { 0x0178, 0x00F3, -111 },
  { 0x0178, 0x00F4, -111 },
  { 0x0178, 0x00F6, -111 },
  { 0x0178, 0x00F2, -111 },
  { 0x0178, 0x0151, -111 },
  { 0x0178, 0x014D, -111 },
  { 0x0178, 0x00F8, -111 },
  { 0x0178, 0x00F5, -111 },
  { 0x0178, 0x002E, -92 },
  { 0x0178, 0x003B, -92 },
  { 0x0178, 0x0075, -92 },
  { 0x0178, 0x00FA, -92 },
  { 0x0178, 0x00FB, -92 },
  { 0x0178, 0x00FC, -92 },
  { 0x0178, 0x00F9, -92 },
  { 0x0178, 0x0171, -92 },
  { 0x0178, 0x016B, -92 },
  { 0x0178, 0x0173, -92 },
  { 0x0178, 0x016F, -92 },
  { 0x0061, 0x0076, -25 },
  { 0x00E1, 0x0076, -25 },
  { 0x0103, 0x0076, -25 },
  { 0x00E2, 0x0076, -25 },
  { 0x00E4, 0x0076, -25 },
  { 0x00E0, 0x0076, -25 },
  { 0x0101, 0x0076, -25 },
  { 0x0105, 0x0076, -25 },
  { 0x00E5, 0x0076, -25 },
  { 0x00E3, 0x0076, -25 },
  { 0x0062, 0x0062, -10 },
  { 0x0062, 0x002E, -40 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0062, 0x0076, -15 },
  { 0x002C, 0x201D, -45 },
  { 0x002C, 0x2019, -55 },
  { 0x0064, 0x0077, -15 },
  { 0x0111, 0x0077, -15 },
  { 0x0065, 0x0076, -15 },
  { 0x00E9, 0x0076, -15 },
  { 0x011B, 0x0076, -15 },
  { 0x00EA, 0x0076, -15 },
  { 0x00EB, 0x0076, -15 },
  { 0x0117, 0x0076, -15 },
  { 0x00E8, 0x0076, -15 },
  { 0x0113, 0x0076, -15 },
  { 0x0119, 0x0076, -15 },
  { 0x0066, 0x002C, -15 },
  { 0x0066, 0x0131, -35 },
  { 0x0066, 0x0069, -25 },
  { 0x0066, 0x006F, -25 },
  { 0x0066, 0x00F3, -25 },
  { 0x0066, 0x00F4, -25 },
  { 0x0066, 0x00F6, -25 },
  { 0x0066, 0x00F2, -25 },
  { 0x0066, 0x0151, -25 },
  { 0x0066, 0x014D, -25 },
  { 0x0066, 0x00F8, -25 },
  { 0x0066, 0x00F5, -25 },
  { 0x0066, 0x002E, -15 },
  { 0x0066, 0x201D, 50 },
  { 0x0066, 0x2019, 55 },
  { 0x0067, 0x002E, -15 },
  { 0x011F, 0x002E, -15 },
  { 0x0123, 0x002E, -15 },
  { 0x0068, 0x0079, -15 },
  { 0x0068, 0x00FD, -15 },
  { 0x0068, 0x00FF, -15 },
  { 0x0069, 0x0076, -10 },
  { 0x00ED, 0x0076, -10 },
  { 0x00EE, 0x0076, -10 },
  { 0x00EF, 0x0076, -10 },
  { 0x00EC, 0x0076, -10 },
  { 0x012B, 0x0076, -10 },
  { 0x012F, 0x0076, -10 },
  { 0x006B, 0x0065, -10 },
  { 0x006B, 0x00E9, -10 },
  { 0x006B, 0x011B, -10 },
  { 0x006B, 0x00EA, -10 },
  { 0x006B, 0x00EB, -10 },
  { 0x006B, 0x0117, -10 },
  { 0x006B, 0x00E8, -10 },
  { 0x006B, 0x0113, -10 },
  { 0x006B, 0x0119, -10 },
  { 0x006B, 0x006F, -15 },
  { 0x006B, 0x00F3, -15 },
  { 0x006B, 0x00F4, -15 },
  { 0x006B, 0x00F6, -15 },
  { 0x006B, 0x00F2, -15 },
  { 0x006B, 0x0151, -15 },
  { 0x006B, 0x014D, -15 },
  { 0x006B, 0x00F8, -15 },
  { 0x006B, 0x00F5, -15 },
  { 0x006B, 0x0079, -15 },
  { 0x006B, 0x00FD, -15 },
  { 0x006B, 0x00FF, -15 },
  { 0x0137, 0x0065, -10 },
  { 0x0137, 0x00E9, -10 },
  { 0x0137, 0x011B, -10 },
  { 0x0137, 0x00EA, -10 },
  { 0x0137, 0x00EB, -10 },
  { 0x0137, 0x0117, -10 },
  { 0x0137, 0x00E8, -10 },
  { 0x0137, 0x0113, -10 },
  { 0x0137, 0x0119, -10 },
  { 0x0137, 0x006F, -15 },
  { 0x0137, 0x00F3, -15 },
  { 0x0137, 0x00F4, -15 },
  { 0x0137, 0x00F6, -15 },
  { 0x0137, 0x00F2, -15 },
  { 0x0137, 0x0151, -15 },
  { 0x0137, 0x014D, -15 },
  { 0x0137, 0x00F8, -15 },
  { 0x0137, 0x00F5, -15 },
  { 0x0137, 0x0079, -15 },
  { 0x0137, 0x00FD, -15 },
  { 0x0137, 0x00FF, -15 },
  { 0x006E, 0x0076, -40 },
  { 0x0144, 0x0076, -40 },
  { 0x0148, 0x0076, -40 },
  { 0x0146, 0x0076, -40 },
  { 0x00F1, 0x0076, -40 },
  { 0x006F, 0x0076, -10 },
  { 0x006F, 0x0077, -10 },
  { 0x00F3, 0x0076, -10 },
  { 0x00F3, 0x0077, -10 },
  { 0x00F4, 0x0076, -10 },
  { 0x00F4, 0x0077, -10 },
  { 0x00F6, 0x0076, -10 },
  { 0x00F6, 0x0077, -10 },
  { 0x00F2, 0x0076, -10 },
  { 0x00F2, 0x0077, -10 },
  { 0x0151, 0x0076, -10 },
  { 0x0151, 0x0077, -10 },
  { 0x014D, 0x0076, -10 },
  { 0x014D, 0x0077, -10 },
  { 0x00F8, 0x0076, -10 },
  { 0x00F8, 0x0077, -10 },
  { 0x00F5, 0x0076, -10 },
  { 0x00F5, 0x0077, -10 },
  { 0x002E, 0x201D, -55 },
  { 0x002E, 0x2019, -55 },
  { 0x201C, 0x0041, -10 },
  { 0x201C, 0x00C1, -10 },
  { 0x201C, 0x0102, -10 },
  { 0x201C, 0x00C2, -10 },
  { 0x201C, 0x00C4, -10 },
  { 0x201C, 0x00C0, -10 },
  { 0x201C, 0x0100, -10 },
  { 0x201C, 0x0104, -10 },
  { 0x201C, 0x00C5, -10 },
  { 0x201C, 0x00C3, -10 },
  { 0x2018, 0x0041, -10 },
  { 0x2018, 0x00C1, -10 },
  { 0x2018, 0x0102, -10 },
  { 0x2018, 0x00C2, -10 },
  { 0x2018, 0x00C4, -10 },
  { 0x2018, 0x00C0, -10 },
  { 0x2018, 0x0100, -10 },
  { 0x2018, 0x0104, -10 },
  { 0x2018, 0x00C5, -10 },
  { 0x2018, 0x00C3, -10 },
  { 0x2018, 0x2018, -63 },
  { 0x2019, 0x0064, -20 },
  { 0x2019, 0x0111, -20 },
  { 0x2019, 0x2019, -63 },
  { 0x2019, 0x0072, -20 },
  { 0x2019, 0x0155, -20 },
  { 0x2019, 0x0159, -20 },
  { 0x2019, 0x0157, -20 },
  { 0x2019, 0x0073, -37 },
  { 0x2019, 0x015B, -37 },
  { 0x2019, 0x0161, -37 },
  { 0x2019, 0x015F, -37 },
  { 0x2019, 0x0219, -37 },
  { 0x2019, 0x0020, -74 },
  { 0x2019, 0x0076, -20 },
  { 0x0072, 0x0063, -18 },
  { 0x0072, 0x0107, -18 },
  { 0x0072, 0x010D, -18 },
  { 0x0072, 0x00E7, -18 },
  { 0x0072, 0x002C, -92 },
  { 0x0072, 0x0065, -18 },
  { 0x0072, 0x00E9, -18 },
  { 0x0072, 0x011B, -18 },
  { 0x0072, 0x00EA, -18 },
  { 0x0072, 0x00EB, -18 },
  { 0x0072, 0x0117, -18 },
  { 0x0072, 0x00E8, -18 },
  { 0x0072, 0x0113, -18 },
  { 0x0072, 0x0119, -18 },
  { 0x0072, 0x0067, -10 },
  { 0x0072, 0x011F, -10 },
  { 0x0072, 0x0123, -10 },
  { 0x0072, 0x002D, -37 },
  { 0x0072, 0x006E, -15 },
  { 0x0072, 0x0144, -15 },
  { 0x0072, 0x0148, -15 },
  { 0x0072, 0x0146, -15 },
  { 0x0072, 0x00F1, -15 },
  { 0x0072, 0x006F, -18 },
  { 0x0072, 0x00F3, -18 },
  { 0x0072, 0x00F4, -18 },
  { 0x0072, 0x00F6, -18 },
  { 0x0072, 0x00F2, -18 },
  { 0x0072, 0x0151, -18 },
  { 0x0072, 0x014D, -18 },
  { 0x0072, 0x00F8, -18 },
  { 0x0072, 0x00F5, -18 },
  { 0x0072, 0x0070, -10 },
  { 0x0072, 0x002E, -100 },
  { 0x0072, 0x0071, -18 },
  { 0x0072, 0x0076, -10 },
  { 0x0155, 0x0063, -18 },
  { 0x0155, 0x0107, -18 },
  { 0x0155, 0x010D, -18 },
  { 0x0155, 0x00E7, -18 },
  { 0x0155, 0x002C, -92 },
  { 0x0155, 0x0065, -18 },
  { 0x0155, 0x00E9, -18 },
  { 0x0155, 0x011B, -18 },
  { 0x0155, 0x00EA, -18 },
  { 0x0155, 0x00EB, -18 },
  { 0x0155, 0x0117, -18 },
  { 0x0155, 0x00E8, -18 },
  { 0x0155, 0x0113, -18 },
  { 0x0155, 0x0119, -18 },
  { 0x0155, 0x0067, -10 },
  { 0x0155, 0x011F, -10 },
  { 0x0155, 0x0123, -10 },
  { 0x0155, 0x002D, -37 },
  { 0x0155, 0x006E, -15 },
  { 0x0155, 0x0144, -15 },
  { 0x0155, 0x0148, -15 },
  { 0x0155, 0x0146, -15 },
  { 0x0155, 0x00F1, -15 },
  { 0x0155, 0x006F, -18 },
  { 0x0155, 0x00F3, -18 },
  { 0x0155, 0x00F4, -18 },
  { 0x0155, 0x00F6, -18 },
  { 0x0155, 0x00F2, -18 },
  { 0x0155, 0x0151, -18 },
  { 0x0155, 0x014D, -18 },
  { 0x0155, 0x00F8, -18 },
  { 0x0155, 0x00F5, -18 },
  { 0x0155, 0x0070, -10 },
  { 0x0155, 0x002E, -100 },
  { 0x0155, 0x0071, -18 },
  { 0x0155, 0x0076, -10 },
  { 0x0159, 0x0063, -18 },
  { 0x0159, 0x0107, -18 },
  { 0x0159, 0x010D, -18 },
  { 0x0159, 0x00E7, -18 },
  { 0x0159, 0x002C, -92 },
  { 0x0159, 0x0065, -18 },
  { 0x0159, 0x00E9, -18 },
  { 0x0159, 0x011B, -18 },
  { 0x0159, 0x00EA, -18 },
  { 0x0159, 0x00EB, -18 },
  { 0x0159, 0x0117, -18 },
  { 0x0159, 0x00E8, -18 },
  { 0x0159, 0x0113, -18 },
  { 0x0159, 0x0119, -18 },
  { 0x0159, 0x0067, -10 },
  { 0x0159, 0x011F, -10 },
  { 0x0159, 0x0123, -10 },
  { 0x0159, 0x002D, -37 },
  { 0x0159, 0x006E, -15 },
  { 0x0159, 0x0144, -15 },
  { 0x0159, 0x0148, -15 },
  { 0x0159, 0x0146, -15 },
  { 0x0159, 0x00F1, -15 },
  { 0x0159, 0x006F, -18 },
  { 0x0159, 0x00F3, -18 },
  { 0x0159, 0x00F4, -18 },
  { 0x0159, 0x00F6, -18 },
  { 0x0159, 0x00F2, -18 },
  { 0x0159, 0x0151, -18 },
  { 0x0159, 0x014D, -18 },
  { 0x0159, 0x00F8, -18 },
  { 0x0159, 0x00F5, -18 },
  { 0x0159, 0x0070, -10 },
  { 0x0159, 0x002E, -100 },
  { 0x0159, 0x0071, -18 },
  { 0x0159, 0x0076, -10 },
  { 0x0157, 0x0063, -18 },
  { 0x0157, 0x0107, -18 },
  { 0x0157, 0x010D, -18 },
  { 0x0157, 0x00E7, -18 },
  { 0x0157, 0x002C, -92 },
  { 0x0157, 0x0065, -18 },
  { 0x0157, 0x00E9, -18 },
  { 0x0157, 0x011B, -18 },
  { 0x0157, 0x00EA, -18 },
  { 0x0157, 0x00EB, -18 },
  { 0x0157, 0x0117, -18 },
  { 0x0157, 0x00E8, -18 },
  { 0x0157, 0x0113, -18 },
  { 0x0157, 0x0119, -18 },
  { 0x0157, 0x0067, -10 },
  { 0x0157, 0x011F, -10 },
  { 0x0157, 0x0123, -10 },
  { 0x0157, 0x002D, -37 },
  { 0x0157, 0x006E, -15 },
  { 0x0157, 0x0144, -15 },
  { 0x0157, 0x0148, -15 },
  { 0x0157, 0x0146, -15 },
  { 0x0157, 0x00F1, -15 },
  { 0x0157, 0x006F, -18 },
  { 0x0157, 0x00F3, -18 },
  { 0x0157, 0x00F4, -18 },
  { 0x0157, 0x00F6, -18 },
  { 0x0157, 0x00F2, -18 },
  { 0x0157, 0x0151, -18 },
  { 0x0157, 0x014D, -18 },
  { 0x0157, 0x00F8, -18 },
  { 0x0157, 0x00F5, -18 },
  { 0x0157, 0x0070, -10 },
  { 0x0157, 0x002E, -100 },
  { 0x0157, 0x0071, -18 },
  { 0x0157, 0x0076, -10 },
  { 0x0020, 0x0041, -55 },
  { 0x0020, 0x00C1, -55 },
  { 0x0020, 0x0102, -55 },
  { 0x0020, 0x00C2, -55 },
  { 0x0020, 0x00C4, -55 },
  { 0x0020, 0x00C0, -55 },
  { 0x0020, 0x0100, -55 },
  { 0x0020, 0x0104, -55 },
  { 0x0020, 0x00C5, -55 },
  { 0x0020, 0x00C3, -55 },
  { 0x0020, 0x0054, -30 },
  { 0x0020, 0x0164, -30 },
  { 0x0020, 0x0162, -30 },
  { 0x0020, 0x0056, -45 },
  { 0x0020, 0x0057, -30 },
  { 0x0020, 0x0059, -55 },
  { 0x0020, 0x00DD, -55 },
  { 0x0020, 0x0178, -55 },
  { 0x0076, 0x0061, -10 },
  { 0x0076, 0x00E1, -10 },
  { 0x0076, 0x0103, -10 },
  { 0x0076, 0x00E2, -10 },
  { 0x0076, 0x00E4, -10 },
  { 0x0076, 0x00E0, -10 },
  { 0x0076, 0x0101, -10 },
  { 0x0076, 0x0105, -10 },
  { 0x0076, 0x00E5, -10 },
  { 0x0076, 0x00E3, -10 },
  { 0x0076, 0x002C, -55 },
  { 0x0076, 0x0065, -10 },
  { 0x0076, 0x00E9, -10 },
  { 0x0076, 0x011B, -10 },
  { 0x0076, 0x00EA, -10 },
  { 0x0076, 0x00EB, -10 },
  { 0x0076, 0x0117, -10 },
  { 0x0076, 0x00E8, -10 },
  { 0x0076, 0x0113, -10 },
  { 0x0076, 0x0119, -10 },
  { 0x0076, 0x006F, -10 },
  { 0x0076, 0x00F3, -10 },
  { 0x0076, 0x00F4, -10 },
  { 0x0076, 0x00F6, -10 },
  { 0x0076, 0x00F2, -10 },
  { 0x0076, 0x0151, -10 },
  { 0x0076, 0x014D, -10 },
  { 0x0076, 0x00F8, -10 },
  { 0x0076, 0x00F5, -10 },
  { 0x0076, 0x002E, -70 },
  { 0x0077, 0x002C, -55 },
  { 0x0077, 0x006F, -10 },
  { 0x0077, 0x00F3, -10 },
  { 0x0077, 0x00F4, -10 },
  { 0x0077, 0x00F6, -10 },
  { 0x0077, 0x00F2, -10 },
  { 0x0077, 0x0151, -10 },
  { 0x0077, 0x014D, -10 },
  { 0x0077, 0x00F8, -10 },
  { 0x0077, 0x00F5, -10 },
  { 0x0077, 0x002E, -70 },
  { 0x0079, 0x002C, -55 },
  { 0x0079, 0x0065, -10 },
  { 0x0079, 0x00E9, -10 },
  { 0x0079, 0x011B, -10 },
  { 0x0079, 0x00EA, -10 },
  { 0x0079, 0x00EB, -10 },
  { 0x0079, 0x0117, -10 },
  { 0x0079, 0x00E8, -10 },
  { 0x0079, 0x0113, -10 },
  { 0x0079, 0x0119, -10 },
  { 0x0079, 0x006F, -25 },
  { 0x0079, 0x00F3, -25 },
  { 0x0079, 0x00F4, -25 },
  { 0x0079, 0x00F6, -25 },
  { 0x0079, 0x00F2, -25 },
  { 0x0079, 0x0151, -25 },
  { 0x0079, 0x014D, -25 },
  { 0x0079, 0x00F8, -25 },
  { 0x0079, 0x00F5, -25 },
  { 0x0079, 0x002E, -70 },
  { 0x00FD, 0x002C, -55 },
  { 0x00FD, 0x0065, -10 },
  { 0x00FD, 0x00E9, -10 },
  { 0x00FD, 0x011B, -10 },
  { 0x00FD, 0x00EA, -10 },
  { 0x00FD, 0x00EB, -10 },
  { 0x00FD, 0x0117, -10 },
  { 0x00FD, 0x00E8, -10 },
  { 0x00FD, 0x0113, -10 },
  { 0x00FD, 0x0119, -10 },
  { 0x00FD, 0x006F, -25 },
  { 0x00FD, 0x00F3, -25 },
  { 0x00FD, 0x00F4, -25 },
  { 0x00FD, 0x00F6, -25 },
  { 0x00FD, 0x00F2, -25 },
  { 0x00FD, 0x0151, -25 },
  { 0x00FD, 0x014D, -25 },
  { 0x00FD, 0x00F8, -25 },
  { 0x00FD, 0x00F5, -25 },
  { 0x00FD, 0x002E, -70 },
  { 0x00FF, 0x002C, -55 },
  { 0x00FF, 0x0065, -10 },
  { 0x00FF, 0x00E9, -10 },
  { 0x00FF, 0x011B, -10 },
  { 0x00FF, 0x00EA, -10 },
  { 0x00FF, 0x00EB, -10 },
  { 0x00FF, 0x0117, -10 },
  { 0x00FF, 0x00E8, -10 },
  { 0x00FF, 0x0113, -10 },
  { 0x00FF, 0x0119, -10 },
  { 0x00FF, 0x006F, -25 },
  { 0x00FF, 0x00F3, -25 },
  { 0x00FF, 0x00F4, -25 },
  { 0x00FF, 0x00F6, -25 },
  { 0x00FF, 0x00F2, -25 },
  { 0x00FF, 0x0151, -25 },
  { 0x00FF, 0x014D, -25 },
  { 0x00FF, 0x00F8, -25 },
  { 0x00FF, 0x00F5, -25 },
  { 0x00FF, 0x002E, -70 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableTimesBoldItalic[] =
{
  { 0x0041, 0x0043, -65 },
  { 0x0041, 0x0106, -65 },
  { 0x0041, 0x010C, -65 },
  { 0x0041, 0x00C7, -65 },
  { 0x0041, 0x0047, -60 },
  { 0x0041, 0x011E, -60 },
  { 0x0041, 0x0122, -60 },
  { 0x0041, 0x004F, -50 },
  { 0x0041, 0x00D3, -50 },
  { 0x0041, 0x00D4, -50 },
  { 0x0041, 0x00D6, -50 },
  { 0x0041, 0x00D2, -50 },
  { 0x0041, 0x0150, -50 },
  { 0x0041, 0x014C, -50 },
  { 0x0041, 0x00D8, -50 },
  { 0x0041, 0x00D5, -50 },
  { 0x0041, 0x0051, -55 },
  { 0x0041, 0x0054, -55 },
  { 0x0041, 0x0164, -55 },
  { 0x0041, 0x0162, -55 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -95 },
  { 0x0041, 0x0057, -100 },
  { 0x0041, 0x0059, -70 },
  { 0x0041, 0x00DD, -70 },
  { 0x0041, 0x0178, -70 },
  { 0x0041, 0x2019, -74 },
  { 0x0041, 0x0075, -30 },
  { 0x0041, 0x00FA, -30 },
  { 0x0041, 0x00FB, -30 },
  { 0x0041, 0x00FC, -30 },
  { 0x0041, 0x00F9, -30 },
  { 0x0041, 0x0171, -30 },
  { 0x0041, 0x016B, -30 },
  { 0x0041, 0x0173, -30 },
  { 0x0041, 0x016F, -30 },
  { 0x0041, 0x0076, -74 },
  { 0x0041, 0x0077, -74 },
  { 0x0041, 0x0079, -74 },
  { 0x0041, 0x00FD, -74 },
  { 0x0041, 0x00FF, -74 },
  { 0x00C1, 0x0043, -65 },
  { 0x00C1, 0x0106, -65 },
  { 0x00C1, 0x010C, -65 },
  { 0x00C1, 0x00C7, -65 },
  { 0x00C1, 0x0047, -60 },
  { 0x00C1, 0x011E, -60 },
  { 0x00C1, 0x0122, -60 },
  { 0x00C1, 0x004F, -50 },
  { 0x00C1, 0x00D3, -50 },
  { 0x00C1, 0x00D4, -50 },
  { 0x00C1, 0x00D6, -50 },
  { 0x00C1, 0x00D2, -50 },
  { 0x00C1, 0x0150, -50 },
  { 0x00C1, 0x014C, -50 },
  { 0x00C1, 0x00D8, -50 },
  { 0x00C1, 0x00D5, -50 },
  { 0x00C1, 0x0051, -55 },
  { 0x00C1, 0x0054, -55 },
  { 0x00C1, 0x0164, -55 },
  { 0x00C1, 0x0162, -55 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -95 },
  { 0x00C1, 0x0057, -100 },
  { 0x00C1, 0x0059, -70 },
  { 0x00C1, 0x00DD, -70 },
  { 0x00C1, 0x0178, -70 },
  { 0x00C1, 0x2019, -74 },
  { 0x00C1, 0x0075, -30 },
  { 0x00C1, 0x00FA, -30 },
  { 0x00C1, 0x00FB, -30 },
  { 0x00C1, 0x00FC, -30 },
  { 0x00C1, 0x00F9, -30 },
  { 0x00C1, 0x0171, -30 },
  { 0x00C1, 0x016B, -30 },
  { 0x00C1, 0x0173, -30 },
  { 0x00C1, 0x016F, -30 },
  { 0x00C1, 0x0076, -74 },
  { 0x00C1, 0x0077, -74 },
  { 0x00C1, 0x0079, -74 },
  { 0x00C1, 0x00FD, -74 },
  { 0x00C1, 0x00FF, -74 },
  { 0x0102, 0x0043, -65 },
  { 0x0102, 0x0106, -65 },
  { 0x0102, 0x010C, -65 },
  { 0x0102, 0x00C7, -65 },
  { 0x0102, 0x0047, -60 },
  { 0x0102, 0x011E, -60 },
  { 0x0102, 0x0122, -60 },
  { 0x0102, 0x004F, -50 },
  { 0x0102, 0x00D3, -50 },
  { 0x0102, 0x00D4, -50 },
  { 0x0102, 0x00D6, -50 },
  { 0x0102, 0x00D2, -50 },
  { 0x0102, 0x0150, -50 },
  { 0x0102, 0x014C, -50 },
  { 0x0102, 0x00D8, -50 },
  { 0x0102, 0x00D5, -50 },
  { 0x0102, 0x0051, -55 },
  { 0x0102, 0x0054, -55 },
  { 0x0102, 0x0164, -55 },
  { 0x0102, 0x0162, -55 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -95 },
  { 0x0102, 0x0057, -100 },
  { 0x0102, 0x0059, -70 },
  { 0x0102, 0x00DD, -70 },
  { 0x0102, 0x0178, -70 },
  { 0x0102, 0x2019, -74 },
  { 0x0102, 0x0075, -30 },
  { 0x0102, 0x00FA, -30 },
  { 0x0102, 0x00FB, -30 },
  { 0x0102, 0x00FC, -30 },
  { 0x0102, 0x00F9, -30 },
  { 0x0102, 0x0171, -30 },
  { 0x0102, 0x016B, -30 },
  { 0x0102, 0x0173, -30 },
  { 0x0102, 0x016F, -30 },
  { 0x0102, 0x0076, -74 },
  { 0x0102, 0x0077, -74 },
  { 0x0102, 0x0079, -74 },
  { 0x0102, 0x00FD, -74 },
  { 0x0102, 0x00FF, -74 },
  { 0x00C2, 0x0043, -65 },
  { 0x00C2, 0x0106, -65 },
  { 0x00C2, 0x010C, -65 },
  { 0x00C2, 0x00C7, -65 },
  { 0x00C2, 0x0047, -60 },
  { 0x00C2, 0x011E, -60 },
  { 0x00C2, 0x0122, -60 },
  { 0x00C2, 0x004F, -50 },
  { 0x00C2, 0x00D3, -50 },
  { 0x00C2, 0x00D4, -50 },
  { 0x00C2, 0x00D6, -50 },
  { 0x00C2, 0x00D2, -50 },
  { 0x00C2, 0x0150, -50 },
  { 0x00C2, 0x014C, -50 },
  { 0x00C2, 0x00D8, -50 },
  { 0x00C2, 0x00D5, -50 },
  { 0x00C2, 0x0051, -55 },
  { 0x00C2, 0x0054, -55 },
  { 0x00C2, 0x0164, -55 },
  { 0x00C2, 0x0162, -55 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -95 },
  { 0x00C2, 0x0057, -100 },
  { 0x00C2, 0x0059, -70 },
  { 0x00C2, 0x00DD, -70 },
  { 0x00C2, 0x0178, -70 },
  { 0x00C2, 0x2019, -74 },
  { 0x00C2, 0x0075, -30 },
  { 0x00C2, 0x00FA, -30 },
  { 0x00C2, 0x00FB, -30 },
  { 0x00C2, 0x00FC, -30 },
  { 0x00C2, 0x00F9, -30 },
  { 0x00C2, 0x0171, -30 },
  { 0x00C2, 0x016B, -30 },
  { 0x00C2, 0x0173, -30 },
  { 0x00C2, 0x016F, -30 },
  { 0x00C2, 0x0076, -74 },
  { 0x00C2, 0x0077, -74 },
  { 0x00C2, 0x0079, -74 },
  { 0x00C2, 0x00FD, -74 },
  { 0x00C2, 0x00FF, -74 },
  { 0x00C4, 0x0043, -65 },
  { 0x00C4, 0x0106, -65 },
  { 0x00C4, 0x010C, -65 },
  { 0x00C4, 0x00C7, -65 },
  { 0x00C4, 0x0047, -60 },
  { 0x00C4, 0x011E, -60 },
  { 0x00C4, 0x0122, -60 },
  { 0x00C4, 0x004F, -50 },
  { 0x00C4, 0x00D3, -50 },
  { 0x00C4, 0x00D4, -50 },
  { 0x00C4, 0x00D6, -50 },
  { 0x00C4, 0x00D2, -50 },
  { 0x00C4, 0x0150, -50 },
  { 0x00C4, 0x014C, -50 },
  { 0x00C4, 0x00D8, -50 },
  { 0x00C4, 0x00D5, -50 },
  { 0x00C4, 0x0051, -55 },
  { 0x00C4, 0x0054, -55 },
  { 0x00C4, 0x0164, -55 },
  { 0x00C4, 0x0162, -55 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -95 },
  { 0x00C4, 0x0057, -100 },
  { 0x00C4, 0x0059, -70 },
  { 0x00C4, 0x00DD, -70 },
  { 0x00C4, 0x0178, -70 },
  { 0x00C4, 0x2019, -74 },
  { 0x00C4, 0x0075, -30 },
  { 0x00C4, 0x00FA, -30 },
  { 0x00C4, 0x00FB, -30 },
  { 0x00C4, 0x00FC, -30 },
  { 0x00C4, 0x00F9, -30 },
  { 0x00C4, 0x0171, -30 },
  { 0x00C4, 0x016B, -30 },
  { 0x00C4, 0x0173, -30 },
  { 0x00C4, 0x016F, -30 },
  { 0x00C4, 0x0076, -74 },
  { 0x00C4, 0x0077, -74 },
  { 0x00C4, 0x0079, -74 },
  { 0x00C4, 0x00FD, -74 },
  { 0x00C4, 0x00FF, -74 },
  { 0x00C0, 0x0043, -65 },
  { 0x00C0, 0x0106, -65 },
  { 0x00C0, 0x010C, -65 },
  { 0x00C0, 0x00C7, -65 },
  { 0x00C0, 0x0047, -60 },
  { 0x00C0, 0x011E, -60 },
  { 0x00C0, 0x0122, -60 },
  { 0x00C0, 0x004F, -50 },
  { 0x00C0, 0x00D3, -50 },
  { 0x00C0, 0x00D4, -50 },
  { 0x00C0, 0x00D6, -50 },
  { 0x00C0, 0x00D2, -50 },
  { 0x00C0, 0x0150, -50 },
  { 0x00C0, 0x014C, -50 },
  { 0x00C0, 0x00D8, -50 },
  { 0x00C0, 0x00D5, -50 },
  { 0x00C0, 0x0051, -55 },
  { 0x00C0, 0x0054, -55 },
  { 0x00C0, 0x0164, -55 },
  { 0x00C0, 0x0162, -55 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -95 },
  { 0x00C0, 0x0057, -100 },
  { 0x00C0, 0x0059, -70 },
  { 0x00C0, 0x00DD, -70 },
  { 0x00C0, 0x0178, -70 },
  { 0x00C0, 0x2019, -74 },
  { 0x00C0, 0x0075, -30 },
  { 0x00C0, 0x00FA, -30 },
  { 0x00C0, 0x00FB, -30 },
  { 0x00C0, 0x00FC, -30 },
  { 0x00C0, 0x00F9, -30 },
  { 0x00C0, 0x0171, -30 },
  { 0x00C0, 0x016B, -30 },
  { 0x00C0, 0x0173, -30 },
  { 0x00C0, 0x016F, -30 },
  { 0x00C0, 0x0076, -74 },
  { 0x00C0, 0x0077, -74 },
  { 0x00C0, 0x0079, -74 },
  { 0x00C0, 0x00FD, -74 },
  { 0x00C0, 0x00FF, -74 },
  { 0x0100, 0x0043, -65 },
  { 0x0100, 0x0106, -65 },
  { 0x0100, 0x010C, -65 },
  { 0x0100, 0x00C7, -65 },
  { 0x0100, 0x0047, -60 },
  { 0x0100, 0x011E, -60 },
  { 0x0100, 0x0122, -60 },
  { 0x0100, 0x004F, -50 },
  { 0x0100, 0x00D3, -50 },
  { 0x0100, 0x00D4, -50 },
  { 0x0100, 0x00D6, -50 },
  { 0x0100, 0x00D2, -50 },
  { 0x0100, 0x0150, -50 },
  { 0x0100, 0x014C, -50 },
  { 0x0100, 0x00D8, -50 },
  { 0x0100, 0x00D5, -50 },
  { 0x0100, 0x0051, -55 },
  { 0x0100, 0x0054, -55 },
  { 0x0100, 0x0164, -55 },
  { 0x0100, 0x0162, -55 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -95 },
  { 0x0100, 0x0057, -100 },
  { 0x0100, 0x0059, -70 },
  { 0x0100, 0x00DD, -70 },
  { 0x0100, 0x0178, -70 },
  { 0x0100, 0x2019, -74 },
  { 0x0100, 0x0075, -30 },
  { 0x0100, 0x00FA, -30 },
  { 0x0100, 0x00FB, -30 },
  { 0x0100, 0x00FC, -30 },
  { 0x0100, 0x00F9, -30 },
  { 0x0100, 0x0171, -30 },
  { 0x0100, 0x016B, -30 },
  { 0x0100, 0x0173, -30 },
  { 0x0100, 0x016F, -30 },
  { 0x0100, 0x0076, -74 },
  { 0x0100, 0x0077, -74 },
  { 0x0100, 0x0079, -74 },
  { 0x0100, 0x00FD, -74 },
  { 0x0100, 0x00FF, -74 },
  { 0x0104, 0x0043, -65 },
  { 0x0104, 0x0106, -65 },
  { 0x0104, 0x010C, -65 },
  { 0x0104, 0x00C7, -65 },
  { 0x0104, 0x0047, -60 },
  { 0x0104, 0x011E, -60 },
  { 0x0104, 0x0122, -60 },
  { 0x0104, 0x004F, -50 },
  { 0x0104, 0x00D3, -50 },
  { 0x0104, 0x00D4, -50 },
  { 0x0104, 0x00D6, -50 },
  { 0x0104, 0x00D2, -50 },
  { 0x0104, 0x0150, -50 },
  { 0x0104, 0x014C, -50 },
  { 0x0104, 0x00D8, -50 },
  { 0x0104, 0x00D5, -50 },
  { 0x0104, 0x0051, -55 },
  { 0x0104, 0x0054, -55 },
  { 0x0104, 0x0164, -55 },
  { 0x0104, 0x0162, -55 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -95 },
  { 0x0104, 0x0057, -100 },
  { 0x0104, 0x0059, -70 },
  { 0x0104, 0x00DD, -70 },
  { 0x0104, 0x0178, -70 },
  { 0x0104, 0x2019, -74 },
  { 0x0104, 0x0075, -30 },
  { 0x0104, 0x00FA, -30 },
  { 0x0104, 0x00FB, -30 },
  { 0x0104, 0x00FC, -30 },
  { 0x0104, 0x00F9, -30 },
  { 0x0104, 0x0171, -30 },
  { 0x0104, 0x016B, -30 },
  { 0x0104, 0x0173, -30 },
  { 0x0104, 0x016F, -30 },
  { 0x0104, 0x0076, -74 },
  { 0x0104, 0x0077, -74 },
  { 0x0104, 0x0079, -34 },
  { 0x0104, 0x00FD, -34 },
  { 0x0104, 0x00FF, -34 },
  { 0x00C5, 0x0043, -65 },
  { 0x00C5, 0x0106, -65 },
  { 0x00C5, 0x010C, -65 },
  { 0x00C5, 0x00C7, -65 },
  { 0x00C5, 0x0047, -60 },
  { 0x00C5, 0x011E, -60 },
  { 0x00C5, 0x0122, -60 },
  { 0x00C5, 0x004F, -50 },
  { 0x00C5, 0x00D3, -50 },
  { 0x00C5, 0x00D4, -50 },
  { 0x00C5, 0x00D6, -50 },
  { 0x00C5, 0x00D2, -50 },
  { 0x00C5, 0x0150, -50 },
  { 0x00C5, 0x014C, -50 },
  { 0x00C5, 0x00D8, -50 },
  { 0x00C5, 0x00D5, -50 },
  { 0x00C5, 0x0051, -55 },
  { 0x00C5, 0x0054, -55 },
  { 0x00C5, 0x0164, -55 },
  { 0x00C5, 0x0162, -55 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -95 },
  { 0x00C5, 0x0057, -100 },
  { 0x00C5, 0x0059, -70 },
  { 0x00C5, 0x00DD, -70 },
  { 0x00C5, 0x0178, -70 },
  { 0x00C5, 0x2019, -74 },
  { 0x00C5, 0x0075, -30 },
  { 0x00C5, 0x00FA, -30 },
  { 0x00C5, 0x00FB, -30 },
  { 0x00C5, 0x00FC, -30 },
  { 0x00C5, 0x00F9, -30 },
  { 0x00C5, 0x0171, -30 },
  { 0x00C5, 0x016B, -30 },
  { 0x00C5, 0x0173, -30 },
  { 0x00C5, 0x016F, -30 },
  { 0x00C5, 0x0076, -74 },
  { 0x00C5, 0x0077, -74 },
  { 0x00C5, 0x0079, -74 },
  { 0x00C5, 0x00FD, -74 },
  { 0x00C5, 0x00FF, -74 },
  { 0x00C3, 0x0043, -65 },
  { 0x00C3, 0x0106, -65 },
  { 0x00C3, 0x010C, -65 },
  { 0x00C3, 0x00C7, -65 },
  { 0x00C3, 0x0047, -60 },
  { 0x00C3, 0x011E, -60 },
  { 0x00C3, 0x0122, -60 },
  { 0x00C3, 0x004F, -50 },
  { 0x00C3, 0x00D3, -50 },
  { 0x00C3, 0x00D4, -50 },
  { 0x00C3, 0x00D6, -50 },
  { 0x00C3, 0x00D2, -50 },
  { 0x00C3, 0x0150, -50 },
  { 0x00C3, 0x014C, -50 },
  { 0x00C3, 0x00D8, -50 },
  { 0x00C3, 0x00D5, -50 },
  { 0x00C3, 0x0051, -55 },
  { 0x00C3, 0x0054, -55 },
  { 0x00C3, 0x0164, -55 },
  { 0x00C3, 0x0162, -55 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -95 },
  { 0x00C3, 0x0057, -100 },
  { 0x00C3, 0x0059, -70 },
  { 0x00C3, 0x00DD, -70 },
  { 0x00C3, 0x0178, -70 },
  { 0x00C3, 0x2019, -74 },
  { 0x00C3, 0x0075, -30 },
  { 0x00C3, 0x00FA, -30 },
  { 0x00C3, 0x00FB, -30 },
  { 0x00C3, 0x00FC, -30 },
  { 0x00C3, 0x00F9, -30 },
  { 0x00C3, 0x0171, -30 },
  { 0x00C3, 0x016B, -30 },
  { 0x00C3, 0x0173, -30 },
  { 0x00C3, 0x016F, -30 },
  { 0x00C3, 0x0076, -74 },
  { 0x00C3, 0x0077, -74 },
  { 0x00C3, 0x0079, -74 },
  { 0x00C3, 0x00FD, -74 },
  { 0x00C3, 0x00FF, -74 },
  { 0x0042, 0x0041, -25 },
  { 0x0042, 0x00C1, -25 },
  { 0x0042, 0x0102, -25 },
  { 0x0042, 0x00C2, -25 },
  { 0x0042, 0x00C4, -25 },
  { 0x0042, 0x00C0, -25 },
  { 0x0042, 0x0100, -25 },
  { 0x0042, 0x0104, -25 },
  { 0x0042, 0x00C5, -25 },
  { 0x0042, 0x00C3, -25 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0044, 0x0041, -25 },
  { 0x0044, 0x00C1, -25 },
  { 0x0044, 0x0102, -25 },
  { 0x0044, 0x00C2, -25 },
  { 0x0044, 0x00C4, -25 },
  { 0x0044, 0x00C0, -25 },
  { 0x0044, 0x0100, -25 },
  { 0x0044, 0x0104, -25 },
  { 0x0044, 0x00C5, -25 },
  { 0x0044, 0x00C3, -25 },
  { 0x0044, 0x0056, -50 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -50 },
  { 0x0044, 0x00DD, -50 },
  { 0x0044, 0x0178, -50 },
  { 0x010E, 0x0041, -25 },
  { 0x010E, 0x00C1, -25 },
  { 0x010E, 0x0102, -25 },
  { 0x010E, 0x00C2, -25 },
  { 0x010E, 0x00C4, -25 },
  { 0x010E, 0x00C0, -25 },
  { 0x010E, 0x0100, -25 },
  { 0x010E, 0x0104, -25 },
  { 0x010E, 0x00C5, -25 },
  { 0x010E, 0x00C3, -25 },
  { 0x010E, 0x0056, -50 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -50 },
  { 0x010E, 0x00DD, -50 },
  { 0x010E, 0x0178, -50 },
  { 0x0110, 0x0041, -25 },
  { 0x0110, 0x00C1, -25 },
  { 0x0110, 0x0102, -25 },
  { 0x0110, 0x00C2, -25 },
  { 0x0110, 0x00C4, -25 },
  { 0x0110, 0x00C0, -25 },
  { 0x0110, 0x0100, -25 },
  { 0x0110, 0x0104, -25 },
  { 0x0110, 0x00C5, -25 },
  { 0x0110, 0x00C3, -25 },
  { 0x0110, 0x0056, -50 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -50 },
  { 0x0110, 0x00DD, -50 },
  { 0x0110, 0x0178, -50 },
  { 0x0046, 0x0041, -100 },
  { 0x0046, 0x00C1, -100 },
  { 0x0046, 0x0102, -100 },
  { 0x0046, 0x00C2, -100 },
  { 0x0046, 0x00C4, -100 },
  { 0x0046, 0x00C0, -100 },
  { 0x0046, 0x0100, -100 },
  { 0x0046, 0x0104, -100 },
  { 0x0046, 0x00C5, -100 },
  { 0x0046, 0x00C3, -100 },
  { 0x0046, 0x0061, -95 },
  { 0x0046, 0x00E1, -95 },
  { 0x0046, 0x0103, -95 },
  { 0x0046, 0x00E2, -95 },
  { 0x0046, 0x00E4, -95 },
  { 0x0046, 0x00E0, -95 },
  { 0x0046, 0x0101, -95 },
  { 0x0046, 0x0105, -95 },
  { 0x0046, 0x00E5, -95 },
  { 0x0046, 0x00E3, -95 },
  { 0x0046, 0x002C, -129 },
  { 0x0046, 0x0065, -100 },
  { 0x0046, 0x00E9, -100 },
  { 0x0046, 0x011B, -100 },
  { 0x0046, 0x00EA, -100 },
  { 0x0046, 0x00EB, -100 },
  { 0x0046, 0x0117, -100 },
  { 0x0046, 0x00E8, -100 },
  { 0x0046, 0x0113, -100 },
  { 0x0046, 0x0119, -100 },
  { 0x0046, 0x0069, -40 },
  { 0x0046, 0x00ED, -40 },
  { 0x0046, 0x00EE, -40 },
  { 0x0046, 0x00EF, -40 },
  { 0x0046, 0x00EC, -40 },
  { 0x0046, 0x012B, -40 },
  { 0x0046, 0x012F, -40 },
  { 0x0046, 0x006F, -70 },
  { 0x0046, 0x00F3, -70 },
  { 0x0046, 0x00F4, -70 },
  { 0x0046, 0x00F6, -70 },
  { 0x0046, 0x00F2, -70 },
  { 0x0046, 0x0151, -70 },
  { 0x0046, 0x014D, -70 },
  { 0x0046, 0x00F8, -70 },
  { 0x0046, 0x00F5, -70 },
  { 0x0046, 0x002E, -129 },
  { 0x0046, 0x0072, -50 },
  { 0x0046, 0x0155, -50 },
  { 0x0046, 0x0159, -50 },
  { 0x0046, 0x0157, -50 },
  { 0x004A, 0x0041, -25 },
  { 0x004A, 0x00C1, -25 },
  { 0x004A, 0x0102, -25 },
  { 0x004A, 0x00C2, -25 },
  { 0x004A, 0x00C4, -25 },
  { 0x004A, 0x00C0, -25 },
  { 0x004A, 0x0100, -25 },
  { 0x004A, 0x0104, -25 },
  { 0x004A, 0x00C5, -25 },
  { 0x004A, 0x00C3, -25 },
  { 0x004A, 0x0061, -40 },
  { 0x004A, 0x00E1, -40 },
  { 0x004A, 0x0103, -40 },
  { 0x004A, 0x00E2, -40 },
  { 0x004A, 0x00E4, -40 },
  { 0x004A, 0x00E0, -40 },
  { 0x004A, 0x0101, -40 },
  { 0x004A, 0x0105, -40 },
  { 0x004A, 0x00E5, -40 },
  { 0x004A, 0x00E3, -40 },
  { 0x004A, 0x002C, -10 },
  { 0x004A, 0x0065, -40 },
  { 0x004A, 0x00E9, -40 },
  { 0x004A, 0x011B, -40 },
  { 0x004A, 0x00EA, -40 },
  { 0x004A, 0x00EB, -40 },
  { 0x004A, 0x0117, -40 },
  { 0x004A, 0x00E8, -40 },
  { 0x004A, 0x0113, -40 },
  { 0x004A, 0x0119, -40 },
  { 0x004A, 0x006F, -40 },
  { 0x004A, 0x00F3, -40 },
  { 0x004A, 0x00F4, -40 },
  { 0x004A, 0x00F6, -40 },
  { 0x004A, 0x00F2, -40 },
  { 0x004A, 0x0151, -40 },
  { 0x004A, 0x014D, -40 },
  { 0x004A, 0x00F8, -40 },
  { 0x004A, 0x00F5, -40 },
  { 0x004A, 0x002E, -10 },
  { 0x004A, 0x0075, -40 },
  { 0x004A, 0x00FA, -40 },
  { 0x004A, 0x00FB, -40 },
  { 0x004A, 0x00FC, -40 },
  { 0x004A, 0x00F9, -40 },
  { 0x004A, 0x0171, -40 },
  { 0x004A, 0x016B, -40 },
  { 0x004A, 0x0173, -40 },
  { 0x004A, 0x016F, -40 },
  { 0x004B, 0x004F, -30 },
  { 0x004B, 0x00D3, -30 },
  { 0x004B, 0x00D4, -30 },
  { 0x004B, 0x00D6, -30 },
  { 0x004B, 0x00D2, -30 },
  { 0x004B, 0x0150, -30 },
  { 0x004B, 0x014C, -30 },
  { 0x004B, 0x00D8, -30 },
  { 0x004B, 0x00D5, -30 },
  { 0x004B, 0x0065, -25 },
  { 0x004B, 0x00E9, -25 },
  { 0x004B, 0x011B, -25 },
  { 0x004B, 0x00EA, -25 },
  { 0x004B, 0x00EB, -25 },
  { 0x004B, 0x0117, -25 },
  { 0x004B, 0x00E8, -25 },
  { 0x004B, 0x0113, -25 },
  { 0x004B, 0x0119, -25 },
  { 0x004B, 0x006F, -25 },
  { 0x004B, 0x00F3, -25 },
  { 0x004B, 0x00F4, -25 },
  { 0x004B, 0x00F6, -25 },
  { 0x004B, 0x00F2, -25 },
  { 0x004B, 0x0151, -25 },
  { 0x004B, 0x014D, -25 },
  { 0x004B, 0x00F8, -25 },
  { 0x004B, 0x00F5, -25 },
  { 0x004B, 0x0075, -20 },
  { 0x004B, 0x00FA, -20 },
  { 0x004B, 0x00FB, -20 },
  { 0x004B, 0x00FC, -20 },
  { 0x004B, 0x00F9, -20 },
  { 0x004B, 0x0171, -20 },
  { 0x004B, 0x016B, -20 },
  { 0x004B, 0x0173, -20 },
  { 0x004B, 0x016F, -20 },
  { 0x004B, 0x0079, -20 },
  { 0x004B, 0x00FD, -20 },
  { 0x004B, 0x00FF, -20 },
  { 0x0136, 0x004F, -30 },
  { 0x0136, 0x00D3, -30 },
  { 0x0136, 0x00D4, -30 },
  { 0x0136, 0x00D6, -30 },
  { 0x0136, 0x00D2, -30 },
  { 0x0136, 0x0150, -30 },
  { 0x0136, 0x014C, -30 },
  { 0x0136, 0x00D8, -30 },
  { 0x0136, 0x00D5, -30 },
  { 0x0136, 0x0065, -25 },
  { 0x0136, 0x00E9, -25 },
  { 0x0136, 0x011B, -25 },
  { 0x0136, 0x00EA, -25 },
  { 0x0136, 0x00EB, -25 },
  { 0x0136, 0x0117, -25 },
  { 0x0136, 0x00E8, -25 },
  { 0x0136, 0x0113, -25 },
  { 0x0136, 0x0119, -25 },
  { 0x0136, 0x006F, -25 },
  { 0x0136, 0x00F3, -25 },
  { 0x0136, 0x00F4, -25 },
  { 0x0136, 0x00F6, -25 },
  { 0x0136, 0x00F2, -25 },
  { 0x0136, 0x0151, -25 },
  { 0x0136, 0x014D, -25 },
  { 0x0136, 0x00F8, -25 },
  { 0x0136, 0x00F5, -25 },
  { 0x0136, 0x0075, -20 },
  { 0x0136, 0x00FA, -20 },
  { 0x0136, 0x00FB, -20 },
  { 0x0136, 0x00FC, -20 },
  { 0x0136, 0x00F9, -20 },
  { 0x0136, 0x0171, -20 },
  { 0x0136, 0x016B, -20 },
  { 0x0136, 0x0173, -20 },
  { 0x0136, 0x016F, -20 },
  { 0x0136, 0x0079, -20 },
  { 0x0136, 0x00FD, -20 },
  { 0x0136, 0x00FF, -20 },
  { 0x004C, 0x0054, -18 },
  { 0x004C, 0x0164, -18 },
  { 0x004C, 0x0162, -18 },
  { 0x004C, 0x0056, -37 },
  { 0x004C, 0x0057, -37 },
  { 0x004C, 0x0059, -37 },
  { 0x004C, 0x00DD, -37 },
  { 0x004C, 0x0178, -37 },
  { 0x004C, 0x2019, -55 },
  { 0x004C, 0x0079, -37 },
  { 0x004C, 0x00FD, -37 },
  { 0x004C, 0x00FF, -37 },
  { 0x0139, 0x0054, -18 },
  { 0x0139, 0x0164, -18 },
  { 0x0139, 0x0162, -18 },
  { 0x0139, 0x0056, -37 },
  { 0x0139, 0x0057, -37 },
  { 0x0139, 0x0059, -37 },
  { 0x0139, 0x00DD, -37 },
  { 0x0139, 0x0178, -37 },
  { 0x0139, 0x2019, -55 },
  { 0x0139, 0x0079, -37 },
  { 0x0139, 0x00FD, -37 },
  { 0x0139, 0x00FF, -37 },
  { 0x013B, 0x0054, -18 },
  { 0x013B, 0x0164, -18 },
  { 0x013B, 0x0162, -18 },
  { 0x013B, 0x0056, -37 },
  { 0x013B, 0x0057, -37 },
  { 0x013B, 0x0059, -37 },
  { 0x013B, 0x00DD, -37 },
  { 0x013B, 0x0178, -37 },
  { 0x013B, 0x2019, -55 },
  { 0x013B, 0x0079, -37 },
  { 0x013B, 0x00FD, -37 },
  { 0x013B, 0x00FF, -37 },
  { 0x0141, 0x0054, -18 },
  { 0x0141, 0x0164, -18 },
  { 0x0141, 0x0162, -18 },
  { 0x0141, 0x0056, -37 },
  { 0x0141, 0x0057, -37 },
  { 0x0141, 0x0059, -37 },
  { 0x0141, 0x00DD, -37 },
  { 0x0141, 0x0178, -37 },
  { 0x0141, 0x2019, -55 },
  { 0x0141, 0x0079, -37 },
  { 0x0141, 0x00FD, -37 },
  { 0x0141, 0x00FF, -37 },
  { 0x004E, 0x0041, -30 },
  { 0x004E, 0x00C1, -30 },
  { 0x004E, 0x0102, -30 },
  { 0x004E, 0x00C2, -30 },
  { 0x004E, 0x00C4, -30 },
  { 0x004E, 0x00C0, -30 },
  { 0x004E, 0x0100, -30 },
  { 0x004E, 0x0104, -30 },
  { 0x004E, 0x00C5, -30 },
  { 0x004E, 0x00C3, -30 },
  { 0x0143, 0x0041, -30 },
  { 0x0143, 0x00C1, -30 },
  { 0x0143, 0x0102, -30 },
  { 0x0143, 0x00C2, -30 },
  { 0x0143, 0x00C4, -30 },
  { 0x0143, 0x00C0, -30 },
  { 0x0143, 0x0100, -30 },
  { 0x0143, 0x0104, -30 },
  { 0x0143, 0x00C5, -30 },
  { 0x0143, 0x00C3, -30 },
  { 0x0147, 0x0041, -30 },
  { 0x0147, 0x00C1, -30 },
  { 0x0147, 0x0102, -30 },
  { 0x0147, 0x00C2, -30 },
  { 0x0147, 0x00C4, -30 },
  { 0x0147, 0x00C0, -30 },
  { 0x0147, 0x0100, -30 },
  { 0x0147, 0x0104, -30 },
  { 0x0147, 0x00C5, -30 },
  { 0x0147, 0x00C3, -30 },
  { 0x0145, 0x0041, -30 },
  { 0x0145, 0x00C1, -30 },
  { 0x0145, 0x0102, -30 },
  { 0x0145, 0x00C2, -30 },
  { 0x0145, 0x00C4, -30 },
  { 0x0145, 0x00C0, -30 },
  { 0x0145, 0x0100, -30 },
  { 0x0145, 0x0104, -30 },
  { 0x0145, 0x00C5, -30 },
  { 0x0145, 0x00C3, -30 },
  { 0x00D1, 0x0041, -30 },
  { 0x00D1, 0x00C1, -30 },
  { 0x00D1, 0x0102, -30 },
  { 0x00D1, 0x00C2, -30 },
  { 0x00D1, 0x00C4, -30 },
  { 0x00D1, 0x00C0, -30 },
  { 0x00D1, 0x0100, -30 },
  { 0x00D1, 0x0104, -30 },
  { 0x00D1, 0x00C5, -30 },
  { 0x00D1, 0x00C3, -30 },
  { 0x004F, 0x0041, -40 },
  { 0x004F, 0x00C1, -40 },
  { 0x004F, 0x0102, -40 },
  { 0x004F, 0x00C2, -40 },
  { 0x004F, 0x00C4, -40 },
  { 0x004F, 0x00C0, -40 },
  { 0x004F, 0x0100, -40 },
  { 0x004F, 0x0104, -40 },
  { 0x004F, 0x00C5, -40 },
  { 0x004F, 0x00C3, -40 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -50 },
  { 0x004F, 0x0058, -40 },
  { 0x004F, 0x0059, -50 },
  { 0x004F, 0x00DD, -50 },
  { 0x004F, 0x0178, -50 },
  { 0x00D3, 0x0041, -40 },
  { 0x00D3, 0x00C1, -40 },
  { 0x00D3, 0x0102, -40 },
  { 0x00D3, 0x00C2, -40 },
  { 0x00D3, 0x00C4, -40 },
  { 0x00D3, 0x00C0, -40 },
  { 0x00D3, 0x0100, -40 },
  { 0x00D3, 0x0104, -40 },
  { 0x00D3, 0x00C5, -40 },
  { 0x00D3, 0x00C3, -40 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -50 },
  { 0x00D3, 0x0058, -40 },
  { 0x00D3, 0x0059, -50 },
  { 0x00D3, 0x00DD, -50 },
  { 0x00D3, 0x0178, -50 },
  { 0x00D4, 0x0041, -40 },
  { 0x00D4, 0x00C1, -40 },
  { 0x00D4, 0x0102, -40 },
  { 0x00D4, 0x00C2, -40 },
  { 0x00D4, 0x00C4, -40 },
  { 0x00D4, 0x00C0, -40 },
  { 0x00D4, 0x0100, -40 },
  { 0x00D4, 0x0104, -40 },
  { 0x00D4, 0x00C5, -40 },
  { 0x00D4, 0x00C3, -40 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -50 },
  { 0x00D4, 0x0058, -40 },
  { 0x00D4, 0x0059, -50 },
  { 0x00D4, 0x00DD, -50 },
  { 0x00D4, 0x0178, -50 },
  { 0x00D6, 0x0041, -40 },
  { 0x00D6, 0x00C1, -40 },
  { 0x00D6, 0x0102, -40 },
  { 0x00D6, 0x00C2, -40 },
  { 0x00D6, 0x00C4, -40 },
  { 0x00D6, 0x00C0, -40 },
  { 0x00D6, 0x0100, -40 },
  { 0x00D6, 0x0104, -40 },
  { 0x00D6, 0x00C5, -40 },
  { 0x00D6, 0x00C3, -40 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -50 },
  { 0x00D6, 0x0058, -40 },
  { 0x00D6, 0x0059, -50 },
  { 0x00D6, 0x00DD, -50 },
  { 0x00D6, 0x0178, -50 },
  { 0x00D2, 0x0041, -40 },
  { 0x00D2, 0x00C1, -40 },
  { 0x00D2, 0x0102, -40 },
  { 0x00D2, 0x00C2, -40 },
  { 0x00D2, 0x00C4, -40 },
  { 0x00D2, 0x00C0, -40 },
  { 0x00D2, 0x0100, -40 },
  { 0x00D2, 0x0104, -40 },
  { 0x00D2, 0x00C5, -40 },
  { 0x00D2, 0x00C3, -40 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -50 },
  { 0x00D2, 0x0058, -40 },
  { 0x00D2, 0x0059, -50 },
  { 0x00D2, 0x00DD, -50 },
  { 0x00D2, 0x0178, -50 },
  { 0x0150, 0x0041, -40 },
  { 0x0150, 0x00C1, -40 },
  { 0x0150, 0x0102, -40 },
  { 0x0150, 0x00C2, -40 },
  { 0x0150, 0x00C4, -40 },
  { 0x0150, 0x00C0, -40 },
  { 0x0150, 0x0100, -40 },
  { 0x0150, 0x0104, -40 },
  { 0x0150, 0x00C5, -40 },
  { 0x0150, 0x00C3, -40 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -50 },
  { 0x0150, 0x0058, -40 },
  { 0x0150, 0x0059, -50 },
  { 0x0150, 0x00DD, -50 },
  { 0x0150, 0x0178, -50 },
  { 0x014C, 0x0041, -40 },
  { 0x014C, 0x00C1, -40 },
  { 0x014C, 0x0102, -40 },
  { 0x014C, 0x00C2, -40 },
  { 0x014C, 0x00C4, -40 },
  { 0x014C, 0x00C0, -40 },
  { 0x014C, 0x0100, -40 },
  { 0x014C, 0x0104, -40 },
  { 0x014C, 0x00C5, -40 },
  { 0x014C, 0x00C3, -40 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -50 },
  { 0x014C, 0x0058, -40 },
  { 0x014C, 0x0059, -50 },
  { 0x014C, 0x00DD, -50 },
  { 0x014C, 0x0178, -50 },
  { 0x00D8, 0x0041, -40 },
  { 0x00D8, 0x00C1, -40 },
  { 0x00D8, 0x0102, -40 },
  { 0x00D8, 0x00C2, -40 },
  { 0x00D8, 0x00C4, -40 },
  { 0x00D8, 0x00C0, -40 },
  { 0x00D8, 0x0100, -40 },
  { 0x00D8, 0x0104, -40 },
  { 0x00D8, 0x00C5, -40 },
  { 0x00D8, 0x00C3, -40 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -50 },
  { 0x00D8, 0x0058, -40 },
  { 0x00D8, 0x0059, -50 },
  { 0x00D8, 0x00DD, -50 },
  { 0x00D8, 0x0178, -50 },
  { 0x00D5, 0x0041, -40 },
  { 0x00D5, 0x00C1, -40 },
  { 0x00D5, 0x0102, -40 },
  { 0x00D5, 0x00C2, -40 },
  { 0x00D5, 0x00C4, -40 },
  { 0x00D5, 0x00C0, -40 },
  { 0x00D5, 0x0100, -40 },
  { 0x00D5, 0x0104, -40 },
  { 0x00D5, 0x00C5, -40 },
  { 0x00D5, 0x00C3, -40 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -50 },
  { 0x00D5, 0x0058, -40 },
  { 0x00D5, 0x0059, -50 },
  { 0x00D5, 0x00DD, -50 },
  { 0x00D5, 0x0178, -50 },
  { 0x0050, 0x0041, -85 },
  { 0x0050, 0x00C1, -85 },
  { 0x0050, 0x0102, -85 },
  { 0x0050, 0x00C2, -85 },
  { 0x0050, 0x00C4, -85 },
  { 0x0050, 0x00C0, -85 },
  { 0x0050, 0x0100, -85 },
  { 0x0050, 0x0104, -85 },
  { 0x0050, 0x00C5, -85 },
  { 0x0050, 0x00C3, -85 },
  { 0x0050, 0x0061, -40 },
  { 0x0050, 0x00E1, -40 },
  { 0x0050, 0x0103, -40 },
  { 0x0050, 0x00E2, -40 },
  { 0x0050, 0x00E4, -40 },
  { 0x0050, 0x00E0, -40 },
  { 0x0050, 0x0101, -40 },
  { 0x0050, 0x0105, -40 },
  { 0x0050, 0x00E5, -40 },
  { 0x0050, 0x00E3, -40 },
  { 0x0050, 0x002C, -129 },
  { 0x0050, 0x0065, -50 },
  { 0x0050, 0x00E9, -50 },
  { 0x0050, 0x011B, -50 },
  { 0x0050, 0x00EA, -50 },
  { 0x0050, 0x00EB, -50 },
  { 0x0050, 0x0117, -50 },
  { 0x0050, 0x00E8, -50 },
  { 0x0050, 0x0113, -50 },
  { 0x0050, 0x0119, -50 },
  { 0x0050, 0x006F, -55 },
  { 0x0050, 0x00F3, -55 },
  { 0x0050, 0x00F4, -55 },
  { 0x0050, 0x00F6, -55 },
  { 0x0050, 0x00F2, -55 },
  { 0x0050, 0x0151, -55 },
  { 0x0050, 0x014D, -55 },
  { 0x0050, 0x00F8, -55 },
  { 0x0050, 0x00F5, -55 },
  { 0x0050, 0x002E, -129 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0052, 0x004F, -40 },
  { 0x0052, 0x00D3, -40 },
  { 0x0052, 0x00D4, -40 },
  { 0x0052, 0x00D6, -40 },
  { 0x0052, 0x00D2, -40 },
  { 0x0052, 0x0150, -40 },
  { 0x0052, 0x014C, -40 },
  { 0x0052, 0x00D8, -40 },
  { 0x0052, 0x00D5, -40 },
  { 0x0052, 0x0054, -30 },
  { 0x0052, 0x0164, -30 },
  { 0x0052, 0x0162, -30 },
  { 0x0052, 0x0055, -40 },
  { 0x0052, 0x00DA, -40 },
  { 0x0052, 0x00DB, -40 },
  { 0x0052, 0x00DC, -40 },
  { 0x0052, 0x00D9, -40 },
  { 0x0052, 0x0170, -40 },
  { 0x0052, 0x016A, -40 },
  { 0x0052, 0x0172, -40 },
  { 0x0052, 0x016E, -40 },
  { 0x0052, 0x0056, -18 },
  { 0x0052, 0x0057, -18 },
  { 0x0052, 0x0059, -18 },
  { 0x0052, 0x00DD, -18 },
  { 0x0052, 0x0178, -18 },
  { 0x0154, 0x004F, -40 },
  { 0x0154, 0x00D3, -40 },
  { 0x0154, 0x00D4, -40 },
  { 0x0154, 0x00D6, -40 },
  { 0x0154, 0x00D2, -40 },
  { 0x0154, 0x0150, -40 },
  { 0x0154, 0x014C, -40 },
  { 0x0154, 0x00D8, -40 },
  { 0x0154, 0x00D5, -40 },
  { 0x0154, 0x0054, -30 },
  { 0x0154, 0x0164, -30 },
  { 0x0154, 0x0162, -30 },
  { 0x0154, 0x0055, -40 },
  { 0x0154, 0x00DA, -40 },
  { 0x0154, 0x00DB, -40 },
  { 0x0154, 0x00DC, -40 },
  { 0x0154, 0x00D9, -40 },
  { 0x0154, 0x0170, -40 },
  { 0x0154, 0x016A, -40 },
  { 0x0154, 0x0172, -40 },
  { 0x0154, 0x016E, -40 },
  { 0x0154, 0x0056, -18 },
  { 0x0154, 0x0057, -18 },
  { 0x0154, 0x0059, -18 },
  { 0x0154, 0x00DD, -18 },
  { 0x0154, 0x0178, -18 },
  { 0x0158, 0x004F, -40 },
  { 0x0158, 0x00D3, -40 },
  { 0x0158, 0x00D4, -40 },
  { 0x0158, 0x00D6, -40 },
  { 0x0158, 0x00D2, -40 },
  { 0x0158, 0x0150, -40 },
  { 0x0158, 0x014C, -40 },
  { 0x0158, 0x00D8, -40 },
  { 0x0158, 0x00D5, -40 },
  { 0x0158, 0x0054, -30 },
  { 0x0158, 0x0164, -30 },
  { 0x0158, 0x0162, -30 },
  { 0x0158, 0x0055, -40 },
  { 0x0158, 0x00DA, -40 },
  { 0x0158, 0x00DB, -40 },
  { 0x0158, 0x00DC, -40 },
  { 0x0158, 0x00D9, -40 },
  { 0x0158, 0x0170, -40 },
  { 0x0158, 0x016A, -40 },
  { 0x0158, 0x0172, -40 },
  { 0x0158, 0x016E, -40 },
  { 0x0158, 0x0056, -18 },
  { 0x0158, 0x0057, -18 },
  { 0x0158, 0x0059, -18 },
  { 0x0158, 0x00DD, -18 },
  { 0x0158, 0x0178, -18 },
  { 0x0156, 0x004F, -40 },
  { 0x0156, 0x00D3, -40 },
  { 0x0156, 0x00D4, -40 },
  { 0x0156, 0x00D6, -40 },
  { 0x0156, 0x00D2, -40 },
  { 0x0156, 0x0150, -40 },
  { 0x0156, 0x014C, -40 },
  { 0x0156, 0x00D8, -40 },
  { 0x0156, 0x00D5, -40 },
  { 0x0156, 0x0054, -30 },
  { 0x0156, 0x0164, -30 },
  { 0x0156, 0x0162, -30 },
  { 0x0156, 0x0055, -40 },
  { 0x0156, 0x00DA, -40 },
  { 0x0156, 0x00DB, -40 },
  { 0x0156, 0x00DC, -40 },
  { 0x0156, 0x00D9, -40 },
  { 0x0156, 0x0170, -40 },
  { 0x0156, 0x016A, -40 },
  { 0x0156, 0x0172, -40 },
  { 0x0156, 0x016E, -40 },
  { 0x0156, 0x0056, -18 },
  { 0x0156, 0x0057, -18 },
  { 0x0156, 0x0059, -18 },
  { 0x0156, 0x00DD, -18 },
  { 0x0156, 0x0178, -18 },
  { 0x0054, 0x0041, -55 },
  { 0x0054, 0x00C1, -55 },
  { 0x0054, 0x0102, -55 },
  { 0x0054, 0x00C2, -55 },
  { 0x0054, 0x00C4, -55 },
  { 0x0054, 0x00C0, -55 },
  { 0x0054, 0x0100, -55 },
  { 0x0054, 0x0104, -55 },
  { 0x0054, 0x00C5, -55 },
  { 0x0054, 0x00C3, -55 },
  { 0x0054, 0x004F, -18 },
  { 0x0054, 0x00D3, -18 },
  { 0x0054, 0x00D4, -18 },
  { 0x0054, 0x00D6, -18 },
  { 0x0054, 0x00D2, -18 },
  { 0x0054, 0x0150, -18 },
  { 0x0054, 0x014C, -18 },
  { 0x0054, 0x00D8, -18 },
  { 0x0054, 0x00D5, -18 },
  { 0x0054, 0x0061, -92 },
  { 0x0054, 0x00E1, -92 },
  { 0x0054, 0x0103, -92 },
  { 0x0054, 0x00E2, -92 },
  { 0x0054, 0x00E4, -92 },
  { 0x0054, 0x00E0, -92 },
  { 0x0054, 0x0101, -92 },
  { 0x0054, 0x0105, -92 },
  { 0x0054, 0x00E5, -92 },
  { 0x0054, 0x00E3, -92 },
  { 0x0054, 0x003A, -74 },
  { 0x0054, 0x002C, -92 },
  { 0x0054, 0x0065, -92 },
  { 0x0054, 0x00E9, -92 },
  { 0x0054, 0x011B, -92 },
  { 0x0054, 0x00EA, -92 },
  { 0x0054, 0x00EB, -52 },
  { 0x0054, 0x0117, -92 },
  { 0x0054, 0x00E8, -52 },
  { 0x0054, 0x0113, -52 },
  { 0x0054, 0x0119, -92 },
  { 0x0054, 0x002D, -92 },
  { 0x0054, 0x0069, -37 },
  { 0x0054, 0x00ED, -37 },
  { 0x0054, 0x012F, -37 },
  { 0x0054, 0x006F, -95 },
  { 0x0054, 0x00F3, -95 },
  { 0x0054, 0x00F4, -95 },
  { 0x0054, 0x00F6, -95 },
  { 0x0054, 0x00F2, -95 },
  { 0x0054, 0x0151, -95 },
  { 0x0054, 0x014D, -95 },
  { 0x0054, 0x00F8, -95 },
  { 0x0054, 0x00F5, -95 },
  { 0x0054, 0x002E, -92 },
  { 0x0054, 0x0072, -37 },
  { 0x0054, 0x0155, -37 },
  { 0x0054, 0x0159, -37 },
  { 0x0054, 0x0157, -37 },
  { 0x0054, 0x003B, -74 },
  { 0x0054, 0x0075, -37 },
  { 0x0054, 0x00FA, -37 },
  { 0x0054, 0x00FB, -37 },
  { 0x0054, 0x00FC, -37 },
  { 0x0054, 0x00F9, -37 },
  { 0x0054, 0x0171, -37 },
  { 0x0054, 0x016B, -37 },
  { 0x0054, 0x0173, -37 },
  { 0x0054, 0x016F, -37 },
  { 0x0054, 0x0077, -37 },
  { 0x0054, 0x0079, -37 },
  { 0x0054, 0x00FD, -37 },
  { 0x0054, 0x00FF, -37 },
  { 0x0164, 0x0041, -55 },
  { 0x0164, 0x00C1, -55 },
  { 0x0164, 0x0102, -55 },
  { 0x0164, 0x00C2, -55 },
  { 0x0164, 0x00C4, -55 },
  { 0x0164, 0x00C0, -55 },
  { 0x0164, 0x0100, -55 },
  { 0x0164, 0x0104, -55 },
  { 0x0164, 0x00C5, -55 },
  { 0x0164, 0x00C3, -55 },
  { 0x0164, 0x004F, -18 },
  { 0x0164, 0x00D3, -18 },
  { 0x0164, 0x00D4, -18 },
  { 0x0164, 0x00D6, -18 },
  { 0x0164, 0x00D2, -18 },
  { 0x0164, 0x0150, -18 },
  { 0x0164, 0x014C, -18 },
  { 0x0164, 0x00D8, -18 },
  { 0x0164, 0x00D5, -18 },
  { 0x0164, 0x0061, -92 },
  { 0x0164, 0x00E1, -92 },
  { 0x0164, 0x0103, -92 },
  { 0x0164, 0x00E2, -92 },
  { 0x0164, 0x00E4, -92 },
  { 0x0164, 0x00E0, -92 },
  { 0x0164, 0x0101, -92 },
  { 0x0164, 0x0105, -92 },
  { 0x0164, 0x00E5, -92 },
  { 0x0164, 0x00E3, -92 },
  { 0x0164, 0x003A, -74 },
  { 0x0164, 0x002C, -92 },
  { 0x0164, 0x0065, -92 },
  { 0x0164, 0x00E9, -92 },
  { 0x0164, 0x011B, -92 },
  { 0x0164, 0x00EA, -92 },
  { 0x0164, 0x00EB, -52 },
  { 0x0164, 0x0117, -92 },
  { 0x0164, 0x00E8, -52 },
  { 0x0164, 0x0113, -52 },
  { 0x0164, 0x0119, -92 },
  { 0x0164, 0x002D, -92 },
  { 0x0164, 0x0069, -37 },
  { 0x0164, 0x00ED, -37 },
  { 0x0164, 0x012F, -37 },
  { 0x0164, 0x006F, -95 },
  { 0x0164, 0x00F3, -95 },
  { 0x0164, 0x00F4, -95 },
  { 0x0164, 0x00F6, -95 },
  { 0x0164, 0x00F2, -95 },
  { 0x0164, 0x0151, -95 },
  { 0x0164, 0x014D, -95 },
  { 0x0164, 0x00F8, -95 },
  { 0x0164, 0x00F5, -95 },
  { 0x0164, 0x002E, -92 },
  { 0x0164, 0x0072, -37 },
  { 0x0164, 0x0155, -37 },
  { 0x0164, 0x0159, -37 },
  { 0x0164, 0x0157, -37 },
  { 0x0164, 0x003B, -74 },
  { 0x0164, 0x0075, -37 },
  { 0x0164, 0x00FA, -37 },
  { 0x0164, 0x00FB, -37 },
  { 0x0164, 0x00FC, -37 },
  { 0x0164, 0x00F9, -37 },
  { 0x0164, 0x0171, -37 },
  { 0x0164, 0x016B, -37 },
  { 0x0164, 0x0173, -37 },
  { 0x0164, 0x016F, -37 },
  { 0x0164, 0x0077, -37 },
  { 0x0164, 0x0079, -37 },
  { 0x0164, 0x00FD, -37 },
  { 0x0164, 0x00FF, -37 },
  { 0x0162, 0x0041, -55 },
  { 0x0162, 0x00C1, -55 },
  { 0x0162, 0x0102, -55 },
  { 0x0162, 0x00C2, -55 },
  { 0x0162, 0x00C4, -55 },
  { 0x0162, 0x00C0, -55 },
  { 0x0162, 0x0100, -55 },
  { 0x0162, 0x0104, -55 },
  { 0x0162, 0x00C5, -55 },
  { 0x0162, 0x00C3, -55 },
  { 0x0162, 0x004F, -18 },
  { 0x0162, 0x00D3, -18 },
  { 0x0162, 0x00D4, -18 },
  { 0x0162, 0x00D6, -18 },
  { 0x0162, 0x00D2, -18 },
  { 0x0162, 0x0150, -18 },
  { 0x0162, 0x014C, -18 },
  { 0x0162, 0x00D8, -18 },
  { 0x0162, 0x00D5, -18 },
  { 0x0162, 0x0061, -92 },
  { 0x0162, 0x00E1, -92 },
  { 0x0162, 0x0103, -92 },
  { 0x0162, 0x00E2, -92 },
  { 0x0162, 0x00E4, -92 },
  { 0x0162, 0x00E0, -92 },
  { 0x0162, 0x0101, -92 },
  { 0x0162, 0x0105, -92 },
  { 0x0162, 0x00E5, -92 },
  { 0x0162, 0x00E3, -92 },
  { 0x0162, 0x003A, -74 },
  { 0x0162, 0x002C, -92 },
  { 0x0162, 0x0065, -92 },
  { 0x0162, 0x00E9, -92 },
  { 0x0162, 0x011B, -92 },
  { 0x0162, 0x00EA, -92 },
  { 0x0162, 0x00EB, -52 },
  { 0x0162, 0x0117, -92 },
  { 0x0162, 0x00E8, -52 },
  { 0x0162, 0x0113, -52 },
  { 0x0162, 0x0119, -92 },
  { 0x0162, 0x002D, -92 },
  { 0x0162, 0x0069, -37 },
  { 0x0162, 0x00ED, -37 },
  { 0x0162, 0x012F, -37 },
  { 0x0162, 0x006F, -95 },
  { 0x0162, 0x00F3, -95 },
  { 0x0162, 0x00F4, -95 },
  { 0x0162, 0x00F6, -95 },
  { 0x0162, 0x00F2, -95 },
  { 0x0162, 0x0151, -95 },
  { 0x0162, 0x014D, -95 },
  { 0x0162, 0x00F8, -95 },
  { 0x0162, 0x00F5, -95 },
  { 0x0162, 0x002E, -92 },
  { 0x0162, 0x0072, -37 },
  { 0x0162, 0x0155, -37 },
  { 0x0162, 0x0159, -37 },
  { 0x0162, 0x0157, -37 },
  { 0x0162, 0x003B, -74 },
  { 0x0162, 0x0075, -37 },
  { 0x0162, 0x00FA, -37 },
  { 0x0162, 0x00FB, -37 },
  { 0x0162, 0x00FC, -37 },
  { 0x0162, 0x00F9, -37 },
  { 0x0162, 0x0171, -37 },
  { 0x0162, 0x016B, -37 },
  { 0x0162, 0x0173, -37 },
  { 0x0162, 0x016F, -37 },
  { 0x0162, 0x0077, -37 },
  { 0x0162, 0x0079, -37 },
  { 0x0162, 0x00FD, -37 },
  { 0x0162, 0x00FF, -37 },
  { 0x0055, 0x0041, -45 },
  { 0x0055, 0x00C1, -45 },
  { 0x0055, 0x0102, -45 },
  { 0x0055, 0x00C2, -45 },
  { 0x0055, 0x00C4, -45 },
  { 0x0055, 0x00C0, -45 },
  { 0x0055, 0x0100, -45 },
  { 0x0055, 0x0104, -45 },
  { 0x0055, 0x00C5, -45 },
  { 0x0055, 0x00C3, -45 },
  { 0x00DA, 0x0041, -45 },
  { 0x00DA, 0x00C1, -45 },
  { 0x00DA, 0x0102, -45 },
  { 0x00DA, 0x00C2, -45 },
  { 0x00DA, 0x00C4, -45 },
  { 0x00DA, 0x00C0, -45 },
  { 0x00DA, 0x0100, -45 },
  { 0x00DA, 0x0104, -45 },
  { 0x00DA, 0x00C5, -45 },
  { 0x00DA, 0x00C3, -45 },
  { 0x00DB, 0x0041, -45 },
  { 0x00DB, 0x00C1, -45 },
  { 0x00DB, 0x0102, -45 },
  { 0x00DB, 0x00C2, -45 },
  { 0x00DB, 0x00C4, -45 },
  { 0x00DB, 0x00C0, -45 },
  { 0x00DB, 0x0100, -45 },
  { 0x00DB, 0x0104, -45 },
  { 0x00DB, 0x00C5, -45 },
  { 0x00DB, 0x00C3, -45 },
  { 0x00DC, 0x0041, -45 },
  { 0x00DC, 0x00C1, -45 },
  { 0x00DC, 0x0102, -45 },
  { 0x00DC, 0x00C2, -45 },
  { 0x00DC, 0x00C4, -45 },
  { 0x00DC, 0x00C0, -45 },
  { 0x00DC, 0x0100, -45 },
  { 0x00DC, 0x0104, -45 },
  { 0x00DC, 0x00C5, -45 },
  { 0x00DC, 0x00C3, -45 },
  { 0x00D9, 0x0041, -45 },
  { 0x00D9, 0x00C1, -45 },
  { 0x00D9, 0x0102, -45 },
  { 0x00D9, 0x00C2, -45 },
  { 0x00D9, 0x00C4, -45 },
  { 0x00D9, 0x00C0, -45 },
  { 0x00D9, 0x0100, -45 },
  { 0x00D9, 0x0104, -45 },
  { 0x00D9, 0x00C5, -45 },
  { 0x00D9, 0x00C3, -45 },
  { 0x0170, 0x0041, -45 },
  { 0x0170, 0x00C1, -45 },
  { 0x0170, 0x0102, -45 },
  { 0x0170, 0x00C2, -45 },
  { 0x0170, 0x00C4, -45 },
  { 0x0170, 0x00C0, -45 },
  { 0x0170, 0x0100, -45 },
  { 0x0170, 0x0104, -45 },
  { 0x0170, 0x00C5, -45 },
  { 0x0170, 0x00C3, -45 },
  { 0x016A, 0x0041, -45 },
  { 0x016A, 0x00C1, -45 },
  { 0x016A, 0x0102, -45 },
  { 0x016A, 0x00C2, -45 },
  { 0x016A, 0x00C4, -45 },
  { 0x016A, 0x00C0, -45 },
  { 0x016A, 0x0100, -45 },
  { 0x016A, 0x0104, -45 },
  { 0x016A, 0x00C5, -45 },
  { 0x016A, 0x00C3, -45 },
  { 0x0172, 0x0041, -45 },
  { 0x0172, 0x00C1, -45 },
  { 0x0172, 0x0102, -45 },
  { 0x0172, 0x00C2, -45 },
  { 0x0172, 0x00C4, -45 },
  { 0x0172, 0x00C0, -45 },
  { 0x0172, 0x0100, -45 },
  { 0x0172, 0x0104, -45 },
  { 0x0172, 0x00C5, -45 },
  { 0x0172, 0x00C3, -45 },
  { 0x016E, 0x0041, -45 },
  { 0x016E, 0x00C1, -45 },
  { 0x016E, 0x0102, -45 },
  { 0x016E, 0x00C2, -45 },
  { 0x016E, 0x00C4, -45 },
  { 0x016E, 0x00C0, -45 },
  { 0x016E, 0x0100, -45 },
  { 0x016E, 0x0104, -45 },
  { 0x016E, 0x00C5, -45 },
  { 0x016E, 0x00C3, -45 },
  { 0x0056, 0x0041, -85 },
  { 0x0056, 0x00C1, -85 },
  { 0x0056, 0x0102, -85 },
  { 0x0056, 0x00C2, -85 },
  { 0x0056, 0x00C4, -85 },
  { 0x0056, 0x00C0, -85 },
  { 0x0056, 0x0100, -85 },
  { 0x0056, 0x0104, -85 },
  { 0x0056, 0x00C5, -85 },
  { 0x0056, 0x00C3, -85 },
  { 0x0056, 0x0047, -10 },
  { 0x0056, 0x011E, -10 },
  { 0x0056, 0x0122, -10 },
  { 0x0056, 0x004F, -30 },
  { 0x0056, 0x00D3, -30 },
  { 0x0056, 0x00D4, -30 },
  { 0x0056, 0x00D6, -30 },
  { 0x0056, 0x00D2, -30 },
  { 0x0056, 0x0150, -30 },
  { 0x0056, 0x014C, -30 },
  { 0x0056, 0x00D8, -30 },
  { 0x0056, 0x00D5, -30 },
  { 0x0056, 0x0061, -111 },
  { 0x0056, 0x00E1, -111 },
  { 0x0056, 0x0103, -111 },
  { 0x0056, 0x00E2, -111 },
  { 0x0056, 0x00E4, -111 },
  { 0x0056, 0x00E0, -111 },
  { 0x0056, 0x0101, -111 },
  { 0x0056, 0x0105, -111 },
  { 0x0056, 0x00E5, -111 },
  { 0x0056, 0x00E3, -111 },
  { 0x0056, 0x003A, -74 },
  { 0x0056, 0x002C, -129 },
  { 0x0056, 0x0065, -111 },
  { 0x0056, 0x00E9, -111 },
  { 0x0056, 0x011B, -111 },
  { 0x0056, 0x00EA, -111 },
  { 0x0056, 0x00EB, -71 },
  { 0x0056, 0x0117, -111 },
  { 0x0056, 0x00E8, -71 },
  { 0x0056, 0x0113, -71 },
  { 0x0056, 0x0119, -111 },
  { 0x0056, 0x002D, -70 },
  { 0x0056, 0x0069, -55 },
  { 0x0056, 0x00ED, -55 },
  { 0x0056, 0x012F, -55 },
  { 0x0056, 0x006F, -111 },
  { 0x0056, 0x00F3, -111 },
  { 0x0056, 0x00F4, -111 },
  { 0x0056, 0x00F6, -111 },
  { 0x0056, 0x00F2, -111 },
  { 0x0056, 0x0151, -111 },
  { 0x0056, 0x014D, -111 },
  { 0x0056, 0x00F8, -111 },
  { 0x0056, 0x00F5, -111 },
  { 0x0056, 0x002E, -129 },
  { 0x0056, 0x003B, -74 },
  { 0x0056, 0x0075, -55 },
  { 0x0056, 0x00FA, -55 },
  { 0x0056, 0x00FB, -55 },
  { 0x0056, 0x00FC, -55 },
  { 0x0056, 0x00F9, -55 },
  { 0x0056, 0x0171, -55 },
  { 0x0056, 0x016B, -55 },
  { 0x0056, 0x0173, -55 },
  { 0x0056, 0x016F, -55 },
  { 0x0057, 0x0041, -74 },
  { 0x0057, 0x00C1, -74 },
  { 0x0057, 0x0102, -74 },
  { 0x0057, 0x00C2, -74 },
  { 0x0057, 0x00C4, -74 },
  { 0x0057, 0x00C0, -74 },
  { 0x0057, 0x0100, -74 },
  { 0x0057, 0x0104, -74 },
  { 0x0057, 0x00C5, -74 },
  { 0x0057, 0x00C3, -74 },
  { 0x0057, 0x004F, -15 },
  { 0x0057, 0x00D3, -15 },
  { 0x0057, 0x00D4, -15 },
  { 0x0057, 0x00D6, -15 },
  { 0x0057, 0x00D2, -15 },
  { 0x0057, 0x0150, -15 },
  { 0x0057, 0x014C, -15 },
  { 0x0057, 0x00D8, -15 },
  { 0x0057, 0x00D5, -15 },
  { 0x0057, 0x0061, -85 },
  { 0x0057, 0x00E1, -85 },
  { 0x0057, 0x0103, -85 },
  { 0x0057, 0x00E2, -85 },
  { 0x0057, 0x00E4, -85 },
  { 0x0057, 0x00E0, -85 },
  { 0x0057, 0x0101, -85 },
  { 0x0057, 0x0105, -85 },
  { 0x0057, 0x00E5, -85 },
  { 0x0057, 0x00E3, -85 },
  { 0x0057, 0x003A, -55 },
  { 0x0057, 0x002C, -74 },
  { 0x0057, 0x0065, -90 },
  { 0x0057, 0x00E9, -90 },
  { 0x0057, 0x011B, -90 },
  { 0x0057, 0x00EA, -90 },
  { 0x0057, 0x00EB, -50 },
  { 0x0057, 0x0117, -90 },
  { 0x0057, 0x00E8, -50 },
  { 0x0057, 0x0113, -50 },
  { 0x0057, 0x0119, -90 },
  { 0x0057, 0x002D, -50 },
  { 0x0057, 0x0069, -37 },
  { 0x0057, 0x00ED, -37 },
  { 0x0057, 0x012F, -37 },
  { 0x0057, 0x006F, -80 },
  { 0x0057, 0x00F3, -80 },
  { 0x0057, 0x00F4, -80 },
  { 0x0057, 0x00F6, -80 },
  { 0x0057, 0x00F2, -80 },
  { 0x0057, 0x0151, -80 },
  { 0x0057, 0x014D, -80 },
  { 0x0057, 0x00F8, -80 },
  { 0x0057, 0x00F5, -80 },
  { 0x0057, 0x002E, -74 },
  { 0x0057, 0x003B, -55 },
  { 0x0057, 0x0075, -55 },
  { 0x0057, 0x00FA, -55 },
  { 0x0057, 0x00FB, -55 },
  { 0x0057, 0x00FC, -55 },
  { 0x0057, 0x00F9, -55 },
  { 0x0057, 0x0171, -55 },
  { 0x0057, 0x016B, -55 },
  { 0x0057, 0x0173, -55 },
  { 0x0057, 0x016F, -55 },
  { 0x0057, 0x0079, -55 },
  { 0x0057, 0x00FD, -55 },
  { 0x0057, 0x00FF, -55 },
  { 0x0059, 0x0041, -74 },
  { 0x0059, 0x00C1, -74 },
  { 0x0059, 0x0102, -74 },
  { 0x0059, 0x00C2, -74 },
  { 0x0059, 0x00C4, -74 },
  { 0x0059, 0x00C0, -74 },
  { 0x0059, 0x0100, -74 },
  { 0x0059, 0x0104, -74 },
  { 0x0059, 0x00C5, -74 },
  { 0x0059, 0x00C3, -74 },
  { 0x0059, 0x004F, -25 },
  { 0x0059, 0x00D3, -25 },
  { 0x0059, 0x00D4, -25 },
  { 0x0059, 0x00D6, -25 },
  { 0x0059, 0x00D2, -25 },
  { 0x0059, 0x0150, -25 },
  { 0x0059, 0x014C, -25 },
  { 0x0059, 0x00D8, -25 },
  { 0x0059, 0x00D5, -25 },
  { 0x0059, 0x0061, -92 },
  { 0x0059, 0x00E1, -92 },
  { 0x0059, 0x0103, -92 },
  { 0x0059, 0x00E2, -92 },
  { 0x0059, 0x00E4, -92 },
  { 0x0059, 0x00E0, -92 },
  { 0x0059, 0x0101, -92 },
  { 0x0059, 0x0105, -92 },
  { 0x0059, 0x00E5, -92 },
  { 0x0059, 0x00E3, -92 },
  { 0x0059, 0x003A, -92 },
  { 0x0059, 0x002C, -92 },
  { 0x0059, 0x0065, -111 },
  { 0x0059, 0x00E9, -111 },
  { 0x0059, 0x011B, -111 },
  { 0x0059, 0x00EA, -71 },
  { 0x0059, 0x00EB, -71 },
  { 0x0059, 0x0117, -111 },
  { 0x0059, 0x00E8, -71 },
  { 0x0059, 0x0113, -71 },
  { 0x0059, 0x0119, -111 },
  { 0x0059, 0x002D, -92 },
  { 0x0059, 0x0069, -55 },
  { 0x0059, 0x00ED, -55 },
  { 0x0059, 0x012F, -55 },
  { 0x0059, 0x006F, -111 },
  { 0x0059, 0x00F3, -111 },
  { 0x0059, 0x00F4, -111 },
  { 0x0059, 0x00F6, -111 },
  { 0x0059, 0x00F2, -111 },
  { 0x0059, 0x0151, -111 },
  { 0x0059, 0x014D, -111 },
  { 0x0059, 0x00F8, -111 },
  { 0x0059, 0x00F5, -111 },
  { 0x0059, 0x002E, -74 },
  { 0x0059, 0x003B, -92 },
  { 0x0059, 0x0075, -92 },
  { 0x0059, 0x00FA, -92 },
  { 0x0059, 0x00FB, -92 },
  { 0x0059, 0x00FC, -92 },
  { 0x0059, 0x00F9, -92 },
  { 0x0059, 0x0171, -92 },
  { 0x0059, 0x016B, -92 },
  { 0x0059, 0x0173, -92 },
  { 0x0059, 0x016F, -92 },
  { 0x00DD, 0x0041, -74 },
  { 0x00DD, 0x00C1, -74 },
  { 0x00DD, 0x0102, -74 },
  { 0x00DD, 0x00C2, -74 },
  { 0x00DD, 0x00C4, -74 },
  { 0x00DD, 0x00C0, -74 },
  { 0x00DD, 0x0100, -74 },
  { 0x00DD, 0x0104, -74 },
  { 0x00DD, 0x00C5, -74 },
  { 0x00DD, 0x00C3, -74 },
  { 0x00DD, 0x004F, -25 },
  { 0x00DD, 0x00D3, -25 },
  { 0x00DD, 0x00D4, -25 },
  { 0x00DD, 0x00D6, -25 },
  { 0x00DD, 0x00D2, -25 },
  { 0x00DD, 0x0150, -25 },
  { 0x00DD, 0x014C, -25 },
  { 0x00DD, 0x00D8, -25 },
  { 0x00DD, 0x00D5, -25 },
  { 0x00DD, 0x0061, -92 },
  { 0x00DD, 0x00E1, -92 },
  { 0x00DD, 0x0103, -92 },
  { 0x00DD, 0x00E2, -92 },
  { 0x00DD, 0x00E4, -92 },
  { 0x00DD, 0x00E0, -92 },
  { 0x00DD, 0x0101, -92 },
  { 0x00DD, 0x0105, -92 },
  { 0x00DD, 0x00E5, -92 },
  { 0x00DD, 0x00E3, -92 },
  { 0x00DD, 0x003A, -92 },
  { 0x00DD, 0x002C, -92 },
  { 0x00DD, 0x0065, -111 },
  { 0x00DD, 0x00E9, -111 },
  { 0x00DD, 0x011B, -111 },
  { 0x00DD, 0x00EA, -71 },
  { 0x00DD, 0x00EB, -71 },
  { 0x00DD, 0x0117, -111 },
  { 0x00DD, 0x00E8, -71 },
  { 0x00DD, 0x0113, -71 },
  { 0x00DD, 0x0119, -111 },
  { 0x00DD, 0x002D, -92 },
  { 0x00DD, 0x0069, -55 },
  { 0x00DD, 0x00ED, -55 },
  { 0x00DD, 0x012F, -55 },
  { 0x00DD, 0x006F, -111 },
  { 0x00DD, 0x00F3, -111 },
  { 0x00DD, 0x00F4, -111 },
  { 0x00DD, 0x00F6, -111 },
  { 0x00DD, 0x00F2, -111 },
  { 0x00DD, 0x0151, -111 },
  { 0x00DD, 0x014D, -111 },
  { 0x00DD, 0x00F8, -111 },
  { 0x00DD, 0x00F5, -111 },
  { 0x00DD, 0x002E, -74 },
  { 0x00DD, 0x003B, -92 },
  { 0x00DD, 0x0075, -92 },
  { 0x00DD, 0x00FA, -92 },
  { 0x00DD, 0x00FB, -92 },
  { 0x00DD, 0x00FC, -92 },
  { 0x00DD, 0x00F9, -92 },
  { 0x00DD, 0x0171, -92 },
  { 0x00DD, 0x016B, -92 },
  { 0x00DD, 0x0173, -92 },
  { 0x00DD, 0x016F, -92 },
  { 0x0178, 0x0041, -74 },
  { 0x0178, 0x00C1, -74 },
  { 0x0178, 0x0102, -74 },
  { 0x0178, 0x00C2, -74 },
  { 0x0178, 0x00C4, -74 },
  { 0x0178, 0x00C0, -74 },
  { 0x0178, 0x0100, -74 },
  { 0x0178, 0x0104, -74 },
  { 0x0178, 0x00C5, -74 },
  { 0x0178, 0x00C3, -74 },
  { 0x0178, 0x004F, -25 },
  { 0x0178, 0x00D3, -25 },
  { 0x0178, 0x00D4, -25 },
  { 0x0178, 0x00D6, -25 },
  { 0x0178, 0x00D2, -25 },
  { 0x0178, 0x0150, -25 },
  { 0x0178, 0x014C, -25 },
  { 0x0178, 0x00D8, -25 },
  { 0x0178, 0x00D5, -25 },
  { 0x0178, 0x0061, -92 },
  { 0x0178, 0x00E1, -92 },
  { 0x0178, 0x0103, -92 },
  { 0x0178, 0x00E2, -92 },
  { 0x0178, 0x00E4, -92 },
  { 0x0178, 0x00E0, -92 },
  { 0x0178, 0x0101, -92 },
  { 0x0178, 0x0105, -92 },
  { 0x0178, 0x00E5, -92 },
  { 0x0178, 0x00E3, -92 },
  { 0x0178, 0x003A, -92 },
  { 0x0178, 0x002C, -92 },
  { 0x0178, 0x0065, -111 },
  { 0x0178, 0x00E9, -111 },
  { 0x0178, 0x011B, -111 },
  { 0x0178, 0x00EA, -71 },
  { 0x0178, 0x00EB, -71 },
  { 0x0178, 0x0117, -111 },
  { 0x0178, 0x00E8, -71 },
  { 0x0178, 0x0113, -71 },
  { 0x0178, 0x0119, -111 },
  { 0x0178, 0x002D, -92 },
  { 0x0178, 0x0069, -55 },
  { 0x0178, 0x00ED, -55 },
  { 0x0178, 0x012F, -55 },
  { 0x0178, 0x006F, -111 },
  { 0x0178, 0x00F3, -111 },
  { 0x0178, 0x00F4, -111 },
  { 0x0178, 0x00F6, -111 },
  { 0x0178, 0x00F2, -111 },
  { 0x0178, 0x0151, -111 },
  { 0x0178, 0x014D, -111 },
  { 0x0178, 0x00F8, -111 },
  { 0x0178, 0x00F5, -111 },
  { 0x0178, 0x002E, -74 },
  { 0x0178, 0x003B, -92 },
  { 0x0178, 0x0075, -92 },
  { 0x0178, 0x00FA, -92 },
  { 0x0178, 0x00FB, -92 },
  { 0x0178, 0x00FC, -92 },
  { 0x0178, 0x00F9, -92 },
  { 0x0178, 0x0171, -92 },
  { 0x0178, 0x016B, -92 },
  { 0x0178, 0x0173, -92 },
  { 0x0178, 0x016F, -92 },
  { 0x0062, 0x0062, -10 },
  { 0x0062, 0x002E, -40 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0063, 0x0068, -10 },
  { 0x0063, 0x006B, -10 },
  { 0x0063, 0x0137, -10 },
  { 0x0107, 0x0068, -10 },
  { 0x0107, 0x006B, -10 },
  { 0x0107, 0x0137, -10 },
  { 0x010D, 0x0068, -10 },
  { 0x010D, 0x006B, -10 },
  { 0x010D, 0x0137, -10 },
  { 0x00E7, 0x0068, -10 },
  { 0x00E7, 0x006B, -10 },
  { 0x00E7, 0x0137, -10 },
  { 0x002C, 0x201D, -95 },
  { 0x002C, 0x2019, -95 },
  { 0x0065, 0x0062, -10 },
  { 0x00E9, 0x0062, -10 },
  { 0x011B, 0x0062, -10 },
  { 0x00EA, 0x0062, -10 },
  { 0x00EB, 0x0062, -10 },
  { 0x0117, 0x0062, -10 },
  { 0x00E8, 0x0062, -10 },
  { 0x0113, 0x0062, -10 },
  { 0x0119, 0x0062, -10 },
  { 0x0066, 0x002C, -10 },
  { 0x0066, 0x0131, -30 },
  { 0x0066, 0x0065, -10 },
  { 0x0066, 0x00E9, -10 },
  { 0x0066, 0x0117, -10 },
  { 0x0066, 0x0119, -10 },
  { 0x0066, 0x0066, -18 },
  { 0x0066, 0x006F, -10 },
  { 0x0066, 0x00F3, -10 },
  { 0x0066, 0x00F4, -10 },
  { 0x0066, 0x00F2, -10 },
  { 0x0066, 0x0151, -10 },
  { 0x0066, 0x00F8, -10 },
  { 0x0066, 0x00F5, -10 },
  { 0x0066, 0x002E, -10 },
  { 0x0066, 0x2019, 55 },
  { 0x006B, 0x0065, -30 },
  { 0x006B, 0x00E9, -30 },
  { 0x006B, 0x011B, -30 },
  { 0x006B, 0x00EA, -30 },
  { 0x006B, 0x00EB, -30 },
  { 0x006B, 0x0117, -30 },
  { 0x006B, 0x00E8, -30 },
  { 0x006B, 0x0113, -30 },
  { 0x006B, 0x0119, -30 },
  { 0x006B, 0x006F, -10 },
  { 0x006B, 0x00F3, -10 },
  { 0x006B, 0x00F4, -10 },
  { 0x006B, 0x00F6, -10 },
  { 0x006B, 0x00F2, -10 },
  { 0x006B, 0x0151, -10 },
  { 0x006B, 0x014D, -10 },
  { 0x006B, 0x00F8, -10 },
  { 0x006B, 0x00F5, -10 },
  { 0x0137, 0x0065, -30 },
  { 0x0137, 0x00E9, -30 },
  { 0x0137, 0x011B, -30 },
  { 0x0137, 0x00EA, -30 },
  { 0x0137, 0x00EB, -30 },
  { 0x0137, 0x0117, -30 },
  { 0x0137, 0x00E8, -30 },
  { 0x0137, 0x0113, -30 },
  { 0x0137, 0x0119, -30 },
  { 0x0137, 0x006F, -10 },
  { 0x0137, 0x00F3, -10 },
  { 0x0137, 0x00F4, -10 },
  { 0x0137, 0x00F6, -10 },
  { 0x0137, 0x00F2, -10 },
  { 0x0137, 0x0151, -10 },
  { 0x0137, 0x014D, -10 },
  { 0x0137, 0x00F8, -10 },
  { 0x0137, 0x00F5, -10 },
  { 0x006E, 0x0076, -40 },
  { 0x0144, 0x0076, -40 },
  { 0x0148, 0x0076, -40 },
  { 0x0146, 0x0076, -40 },
  { 0x00F1, 0x0076, -40 },
  { 0x006F, 0x0076, -15 },
  { 0x006F, 0x0077, -25 },
  { 0x006F, 0x0078, -10 },
  { 0x006F, 0x0079, -10 },
  { 0x006F, 0x00FD, -10 },
  { 0x006F, 0x00FF, -10 },
  { 0x00F3, 0x0076, -15 },
  { 0x00F3, 0x0077, -25 },
  { 0x00F3, 0x0078, -10 },
  { 0x00F3, 0x0079, -10 },
  { 0x00F3, 0x00FD, -10 },
  { 0x00F3, 0x00FF, -10 },
  { 0x00F4, 0x0076, -15 },
  { 0x00F4, 0x0077, -25 },
  { 0x00F4, 0x0078, -10 },
  { 0x00F4, 0x0079, -10 },
  { 0x00F4, 0x00FD, -10 },
  { 0x00F4, 0x00FF, -10 },
  { 0x00F6, 0x0076, -15 },
  { 0x00F6, 0x0077, -25 },
  { 0x00F6, 0x0078, -10 },
  { 0x00F6, 0x0079, -10 },
  { 0x00F6, 0x00FD, -10 },
  { 0x00F6, 0x00FF, -10 },
  { 0x00F2, 0x0076, -15 },
  { 0x00F2, 0x0077, -25 },
  { 0x00F2, 0x0078, -10 },
  { 0x00F2, 0x0079, -10 },
  { 0x00F2, 0x00FD, -10 },
  { 0x00F2, 0x00FF, -10 },
  { 0x0151, 0x0076, -15 },
  { 0x0151, 0x0077, -25 },
  { 0x0151, 0x0078, -10 },
  { 0x0151, 0x0079, -10 },
  { 0x0151, 0x00FD, -10 },
  { 0x0151, 0x00FF, -10 },
  { 0x014D, 0x0076, -15 },
  { 0x014D, 0x0077, -25 },
  { 0x014D, 0x0078, -10 },
  { 0x014D, 0x0079, -10 },
  { 0x014D, 0x00FD, -10 },
  { 0x014D, 0x00FF, -10 },
  { 0x00F8, 0x0076, -15 },
  { 0x00F8, 0x0077, -25 },
  { 0x00F8, 0x0078, -10 },
  { 0x00F8, 0x0079, -10 },
  { 0x00F8, 0x00FD, -10 },
  { 0x00F8, 0x00FF, -10 },
  { 0x00F5, 0x0076, -15 },
  { 0x00F5, 0x0077, -25 },
  { 0x00F5, 0x0078, -10 },
  { 0x00F5, 0x0079, -10 },
  { 0x00F5, 0x00FD, -10 },
  { 0x00F5, 0x00FF, -10 },
  { 0x002E, 0x201D, -95 },
  { 0x002E, 0x2019, -95 },
  { 0x2018, 0x2018, -74 },
  { 0x2019, 0x0064, -15 },
  { 0x2019, 0x0111, -15 },
  { 0x2019, 0x2019, -74 },
  { 0x2019, 0x0072, -15 },
  { 0x2019, 0x0155, -15 },
  { 0x2019, 0x0159, -15 },
  { 0x2019, 0x0157, -15 },
  { 0x2019, 0x0073, -74 },
  { 0x2019, 0x015B, -74 },
  { 0x2019, 0x0161, -74 },
  { 0x2019, 0x015F, -74 },
  { 0x2019, 0x0219, -74 },
  { 0x2019, 0x0020, -74 },
  { 0x2019, 0x0074, -37 },
  { 0x2019, 0x0163, -37 },
  { 0x2019, 0x0076, -15 },
  { 0x0072, 0x002C, -65 },
  { 0x0072, 0x002E, -65 },
  { 0x0155, 0x002C, -65 },
  { 0x0155, 0x002E, -65 },
  { 0x0159, 0x002C, -65 },
  { 0x0159, 0x002E, -65 },
  { 0x0157, 0x002C, -65 },
  { 0x0157, 0x002E, -65 },
  { 0x0020, 0x0041, -37 },
  { 0x0020, 0x00C1, -37 },
  { 0x0020, 0x0102, -37 },
  { 0x0020, 0x00C2, -37 },
  { 0x0020, 0x00C4, -37 },
  { 0x0020, 0x00C0, -37 },
  { 0x0020, 0x0100, -37 },
  { 0x0020, 0x0104, -37 },
  { 0x0020, 0x00C5, -37 },
  { 0x0020, 0x00C3, -37 },
  { 0x0020, 0x0056, -70 },
  { 0x0020, 0x0057, -70 },
  { 0x0020, 0x0059, -70 },
  { 0x0020, 0x00DD, -70 },
  { 0x0020, 0x0178, -70 },
  { 0x0076, 0x002C, -37 },
  { 0x0076, 0x0065, -15 },
  { 0x0076, 0x00E9, -15 },
  { 0x0076, 0x011B, -15 },
  { 0x0076, 0x00EA, -15 },
  { 0x0076, 0x00EB, -15 },
  { 0x0076, 0x0117, -15 },
  { 0x0076, 0x00E8, -15 },
  { 0x0076, 0x0113, -15 },
  { 0x0076, 0x0119, -15 },
  { 0x0076, 0x006F, -15 },
  { 0x0076, 0x00F3, -15 },
  { 0x0076, 0x00F4, -15 },
  { 0x0076, 0x00F6, -15 },
  { 0x0076, 0x00F2, -15 },
  { 0x0076, 0x0151, -15 },
  { 0x0076, 0x014D, -15 },
  { 0x0076, 0x00F8, -15 },
  { 0x0076, 0x00F5, -15 },
  { 0x0076, 0x002E, -37 },
  { 0x0077, 0x0061, -10 },
  { 0x0077, 0x00E1, -10 },
  { 0x0077, 0x0103, -10 },
  { 0x0077, 0x00E2, -10 },
  { 0x0077, 0x00E4, -10 },
  { 0x0077, 0x00E0, -10 },
  { 0x0077, 0x0101, -10 },
  { 0x0077, 0x0105, -10 },
  { 0x0077, 0x00E5, -10 },
  { 0x0077, 0x00E3, -10 },
  { 0x0077, 0x002C, -37 },
  { 0x0077, 0x0065, -10 },
  { 0x0077, 0x00E9, -10 },
  { 0x0077, 0x011B, -10 },
  { 0x0077, 0x00EA, -10 },
  { 0x0077, 0x00EB, -10 },
  { 0x0077, 0x0117, -10 },
  { 0x0077, 0x00E8, -10 },
  { 0x0077, 0x0113, -10 },
  { 0x0077, 0x0119, -10 },
  { 0x0077, 0x006F, -15 },
  { 0x0077, 0x00F3, -15 },
  { 0x0077, 0x00F4, -15 },
  { 0x0077, 0x00F6, -15 },
  { 0x0077, 0x00F2, -15 },
  { 0x0077, 0x0151, -15 },
  { 0x0077, 0x014D, -15 },
  { 0x0077, 0x00F8, -15 },
  { 0x0077, 0x00F5, -15 },
  { 0x0077, 0x002E, -37 },
  { 0x0078, 0x0065, -10 },
  { 0x0078, 0x00E9, -10 },
  { 0x0078, 0x011B, -10 },
  { 0x0078, 0x00EA, -10 },
  { 0x0078, 0x00EB, -10 },
  { 0x0078, 0x0117, -10 },
  { 0x0078, 0x00E8, -10 },
  { 0x0078, 0x0113, -10 },
  { 0x0078, 0x0119, -10 },
  { 0x0079, 0x002C, -37 },
  { 0x0079, 0x002E, -37 },
  { 0x00FD, 0x002C, -37 },
  { 0x00FD, 0x002E, -37 },
  { 0x00FF, 0x002C, -37 },
  { 0x00FF, 0x002E, -37 },
  { 0, 0, 0 }
};

static const wxPdfKernPairDesc kpTableTimesItalic[] =
{
  { 0x0041, 0x0043, -30 },
  { 0x0041, 0x0106, -30 },
  { 0x0041, 0x010C, -30 },
  { 0x0041, 0x00C7, -30 },
  { 0x0041, 0x0047, -35 },
  { 0x0041, 0x011E, -35 },
  { 0x0041, 0x0122, -35 },
  { 0x0041, 0x004F, -40 },
  { 0x0041, 0x00D3, -40 },
  { 0x0041, 0x00D4, -40 },
  { 0x0041, 0x00D6, -40 },
  { 0x0041, 0x00D2, -40 },
  { 0x0041, 0x0150, -40 },
  { 0x0041, 0x014C, -40 },
  { 0x0041, 0x00D8, -40 },
  { 0x0041, 0x00D5, -40 },
  { 0x0041, 0x0051, -40 },
  { 0x0041, 0x0054, -37 },
  { 0x0041, 0x0164, -37 },
  { 0x0041, 0x0162, -37 },
  { 0x0041, 0x0055, -50 },
  { 0x0041, 0x00DA, -50 },
  { 0x0041, 0x00DB, -50 },
  { 0x0041, 0x00DC, -50 },
  { 0x0041, 0x00D9, -50 },
  { 0x0041, 0x0170, -50 },
  { 0x0041, 0x016A, -50 },
  { 0x0041, 0x0172, -50 },
  { 0x0041, 0x016E, -50 },
  { 0x0041, 0x0056, -105 },
  { 0x0041, 0x0057, -95 },
  { 0x0041, 0x0059, -55 },
  { 0x0041, 0x00DD, -55 },
  { 0x0041, 0x0178, -55 },
  { 0x0041, 0x2019, -37 },
  { 0x0041, 0x0075, -20 },
  { 0x0041, 0x00FA, -20 },
  { 0x0041, 0x00FB, -20 },
  { 0x0041, 0x00FC, -20 },
  { 0x0041, 0x00F9, -20 },
  { 0x0041, 0x0171, -20 },
  { 0x0041, 0x016B, -20 },
  { 0x0041, 0x0173, -20 },
  { 0x0041, 0x016F, -20 },
  { 0x0041, 0x0076, -55 },
  { 0x0041, 0x0077, -55 },
  { 0x0041, 0x0079, -55 },
  { 0x0041, 0x00FD, -55 },
  { 0x0041, 0x00FF, -55 },
  { 0x00C1, 0x0043, -30 },
  { 0x00C1, 0x0106, -30 },
  { 0x00C1, 0x010C, -30 },
  { 0x00C1, 0x00C7, -30 },
  { 0x00C1, 0x0047, -35 },
  { 0x00C1, 0x011E, -35 },
  { 0x00C1, 0x0122, -35 },
  { 0x00C1, 0x004F, -40 },
  { 0x00C1, 0x00D3, -40 },
  { 0x00C1, 0x00D4, -40 },
  { 0x00C1, 0x00D6, -40 },
  { 0x00C1, 0x00D2, -40 },
  { 0x00C1, 0x0150, -40 },
  { 0x00C1, 0x014C, -40 },
  { 0x00C1, 0x00D8, -40 },
  { 0x00C1, 0x00D5, -40 },
  { 0x00C1, 0x0051, -40 },
  { 0x00C1, 0x0054, -37 },
  { 0x00C1, 0x0164, -37 },
  { 0x00C1, 0x0162, -37 },
  { 0x00C1, 0x0055, -50 },
  { 0x00C1, 0x00DA, -50 },
  { 0x00C1, 0x00DB, -50 },
  { 0x00C1, 0x00DC, -50 },
  { 0x00C1, 0x00D9, -50 },
  { 0x00C1, 0x0170, -50 },
  { 0x00C1, 0x016A, -50 },
  { 0x00C1, 0x0172, -50 },
  { 0x00C1, 0x016E, -50 },
  { 0x00C1, 0x0056, -105 },
  { 0x00C1, 0x0057, -95 },
  { 0x00C1, 0x0059, -55 },
  { 0x00C1, 0x00DD, -55 },
  { 0x00C1, 0x0178, -55 },
  { 0x00C1, 0x2019, -37 },
  { 0x00C1, 0x0075, -20 },
  { 0x00C1, 0x00FA, -20 },
  { 0x00C1, 0x00FB, -20 },
  { 0x00C1, 0x00FC, -20 },
  { 0x00C1, 0x00F9, -20 },
  { 0x00C1, 0x0171, -20 },
  { 0x00C1, 0x016B, -20 },
  { 0x00C1, 0x0173, -20 },
  { 0x00C1, 0x016F, -20 },
  { 0x00C1, 0x0076, -55 },
  { 0x00C1, 0x0077, -55 },
  { 0x00C1, 0x0079, -55 },
  { 0x00C1, 0x00FD, -55 },
  { 0x00C1, 0x00FF, -55 },
  { 0x0102, 0x0043, -30 },
  { 0x0102, 0x0106, -30 },
  { 0x0102, 0x010C, -30 },
  { 0x0102, 0x00C7, -30 },
  { 0x0102, 0x0047, -35 },
  { 0x0102, 0x011E, -35 },
  { 0x0102, 0x0122, -35 },
  { 0x0102, 0x004F, -40 },
  { 0x0102, 0x00D3, -40 },
  { 0x0102, 0x00D4, -40 },
  { 0x0102, 0x00D6, -40 },
  { 0x0102, 0x00D2, -40 },
  { 0x0102, 0x0150, -40 },
  { 0x0102, 0x014C, -40 },
  { 0x0102, 0x00D8, -40 },
  { 0x0102, 0x00D5, -40 },
  { 0x0102, 0x0051, -40 },
  { 0x0102, 0x0054, -37 },
  { 0x0102, 0x0164, -37 },
  { 0x0102, 0x0162, -37 },
  { 0x0102, 0x0055, -50 },
  { 0x0102, 0x00DA, -50 },
  { 0x0102, 0x00DB, -50 },
  { 0x0102, 0x00DC, -50 },
  { 0x0102, 0x00D9, -50 },
  { 0x0102, 0x0170, -50 },
  { 0x0102, 0x016A, -50 },
  { 0x0102, 0x0172, -50 },
  { 0x0102, 0x016E, -50 },
  { 0x0102, 0x0056, -105 },
  { 0x0102, 0x0057, -95 },
  { 0x0102, 0x0059, -55 },
  { 0x0102, 0x00DD, -55 },
  { 0x0102, 0x0178, -55 },
  { 0x0102, 0x2019, -37 },
  { 0x0102, 0x0075, -20 },
  { 0x0102, 0x00FA, -20 },
  { 0x0102, 0x00FB, -20 },
  { 0x0102, 0x00FC, -20 },
  { 0x0102, 0x00F9, -20 },
  { 0x0102, 0x0171, -20 },
  { 0x0102, 0x016B, -20 },
  { 0x0102, 0x0173, -20 },
  { 0x0102, 0x016F, -20 },
  { 0x0102, 0x0076, -55 },
  { 0x0102, 0x0077, -55 },
  { 0x0102, 0x0079, -55 },
  { 0x0102, 0x00FD, -55 },
  { 0x0102, 0x00FF, -55 },
  { 0x00C2, 0x0043, -30 },
  { 0x00C2, 0x0106, -30 },
  { 0x00C2, 0x010C, -30 },
  { 0x00C2, 0x00C7, -30 },
  { 0x00C2, 0x0047, -35 },
  { 0x00C2, 0x011E, -35 },
  { 0x00C2, 0x0122, -35 },
  { 0x00C2, 0x004F, -40 },
  { 0x00C2, 0x00D3, -40 },
  { 0x00C2, 0x00D4, -40 },
  { 0x00C2, 0x00D6, -40 },
  { 0x00C2, 0x00D2, -40 },
  { 0x00C2, 0x0150, -40 },
  { 0x00C2, 0x014C, -40 },
  { 0x00C2, 0x00D8, -40 },
  { 0x00C2, 0x00D5, -40 },
  { 0x00C2, 0x0051, -40 },
  { 0x00C2, 0x0054, -37 },
  { 0x00C2, 0x0164, -37 },
  { 0x00C2, 0x0162, -37 },
  { 0x00C2, 0x0055, -50 },
  { 0x00C2, 0x00DA, -50 },
  { 0x00C2, 0x00DB, -50 },
  { 0x00C2, 0x00DC, -50 },
  { 0x00C2, 0x00D9, -50 },
  { 0x00C2, 0x0170, -50 },
  { 0x00C2, 0x016A, -50 },
  { 0x00C2, 0x0172, -50 },
  { 0x00C2, 0x016E, -50 },
  { 0x00C2, 0x0056, -105 },
  { 0x00C2, 0x0057, -95 },
  { 0x00C2, 0x0059, -55 },
  { 0x00C2, 0x00DD, -55 },
  { 0x00C2, 0x0178, -55 },
  { 0x00C2, 0x2019, -37 },
  { 0x00C2, 0x0075, -20 },
  { 0x00C2, 0x00FA, -20 },
  { 0x00C2, 0x00FB, -20 },
  { 0x00C2, 0x00FC, -20 },
  { 0x00C2, 0x00F9, -20 },
  { 0x00C2, 0x0171, -20 },
  { 0x00C2, 0x016B, -20 },
  { 0x00C2, 0x0173, -20 },
  { 0x00C2, 0x016F, -20 },
  { 0x00C2, 0x0076, -55 },
  { 0x00C2, 0x0077, -55 },
  { 0x00C2, 0x0079, -55 },
  { 0x00C2, 0x00FD, -55 },
  { 0x00C2, 0x00FF, -55 },
  { 0x00C4, 0x0043, -30 },
  { 0x00C4, 0x0106, -30 },
  { 0x00C4, 0x010C, -30 },
  { 0x00C4, 0x00C7, -30 },
  { 0x00C4, 0x0047, -35 },
  { 0x00C4, 0x011E, -35 },
  { 0x00C4, 0x0122, -35 },
  { 0x00C4, 0x004F, -40 },
  { 0x00C4, 0x00D3, -40 },
  { 0x00C4, 0x00D4, -40 },
  { 0x00C4, 0x00D6, -40 },
  { 0x00C4, 0x00D2, -40 },
  { 0x00C4, 0x0150, -40 },
  { 0x00C4, 0x014C, -40 },
  { 0x00C4, 0x00D8, -40 },
  { 0x00C4, 0x00D5, -40 },
  { 0x00C4, 0x0051, -40 },
  { 0x00C4, 0x0054, -37 },
  { 0x00C4, 0x0164, -37 },
  { 0x00C4, 0x0162, -37 },
  { 0x00C4, 0x0055, -50 },
  { 0x00C4, 0x00DA, -50 },
  { 0x00C4, 0x00DB, -50 },
  { 0x00C4, 0x00DC, -50 },
  { 0x00C4, 0x00D9, -50 },
  { 0x00C4, 0x0170, -50 },
  { 0x00C4, 0x016A, -50 },
  { 0x00C4, 0x0172, -50 },
  { 0x00C4, 0x016E, -50 },
  { 0x00C4, 0x0056, -105 },
  { 0x00C4, 0x0057, -95 },
  { 0x00C4, 0x0059, -55 },
  { 0x00C4, 0x00DD, -55 },
  { 0x00C4, 0x0178, -55 },
  { 0x00C4, 0x2019, -37 },
  { 0x00C4, 0x0075, -20 },
  { 0x00C4, 0x00FA, -20 },
  { 0x00C4, 0x00FB, -20 },
  { 0x00C4, 0x00FC, -20 },
  { 0x00C4, 0x00F9, -20 },
  { 0x00C4, 0x0171, -20 },
  { 0x00C4, 0x016B, -20 },
  { 0x00C4, 0x0173, -20 },
  { 0x00C4, 0x016F, -20 },
  { 0x00C4, 0x0076, -55 },
  { 0x00C4, 0x0077, -55 },
  { 0x00C4, 0x0079, -55 },
  { 0x00C4, 0x00FD, -55 },
  { 0x00C4, 0x00FF, -55 },
  { 0x00C0, 0x0043, -30 },
  { 0x00C0, 0x0106, -30 },
  { 0x00C0, 0x010C, -30 },
  { 0x00C0, 0x00C7, -30 },
  { 0x00C0, 0x0047, -35 },
  { 0x00C0, 0x011E, -35 },
  { 0x00C0, 0x0122, -35 },
  { 0x00C0, 0x004F, -40 },
  { 0x00C0, 0x00D3, -40 },
  { 0x00C0, 0x00D4, -40 },
  { 0x00C0, 0x00D6, -40 },
  { 0x00C0, 0x00D2, -40 },
  { 0x00C0, 0x0150, -40 },
  { 0x00C0, 0x014C, -40 },
  { 0x00C0, 0x00D8, -40 },
  { 0x00C0, 0x00D5, -40 },
  { 0x00C0, 0x0051, -40 },
  { 0x00C0, 0x0054, -37 },
  { 0x00C0, 0x0164, -37 },
  { 0x00C0, 0x0162, -37 },
  { 0x00C0, 0x0055, -50 },
  { 0x00C0, 0x00DA, -50 },
  { 0x00C0, 0x00DB, -50 },
  { 0x00C0, 0x00DC, -50 },
  { 0x00C0, 0x00D9, -50 },
  { 0x00C0, 0x0170, -50 },
  { 0x00C0, 0x016A, -50 },
  { 0x00C0, 0x0172, -50 },
  { 0x00C0, 0x016E, -50 },
  { 0x00C0, 0x0056, -105 },
  { 0x00C0, 0x0057, -95 },
  { 0x00C0, 0x0059, -55 },
  { 0x00C0, 0x00DD, -55 },
  { 0x00C0, 0x0178, -55 },
  { 0x00C0, 0x2019, -37 },
  { 0x00C0, 0x0075, -20 },
  { 0x00C0, 0x00FA, -20 },
  { 0x00C0, 0x00FB, -20 },
  { 0x00C0, 0x00FC, -20 },
  { 0x00C0, 0x00F9, -20 },
  { 0x00C0, 0x0171, -20 },
  { 0x00C0, 0x016B, -20 },
  { 0x00C0, 0x0173, -20 },
  { 0x00C0, 0x016F, -20 },
  { 0x00C0, 0x0076, -55 },
  { 0x00C0, 0x0077, -55 },
  { 0x00C0, 0x0079, -55 },
  { 0x00C0, 0x00FD, -55 },
  { 0x00C0, 0x00FF, -55 },
  { 0x0100, 0x0043, -30 },
  { 0x0100, 0x0106, -30 },
  { 0x0100, 0x010C, -30 },
  { 0x0100, 0x00C7, -30 },
  { 0x0100, 0x0047, -35 },
  { 0x0100, 0x011E, -35 },
  { 0x0100, 0x0122, -35 },
  { 0x0100, 0x004F, -40 },
  { 0x0100, 0x00D3, -40 },
  { 0x0100, 0x00D4, -40 },
  { 0x0100, 0x00D6, -40 },
  { 0x0100, 0x00D2, -40 },
  { 0x0100, 0x0150, -40 },
  { 0x0100, 0x014C, -40 },
  { 0x0100, 0x00D8, -40 },
  { 0x0100, 0x00D5, -40 },
  { 0x0100, 0x0051, -40 },
  { 0x0100, 0x0054, -37 },
  { 0x0100, 0x0164, -37 },
  { 0x0100, 0x0162, -37 },
  { 0x0100, 0x0055, -50 },
  { 0x0100, 0x00DA, -50 },
  { 0x0100, 0x00DB, -50 },
  { 0x0100, 0x00DC, -50 },
  { 0x0100, 0x00D9, -50 },
  { 0x0100, 0x0170, -50 },
  { 0x0100, 0x016A, -50 },
  { 0x0100, 0x0172, -50 },
  { 0x0100, 0x016E, -50 },
  { 0x0100, 0x0056, -105 },
  { 0x0100, 0x0057, -95 },
  { 0x0100, 0x0059, -55 },
  { 0x0100, 0x00DD, -55 },
  { 0x0100, 0x0178, -55 },
  { 0x0100, 0x2019, -37 },
  { 0x0100, 0x0075, -20 },
  { 0x0100, 0x00FA, -20 },
  { 0x0100, 0x00FB, -20 },
  { 0x0100, 0x00FC, -20 },
  { 0x0100, 0x00F9, -20 },
  { 0x0100, 0x0171, -20 },
  { 0x0100, 0x016B, -20 },
  { 0x0100, 0x0173, -20 },
  { 0x0100, 0x016F, -20 },
  { 0x0100, 0x0076, -55 },
  { 0x0100, 0x0077, -55 },
  { 0x0100, 0x0079, -55 },
  { 0x0100, 0x00FD, -55 },
  { 0x0100, 0x00FF, -55 },
  { 0x0104, 0x0043, -30 },
  { 0x0104, 0x0106, -30 },
  { 0x0104, 0x010C, -30 },
  { 0x0104, 0x00C7, -30 },
  { 0x0104, 0x0047, -35 },
  { 0x0104, 0x011E, -35 },
  { 0x0104, 0x0122, -35 },
  { 0x0104, 0x004F, -40 },
  { 0x0104, 0x00D3, -40 },
  { 0x0104, 0x00D4, -40 },
  { 0x0104, 0x00D6, -40 },
  { 0x0104, 0x00D2, -40 },
  { 0x0104, 0x0150, -40 },
  { 0x0104, 0x014C, -40 },
  { 0x0104, 0x00D8, -40 },
  { 0x0104, 0x00D5, -40 },
  { 0x0104, 0x0051, -40 },
  { 0x0104, 0x0054, -37 },
  { 0x0104, 0x0164, -37 },
  { 0x0104, 0x0162, -37 },
  { 0x0104, 0x0055, -50 },
  { 0x0104, 0x00DA, -50 },
  { 0x0104, 0x00DB, -50 },
  { 0x0104, 0x00DC, -50 },
  { 0x0104, 0x00D9, -50 },
  { 0x0104, 0x0170, -50 },
  { 0x0104, 0x016A, -50 },
  { 0x0104, 0x0172, -50 },
  { 0x0104, 0x016E, -50 },
  { 0x0104, 0x0056, -105 },
  { 0x0104, 0x0057, -95 },
  { 0x0104, 0x0059, -55 },
  { 0x0104, 0x00DD, -55 },
  { 0x0104, 0x0178, -55 },
  { 0x0104, 0x2019, -37 },
  { 0x0104, 0x0075, -20 },
  { 0x0104, 0x00FA, -20 },
  { 0x0104, 0x00FB, -20 },
  { 0x0104, 0x00FC, -20 },
  { 0x0104, 0x00F9, -20 },
  { 0x0104, 0x0171, -20 },
  { 0x0104, 0x016B, -20 },
  { 0x0104, 0x0173, -20 },
  { 0x0104, 0x016F, -20 },
  { 0x0104, 0x0076, -55 },
  { 0x0104, 0x0077, -55 },
  { 0x0104, 0x0079, -55 },
  { 0x0104, 0x00FD, -55 },
  { 0x0104, 0x00FF, -55 },
  { 0x00C5, 0x0043, -30 },
  { 0x00C5, 0x0106, -30 },
  { 0x00C5, 0x010C, -30 },
  { 0x00C5, 0x00C7, -30 },
  { 0x00C5, 0x0047, -35 },
  { 0x00C5, 0x011E, -35 },
  { 0x00C5, 0x0122, -35 },
  { 0x00C5, 0x004F, -40 },
  { 0x00C5, 0x00D3, -40 },
  { 0x00C5, 0x00D4, -40 },
  { 0x00C5, 0x00D6, -40 },
  { 0x00C5, 0x00D2, -40 },
  { 0x00C5, 0x0150, -40 },
  { 0x00C5, 0x014C, -40 },
  { 0x00C5, 0x00D8, -40 },
  { 0x00C5, 0x00D5, -40 },
  { 0x00C5, 0x0051, -40 },
  { 0x00C5, 0x0054, -37 },
  { 0x00C5, 0x0164, -37 },
  { 0x00C5, 0x0162, -37 },
  { 0x00C5, 0x0055, -50 },
  { 0x00C5, 0x00DA, -50 },
  { 0x00C5, 0x00DB, -50 },
  { 0x00C5, 0x00DC, -50 },
  { 0x00C5, 0x00D9, -50 },
  { 0x00C5, 0x0170, -50 },
  { 0x00C5, 0x016A, -50 },
  { 0x00C5, 0x0172, -50 },
  { 0x00C5, 0x016E, -50 },
  { 0x00C5, 0x0056, -105 },
  { 0x00C5, 0x0057, -95 },
  { 0x00C5, 0x0059, -55 },
  { 0x00C5, 0x00DD, -55 },
  { 0x00C5, 0x0178, -55 },
  { 0x00C5, 0x2019, -37 },
  { 0x00C5, 0x0075, -20 },
  { 0x00C5, 0x00FA, -20 },
  { 0x00C5, 0x00FB, -20 },
  { 0x00C5, 0x00FC, -20 },
  { 0x00C5, 0x00F9, -20 },
  { 0x00C5, 0x0171, -20 },
  { 0x00C5, 0x016B, -20 },
  { 0x00C5, 0x0173, -20 },
  { 0x00C5, 0x016F, -20 },
  { 0x00C5, 0x0076, -55 },
  { 0x00C5, 0x0077, -55 },
  { 0x00C5, 0x0079, -55 },
  { 0x00C5, 0x00FD, -55 },
  { 0x00C5, 0x00FF, -55 },
  { 0x00C3, 0x0043, -30 },
  { 0x00C3, 0x0106, -30 },
  { 0x00C3, 0x010C, -30 },
  { 0x00C3, 0x00C7, -30 },
  { 0x00C3, 0x0047, -35 },
  { 0x00C3, 0x011E, -35 },
  { 0x00C3, 0x0122, -35 },
  { 0x00C3, 0x004F, -40 },
  { 0x00C3, 0x00D3, -40 },
  { 0x00C3, 0x00D4, -40 },
  { 0x00C3, 0x00D6, -40 },
  { 0x00C3, 0x00D2, -40 },
  { 0x00C3, 0x0150, -40 },
  { 0x00C3, 0x014C, -40 },
  { 0x00C3, 0x00D8, -40 },
  { 0x00C3, 0x00D5, -40 },
  { 0x00C3, 0x0051, -40 },
  { 0x00C3, 0x0054, -37 },
  { 0x00C3, 0x0164, -37 },
  { 0x00C3, 0x0162, -37 },
  { 0x00C3, 0x0055, -50 },
  { 0x00C3, 0x00DA, -50 },
  { 0x00C3, 0x00DB, -50 },
  { 0x00C3, 0x00DC, -50 },
  { 0x00C3, 0x00D9, -50 },
  { 0x00C3, 0x0170, -50 },
  { 0x00C3, 0x016A, -50 },
  { 0x00C3, 0x0172, -50 },
  { 0x00C3, 0x016E, -50 },
  { 0x00C3, 0x0056, -105 },
  { 0x00C3, 0x0057, -95 },
  { 0x00C3, 0x0059, -55 },
  { 0x00C3, 0x00DD, -55 },
  { 0x00C3, 0x0178, -55 },
  { 0x00C3, 0x2019, -37 },
  { 0x00C3, 0x0075, -20 },
  { 0x00C3, 0x00FA, -20 },
  { 0x00C3, 0x00FB, -20 },
  { 0x00C3, 0x00FC, -20 },
  { 0x00C3, 0x00F9, -20 },
  { 0x00C3, 0x0171, -20 },
  { 0x00C3, 0x016B, -20 },
  { 0x00C3, 0x0173, -20 },
  { 0x00C3, 0x016F, -20 },
  { 0x00C3, 0x0076, -55 },
  { 0x00C3, 0x0077, -55 },
  { 0x00C3, 0x0079, -55 },
  { 0x00C3, 0x00FD, -55 },
  { 0x00C3, 0x00FF, -55 },
  { 0x0042, 0x0041, -25 },
  { 0x0042, 0x00C1, -25 },
  { 0x0042, 0x0102, -25 },
  { 0x0042, 0x00C2, -25 },
  { 0x0042, 0x00C4, -25 },
  { 0x0042, 0x00C0, -25 },
  { 0x0042, 0x0100, -25 },
  { 0x0042, 0x0104, -25 },
  { 0x0042, 0x00C5, -25 },
  { 0x0042, 0x00C3, -25 },
  { 0x0042, 0x0055, -10 },
  { 0x0042, 0x00DA, -10 },
  { 0x0042, 0x00DB, -10 },
  { 0x0042, 0x00DC, -10 },
  { 0x0042, 0x00D9, -10 },
  { 0x0042, 0x0170, -10 },
  { 0x0042, 0x016A, -10 },
  { 0x0042, 0x0172, -10 },
  { 0x0042, 0x016E, -10 },
  { 0x0044, 0x0041, -35 },
  { 0x0044, 0x00C1, -35 },
  { 0x0044, 0x0102, -35 },
  { 0x0044, 0x00C2, -35 },
  { 0x0044, 0x00C4, -35 },
  { 0x0044, 0x00C0, -35 },
  { 0x0044, 0x0100, -35 },
  { 0x0044, 0x0104, -35 },
  { 0x0044, 0x00C5, -35 },
  { 0x0044, 0x00C3, -35 },
  { 0x0044, 0x0056, -40 },
  { 0x0044, 0x0057, -40 },
  { 0x0044, 0x0059, -40 },
  { 0x0044, 0x00DD, -40 },
  { 0x0044, 0x0178, -40 },
  { 0x010E, 0x0041, -35 },
  { 0x010E, 0x00C1, -35 },
  { 0x010E, 0x0102, -35 },
  { 0x010E, 0x00C2, -35 },
  { 0x010E, 0x00C4, -35 },
  { 0x010E, 0x00C0, -35 },
  { 0x010E, 0x0100, -35 },
  { 0x010E, 0x0104, -35 },
  { 0x010E, 0x00C5, -35 },
  { 0x010E, 0x00C3, -35 },
  { 0x010E, 0x0056, -40 },
  { 0x010E, 0x0057, -40 },
  { 0x010E, 0x0059, -40 },
  { 0x010E, 0x00DD, -40 },
  { 0x010E, 0x0178, -40 },
  { 0x0110, 0x0041, -35 },
  { 0x0110, 0x00C1, -35 },
  { 0x0110, 0x0102, -35 },
  { 0x0110, 0x00C2, -35 },
  { 0x0110, 0x00C4, -35 },
  { 0x0110, 0x00C0, -35 },
  { 0x0110, 0x0100, -35 },
  { 0x0110, 0x0104, -35 },
  { 0x0110, 0x00C5, -35 },
  { 0x0110, 0x00C3, -35 },
  { 0x0110, 0x0056, -40 },
  { 0x0110, 0x0057, -40 },
  { 0x0110, 0x0059, -40 },
  { 0x0110, 0x00DD, -40 },
  { 0x0110, 0x0178, -40 },
  { 0x0046, 0x0041, -115 },
  { 0x0046, 0x00C1, -115 },
  { 0x0046, 0x0102, -115 },
  { 0x0046, 0x00C2, -115 },
  { 0x0046, 0x00C4, -115 },
  { 0x0046, 0x00C0, -115 },
  { 0x0046, 0x0100, -115 },
  { 0x0046, 0x0104, -115 },
  { 0x0046, 0x00C5, -115 },
  { 0x0046, 0x00C3, -115 },
  { 0x0046, 0x0061, -75 },
  { 0x0046, 0x00E1, -75 },
  { 0x0046, 0x0103, -75 },
  { 0x0046, 0x00E2, -75 },
  { 0x0046, 0x00E4, -75 },
  { 0x0046, 0x00E0, -75 },
  { 0x0046, 0x0101, -75 },
  { 0x0046, 0x0105, -75 },
  { 0x0046, 0x00E5, -75 },
  { 0x0046, 0x00E3, -75 },
  { 0x0046, 0x002C, -135 },
  { 0x0046, 0x0065, -75 },
  { 0x0046, 0x00E9, -75 },
  { 0x0046, 0x011B, -75 },
  { 0x0046, 0x00EA, -75 },
  { 0x0046, 0x00EB, -75 },
  { 0x0046, 0x0117, -75 },
  { 0x0046, 0x00E8, -75 },
  { 0x0046, 0x0113, -75 },
  { 0x0046, 0x0119, -75 },
  { 0x0046, 0x0069, -45 },
  { 0x0046, 0x00ED, -45 },
  { 0x0046, 0x00EE, -45 },
  { 0x0046, 0x00EF, -45 },
  { 0x0046, 0x00EC, -45 },
  { 0x0046, 0x012B, -45 },
  { 0x0046, 0x012F, -45 },
  { 0x0046, 0x006F, -105 },
  { 0x0046, 0x00F3, -105 },
  { 0x0046, 0x00F4, -105 },
  { 0x0046, 0x00F6, -105 },
  { 0x0046, 0x00F2, -105 },
  { 0x0046, 0x0151, -105 },
  { 0x0046, 0x014D, -105 },
  { 0x0046, 0x00F8, -105 },
  { 0x0046, 0x00F5, -105 },
  { 0x0046, 0x002E, -135 },
  { 0x0046, 0x0072, -55 },
  { 0x0046, 0x0155, -55 },
  { 0x0046, 0x0159, -55 },
  { 0x0046, 0x0157, -55 },
  { 0x004A, 0x0041, -40 },
  { 0x004A, 0x00C1, -40 },
  { 0x004A, 0x0102, -40 },
  { 0x004A, 0x00C2, -40 },
  { 0x004A, 0x00C4, -40 },
  { 0x004A, 0x00C0, -40 },
  { 0x004A, 0x0100, -40 },
  { 0x004A, 0x0104, -40 },
  { 0x004A, 0x00C5, -40 },
  { 0x004A, 0x00C3, -40 },
  { 0x004A, 0x0061, -35 },
  { 0x004A, 0x00E1, -35 },
  { 0x004A, 0x0103, -35 },
  { 0x004A, 0x00E2, -35 },
  { 0x004A, 0x00E4, -35 },
  { 0x004A, 0x00E0, -35 },
  { 0x004A, 0x0101, -35 },
  { 0x004A, 0x0105, -35 },
  { 0x004A, 0x00E5, -35 },
  { 0x004A, 0x00E3, -35 },
  { 0x004A, 0x002C, -25 },
  { 0x004A, 0x0065, -25 },
  { 0x004A, 0x00E9, -25 },
  { 0x004A, 0x011B, -25 },
  { 0x004A, 0x00EA, -25 },
  { 0x004A, 0x00EB, -25 },
  { 0x004A, 0x0117, -25 },
  { 0x004A, 0x00E8, -25 },
  { 0x004A, 0x0113, -25 },
  { 0x004A, 0x0119, -25 },
  { 0x004A, 0x006F, -25 },
  { 0x004A, 0x00F3, -25 },
  { 0x004A, 0x00F4, -25 },
  { 0x004A, 0x00F6, -25 },
  { 0x004A, 0x00F2, -25 },
  { 0x004A, 0x0151, -25 },
  { 0x004A, 0x014D, -25 },
  { 0x004A, 0x00F8, -25 },
  { 0x004A, 0x00F5, -25 },
  { 0x004A, 0x002E, -25 },
  { 0x004A, 0x0075, -35 },
  { 0x004A, 0x00FA, -35 },
  { 0x004A, 0x00FB, -35 },
  { 0x004A, 0x00FC, -35 },
  { 0x004A, 0x00F9, -35 },
  { 0x004A, 0x0171, -35 },
  { 0x004A, 0x016B, -35 },
  { 0x004A, 0x0173, -35 },
  { 0x004A, 0x016F, -35 },
  { 0x004B, 0x004F, -50 },
  { 0x004B, 0x00D3, -50 },
  { 0x004B, 0x00D4, -50 },
  { 0x004B, 0x00D6, -50 },
  { 0x004B, 0x00D2, -50 },
  { 0x004B, 0x0150, -50 },
  { 0x004B, 0x014C, -50 },
  { 0x004B, 0x00D8, -50 },
  { 0x004B, 0x00D5, -50 },
  { 0x004B, 0x0065, -35 },
  { 0x004B, 0x00E9, -35 },
  { 0x004B, 0x011B, -35 },
  { 0x004B, 0x00EA, -35 },
  { 0x004B, 0x00EB, -35 },
  { 0x004B, 0x0117, -35 },
  { 0x004B, 0x00E8, -35 },
  { 0x004B, 0x0113, -35 },
  { 0x004B, 0x0119, -35 },
  { 0x004B, 0x006F, -40 },
  { 0x004B, 0x00F3, -40 },
  { 0x004B, 0x00F4, -40 },
  { 0x004B, 0x00F6, -40 },
  { 0x004B, 0x00F2, -40 },
  { 0x004B, 0x0151, -40 },
  { 0x004B, 0x014D, -40 },
  { 0x004B, 0x00F8, -40 },
  { 0x004B, 0x00F5, -40 },
  { 0x004B, 0x0075, -40 },
  { 0x004B, 0x00FA, -40 },
  { 0x004B, 0x00FB, -40 },
  { 0x004B, 0x00FC, -40 },
  { 0x004B, 0x00F9, -40 },
  { 0x004B, 0x0171, -40 },
  { 0x004B, 0x016B, -40 },
  { 0x004B, 0x0173, -40 },
  { 0x004B, 0x016F, -40 },
  { 0x004B, 0x0079, -40 },
  { 0x004B, 0x00FD, -40 },
  { 0x004B, 0x00FF, -40 },
  { 0x0136, 0x004F, -50 },
  { 0x0136, 0x00D3, -50 },
  { 0x0136, 0x00D4, -50 },
  { 0x0136, 0x00D6, -50 },
  { 0x0136, 0x00D2, -50 },
  { 0x0136, 0x0150, -50 },
  { 0x0136, 0x014C, -50 },
  { 0x0136, 0x00D8, -50 },
  { 0x0136, 0x00D5, -50 },
  { 0x0136, 0x0065, -35 },
  { 0x0136, 0x00E9, -35 },
  { 0x0136, 0x011B, -35 },
  { 0x0136, 0x00EA, -35 },
  { 0x0136, 0x00EB, -35 },
  { 0x0136, 0x0117, -35 },
  { 0x0136, 0x00E8, -35 },
  { 0x0136, 0x0113, -35 },
  { 0x0136, 0x0119, -35 },
  { 0x0136, 0x006F, -40 },
  { 0x0136, 0x00F3, -40 },
  { 0x0136, 0x00F4, -40 },
  { 0x0136, 0x00F6, -40 },
  { 0x0136, 0x00F2, -40 },
  { 0x0136, 0x0151, -40 },
  { 0x0136, 0x014D, -40 },
  { 0x0136, 0x00F8, -40 },
  { 0x0136, 0x00F5, -40 },
  { 0x0136, 0x0075, -40 },
  { 0x0136, 0x00FA, -40 },
  { 0x0136, 0x00FB, -40 },
  { 0x0136, 0x00FC, -40 },
  { 0x0136, 0x00F9, -40 },
  { 0x0136, 0x0171, -40 },
  { 0x0136, 0x016B, -40 },
  { 0x0136, 0x0173, -40 },
  { 0x0136, 0x016F, -40 },
  { 0x0136, 0x0079, -40 },
  { 0x0136, 0x00FD, -40 },
  { 0x0136, 0x00FF, -40 },
  { 0x004C, 0x0054, -20 },
  { 0x004C, 0x0164, -20 },
  { 0x004C, 0x0162, -20 },
  { 0x004C, 0x0056, -55 },
  { 0x004C, 0x0057, -55 },
  { 0x004C, 0x0059, -20 },
  { 0x004C, 0x00DD, -20 },
  { 0x004C, 0x0178, -20 },
  { 0x004C, 0x2019, -37 },
  { 0x004C, 0x0079, -30 },
  { 0x004C, 0x00FD, -30 },
  { 0x004C, 0x00FF, -30 },
  { 0x0139, 0x0054, -20 },
  { 0x0139, 0x0164, -20 },
  { 0x0139, 0x0162, -20 },
  { 0x0139, 0x0056, -55 },
  { 0x0139, 0x0057, -55 },
  { 0x0139, 0x0059, -20 },
  { 0x0139, 0x00DD, -20 },
  { 0x0139, 0x0178, -20 },
  { 0x0139, 0x2019, -37 },
  { 0x0139, 0x0079, -30 },
  { 0x0139, 0x00FD, -30 },
  { 0x0139, 0x00FF, -30 },
  { 0x013B, 0x0054, -20 },
  { 0x013B, 0x0164, -20 },
  { 0x013B, 0x0162, -20 },
  { 0x013B, 0x0056, -55 },
  { 0x013B, 0x0057, -55 },
  { 0x013B, 0x0059, -20 },
  { 0x013B, 0x00DD, -20 },
  { 0x013B, 0x0178, -20 },
  { 0x013B, 0x2019, -37 },
  { 0x013B, 0x0079, -30 },
  { 0x013B, 0x00FD, -30 },
  { 0x013B, 0x00FF, -30 },
  { 0x0141, 0x0054, -20 },
  { 0x0141, 0x0164, -20 },
  { 0x0141, 0x0162, -20 },
  { 0x0141, 0x0056, -55 },
  { 0x0141, 0x0057, -55 },
  { 0x0141, 0x0059, -20 },
  { 0x0141, 0x00DD, -20 },
  { 0x0141, 0x0178, -20 },
  { 0x0141, 0x2019, -37 },
  { 0x0141, 0x0079, -30 },
  { 0x0141, 0x00FD, -30 },
  { 0x0141, 0x00FF, -30 },
  { 0x004E, 0x0041, -27 },
  { 0x004E, 0x00C1, -27 },
  { 0x004E, 0x0102, -27 },
  { 0x004E, 0x00C2, -27 },
  { 0x004E, 0x00C4, -27 },
  { 0x004E, 0x00C0, -27 },
  { 0x004E, 0x0100, -27 },
  { 0x004E, 0x0104, -27 },
  { 0x004E, 0x00C5, -27 },
  { 0x004E, 0x00C3, -27 },
  { 0x0143, 0x0041, -27 },
  { 0x0143, 0x00C1, -27 },
  { 0x0143, 0x0102, -27 },
  { 0x0143, 0x00C2, -27 },
  { 0x0143, 0x00C4, -27 },
  { 0x0143, 0x00C0, -27 },
  { 0x0143, 0x0100, -27 },
  { 0x0143, 0x0104, -27 },
  { 0x0143, 0x00C5, -27 },
  { 0x0143, 0x00C3, -27 },
  { 0x0147, 0x0041, -27 },
  { 0x0147, 0x00C1, -27 },
  { 0x0147, 0x0102, -27 },
  { 0x0147, 0x00C2, -27 },
  { 0x0147, 0x00C4, -27 },
  { 0x0147, 0x00C0, -27 },
  { 0x0147, 0x0100, -27 },
  { 0x0147, 0x0104, -27 },
  { 0x0147, 0x00C5, -27 },
  { 0x0147, 0x00C3, -27 },
  { 0x0145, 0x0041, -27 },
  { 0x0145, 0x00C1, -27 },
  { 0x0145, 0x0102, -27 },
  { 0x0145, 0x00C2, -27 },
  { 0x0145, 0x00C4, -27 },
  { 0x0145, 0x00C0, -27 },
  { 0x0145, 0x0100, -27 },
  { 0x0145, 0x0104, -27 },
  { 0x0145, 0x00C5, -27 },
  { 0x0145, 0x00C3, -27 },
  { 0x00D1, 0x0041, -27 },
  { 0x00D1, 0x00C1, -27 },
  { 0x00D1, 0x0102, -27 },
  { 0x00D1, 0x00C2, -27 },
  { 0x00D1, 0x00C4, -27 },
  { 0x00D1, 0x00C0, -27 },
  { 0x00D1, 0x0100, -27 },
  { 0x00D1, 0x0104, -27 },
  { 0x00D1, 0x00C5, -27 },
  { 0x00D1, 0x00C3, -27 },
  { 0x004F, 0x0041, -55 },
  { 0x004F, 0x00C1, -55 },
  { 0x004F, 0x0102, -55 },
  { 0x004F, 0x00C2, -55 },
  { 0x004F, 0x00C4, -55 },
  { 0x004F, 0x00C0, -55 },
  { 0x004F, 0x0100, -55 },
  { 0x004F, 0x0104, -55 },
  { 0x004F, 0x00C5, -55 },
  { 0x004F, 0x00C3, -55 },
  { 0x004F, 0x0054, -40 },
  { 0x004F, 0x0164, -40 },
  { 0x004F, 0x0162, -40 },
  { 0x004F, 0x0056, -50 },
  { 0x004F, 0x0057, -50 },
  { 0x004F, 0x0058, -40 },
  { 0x004F, 0x0059, -50 },
  { 0x004F, 0x00DD, -50 },
  { 0x004F, 0x0178, -50 },
  { 0x00D3, 0x0041, -55 },
  { 0x00D3, 0x00C1, -55 },
  { 0x00D3, 0x0102, -55 },
  { 0x00D3, 0x00C2, -55 },
  { 0x00D3, 0x00C4, -55 },
  { 0x00D3, 0x00C0, -55 },
  { 0x00D3, 0x0100, -55 },
  { 0x00D3, 0x0104, -55 },
  { 0x00D3, 0x00C5, -55 },
  { 0x00D3, 0x00C3, -55 },
  { 0x00D3, 0x0054, -40 },
  { 0x00D3, 0x0164, -40 },
  { 0x00D3, 0x0162, -40 },
  { 0x00D3, 0x0056, -50 },
  { 0x00D3, 0x0057, -50 },
  { 0x00D3, 0x0058, -40 },
  { 0x00D3, 0x0059, -50 },
  { 0x00D3, 0x00DD, -50 },
  { 0x00D3, 0x0178, -50 },
  { 0x00D4, 0x0041, -55 },
  { 0x00D4, 0x00C1, -55 },
  { 0x00D4, 0x0102, -55 },
  { 0x00D4, 0x00C2, -55 },
  { 0x00D4, 0x00C4, -55 },
  { 0x00D4, 0x00C0, -55 },
  { 0x00D4, 0x0100, -55 },
  { 0x00D4, 0x0104, -55 },
  { 0x00D4, 0x00C5, -55 },
  { 0x00D4, 0x00C3, -55 },
  { 0x00D4, 0x0054, -40 },
  { 0x00D4, 0x0164, -40 },
  { 0x00D4, 0x0162, -40 },
  { 0x00D4, 0x0056, -50 },
  { 0x00D4, 0x0057, -50 },
  { 0x00D4, 0x0058, -40 },
  { 0x00D4, 0x0059, -50 },
  { 0x00D4, 0x00DD, -50 },
  { 0x00D4, 0x0178, -50 },
  { 0x00D6, 0x0041, -55 },
  { 0x00D6, 0x00C1, -55 },
  { 0x00D6, 0x0102, -55 },
  { 0x00D6, 0x00C2, -55 },
  { 0x00D6, 0x00C4, -55 },
  { 0x00D6, 0x00C0, -55 },
  { 0x00D6, 0x0100, -55 },
  { 0x00D6, 0x0104, -55 },
  { 0x00D6, 0x00C5, -55 },
  { 0x00D6, 0x00C3, -55 },
  { 0x00D6, 0x0054, -40 },
  { 0x00D6, 0x0164, -40 },
  { 0x00D6, 0x0162, -40 },
  { 0x00D6, 0x0056, -50 },
  { 0x00D6, 0x0057, -50 },
  { 0x00D6, 0x0058, -40 },
  { 0x00D6, 0x0059, -50 },
  { 0x00D6, 0x00DD, -50 },
  { 0x00D6, 0x0178, -50 },
  { 0x00D2, 0x0041, -55 },
  { 0x00D2, 0x00C1, -55 },
  { 0x00D2, 0x0102, -55 },
  { 0x00D2, 0x00C2, -55 },
  { 0x00D2, 0x00C4, -55 },
  { 0x00D2, 0x00C0, -55 },
  { 0x00D2, 0x0100, -55 },
  { 0x00D2, 0x0104, -55 },
  { 0x00D2, 0x00C5, -55 },
  { 0x00D2, 0x00C3, -55 },
  { 0x00D2, 0x0054, -40 },
  { 0x00D2, 0x0164, -40 },
  { 0x00D2, 0x0162, -40 },
  { 0x00D2, 0x0056, -50 },
  { 0x00D2, 0x0057, -50 },
  { 0x00D2, 0x0058, -40 },
  { 0x00D2, 0x0059, -50 },
  { 0x00D2, 0x00DD, -50 },
  { 0x00D2, 0x0178, -50 },
  { 0x0150, 0x0041, -55 },
  { 0x0150, 0x00C1, -55 },
  { 0x0150, 0x0102, -55 },
  { 0x0150, 0x00C2, -55 },
  { 0x0150, 0x00C4, -55 },
  { 0x0150, 0x00C0, -55 },
  { 0x0150, 0x0100, -55 },
  { 0x0150, 0x0104, -55 },
  { 0x0150, 0x00C5, -55 },
  { 0x0150, 0x00C3, -55 },
  { 0x0150, 0x0054, -40 },
  { 0x0150, 0x0164, -40 },
  { 0x0150, 0x0162, -40 },
  { 0x0150, 0x0056, -50 },
  { 0x0150, 0x0057, -50 },
  { 0x0150, 0x0058, -40 },
  { 0x0150, 0x0059, -50 },
  { 0x0150, 0x00DD, -50 },
  { 0x0150, 0x0178, -50 },
  { 0x014C, 0x0041, -55 },
  { 0x014C, 0x00C1, -55 },
  { 0x014C, 0x0102, -55 },
  { 0x014C, 0x00C2, -55 },
  { 0x014C, 0x00C4, -55 },
  { 0x014C, 0x00C0, -55 },
  { 0x014C, 0x0100, -55 },
  { 0x014C, 0x0104, -55 },
  { 0x014C, 0x00C5, -55 },
  { 0x014C, 0x00C3, -55 },
  { 0x014C, 0x0054, -40 },
  { 0x014C, 0x0164, -40 },
  { 0x014C, 0x0162, -40 },
  { 0x014C, 0x0056, -50 },
  { 0x014C, 0x0057, -50 },
  { 0x014C, 0x0058, -40 },
  { 0x014C, 0x0059, -50 },
  { 0x014C, 0x00DD, -50 },
  { 0x014C, 0x0178, -50 },
  { 0x00D8, 0x0041, -55 },
  { 0x00D8, 0x00C1, -55 },
  { 0x00D8, 0x0102, -55 },
  { 0x00D8, 0x00C2, -55 },
  { 0x00D8, 0x00C4, -55 },
  { 0x00D8, 0x00C0, -55 },
  { 0x00D8, 0x0100, -55 },
  { 0x00D8, 0x0104, -55 },
  { 0x00D8, 0x00C5, -55 },
  { 0x00D8, 0x00C3, -55 },
  { 0x00D8, 0x0054, -40 },
  { 0x00D8, 0x0164, -40 },
  { 0x00D8, 0x0162, -40 },
  { 0x00D8, 0x0056, -50 },
  { 0x00D8, 0x0057, -50 },
  { 0x00D8, 0x0058, -40 },
  { 0x00D8, 0x0059, -50 },
  { 0x00D8, 0x00DD, -50 },
  { 0x00D8, 0x0178, -50 },
  { 0x00D5, 0x0041, -55 },
  { 0x00D5, 0x00C1, -55 },
  { 0x00D5, 0x0102, -55 },
  { 0x00D5, 0x00C2, -55 },
  { 0x00D5, 0x00C4, -55 },
  { 0x00D5, 0x00C0, -55 },
  { 0x00D5, 0x0100, -55 },
  { 0x00D5, 0x0104, -55 },
  { 0x00D5, 0x00C5, -55 },
  { 0x00D5, 0x00C3, -55 },
  { 0x00D5, 0x0054, -40 },
  { 0x00D5, 0x0164, -40 },
  { 0x00D5, 0x0162, -40 },
  { 0x00D5, 0x0056, -50 },
  { 0x00D5, 0x0057, -50 },
  { 0x00D5, 0x0058, -40 },
  { 0x00D5, 0x0059, -50 },
  { 0x00D5, 0x00DD, -50 },
  { 0x00D5, 0x0178, -50 },
  { 0x0050, 0x0041, -90 },
  { 0x0050, 0x00C1, -90 },
  { 0x0050, 0x0102, -90 },
  { 0x0050, 0x00C2, -90 },
  { 0x0050, 0x00C4, -90 },
  { 0x0050, 0x00C0, -90 },
  { 0x0050, 0x0100, -90 },
  { 0x0050, 0x0104, -90 },
  { 0x0050, 0x00C5, -90 },
  { 0x0050, 0x00C3, -90 },
  { 0x0050, 0x0061, -80 },
  { 0x0050, 0x00E1, -80 },
  { 0x0050, 0x0103, -80 },
  { 0x0050, 0x00E2, -80 },
  { 0x0050, 0x00E4, -80 },
  { 0x0050, 0x00E0, -80 },
  { 0x0050, 0x0101, -80 },
  { 0x0050, 0x0105, -80 },
  { 0x0050, 0x00E5, -80 },
  { 0x0050, 0x00E3, -80 },
  { 0x0050, 0x002C, -135 },
  { 0x0050, 0x0065, -80 },
  { 0x0050, 0x00E9, -80 },
  { 0x0050, 0x011B, -80 },
  { 0x0050, 0x00EA, -80 },
  { 0x0050, 0x00EB, -80 },
  { 0x0050, 0x0117, -80 },
  { 0x0050, 0x00E8, -80 },
  { 0x0050, 0x0113, -80 },
  { 0x0050, 0x0119, -80 },
  { 0x0050, 0x006F, -80 },
  { 0x0050, 0x00F3, -80 },
  { 0x0050, 0x00F4, -80 },
  { 0x0050, 0x00F6, -80 },
  { 0x0050, 0x00F2, -80 },
  { 0x0050, 0x0151, -80 },
  { 0x0050, 0x014D, -80 },
  { 0x0050, 0x00F8, -80 },
  { 0x0050, 0x00F5, -80 },
  { 0x0050, 0x002E, -135 },
  { 0x0051, 0x0055, -10 },
  { 0x0051, 0x00DA, -10 },
  { 0x0051, 0x00DB, -10 },
  { 0x0051, 0x00DC, -10 },
  { 0x0051, 0x00D9, -10 },
  { 0x0051, 0x0170, -10 },
  { 0x0051, 0x016A, -10 },
  { 0x0051, 0x0172, -10 },
  { 0x0051, 0x016E, -10 },
  { 0x0052, 0x004F, -40 },
  { 0x0052, 0x00D3, -40 },
  { 0x0052, 0x00D4, -40 },
  { 0x0052, 0x00D6, -40 },
  { 0x0052, 0x00D2, -40 },
  { 0x0052, 0x0150, -40 },
  { 0x0052, 0x014C, -40 },
  { 0x0052, 0x00D8, -40 },
  { 0x0052, 0x00D5, -40 },
  { 0x0052, 0x0055, -40 },
  { 0x0052, 0x00DA, -40 },
  { 0x0052, 0x00DB, -40 },
  { 0x0052, 0x00DC, -40 },
  { 0x0052, 0x00D9, -40 },
  { 0x0052, 0x0170, -40 },
  { 0x0052, 0x016A, -40 },
  { 0x0052, 0x0172, -40 },
  { 0x0052, 0x016E, -40 },
  { 0x0052, 0x0056, -18 },
  { 0x0052, 0x0057, -18 },
  { 0x0052, 0x0059, -18 },
  { 0x0052, 0x00DD, -18 },
  { 0x0052, 0x0178, -18 },
  { 0x0154, 0x004F, -40 },
  { 0x0154, 0x00D3, -40 },
  { 0x0154, 0x00D4, -40 },
  { 0x0154, 0x00D6, -40 },
  { 0x0154, 0x00D2, -40 },
  { 0x0154, 0x0150, -40 },
  { 0x0154, 0x014C, -40 },
  { 0x0154, 0x00D8, -40 },
  { 0x0154, 0x00D5, -40 },
  { 0x0154, 0x0055, -40 },
  { 0x0154, 0x00DA, -40 },
  { 0x0154, 0x00DB, -40 },
  { 0x0154, 0x00DC, -40 },
  { 0x0154, 0x00D9, -40 },
  { 0x0154, 0x0170, -40 },
  { 0x0154, 0x016A, -40 },
  { 0x0154, 0x0172, -40 },
  { 0x0154, 0x016E, -40 },
  { 0x0154, 0x0056, -18 },
  { 0x0154, 0x0057, -18 },
  { 0x0154, 0x0059, -18 },
  { 0x0154, 0x00DD, -18 },
  { 0x0154, 0x0178, -18 },
  { 0x0158, 0x004F, -40 },
  { 0x0158, 0x00D3, -40 },
  { 0x0158, 0x00D4, -40 },
  { 0x0158, 0x00D6, -40 },
  { 0x0158, 0x00D2, -40 },
  { 0x0158, 0x0150, -40 },
  { 0x0158, 0x014C, -40 },
  { 0x0158, 0x00D8, -40 },
  { 0x0158, 0x00D5, -40 },
  { 0x0158, 0x0055, -40 },
  { 0x0158, 0x00DA, -40 },
  { 0x0158, 0x00DB, -40 },
  { 0x0158, 0x00DC, -40 },
  { 0x0158, 0x00D9, -40 },
  { 0x0158, 0x0170, -40 },
  { 0x0158, 0x016A, -40 },
  { 0x0158, 0x0172, -40 },
  { 0x0158, 0x016E, -40 },
  { 0x0158, 0x0056, -18 },
  { 0x0158, 0x0057, -18 },
  { 0x0158, 0x0059, -18 },
  { 0x0158, 0x00DD, -18 },
  { 0x0158, 0x0178, -18 },
  { 0x0156, 0x004F, -40 },
  { 0x0156, 0x00D3, -40 },
  { 0x0156, 0x00D4, -40 },
  { 0x0156, 0x00D6, -40 },
  { 0x0156, 0x00D2, -40 },
  { 0x0156, 0x0150, -40 },
  { 0x0156, 0x014C, -40 },
  { 0x0156, 0x00D8, -40 },
  { 0x0156, 0x00D5, -40 },
  { 0x0156, 0x0055, -40 },
  { 0x0156, 0x00DA, -40 },
  { 0x0156, 0x00DB, -40 },
  { 0x0156, 0x00DC, -40 },
  { 0x0156, 0x00D9, -40 },
  { 0x0156, 0x0170, -40 },
  { 0x0156, 0x016A, -40 },
  { 0x0156, 0x0172, -40 },
  { 0x0156, 0x016E, -40 },
  { 0x0156, 0x0056, -18 },
  { 0x0156, 0x0057, -18 },
  { 0x0156, 0x0059, -18 },
  { 0x0156, 0x00DD, -18 },
  { 0x0156, 0x0178, -18 },
  { 0x0054, 0x0041, -50 },
  { 0x0054, 0x00C1, -50 },
  { 0x0054, 0x0102, -50 },
  { 0x0054, 0x00C2, -50 },
  { 0x0054, 0x00C4, -50 },
  { 0x0054, 0x00C0, -50 },
  { 0x0054, 0x0100, -50 },
  { 0x0054, 0x0104, -50 },
  { 0x0054, 0x00C5, -50 },
  { 0x0054, 0x00C3, -50 },
  { 0x0054, 0x004F, -18 },
  { 0x0054, 0x00D3, -18 },
  { 0x0054, 0x00D4, -18 },
  { 0x0054, 0x00D6, -18 },
  { 0x0054, 0x00D2, -18 },
  { 0x0054, 0x0150, -18 },
  { 0x0054, 0x014C, -18 },
  { 0x0054, 0x00D8, -18 },
  { 0x0054, 0x00D5, -18 },
  { 0x0054, 0x0061, -92 },
  { 0x0054, 0x00E1, -92 },
  { 0x0054, 0x0103, -92 },
  { 0x0054, 0x00E2, -92 },
  { 0x0054, 0x00E4, -92 },
  { 0x0054, 0x00E0, -92 },
  { 0x0054, 0x0101, -92 },
  { 0x0054, 0x0105, -92 },
  { 0x0054, 0x00E5, -92 },
  { 0x0054, 0x00E3, -92 },
  { 0x0054, 0x003A, -55 },
  { 0x0054, 0x002C, -74 },
  { 0x0054, 0x0065, -92 },
  { 0x0054, 0x00E9, -92 },
  { 0x0054, 0x011B, -92 },
  { 0x0054, 0x00EA, -52 },
  { 0x0054, 0x00EB, -52 },
  { 0x0054, 0x0117, -92 },
  { 0x0054, 0x00E8, -52 },
  { 0x0054, 0x0113, -52 },
  { 0x0054, 0x0119, -92 },
  { 0x0054, 0x002D, -74 },
  { 0x0054, 0x0069, -55 },
  { 0x0054, 0x00ED, -55 },
  { 0x0054, 0x012F, -55 },
  { 0x0054, 0x006F, -92 },
  { 0x0054, 0x00F3, -92 },
  { 0x0054, 0x00F4, -92 },
  { 0x0054, 0x00F6, -92 },
  { 0x0054, 0x00F2, -92 },
  { 0x0054, 0x0151, -92 },
  { 0x0054, 0x014D, -92 },
  { 0x0054, 0x00F8, -92 },
  { 0x0054, 0x00F5, -92 },
  { 0x0054, 0x002E, -74 },
  { 0x0054, 0x0072, -55 },
  { 0x0054, 0x0155, -55 },
  { 0x0054, 0x0159, -55 },
  { 0x0054, 0x0157, -55 },
  { 0x0054, 0x003B, -65 },
  { 0x0054, 0x0075, -55 },
  { 0x0054, 0x00FA, -55 },
  { 0x0054, 0x00FB, -55 },
  { 0x0054, 0x00FC, -55 },
  { 0x0054, 0x00F9, -55 },
  { 0x0054, 0x0171, -55 },
  { 0x0054, 0x016B, -55 },
  { 0x0054, 0x0173, -55 },
  { 0x0054, 0x016F, -55 },
  { 0x0054, 0x0077, -74 },
  { 0x0054, 0x0079, -74 },
  { 0x0054, 0x00FD, -74 },
  { 0x0054, 0x00FF, -34 },
  { 0x0164, 0x0041, -50 },
  { 0x0164, 0x00C1, -50 },
  { 0x0164, 0x0102, -50 },
  { 0x0164, 0x00C2, -50 },
  { 0x0164, 0x00C4, -50 },
  { 0x0164, 0x00C0, -50 },
  { 0x0164, 0x0100, -50 },
  { 0x0164, 0x0104, -50 },
  { 0x0164, 0x00C5, -50 },
  { 0x0164, 0x00C3, -50 },
  { 0x0164, 0x004F, -18 },
  { 0x0164, 0x00D3, -18 },
  { 0x0164, 0x00D4, -18 },
  { 0x0164, 0x00D6, -18 },
  { 0x0164, 0x00D2, -18 },
  { 0x0164, 0x0150, -18 },
  { 0x0164, 0x014C, -18 },
  { 0x0164, 0x00D8, -18 },
  { 0x0164, 0x00D5, -18 },
  { 0x0164, 0x0061, -92 },
  { 0x0164, 0x00E1, -92 },
  { 0x0164, 0x0103, -92 },
  { 0x0164, 0x00E2, -92 },
  { 0x0164, 0x00E4, -92 },
  { 0x0164, 0x00E0, -92 },
  { 0x0164, 0x0101, -92 },
  { 0x0164, 0x0105, -92 },
  { 0x0164, 0x00E5, -92 },
  { 0x0164, 0x00E3, -92 },
  { 0x0164, 0x003A, -55 },
  { 0x0164, 0x002C, -74 },
  { 0x0164, 0x0065, -92 },
  { 0x0164, 0x00E9, -92 },
  { 0x0164, 0x011B, -92 },
  { 0x0164, 0x00EA, -52 },
  { 0x0164, 0x00EB, -52 },
  { 0x0164, 0x0117, -92 },
  { 0x0164, 0x00E8, -52 },
  { 0x0164, 0x0113, -52 },
  { 0x0164, 0x0119, -92 },
  { 0x0164, 0x002D, -74 },
  { 0x0164, 0x0069, -55 },
  { 0x0164, 0x00ED, -55 },
  { 0x0164, 0x012F, -55 },
  { 0x0164, 0x006F, -92 },
  { 0x0164, 0x00F3, -92 },
  { 0x0164, 0x00F4, -92 },
  { 0x0164, 0x00F6, -92 },
  { 0x0164, 0x00F2, -92 },
  { 0x0164, 0x0151, -92 },
  { 0x0164, 0x014D, -92 },
  { 0x0164, 0x00F8, -92 },
  { 0x0164, 0x00F5, -92 },
  { 0x0164, 0x002E, -74 },
  { 0x0164, 0x0072, -55 },
  { 0x0164, 0x0155, -55 },
  { 0x0164, 0x0159, -55 },
  { 0x0164, 0x0157, -55 },
  { 0x0164, 0x003B, -65 },
  { 0x0164, 0x0075, -55 },
  { 0x0164, 0x00FA, -55 },
  { 0x0164, 0x00FB, -55 },
  { 0x0164, 0x00FC, -55 },
  { 0x0164, 0x00F9, -55 },
  { 0x0164, 0x0171, -55 },
  { 0x0164, 0x016B, -55 },
  { 0x0164, 0x0173, -55 },
  { 0x0164, 0x016F, -55 },
  { 0x0164, 0x0077, -74 },
  { 0x0164, 0x0079, -74 },
  { 0x0164, 0x00FD, -74 },
  { 0x0164, 0x00FF, -34 },
  { 0x0162, 0x0041, -50 },
  { 0x0162, 0x00C1, -50 },
  { 0x0162, 0x0102, -50 },
  { 0x0162, 0x00C2, -50 },
  { 0x0162, 0x00C4, -50 },
  { 0x0162, 0x00C0, -50 },
  { 0x0162, 0x0100, -50 },
  { 0x0162, 0x0104, -50 },
  { 0x0162, 0x00C5, -50 },
  { 0x0162, 0x00C3, -50 },
  { 0x0162, 0x004F, -18 },
  { 0x0162, 0x00D3, -18 },
  { 0x0162, 0x00D4, -18 },
  { 0x0162, 0x00D6, -18 },
  { 0x0162, 0x00D2, -18 },
  { 0x0162, 0x0150, -18 },
  { 0x0162, 0x014C, -18 },
  { 0x0162, 0x00D8, -18 },
  { 0x0162, 0x00D5, -18 },
  { 0x0162, 0x0061, -92 },
  { 0x0162, 0x00E1, -92 },
  { 0x0162, 0x0103, -92 },
  { 0x0162, 0x00E2, -92 },
  { 0x0162, 0x00E4, -92 },
  { 0x0162, 0x00E0, -92 },
  { 0x0162, 0x0101, -92 },
  { 0x0162, 0x0105, -92 },
  { 0x0162, 0x00E5, -92 },
  { 0x0162, 0x00E3, -92 },
  { 0x0162, 0x003A, -55 },
  { 0x0162, 0x002C, -74 },
  { 0x0162, 0x0065, -92 },
  { 0x0162, 0x00E9, -92 },
  { 0x0162, 0x011B, -92 },
  { 0x0162, 0x00EA, -52 },
  { 0x0162, 0x00EB, -52 },
  { 0x0162, 0x0117, -92 },
  { 0x0162, 0x00E8, -52 },
  { 0x0162, 0x0113, -52 },
  { 0x0162, 0x0119, -92 },
  { 0x0162, 0x002D, -74 },
  { 0x0162, 0x0069, -55 },
  { 0x0162, 0x00ED, -55 },
  { 0x0162, 0x012F, -55 },
  { 0x0162, 0x006F, -92 },
  { 0x0162, 0x00F3, -92 },
  { 0x0162, 0x00F4, -92 },
  { 0x0162, 0x00F6, -92 },
  { 0x0162, 0x00F2, -92 },
  { 0x0162, 0x0151, -92 },
  { 0x0162, 0x014D, -92 },
  { 0x0162, 0x00F8, -92 },
  { 0x0162, 0x00F5, -92 },
  { 0x0162, 0x002E, -74 },
  { 0x0162, 0x0072, -55 },
  { 0x0162, 0x0155, -55 },
  { 0x0162, 0x0159, -55 },
  { 0x0162, 0x0157, -55 },
  { 0x0162, 0x003B, -65 },
  { 0x0162, 0x0075, -55 },
  { 0x0162, 0x00FA, -55 },
  { 0x0162, 0x00FB, -55 },
  { 0x0162, 0x00FC, -55 },
  { 0x0162, 0x00F9, -55 },
  { 0x0162, 0x0171, -55 },
  { 0x0162, 0x016B, -55 },
  { 0x0162, 0x0173, -55 },
  { 0x0162, 0x016F, -55 },
  { 0x0162, 0x0077, -74 },
  { 0x0162, 0x0079, -74 },
  { 0x0162, 0x00FD, -74 },
  { 0x0162, 0x00FF, -34 },
  { 0x0055, 0x0041, -40 },
  { 0x0055, 0x00C1, -40 },
  { 0x0055, 0x0102, -40 },
  { 0x0055, 0x00C2, -40 },
  { 0x0055, 0x00C4, -40 },
  { 0x0055, 0x00C0, -40 },
  { 0x0055, 0x0100, -40 },
  { 0x0055, 0x0104, -40 },
  { 0x0055, 0x00C5, -40 },
  { 0x0055, 0x00C3, -40 },
  { 0x0055, 0x002C, -25 },
  { 0x0055, 0x002E, -25 },
  { 0x00DA, 0x0041, -40 },
  { 0x00DA, 0x00C1, -40 },
  { 0x00DA, 0x0102, -40 },
  { 0x00DA, 0x00C2, -40 },
  { 0x00DA, 0x00C4, -40 },
  { 0x00DA, 0x00C0, -40 },
  { 0x00DA, 0x0100, -40 },
  { 0x00DA, 0x0104, -40 },
  { 0x00DA, 0x00C5, -40 },
  { 0x00DA, 0x00C3, -40 },
  { 0x00DA, 0x002C, -25 },
  { 0x00DA, 0x002E, -25 },
  { 0x00DB, 0x0041, -40 },
  { 0x00DB, 0x00C1, -40 },
  { 0x00DB, 0x0102, -40 },
  { 0x00DB, 0x00C2, -40 },
  { 0x00DB, 0x00C4, -40 },
  { 0x00DB, 0x00C0, -40 },
  { 0x00DB, 0x0100, -40 },
  { 0x00DB, 0x0104, -40 },
  { 0x00DB, 0x00C5, -40 },
  { 0x00DB, 0x00C3, -40 },
  { 0x00DB, 0x002C, -25 },
  { 0x00DB, 0x002E, -25 },
  { 0x00DC, 0x0041, -40 },
  { 0x00DC, 0x00C1, -40 },
  { 0x00DC, 0x0102, -40 },
  { 0x00DC, 0x00C2, -40 },
  { 0x00DC, 0x00C4, -40 },
  { 0x00DC, 0x00C0, -40 },
  { 0x00DC, 0x0100, -40 },
  { 0x00DC, 0x0104, -40 },
  { 0x00DC, 0x00C5, -40 },
  { 0x00DC, 0x00C3, -40 },
  { 0x00DC, 0x002C, -25 },
  { 0x00DC, 0x002E, -25 },
  { 0x00D9, 0x0041, -40 },
  { 0x00D9, 0x00C1, -40 },
  { 0x00D9, 0x0102, -40 },
  { 0x00D9, 0x00C2, -40 },
  { 0x00D9, 0x00C4, -40 },
  { 0x00D9, 0x00C0, -40 },
  { 0x00D9, 0x0100, -40 },
  { 0x00D9, 0x0104, -40 },
  { 0x00D9, 0x00C5, -40 },
  { 0x00D9, 0x00C3, -40 },
  { 0x00D9, 0x002C, -25 },
  { 0x00D9, 0x002E, -25 },
  { 0x0170, 0x0041, -40 },
  { 0x0170, 0x00C1, -40 },
  { 0x0170, 0x0102, -40 },
  { 0x0170, 0x00C2, -40 },
  { 0x0170, 0x00C4, -40 },
  { 0x0170, 0x00C0, -40 },
  { 0x0170, 0x0100, -40 },
  { 0x0170, 0x0104, -40 },
  { 0x0170, 0x00C5, -40 },
  { 0x0170, 0x00C3, -40 },
  { 0x0170, 0x002C, -25 },
  { 0x0170, 0x002E, -25 },
  { 0x016A, 0x0041, -40 },
  { 0x016A, 0x00C1, -40 },
  { 0x016A, 0x0102, -40 },
  { 0x016A, 0x00C2, -40 },
  { 0x016A, 0x00C4, -40 },
  { 0x016A, 0x00C0, -40 },
  { 0x016A, 0x0100, -40 },
  { 0x016A, 0x0104, -40 },
  { 0x016A, 0x00C5, -40 },
  { 0x016A, 0x00C3, -40 },
  { 0x016A, 0x002C, -25 },
  { 0x016A, 0x002E, -25 },
  { 0x0172, 0x0041, -40 },
  { 0x0172, 0x00C1, -40 },
  { 0x0172, 0x0102, -40 },
  { 0x0172, 0x00C2, -40 },
  { 0x0172, 0x00C4, -40 },
  { 0x0172, 0x00C0, -40 },
  { 0x0172, 0x0100, -40 },
  { 0x0172, 0x0104, -40 },
  { 0x0172, 0x00C5, -40 },
  { 0x0172, 0x00C3, -40 },
  { 0x0172, 0x002C, -25 },
  { 0x0172, 0x002E, -25 },
  { 0x016E, 0x0041, -40 },
  { 0x016E, 0x00C1, -40 },
  { 0x016E, 0x0102, -40 },
  { 0x016E, 0x00C2, -40 },
  { 0x016E, 0x00C4, -40 },
  { 0x016E, 0x00C0, -40 },
  { 0x016E, 0x0100, -40 },
  { 0x016E, 0x0104, -40 },
  { 0x016E, 0x00C5, -40 },
  { 0x016E, 0x00C3, -40 },
  { 0x016E, 0x002C, -25 },
  { 0x016E, 0x002E, -25 },
  { 0x0056, 0x0041, -60 },
  { 0x0056, 0x00C1, -60 },
  { 0x0056, 0x0102, -60 },
  { 0x0056, 0x00C2, -60 },
  { 0x0056, 0x00C4, -60 },
  { 0x0056, 0x00C0, -60 },
  { 0x0056, 0x0100, -60 },
  { 0x0056, 0x0104, -60 },
  { 0x0056, 0x00C5, -60 },
  { 0x0056, 0x00C3, -60 },
  { 0x0056, 0x004F, -30 },
  { 0x0056, 0x00D3, -30 },
  { 0x0056, 0x00D4, -30 },
  { 0x0056, 0x00D6, -30 },
  { 0x0056, 0x00D2, -30 },
  { 0x0056, 0x0150, -30 },
  { 0x0056, 0x014C, -30 },
  { 0x0056, 0x00D8, -30 },
  { 0x0056, 0x00D5, -30 },
  { 0x0056, 0x0061, -111 },
  { 0x0056, 0x00E1, -111 },
  { 0x0056, 0x0103, -111 },
  { 0x0056, 0x00E2, -111 },
  { 0x0056, 0x00E4, -111 },
  { 0x0056, 0x00E0, -111 },
  { 0x0056, 0x0101, -111 },
  { 0x0056, 0x0105, -111 },
  { 0x0056, 0x00E5, -111 },
  { 0x0056, 0x00E3, -111 },
  { 0x0056, 0x003A, -65 },
  { 0x0056, 0x002C, -129 },
  { 0x0056, 0x0065, -111 },
  { 0x0056, 0x00E9, -111 },
  { 0x0056, 0x011B, -111 },
  { 0x0056, 0x00EA, -111 },
  { 0x0056, 0x00EB, -71 },
  { 0x0056, 0x0117, -111 },
  { 0x0056, 0x00E8, -71 },
  { 0x0056, 0x0113, -71 },
  { 0x0056, 0x0119, -111 },
  { 0x0056, 0x002D, -55 },
  { 0x0056, 0x0069, -74 },
  { 0x0056, 0x00ED, -74 },
  { 0x0056, 0x00EE, -34 },
  { 0x0056, 0x00EF, -34 },
  { 0x0056, 0x00EC, -34 },
  { 0x0056, 0x012B, -34 },
  { 0x0056, 0x012F, -74 },
  { 0x0056, 0x006F, -111 },
  { 0x0056, 0x00F3, -111 },
  { 0x0056, 0x00F4, -111 },
  { 0x0056, 0x00F6, -111 },
  { 0x0056, 0x00F2, -111 },
  { 0x0056, 0x0151, -111 },
  { 0x0056, 0x014D, -111 },
  { 0x0056, 0x00F8, -111 },
  { 0x0056, 0x00F5, -111 },
  { 0x0056, 0x002E, -129 },
  { 0x0056, 0x003B, -74 },
  { 0x0056, 0x0075, -74 },
  { 0x0056, 0x00FA, -74 },
  { 0x0056, 0x00FB, -74 },
  { 0x0056, 0x00FC, -74 },
  { 0x0056, 0x00F9, -74 },
  { 0x0056, 0x0171, -74 },
  { 0x0056, 0x016B, -74 },
  { 0x0056, 0x0173, -74 },
  { 0x0056, 0x016F, -74 },
  { 0x0057, 0x0041, -60 },
  { 0x0057, 0x00C1, -60 },
  { 0x0057, 0x0102, -60 },
  { 0x0057, 0x00C2, -60 },
  { 0x0057, 0x00C4, -60 },
  { 0x0057, 0x00C0, -60 },
  { 0x0057, 0x0100, -60 },
  { 0x0057, 0x0104, -60 },
  { 0x0057, 0x00C5, -60 },
  { 0x0057, 0x00C3, -60 },
  { 0x0057, 0x004F, -25 },
  { 0x0057, 0x00D3, -25 },
  { 0x0057, 0x00D4, -25 },
  { 0x0057, 0x00D6, -25 },
  { 0x0057, 0x00D2, -25 },
  { 0x0057, 0x0150, -25 },
  { 0x0057, 0x014C, -25 },
  { 0x0057, 0x00D8, -25 },
  { 0x0057, 0x00D5, -25 },
  { 0x0057, 0x0061, -92 },
  { 0x0057, 0x00E1, -92 },
  { 0x0057, 0x0103, -92 },
  { 0x0057, 0x00E2, -92 },
  { 0x0057, 0x00E4, -92 },
  { 0x0057, 0x00E0, -92 },
  { 0x0057, 0x0101, -92 },
  { 0x0057, 0x0105, -92 },
  { 0x0057, 0x00E5, -92 },
  { 0x0057, 0x00E3, -92 },
  { 0x0057, 0x003A, -65 },
  { 0x0057, 0x002C, -92 },
  { 0x0057, 0x0065, -92 },
  { 0x0057, 0x00E9, -92 },
  { 0x0057, 0x011B, -92 },
  { 0x0057, 0x00EA, -92 },
  { 0x0057, 0x00EB, -52 },
  { 0x0057, 0x0117, -92 },
  { 0x0057, 0x00E8, -52 },
  { 0x0057, 0x0113, -52 },
  { 0x0057, 0x0119, -92 },
  { 0x0057, 0x002D, -37 },
  { 0x0057, 0x0069, -55 },
  { 0x0057, 0x00ED, -55 },
  { 0x0057, 0x012F, -55 },
  { 0x0057, 0x006F, -92 },
  { 0x0057, 0x00F3, -92 },
  { 0x0057, 0x00F4, -92 },
  { 0x0057, 0x00F6, -92 },
  { 0x0057, 0x00F2, -92 },
  { 0x0057, 0x0151, -92 },
  { 0x0057, 0x014D, -92 },
  { 0x0057, 0x00F8, -92 },
  { 0x0057, 0x00F5, -92 },
  { 0x0057, 0x002E, -92 },
  { 0x0057, 0x003B, -65 },
  { 0x0057, 0x0075, -55 },
  { 0x0057, 0x00FA, -55 },
  { 0x0057, 0x00FB, -55 },
  { 0x0057, 0x00FC, -55 },
  { 0x0057, 0x00F9, -55 },
  { 0x0057, 0x0171, -55 },
  { 0x0057, 0x016B, -55 },
  { 0x0057, 0x0173, -55 },
  { 0x0057, 0x016F, -55 },
  { 0x0057, 0x0079, -70 },
  { 0x0057, 0x00FD, -70 },
  { 0x0057, 0x00FF, -70 },
  { 0x0059, 0x0041, -50 },
  { 0x0059, 0x00C1, -50 },
  { 0x0059, 0x0102, -50 },
  { 0x0059, 0x00C2, -50 },
  { 0x0059, 0x00C4, -50 },
  { 0x0059, 0x00C0, -50 },
  { 0x0059, 0x0100, -50 },
  { 0x0059, 0x0104, -50 },
  { 0x0059, 0x00C5, -50 },
  { 0x0059, 0x00C3, -50 },
  { 0x0059, 0x004F, -15 },
  { 0x0059, 0x00D3, -15 },
  { 0x0059, 0x00D4, -15 },
  { 0x0059, 0x00D6, -15 },
  { 0x0059, 0x00D2, -15 },
  { 0x0059, 0x0150, -15 },
  { 0x0059, 0x014C, -15 },
  { 0x0059, 0x00D8, -15 },
  { 0x0059, 0x00D5, -15 },
  { 0x0059, 0x0061, -92 },
  { 0x0059, 0x00E1, -92 },
  { 0x0059, 0x0103, -92 },
  { 0x0059, 0x00E2, -92 },
  { 0x0059, 0x00E4, -92 },
  { 0x0059, 0x00E0, -92 },
  { 0x0059, 0x0101, -92 },
  { 0x0059, 0x0105, -92 },
  { 0x0059, 0x00E5, -92 },
  { 0x0059, 0x00E3, -92 },
  { 0x0059, 0x003A, -65 },
  { 0x0059, 0x002C, -92 },
  { 0x0059, 0x0065, -92 },
  { 0x0059, 0x00E9, -92 },
  { 0x0059, 0x011B, -92 },
  { 0x0059, 0x00EA, -92 },
  { 0x0059, 0x00EB, -52 },
  { 0x0059, 0x0117, -92 },
  { 0x0059, 0x00E8, -52 },
  { 0x0059, 0x0113, -52 },
  { 0x0059, 0x0119, -92 },
  { 0x0059, 0x002D, -74 },
  { 0x0059, 0x0069, -74 },
  { 0x0059, 0x00ED, -74 },
  { 0x0059, 0x00EE, -34 },
  { 0x0059, 0x00EF, -34 },
  { 0x0059, 0x00EC, -34 },
  { 0x0059, 0x012B, -34 },
  { 0x0059, 0x012F, -74 },
  { 0x0059, 0x006F, -92 },
  { 0x0059, 0x00F3, -92 },
  { 0x0059, 0x00F4, -92 },
  { 0x0059, 0x00F6, -92 },
  { 0x0059, 0x00F2, -92 },
  { 0x0059, 0x0151, -92 },
  { 0x0059, 0x014D, -92 },
  { 0x0059, 0x00F8, -92 },
  { 0x0059, 0x00F5, -92 },
  { 0x0059, 0x002E, -92 },
  { 0x0059, 0x003B, -65 },
  { 0x0059, 0x0075, -92 },
  { 0x0059, 0x00FA, -92 },
  { 0x0059, 0x00FB, -92 },
  { 0x0059, 0x00FC, -92 },
  { 0x0059, 0x00F9, -92 },
  { 0x0059, 0x0171, -92 },
  { 0x0059, 0x016B, -92 },
  { 0x0059, 0x0173, -92 },
  { 0x0059, 0x016F, -92 },
  { 0x00DD, 0x0041, -50 },
  { 0x00DD, 0x00C1, -50 },
  { 0x00DD, 0x0102, -50 },
  { 0x00DD, 0x00C2, -50 },
  { 0x00DD, 0x00C4, -50 },
  { 0x00DD, 0x00C0, -50 },
  { 0x00DD, 0x0100, -50 },
  { 0x00DD, 0x0104, -50 },
  { 0x00DD, 0x00C5, -50 },
  { 0x00DD, 0x00C3, -50 },
  { 0x00DD, 0x004F, -15 },
  { 0x00DD, 0x00D3, -15 },
  { 0x00DD, 0x00D4, -15 },
  { 0x00DD, 0x00D6, -15 },
  { 0x00DD, 0x00D2, -15 },
  { 0x00DD, 0x0150, -15 },
  { 0x00DD, 0x014C, -15 },
  { 0x00DD, 0x00D8, -15 },
  { 0x00DD, 0x00D5, -15 },
  { 0x00DD, 0x0061, -92 },
  { 0x00DD, 0x00E1, -92 },
  { 0x00DD, 0x0103, -92 },
  { 0x00DD, 0x00E2, -92 },
  { 0x00DD, 0x00E4, -92 },
  { 0x00DD, 0x00E0, -92 },
  { 0x00DD, 0x0101, -92 },
  { 0x00DD, 0x0105, -92 },
  { 0x00DD, 0x00E5, -92 },
  { 0x00DD, 0x00E3, -92 },
  { 0x00DD, 0x003A, -65 },
  { 0x00DD, 0x002C, -92 },
  { 0x00DD, 0x0065, -92 },
  { 0x00DD, 0x00E9, -92 },
  { 0x00DD, 0x011B, -92 },
  { 0x00DD, 0x00EA, -92 },
  { 0x00DD, 0x00EB, -52 },
  { 0x00DD, 0x0117, -92 },
  { 0x00DD, 0x00E8, -52 },
  { 0x00DD, 0x0113, -52 },
  { 0x00DD, 0x0119, -92 },
  { 0x00DD, 0x002D, -74 },
  { 0x00DD, 0x0069, -74 },
  { 0x00DD, 0x00ED, -74 },
  { 0x00DD, 0x00EE, -34 },
  { 0x00DD, 0x00EF, -34 },
  { 0x00DD, 0x00EC, -34 },
  { 0x00DD, 0x012B, -34 },
  { 0x00DD, 0x012F, -74 },
  { 0x00DD, 0x006F, -92 },
  { 0x00DD, 0x00F3, -92 },
  { 0x00DD, 0x00F4, -92 },
  { 0x00DD, 0x00F6, -92 },
  { 0x00DD, 0x00F2, -92 },
  { 0x00DD, 0x0151, -92 },
  { 0x00DD, 0x014D, -92 },
  { 0x00DD, 0x00F8, -92 },
  { 0x00DD, 0x00F5, -92 },
  { 0x00DD, 0x002E, -92 },
  { 0x00DD, 0x003B, -65 },
  { 0x00DD, 0x0075, -92 },
  { 0x00DD, 0x00FA, -92 },
  { 0x00DD, 0x00FB, -92 },
  { 0x00DD, 0x00FC, -92 },
  { 0x00DD, 0x00F9, -92 },
  { 0x00DD, 0x0171, -92 },
  { 0x00DD, 0x016B, -92 },
  { 0x00DD, 0x0173, -92 },
  { 0x00DD, 0x016F, -92 },
  { 0x0178, 0x0041, -50 },
  { 0x0178, 0x00C1, -50 },
  { 0x0178, 0x0102, -50 },
  { 0x0178, 0x00C2, -50 },
  { 0x0178, 0x00C4, -50 },
  { 0x0178, 0x00C0, -50 },
  { 0x0178, 0x0100, -50 },
  { 0x0178, 0x0104, -50 },
  { 0x0178, 0x00C5, -50 },
  { 0x0178, 0x00C3, -50 },
  { 0x0178, 0x004F, -15 },
  { 0x0178, 0x00D3, -15 },
  { 0x0178, 0x00D4, -15 },
  { 0x0178, 0x00D6, -15 },
  { 0x0178, 0x00D2, -15 },
  { 0x0178, 0x0150, -15 },
  { 0x0178, 0x014C, -15 },
  { 0x0178, 0x00D8, -15 },
  { 0x0178, 0x00D5, -15 },
  { 0x0178, 0x0061, -92 },
  { 0x0178, 0x00E1, -92 },
  { 0x0178, 0x0103, -92 },
  { 0x0178, 0x00E2, -92 },
  { 0x0178, 0x00E4, -92 },
  { 0x0178, 0x00E0, -92 },
  { 0x0178, 0x0101, -92 },
  { 0x0178, 0x0105, -92 },
  { 0x0178, 0x00E5, -92 },
  { 0x0178, 0x00E3, -92 },
  { 0x0178, 0x003A, -65 },
  { 0x0178, 0x002C, -92 },
  { 0x0178, 0x0065, -92 },
  { 0x0178, 0x00E9, -92 },
  { 0x0178, 0x011B, -92 },
  { 0x0178, 0x00EA, -92 },
  { 0x0178, 0x00EB, -52 },
  { 0x0178, 0x0117, -92 },
  { 0x0178, 0x00E8, -52 },
  { 0x0178, 0x0113, -52 },
  { 0x0178, 0x0119, -92 },
  { 0x0178, 0x002D, -74 },
  { 0x0178, 0x0069, -74 },
  { 0x0178, 0x00ED, -74 },
  { 0x0178, 0x00EE, -34 },
  { 0x0178, 0x00EF, -34 },
  { 0x0178, 0x00EC, -34 },
  { 0x0178, 0x012B, -34 },
  { 0x0178, 0x012F, -74 },
  { 0x0178, 0x006F, -92 },
  { 0x0178, 0x00F3, -92 },
  { 0x0178, 0x00F4, -92 },
  { 0x0178, 0x00F6, -92 },
  { 0x0178, 0x00F2, -92 },
  { 0x0178, 0x0151, -92 },
  { 0x0178, 0x014D, -92 },
  { 0x0178, 0x00F8, -92 },
  { 0x0178, 0x00F5, -92 },
  { 0x0178, 0x002E, -92 },
  { 0x0178, 0x003B, -65 },
  { 0x0178, 0x0075, -92 },
  { 0x0178, 0x00FA, -92 },
  { 0x0178, 0x00FB, -92 },
  { 0x0178, 0x00FC, -92 },
  { 0x0178, 0x00F9, -92 },
  { 0x0178, 0x0171, -92 },
  { 0x0178, 0x016B, -92 },
  { 0x0178, 0x0173, -92 },
  { 0x0178, 0x016F, -92 },
  { 0x0061, 0x0067, -10 },
  { 0x0061, 0x011F, -10 },
  { 0x0061, 0x0123, -10 },
  { 0x00E1, 0x0067, -10 },
  { 0x00E1, 0x011F, -10 },
  { 0x00E1, 0x0123, -10 },
  { 0x0103, 0x0067, -10 },
  { 0x0103, 0x011F, -10 },
  { 0x0103, 0x0123, -10 },
  { 0x00E2, 0x0067, -10 },
  { 0x00E2, 0x011F, -10 },
  { 0x00E2, 0x0123, -10 },
  { 0x00E4, 0x0067, -10 },
  { 0x00E4, 0x011F, -10 },
  { 0x00E4, 0x0123, -10 },
  { 0x00E0, 0x0067, -10 },
  { 0x00E0, 0x011F, -10 },
  { 0x00E0, 0x0123, -10 },
  { 0x0101, 0x0067, -10 },
  { 0x0101, 0x011F, -10 },
  { 0x0101, 0x0123, -10 },
  { 0x0105, 0x0067, -10 },
  { 0x0105, 0x011F, -10 },
  { 0x0105, 0x0123, -10 },
  { 0x00E5, 0x0067, -10 },
  { 0x00E5, 0x011F, -10 },
  { 0x00E5, 0x0123, -10 },
  { 0x00E3, 0x0067, -10 },
  { 0x00E3, 0x011F, -10 },
  { 0x00E3, 0x0123, -10 },
  { 0x0062, 0x002E, -40 },
  { 0x0062, 0x0075, -20 },
  { 0x0062, 0x00FA, -20 },
  { 0x0062, 0x00FB, -20 },
  { 0x0062, 0x00FC, -20 },
  { 0x0062, 0x00F9, -20 },
  { 0x0062, 0x0171, -20 },
  { 0x0062, 0x016B, -20 },
  { 0x0062, 0x0173, -20 },
  { 0x0062, 0x016F, -20 },
  { 0x0063, 0x0068, -15 },
  { 0x0063, 0x006B, -20 },
  { 0x0063, 0x0137, -20 },
  { 0x0107, 0x0068, -15 },
  { 0x0107, 0x006B, -20 },
  { 0x0107, 0x0137, -20 },
  { 0x010D, 0x0068, -15 },
  { 0x010D, 0x006B, -20 },
  { 0x010D, 0x0137, -20 },
  { 0x00E7, 0x0068, -15 },
  { 0x00E7, 0x006B, -20 },
  { 0x00E7, 0x0137, -20 },
  { 0x002C, 0x201D, -140 },
  { 0x002C, 0x2019, -140 },
  { 0x0065, 0x002C, -10 },
  { 0x0065, 0x0067, -40 },
  { 0x0065, 0x011F, -40 },
  { 0x0065, 0x0123, -40 },
  { 0x0065, 0x002E, -15 },
  { 0x0065, 0x0076, -15 },
  { 0x0065, 0x0077, -15 },
  { 0x0065, 0x0078, -20 },
  { 0x0065, 0x0079, -30 },
  { 0x0065, 0x00FD, -30 },
  { 0x0065, 0x00FF, -30 },
  { 0x00E9, 0x002C, -10 },
  { 0x00E9, 0x0067, -40 },
  { 0x00E9, 0x011F, -40 },
  { 0x00E9, 0x0123, -40 },
  { 0x00E9, 0x002E, -15 },
  { 0x00E9, 0x0076, -15 },
  { 0x00E9, 0x0077, -15 },
  { 0x00E9, 0x0078, -20 },
  { 0x00E9, 0x0079, -30 },
  { 0x00E9, 0x00FD, -30 },
  { 0x00E9, 0x00FF, -30 },
  { 0x011B, 0x002C, -10 },
  { 0x011B, 0x0067, -40 },
  { 0x011B, 0x011F, -40 },
  { 0x011B, 0x0123, -40 },
  { 0x011B, 0x002E, -15 },
  { 0x011B, 0x0076, -15 },
  { 0x011B, 0x0077, -15 },
  { 0x011B, 0x0078, -20 },
  { 0x011B, 0x0079, -30 },
  { 0x011B, 0x00FD, -30 },
  { 0x011B, 0x00FF, -30 },
  { 0x00EA, 0x002C, -10 },
  { 0x00EA, 0x0067, -40 },
  { 0x00EA, 0x011F, -40 },
  { 0x00EA, 0x0123, -40 },
  { 0x00EA, 0x002E, -15 },
  { 0x00EA, 0x0076, -15 },
  { 0x00EA, 0x0077, -15 },
  { 0x00EA, 0x0078, -20 },
  { 0x00EA, 0x0079, -30 },
  { 0x00EA, 0x00FD, -30 },
  { 0x00EA, 0x00FF, -30 },
  { 0x00EB, 0x002C, -10 },
  { 0x00EB, 0x0067, -40 },
  { 0x00EB, 0x011F, -40 },
  { 0x00EB, 0x0123, -40 },
  { 0x00EB, 0x002E, -15 },
  { 0x00EB, 0x0076, -15 },
  { 0x00EB, 0x0077, -15 },
  { 0x00EB, 0x0078, -20 },
  { 0x00EB, 0x0079, -30 },
  { 0x00EB, 0x00FD, -30 },
  { 0x00EB, 0x00FF, -30 },
  { 0x0117, 0x002C, -10 },
  { 0x0117, 0x0067, -40 },
  { 0x0117, 0x011F, -40 },
  { 0x0117, 0x0123, -40 },
  { 0x0117, 0x002E, -15 },
  { 0x0117, 0x0076, -15 },
  { 0x0117, 0x0077, -15 },
  { 0x0117, 0x0078, -20 },
  { 0x0117, 0x0079, -30 },
  { 0x0117, 0x00FD, -30 },
  { 0x0117, 0x00FF, -30 },
  { 0x00E8, 0x002C, -10 },
  { 0x00E8, 0x0067, -40 },
  { 0x00E8, 0x011F, -40 },
  { 0x00E8, 0x0123, -40 },
  { 0x00E8, 0x002E, -15 },
  { 0x00E8, 0x0076, -15 },
  { 0x00E8, 0x0077, -15 },
  { 0x00E8, 0x0078, -20 },
  { 0x00E8, 0x0079, -30 },
  { 0x00E8, 0x00FD, -30 },
  { 0x00E8, 0x00FF, -30 },
  { 0x0113, 0x002C, -10 },
  { 0x0113, 0x0067, -40 },
  { 0x0113, 0x011F, -40 },
  { 0x0113, 0x0123, -40 },
  { 0x0113, 0x002E, -15 },
  { 0x0113, 0x0076, -15 },
  { 0x0113, 0x0077, -15 },
  { 0x0113, 0x0078, -20 },
  { 0x0113, 0x0079, -30 },
  { 0x0113, 0x00FD, -30 },
  { 0x0113, 0x00FF, -30 },
  { 0x0119, 0x002C, -10 },
  { 0x0119, 0x0067, -40 },
  { 0x0119, 0x011F, -40 },
  { 0x0119, 0x0123, -40 },
  { 0x0119, 0x002E, -15 },
  { 0x0119, 0x0076, -15 },
  { 0x0119, 0x0077, -15 },
  { 0x0119, 0x0078, -20 },
  { 0x0119, 0x0079, -30 },
  { 0x0119, 0x00FD, -30 },
  { 0x0119, 0x00FF, -30 },
  { 0x0066, 0x002C, -10 },
  { 0x0066, 0x0131, -60 },
  { 0x0066, 0x0066, -18 },
  { 0x0066, 0x0069, -20 },
  { 0x0066, 0x012F, -20 },
  { 0x0066, 0x002E, -15 },
  { 0x0066, 0x2019, 92 },
  { 0x0067, 0x002C, -10 },
  { 0x0067, 0x0065, -10 },
  { 0x0067, 0x00E9, -10 },
  { 0x0067, 0x011B, -10 },
  { 0x0067, 0x00EA, -10 },
  { 0x0067, 0x00EB, -10 },
  { 0x0067, 0x0117, -10 },
  { 0x0067, 0x00E8, -10 },
  { 0x0067, 0x0113, -10 },
  { 0x0067, 0x0119, -10 },
  { 0x0067, 0x0067, -10 },
  { 0x0067, 0x011F, -10 },
  { 0x0067, 0x0123, -10 },
  { 0x0067, 0x002E, -15 },
  { 0x011F, 0x002C, -10 },
  { 0x011F, 0x0065, -10 },
  { 0x011F, 0x00E9, -10 },
  { 0x011F, 0x011B, -10 },
  { 0x011F, 0x00EA, -10 },
  { 0x011F, 0x00EB, -10 },
  { 0x011F, 0x0117, -10 },
  { 0x011F, 0x00E8, -10 },
  { 0x011F, 0x0113, -10 },
  { 0x011F, 0x0119, -10 },
  { 0x011F, 0x0067, -10 },
  { 0x011F, 0x011F, -10 },
  { 0x011F, 0x0123, -10 },
  { 0x011F, 0x002E, -15 },
  { 0x0123, 0x002C, -10 },
  { 0x0123, 0x0065, -10 },
  { 0x0123, 0x00E9, -10 },
  { 0x0123, 0x011B, -10 },
  { 0x0123, 0x00EA, -10 },
  { 0x0123, 0x00EB, -10 },
  { 0x0123, 0x0117, -10 },
  { 0x0123, 0x00E8, -10 },
  { 0x0123, 0x0113, -10 },
  { 0x0123, 0x0119, -10 },
  { 0x0123, 0x0067, -10 },
  { 0x0123, 0x011F, -10 },
  { 0x0123, 0x0123, -10 },
  { 0x0123, 0x002E, -15 },
  { 0x006B, 0x0065, -10 },
  { 0x006B, 0x00E9, -10 },
  { 0x006B, 0x011B, -10 },
  { 0x006B, 0x00EA, -10 },
  { 0x006B, 0x00EB, -10 },
  { 0x006B, 0x0117, -10 },
  { 0x006B, 0x00E8, -10 },
  { 0x006B, 0x0113, -10 },
  { 0x006B, 0x0119, -10 },
  { 0x006B, 0x006F, -10 },
  { 0x006B, 0x00F3, -10 },
  { 0x006B, 0x00F4, -10 },
  { 0x006B, 0x00F6, -10 },
  { 0x006B, 0x00F2, -10 },
  { 0x006B, 0x0151, -10 },
  { 0x006B, 0x014D, -10 },
  { 0x006B, 0x00F8, -10 },
  { 0x006B, 0x00F5, -10 },
  { 0x006B, 0x0079, -10 },
  { 0x006B, 0x00FD, -10 },
  { 0x006B, 0x00FF, -10 },
  { 0x0137, 0x0065, -10 },
  { 0x0137, 0x00E9, -10 },
  { 0x0137, 0x011B, -10 },
  { 0x0137, 0x00EA, -10 },
  { 0x0137, 0x00EB, -10 },
  { 0x0137, 0x0117, -10 },
  { 0x0137, 0x00E8, -10 },
  { 0x0137, 0x0113, -10 },
  { 0x0137, 0x0119, -10 },
  { 0x0137, 0x006F, -10 },
  { 0x0137, 0x00F3, -10 },
  { 0x0137, 0x00F4, -10 },
  { 0x0137, 0x00F6, -10 },
  { 0x0137, 0x00F2, -10 },
  { 0x0137, 0x0151, -10 },
  { 0x0137, 0x014D, -10 },
  { 0x0137, 0x00F8, -10 },
  { 0x0137, 0x00F5, -10 },
  { 0x0137, 0x0079, -10 },
  { 0x0137, 0x00FD, -10 },
  { 0x0137, 0x00FF, -10 },
  { 0x006E, 0x0076, -40 },
  { 0x0144, 0x0076, -40 },
  { 0x0148, 0x0076, -40 },
  { 0x0146, 0x0076, -40 },
  { 0x00F1, 0x0076, -40 },
  { 0x006F, 0x0067, -10 },
  { 0x006F, 0x011F, -10 },
  { 0x006F, 0x0123, -10 },
  { 0x006F, 0x0076, -10 },
  { 0x00F3, 0x0067, -10 },
  { 0x00F3, 0x011F, -10 },
  { 0x00F3, 0x0123, -10 },
  { 0x00F3, 0x0076, -10 },
  { 0x00F4, 0x0067, -10 },
  { 0x00F4, 0x011F, -10 },
  { 0x00F4, 0x0123, -10 },
  { 0x00F4, 0x0076, -10 },
  { 0x00F6, 0x0067, -10 },
  { 0x00F6, 0x011F, -10 },
  { 0x00F6, 0x0123, -10 },
  { 0x00F6, 0x0076, -10 },
  { 0x00F2, 0x0067, -10 },
  { 0x00F2, 0x011F, -10 },
  { 0x00F2, 0x0123, -10 },
  { 0x00F2, 0x0076, -10 },
  { 0x0151, 0x0067, -10 },
  { 0x0151, 0x011F, -10 },
  { 0x0151, 0x0123, -10 },
  { 0x0151, 0x0076, -10 },
  { 0x014D, 0x0067, -10 },
  { 0x014D, 0x011F, -10 },
  { 0x014D, 0x0123, -10 },
  { 0x014D, 0x0076, -10 },
  { 0x00F8, 0x0067, -10 },
  { 0x00F8, 0x011F, -10 },
  { 0x00F8, 0x0123, -10 },
  { 0x00F8, 0x0076, -10 },
  { 0x00F5, 0x0067, -10 },
  { 0x00F5, 0x011F, -10 },
  { 0x00F5, 0x0123, -10 },
  { 0x00F5, 0x0076, -10 },
  { 0x002E, 0x201D, -140 },
  { 0x002E, 0x2019, -140 },
  { 0x2018, 0x2018, -111 },
  { 0x2019, 0x0064, -25 },
  { 0x2019, 0x0111, -25 },
  { 0x2019, 0x2019, -111 },
  { 0x2019, 0x0072, -25 },
  { 0x2019, 0x0155, -25 },
  { 0x2019, 0x0159, -25 },
  { 0x2019, 0x0157, -25 },
  { 0x2019, 0x0073, -40 },
  { 0x2019, 0x015B, -40 },
  { 0x2019, 0x0161, -40 },
  { 0x2019, 0x015F, -40 },
  { 0x2019, 0x0219, -40 },
  { 0x2019, 0x0020, -111 },
  { 0x2019, 0x0074, -30 },
  { 0x2019, 0x0163, -30 },
  { 0x2019, 0x0076, -10 },
  { 0x0072, 0x0061, -15 },
  { 0x0072, 0x00E1, -15 },
  { 0x0072, 0x0103, -15 },
  { 0x0072, 0x00E2, -15 },
  { 0x0072, 0x00E4, -15 },
  { 0x0072, 0x00E0, -15 },
  { 0x0072, 0x0101, -15 },
  { 0x0072, 0x0105, -15 },
  { 0x0072, 0x00E5, -15 },
  { 0x0072, 0x00E3, -15 },
  { 0x0072, 0x0063, -37 },
  { 0x0072, 0x0107, -37 },
  { 0x0072, 0x010D, -37 },
  { 0x0072, 0x00E7, -37 },
  { 0x0072, 0x002C, -111 },
  { 0x0072, 0x0064, -37 },
  { 0x0072, 0x0111, -37 },
  { 0x0072, 0x0065, -37 },
  { 0x0072, 0x00E9, -37 },
  { 0x0072, 0x011B, -37 },
  { 0x0072, 0x00EA, -37 },
  { 0x0072, 0x00EB, -37 },
  { 0x0072, 0x0117, -37 },
  { 0x0072, 0x00E8, -37 },
  { 0x0072, 0x0113, -37 },
  { 0x0072, 0x0119, -37 },
  { 0x0072, 0x0067, -37 },
  { 0x0072, 0x011F, -37 },
  { 0x0072, 0x0123, -37 },
  { 0x0072, 0x002D, -20 },
  { 0x0072, 0x006F, -45 },
  { 0x0072, 0x00F3, -45 },
  { 0x0072, 0x00F4, -45 },
  { 0x0072, 0x00F6, -45 },
  { 0x0072, 0x00F2, -45 },
  { 0x0072, 0x0151, -45 },
  { 0x0072, 0x014D, -45 },
  { 0x0072, 0x00F8, -45 },
  { 0x0072, 0x00F5, -45 },
  { 0x0072, 0x002E, -111 },
  { 0x0072, 0x0071, -37 },
  { 0x0072, 0x0073, -10 },
  { 0x0072, 0x015B, -10 },
  { 0x0072, 0x0161, -10 },
  { 0x0072, 0x015F, -10 },
  { 0x0072, 0x0219, -10 },
  { 0x0155, 0x0061, -15 },
  { 0x0155, 0x00E1, -15 },
  { 0x0155, 0x0103, -15 },
  { 0x0155, 0x00E2, -15 },
  { 0x0155, 0x00E4, -15 },
  { 0x0155, 0x00E0, -15 },
  { 0x0155, 0x0101, -15 },
  { 0x0155, 0x0105, -15 },
  { 0x0155, 0x00E5, -15 },
  { 0x0155, 0x00E3, -15 },
  { 0x0155, 0x0063, -37 },
  { 0x0155, 0x0107, -37 },
  { 0x0155, 0x010D, -37 },
  { 0x0155, 0x00E7, -37 },
  { 0x0155, 0x002C, -111 },
  { 0x0155, 0x0064, -37 },
  { 0x0155, 0x0111, -37 },
  { 0x0155, 0x0065, -37 },
  { 0x0155, 0x00E9, -37 },
  { 0x0155, 0x011B, -37 },
  { 0x0155, 0x00EA, -37 },
  { 0x0155, 0x00EB, -37 },
  { 0x0155, 0x0117, -37 },
  { 0x0155, 0x00E8, -37 },
  { 0x0155, 0x0113, -37 },
  { 0x0155, 0x0119, -37 },
  { 0x0155, 0x0067, -37 },
  { 0x0155, 0x011F, -37 },
  { 0x0155, 0x0123, -37 },
  { 0x0155, 0x002D, -20 },
  { 0x0155, 0x006F, -45 },
  { 0x0155, 0x00F3, -45 },
  { 0x0155, 0x00F4, -45 },
  { 0x0155, 0x00F6, -45 },
  { 0x0155, 0x00F2, -45 },
  { 0x0155, 0x0151, -45 },
  { 0x0155, 0x014D, -45 },
  { 0x0155, 0x00F8, -45 },
  { 0x0155, 0x00F5, -45 },
  { 0x0155, 0x002E, -111 },
  { 0x0155, 0x0071, -37 },
  { 0x0155, 0x0073, -10 },
  { 0x0155, 0x015B, -10 },
  { 0x0155, 0x0161, -10 },
  { 0x0155, 0x015F, -10 },
  { 0x0155, 0x0219, -10 },
  { 0x0159, 0x0061, -15 },
  { 0x0159, 0x00E1, -15 },
  { 0x0159, 0x0103, -15 },
  { 0x0159, 0x00E2, -15 },
  { 0x0159, 0x00E4, -15 },
  { 0x0159, 0x00E0, -15 },
  { 0x0159, 0x0101, -15 },
  { 0x0159, 0x0105, -15 },
  { 0x0159, 0x00E5, -15 },
  { 0x0159, 0x00E3, -15 },
  { 0x0159, 0x0063, -37 },
  { 0x0159, 0x0107, -37 },
  { 0x0159, 0x010D, -37 },
  { 0x0159, 0x00E7, -37 },
  { 0x0159, 0x002C, -111 },
  { 0x0159, 0x0064, -37 },
  { 0x0159, 0x0111, -37 },
  { 0x0159, 0x0065, -37 },
  { 0x0159, 0x00E9, -37 },
  { 0x0159, 0x011B, -37 },
  { 0x0159, 0x00EA, -37 },
  { 0x0159, 0x00EB, -37 },
  { 0x0159, 0x0117, -37 },
  { 0x0159, 0x00E8, -37 },
  { 0x0159, 0x0113, -37 },
  { 0x0159, 0x0119, -37 },
  { 0x0159, 0x0067, -37 },
  { 0x0159, 0x011F, -37 },
  { 0x0159, 0x0123, -37 },
  { 0x0159, 0x002D, -20 },
  { 0x0159, 0x006F, -45 },
  { 0x0159, 0x00F3, -45 },
  { 0x0159, 0x00F4, -45 },
  { 0x0159, 0x00F6, -45 },
  { 0x0159, 0x00F2, -45 },
  { 0x0159, 0x0151, -45 },
  { 0x0159, 0x014D, -45 },
  { 0x0159, 0x00F8, -45 },
  { 0x0159, 0x00F5, -45 },
  { 0x0159, 0x002E, -111 },
  { 0x0159, 0x0071, -37 },
  { 0x0159, 0x0073, -10 },
  { 0x0159, 0x015B, -10 },
  { 0x0159, 0x0161, -10 },
  { 0x0159, 0x015F, -10 },
  { 0x0159, 0x0219, -10 },
  { 0x0157, 0x0061, -15 },
  { 0x0157, 0x00E1, -15 },
  { 0x0157, 0x0103, -15 },
  { 0x0157, 0x00E2, -15 },
  { 0x0157, 0x00E4, -15 },
  { 0x0157, 0x00E0, -15 },
  { 0x0157, 0x0101, -15 },
  { 0x0157, 0x0105, -15 },
  { 0x0157, 0x00E5, -15 },
  { 0x0157, 0x00E3, -15 },
  { 0x0157, 0x0063, -37 },
  { 0x0157, 0x0107, -37 },
  { 0x0157, 0x010D, -37 },
  { 0x0157, 0x00E7, -37 },
  { 0x0157, 0x002C, -111 },
  { 0x0157, 0x0064, -37 },
  { 0x0157, 0x0111, -37 },
  { 0x0157, 0x0065, -37 },
  { 0x0157, 0x00E9, -37 },
  { 0x0157, 0x011B, -37 },
  { 0x0157, 0x00EA, -37 },
  { 0x0157, 0x00EB, -37 },
  { 0x0157, 0x0117, -37 },
  { 0x0157, 0x00E8, -37 },
  { 0x0157, 0x0113, -37 },
  { 0x0157, 0x0119, -37 },
  { 0x0157, 0x0067, -37 },
  { 0x0157, 0x011F, -37 },
  { 0x0157, 0x0123, -37 },
  { 0x0157, 0x002D, -20 },
  { 0x0157, 0x006F, -45 },
  { 0x0157, 0x00F3, -45 },
  { 0x0157, 0x00F4, -45 },
  { 0x0157, 0x00F6, -45 },
  { 0x0157, 0x00F2, -45 },
  { 0x0157, 0x0151, -45 },
  { 0x0157, 0x014D, -45 },
  { 0x0157, 0x00F8, -45 },
  { 0x0157, 0x00F5, -45 },
  { 0x0157, 0x002E, -111 },
  { 0x0157, 0x0071, -37 },
  { 0x0157, 0x0073, -10 },
  { 0x0157, 0x015B, -10 },
  { 0x0157, 0x0161, -10 },
  { 0x0157, 0x015F, -10 },
  { 0x0157, 0x0219, -10 },
  { 0x0020, 0x0041, -18 },
  { 0x0020, 0x00C1, -18 },
  { 0x0020, 0x0102, -18 },
  { 0x0020, 0x00C2, -18 },
  { 0x0020, 0x00C4, -18 },
  { 0x0020, 0x00C0, -18 },
  { 0x0020, 0x0100, -18 },
  { 0x0020, 0x0104, -18 },
  { 0x0020, 0x00C5, -18 },
  { 0x0020, 0x00C3, -18 },
  { 0x0020, 0x0054, -18 },
  { 0x0020, 0x0164, -18 },
  { 0x0020, 0x0162, -18 },
  { 0x0020, 0x0056, -35 },
  { 0x0020, 0x0057, -40 },
  { 0x0020, 0x0059, -75 },
  { 0x0020, 0x00DD, -75 },
  { 0x0020, 0x0178, -75 },
  { 0x0076, 0x002C, -74 },
  { 0x0076, 0x002E, -74 },
  { 0x0077, 0x002C, -74 },
  { 0x0077, 0x002E, -74 },
  { 0x0079, 0x002C, -55 },
  { 0x0079, 0x002E, -55 },
  { 0x00FD, 0x002C, -55 },
  { 0x00FD, 0x002E, -55 },
  { 0x00FF, 0x002C, -55 },
  { 0x00FF, 0x002E, -55 },
  { 0, 0, 0 }
};
