// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package detectiveiface provides an interface to enable mocking the Amazon Detective service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package detectiveiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/detective"
)

// DetectiveAPI provides an interface to enable mocking the
// detective.Detective service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Detective.
//	func myFunc(svc detectiveiface.DetectiveAPI) bool {
//	    // Make svc.AcceptInvitation request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := detective.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockDetectiveClient struct {
//	    detectiveiface.DetectiveAPI
//	}
//	func (m *mockDetectiveClient) AcceptInvitation(input *detective.AcceptInvitationInput) (*detective.AcceptInvitationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockDetectiveClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type DetectiveAPI interface {
	AcceptInvitation(*detective.AcceptInvitationInput) (*detective.AcceptInvitationOutput, error)
	AcceptInvitationWithContext(aws.Context, *detective.AcceptInvitationInput, ...request.Option) (*detective.AcceptInvitationOutput, error)
	AcceptInvitationRequest(*detective.AcceptInvitationInput) (*request.Request, *detective.AcceptInvitationOutput)

	BatchGetGraphMemberDatasources(*detective.BatchGetGraphMemberDatasourcesInput) (*detective.BatchGetGraphMemberDatasourcesOutput, error)
	BatchGetGraphMemberDatasourcesWithContext(aws.Context, *detective.BatchGetGraphMemberDatasourcesInput, ...request.Option) (*detective.BatchGetGraphMemberDatasourcesOutput, error)
	BatchGetGraphMemberDatasourcesRequest(*detective.BatchGetGraphMemberDatasourcesInput) (*request.Request, *detective.BatchGetGraphMemberDatasourcesOutput)

	BatchGetMembershipDatasources(*detective.BatchGetMembershipDatasourcesInput) (*detective.BatchGetMembershipDatasourcesOutput, error)
	BatchGetMembershipDatasourcesWithContext(aws.Context, *detective.BatchGetMembershipDatasourcesInput, ...request.Option) (*detective.BatchGetMembershipDatasourcesOutput, error)
	BatchGetMembershipDatasourcesRequest(*detective.BatchGetMembershipDatasourcesInput) (*request.Request, *detective.BatchGetMembershipDatasourcesOutput)

	CreateGraph(*detective.CreateGraphInput) (*detective.CreateGraphOutput, error)
	CreateGraphWithContext(aws.Context, *detective.CreateGraphInput, ...request.Option) (*detective.CreateGraphOutput, error)
	CreateGraphRequest(*detective.CreateGraphInput) (*request.Request, *detective.CreateGraphOutput)

	CreateMembers(*detective.CreateMembersInput) (*detective.CreateMembersOutput, error)
	CreateMembersWithContext(aws.Context, *detective.CreateMembersInput, ...request.Option) (*detective.CreateMembersOutput, error)
	CreateMembersRequest(*detective.CreateMembersInput) (*request.Request, *detective.CreateMembersOutput)

	DeleteGraph(*detective.DeleteGraphInput) (*detective.DeleteGraphOutput, error)
	DeleteGraphWithContext(aws.Context, *detective.DeleteGraphInput, ...request.Option) (*detective.DeleteGraphOutput, error)
	DeleteGraphRequest(*detective.DeleteGraphInput) (*request.Request, *detective.DeleteGraphOutput)

	DeleteMembers(*detective.DeleteMembersInput) (*detective.DeleteMembersOutput, error)
	DeleteMembersWithContext(aws.Context, *detective.DeleteMembersInput, ...request.Option) (*detective.DeleteMembersOutput, error)
	DeleteMembersRequest(*detective.DeleteMembersInput) (*request.Request, *detective.DeleteMembersOutput)

	DescribeOrganizationConfiguration(*detective.DescribeOrganizationConfigurationInput) (*detective.DescribeOrganizationConfigurationOutput, error)
	DescribeOrganizationConfigurationWithContext(aws.Context, *detective.DescribeOrganizationConfigurationInput, ...request.Option) (*detective.DescribeOrganizationConfigurationOutput, error)
	DescribeOrganizationConfigurationRequest(*detective.DescribeOrganizationConfigurationInput) (*request.Request, *detective.DescribeOrganizationConfigurationOutput)

	DisableOrganizationAdminAccount(*detective.DisableOrganizationAdminAccountInput) (*detective.DisableOrganizationAdminAccountOutput, error)
	DisableOrganizationAdminAccountWithContext(aws.Context, *detective.DisableOrganizationAdminAccountInput, ...request.Option) (*detective.DisableOrganizationAdminAccountOutput, error)
	DisableOrganizationAdminAccountRequest(*detective.DisableOrganizationAdminAccountInput) (*request.Request, *detective.DisableOrganizationAdminAccountOutput)

	DisassociateMembership(*detective.DisassociateMembershipInput) (*detective.DisassociateMembershipOutput, error)
	DisassociateMembershipWithContext(aws.Context, *detective.DisassociateMembershipInput, ...request.Option) (*detective.DisassociateMembershipOutput, error)
	DisassociateMembershipRequest(*detective.DisassociateMembershipInput) (*request.Request, *detective.DisassociateMembershipOutput)

	EnableOrganizationAdminAccount(*detective.EnableOrganizationAdminAccountInput) (*detective.EnableOrganizationAdminAccountOutput, error)
	EnableOrganizationAdminAccountWithContext(aws.Context, *detective.EnableOrganizationAdminAccountInput, ...request.Option) (*detective.EnableOrganizationAdminAccountOutput, error)
	EnableOrganizationAdminAccountRequest(*detective.EnableOrganizationAdminAccountInput) (*request.Request, *detective.EnableOrganizationAdminAccountOutput)

	GetInvestigation(*detective.GetInvestigationInput) (*detective.GetInvestigationOutput, error)
	GetInvestigationWithContext(aws.Context, *detective.GetInvestigationInput, ...request.Option) (*detective.GetInvestigationOutput, error)
	GetInvestigationRequest(*detective.GetInvestigationInput) (*request.Request, *detective.GetInvestigationOutput)

	GetMembers(*detective.GetMembersInput) (*detective.GetMembersOutput, error)
	GetMembersWithContext(aws.Context, *detective.GetMembersInput, ...request.Option) (*detective.GetMembersOutput, error)
	GetMembersRequest(*detective.GetMembersInput) (*request.Request, *detective.GetMembersOutput)

	ListDatasourcePackages(*detective.ListDatasourcePackagesInput) (*detective.ListDatasourcePackagesOutput, error)
	ListDatasourcePackagesWithContext(aws.Context, *detective.ListDatasourcePackagesInput, ...request.Option) (*detective.ListDatasourcePackagesOutput, error)
	ListDatasourcePackagesRequest(*detective.ListDatasourcePackagesInput) (*request.Request, *detective.ListDatasourcePackagesOutput)

	ListDatasourcePackagesPages(*detective.ListDatasourcePackagesInput, func(*detective.ListDatasourcePackagesOutput, bool) bool) error
	ListDatasourcePackagesPagesWithContext(aws.Context, *detective.ListDatasourcePackagesInput, func(*detective.ListDatasourcePackagesOutput, bool) bool, ...request.Option) error

	ListGraphs(*detective.ListGraphsInput) (*detective.ListGraphsOutput, error)
	ListGraphsWithContext(aws.Context, *detective.ListGraphsInput, ...request.Option) (*detective.ListGraphsOutput, error)
	ListGraphsRequest(*detective.ListGraphsInput) (*request.Request, *detective.ListGraphsOutput)

	ListGraphsPages(*detective.ListGraphsInput, func(*detective.ListGraphsOutput, bool) bool) error
	ListGraphsPagesWithContext(aws.Context, *detective.ListGraphsInput, func(*detective.ListGraphsOutput, bool) bool, ...request.Option) error

	ListIndicators(*detective.ListIndicatorsInput) (*detective.ListIndicatorsOutput, error)
	ListIndicatorsWithContext(aws.Context, *detective.ListIndicatorsInput, ...request.Option) (*detective.ListIndicatorsOutput, error)
	ListIndicatorsRequest(*detective.ListIndicatorsInput) (*request.Request, *detective.ListIndicatorsOutput)

	ListInvestigations(*detective.ListInvestigationsInput) (*detective.ListInvestigationsOutput, error)
	ListInvestigationsWithContext(aws.Context, *detective.ListInvestigationsInput, ...request.Option) (*detective.ListInvestigationsOutput, error)
	ListInvestigationsRequest(*detective.ListInvestigationsInput) (*request.Request, *detective.ListInvestigationsOutput)

	ListInvitations(*detective.ListInvitationsInput) (*detective.ListInvitationsOutput, error)
	ListInvitationsWithContext(aws.Context, *detective.ListInvitationsInput, ...request.Option) (*detective.ListInvitationsOutput, error)
	ListInvitationsRequest(*detective.ListInvitationsInput) (*request.Request, *detective.ListInvitationsOutput)

	ListInvitationsPages(*detective.ListInvitationsInput, func(*detective.ListInvitationsOutput, bool) bool) error
	ListInvitationsPagesWithContext(aws.Context, *detective.ListInvitationsInput, func(*detective.ListInvitationsOutput, bool) bool, ...request.Option) error

	ListMembers(*detective.ListMembersInput) (*detective.ListMembersOutput, error)
	ListMembersWithContext(aws.Context, *detective.ListMembersInput, ...request.Option) (*detective.ListMembersOutput, error)
	ListMembersRequest(*detective.ListMembersInput) (*request.Request, *detective.ListMembersOutput)

	ListMembersPages(*detective.ListMembersInput, func(*detective.ListMembersOutput, bool) bool) error
	ListMembersPagesWithContext(aws.Context, *detective.ListMembersInput, func(*detective.ListMembersOutput, bool) bool, ...request.Option) error

	ListOrganizationAdminAccounts(*detective.ListOrganizationAdminAccountsInput) (*detective.ListOrganizationAdminAccountsOutput, error)
	ListOrganizationAdminAccountsWithContext(aws.Context, *detective.ListOrganizationAdminAccountsInput, ...request.Option) (*detective.ListOrganizationAdminAccountsOutput, error)
	ListOrganizationAdminAccountsRequest(*detective.ListOrganizationAdminAccountsInput) (*request.Request, *detective.ListOrganizationAdminAccountsOutput)

	ListOrganizationAdminAccountsPages(*detective.ListOrganizationAdminAccountsInput, func(*detective.ListOrganizationAdminAccountsOutput, bool) bool) error
	ListOrganizationAdminAccountsPagesWithContext(aws.Context, *detective.ListOrganizationAdminAccountsInput, func(*detective.ListOrganizationAdminAccountsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*detective.ListTagsForResourceInput) (*detective.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *detective.ListTagsForResourceInput, ...request.Option) (*detective.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*detective.ListTagsForResourceInput) (*request.Request, *detective.ListTagsForResourceOutput)

	RejectInvitation(*detective.RejectInvitationInput) (*detective.RejectInvitationOutput, error)
	RejectInvitationWithContext(aws.Context, *detective.RejectInvitationInput, ...request.Option) (*detective.RejectInvitationOutput, error)
	RejectInvitationRequest(*detective.RejectInvitationInput) (*request.Request, *detective.RejectInvitationOutput)

	StartInvestigation(*detective.StartInvestigationInput) (*detective.StartInvestigationOutput, error)
	StartInvestigationWithContext(aws.Context, *detective.StartInvestigationInput, ...request.Option) (*detective.StartInvestigationOutput, error)
	StartInvestigationRequest(*detective.StartInvestigationInput) (*request.Request, *detective.StartInvestigationOutput)

	StartMonitoringMember(*detective.StartMonitoringMemberInput) (*detective.StartMonitoringMemberOutput, error)
	StartMonitoringMemberWithContext(aws.Context, *detective.StartMonitoringMemberInput, ...request.Option) (*detective.StartMonitoringMemberOutput, error)
	StartMonitoringMemberRequest(*detective.StartMonitoringMemberInput) (*request.Request, *detective.StartMonitoringMemberOutput)

	TagResource(*detective.TagResourceInput) (*detective.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *detective.TagResourceInput, ...request.Option) (*detective.TagResourceOutput, error)
	TagResourceRequest(*detective.TagResourceInput) (*request.Request, *detective.TagResourceOutput)

	UntagResource(*detective.UntagResourceInput) (*detective.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *detective.UntagResourceInput, ...request.Option) (*detective.UntagResourceOutput, error)
	UntagResourceRequest(*detective.UntagResourceInput) (*request.Request, *detective.UntagResourceOutput)

	UpdateDatasourcePackages(*detective.UpdateDatasourcePackagesInput) (*detective.UpdateDatasourcePackagesOutput, error)
	UpdateDatasourcePackagesWithContext(aws.Context, *detective.UpdateDatasourcePackagesInput, ...request.Option) (*detective.UpdateDatasourcePackagesOutput, error)
	UpdateDatasourcePackagesRequest(*detective.UpdateDatasourcePackagesInput) (*request.Request, *detective.UpdateDatasourcePackagesOutput)

	UpdateInvestigationState(*detective.UpdateInvestigationStateInput) (*detective.UpdateInvestigationStateOutput, error)
	UpdateInvestigationStateWithContext(aws.Context, *detective.UpdateInvestigationStateInput, ...request.Option) (*detective.UpdateInvestigationStateOutput, error)
	UpdateInvestigationStateRequest(*detective.UpdateInvestigationStateInput) (*request.Request, *detective.UpdateInvestigationStateOutput)

	UpdateOrganizationConfiguration(*detective.UpdateOrganizationConfigurationInput) (*detective.UpdateOrganizationConfigurationOutput, error)
	UpdateOrganizationConfigurationWithContext(aws.Context, *detective.UpdateOrganizationConfigurationInput, ...request.Option) (*detective.UpdateOrganizationConfigurationOutput, error)
	UpdateOrganizationConfigurationRequest(*detective.UpdateOrganizationConfigurationInput) (*request.Request, *detective.UpdateOrganizationConfigurationOutput)
}

var _ DetectiveAPI = (*detective.Detective)(nil)
