(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     27236,        796]
NotebookOptionsPosition[     26296,        759]
NotebookOutlinePosition[     26650,        775]
CellTagsIndexPosition[     26607,        772]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
The derivative of StereoCamera.project:\
\>", "Text",
 CellChangeTimes->{{3.5349648356912127`*^9, 3.534964846480523*^9}, {
  3.534983100980744*^9, 3.534983101484686*^9}, {3.535027340892766*^9, 
  3.535027341727685*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"fx", "0", 
          RowBox[{
           RowBox[{"-", "fx"}], " ", 
           RowBox[{"xL", "/", "z"}]}]},
         {"fx", "0", 
          RowBox[{
           RowBox[{"-", "fx"}], " ", 
           RowBox[{"xR", "/", "z"}]}]},
         {"0", "fy", 
          RowBox[{
           RowBox[{"-", "fy"}], " ", 
           RowBox[{"y", "/", "z"}]}]}
        }], ")"}], ".", 
      RowBox[{"(", GridBox[{
         {"0", 
          RowBox[{"-", "z"}], "y", 
          RowBox[{"-", "1"}], "0", "0", "R00", "R10", "R20"},
         {"z", "0", 
          RowBox[{"-", "x"}], "0", 
          RowBox[{"-", "1"}], "0", "R01", "R11", "R21"},
         {
          RowBox[{"-", "y"}], "x", "0", "0", "0", 
          RowBox[{"-", "1"}], "R02", "R12", "R22"}
        }], ")"}]}]}], "//", "FullSimplify"}], "//", 
   "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.5349631885090446`*^9, 3.5349632390951033`*^9}, {
   3.53496344228561*^9, 3.534963552777855*^9}, {3.53496365487344*^9, 
   3.53496369917972*^9}, 3.534963801932398*^9, {3.5349638327702837`*^9, 
   3.534963833842349*^9}, {3.5349638684957743`*^9, 3.534963869306225*^9}, {
   3.5349640018609343`*^9, 3.534964073635954*^9}, {3.534964139661661*^9, 
   3.534964141597094*^9}, {3.534964228457883*^9, 3.534964230497267*^9}, {
   3.534964522693956*^9, 3.534964554934105*^9}, 3.534979649216166*^9, {
   3.534979703414953*^9, 3.5349797245266523`*^9}, 3.534979754875834*^9, {
   3.5349801268943996`*^9, 3.534980128188809*^9}, {3.534981330976294*^9, 
   3.5349813327600317`*^9}, 3.534981567474765*^9, {3.534982081101321*^9, 
   3.534982107106247*^9}, {3.534982164393888*^9, 3.534982164510919*^9}, {
   3.534982374683118*^9, 3.534982376464725*^9}, {3.534985216789068*^9, 
   3.5349853102222767`*^9}, 3.535027505430372*^9, {3.5350275383121347`*^9, 
   3.5350275490436373`*^9}, {3.535030144765522*^9, 3.535030151312361*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"fx", " ", "xL", " ", "y"}], 
       SuperscriptBox["z", "2"]], 
      RowBox[{"fx", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         FractionBox[
          RowBox[{"x", " ", "xL"}], 
          SuperscriptBox["z", "2"]]}], ")"}]}], 
      FractionBox[
       RowBox[{"fx", " ", "y"}], "z"], 
      RowBox[{"-", 
       FractionBox["fx", "z"]}], "0", 
      FractionBox[
       RowBox[{"fx", " ", "xL"}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fx", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R02"}], " ", "xL"}], "+", 
          RowBox[{"R00", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fx", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R12"}], " ", "xL"}], "+", 
          RowBox[{"R10", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fx", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R22"}], " ", "xL"}], "+", 
          RowBox[{"R20", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]]},
     {
      FractionBox[
       RowBox[{"fx", " ", "xR", " ", "y"}], 
       SuperscriptBox["z", "2"]], 
      RowBox[{"fx", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         FractionBox[
          RowBox[{"x", " ", "xR"}], 
          SuperscriptBox["z", "2"]]}], ")"}]}], 
      FractionBox[
       RowBox[{"fx", " ", "y"}], "z"], 
      RowBox[{"-", 
       FractionBox["fx", "z"]}], "0", 
      FractionBox[
       RowBox[{"fx", " ", "xR"}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fx", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R02"}], " ", "xR"}], "+", 
          RowBox[{"R00", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fx", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R12"}], " ", "xR"}], "+", 
          RowBox[{"R10", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fx", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R22"}], " ", "xR"}], "+", 
          RowBox[{"R20", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]]},
     {
      RowBox[{"fy", "+", 
       FractionBox[
        RowBox[{"fy", " ", 
         SuperscriptBox["y", "2"]}], 
        SuperscriptBox["z", "2"]]}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"fy", " ", "x", " ", "y"}], 
        SuperscriptBox["z", "2"]]}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"fy", " ", "x"}], "z"]}], "0", 
      RowBox[{"-", 
       FractionBox["fy", "z"]}], 
      FractionBox[
       RowBox[{"fy", " ", "y"}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fy", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R02"}], " ", "y"}], "+", 
          RowBox[{"R01", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fy", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R12"}], " ", "y"}], "+", 
          RowBox[{"R11", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]], 
      FractionBox[
       RowBox[{"fy", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "R22"}], " ", "y"}], "+", 
          RowBox[{"R21", " ", "z"}]}], ")"}]}], 
       SuperscriptBox["z", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.534979650069955*^9, {3.534979704654621*^9, 3.5349797249719963`*^9}, 
   3.534979755407372*^9, 3.534980128803479*^9, 3.534981333789564*^9, 
   3.5349815682066193`*^9, 3.534982108180704*^9, 3.534982166031692*^9, 
   3.534982377250555*^9, {3.534985297869969*^9, 3.534985310666787*^9}, 
   3.5350275060097218`*^9, {3.5350275405948477`*^9, 3.5350275500341053`*^9}, 
   3.53502790540648*^9, 3.535029215121779*^9, 3.535029483759522*^9, 
   3.5350296764304867`*^9, 3.5350298306322317`*^9, {3.535029885155205*^9, 
   3.5350299030168447`*^9}, 3.53503004137671*^9, {3.53503014602885*^9, 
   3.53503015777907*^9}, 3.535030484588359*^9, 3.535030717468384*^9, 
   3.535030824926405*^9, 3.535030926999936*^9, 3.535031294857418*^9, 
   3.535031331229004*^9}]
}, Open  ]],

Cell["\<\
To get rid of (1/z) factors, work in terms of u=x/z and v=x/z.\
\>", "Text",
 CellChangeTimes->{{3.534981922219325*^9, 3.534981963212936*^9}, {
  3.534983115196439*^9, 3.534983121940318*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"H1", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xL", "\[Rule]", 
        RowBox[{"z", " ", 
         RowBox[{"uL", "/", "fx"}]}]}], ",", 
       RowBox[{"xR", "\[Rule]", 
        RowBox[{"z", " ", 
         RowBox[{"uR", "/", "fx"}]}]}], ",", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{"z", " ", 
         RowBox[{"v", "/", "fy"}]}]}]}], "}"}]}], "//", "FullSimplify"}], " ",
    "//", "MatrixForm", " "}]}]], "Input",
 CellChangeTimes->{{3.534981575562448*^9, 3.534981660163035*^9}, {
   3.534981699433219*^9, 3.534981715884362*^9}, {3.534981811953741*^9, 
   3.534981812758938*^9}, {3.534981967549185*^9, 3.534981970084591*^9}, {
   3.5349821168936243`*^9, 3.5349821229726763`*^9}, {3.5349821691614027`*^9, 
   3.534982169838853*^9}, {3.5349823818506517`*^9, 3.5349823882411737`*^9}, {
   3.534982418562274*^9, 3.534982445450313*^9}, {3.5349824987688103`*^9, 
   3.5349825453911533`*^9}, 3.5349853401371813`*^9, {3.5349854168944473`*^9, 
   3.534985505039978*^9}, {3.5349855515891447`*^9, 3.5349855522595778`*^9}, {
   3.534985594640473*^9, 3.534985605102441*^9}, {3.534985635544286*^9, 
   3.5349856556893806`*^9}, {3.534985722650296*^9, 3.534985735961334*^9}, {
   3.5349862396524563`*^9, 3.534986241578967*^9}, {3.534986277578917*^9, 
   3.5349863148397903`*^9}, {3.534986786489544*^9, 3.534986789124526*^9}, {
   3.5349868534541187`*^9, 3.534986854897138*^9}, {3.535029811937036*^9, 
   3.535029812505899*^9}, {3.5350298992369347`*^9, 3.535029900460285*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox[
        RowBox[{"uL", " ", "v"}], "fy"], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"uL", " ", "x"}], "+", 
          RowBox[{"fx", " ", "z"}]}], "z"]}], 
       FractionBox[
        RowBox[{"fx", " ", "v"}], "fy"], 
       RowBox[{"-", 
        FractionBox["fx", "z"]}], "0", 
       FractionBox["uL", "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fx", " ", "R00"}], "-", 
         RowBox[{"R02", " ", "uL"}]}], "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fx", " ", "R10"}], "-", 
         RowBox[{"R12", " ", "uL"}]}], "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fx", " ", "R20"}], "-", 
         RowBox[{"R22", " ", "uL"}]}], "z"]},
      {
       FractionBox[
        RowBox[{"uR", " ", "v"}], "fy"], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"uR", " ", "x"}], "+", 
          RowBox[{"fx", " ", "z"}]}], "z"]}], 
       FractionBox[
        RowBox[{"fx", " ", "v"}], "fy"], 
       RowBox[{"-", 
        FractionBox["fx", "z"]}], "0", 
       FractionBox["uR", "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fx", " ", "R00"}], "-", 
         RowBox[{"R02", " ", "uR"}]}], "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fx", " ", "R10"}], "-", 
         RowBox[{"R12", " ", "uR"}]}], "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fx", " ", "R20"}], "-", 
         RowBox[{"R22", " ", "uR"}]}], "z"]},
      {
       RowBox[{"fy", "+", 
        FractionBox[
         SuperscriptBox["v", "2"], "fy"]}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"v", " ", "x"}], "z"]}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"fy", " ", "x"}], "z"]}], "0", 
       RowBox[{"-", 
        FractionBox["fy", "z"]}], 
       FractionBox["v", "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fy", " ", "R01"}], "-", 
         RowBox[{"R02", " ", "v"}]}], "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fy", " ", "R11"}], "-", 
         RowBox[{"R12", " ", "v"}]}], "z"], 
       FractionBox[
        RowBox[{
         RowBox[{"fy", " ", "R21"}], "-", 
         RowBox[{"R22", " ", "v"}]}], "z"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.534981661750978*^9, {3.534981700471121*^9, 3.5349817167574883`*^9}, 
   3.534981813153152*^9, 3.5349819705942793`*^9, {3.534982117522484*^9, 
   3.534982124251252*^9}, 3.534982170293386*^9, 3.534982388956635*^9, 
   3.534982446240321*^9, {3.534982502305121*^9, 3.534982546180998*^9}, 
   3.534985341687833*^9, {3.534985429323271*^9, 3.534985505574792*^9}, 
   3.534985553224812*^9, {3.534985595114938*^9, 3.534985605471074*^9}, {
   3.534985637118844*^9, 3.534985656675743*^9}, {3.534985725554123*^9, 
   3.534985736368793*^9}, 3.5349862441909113`*^9, 3.534986284242839*^9, 
   3.534986315973349*^9, 3.5349868083087063`*^9, 3.5349868556678743`*^9, 
   3.535027508201213*^9, 3.535027905504321*^9, 3.535029215205296*^9, 
   3.535029483862213*^9, 3.5350296765274553`*^9, {3.535029813618102*^9, 
   3.535029830728488*^9}, {3.5350298852376328`*^9, 3.535029903102009*^9}, 
   3.535030041462805*^9, 3.535030157872327*^9, 3.535030484684712*^9, 
   3.535030717553156*^9, 3.535030825005567*^9, 3.5350309270975943`*^9, 
   3.535031294955385*^9, 3.535031331322283*^9}]
}, Open  ]],

Cell["\<\
Finally, avoid divides, version one, with annoying (but efficient) \
non-physical v1 and dx:\
\>", "Text",
 CellChangeTimes->{{3.534983093980698*^9, 3.5349831123126383`*^9}, {
  3.535030889345251*^9, 3.535030899759769*^9}, {3.535031098323531*^9, 
  3.5350310992901497`*^9}, {3.53503128089581*^9, 3.535031286791445*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"H2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "z"}], "\[Rule]", "d"}], ",", " ", 
      RowBox[{"v", " ", "\[Rule]", " ", 
       RowBox[{"v1", " ", "fy"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"z", " ", "d"}], " ", "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"v1", " ", "fy"}], " ", "\[Equal]", "v"}], ",", "  ", 
     RowBox[{
      RowBox[{"fx", " ", "v1"}], " ", "\[Equal]", " ", "v2"}], ",", " ", 
     RowBox[{
      RowBox[{"d", " ", "x"}], " ", "\[Equal]", "dx"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.534982548021124*^9, 3.534982548331835*^9}, {
   3.534985672071082*^9, 3.5349856752309647`*^9}, {3.53498575691752*^9, 
   3.534985773748554*^9}, {3.534985930341876*^9, 3.534985932316481*^9}, {
   3.534986318557267*^9, 3.534986330749145*^9}, 3.534986878092679*^9, {
   3.535027890326747*^9, 3.5350279684574137`*^9}, {3.535029655571067*^9, 
   3.5350296880567923`*^9}, 3.535029764887192*^9, {3.535030004090427*^9, 
   3.535030121269846*^9}, {3.535030353510531*^9, 3.535030396311715*^9}, {
   3.535030458599264*^9, 3.535030460790845*^9}, {3.535030491323802*^9, 
   3.5350304934595013`*^9}, {3.53503074017763*^9, 3.5350307703521557`*^9}, {
   3.535030874930986*^9, 3.535030880610591*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"uL", " ", "v1"}], 
       RowBox[{
        RowBox[{"-", "fx"}], "-", 
        RowBox[{"dx", " ", "uL"}]}], "v2", 
       RowBox[{
        RowBox[{"-", "d"}], " ", "fx"}], "0", 
       RowBox[{"d", " ", "uL"}], 
       RowBox[{
        RowBox[{"d", " ", "fx", " ", "R00"}], "-", 
        RowBox[{"d", " ", "R02", " ", "uL"}]}], 
       RowBox[{
        RowBox[{"d", " ", "fx", " ", "R10"}], "-", 
        RowBox[{"d", " ", "R12", " ", "uL"}]}], 
       RowBox[{
        RowBox[{"d", " ", "fx", " ", "R20"}], "-", 
        RowBox[{"d", " ", "R22", " ", "uL"}]}]},
      {
       RowBox[{"uR", " ", "v1"}], 
       RowBox[{
        RowBox[{"-", "fx"}], "-", 
        RowBox[{"dx", " ", "uR"}]}], "v2", 
       RowBox[{
        RowBox[{"-", "d"}], " ", "fx"}], "0", 
       RowBox[{"d", " ", "uR"}], 
       RowBox[{
        RowBox[{"d", " ", "fx", " ", "R00"}], "-", 
        RowBox[{"d", " ", "R02", " ", "uR"}]}], 
       RowBox[{
        RowBox[{"d", " ", "fx", " ", "R10"}], "-", 
        RowBox[{"d", " ", "R12", " ", "uR"}]}], 
       RowBox[{
        RowBox[{"d", " ", "fx", " ", "R20"}], "-", 
        RowBox[{"d", " ", "R22", " ", "uR"}]}]},
      {
       RowBox[{"fy", "+", 
        RowBox[{"v", " ", "v1"}]}], 
       RowBox[{
        RowBox[{"-", "dx"}], " ", "v"}], 
       RowBox[{
        RowBox[{"-", "dx"}], " ", "fy"}], "0", 
       RowBox[{
        RowBox[{"-", "d"}], " ", "fy"}], 
       RowBox[{"d", " ", "v"}], 
       RowBox[{
        RowBox[{"d", " ", "fy", " ", "R01"}], "-", 
        RowBox[{"d", " ", "R02", " ", "v"}]}], 
       RowBox[{
        RowBox[{"d", " ", "fy", " ", "R11"}], "-", 
        RowBox[{"d", " ", "R12", " ", "v"}]}], 
       RowBox[{
        RowBox[{"d", " ", "fy", " ", "R21"}], "-", 
        RowBox[{"d", " ", "R22", " ", "v"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.535030870852317*^9, 3.5350308809975147`*^9}, 
   3.535030927149189*^9, 3.53503110310464*^9, 3.535031295009418*^9, 
   3.5350313313757133`*^9}]
}, Open  ]],

Cell["\<\
Second version, with u and v not divided by focal lengths (i.e., intrinsic \
coordinates):\
\>", "Text",
 CellChangeTimes->{{3.5350309023234043`*^9, 3.53503092149507*^9}, {
  3.535031301437237*^9, 3.535031325948593*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"H1", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xL", "\[Rule]", 
        RowBox[{"z", " ", "uL"}]}], ",", 
       RowBox[{"xR", "\[Rule]", 
        RowBox[{"z", " ", "uR"}]}], ",", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{"z", " ", "v"}]}]}], "}"}]}], "//", "FullSimplify"}], " ", "//",
    "MatrixForm", " "}]}]], "Input",
 CellChangeTimes->{{3.53503114628979*^9, 3.535031150920274*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"fx", " ", "uL", " ", "v"}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"fx", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"uL", " ", "x"}], "+", "z"}], ")"}]}], "z"]}], 
       RowBox[{"fx", " ", "v"}], 
       RowBox[{"-", 
        FractionBox["fx", "z"]}], "0", 
       FractionBox[
        RowBox[{"fx", " ", "uL"}], "z"], 
       FractionBox[
        RowBox[{"fx", " ", 
         RowBox[{"(", 
          RowBox[{"R00", "-", 
           RowBox[{"R02", " ", "uL"}]}], ")"}]}], "z"], 
       FractionBox[
        RowBox[{"fx", " ", 
         RowBox[{"(", 
          RowBox[{"R10", "-", 
           RowBox[{"R12", " ", "uL"}]}], ")"}]}], "z"], 
       FractionBox[
        RowBox[{"fx", " ", 
         RowBox[{"(", 
          RowBox[{"R20", "-", 
           RowBox[{"R22", " ", "uL"}]}], ")"}]}], "z"]},
      {
       RowBox[{"fx", " ", "uR", " ", "v"}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"fx", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"uR", " ", "x"}], "+", "z"}], ")"}]}], "z"]}], 
       RowBox[{"fx", " ", "v"}], 
       RowBox[{"-", 
        FractionBox["fx", "z"]}], "0", 
       FractionBox[
        RowBox[{"fx", " ", "uR"}], "z"], 
       FractionBox[
        RowBox[{"fx", " ", 
         RowBox[{"(", 
          RowBox[{"R00", "-", 
           RowBox[{"R02", " ", "uR"}]}], ")"}]}], "z"], 
       FractionBox[
        RowBox[{"fx", " ", 
         RowBox[{"(", 
          RowBox[{"R10", "-", 
           RowBox[{"R12", " ", "uR"}]}], ")"}]}], "z"], 
       FractionBox[
        RowBox[{"fx", " ", 
         RowBox[{"(", 
          RowBox[{"R20", "-", 
           RowBox[{"R22", " ", "uR"}]}], ")"}]}], "z"]},
      {
       RowBox[{"fy", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["v", "2"]}], ")"}]}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"fy", " ", "v", " ", "x"}], "z"]}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"fy", " ", "x"}], "z"]}], "0", 
       RowBox[{"-", 
        FractionBox["fy", "z"]}], 
       FractionBox[
        RowBox[{"fy", " ", "v"}], "z"], 
       FractionBox[
        RowBox[{"fy", " ", 
         RowBox[{"(", 
          RowBox[{"R01", "-", 
           RowBox[{"R02", " ", "v"}]}], ")"}]}], "z"], 
       FractionBox[
        RowBox[{"fy", " ", 
         RowBox[{"(", 
          RowBox[{"R11", "-", 
           RowBox[{"R12", " ", "v"}]}], ")"}]}], "z"], 
       FractionBox[
        RowBox[{"fy", " ", 
         RowBox[{"(", 
          RowBox[{"R21", "-", 
           RowBox[{"R22", " ", "v"}]}], ")"}]}], "z"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.5350311514150476`*^9, 3.5350312951300697`*^9, 
  3.535031331425353*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"H2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "z"}], "\[Rule]", "d"}], ",", " ", 
      RowBox[{"x", "->", " ", 
       RowBox[{"uL", "/", " ", "d"}]}]}], " ", "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", " ", "d"}], " ", "\[Equal]", "1"}], "}"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.534982548021124*^9, 3.534982548331835*^9}, {
   3.534985672071082*^9, 3.5349856752309647`*^9}, {3.53498575691752*^9, 
   3.534985773748554*^9}, {3.534985930341876*^9, 3.534985932316481*^9}, {
   3.534986318557267*^9, 3.534986330749145*^9}, 3.534986878092679*^9, {
   3.535027890326747*^9, 3.5350279684574137`*^9}, {3.535029655571067*^9, 
   3.5350296880567923`*^9}, 3.535029764887192*^9, {3.535030004090427*^9, 
   3.535030121269846*^9}, {3.535030353510531*^9, 3.535030396311715*^9}, {
   3.535030458599264*^9, 3.535030460790845*^9}, {3.535030491323802*^9, 
   3.5350304934595013`*^9}, {3.53503074017763*^9, 3.5350307703521557`*^9}, {
   3.5350309553568153`*^9, 3.535030961548119*^9}, {3.535031181790264*^9, 
   3.535031181981776*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"fx", " ", "uL", " ", "v"}], 
       RowBox[{
        RowBox[{"-", "fx"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["uL", "2"]}], ")"}]}], 
       RowBox[{"fx", " ", "v"}], 
       RowBox[{
        RowBox[{"-", "d"}], " ", "fx"}], "0", 
       RowBox[{"d", " ", "fx", " ", "uL"}], 
       RowBox[{"d", " ", "fx", " ", 
        RowBox[{"(", 
         RowBox[{"R00", "-", 
          RowBox[{"R02", " ", "uL"}]}], ")"}]}], 
       RowBox[{"d", " ", "fx", " ", 
        RowBox[{"(", 
         RowBox[{"R10", "-", 
          RowBox[{"R12", " ", "uL"}]}], ")"}]}], 
       RowBox[{"d", " ", "fx", " ", 
        RowBox[{"(", 
         RowBox[{"R20", "-", 
          RowBox[{"R22", " ", "uL"}]}], ")"}]}]},
      {
       RowBox[{"fx", " ", "uR", " ", "v"}], 
       RowBox[{
        RowBox[{"-", "fx"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"uL", " ", "uR"}]}], ")"}]}], 
       RowBox[{"fx", " ", "v"}], 
       RowBox[{
        RowBox[{"-", "d"}], " ", "fx"}], "0", 
       RowBox[{"d", " ", "fx", " ", "uR"}], 
       RowBox[{"d", " ", "fx", " ", 
        RowBox[{"(", 
         RowBox[{"R00", "-", 
          RowBox[{"R02", " ", "uR"}]}], ")"}]}], 
       RowBox[{"d", " ", "fx", " ", 
        RowBox[{"(", 
         RowBox[{"R10", "-", 
          RowBox[{"R12", " ", "uR"}]}], ")"}]}], 
       RowBox[{"d", " ", "fx", " ", 
        RowBox[{"(", 
         RowBox[{"R20", "-", 
          RowBox[{"R22", " ", "uR"}]}], ")"}]}]},
      {
       RowBox[{"fy", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["v", "2"]}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "fy"}], " ", "uL", " ", "v"}], 
       RowBox[{
        RowBox[{"-", "fy"}], " ", "uL"}], "0", 
       RowBox[{
        RowBox[{"-", "d"}], " ", "fy"}], 
       RowBox[{"d", " ", "fy", " ", "v"}], 
       RowBox[{"d", " ", "fy", " ", 
        RowBox[{"(", 
         RowBox[{"R01", "-", 
          RowBox[{"R02", " ", "v"}]}], ")"}]}], 
       RowBox[{"d", " ", "fy", " ", 
        RowBox[{"(", 
         RowBox[{"R11", "-", 
          RowBox[{"R12", " ", "v"}]}], ")"}]}], 
       RowBox[{"d", " ", "fy", " ", 
        RowBox[{"(", 
         RowBox[{"R21", "-", 
          RowBox[{"R22", " ", "v"}]}], ")"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.5350311905951633`*^9, 3.535031295195949*^9, 
  3.535031331472315*^9}]
}, Open  ]]
},
WindowSize->{936, 817},
WindowMargins->{{26, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 229, 5, 26, "Text"],
Cell[CellGroupData[{
Cell[811, 29, 2006, 46, 61, "Input"],
Cell[2820, 77, 5034, 153, 109, "Output"]
}, Open  ]],
Cell[7869, 233, 201, 4, 26, "Text"],
Cell[CellGroupData[{
Cell[8095, 241, 1555, 30, 27, "Input"],
Cell[9653, 273, 3952, 109, 109, "Output"]
}, Open  ]],
Cell[13620, 385, 329, 6, 26, "Text"],
Cell[CellGroupData[{
Cell[13974, 395, 1364, 30, 27, "Input"],
Cell[15341, 427, 2598, 74, 73, "Output"]
}, Open  ]],
Cell[17954, 504, 230, 5, 26, "Text"],
Cell[CellGroupData[{
Cell[18209, 513, 481, 14, 27, "Input"],
Cell[18693, 529, 3372, 106, 101, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22102, 640, 1150, 24, 27, "Input"],
Cell[23255, 666, 3025, 90, 83, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
