/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef CLEAVE_MOTIF_HPP
#define CLEAVE_MOTIF_HPP


/////////////////////// Qt includes
#include <QString>
#include <QStringList>
#include <QList>


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "PolChemDefEntity.hpp"
#include "Monomer.hpp"


namespace MsXpS
{

namespace libXpertMass
{


  class DECLSPEC CleaveMotif : public PolChemDefEntity
  {
    public:
    CleaveMotif(PolChemDefCstSPtr,
                QString,
                const QString & = QString(),
                int             = 0,
                bool            = false);

    CleaveMotif(const CleaveMotif &other);


    ~CleaveMotif();

    using PolChemDefEntity::operator=;
    CleaveMotif &operator=(const CleaveMotif &other);

    void setMotif(const QString &);
    const QString &motif();

    const QStringList &codeList() const;

    void setOffset(int);
    int offset();

    void setForCleave(bool);
    bool isForCleave();

    int parse(const QString &);

    using PolChemDefEntity::validate;
    bool validate();

    protected:
    //! Motif.
    QString m_motif;

    //! List of codes in motif.
    QStringList m_codeList;

    //! Offset of the cleavage.
    int m_offset;

    //! Tells if motif is for cleavage.
    bool m_isForCleave;
  };

} // namespace libXpertMass

} // namespace MsXpS


#endif // CLEAVE_MOTIF_HPP
