# emacs: -*- mode: python; py-indent-offset: 4; indent-tabs-mode: nil -*-
# vi: set ft=python sts=4 ts=4 sw=4 et:
"""
Please write tests for all code submitted to the repository. The code will be
used by many people, and will in due course be used in live analyses, so we
need to make sure that we have the best possible defenses against bugs. It also
helps us think about code interfaces, and gives examples of code use that can
be useful for others using the code.

Python's unit testing framework (the
U{unittest<http://docs.python.org/lib/module-unittest.html>} module) is used to
implement project tests. We use the convention that each package contains a
subpackage called tests which contains modules defining test cases (subclasses
of U{unittest.TestCase<http://docs.python.org/lib/testcase-objects.html>})
for that package. The nipy.utils.tests package contains an example test case
called L{test_template.TemplateTest} to get you started writing your tests.
Please try to include working test cases for all functions and classes that
you contribute. Often, writing tests for your code before the code is written
helps to frame your thoughts about what the code should look like.
"""
