# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.monitor import MonitorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-monitor
# USAGE
    python create_or_update_dynamic_metric_alert_single_resource.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MonitorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.metric_alerts.create_or_update(
        resource_group_name="gigtest",
        rule_name="chiricutin",
        parameters={
            "location": "global",
            "properties": {
                "actions": [
                    {
                        "actionGroupId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
                        "webHookProperties": {"key11": "value11", "key12": "value12"},
                    }
                ],
                "autoMitigate": True,
                "criteria": {
                    "allOf": [
                        {
                            "alertSensitivity": "Medium",
                            "criterionType": "DynamicThresholdCriterion",
                            "dimensions": [],
                            "failingPeriods": {"minFailingPeriodsToAlert": 4, "numberOfEvaluationPeriods": 4},
                            "ignoreDataBefore": "2019-04-04T21:00:00.000Z",
                            "metricName": "Percentage CPU",
                            "metricNamespace": "microsoft.compute/virtualmachines",
                            "name": "High_CPU_80",
                            "operator": "GreaterOrLessThan",
                            "timeAggregation": "Average",
                        }
                    ],
                    "odata.type": "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
                },
                "description": "This is the description of the rule1",
                "enabled": True,
                "evaluationFrequency": "PT1M",
                "scopes": [
                    "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme"
                ],
                "severity": 3,
                "windowSize": "PT15M",
            },
            "tags": {},
        },
    )
    print(response)


# x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateDynamicMetricAlertSingleResource.json
if __name__ == "__main__":
    main()
