% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_ol}
\alias{cli_ol}
\title{Ordered CLI list}
\usage{
cli_ol(
  items = NULL,
  id = NULL,
  class = NULL,
  .close = TRUE,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{items}{If not \code{NULL}, then a character vector. Each element of
the vector will be one list item, and the list container will be
closed by default (see the \code{.close} argument).}

\item{id}{Id of the list container. Can be used for closing it with
\code{\link[=cli_end]{cli_end()}} or in themes. If \code{NULL}, then an id is generated and
returned invisibly.}

\item{class}{Class of the list container. Can be used in themes.}

\item{.close}{Whether to close the list container if the \code{items} were
specified. If \code{FALSE} then new items can be added to the list.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
An ordered list is a container, see \link{containers}.
}
\details{
\subsection{Adding all items at once}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_ol(c("one", "two", "three"))
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> 1. one                                                                          
#> 2. two                                                                          
#> 3. three                                                                        
</pre></div>
}}

}

\subsection{Adding items one by one}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## Adding items one by one
fun <- function() \{
  cli_ol()
  cli_li("\{.emph one\}")
  cli_li("\{.emph two\}")
  cli_li("\{.emph three\}")
  cli_end()
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> 1. <span style="font-style: italic;">one</span>                                                                          
#> 2. <span style="font-style: italic;">two</span>                                                                          
#> 3. <span style="font-style: italic;">three</span>                                                                        
</pre></div>
}}

}

\subsection{Nested lists}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_div(theme = list(ol = list("margin-left" = 2)))
  cli_ul()
  cli_li("one")
  cli_ol(c("foo", "bar", "foobar"))
  cli_li("two")
  cli_end()
  cli_end()
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> • one                                                                           
#>     1. foo                                                                      
#>     2. bar                                                                      
#>     3. foobar                                                                   
#> • two                                                                           
</pre></div>
}}

}
}
\seealso{
This function supports \link[=inline-markup]{inline markup}.

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_bullets}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status_update}()},
\code{\link{cli_status}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
