% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design_plan.R
\name{TrialDesignPlanCountData}
\alias{TrialDesignPlanCountData}
\title{Trial Design Plan Count Data}
\description{
Trial design plan for count data.
}
\details{
This object cannot be created directly; use \code{\link[=getSampleSizeCounts]{getSampleSizeCounts()}}
with suitable arguments to create a design plan for a dataset of rates.
}
\section{Fields}{

\describe{
\item{\code{thetaH0}}{The difference or assumed effect under H0. Is a numeric vector of length 1.}

\item{\code{groups}}{The group numbers. Is a numeric vector.}

\item{\code{allocationRatioPlanned}}{The planned allocation ratio (\code{n1 / n2}) for the groups. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control. Is a positive numeric vector of length 1.}

\item{\code{optimumAllocationRatio}}{The allocation ratio that is optimum with respect to the overall sample size at given power. Is a logical vector of length 1.}

\item{\code{directionUpper}}{Specifies the direction of the alternative, only applicable for one-sided testing. Default is \code{TRUE} which means that larger values of the test statistics yield smaller p-values. Is a logical vector of length 1.}

\item{\code{lambda1}}{The assumed hazard rate in the treatment group. Is a numeric vector of length \code{kMax}.}

\item{\code{lambda2}}{The assumed hazard rate in the reference group. Is a numeric vector of length 1.}

\item{\code{lambda}}{A numeric value or vector that represents the assumed rate of a homogeneous Poisson process in the pooled treatment groups Is a numeric vector.}

\item{\code{theta}}{A vector of standardized effect sizes (theta values). Is a numeric vector.}

\item{\code{nFixed}}{The sample size in a fixed (one-stage) design. Is a positive numeric vector.}

\item{\code{nFixed1}}{The sample size in treatment arm 1 in a fixed (one-stage) design. Is a positive numeric vector.}

\item{\code{nFixed2}}{The sample size in treatment arm 2 in a fixed (one-stage) design. Is a positive numeric vector.}

\item{\code{maxNumberOfSubjects}}{The maximum number of subjects for power calculations. Is a numeric vector.}

\item{\code{maxNumberOfSubjects1}}{The maximum number of subjects in treatment arm 1. Is a numeric vector.}

\item{\code{maxNumberOfSubjects2}}{The maximum number of subjects in treatment arm 2. Is a numeric vector.}

\item{\code{overallReject}}{The overall rejection probability. Is a numeric vector.}

\item{\code{rejectPerStage}}{The probability to reject a hypothesis per stage of the trial. Is a numeric matrix.}

\item{\code{futilityStop}}{In simulation results data set: indicates whether trial is stopped for futility or not.}

\item{\code{futilityPerStage}}{The per-stage probabilities of stopping the trial for futility. Is a numeric matrix.}

\item{\code{earlyStop}}{The probability to stopping the trial either for efficacy or futility. Is a numeric vector.}

\item{\code{overdispersion}}{A numeric value that represents the assumed overdispersion of the negative binomial distribution Is a numeric vector.}

\item{\code{fixedExposureTime}}{If specified, the fixed time of exposure per subject for count data Is a numeric vector.}

\item{\code{accrualTime}}{The assumed accrual time intervals for the study. Is a numeric vector.}

\item{\code{accrualIntensity}}{The absolute accrual intensities. Is a numeric vector of length \code{kMax}.}

\item{\code{followUpTime}}{The assumed follow-up time for the study. Is a numeric vector of length 1.}

\item{\code{calendarTime}}{The calendar time Is a numeric vector.}

\item{\code{expectedStudyDurationH1}}{The expected study duration under H1 Is a numeric vector.}

\item{\code{studyTime}}{The study time Is a numeric vector.}

\item{\code{numberOfSubjects}}{In simulation results data set: The number of subjects under consideration when the interim analysis takes place.}

\item{\code{expectedNumberOfSubjectsH1}}{The expected number of subjects under H1. Is a numeric vector.}

\item{\code{informationOverStages}}{The information over stages Is a numeric vector.}

\item{\code{expectedInformationH0}}{The expected information under H0 Is a numeric vector.}

\item{\code{expectedInformationH01}}{The expected information under H0/H1 Is a numeric vector.}

\item{\code{expectedInformationH1}}{The expected information under H1 Is a numeric vector.}

\item{\code{maxInformation}}{The maximum information. Is a numeric vector of length 1 containing a whole number.}

\item{\code{futilityBoundsPValueScale}}{The futility bounds for each stage of the trial on the p-value scale. Is a numeric matrix.}
}}

\keyword{internal}
