// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Align, Buildable, Container, DirectionType, NotebookTab, PackType, PositionType, ResizeMode,
    Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkNotebook")]
    pub struct Notebook(Object<ffi::GtkNotebook, ffi::GtkNotebookClass>) @extends Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_notebook_get_type(),
    }
}

impl Notebook {
    pub const NONE: Option<&'static Notebook> = None;

    #[doc(alias = "gtk_notebook_new")]
    pub fn new() -> Notebook {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_notebook_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Notebook`] objects.
    ///
    /// This method returns an instance of [`NotebookBuilder`](crate::builders::NotebookBuilder) which can be used to create [`Notebook`] objects.
    pub fn builder() -> NotebookBuilder {
        NotebookBuilder::new()
    }
}

impl Default for Notebook {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Notebook`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct NotebookBuilder {
    builder: glib::object::ObjectBuilder<'static, Notebook>,
}

impl NotebookBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn enable_popup(self, enable_popup: bool) -> Self {
        Self {
            builder: self.builder.property("enable-popup", enable_popup),
        }
    }

    pub fn group_name(self, group_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("group-name", group_name.into()),
        }
    }

    pub fn page(self, page: i32) -> Self {
        Self {
            builder: self.builder.property("page", page),
        }
    }

    pub fn scrollable(self, scrollable: bool) -> Self {
        Self {
            builder: self.builder.property("scrollable", scrollable),
        }
    }

    pub fn show_border(self, show_border: bool) -> Self {
        Self {
            builder: self.builder.property("show-border", show_border),
        }
    }

    pub fn show_tabs(self, show_tabs: bool) -> Self {
        Self {
            builder: self.builder.property("show-tabs", show_tabs),
        }
    }

    pub fn tab_pos(self, tab_pos: PositionType) -> Self {
        Self {
            builder: self.builder.property("tab-pos", tab_pos),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Notebook`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Notebook {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Notebook>> Sealed for T {}
}

pub trait NotebookExt: IsA<Notebook> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_notebook_detach_tab")]
    fn detach_tab(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_notebook_detach_tab(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_notebook_get_action_widget")]
    #[doc(alias = "get_action_widget")]
    fn action_widget(&self, pack_type: PackType) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_action_widget(
                self.as_ref().to_glib_none().0,
                pack_type.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_group_name")]
    #[doc(alias = "get_group_name")]
    fn group_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_group_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_menu_label")]
    #[doc(alias = "get_menu_label")]
    fn menu_label(&self, child: &impl IsA<Widget>) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_menu_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_menu_label_text")]
    #[doc(alias = "get_menu_label_text")]
    fn menu_label_text(&self, child: &impl IsA<Widget>) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_menu_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_scrollable")]
    #[doc(alias = "get_scrollable")]
    fn is_scrollable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_scrollable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_show_border")]
    #[doc(alias = "get_show_border")]
    fn shows_border(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_show_border(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_show_tabs")]
    #[doc(alias = "get_show_tabs")]
    fn shows_tabs(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_show_tabs(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_tab_detachable")]
    #[doc(alias = "get_tab_detachable")]
    fn tab_is_detachable(&self, child: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_tab_detachable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_tab_label")]
    #[doc(alias = "get_tab_label")]
    fn tab_label(&self, child: &impl IsA<Widget>) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_tab_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_tab_label_text")]
    #[doc(alias = "get_tab_label_text")]
    fn tab_label_text(&self, child: &impl IsA<Widget>) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_tab_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_tab_pos")]
    #[doc(alias = "get_tab_pos")]
    fn tab_pos(&self) -> PositionType {
        unsafe {
            from_glib(ffi::gtk_notebook_get_tab_pos(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_get_tab_reorderable")]
    #[doc(alias = "get_tab_reorderable")]
    fn tab_is_reorderable(&self, child: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_tab_reorderable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_notebook_next_page")]
    fn next_page(&self) {
        unsafe {
            ffi::gtk_notebook_next_page(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_notebook_popup_disable")]
    fn popup_disable(&self) {
        unsafe {
            ffi::gtk_notebook_popup_disable(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_notebook_popup_enable")]
    fn popup_enable(&self) {
        unsafe {
            ffi::gtk_notebook_popup_enable(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_notebook_prev_page")]
    fn prev_page(&self) {
        unsafe {
            ffi::gtk_notebook_prev_page(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_notebook_set_action_widget")]
    fn set_action_widget(&self, widget: &impl IsA<Widget>, pack_type: PackType) {
        unsafe {
            ffi::gtk_notebook_set_action_widget(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                pack_type.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_group_name")]
    fn set_group_name(&self, group_name: Option<&str>) {
        unsafe {
            ffi::gtk_notebook_set_group_name(
                self.as_ref().to_glib_none().0,
                group_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_menu_label")]
    fn set_menu_label(&self, child: &impl IsA<Widget>, menu_label: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_notebook_set_menu_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                menu_label.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_menu_label_text")]
    fn set_menu_label_text(&self, child: &impl IsA<Widget>, menu_text: &str) {
        unsafe {
            ffi::gtk_notebook_set_menu_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                menu_text.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_scrollable")]
    fn set_scrollable(&self, scrollable: bool) {
        unsafe {
            ffi::gtk_notebook_set_scrollable(
                self.as_ref().to_glib_none().0,
                scrollable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_show_border")]
    fn set_show_border(&self, show_border: bool) {
        unsafe {
            ffi::gtk_notebook_set_show_border(
                self.as_ref().to_glib_none().0,
                show_border.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_show_tabs")]
    fn set_show_tabs(&self, show_tabs: bool) {
        unsafe {
            ffi::gtk_notebook_set_show_tabs(self.as_ref().to_glib_none().0, show_tabs.into_glib());
        }
    }

    #[doc(alias = "gtk_notebook_set_tab_detachable")]
    fn set_tab_detachable(&self, child: &impl IsA<Widget>, detachable: bool) {
        unsafe {
            ffi::gtk_notebook_set_tab_detachable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                detachable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_tab_label")]
    fn set_tab_label(&self, child: &impl IsA<Widget>, tab_label: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_notebook_set_tab_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                tab_label.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_tab_label_text")]
    fn set_tab_label_text(&self, child: &impl IsA<Widget>, tab_text: &str) {
        unsafe {
            ffi::gtk_notebook_set_tab_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                tab_text.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_notebook_set_tab_pos")]
    fn set_tab_pos(&self, pos: PositionType) {
        unsafe {
            ffi::gtk_notebook_set_tab_pos(self.as_ref().to_glib_none().0, pos.into_glib());
        }
    }

    #[doc(alias = "gtk_notebook_set_tab_reorderable")]
    fn set_tab_reorderable(&self, child: &impl IsA<Widget>, reorderable: bool) {
        unsafe {
            ffi::gtk_notebook_set_tab_reorderable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    #[doc(alias = "enable-popup")]
    fn enables_popup(&self) -> bool {
        ObjectExt::property(self.as_ref(), "enable-popup")
    }

    #[doc(alias = "enable-popup")]
    fn set_enable_popup(&self, enable_popup: bool) {
        ObjectExt::set_property(self.as_ref(), "enable-popup", enable_popup)
    }

    fn page(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "page")
    }

    fn set_page(&self, page: i32) {
        ObjectExt::set_property(self.as_ref(), "page", page)
    }

    fn child_is_detachable<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "detachable",
        )
    }

    fn set_child_detachable<T: IsA<crate::Widget>>(&self, item: &T, detachable: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "detachable",
            &detachable,
        )
    }

    #[doc(alias = "child.menu-label")]
    fn child_menu_label<T: IsA<crate::Widget>>(&self, item: &T) -> Option<glib::GString> {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "menu-label",
        )
    }

    #[doc(alias = "child.menu-label")]
    fn set_child_menu_label<T: IsA<crate::Widget>>(&self, item: &T, menu_label: Option<&str>) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "menu-label",
            &menu_label,
        )
    }

    fn child_position<T: IsA<crate::Widget>>(&self, item: &T) -> i32 {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "position",
        )
    }

    fn set_child_position<T: IsA<crate::Widget>>(&self, item: &T, position: i32) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "position",
            &position,
        )
    }

    fn child_is_reorderable<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "reorderable",
        )
    }

    fn set_child_reorderable<T: IsA<crate::Widget>>(&self, item: &T, reorderable: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "reorderable",
            &reorderable,
        )
    }

    #[doc(alias = "child.tab-expand")]
    fn child_tab_expands<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "tab-expand",
        )
    }

    #[doc(alias = "child.tab-expand")]
    fn set_child_tab_expand<T: IsA<crate::Widget>>(&self, item: &T, tab_expand: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "tab-expand",
            &tab_expand,
        )
    }

    #[doc(alias = "child.tab-fill")]
    fn child_tab_fills<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "tab-fill",
        )
    }

    #[doc(alias = "child.tab-fill")]
    fn set_child_tab_fill<T: IsA<crate::Widget>>(&self, item: &T, tab_fill: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "tab-fill",
            &tab_fill,
        )
    }

    #[doc(alias = "child.tab-label")]
    fn child_tab_label<T: IsA<crate::Widget>>(&self, item: &T) -> Option<glib::GString> {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "tab-label",
        )
    }

    #[doc(alias = "child.tab-label")]
    fn set_child_tab_label<T: IsA<crate::Widget>>(&self, item: &T, tab_label: Option<&str>) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "tab-label",
            &tab_label,
        )
    }

    #[doc(alias = "change-current-page")]
    fn connect_change_current_page<F: Fn(&Self, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn change_current_page_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, i32) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref(), object).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-current-page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    change_current_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_change_current_page(&self, object: i32) -> bool {
        self.emit_by_name("change-current-page", &[&object])
    }

    #[doc(alias = "create-window")]
    fn connect_create_window<F: Fn(&Self, &Widget, i32, i32) -> Notebook + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_window_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, i32, i32) -> Notebook + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            page: *mut ffi::GtkWidget,
            x: libc::c_int,
            y: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> *mut ffi::GtkNotebook {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(page),
                x,
                y,
            ) /*Not checked*/
            .to_glib_none()
            .0
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"create-window\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    create_window_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-tab")]
    fn connect_focus_tab<F: Fn(&Self, NotebookTab) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn focus_tab_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, NotebookTab) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: ffi::GtkNotebookTab,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"focus-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    focus_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_focus_tab(&self, object: NotebookTab) -> bool {
        self.emit_by_name("focus-tab", &[&object])
    }

    #[doc(alias = "move-focus-out")]
    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_out_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus-out\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_out_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus_out(&self, object: DirectionType) {
        self.emit_by_name::<()>("move-focus-out", &[&object]);
    }

    #[doc(alias = "page-added")]
    fn connect_page_added<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn page_added_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            child: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-added\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_added_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-removed")]
    fn connect_page_removed<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn page_removed_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            child: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-removed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_removed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-reordered")]
    fn connect_page_reordered<F: Fn(&Self, &Widget, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn page_reordered_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            child: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-reordered\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_reordered_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reorder-tab")]
    fn connect_reorder_tab<F: Fn(&Self, DirectionType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn reorder_tab_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, DirectionType, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: ffi::GtkDirectionType,
            p0: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
                from_glib(p0),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"reorder-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    reorder_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_reorder_tab(&self, object: DirectionType, p0: bool) -> bool {
        self.emit_by_name("reorder-tab", &[&object, &p0])
    }

    #[doc(alias = "select-page")]
    fn connect_select_page<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_page_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_page(&self, object: bool) -> bool {
        self.emit_by_name("select-page", &[&object])
    }

    #[doc(alias = "switch-page")]
    fn connect_switch_page<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn switch_page_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            page: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(page),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"switch-page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    switch_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-popup")]
    fn connect_enable_popup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_popup_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-popup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_popup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "group-name")]
    fn connect_group_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_group_name_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::group-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_group_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page")]
    fn connect_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scrollable")]
    fn connect_scrollable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scrollable_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scrollable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scrollable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-border")]
    fn connect_show_border_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_border_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-border\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_border_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-tabs")]
    fn connect_show_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_tabs_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tab-pos")]
    fn connect_tab_pos_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tab_pos_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tab-pos\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tab_pos_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Notebook>> NotebookExt for O {}

impl fmt::Display for Notebook {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Notebook")
    }
}
