---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, numérotation
---

# Comment modifier la numérotation des pages ?

## Avec les commandes de base

Pour changer la valeur du `⟨numéro⟩` de page, il suffit d'utiliser la commande 
`\setcounter{page}{⟨numéro⟩}`. En effet, le numéro de page est contenu 
dans un compteur. Toutes les fonctions associées aux 
[compteurs](/2_programmation/syntaxe/compteurs/start) peuvent donc s'y appliquer.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\setcounter{page}{1}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

Des modifications un peu plus automatisées peuvent être obtenues en modifiant 
la définition de la commande qui affiche le compteur `page`, à savoir 
la commande `\thepage`. L'exemple suivant, de Piet van Oostrum, 
permet d'afficher un compteur comprenant, en plus du numéro de la page, 
le numéro du chapitre courant, et de remettre le compteur de pages à zéro 
à chaque nouveau chapitre :

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

  \makeatletter % 
  \renewcommand{\thepage}{\thechapter-\arabic{page}}
  \@addtoreset{page}{chapter}
  \makeatother

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

Sur le sujet de la rénumérotation des pages par chapitre, 
vous pouvez consulter la question "[](numeroter_les_pages_par_chapitre)" 
pour des exemples plus avancés.