/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.MinusExpression;
import rene.zirkel.expression.ProductExpression;

class QuotientExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public QuotientExpression(BasicExpression basicExpression, BasicExpression basicExpression2) {
        this.E1 = basicExpression;
        this.E2 = basicExpression2;
    }

    public static BasicExpression scan(ExpressionText expressionText, BasicExpression basicExpression) throws ConstructionException {
        BasicExpression basicExpression2 = MinusExpression.scan(expressionText);
        if (expressionText.next() == '/') {
            expressionText.advance();
            return QuotientExpression.scan(expressionText, new QuotientExpression(basicExpression, basicExpression2));
        }
        if (expressionText.next() == '*' && expressionText.nextnext() != '*') {
            expressionText.advance();
            return ProductExpression.scan(expressionText, new QuotientExpression(basicExpression, basicExpression2));
        }
        return new QuotientExpression(basicExpression, basicExpression2);
    }

    public double getValue() throws ConstructionException {
        return this.E1.getValue() / this.E2.getValue();
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "/" + this.E2;
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }
}

