/*
 * $Header: /home/harald/repos/remotetea.sf.net/remotetea/src/tests/org/acplt/oncrpc/EchoClientTest.java,v 1.1 2003/08/13 12:03:53 haraldalbrecht Exp $
 *
 * Copyright (c) 1999, 2000
 * Lehrstuhl fuer Prozessleittechnik (PLT), RWTH Aachen
 * D-52064 Aachen, Germany.
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program (see the file LICENSE.txt for more
 * details); if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package tests.org.acplt.oncrpc;

import java.net.InetAddress;

import org.acplt.oncrpc.OncRpcAuthStatus;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcClientAuthUnix;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrVoid;

public class EchoClientTest {

    public void testEchoCall() {
	if (this.initialize()) {
	    //
	    // Now check the echo RPC call...
	    //
	    String [] messages =
		{ "Open Source", "is not yet", "another buzzword." };
	    checkEcho(messages);

	    //
	    // Now test AUTH_UNIX authentication. First start with an
	    // invalid credential...
	    //
	    OncRpcClientAuth auth = new OncRpcClientAuthUnix(
		    "marvin", 0, 0, new int[0]);
	    this.client.setAuth(auth);
	    System.out.print("checking AUTH_UNIX with invalid credential: ");
	    try {
		client.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
	    } catch ( OncRpcAuthenticationException ae ) {
		if ( ae.getAuthStatus() != OncRpcAuthStatus.ONCRPC_AUTH_BADCRED ) {
		    System.out.println("received wrong authentication exception with status of "
			    + ae.getAuthStatus());
		    ae.printStackTrace(System.out);
		    System.exit(1);
		}
	    } catch ( OncRpcException e ) {
		System.out.println("method call failed unexpectedly:");
		e.printStackTrace(System.out);
		System.exit(1);
	    }
	    System.out.println("passed.");

	    auth = new OncRpcClientAuthUnix(
		    "marvin", 42, 815, new int[0]);
	    client.setAuth(auth);
	    messages = new String[]
		    { "AUTH_UNIX", "is like", "*NO* authentication",
			    "--", "it", "uses", "*NO CRYPTOGRAPHY*", "for securing",
		    "ONC/RPC messages" };
	    checkEcho(messages);

	    client.setAuth(null);
	}
	
	this.close();
    }
    
    private void checkEcho(String [] messages) {
        for ( int idx = 0; idx < messages.length; ++idx ) {
            XdrString params = new XdrString(messages[idx]);
            XdrString result = new XdrString();
            System.out.print("checking echo: ");
            try {
                this.client.call(1, params, result);
            } catch ( OncRpcException e ) {
                System.out.println("method call failed unexpectedly:");
                e.printStackTrace(System.out);
                System.exit(1);
            }
            if ( !params.stringValue().equals(result.stringValue()) ) {
                System.out.println("answer does not match call:");
                System.out.println("  expected: \"" + params.stringValue() + "\"");
                System.out.println("  but got:  \"" + result.stringValue() + "\"");
                System.exit(1);
            }
            System.out.println(result.stringValue());
        }
    }

    private boolean initialize() {	
	boolean initialized = false;
	
	/*
	 * Can the echo server be started?
	 */
	if (this.echoServer.start()) {
	    /*
	     * Can we create a client object?
	     */
	    try {
		System.out.print("Creating client for the test server: ");            
		this.client = new OncRpcTcpClient(InetAddress.getByName("localhost"),
			0x49679, 1, 0);
		System.out.println("done.");

		System.out.print("Pinging test server: ");
		client.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
		System.out.println("done.");


		initialized = true;
	    } catch ( Exception exception ) {

		System.out.format("failed (%s).%n", exception);
		
		if (this.client != null) {
		    try {
			System.out.print("Close the client: ");
			this.client.close();
			System.out.println("done.");
		    } catch (OncRpcException closeException) {
			System.out.format(" failed (%s).%n", closeException);
		    }
		    this.client = null;
		}
		
		initialized = false;
	    }
	}
	
	return initialized;
    }
    
    private void close() {
	if (this.client != null) {
	    try {
		this.client.close();
	    } catch (OncRpcException exception) {
		System.out.format("Failed to close client (%s).%n", exception);
	    }
	    
	    this.client = null;
	}
	
	this.echoServer.shutdown();
    }
	
    
    private final EchoServer echoServer = new EchoServer();
    private OncRpcClient client;
    
}

// End of EchoClientTest.java